# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AutoGroupingRuleRuleContent',
    'DeliveryChannelDeliveryChannelFilter',
    'DeliveryChannelResourceChangeDelivery',
    'DeliveryChannelResourceChangeDeliverySlsProperties',
    'DeliveryChannelResourceSnapshotDelivery',
    'DeliveryChannelResourceSnapshotDeliverySlsProperties',
    'MultiAccountDeliveryChannelDeliveryChannelFilter',
    'MultiAccountDeliveryChannelResourceChangeDelivery',
    'MultiAccountDeliveryChannelResourceChangeDeliverySlsProperties',
    'MultiAccountDeliveryChannelResourceSnapshotDelivery',
    'MultiAccountDeliveryChannelResourceSnapshotDeliverySlsProperties',
    'ResourceGroupRegionStatus',
    'ResourceShareResource',
    'GetAccountDeletionCheckTaskAbandonAbleCheckResult',
    'GetAccountDeletionCheckTaskNotAllowReasonResult',
    'GetAccountsAccountResult',
    'GetControlPoliciesPolicyResult',
    'GetControlPolicyAttachmentsAttachmentResult',
    'GetDelegatedAdministratorsAdministratorResult',
    'GetFoldersFolderResult',
    'GetHandshakesHandshakeResult',
    'GetPoliciesPolicyResult',
    'GetPolicyAttachmentsAttachmentResult',
    'GetPolicyVersionsVersionResult',
    'GetResourceDirectoriesDirectoryResult',
    'GetResourceGroupsGroupResult',
    'GetResourceGroupsGroupRegionStatusResult',
    'GetResourceSharesShareResult',
    'GetRolesRoleResult',
    'GetSharedResourcesResourceResult',
    'GetSharedTargetsTargetResult',
]

@pulumi.output_type
class AutoGroupingRuleRuleContent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetResourceGroupCondition":
            suggest = "target_resource_group_condition"
        elif key == "autoGroupingScopeCondition":
            suggest = "auto_grouping_scope_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoGroupingRuleRuleContent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoGroupingRuleRuleContent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoGroupingRuleRuleContent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_resource_group_condition: _builtins.str,
                 auto_grouping_scope_condition: Optional[_builtins.str] = None):
        """
        :param _builtins.str target_resource_group_condition: The condition for the destination resource group.
        :param _builtins.str auto_grouping_scope_condition: The condition for the range of resources to be automatically transferred.
        """
        pulumi.set(__self__, "target_resource_group_condition", target_resource_group_condition)
        if auto_grouping_scope_condition is not None:
            pulumi.set(__self__, "auto_grouping_scope_condition", auto_grouping_scope_condition)

    @_builtins.property
    @pulumi.getter(name="targetResourceGroupCondition")
    def target_resource_group_condition(self) -> _builtins.str:
        """
        The condition for the destination resource group.
        """
        return pulumi.get(self, "target_resource_group_condition")

    @_builtins.property
    @pulumi.getter(name="autoGroupingScopeCondition")
    def auto_grouping_scope_condition(self) -> Optional[_builtins.str]:
        """
        The condition for the range of resources to be automatically transferred.
        """
        return pulumi.get(self, "auto_grouping_scope_condition")


@pulumi.output_type
class DeliveryChannelDeliveryChannelFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceTypes":
            suggest = "resource_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryChannelDeliveryChannelFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryChannelDeliveryChannelFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryChannelDeliveryChannelFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_types: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] resource_types: An array of effective resource types for the delivery channel.
               - Example: ["ACS::VPC::VPC", "ACS::ECS::Instance"].
               - If you want to deliver items of all resource types supported by Resource Center, set this parameter to ["ALL"].
        """
        if resource_types is not None:
            pulumi.set(__self__, "resource_types", resource_types)

    @_builtins.property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        An array of effective resource types for the delivery channel.
        - Example: ["ACS::VPC::VPC", "ACS::ECS::Instance"].
        - If you want to deliver items of all resource types supported by Resource Center, set this parameter to ["ALL"].
        """
        return pulumi.get(self, "resource_types")


@pulumi.output_type
class DeliveryChannelResourceChangeDelivery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "slsProperties":
            suggest = "sls_properties"
        elif key == "targetArn":
            suggest = "target_arn"
        elif key == "targetType":
            suggest = "target_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryChannelResourceChangeDelivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryChannelResourceChangeDelivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryChannelResourceChangeDelivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 sls_properties: Optional['outputs.DeliveryChannelResourceChangeDeliverySlsProperties'] = None,
                 target_arn: Optional[_builtins.str] = None,
                 target_type: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Specifies whether to enable delivery of resource configuration change events. Valid values:
               - true
               - false
        :param 'DeliveryChannelResourceChangeDeliverySlsPropertiesArgs' sls_properties: The Simple Log Service configurations. See `sls_properties` below.
        :param _builtins.str target_arn: The ARN of the delivery destination.
               - If you set TargetType to`OSS`, you must set TargetArn to the ARN of a bucket whose name is prefixed with `resourcecenter-`.
               - If you set TargetType to`SLS`, you must set TargetArn to the ARN of a Logstore whose name is prefixed with `resourcecenter-`.
        :param _builtins.str target_type: The type of the delivery destination.
               
               Valid values:
               - SLS
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if sls_properties is not None:
            pulumi.set(__self__, "sls_properties", sls_properties)
        if target_arn is not None:
            pulumi.set(__self__, "target_arn", target_arn)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable delivery of resource configuration change events. Valid values:
        - true
        - false
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="slsProperties")
    def sls_properties(self) -> Optional['outputs.DeliveryChannelResourceChangeDeliverySlsProperties']:
        """
        The Simple Log Service configurations. See `sls_properties` below.
        """
        return pulumi.get(self, "sls_properties")

    @_builtins.property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> Optional[_builtins.str]:
        """
        The ARN of the delivery destination.
        - If you set TargetType to`OSS`, you must set TargetArn to the ARN of a bucket whose name is prefixed with `resourcecenter-`.
        - If you set TargetType to`SLS`, you must set TargetArn to the ARN of a Logstore whose name is prefixed with `resourcecenter-`.
        """
        return pulumi.get(self, "target_arn")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[_builtins.str]:
        """
        The type of the delivery destination.

        Valid values:
        - SLS
        """
        return pulumi.get(self, "target_type")


@pulumi.output_type
class DeliveryChannelResourceChangeDeliverySlsProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oversizedDataOssTargetArn":
            suggest = "oversized_data_oss_target_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryChannelResourceChangeDeliverySlsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryChannelResourceChangeDeliverySlsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryChannelResourceChangeDeliverySlsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oversized_data_oss_target_arn: Optional[_builtins.str] = None):
        if oversized_data_oss_target_arn is not None:
            pulumi.set(__self__, "oversized_data_oss_target_arn", oversized_data_oss_target_arn)

    @_builtins.property
    @pulumi.getter(name="oversizedDataOssTargetArn")
    def oversized_data_oss_target_arn(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "oversized_data_oss_target_arn")


@pulumi.output_type
class DeliveryChannelResourceSnapshotDelivery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customExpression":
            suggest = "custom_expression"
        elif key == "deliveryTime":
            suggest = "delivery_time"
        elif key == "slsProperties":
            suggest = "sls_properties"
        elif key == "targetArn":
            suggest = "target_arn"
        elif key == "targetType":
            suggest = "target_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryChannelResourceSnapshotDelivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryChannelResourceSnapshotDelivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryChannelResourceSnapshotDelivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_expression: Optional[_builtins.str] = None,
                 delivery_time: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None,
                 sls_properties: Optional['outputs.DeliveryChannelResourceSnapshotDeliverySlsProperties'] = None,
                 target_arn: Optional[_builtins.str] = None,
                 target_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str custom_expression: The custom expression.
        :param _builtins.str delivery_time: The delivery time.
        :param _builtins.bool enabled: Specifies whether to enable delivery of scheduled resource snapshots. Valid values:
               - true
               - false
        :param 'DeliveryChannelResourceSnapshotDeliverySlsPropertiesArgs' sls_properties: The Simple Log Service configurations. See `sls_properties` below.
        :param _builtins.str target_arn: The Alibaba Cloud Resource Name (ARN) of the delivery destination.
               - If you set TargetType to`OSS`, you must set TargetArn to the ARN of a bucket whose name is prefixed with `resourcecenter-`.
               - If you set TargetType to `SLS`, you must set TargetArn to the ARN of a Logstore whose name is prefixed with `resourcecenter-`.
        :param _builtins.str target_type: The type of the delivery destination.
               
               Valid values:
               - `OSS` for standard delivery
               - `OSS` or `SLS` for custom delivery
        """
        if custom_expression is not None:
            pulumi.set(__self__, "custom_expression", custom_expression)
        if delivery_time is not None:
            pulumi.set(__self__, "delivery_time", delivery_time)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if sls_properties is not None:
            pulumi.set(__self__, "sls_properties", sls_properties)
        if target_arn is not None:
            pulumi.set(__self__, "target_arn", target_arn)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)

    @_builtins.property
    @pulumi.getter(name="customExpression")
    def custom_expression(self) -> Optional[_builtins.str]:
        """
        The custom expression.
        """
        return pulumi.get(self, "custom_expression")

    @_builtins.property
    @pulumi.getter(name="deliveryTime")
    def delivery_time(self) -> Optional[_builtins.str]:
        """
        The delivery time.
        """
        return pulumi.get(self, "delivery_time")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable delivery of scheduled resource snapshots. Valid values:
        - true
        - false
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="slsProperties")
    def sls_properties(self) -> Optional['outputs.DeliveryChannelResourceSnapshotDeliverySlsProperties']:
        """
        The Simple Log Service configurations. See `sls_properties` below.
        """
        return pulumi.get(self, "sls_properties")

    @_builtins.property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> Optional[_builtins.str]:
        """
        The Alibaba Cloud Resource Name (ARN) of the delivery destination.
        - If you set TargetType to`OSS`, you must set TargetArn to the ARN of a bucket whose name is prefixed with `resourcecenter-`.
        - If you set TargetType to `SLS`, you must set TargetArn to the ARN of a Logstore whose name is prefixed with `resourcecenter-`.
        """
        return pulumi.get(self, "target_arn")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[_builtins.str]:
        """
        The type of the delivery destination.

        Valid values:
        - `OSS` for standard delivery
        - `OSS` or `SLS` for custom delivery
        """
        return pulumi.get(self, "target_type")


@pulumi.output_type
class DeliveryChannelResourceSnapshotDeliverySlsProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oversizedDataOssTargetArn":
            suggest = "oversized_data_oss_target_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryChannelResourceSnapshotDeliverySlsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryChannelResourceSnapshotDeliverySlsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryChannelResourceSnapshotDeliverySlsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oversized_data_oss_target_arn: Optional[_builtins.str] = None):
        if oversized_data_oss_target_arn is not None:
            pulumi.set(__self__, "oversized_data_oss_target_arn", oversized_data_oss_target_arn)

    @_builtins.property
    @pulumi.getter(name="oversizedDataOssTargetArn")
    def oversized_data_oss_target_arn(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "oversized_data_oss_target_arn")


@pulumi.output_type
class MultiAccountDeliveryChannelDeliveryChannelFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountScopes":
            suggest = "account_scopes"
        elif key == "resourceTypes":
            suggest = "resource_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiAccountDeliveryChannelDeliveryChannelFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiAccountDeliveryChannelDeliveryChannelFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiAccountDeliveryChannelDeliveryChannelFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_scopes: Sequence[_builtins.str],
                 resource_types: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] account_scopes: The account scopes of the delivery channel.
        :param Sequence[_builtins.str] resource_types: An array of effective resource types for the delivery channel.
               - Example: ["ACS::VPC::VPC", "ACS::ECS::Instance"].
               - If you want to deliver items of all resource types supported by Resource Center, set this parameter to ["ALL"].
        """
        pulumi.set(__self__, "account_scopes", account_scopes)
        if resource_types is not None:
            pulumi.set(__self__, "resource_types", resource_types)

    @_builtins.property
    @pulumi.getter(name="accountScopes")
    def account_scopes(self) -> Sequence[_builtins.str]:
        """
        The account scopes of the delivery channel.
        """
        return pulumi.get(self, "account_scopes")

    @_builtins.property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        An array of effective resource types for the delivery channel.
        - Example: ["ACS::VPC::VPC", "ACS::ECS::Instance"].
        - If you want to deliver items of all resource types supported by Resource Center, set this parameter to ["ALL"].
        """
        return pulumi.get(self, "resource_types")


@pulumi.output_type
class MultiAccountDeliveryChannelResourceChangeDelivery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "slsProperties":
            suggest = "sls_properties"
        elif key == "targetArn":
            suggest = "target_arn"
        elif key == "targetType":
            suggest = "target_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiAccountDeliveryChannelResourceChangeDelivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiAccountDeliveryChannelResourceChangeDelivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiAccountDeliveryChannelResourceChangeDelivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 sls_properties: Optional['outputs.MultiAccountDeliveryChannelResourceChangeDeliverySlsProperties'] = None,
                 target_arn: Optional[_builtins.str] = None,
                 target_type: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Specifies whether to enable delivery of resource configuration change events. Valid values:
               - true
               - false
        :param 'MultiAccountDeliveryChannelResourceChangeDeliverySlsPropertiesArgs' sls_properties: The Simple Log Service configurations. See `sls_properties` below.
        :param _builtins.str target_arn: The ARN of the delivery destination.
               - If you set TargetType to`OSS`, you must set TargetArn to the ARN of a bucket whose name is prefixed with `resourcecenter-`.
               - If you set TargetType to`SLS`, you must set TargetArn to the ARN of a Logstore whose name is prefixed with `resourcecenter-`.
        :param _builtins.str target_type: The type of the delivery destination.
               
               Valid values:
               - SLS
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if sls_properties is not None:
            pulumi.set(__self__, "sls_properties", sls_properties)
        if target_arn is not None:
            pulumi.set(__self__, "target_arn", target_arn)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable delivery of resource configuration change events. Valid values:
        - true
        - false
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="slsProperties")
    def sls_properties(self) -> Optional['outputs.MultiAccountDeliveryChannelResourceChangeDeliverySlsProperties']:
        """
        The Simple Log Service configurations. See `sls_properties` below.
        """
        return pulumi.get(self, "sls_properties")

    @_builtins.property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> Optional[_builtins.str]:
        """
        The ARN of the delivery destination.
        - If you set TargetType to`OSS`, you must set TargetArn to the ARN of a bucket whose name is prefixed with `resourcecenter-`.
        - If you set TargetType to`SLS`, you must set TargetArn to the ARN of a Logstore whose name is prefixed with `resourcecenter-`.
        """
        return pulumi.get(self, "target_arn")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[_builtins.str]:
        """
        The type of the delivery destination.

        Valid values:
        - SLS
        """
        return pulumi.get(self, "target_type")


@pulumi.output_type
class MultiAccountDeliveryChannelResourceChangeDeliverySlsProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oversizedDataOssTargetArn":
            suggest = "oversized_data_oss_target_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiAccountDeliveryChannelResourceChangeDeliverySlsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiAccountDeliveryChannelResourceChangeDeliverySlsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiAccountDeliveryChannelResourceChangeDeliverySlsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oversized_data_oss_target_arn: Optional[_builtins.str] = None):
        if oversized_data_oss_target_arn is not None:
            pulumi.set(__self__, "oversized_data_oss_target_arn", oversized_data_oss_target_arn)

    @_builtins.property
    @pulumi.getter(name="oversizedDataOssTargetArn")
    def oversized_data_oss_target_arn(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "oversized_data_oss_target_arn")


@pulumi.output_type
class MultiAccountDeliveryChannelResourceSnapshotDelivery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customExpression":
            suggest = "custom_expression"
        elif key == "deliveryTime":
            suggest = "delivery_time"
        elif key == "slsProperties":
            suggest = "sls_properties"
        elif key == "targetArn":
            suggest = "target_arn"
        elif key == "targetType":
            suggest = "target_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiAccountDeliveryChannelResourceSnapshotDelivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiAccountDeliveryChannelResourceSnapshotDelivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiAccountDeliveryChannelResourceSnapshotDelivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_expression: Optional[_builtins.str] = None,
                 delivery_time: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None,
                 sls_properties: Optional['outputs.MultiAccountDeliveryChannelResourceSnapshotDeliverySlsProperties'] = None,
                 target_arn: Optional[_builtins.str] = None,
                 target_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str custom_expression: The custom expression.
        :param _builtins.str delivery_time: The delivery time.
        :param _builtins.bool enabled: Specifies whether to enable delivery of scheduled resource snapshots. Valid values:
               - true
               - false
        :param 'MultiAccountDeliveryChannelResourceSnapshotDeliverySlsPropertiesArgs' sls_properties: The Simple Log Service configurations. See `sls_properties` below.
        :param _builtins.str target_arn: The Alibaba Cloud Resource Name (ARN) of the delivery destination.
               - If you set TargetType to`OSS`, you must set TargetArn to the ARN of a bucket whose name is prefixed with `resourcecenter-`.
               - If you set TargetType to `SLS`, you must set TargetArn to the ARN of a Logstore whose name is prefixed with `resourcecenter-`.
        :param _builtins.str target_type: The type of the delivery destination.
               
               Valid values:
               - `OSS` for standard delivery
               - `OSS` or `SLS` for custom delivery
        """
        if custom_expression is not None:
            pulumi.set(__self__, "custom_expression", custom_expression)
        if delivery_time is not None:
            pulumi.set(__self__, "delivery_time", delivery_time)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if sls_properties is not None:
            pulumi.set(__self__, "sls_properties", sls_properties)
        if target_arn is not None:
            pulumi.set(__self__, "target_arn", target_arn)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)

    @_builtins.property
    @pulumi.getter(name="customExpression")
    def custom_expression(self) -> Optional[_builtins.str]:
        """
        The custom expression.
        """
        return pulumi.get(self, "custom_expression")

    @_builtins.property
    @pulumi.getter(name="deliveryTime")
    def delivery_time(self) -> Optional[_builtins.str]:
        """
        The delivery time.
        """
        return pulumi.get(self, "delivery_time")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable delivery of scheduled resource snapshots. Valid values:
        - true
        - false
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="slsProperties")
    def sls_properties(self) -> Optional['outputs.MultiAccountDeliveryChannelResourceSnapshotDeliverySlsProperties']:
        """
        The Simple Log Service configurations. See `sls_properties` below.
        """
        return pulumi.get(self, "sls_properties")

    @_builtins.property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> Optional[_builtins.str]:
        """
        The Alibaba Cloud Resource Name (ARN) of the delivery destination.
        - If you set TargetType to`OSS`, you must set TargetArn to the ARN of a bucket whose name is prefixed with `resourcecenter-`.
        - If you set TargetType to `SLS`, you must set TargetArn to the ARN of a Logstore whose name is prefixed with `resourcecenter-`.
        """
        return pulumi.get(self, "target_arn")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[_builtins.str]:
        """
        The type of the delivery destination.

        Valid values:
        - `OSS` for standard delivery
        - `OSS` or `SLS` for custom delivery
        """
        return pulumi.get(self, "target_type")


@pulumi.output_type
class MultiAccountDeliveryChannelResourceSnapshotDeliverySlsProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oversizedDataOssTargetArn":
            suggest = "oversized_data_oss_target_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiAccountDeliveryChannelResourceSnapshotDeliverySlsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiAccountDeliveryChannelResourceSnapshotDeliverySlsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiAccountDeliveryChannelResourceSnapshotDeliverySlsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oversized_data_oss_target_arn: Optional[_builtins.str] = None):
        if oversized_data_oss_target_arn is not None:
            pulumi.set(__self__, "oversized_data_oss_target_arn", oversized_data_oss_target_arn)

    @_builtins.property
    @pulumi.getter(name="oversizedDataOssTargetArn")
    def oversized_data_oss_target_arn(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "oversized_data_oss_target_arn")


@pulumi.output_type
class ResourceGroupRegionStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionId":
            suggest = "region_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceGroupRegionStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceGroupRegionStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceGroupRegionStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region_id: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str region_id: The status of the region.
        :param _builtins.str status: The status of the resource group.
        """
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[_builtins.str]:
        """
        The status of the region.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the resource group.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ResourceShareResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceShareResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceShareResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceShareResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: Optional[_builtins.str] = None,
                 resource_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str resource_id: The ID of the shared resource.
        :param _builtins.str resource_type: Shared resource type. For the types of resources that support sharing, see [Cloud services that support sharing](https://www.alibabacloud.com/help/en/resource-management/resource-sharing/product-overview/services-that-work-with-resource-sharing).
        """
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[_builtins.str]:
        """
        The ID of the shared resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        Shared resource type. For the types of resources that support sharing, see [Cloud services that support sharing](https://www.alibabacloud.com/help/en/resource-management/resource-sharing/product-overview/services-that-work-with-resource-sharing).
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class GetAccountDeletionCheckTaskAbandonAbleCheckResult(dict):
    def __init__(__self__, *,
                 check_id: _builtins.str,
                 check_name: _builtins.str,
                 description: _builtins.str):
        """
        :param _builtins.str check_id: The ID of the check item.
        :param _builtins.str check_name: The name of the cloud service to which the check item belongs.
        :param _builtins.str description: The description of the check item.
        """
        pulumi.set(__self__, "check_id", check_id)
        pulumi.set(__self__, "check_name", check_name)
        pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="checkId")
    def check_id(self) -> _builtins.str:
        """
        The ID of the check item.
        """
        return pulumi.get(self, "check_id")

    @_builtins.property
    @pulumi.getter(name="checkName")
    def check_name(self) -> _builtins.str:
        """
        The name of the cloud service to which the check item belongs.
        """
        return pulumi.get(self, "check_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the check item.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GetAccountDeletionCheckTaskNotAllowReasonResult(dict):
    def __init__(__self__, *,
                 check_id: _builtins.str,
                 check_name: _builtins.str,
                 description: _builtins.str):
        """
        :param _builtins.str check_id: The ID of the check item.
        :param _builtins.str check_name: The name of the cloud service to which the check item belongs.
        :param _builtins.str description: The description of the check item.
        """
        pulumi.set(__self__, "check_id", check_id)
        pulumi.set(__self__, "check_name", check_name)
        pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="checkId")
    def check_id(self) -> _builtins.str:
        """
        The ID of the check item.
        """
        return pulumi.get(self, "check_id")

    @_builtins.property
    @pulumi.getter(name="checkName")
    def check_name(self) -> _builtins.str:
        """
        The name of the cloud service to which the check item belongs.
        """
        return pulumi.get(self, "check_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the check item.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GetAccountsAccountResult(dict):
    def __init__(__self__, *,
                 account_id: _builtins.str,
                 account_name: _builtins.str,
                 display_name: _builtins.str,
                 folder_id: _builtins.str,
                 id: _builtins.str,
                 join_method: _builtins.str,
                 join_time: _builtins.str,
                 modify_time: _builtins.str,
                 payer_account_id: _builtins.str,
                 resource_directory_id: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 type: _builtins.str):
        """
        :param _builtins.str account_id: The Alibaba Cloud account ID of the member.
        :param _builtins.str account_name: (Available since v1.125.0) The Alibaba Cloud account name of the member. **Note:** `account_name` takes effect only if `enable_details` is set to `true`.
        :param _builtins.str display_name: The display name of the member.
        :param _builtins.str folder_id: The ID of the folder.
        :param _builtins.str id: The ID of the Account.
        :param _builtins.str join_method: The way in which the member joins the resource directory.
        :param _builtins.str join_time: The time when the member joined the resource directory.
        :param _builtins.str modify_time: The time when the member was modified.
        :param _builtins.str payer_account_id: (Available since v1.124.3) The ID of the settlement account. **Note:** `payer_account_id` takes effect only if `enable_details` is set to `true`.
        :param _builtins.str resource_directory_id: The ID of the resource directory.
        :param _builtins.str status: The status of account. Valid values: `CreateCancelled`, `CreateExpired`, `CreateFailed`, `CreateSuccess`, `CreateVerifying`, `InviteSuccess`, `PromoteCancelled`, `PromoteExpired`, `PromoteFailed`, `PromoteSuccess`, `PromoteVerifying`.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        :param _builtins.str type: The type of the member.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "folder_id", folder_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "join_method", join_method)
        pulumi.set(__self__, "join_time", join_time)
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "payer_account_id", payer_account_id)
        pulumi.set(__self__, "resource_directory_id", resource_directory_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The Alibaba Cloud account ID of the member.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        """
        (Available since v1.125.0) The Alibaba Cloud account name of the member. **Note:** `account_name` takes effect only if `enable_details` is set to `true`.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the member.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The ID of the folder.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Account.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="joinMethod")
    def join_method(self) -> _builtins.str:
        """
        The way in which the member joins the resource directory.
        """
        return pulumi.get(self, "join_method")

    @_builtins.property
    @pulumi.getter(name="joinTime")
    def join_time(self) -> _builtins.str:
        """
        The time when the member joined the resource directory.
        """
        return pulumi.get(self, "join_time")

    @_builtins.property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> _builtins.str:
        """
        The time when the member was modified.
        """
        return pulumi.get(self, "modify_time")

    @_builtins.property
    @pulumi.getter(name="payerAccountId")
    def payer_account_id(self) -> _builtins.str:
        """
        (Available since v1.124.3) The ID of the settlement account. **Note:** `payer_account_id` takes effect only if `enable_details` is set to `true`.
        """
        return pulumi.get(self, "payer_account_id")

    @_builtins.property
    @pulumi.getter(name="resourceDirectoryId")
    def resource_directory_id(self) -> _builtins.str:
        """
        The ID of the resource directory.
        """
        return pulumi.get(self, "resource_directory_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of account. Valid values: `CreateCancelled`, `CreateExpired`, `CreateFailed`, `CreateSuccess`, `CreateVerifying`, `InviteSuccess`, `PromoteCancelled`, `PromoteExpired`, `PromoteFailed`, `PromoteSuccess`, `PromoteVerifying`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the member.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetControlPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 attachment_count: _builtins.int,
                 control_policy_name: _builtins.str,
                 description: _builtins.str,
                 effect_scope: _builtins.str,
                 id: _builtins.str,
                 policy_document: _builtins.str,
                 policy_id: _builtins.str,
                 policy_type: _builtins.str):
        """
        :param _builtins.int attachment_count: The count of policy attachment.
        :param _builtins.str control_policy_name: The name of policy.
        :param _builtins.str description: The description of policy.
        :param _builtins.str effect_scope: The effect scope.
        :param _builtins.str id: The ID of the Control Policy.
        :param _builtins.str policy_document: The policy document.
        :param _builtins.str policy_id: The ID of policy.
        :param _builtins.str policy_type: The type of policy.
        """
        pulumi.set(__self__, "attachment_count", attachment_count)
        pulumi.set(__self__, "control_policy_name", control_policy_name)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "effect_scope", effect_scope)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "policy_type", policy_type)

    @_builtins.property
    @pulumi.getter(name="attachmentCount")
    def attachment_count(self) -> _builtins.int:
        """
        The count of policy attachment.
        """
        return pulumi.get(self, "attachment_count")

    @_builtins.property
    @pulumi.getter(name="controlPolicyName")
    def control_policy_name(self) -> _builtins.str:
        """
        The name of policy.
        """
        return pulumi.get(self, "control_policy_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectScope")
    def effect_scope(self) -> _builtins.str:
        """
        The effect scope.
        """
        return pulumi.get(self, "effect_scope")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Control Policy.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> _builtins.str:
        """
        The policy document.
        """
        return pulumi.get(self, "policy_document")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> _builtins.str:
        """
        The ID of policy.
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> _builtins.str:
        """
        The type of policy.
        """
        return pulumi.get(self, "policy_type")


@pulumi.output_type
class GetControlPolicyAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 attach_date: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 policy_id: _builtins.str,
                 policy_name: _builtins.str,
                 policy_type: _builtins.str):
        """
        :param _builtins.str attach_date: The attach date.
        :param _builtins.str description: The description of policy.
        :param _builtins.str id: The ID of the Control Policy Attachment.
        :param _builtins.str policy_id: The ID of policy.
        :param _builtins.str policy_name: The name of policy.
        :param _builtins.str policy_type: The type of policy.
        """
        pulumi.set(__self__, "attach_date", attach_date)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "policy_type", policy_type)

    @_builtins.property
    @pulumi.getter(name="attachDate")
    def attach_date(self) -> _builtins.str:
        """
        The attach date.
        """
        return pulumi.get(self, "attach_date")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Control Policy Attachment.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> _builtins.str:
        """
        The ID of policy.
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> _builtins.str:
        """
        The name of policy.
        """
        return pulumi.get(self, "policy_name")

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> _builtins.str:
        """
        The type of policy.
        """
        return pulumi.get(self, "policy_type")


@pulumi.output_type
class GetDelegatedAdministratorsAdministratorResult(dict):
    def __init__(__self__, *,
                 account_id: _builtins.str,
                 delegation_enabled_time: _builtins.str,
                 id: _builtins.str,
                 service_principal: _builtins.str):
        """
        :param _builtins.str account_id: The ID of the member account.
        :param _builtins.str delegation_enabled_time: The time when the member was specified as a delegated administrator account.
        :param _builtins.str id: The ID of the Delegated Administrator.
        :param _builtins.str service_principal: The identity of the trusted service.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "delegation_enabled_time", delegation_enabled_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "service_principal", service_principal)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The ID of the member account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="delegationEnabledTime")
    def delegation_enabled_time(self) -> _builtins.str:
        """
        The time when the member was specified as a delegated administrator account.
        """
        return pulumi.get(self, "delegation_enabled_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Delegated Administrator.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="servicePrincipal")
    def service_principal(self) -> _builtins.str:
        """
        The identity of the trusted service.
        """
        return pulumi.get(self, "service_principal")


@pulumi.output_type
class GetFoldersFolderResult(dict):
    def __init__(__self__, *,
                 folder_id: _builtins.str,
                 folder_name: _builtins.str,
                 id: _builtins.str,
                 parent_folder_id: _builtins.str):
        """
        :param _builtins.str folder_id: The ID of the Folder.
        :param _builtins.str folder_name: The Name of the Folder.
        :param _builtins.str id: The ID of the Resource Manager Folder.
        :param _builtins.str parent_folder_id: The ID of the parent folder. **NOTE:** If `parent_folder_id` is not set, the information of the first-level subfolders of the Root folder is queried.
        """
        pulumi.set(__self__, "folder_id", folder_id)
        pulumi.set(__self__, "folder_name", folder_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "parent_folder_id", parent_folder_id)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The ID of the Folder.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="folderName")
    def folder_name(self) -> _builtins.str:
        """
        The Name of the Folder.
        """
        return pulumi.get(self, "folder_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Resource Manager Folder.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="parentFolderId")
    def parent_folder_id(self) -> _builtins.str:
        """
        The ID of the parent folder. **NOTE:** If `parent_folder_id` is not set, the information of the first-level subfolders of the Root folder is queried.
        """
        return pulumi.get(self, "parent_folder_id")


@pulumi.output_type
class GetHandshakesHandshakeResult(dict):
    def __init__(__self__, *,
                 expire_time: _builtins.str,
                 handshake_id: _builtins.str,
                 id: _builtins.str,
                 invited_account_real_name: _builtins.str,
                 master_account_id: _builtins.str,
                 master_account_name: _builtins.str,
                 master_account_real_name: _builtins.str,
                 modify_time: _builtins.str,
                 note: _builtins.str,
                 resource_directory_id: _builtins.str,
                 status: _builtins.str,
                 target_entity: _builtins.str,
                 target_type: _builtins.str):
        """
        :param _builtins.str expire_time: The time when the invitation expires.
        :param _builtins.str handshake_id: The ID of the invitation.
        :param _builtins.str id: The ID of the resource.
        :param _builtins.str invited_account_real_name: (Available in v1.114.0+) The real name of the invited account.
        :param _builtins.str master_account_id: The ID of the master account of the resource directory.
        :param _builtins.str master_account_name: The name of the master account of the resource directory.
        :param _builtins.str master_account_real_name: (Available in v1.114.0+) The real name of the master account of the resource directory.
        :param _builtins.str modify_time: The time when the invitation was modified.
        :param _builtins.str note: The invitation note.
        :param _builtins.str resource_directory_id: The ID of the resource directory.
        :param _builtins.str status: The status of handshake, valid values: `Accepted`, `Cancelled`, `Declined`, `Deleted`, `Expired` and `Pending`.
        :param _builtins.str target_entity: The ID or logon email address of the invited account.
        :param _builtins.str target_type: The type of the invited account.
        """
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "handshake_id", handshake_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "invited_account_real_name", invited_account_real_name)
        pulumi.set(__self__, "master_account_id", master_account_id)
        pulumi.set(__self__, "master_account_name", master_account_name)
        pulumi.set(__self__, "master_account_real_name", master_account_real_name)
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "note", note)
        pulumi.set(__self__, "resource_directory_id", resource_directory_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "target_entity", target_entity)
        pulumi.set(__self__, "target_type", target_type)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        """
        The time when the invitation expires.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter(name="handshakeId")
    def handshake_id(self) -> _builtins.str:
        """
        The ID of the invitation.
        """
        return pulumi.get(self, "handshake_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="invitedAccountRealName")
    def invited_account_real_name(self) -> _builtins.str:
        """
        (Available in v1.114.0+) The real name of the invited account.
        """
        return pulumi.get(self, "invited_account_real_name")

    @_builtins.property
    @pulumi.getter(name="masterAccountId")
    def master_account_id(self) -> _builtins.str:
        """
        The ID of the master account of the resource directory.
        """
        return pulumi.get(self, "master_account_id")

    @_builtins.property
    @pulumi.getter(name="masterAccountName")
    def master_account_name(self) -> _builtins.str:
        """
        The name of the master account of the resource directory.
        """
        return pulumi.get(self, "master_account_name")

    @_builtins.property
    @pulumi.getter(name="masterAccountRealName")
    def master_account_real_name(self) -> _builtins.str:
        """
        (Available in v1.114.0+) The real name of the master account of the resource directory.
        """
        return pulumi.get(self, "master_account_real_name")

    @_builtins.property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> _builtins.str:
        """
        The time when the invitation was modified.
        """
        return pulumi.get(self, "modify_time")

    @_builtins.property
    @pulumi.getter
    def note(self) -> _builtins.str:
        """
        The invitation note.
        """
        return pulumi.get(self, "note")

    @_builtins.property
    @pulumi.getter(name="resourceDirectoryId")
    def resource_directory_id(self) -> _builtins.str:
        """
        The ID of the resource directory.
        """
        return pulumi.get(self, "resource_directory_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of handshake, valid values: `Accepted`, `Cancelled`, `Declined`, `Deleted`, `Expired` and `Pending`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="targetEntity")
    def target_entity(self) -> _builtins.str:
        """
        The ID or logon email address of the invited account.
        """
        return pulumi.get(self, "target_entity")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> _builtins.str:
        """
        The type of the invited account.
        """
        return pulumi.get(self, "target_type")


@pulumi.output_type
class GetPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 attachment_count: _builtins.int,
                 default_version: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 policy_name: _builtins.str,
                 policy_type: _builtins.str,
                 update_date: _builtins.str):
        """
        :param _builtins.int attachment_count: The number of times the policy is referenced.
        :param _builtins.str default_version: The default version of the policy.
        :param _builtins.str description: The description of the policy.
        :param _builtins.str id: The ID of the policy.
        :param _builtins.str policy_name: The name of the policy.
        :param _builtins.str policy_type: The type of the policy. If you do not specify this parameter, the system lists all types of policies. Valid values: `Custom` and `System`.
        :param _builtins.str update_date: The time when the policy was updated.
        """
        pulumi.set(__self__, "attachment_count", attachment_count)
        pulumi.set(__self__, "default_version", default_version)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "policy_type", policy_type)
        pulumi.set(__self__, "update_date", update_date)

    @_builtins.property
    @pulumi.getter(name="attachmentCount")
    def attachment_count(self) -> _builtins.int:
        """
        The number of times the policy is referenced.
        """
        return pulumi.get(self, "attachment_count")

    @_builtins.property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> _builtins.str:
        """
        The default version of the policy.
        """
        return pulumi.get(self, "default_version")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the policy.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> _builtins.str:
        """
        The name of the policy.
        """
        return pulumi.get(self, "policy_name")

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> _builtins.str:
        """
        The type of the policy. If you do not specify this parameter, the system lists all types of policies. Valid values: `Custom` and `System`.
        """
        return pulumi.get(self, "policy_type")

    @_builtins.property
    @pulumi.getter(name="updateDate")
    def update_date(self) -> _builtins.str:
        """
        The time when the policy was updated.
        """
        return pulumi.get(self, "update_date")


@pulumi.output_type
class GetPolicyAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 attach_date: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 policy_name: _builtins.str,
                 policy_type: _builtins.str,
                 principal_name: _builtins.str,
                 principal_type: _builtins.str,
                 resource_group_id: _builtins.str):
        """
        :param _builtins.str attach_date: The time when the policy was attached.
        :param _builtins.str description: The description of the policy.
        :param _builtins.str id: The ID of the Resource Manager Policy Attachment.
        :param _builtins.str policy_name: The name of the policy. The name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
        :param _builtins.str policy_type: The type of the policy. Valid values: `Custom` and `System`.
        :param _builtins.str principal_name: The name of the object to which the policy is attached.
        :param _builtins.str principal_type: The type of the object to which the policy is attached. If you do not specify this parameter, the system lists all types of objects. Valid values: `IMSUser`: RAM user, `IMSGroup`: RAM user group, `ServiceRole`: RAM role.
        :param _builtins.str resource_group_id: The ID of the resource group or the ID of the Alibaba Cloud account to which the resource group belongs. If you do not specify this parameter, the system lists all policy attachment records under the current account.
        """
        pulumi.set(__self__, "attach_date", attach_date)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "policy_type", policy_type)
        pulumi.set(__self__, "principal_name", principal_name)
        pulumi.set(__self__, "principal_type", principal_type)
        pulumi.set(__self__, "resource_group_id", resource_group_id)

    @_builtins.property
    @pulumi.getter(name="attachDate")
    def attach_date(self) -> _builtins.str:
        """
        The time when the policy was attached.
        """
        return pulumi.get(self, "attach_date")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Resource Manager Policy Attachment.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> _builtins.str:
        """
        The name of the policy. The name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
        """
        return pulumi.get(self, "policy_name")

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> _builtins.str:
        """
        The type of the policy. Valid values: `Custom` and `System`.
        """
        return pulumi.get(self, "policy_type")

    @_builtins.property
    @pulumi.getter(name="principalName")
    def principal_name(self) -> _builtins.str:
        """
        The name of the object to which the policy is attached.
        """
        return pulumi.get(self, "principal_name")

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> _builtins.str:
        """
        The type of the object to which the policy is attached. If you do not specify this parameter, the system lists all types of objects. Valid values: `IMSUser`: RAM user, `IMSGroup`: RAM user group, `ServiceRole`: RAM role.
        """
        return pulumi.get(self, "principal_type")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group or the ID of the Alibaba Cloud account to which the resource group belongs. If you do not specify this parameter, the system lists all policy attachment records under the current account.
        """
        return pulumi.get(self, "resource_group_id")


@pulumi.output_type
class GetPolicyVersionsVersionResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 is_default_version: _builtins.bool,
                 policy_document: _builtins.str,
                 version_id: _builtins.str):
        """
        :param _builtins.str id: The ID of the resource, the value is `<policy_name>`:`<version_id>`.
        :param _builtins.bool is_default_version: Indicates whether the policy version is the default version.
        :param _builtins.str policy_document: (Available in v1.114.0+) The policy document of the policy version.
        :param _builtins.str version_id: The ID of the policy version.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_default_version", is_default_version)
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "version_id", version_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource, the value is `<policy_name>`:`<version_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDefaultVersion")
    def is_default_version(self) -> _builtins.bool:
        """
        Indicates whether the policy version is the default version.
        """
        return pulumi.get(self, "is_default_version")

    @_builtins.property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> _builtins.str:
        """
        (Available in v1.114.0+) The policy document of the policy version.
        """
        return pulumi.get(self, "policy_document")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> _builtins.str:
        """
        The ID of the policy version.
        """
        return pulumi.get(self, "version_id")


@pulumi.output_type
class GetResourceDirectoriesDirectoryResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 master_account_id: _builtins.str,
                 master_account_name: _builtins.str,
                 resource_directory_id: _builtins.str,
                 root_folder_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str id: The ID of resource directory.
        :param _builtins.str master_account_id: The ID of the master account.
        :param _builtins.str master_account_name: The name of the master account.
        :param _builtins.str resource_directory_id: The ID of the resource directory.
        :param _builtins.str root_folder_id: The ID of the root folder.
        :param _builtins.str status: (Available in 1.120.0+.) The status of the control policy.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "master_account_id", master_account_id)
        pulumi.set(__self__, "master_account_name", master_account_name)
        pulumi.set(__self__, "resource_directory_id", resource_directory_id)
        pulumi.set(__self__, "root_folder_id", root_folder_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of resource directory.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="masterAccountId")
    def master_account_id(self) -> _builtins.str:
        """
        The ID of the master account.
        """
        return pulumi.get(self, "master_account_id")

    @_builtins.property
    @pulumi.getter(name="masterAccountName")
    def master_account_name(self) -> _builtins.str:
        """
        The name of the master account.
        """
        return pulumi.get(self, "master_account_name")

    @_builtins.property
    @pulumi.getter(name="resourceDirectoryId")
    def resource_directory_id(self) -> _builtins.str:
        """
        The ID of the resource directory.
        """
        return pulumi.get(self, "resource_directory_id")

    @_builtins.property
    @pulumi.getter(name="rootFolderId")
    def root_folder_id(self) -> _builtins.str:
        """
        The ID of the root folder.
        """
        return pulumi.get(self, "root_folder_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        (Available in 1.120.0+.) The status of the control policy.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetResourceGroupsGroupResult(dict):
    def __init__(__self__, *,
                 account_id: _builtins.str,
                 display_name: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 region_statuses: Sequence['outputs.GetResourceGroupsGroupRegionStatusResult'],
                 resource_group_name: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str account_id: The ID of the Alibaba Cloud account to which the resource group belongs.
        :param _builtins.str display_name: The display name of the resource group.
        :param _builtins.str id: The ID of the resource group.
        :param _builtins.str name: The unique identifier of the resource group.
        :param Sequence['GetResourceGroupsGroupRegionStatusArgs'] region_statuses: (Available since v1.114.0) The status of the resource group in all regions.
        :param _builtins.str resource_group_name: (Available since v1.114.0) The unique identifier of the resource group.
        :param _builtins.str status: The status of the resource group. Valid values: `Creating`, `Deleted`, `Deleting`, `OK` and `PendingDelete`. **NOTE:** From version 1.114.0, `status` can be set to `Deleting`.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region_statuses", region_statuses)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The ID of the Alibaba Cloud account to which the resource group belongs.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the resource group.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique identifier of the resource group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="regionStatuses")
    def region_statuses(self) -> Sequence['outputs.GetResourceGroupsGroupRegionStatusResult']:
        """
        (Available since v1.114.0) The status of the resource group in all regions.
        """
        return pulumi.get(self, "region_statuses")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        """
        (Available since v1.114.0) The unique identifier of the resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource group. Valid values: `Creating`, `Deleted`, `Deleting`, `OK` and `PendingDelete`. **NOTE:** From version 1.114.0, `status` can be set to `Deleting`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetResourceGroupsGroupRegionStatusResult(dict):
    def __init__(__self__, *,
                 region_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str region_id: The region ID.
        :param _builtins.str status: The status of the resource group. Valid values: `Creating`, `Deleted`, `Deleting`, `OK` and `PendingDelete`. **NOTE:** From version 1.114.0, `status` can be set to `Deleting`.
        """
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region ID.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource group. Valid values: `Creating`, `Deleted`, `Deleting`, `OK` and `PendingDelete`. **NOTE:** From version 1.114.0, `status` can be set to `Deleting`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetResourceSharesShareResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 resource_share_id: _builtins.str,
                 resource_share_name: _builtins.str,
                 resource_share_owner: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str id: The ID of the Resource Share.
        :param _builtins.str resource_share_id: The ID of the resource share.
        :param _builtins.str resource_share_name: The name of resource share.
        :param _builtins.str resource_share_owner: The owner of resource share.
        :param _builtins.str status: The status of resource share.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_share_id", resource_share_id)
        pulumi.set(__self__, "resource_share_name", resource_share_name)
        pulumi.set(__self__, "resource_share_owner", resource_share_owner)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Resource Share.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceShareId")
    def resource_share_id(self) -> _builtins.str:
        """
        The ID of the resource share.
        """
        return pulumi.get(self, "resource_share_id")

    @_builtins.property
    @pulumi.getter(name="resourceShareName")
    def resource_share_name(self) -> _builtins.str:
        """
        The name of resource share.
        """
        return pulumi.get(self, "resource_share_name")

    @_builtins.property
    @pulumi.getter(name="resourceShareOwner")
    def resource_share_owner(self) -> _builtins.str:
        """
        The owner of resource share.
        """
        return pulumi.get(self, "resource_share_owner")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of resource share.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetRolesRoleResult(dict):
    def __init__(__self__, *,
                 arn: _builtins.str,
                 assume_role_policy_document: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 max_session_duration: _builtins.int,
                 role_id: _builtins.str,
                 role_name: _builtins.str,
                 update_date: _builtins.str):
        """
        :param _builtins.str arn: The Alibaba Cloud Resource Name (ARN) of the RAM role.
        :param _builtins.str assume_role_policy_document: (Available in v1.114.0+) The assume role policy document.
        :param _builtins.str description: The description of the RAM role.
        :param _builtins.str id: The ID of the role.
        :param _builtins.int max_session_duration: The maximum session duration of the RAM role.
        :param _builtins.str role_id: The ID of the role.
        :param _builtins.str role_name: The name of the role.
        :param _builtins.str update_date: The time when the RAM role was updated.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "assume_role_policy_document", assume_role_policy_document)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "max_session_duration", max_session_duration)
        pulumi.set(__self__, "role_id", role_id)
        pulumi.set(__self__, "role_name", role_name)
        pulumi.set(__self__, "update_date", update_date)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The Alibaba Cloud Resource Name (ARN) of the RAM role.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="assumeRolePolicyDocument")
    def assume_role_policy_document(self) -> _builtins.str:
        """
        (Available in v1.114.0+) The assume role policy document.
        """
        return pulumi.get(self, "assume_role_policy_document")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the RAM role.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the role.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxSessionDuration")
    def max_session_duration(self) -> _builtins.int:
        """
        The maximum session duration of the RAM role.
        """
        return pulumi.get(self, "max_session_duration")

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> _builtins.str:
        """
        The ID of the role.
        """
        return pulumi.get(self, "role_id")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> _builtins.str:
        """
        The name of the role.
        """
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter(name="updateDate")
    def update_date(self) -> _builtins.str:
        """
        The time when the RAM role was updated.
        """
        return pulumi.get(self, "update_date")


@pulumi.output_type
class GetSharedResourcesResourceResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 resource_id: _builtins.str,
                 resource_share_id: _builtins.str,
                 resource_type: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str id: The ID of the Shared Resource. It formats as `<resource_id>:<resource_type>`.
        :param _builtins.str resource_id: The ID of the shared resource.
        :param _builtins.str resource_share_id: The resource share ID of resource manager.
        :param _builtins.str resource_type: The type of shared resource.
        :param _builtins.str status: The status of share resource. Valid values: `Associated`, `Associating`, `Disassociated`, `Disassociating` and `Failed`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_share_id", resource_share_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Shared Resource. It formats as `<resource_id>:<resource_type>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The ID of the shared resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceShareId")
    def resource_share_id(self) -> _builtins.str:
        """
        The resource share ID of resource manager.
        """
        return pulumi.get(self, "resource_share_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The type of shared resource.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of share resource. Valid values: `Associated`, `Associating`, `Disassociated`, `Disassociating` and `Failed`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetSharedTargetsTargetResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 resource_share_id: _builtins.str,
                 status: _builtins.str,
                 target_id: _builtins.str):
        """
        :param _builtins.str id: The ID of the Shared Target.
        :param _builtins.str resource_share_id: The resource share ID of resource manager.
        :param _builtins.str status: The status of share resource. Valid values: `Associated`, `Associating`, `Disassociated`, `Disassociating` and `Failed`.
        :param _builtins.str target_id: The ID of the Shared Target.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_share_id", resource_share_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "target_id", target_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Shared Target.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceShareId")
    def resource_share_id(self) -> _builtins.str:
        """
        The resource share ID of resource manager.
        """
        return pulumi.get(self, "resource_share_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of share resource. Valid values: `Associated`, `Associating`, `Disassociated`, `Disassociating` and `Failed`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> _builtins.str:
        """
        The ID of the Shared Target.
        """
        return pulumi.get(self, "target_id")


