# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SharedTargetArgs', 'SharedTarget']

@pulumi.input_type
class SharedTargetArgs:
    def __init__(__self__, *,
                 resource_share_id: pulumi.Input[_builtins.str],
                 target_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a SharedTarget resource.
        :param pulumi.Input[_builtins.str] resource_share_id: The ID of the resource share.
        :param pulumi.Input[_builtins.str] target_id: The ID of the principal.
        """
        pulumi.set(__self__, "resource_share_id", resource_share_id)
        pulumi.set(__self__, "target_id", target_id)

    @_builtins.property
    @pulumi.getter(name="resourceShareId")
    def resource_share_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the resource share.
        """
        return pulumi.get(self, "resource_share_id")

    @resource_share_id.setter
    def resource_share_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_share_id", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the principal.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_id", value)


@pulumi.input_type
class _SharedTargetState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_share_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SharedTarget resources.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.259.0) The time when the association of the entity was created.
        :param pulumi.Input[_builtins.str] resource_share_id: The ID of the resource share.
        :param pulumi.Input[_builtins.str] status: The status of shared target.
        :param pulumi.Input[_builtins.str] target_id: The ID of the principal.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if resource_share_id is not None:
            pulumi.set(__self__, "resource_share_id", resource_share_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.259.0) The time when the association of the entity was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="resourceShareId")
    def resource_share_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource share.
        """
        return pulumi.get(self, "resource_share_id")

    @resource_share_id.setter
    def resource_share_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_share_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of shared target.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the principal.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_id", value)


@pulumi.type_token("alicloud:resourcemanager/sharedTarget:SharedTarget")
class SharedTarget(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_share_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Resource Manager Shared Target resource.

        For information about Resource Manager Shared Target and how to use it, see [What is Shared Target](https://www.alibabacloud.com/help/en/resource-management/resource-sharing/developer-reference/api-resourcesharing-2020-01-10-associateresourceshare).

        > **NOTE:** Available since v1.111.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_accounts()
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_resource_share = alicloud.resourcemanager.ResourceShare("default", resource_share_name=f"{name}-{default_integer['result']}")
        default_shared_target = alicloud.resourcemanager.SharedTarget("default",
            resource_share_id=default_resource_share.id,
            target_id=default.ids[0])
        ```

        ## Import

        Resource Manager Shared Target can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:resourcemanager/sharedTarget:SharedTarget example <resource_share_id>:<target_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] resource_share_id: The ID of the resource share.
        :param pulumi.Input[_builtins.str] target_id: The ID of the principal.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SharedTargetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Resource Manager Shared Target resource.

        For information about Resource Manager Shared Target and how to use it, see [What is Shared Target](https://www.alibabacloud.com/help/en/resource-management/resource-sharing/developer-reference/api-resourcesharing-2020-01-10-associateresourceshare).

        > **NOTE:** Available since v1.111.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_accounts()
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_resource_share = alicloud.resourcemanager.ResourceShare("default", resource_share_name=f"{name}-{default_integer['result']}")
        default_shared_target = alicloud.resourcemanager.SharedTarget("default",
            resource_share_id=default_resource_share.id,
            target_id=default.ids[0])
        ```

        ## Import

        Resource Manager Shared Target can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:resourcemanager/sharedTarget:SharedTarget example <resource_share_id>:<target_id>
        ```

        :param str resource_name: The name of the resource.
        :param SharedTargetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SharedTargetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_share_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SharedTargetArgs.__new__(SharedTargetArgs)

            if resource_share_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_share_id'")
            __props__.__dict__["resource_share_id"] = resource_share_id
            if target_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_id'")
            __props__.__dict__["target_id"] = target_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(SharedTarget, __self__).__init__(
            'alicloud:resourcemanager/sharedTarget:SharedTarget',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            resource_share_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            target_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SharedTarget':
        """
        Get an existing SharedTarget resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.259.0) The time when the association of the entity was created.
        :param pulumi.Input[_builtins.str] resource_share_id: The ID of the resource share.
        :param pulumi.Input[_builtins.str] status: The status of shared target.
        :param pulumi.Input[_builtins.str] target_id: The ID of the principal.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SharedTargetState.__new__(_SharedTargetState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["resource_share_id"] = resource_share_id
        __props__.__dict__["status"] = status
        __props__.__dict__["target_id"] = target_id
        return SharedTarget(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.259.0) The time when the association of the entity was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="resourceShareId")
    def resource_share_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource share.
        """
        return pulumi.get(self, "resource_share_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of shared target.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the principal.
        """
        return pulumi.get(self, "target_id")

