# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RocketMQInstanceArgs', 'RocketMQInstance']

@pulumi.input_type
class RocketMQInstanceArgs:
    def __init__(__self__, *,
                 network_info: pulumi.Input['RocketMQInstanceNetworkInfoArgs'],
                 payment_type: pulumi.Input[_builtins.str],
                 series_code: pulumi.Input[_builtins.str],
                 service_code: pulumi.Input[_builtins.str],
                 sub_series_code: pulumi.Input[_builtins.str],
                 acl_info: Optional[pulumi.Input['RocketMQInstanceAclInfoArgs']] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_renew_period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 commodity_code: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 product_info: Optional[pulumi.Input['RocketMQInstanceProductInfoArgs']] = None,
                 remark: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 software: Optional[pulumi.Input['RocketMQInstanceSoftwareArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a RocketMQInstance resource.
        :param pulumi.Input['RocketMQInstanceNetworkInfoArgs'] network_info: Instance network configuration information See `network_info` below.
        :param pulumi.Input[_builtins.str] payment_type: The payment type for the instance. Alibaba Cloud Message Queue RocketMQ version supports two types of payment:
               
               The parameter values are as follows:
               - PayAsYouGo: Pay-as-you-go, a post-payment model where you pay after usage.
               - Subscription: Subscription-based, a pre-payment model where you pay before usage.
               
               For more information, please refer to [Billing Methods](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/overview-2).
        :param pulumi.Input[_builtins.str] series_code: The primary series encoding for the instance. For specific differences between the primary series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection).
               
               The parameter values are as follows:
               - standard: Standard Edition
               - ultimate: Platinum Edition
               - professional: Professional Edition
        :param pulumi.Input[_builtins.str] service_code: The code of the service code instance. The code of the RocketMQ is rmq.
        :param pulumi.Input[_builtins.str] sub_series_code: The sub-series encoding for the instance. For specific differences between the sub-series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection).
               
               The parameter values are as follows:
               - cluster_ha: Cluster High Availability Edition
               - single_node: Single Node Testing Edition
               - serverless：Serverless instance
               **NOTE:** From version 1.245.0, `sub_series_code` can be set to `serverless`.
               When selecting the primary series as ultimate (Platinum Edition), the sub-series can only be chosen as cluster_ha (Cluster High Availability Edition).
        :param pulumi.Input['RocketMQInstanceAclInfoArgs'] acl_info: The access control list for the instance. See `acl_info` below.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to enable auto-renewal. This parameter is only applicable when the payment type for the instance is Subscription (prepaid).
               - true: Enable auto-renewal
               - false: Disable auto-renewal
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto-renewal period. This parameter is only valid when auto-renewal is enabled. Unit: months.
               
               The values can be as follows:
               - Monthly renewal: 1, 2, 3, 6, 12
        :param pulumi.Input[_builtins.str] auto_renew_period_unit: The minimum periodic unit for the duration of auto-renewal. This parameter is only valid when auto-renewal is enabled. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] commodity_code: Commodity code
               
               ons_rmqsub_public_cn: Package year and month instance
               
               ons_rmqpost_public_cn: Pay-As-You-Go instance
               
               Next: Serverless instances
        :param pulumi.Input[_builtins.str] instance_name: The name of instance
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_whitelists: The ip whitelist.
        :param pulumi.Input[_builtins.int] period: Duration of purchase. This parameter is only valid when the payment type for the instance is Subscription (prepaid).
               
               The values can be as follows:
               - Monthly purchase: 1, 2, 3, 4, 5, 6
               - Annual purchase: 1, 2, 3
        :param pulumi.Input[_builtins.str] period_unit: The minimum periodic unit for the duration of purchase.
               
               The parameter values are as follows:
               - Month: Purchase on a monthly basis
               - Year: Purchase on an annual basis
        :param pulumi.Input['RocketMQInstanceProductInfoArgs'] product_info: product info See `product_info` below.
        :param pulumi.Input[_builtins.str] remark: Custom description
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input['RocketMQInstanceSoftwareArgs'] software: Instance software information. See `software` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The resource label.
        """
        pulumi.set(__self__, "network_info", network_info)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "series_code", series_code)
        pulumi.set(__self__, "service_code", service_code)
        pulumi.set(__self__, "sub_series_code", sub_series_code)
        if acl_info is not None:
            pulumi.set(__self__, "acl_info", acl_info)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if auto_renew_period_unit is not None:
            pulumi.set(__self__, "auto_renew_period_unit", auto_renew_period_unit)
        if commodity_code is not None:
            pulumi.set(__self__, "commodity_code", commodity_code)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if ip_whitelists is not None:
            pulumi.set(__self__, "ip_whitelists", ip_whitelists)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if product_info is not None:
            pulumi.set(__self__, "product_info", product_info)
        if remark is not None:
            pulumi.set(__self__, "remark", remark)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if software is not None:
            pulumi.set(__self__, "software", software)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="networkInfo")
    def network_info(self) -> pulumi.Input['RocketMQInstanceNetworkInfoArgs']:
        """
        Instance network configuration information See `network_info` below.
        """
        return pulumi.get(self, "network_info")

    @network_info.setter
    def network_info(self, value: pulumi.Input['RocketMQInstanceNetworkInfoArgs']):
        pulumi.set(self, "network_info", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The payment type for the instance. Alibaba Cloud Message Queue RocketMQ version supports two types of payment:

        The parameter values are as follows:
        - PayAsYouGo: Pay-as-you-go, a post-payment model where you pay after usage.
        - Subscription: Subscription-based, a pre-payment model where you pay before usage.

        For more information, please refer to [Billing Methods](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/overview-2).
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="seriesCode")
    def series_code(self) -> pulumi.Input[_builtins.str]:
        """
        The primary series encoding for the instance. For specific differences between the primary series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection).

        The parameter values are as follows:
        - standard: Standard Edition
        - ultimate: Platinum Edition
        - professional: Professional Edition
        """
        return pulumi.get(self, "series_code")

    @series_code.setter
    def series_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "series_code", value)

    @_builtins.property
    @pulumi.getter(name="serviceCode")
    def service_code(self) -> pulumi.Input[_builtins.str]:
        """
        The code of the service code instance. The code of the RocketMQ is rmq.
        """
        return pulumi.get(self, "service_code")

    @service_code.setter
    def service_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_code", value)

    @_builtins.property
    @pulumi.getter(name="subSeriesCode")
    def sub_series_code(self) -> pulumi.Input[_builtins.str]:
        """
        The sub-series encoding for the instance. For specific differences between the sub-series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection).

        The parameter values are as follows:
        - cluster_ha: Cluster High Availability Edition
        - single_node: Single Node Testing Edition
        - serverless：Serverless instance
        **NOTE:** From version 1.245.0, `sub_series_code` can be set to `serverless`.
        When selecting the primary series as ultimate (Platinum Edition), the sub-series can only be chosen as cluster_ha (Cluster High Availability Edition).
        """
        return pulumi.get(self, "sub_series_code")

    @sub_series_code.setter
    def sub_series_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sub_series_code", value)

    @_builtins.property
    @pulumi.getter(name="aclInfo")
    def acl_info(self) -> Optional[pulumi.Input['RocketMQInstanceAclInfoArgs']]:
        """
        The access control list for the instance. See `acl_info` below.
        """
        return pulumi.get(self, "acl_info")

    @acl_info.setter
    def acl_info(self, value: Optional[pulumi.Input['RocketMQInstanceAclInfoArgs']]):
        pulumi.set(self, "acl_info", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable auto-renewal. This parameter is only applicable when the payment type for the instance is Subscription (prepaid).
        - true: Enable auto-renewal
        - false: Disable auto-renewal
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Auto-renewal period. This parameter is only valid when auto-renewal is enabled. Unit: months.

        The values can be as follows:
        - Monthly renewal: 1, 2, 3, 6, 12
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriodUnit")
    def auto_renew_period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum periodic unit for the duration of auto-renewal. This parameter is only valid when auto-renewal is enabled. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "auto_renew_period_unit")

    @auto_renew_period_unit.setter
    def auto_renew_period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew_period_unit", value)

    @_builtins.property
    @pulumi.getter(name="commodityCode")
    def commodity_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Commodity code

        ons_rmqsub_public_cn: Package year and month instance

        ons_rmqpost_public_cn: Pay-As-You-Go instance

        Next: Serverless instances
        """
        return pulumi.get(self, "commodity_code")

    @commodity_code.setter
    def commodity_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commodity_code", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of instance
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="ipWhitelists")
    def ip_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The ip whitelist.
        """
        return pulumi.get(self, "ip_whitelists")

    @ip_whitelists.setter
    def ip_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_whitelists", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration of purchase. This parameter is only valid when the payment type for the instance is Subscription (prepaid).

        The values can be as follows:
        - Monthly purchase: 1, 2, 3, 4, 5, 6
        - Annual purchase: 1, 2, 3
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum periodic unit for the duration of purchase.

        The parameter values are as follows:
        - Month: Purchase on a monthly basis
        - Year: Purchase on an annual basis
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="productInfo")
    def product_info(self) -> Optional[pulumi.Input['RocketMQInstanceProductInfoArgs']]:
        """
        product info See `product_info` below.
        """
        return pulumi.get(self, "product_info")

    @product_info.setter
    def product_info(self, value: Optional[pulumi.Input['RocketMQInstanceProductInfoArgs']]):
        pulumi.set(self, "product_info", value)

    @_builtins.property
    @pulumi.getter
    def remark(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom description
        """
        return pulumi.get(self, "remark")

    @remark.setter
    def remark(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remark", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def software(self) -> Optional[pulumi.Input['RocketMQInstanceSoftwareArgs']]:
        """
        Instance software information. See `software` below.
        """
        return pulumi.get(self, "software")

    @software.setter
    def software(self, value: Optional[pulumi.Input['RocketMQInstanceSoftwareArgs']]):
        pulumi.set(self, "software", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The resource label.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RocketMQInstanceState:
    def __init__(__self__, *,
                 acl_info: Optional[pulumi.Input['RocketMQInstanceAclInfoArgs']] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_renew_period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 commodity_code: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network_info: Optional[pulumi.Input['RocketMQInstanceNetworkInfoArgs']] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 product_info: Optional[pulumi.Input['RocketMQInstanceProductInfoArgs']] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 remark: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 series_code: Optional[pulumi.Input[_builtins.str]] = None,
                 service_code: Optional[pulumi.Input[_builtins.str]] = None,
                 software: Optional[pulumi.Input['RocketMQInstanceSoftwareArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_series_code: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering RocketMQInstance resources.
        :param pulumi.Input['RocketMQInstanceAclInfoArgs'] acl_info: The access control list for the instance. See `acl_info` below.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to enable auto-renewal. This parameter is only applicable when the payment type for the instance is Subscription (prepaid).
               - true: Enable auto-renewal
               - false: Disable auto-renewal
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto-renewal period. This parameter is only valid when auto-renewal is enabled. Unit: months.
               
               The values can be as follows:
               - Monthly renewal: 1, 2, 3, 6, 12
        :param pulumi.Input[_builtins.str] auto_renew_period_unit: The minimum periodic unit for the duration of auto-renewal. This parameter is only valid when auto-renewal is enabled. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] commodity_code: Commodity code
               
               ons_rmqsub_public_cn: Package year and month instance
               
               ons_rmqpost_public_cn: Pay-As-You-Go instance
               
               Next: Serverless instances
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] instance_name: The name of instance
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_whitelists: The ip whitelist.
        :param pulumi.Input['RocketMQInstanceNetworkInfoArgs'] network_info: Instance network configuration information See `network_info` below.
        :param pulumi.Input[_builtins.str] payment_type: The payment type for the instance. Alibaba Cloud Message Queue RocketMQ version supports two types of payment:
               
               The parameter values are as follows:
               - PayAsYouGo: Pay-as-you-go, a post-payment model where you pay after usage.
               - Subscription: Subscription-based, a pre-payment model where you pay before usage.
               
               For more information, please refer to [Billing Methods](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/overview-2).
        :param pulumi.Input[_builtins.int] period: Duration of purchase. This parameter is only valid when the payment type for the instance is Subscription (prepaid).
               
               The values can be as follows:
               - Monthly purchase: 1, 2, 3, 4, 5, 6
               - Annual purchase: 1, 2, 3
        :param pulumi.Input[_builtins.str] period_unit: The minimum periodic unit for the duration of purchase.
               
               The parameter values are as follows:
               - Month: Purchase on a monthly basis
               - Year: Purchase on an annual basis
        :param pulumi.Input['RocketMQInstanceProductInfoArgs'] product_info: product info See `product_info` below.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.245.0) The ID of the region in which the instance resides.
        :param pulumi.Input[_builtins.str] remark: Custom description
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] series_code: The primary series encoding for the instance. For specific differences between the primary series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection).
               
               The parameter values are as follows:
               - standard: Standard Edition
               - ultimate: Platinum Edition
               - professional: Professional Edition
        :param pulumi.Input[_builtins.str] service_code: The code of the service code instance. The code of the RocketMQ is rmq.
        :param pulumi.Input['RocketMQInstanceSoftwareArgs'] software: Instance software information. See `software` below.
        :param pulumi.Input[_builtins.str] status: The status of the instance
        :param pulumi.Input[_builtins.str] sub_series_code: The sub-series encoding for the instance. For specific differences between the sub-series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection).
               
               The parameter values are as follows:
               - cluster_ha: Cluster High Availability Edition
               - single_node: Single Node Testing Edition
               - serverless：Serverless instance
               **NOTE:** From version 1.245.0, `sub_series_code` can be set to `serverless`.
               When selecting the primary series as ultimate (Platinum Edition), the sub-series can only be chosen as cluster_ha (Cluster High Availability Edition).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The resource label.
        """
        if acl_info is not None:
            pulumi.set(__self__, "acl_info", acl_info)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if auto_renew_period_unit is not None:
            pulumi.set(__self__, "auto_renew_period_unit", auto_renew_period_unit)
        if commodity_code is not None:
            pulumi.set(__self__, "commodity_code", commodity_code)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if ip_whitelists is not None:
            pulumi.set(__self__, "ip_whitelists", ip_whitelists)
        if network_info is not None:
            pulumi.set(__self__, "network_info", network_info)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if product_info is not None:
            pulumi.set(__self__, "product_info", product_info)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if remark is not None:
            pulumi.set(__self__, "remark", remark)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if series_code is not None:
            pulumi.set(__self__, "series_code", series_code)
        if service_code is not None:
            pulumi.set(__self__, "service_code", service_code)
        if software is not None:
            pulumi.set(__self__, "software", software)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sub_series_code is not None:
            pulumi.set(__self__, "sub_series_code", sub_series_code)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="aclInfo")
    def acl_info(self) -> Optional[pulumi.Input['RocketMQInstanceAclInfoArgs']]:
        """
        The access control list for the instance. See `acl_info` below.
        """
        return pulumi.get(self, "acl_info")

    @acl_info.setter
    def acl_info(self, value: Optional[pulumi.Input['RocketMQInstanceAclInfoArgs']]):
        pulumi.set(self, "acl_info", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable auto-renewal. This parameter is only applicable when the payment type for the instance is Subscription (prepaid).
        - true: Enable auto-renewal
        - false: Disable auto-renewal
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Auto-renewal period. This parameter is only valid when auto-renewal is enabled. Unit: months.

        The values can be as follows:
        - Monthly renewal: 1, 2, 3, 6, 12
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriodUnit")
    def auto_renew_period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum periodic unit for the duration of auto-renewal. This parameter is only valid when auto-renewal is enabled. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "auto_renew_period_unit")

    @auto_renew_period_unit.setter
    def auto_renew_period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew_period_unit", value)

    @_builtins.property
    @pulumi.getter(name="commodityCode")
    def commodity_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Commodity code

        ons_rmqsub_public_cn: Package year and month instance

        ons_rmqpost_public_cn: Pay-As-You-Go instance

        Next: Serverless instances
        """
        return pulumi.get(self, "commodity_code")

    @commodity_code.setter
    def commodity_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commodity_code", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of instance
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="ipWhitelists")
    def ip_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The ip whitelist.
        """
        return pulumi.get(self, "ip_whitelists")

    @ip_whitelists.setter
    def ip_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_whitelists", value)

    @_builtins.property
    @pulumi.getter(name="networkInfo")
    def network_info(self) -> Optional[pulumi.Input['RocketMQInstanceNetworkInfoArgs']]:
        """
        Instance network configuration information See `network_info` below.
        """
        return pulumi.get(self, "network_info")

    @network_info.setter
    def network_info(self, value: Optional[pulumi.Input['RocketMQInstanceNetworkInfoArgs']]):
        pulumi.set(self, "network_info", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type for the instance. Alibaba Cloud Message Queue RocketMQ version supports two types of payment:

        The parameter values are as follows:
        - PayAsYouGo: Pay-as-you-go, a post-payment model where you pay after usage.
        - Subscription: Subscription-based, a pre-payment model where you pay before usage.

        For more information, please refer to [Billing Methods](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/overview-2).
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration of purchase. This parameter is only valid when the payment type for the instance is Subscription (prepaid).

        The values can be as follows:
        - Monthly purchase: 1, 2, 3, 4, 5, 6
        - Annual purchase: 1, 2, 3
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum periodic unit for the duration of purchase.

        The parameter values are as follows:
        - Month: Purchase on a monthly basis
        - Year: Purchase on an annual basis
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="productInfo")
    def product_info(self) -> Optional[pulumi.Input['RocketMQInstanceProductInfoArgs']]:
        """
        product info See `product_info` below.
        """
        return pulumi.get(self, "product_info")

    @product_info.setter
    def product_info(self, value: Optional[pulumi.Input['RocketMQInstanceProductInfoArgs']]):
        pulumi.set(self, "product_info", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.245.0) The ID of the region in which the instance resides.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter
    def remark(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom description
        """
        return pulumi.get(self, "remark")

    @remark.setter
    def remark(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remark", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="seriesCode")
    def series_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary series encoding for the instance. For specific differences between the primary series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection).

        The parameter values are as follows:
        - standard: Standard Edition
        - ultimate: Platinum Edition
        - professional: Professional Edition
        """
        return pulumi.get(self, "series_code")

    @series_code.setter
    def series_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "series_code", value)

    @_builtins.property
    @pulumi.getter(name="serviceCode")
    def service_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The code of the service code instance. The code of the RocketMQ is rmq.
        """
        return pulumi.get(self, "service_code")

    @service_code.setter
    def service_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_code", value)

    @_builtins.property
    @pulumi.getter
    def software(self) -> Optional[pulumi.Input['RocketMQInstanceSoftwareArgs']]:
        """
        Instance software information. See `software` below.
        """
        return pulumi.get(self, "software")

    @software.setter
    def software(self, value: Optional[pulumi.Input['RocketMQInstanceSoftwareArgs']]):
        pulumi.set(self, "software", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the instance
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subSeriesCode")
    def sub_series_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sub-series encoding for the instance. For specific differences between the sub-series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection).

        The parameter values are as follows:
        - cluster_ha: Cluster High Availability Edition
        - single_node: Single Node Testing Edition
        - serverless：Serverless instance
        **NOTE:** From version 1.245.0, `sub_series_code` can be set to `serverless`.
        When selecting the primary series as ultimate (Platinum Edition), the sub-series can only be chosen as cluster_ha (Cluster High Availability Edition).
        """
        return pulumi.get(self, "sub_series_code")

    @sub_series_code.setter
    def sub_series_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_series_code", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The resource label.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:rocketmq/rocketMQInstance:RocketMQInstance")
class RocketMQInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_info: Optional[pulumi.Input[Union['RocketMQInstanceAclInfoArgs', 'RocketMQInstanceAclInfoArgsDict']]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_renew_period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 commodity_code: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network_info: Optional[pulumi.Input[Union['RocketMQInstanceNetworkInfoArgs', 'RocketMQInstanceNetworkInfoArgsDict']]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 product_info: Optional[pulumi.Input[Union['RocketMQInstanceProductInfoArgs', 'RocketMQInstanceProductInfoArgsDict']]] = None,
                 remark: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 series_code: Optional[pulumi.Input[_builtins.str]] = None,
                 service_code: Optional[pulumi.Input[_builtins.str]] = None,
                 software: Optional[pulumi.Input[Union['RocketMQInstanceSoftwareArgs', 'RocketMQInstanceSoftwareArgsDict']]] = None,
                 sub_series_code: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Import

        RocketMQ Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rocketmq/rocketMQInstance:RocketMQInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RocketMQInstanceAclInfoArgs', 'RocketMQInstanceAclInfoArgsDict']] acl_info: The access control list for the instance. See `acl_info` below.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to enable auto-renewal. This parameter is only applicable when the payment type for the instance is Subscription (prepaid).
               - true: Enable auto-renewal
               - false: Disable auto-renewal
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto-renewal period. This parameter is only valid when auto-renewal is enabled. Unit: months.
               
               The values can be as follows:
               - Monthly renewal: 1, 2, 3, 6, 12
        :param pulumi.Input[_builtins.str] auto_renew_period_unit: The minimum periodic unit for the duration of auto-renewal. This parameter is only valid when auto-renewal is enabled. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] commodity_code: Commodity code
               
               ons_rmqsub_public_cn: Package year and month instance
               
               ons_rmqpost_public_cn: Pay-As-You-Go instance
               
               Next: Serverless instances
        :param pulumi.Input[_builtins.str] instance_name: The name of instance
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_whitelists: The ip whitelist.
        :param pulumi.Input[Union['RocketMQInstanceNetworkInfoArgs', 'RocketMQInstanceNetworkInfoArgsDict']] network_info: Instance network configuration information See `network_info` below.
        :param pulumi.Input[_builtins.str] payment_type: The payment type for the instance. Alibaba Cloud Message Queue RocketMQ version supports two types of payment:
               
               The parameter values are as follows:
               - PayAsYouGo: Pay-as-you-go, a post-payment model where you pay after usage.
               - Subscription: Subscription-based, a pre-payment model where you pay before usage.
               
               For more information, please refer to [Billing Methods](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/overview-2).
        :param pulumi.Input[_builtins.int] period: Duration of purchase. This parameter is only valid when the payment type for the instance is Subscription (prepaid).
               
               The values can be as follows:
               - Monthly purchase: 1, 2, 3, 4, 5, 6
               - Annual purchase: 1, 2, 3
        :param pulumi.Input[_builtins.str] period_unit: The minimum periodic unit for the duration of purchase.
               
               The parameter values are as follows:
               - Month: Purchase on a monthly basis
               - Year: Purchase on an annual basis
        :param pulumi.Input[Union['RocketMQInstanceProductInfoArgs', 'RocketMQInstanceProductInfoArgsDict']] product_info: product info See `product_info` below.
        :param pulumi.Input[_builtins.str] remark: Custom description
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] series_code: The primary series encoding for the instance. For specific differences between the primary series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection).
               
               The parameter values are as follows:
               - standard: Standard Edition
               - ultimate: Platinum Edition
               - professional: Professional Edition
        :param pulumi.Input[_builtins.str] service_code: The code of the service code instance. The code of the RocketMQ is rmq.
        :param pulumi.Input[Union['RocketMQInstanceSoftwareArgs', 'RocketMQInstanceSoftwareArgsDict']] software: Instance software information. See `software` below.
        :param pulumi.Input[_builtins.str] sub_series_code: The sub-series encoding for the instance. For specific differences between the sub-series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection).
               
               The parameter values are as follows:
               - cluster_ha: Cluster High Availability Edition
               - single_node: Single Node Testing Edition
               - serverless：Serverless instance
               **NOTE:** From version 1.245.0, `sub_series_code` can be set to `serverless`.
               When selecting the primary series as ultimate (Platinum Edition), the sub-series can only be chosen as cluster_ha (Cluster High Availability Edition).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The resource label.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RocketMQInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        RocketMQ Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rocketmq/rocketMQInstance:RocketMQInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param RocketMQInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RocketMQInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_info: Optional[pulumi.Input[Union['RocketMQInstanceAclInfoArgs', 'RocketMQInstanceAclInfoArgsDict']]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_renew_period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 commodity_code: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network_info: Optional[pulumi.Input[Union['RocketMQInstanceNetworkInfoArgs', 'RocketMQInstanceNetworkInfoArgsDict']]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 product_info: Optional[pulumi.Input[Union['RocketMQInstanceProductInfoArgs', 'RocketMQInstanceProductInfoArgsDict']]] = None,
                 remark: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 series_code: Optional[pulumi.Input[_builtins.str]] = None,
                 service_code: Optional[pulumi.Input[_builtins.str]] = None,
                 software: Optional[pulumi.Input[Union['RocketMQInstanceSoftwareArgs', 'RocketMQInstanceSoftwareArgsDict']]] = None,
                 sub_series_code: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RocketMQInstanceArgs.__new__(RocketMQInstanceArgs)

            __props__.__dict__["acl_info"] = acl_info
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["auto_renew_period_unit"] = auto_renew_period_unit
            __props__.__dict__["commodity_code"] = commodity_code
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["ip_whitelists"] = ip_whitelists
            if network_info is None and not opts.urn:
                raise TypeError("Missing required property 'network_info'")
            __props__.__dict__["network_info"] = network_info
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["product_info"] = product_info
            __props__.__dict__["remark"] = remark
            __props__.__dict__["resource_group_id"] = resource_group_id
            if series_code is None and not opts.urn:
                raise TypeError("Missing required property 'series_code'")
            __props__.__dict__["series_code"] = series_code
            if service_code is None and not opts.urn:
                raise TypeError("Missing required property 'service_code'")
            __props__.__dict__["service_code"] = service_code
            __props__.__dict__["software"] = software
            if sub_series_code is None and not opts.urn:
                raise TypeError("Missing required property 'sub_series_code'")
            __props__.__dict__["sub_series_code"] = sub_series_code
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(RocketMQInstance, __self__).__init__(
            'alicloud:rocketmq/rocketMQInstance:RocketMQInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_info: Optional[pulumi.Input[Union['RocketMQInstanceAclInfoArgs', 'RocketMQInstanceAclInfoArgsDict']]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
            auto_renew_period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            commodity_code: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            ip_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            network_info: Optional[pulumi.Input[Union['RocketMQInstanceNetworkInfoArgs', 'RocketMQInstanceNetworkInfoArgsDict']]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            product_info: Optional[pulumi.Input[Union['RocketMQInstanceProductInfoArgs', 'RocketMQInstanceProductInfoArgsDict']]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            remark: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            series_code: Optional[pulumi.Input[_builtins.str]] = None,
            service_code: Optional[pulumi.Input[_builtins.str]] = None,
            software: Optional[pulumi.Input[Union['RocketMQInstanceSoftwareArgs', 'RocketMQInstanceSoftwareArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            sub_series_code: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'RocketMQInstance':
        """
        Get an existing RocketMQInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RocketMQInstanceAclInfoArgs', 'RocketMQInstanceAclInfoArgsDict']] acl_info: The access control list for the instance. See `acl_info` below.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to enable auto-renewal. This parameter is only applicable when the payment type for the instance is Subscription (prepaid).
               - true: Enable auto-renewal
               - false: Disable auto-renewal
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto-renewal period. This parameter is only valid when auto-renewal is enabled. Unit: months.
               
               The values can be as follows:
               - Monthly renewal: 1, 2, 3, 6, 12
        :param pulumi.Input[_builtins.str] auto_renew_period_unit: The minimum periodic unit for the duration of auto-renewal. This parameter is only valid when auto-renewal is enabled. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] commodity_code: Commodity code
               
               ons_rmqsub_public_cn: Package year and month instance
               
               ons_rmqpost_public_cn: Pay-As-You-Go instance
               
               Next: Serverless instances
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] instance_name: The name of instance
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_whitelists: The ip whitelist.
        :param pulumi.Input[Union['RocketMQInstanceNetworkInfoArgs', 'RocketMQInstanceNetworkInfoArgsDict']] network_info: Instance network configuration information See `network_info` below.
        :param pulumi.Input[_builtins.str] payment_type: The payment type for the instance. Alibaba Cloud Message Queue RocketMQ version supports two types of payment:
               
               The parameter values are as follows:
               - PayAsYouGo: Pay-as-you-go, a post-payment model where you pay after usage.
               - Subscription: Subscription-based, a pre-payment model where you pay before usage.
               
               For more information, please refer to [Billing Methods](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/overview-2).
        :param pulumi.Input[_builtins.int] period: Duration of purchase. This parameter is only valid when the payment type for the instance is Subscription (prepaid).
               
               The values can be as follows:
               - Monthly purchase: 1, 2, 3, 4, 5, 6
               - Annual purchase: 1, 2, 3
        :param pulumi.Input[_builtins.str] period_unit: The minimum periodic unit for the duration of purchase.
               
               The parameter values are as follows:
               - Month: Purchase on a monthly basis
               - Year: Purchase on an annual basis
        :param pulumi.Input[Union['RocketMQInstanceProductInfoArgs', 'RocketMQInstanceProductInfoArgsDict']] product_info: product info See `product_info` below.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.245.0) The ID of the region in which the instance resides.
        :param pulumi.Input[_builtins.str] remark: Custom description
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] series_code: The primary series encoding for the instance. For specific differences between the primary series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection).
               
               The parameter values are as follows:
               - standard: Standard Edition
               - ultimate: Platinum Edition
               - professional: Professional Edition
        :param pulumi.Input[_builtins.str] service_code: The code of the service code instance. The code of the RocketMQ is rmq.
        :param pulumi.Input[Union['RocketMQInstanceSoftwareArgs', 'RocketMQInstanceSoftwareArgsDict']] software: Instance software information. See `software` below.
        :param pulumi.Input[_builtins.str] status: The status of the instance
        :param pulumi.Input[_builtins.str] sub_series_code: The sub-series encoding for the instance. For specific differences between the sub-series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection).
               
               The parameter values are as follows:
               - cluster_ha: Cluster High Availability Edition
               - single_node: Single Node Testing Edition
               - serverless：Serverless instance
               **NOTE:** From version 1.245.0, `sub_series_code` can be set to `serverless`.
               When selecting the primary series as ultimate (Platinum Edition), the sub-series can only be chosen as cluster_ha (Cluster High Availability Edition).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The resource label.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RocketMQInstanceState.__new__(_RocketMQInstanceState)

        __props__.__dict__["acl_info"] = acl_info
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["auto_renew_period_unit"] = auto_renew_period_unit
        __props__.__dict__["commodity_code"] = commodity_code
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["ip_whitelists"] = ip_whitelists
        __props__.__dict__["network_info"] = network_info
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["product_info"] = product_info
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["remark"] = remark
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["series_code"] = series_code
        __props__.__dict__["service_code"] = service_code
        __props__.__dict__["software"] = software
        __props__.__dict__["status"] = status
        __props__.__dict__["sub_series_code"] = sub_series_code
        __props__.__dict__["tags"] = tags
        return RocketMQInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aclInfo")
    def acl_info(self) -> pulumi.Output['outputs.RocketMQInstanceAclInfo']:
        """
        The access control list for the instance. See `acl_info` below.
        """
        return pulumi.get(self, "acl_info")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable auto-renewal. This parameter is only applicable when the payment type for the instance is Subscription (prepaid).
        - true: Enable auto-renewal
        - false: Disable auto-renewal
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Auto-renewal period. This parameter is only valid when auto-renewal is enabled. Unit: months.

        The values can be as follows:
        - Monthly renewal: 1, 2, 3, 6, 12
        """
        return pulumi.get(self, "auto_renew_period")

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriodUnit")
    def auto_renew_period_unit(self) -> pulumi.Output[_builtins.str]:
        """
        The minimum periodic unit for the duration of auto-renewal. This parameter is only valid when auto-renewal is enabled. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "auto_renew_period_unit")

    @_builtins.property
    @pulumi.getter(name="commodityCode")
    def commodity_code(self) -> pulumi.Output[_builtins.str]:
        """
        Commodity code

        ons_rmqsub_public_cn: Package year and month instance

        ons_rmqpost_public_cn: Pay-As-You-Go instance

        Next: Serverless instances
        """
        return pulumi.get(self, "commodity_code")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of instance
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="ipWhitelists")
    def ip_whitelists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The ip whitelist.
        """
        return pulumi.get(self, "ip_whitelists")

    @_builtins.property
    @pulumi.getter(name="networkInfo")
    def network_info(self) -> pulumi.Output['outputs.RocketMQInstanceNetworkInfo']:
        """
        Instance network configuration information See `network_info` below.
        """
        return pulumi.get(self, "network_info")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type for the instance. Alibaba Cloud Message Queue RocketMQ version supports two types of payment:

        The parameter values are as follows:
        - PayAsYouGo: Pay-as-you-go, a post-payment model where you pay after usage.
        - Subscription: Subscription-based, a pre-payment model where you pay before usage.

        For more information, please refer to [Billing Methods](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/overview-2).
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Duration of purchase. This parameter is only valid when the payment type for the instance is Subscription (prepaid).

        The values can be as follows:
        - Monthly purchase: 1, 2, 3, 4, 5, 6
        - Annual purchase: 1, 2, 3
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[_builtins.str]:
        """
        The minimum periodic unit for the duration of purchase.

        The parameter values are as follows:
        - Month: Purchase on a monthly basis
        - Year: Purchase on an annual basis
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="productInfo")
    def product_info(self) -> pulumi.Output[Optional['outputs.RocketMQInstanceProductInfo']]:
        """
        product info See `product_info` below.
        """
        return pulumi.get(self, "product_info")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.245.0) The ID of the region in which the instance resides.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def remark(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom description
        """
        return pulumi.get(self, "remark")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="seriesCode")
    def series_code(self) -> pulumi.Output[_builtins.str]:
        """
        The primary series encoding for the instance. For specific differences between the primary series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection).

        The parameter values are as follows:
        - standard: Standard Edition
        - ultimate: Platinum Edition
        - professional: Professional Edition
        """
        return pulumi.get(self, "series_code")

    @_builtins.property
    @pulumi.getter(name="serviceCode")
    def service_code(self) -> pulumi.Output[_builtins.str]:
        """
        The code of the service code instance. The code of the RocketMQ is rmq.
        """
        return pulumi.get(self, "service_code")

    @_builtins.property
    @pulumi.getter
    def software(self) -> pulumi.Output['outputs.RocketMQInstanceSoftware']:
        """
        Instance software information. See `software` below.
        """
        return pulumi.get(self, "software")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the instance
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subSeriesCode")
    def sub_series_code(self) -> pulumi.Output[_builtins.str]:
        """
        The sub-series encoding for the instance. For specific differences between the sub-series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection).

        The parameter values are as follows:
        - cluster_ha: Cluster High Availability Edition
        - single_node: Single Node Testing Edition
        - serverless：Serverless instance
        **NOTE:** From version 1.245.0, `sub_series_code` can be set to `serverless`.
        When selecting the primary series as ultimate (Platinum Edition), the sub-series can only be chosen as cluster_ha (Cluster High Availability Edition).
        """
        return pulumi.get(self, "sub_series_code")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The resource label.
        """
        return pulumi.get(self, "tags")

