# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetStackInstancesResult',
    'AwaitableGetStackInstancesResult',
    'get_stack_instances',
    'get_stack_instances_output',
]

@pulumi.output_type
class GetStackInstancesResult:
    """
    A collection of values returned by getStackInstances.
    """
    def __init__(__self__, enable_details=None, id=None, ids=None, instances=None, output_file=None, stack_group_name=None, stack_instance_account_id=None, stack_instance_region_id=None, status=None):
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if stack_group_name and not isinstance(stack_group_name, str):
            raise TypeError("Expected argument 'stack_group_name' to be a str")
        pulumi.set(__self__, "stack_group_name", stack_group_name)
        if stack_instance_account_id and not isinstance(stack_instance_account_id, str):
            raise TypeError("Expected argument 'stack_instance_account_id' to be a str")
        pulumi.set(__self__, "stack_instance_account_id", stack_instance_account_id)
        if stack_instance_region_id and not isinstance(stack_instance_region_id, str):
            raise TypeError("Expected argument 'stack_instance_region_id' to be a str")
        pulumi.set(__self__, "stack_instance_region_id", stack_instance_region_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetStackInstancesInstanceResult']:
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="stackGroupName")
    def stack_group_name(self) -> _builtins.str:
        return pulumi.get(self, "stack_group_name")

    @_builtins.property
    @pulumi.getter(name="stackInstanceAccountId")
    def stack_instance_account_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "stack_instance_account_id")

    @_builtins.property
    @pulumi.getter(name="stackInstanceRegionId")
    def stack_instance_region_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "stack_instance_region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "status")


class AwaitableGetStackInstancesResult(GetStackInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStackInstancesResult(
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            instances=self.instances,
            output_file=self.output_file,
            stack_group_name=self.stack_group_name,
            stack_instance_account_id=self.stack_instance_account_id,
            stack_instance_region_id=self.stack_instance_region_id,
            status=self.status)


def get_stack_instances(enable_details: Optional[_builtins.bool] = None,
                        ids: Optional[Sequence[_builtins.str]] = None,
                        output_file: Optional[_builtins.str] = None,
                        stack_group_name: Optional[_builtins.str] = None,
                        stack_instance_account_id: Optional[_builtins.str] = None,
                        stack_instance_region_id: Optional[_builtins.str] = None,
                        status: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStackInstancesResult:
    """
    This data source provides the Ros Stack Instances of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.145.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.ros.get_stack_instances(stack_group_name="example_value",
        ids=[
            "example_value-1",
            "example_value-2",
        ],
        enable_details=True)
    pulumi.export("rosStackInstanceId1", ids.instances[0].id)
    status = alicloud.ros.get_stack_instances(stack_group_name="example_value",
        status="CURRENT",
        enable_details=True)
    pulumi.export("rosStackInstanceId2", status.instances[0].id)
    region_id = alicloud.ros.get_stack_instances(stack_group_name="example_value",
        stack_instance_region_id="example_value",
        enable_details=True)
    pulumi.export("rosStackInstanceId3", region_id.instances[0].id)
    account_id = alicloud.ros.get_stack_instances(stack_group_name="example_value",
        stack_instance_account_id="example_value",
        enable_details=True)
    pulumi.export("rosStackInstanceId4", account_id.instances[0].id)
    ```


    :param _builtins.bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[_builtins.str] ids: A list of Stack Instance IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str stack_group_name: The name of the stack group.
    :param _builtins.str stack_instance_account_id: The account to which the stack instance belongs.
    :param _builtins.str stack_instance_region_id: The region of the stack instance.
    :param _builtins.str status: The status of the stack instance. Valid values: `CURRENT` or `OUTDATED`. 
           * `CURRENT`: The stack corresponding to the stack instance is up to date with the stack group.
           * `OUTDATED`: The stack corresponding to the stack instance is not up to date with the stack group. The `OUTDATED` state has the following possible causes:
           * When the CreateStackInstances operation is called to create stack instances, the corresponding stacks fail to be created.
           * When the UpdateStackInstances or UpdateStackGroup operation is called to update stack instances, the corresponding stacks fail to be updated, or only some of the stack instances are updated.
           * The create or update operation is not complete.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['stackGroupName'] = stack_group_name
    __args__['stackInstanceAccountId'] = stack_instance_account_id
    __args__['stackInstanceRegionId'] = stack_instance_region_id
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ros/getStackInstances:getStackInstances', __args__, opts=opts, typ=GetStackInstancesResult).value

    return AwaitableGetStackInstancesResult(
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instances=pulumi.get(__ret__, 'instances'),
        output_file=pulumi.get(__ret__, 'output_file'),
        stack_group_name=pulumi.get(__ret__, 'stack_group_name'),
        stack_instance_account_id=pulumi.get(__ret__, 'stack_instance_account_id'),
        stack_instance_region_id=pulumi.get(__ret__, 'stack_instance_region_id'),
        status=pulumi.get(__ret__, 'status'))
def get_stack_instances_output(enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                               ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                               output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               stack_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                               stack_instance_account_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               stack_instance_region_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStackInstancesResult]:
    """
    This data source provides the Ros Stack Instances of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.145.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.ros.get_stack_instances(stack_group_name="example_value",
        ids=[
            "example_value-1",
            "example_value-2",
        ],
        enable_details=True)
    pulumi.export("rosStackInstanceId1", ids.instances[0].id)
    status = alicloud.ros.get_stack_instances(stack_group_name="example_value",
        status="CURRENT",
        enable_details=True)
    pulumi.export("rosStackInstanceId2", status.instances[0].id)
    region_id = alicloud.ros.get_stack_instances(stack_group_name="example_value",
        stack_instance_region_id="example_value",
        enable_details=True)
    pulumi.export("rosStackInstanceId3", region_id.instances[0].id)
    account_id = alicloud.ros.get_stack_instances(stack_group_name="example_value",
        stack_instance_account_id="example_value",
        enable_details=True)
    pulumi.export("rosStackInstanceId4", account_id.instances[0].id)
    ```


    :param _builtins.bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[_builtins.str] ids: A list of Stack Instance IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str stack_group_name: The name of the stack group.
    :param _builtins.str stack_instance_account_id: The account to which the stack instance belongs.
    :param _builtins.str stack_instance_region_id: The region of the stack instance.
    :param _builtins.str status: The status of the stack instance. Valid values: `CURRENT` or `OUTDATED`. 
           * `CURRENT`: The stack corresponding to the stack instance is up to date with the stack group.
           * `OUTDATED`: The stack corresponding to the stack instance is not up to date with the stack group. The `OUTDATED` state has the following possible causes:
           * When the CreateStackInstances operation is called to create stack instances, the corresponding stacks fail to be created.
           * When the UpdateStackInstances or UpdateStackGroup operation is called to update stack instances, the corresponding stacks fail to be updated, or only some of the stack instances are updated.
           * The create or update operation is not complete.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['stackGroupName'] = stack_group_name
    __args__['stackInstanceAccountId'] = stack_instance_account_id
    __args__['stackInstanceRegionId'] = stack_instance_region_id
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ros/getStackInstances:getStackInstances', __args__, opts=opts, typ=GetStackInstancesResult)
    return __ret__.apply(lambda __response__: GetStackInstancesResult(
        enable_details=pulumi.get(__response__, 'enable_details'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        instances=pulumi.get(__response__, 'instances'),
        output_file=pulumi.get(__response__, 'output_file'),
        stack_group_name=pulumi.get(__response__, 'stack_group_name'),
        stack_instance_account_id=pulumi.get(__response__, 'stack_instance_account_id'),
        stack_instance_region_id=pulumi.get(__response__, 'stack_instance_region_id'),
        status=pulumi.get(__response__, 'status')))
