# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StackGroupArgs', 'StackGroup']

@pulumi.input_type
class StackGroupArgs:
    def __init__(__self__, *,
                 stack_group_name: pulumi.Input[_builtins.str],
                 administration_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_deployment: Optional[pulumi.Input['StackGroupAutoDeploymentArgs']] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['StackGroupParameterArgs']]]] = None,
                 permission_model: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_body: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 template_url: Optional[pulumi.Input[_builtins.str]] = None,
                 template_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StackGroup resource.
        :param pulumi.Input[_builtins.str] stack_group_name: StackGroupName
        :param pulumi.Input[_builtins.str] administration_role_name: The name of the RAM role that you specify for the administrator account in ROS when you create the self-managed stack group. If you do not specify this parameter, the default value AliyunROSStackGroupAdministrationRole is used. You can use the administrator role in ROS to assume the execution role AliyunROSStackGroupExecutionRole to perform operations on the stacks that correspond to stack instances in the stack group.
        :param pulumi.Input['StackGroupAutoDeploymentArgs'] auto_deployment: Automatic deployment setting information. Description
               This parameter is required only if the PermissionModel is SERVICE_MANAGED. See `auto_deployment` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] capabilities: The list of resource stack group options. The maximum length is 1.
        :param pulumi.Input[_builtins.str] description: The description of the stack group.
        :param pulumi.Input[_builtins.str] execution_role_name: The name of the RAM role that you specify for the execution account when you create the self-managed stack group. You can use the administrator role AliyunROSStackGroupAdministrationRole to assume the execution role. If you do not specify this parameter, the default value AliyunROSStackGroupExecutionRole is used. You can use this role in ROS to perform operations on the stacks that correspond to stack instances in the stack group.
        :param pulumi.Input[Sequence[pulumi.Input['StackGroupParameterArgs']]] parameters: Parameters See `parameters` below.
        :param pulumi.Input[_builtins.str] permission_model: The permission model.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The label of the resource stack group.
        :param pulumi.Input[_builtins.str] template_body: The template body.
        :param pulumi.Input[_builtins.str] template_id: The ID of the template.
        :param pulumi.Input[_builtins.str] template_url: The location of the file that contains the template body. The URL must point to the template (1 to 524,288 bytes) located in the HTTP Web server (HTTP or HTTPS) or Alibaba Cloud OSS bucket. The URL of the OSS bucket, such as oss:// ros/template/demo or oss:// ros/template/demo? RegionId = cn-hangzhou. If the OSS region is not specified, the RegionId of the interface is the same by default.
               
               > **NOTE:** You must and can specify only one of the parameters of TemplateBody, TemplateURL, or TemplateId.
        :param pulumi.Input[_builtins.str] template_version: The version of the template.
        """
        pulumi.set(__self__, "stack_group_name", stack_group_name)
        if administration_role_name is not None:
            pulumi.set(__self__, "administration_role_name", administration_role_name)
        if auto_deployment is not None:
            pulumi.set(__self__, "auto_deployment", auto_deployment)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_role_name is not None:
            pulumi.set(__self__, "execution_role_name", execution_role_name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if permission_model is not None:
            pulumi.set(__self__, "permission_model", permission_model)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_body is not None:
            pulumi.set(__self__, "template_body", template_body)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)
        if template_url is not None:
            pulumi.set(__self__, "template_url", template_url)
        if template_version is not None:
            pulumi.set(__self__, "template_version", template_version)

    @_builtins.property
    @pulumi.getter(name="stackGroupName")
    def stack_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        StackGroupName
        """
        return pulumi.get(self, "stack_group_name")

    @stack_group_name.setter
    def stack_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stack_group_name", value)

    @_builtins.property
    @pulumi.getter(name="administrationRoleName")
    def administration_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the RAM role that you specify for the administrator account in ROS when you create the self-managed stack group. If you do not specify this parameter, the default value AliyunROSStackGroupAdministrationRole is used. You can use the administrator role in ROS to assume the execution role AliyunROSStackGroupExecutionRole to perform operations on the stacks that correspond to stack instances in the stack group.
        """
        return pulumi.get(self, "administration_role_name")

    @administration_role_name.setter
    def administration_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administration_role_name", value)

    @_builtins.property
    @pulumi.getter(name="autoDeployment")
    def auto_deployment(self) -> Optional[pulumi.Input['StackGroupAutoDeploymentArgs']]:
        """
        Automatic deployment setting information. Description
        This parameter is required only if the PermissionModel is SERVICE_MANAGED. See `auto_deployment` below.
        """
        return pulumi.get(self, "auto_deployment")

    @auto_deployment.setter
    def auto_deployment(self, value: Optional[pulumi.Input['StackGroupAutoDeploymentArgs']]):
        pulumi.set(self, "auto_deployment", value)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of resource stack group options. The maximum length is 1.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "capabilities", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the stack group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executionRoleName")
    def execution_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the RAM role that you specify for the execution account when you create the self-managed stack group. You can use the administrator role AliyunROSStackGroupAdministrationRole to assume the execution role. If you do not specify this parameter, the default value AliyunROSStackGroupExecutionRole is used. You can use this role in ROS to perform operations on the stacks that correspond to stack instances in the stack group.
        """
        return pulumi.get(self, "execution_role_name")

    @execution_role_name.setter
    def execution_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execution_role_name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackGroupParameterArgs']]]]:
        """
        Parameters See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackGroupParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="permissionModel")
    def permission_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The permission model.
        """
        return pulumi.get(self, "permission_model")

    @permission_model.setter
    def permission_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permission_model", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The label of the resource stack group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="templateBody")
    def template_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The template body.
        """
        return pulumi.get(self, "template_body")

    @template_body.setter
    def template_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_body", value)

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the template.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_id", value)

    @_builtins.property
    @pulumi.getter(name="templateUrl")
    def template_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the file that contains the template body. The URL must point to the template (1 to 524,288 bytes) located in the HTTP Web server (HTTP or HTTPS) or Alibaba Cloud OSS bucket. The URL of the OSS bucket, such as oss:// ros/template/demo or oss:// ros/template/demo? RegionId = cn-hangzhou. If the OSS region is not specified, the RegionId of the interface is the same by default.

        > **NOTE:** You must and can specify only one of the parameters of TemplateBody, TemplateURL, or TemplateId.
        """
        return pulumi.get(self, "template_url")

    @template_url.setter
    def template_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_url", value)

    @_builtins.property
    @pulumi.getter(name="templateVersion")
    def template_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the template.
        """
        return pulumi.get(self, "template_version")

    @template_version.setter
    def template_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_version", value)


@pulumi.input_type
class _StackGroupState:
    def __init__(__self__, *,
                 administration_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_deployment: Optional[pulumi.Input['StackGroupAutoDeploymentArgs']] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['StackGroupParameterArgs']]]] = None,
                 permission_model: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_body: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 template_url: Optional[pulumi.Input[_builtins.str]] = None,
                 template_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StackGroup resources.
        :param pulumi.Input[_builtins.str] administration_role_name: The name of the RAM role that you specify for the administrator account in ROS when you create the self-managed stack group. If you do not specify this parameter, the default value AliyunROSStackGroupAdministrationRole is used. You can use the administrator role in ROS to assume the execution role AliyunROSStackGroupExecutionRole to perform operations on the stacks that correspond to stack instances in the stack group.
        :param pulumi.Input['StackGroupAutoDeploymentArgs'] auto_deployment: Automatic deployment setting information. Description
               This parameter is required only if the PermissionModel is SERVICE_MANAGED. See `auto_deployment` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] capabilities: The list of resource stack group options. The maximum length is 1.
        :param pulumi.Input[_builtins.str] description: The description of the stack group.
        :param pulumi.Input[_builtins.str] execution_role_name: The name of the RAM role that you specify for the execution account when you create the self-managed stack group. You can use the administrator role AliyunROSStackGroupAdministrationRole to assume the execution role. If you do not specify this parameter, the default value AliyunROSStackGroupExecutionRole is used. You can use this role in ROS to perform operations on the stacks that correspond to stack instances in the stack group.
        :param pulumi.Input[Sequence[pulumi.Input['StackGroupParameterArgs']]] parameters: Parameters See `parameters` below.
        :param pulumi.Input[_builtins.str] permission_model: The permission model.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] stack_group_id: The ID of stack group.
        :param pulumi.Input[_builtins.str] stack_group_name: StackGroupName
        :param pulumi.Input[_builtins.str] status: The status of the stack group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The label of the resource stack group.
        :param pulumi.Input[_builtins.str] template_body: The template body.
        :param pulumi.Input[_builtins.str] template_id: The ID of the template.
        :param pulumi.Input[_builtins.str] template_url: The location of the file that contains the template body. The URL must point to the template (1 to 524,288 bytes) located in the HTTP Web server (HTTP or HTTPS) or Alibaba Cloud OSS bucket. The URL of the OSS bucket, such as oss:// ros/template/demo or oss:// ros/template/demo? RegionId = cn-hangzhou. If the OSS region is not specified, the RegionId of the interface is the same by default.
               
               > **NOTE:** You must and can specify only one of the parameters of TemplateBody, TemplateURL, or TemplateId.
        :param pulumi.Input[_builtins.str] template_version: The version of the template.
        """
        if administration_role_name is not None:
            pulumi.set(__self__, "administration_role_name", administration_role_name)
        if auto_deployment is not None:
            pulumi.set(__self__, "auto_deployment", auto_deployment)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_role_name is not None:
            pulumi.set(__self__, "execution_role_name", execution_role_name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if permission_model is not None:
            pulumi.set(__self__, "permission_model", permission_model)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if stack_group_id is not None:
            pulumi.set(__self__, "stack_group_id", stack_group_id)
        if stack_group_name is not None:
            pulumi.set(__self__, "stack_group_name", stack_group_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_body is not None:
            pulumi.set(__self__, "template_body", template_body)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)
        if template_url is not None:
            pulumi.set(__self__, "template_url", template_url)
        if template_version is not None:
            pulumi.set(__self__, "template_version", template_version)

    @_builtins.property
    @pulumi.getter(name="administrationRoleName")
    def administration_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the RAM role that you specify for the administrator account in ROS when you create the self-managed stack group. If you do not specify this parameter, the default value AliyunROSStackGroupAdministrationRole is used. You can use the administrator role in ROS to assume the execution role AliyunROSStackGroupExecutionRole to perform operations on the stacks that correspond to stack instances in the stack group.
        """
        return pulumi.get(self, "administration_role_name")

    @administration_role_name.setter
    def administration_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administration_role_name", value)

    @_builtins.property
    @pulumi.getter(name="autoDeployment")
    def auto_deployment(self) -> Optional[pulumi.Input['StackGroupAutoDeploymentArgs']]:
        """
        Automatic deployment setting information. Description
        This parameter is required only if the PermissionModel is SERVICE_MANAGED. See `auto_deployment` below.
        """
        return pulumi.get(self, "auto_deployment")

    @auto_deployment.setter
    def auto_deployment(self, value: Optional[pulumi.Input['StackGroupAutoDeploymentArgs']]):
        pulumi.set(self, "auto_deployment", value)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of resource stack group options. The maximum length is 1.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "capabilities", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the stack group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executionRoleName")
    def execution_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the RAM role that you specify for the execution account when you create the self-managed stack group. You can use the administrator role AliyunROSStackGroupAdministrationRole to assume the execution role. If you do not specify this parameter, the default value AliyunROSStackGroupExecutionRole is used. You can use this role in ROS to perform operations on the stacks that correspond to stack instances in the stack group.
        """
        return pulumi.get(self, "execution_role_name")

    @execution_role_name.setter
    def execution_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execution_role_name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackGroupParameterArgs']]]]:
        """
        Parameters See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackGroupParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="permissionModel")
    def permission_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The permission model.
        """
        return pulumi.get(self, "permission_model")

    @permission_model.setter
    def permission_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permission_model", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="stackGroupId")
    def stack_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of stack group.
        """
        return pulumi.get(self, "stack_group_id")

    @stack_group_id.setter
    def stack_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_group_id", value)

    @_builtins.property
    @pulumi.getter(name="stackGroupName")
    def stack_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        StackGroupName
        """
        return pulumi.get(self, "stack_group_name")

    @stack_group_name.setter
    def stack_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_group_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the stack group.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The label of the resource stack group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="templateBody")
    def template_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The template body.
        """
        return pulumi.get(self, "template_body")

    @template_body.setter
    def template_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_body", value)

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the template.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_id", value)

    @_builtins.property
    @pulumi.getter(name="templateUrl")
    def template_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the file that contains the template body. The URL must point to the template (1 to 524,288 bytes) located in the HTTP Web server (HTTP or HTTPS) or Alibaba Cloud OSS bucket. The URL of the OSS bucket, such as oss:// ros/template/demo or oss:// ros/template/demo? RegionId = cn-hangzhou. If the OSS region is not specified, the RegionId of the interface is the same by default.

        > **NOTE:** You must and can specify only one of the parameters of TemplateBody, TemplateURL, or TemplateId.
        """
        return pulumi.get(self, "template_url")

    @template_url.setter
    def template_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_url", value)

    @_builtins.property
    @pulumi.getter(name="templateVersion")
    def template_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the template.
        """
        return pulumi.get(self, "template_version")

    @template_version.setter
    def template_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_version", value)


@pulumi.type_token("alicloud:ros/stackGroup:StackGroup")
class StackGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administration_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_deployment: Optional[pulumi.Input[Union['StackGroupAutoDeploymentArgs', 'StackGroupAutoDeploymentArgsDict']]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackGroupParameterArgs', 'StackGroupParameterArgsDict']]]]] = None,
                 permission_model: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_body: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 template_url: Optional[pulumi.Input[_builtins.str]] = None,
                 template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ROS Stack Group resource.

        Resource stack Group.

        For information about ROS Stack Group and how to use it, see [What is Stack Group](https://www.alibabacloud.com/help/en/doc-detail/151333.htm).

        > **NOTE:** Available since v1.107.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.ros.StackGroup("example",
            stack_group_name="example_value",
            template_body=\"\"\"    {
            \\t\\"ROSTemplateFormatVersion\\": \\"2015-09-01\\"
            }
        \"\"\")
        ```

        ## Import

        ROS Stack Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ros/stackGroup:StackGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] administration_role_name: The name of the RAM role that you specify for the administrator account in ROS when you create the self-managed stack group. If you do not specify this parameter, the default value AliyunROSStackGroupAdministrationRole is used. You can use the administrator role in ROS to assume the execution role AliyunROSStackGroupExecutionRole to perform operations on the stacks that correspond to stack instances in the stack group.
        :param pulumi.Input[Union['StackGroupAutoDeploymentArgs', 'StackGroupAutoDeploymentArgsDict']] auto_deployment: Automatic deployment setting information. Description
               This parameter is required only if the PermissionModel is SERVICE_MANAGED. See `auto_deployment` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] capabilities: The list of resource stack group options. The maximum length is 1.
        :param pulumi.Input[_builtins.str] description: The description of the stack group.
        :param pulumi.Input[_builtins.str] execution_role_name: The name of the RAM role that you specify for the execution account when you create the self-managed stack group. You can use the administrator role AliyunROSStackGroupAdministrationRole to assume the execution role. If you do not specify this parameter, the default value AliyunROSStackGroupExecutionRole is used. You can use this role in ROS to perform operations on the stacks that correspond to stack instances in the stack group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StackGroupParameterArgs', 'StackGroupParameterArgsDict']]]] parameters: Parameters See `parameters` below.
        :param pulumi.Input[_builtins.str] permission_model: The permission model.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] stack_group_name: StackGroupName
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The label of the resource stack group.
        :param pulumi.Input[_builtins.str] template_body: The template body.
        :param pulumi.Input[_builtins.str] template_id: The ID of the template.
        :param pulumi.Input[_builtins.str] template_url: The location of the file that contains the template body. The URL must point to the template (1 to 524,288 bytes) located in the HTTP Web server (HTTP or HTTPS) or Alibaba Cloud OSS bucket. The URL of the OSS bucket, such as oss:// ros/template/demo or oss:// ros/template/demo? RegionId = cn-hangzhou. If the OSS region is not specified, the RegionId of the interface is the same by default.
               
               > **NOTE:** You must and can specify only one of the parameters of TemplateBody, TemplateURL, or TemplateId.
        :param pulumi.Input[_builtins.str] template_version: The version of the template.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StackGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ROS Stack Group resource.

        Resource stack Group.

        For information about ROS Stack Group and how to use it, see [What is Stack Group](https://www.alibabacloud.com/help/en/doc-detail/151333.htm).

        > **NOTE:** Available since v1.107.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.ros.StackGroup("example",
            stack_group_name="example_value",
            template_body=\"\"\"    {
            \\t\\"ROSTemplateFormatVersion\\": \\"2015-09-01\\"
            }
        \"\"\")
        ```

        ## Import

        ROS Stack Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ros/stackGroup:StackGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param StackGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StackGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administration_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_deployment: Optional[pulumi.Input[Union['StackGroupAutoDeploymentArgs', 'StackGroupAutoDeploymentArgsDict']]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackGroupParameterArgs', 'StackGroupParameterArgsDict']]]]] = None,
                 permission_model: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_body: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 template_url: Optional[pulumi.Input[_builtins.str]] = None,
                 template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StackGroupArgs.__new__(StackGroupArgs)

            __props__.__dict__["administration_role_name"] = administration_role_name
            __props__.__dict__["auto_deployment"] = auto_deployment
            __props__.__dict__["capabilities"] = capabilities
            __props__.__dict__["description"] = description
            __props__.__dict__["execution_role_name"] = execution_role_name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["permission_model"] = permission_model
            __props__.__dict__["resource_group_id"] = resource_group_id
            if stack_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'stack_group_name'")
            __props__.__dict__["stack_group_name"] = stack_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_body"] = template_body
            __props__.__dict__["template_id"] = template_id
            __props__.__dict__["template_url"] = template_url
            __props__.__dict__["template_version"] = template_version
            __props__.__dict__["stack_group_id"] = None
            __props__.__dict__["status"] = None
        super(StackGroup, __self__).__init__(
            'alicloud:ros/stackGroup:StackGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            administration_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            auto_deployment: Optional[pulumi.Input[Union['StackGroupAutoDeploymentArgs', 'StackGroupAutoDeploymentArgsDict']]] = None,
            capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            execution_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackGroupParameterArgs', 'StackGroupParameterArgsDict']]]]] = None,
            permission_model: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            stack_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            stack_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            template_body: Optional[pulumi.Input[_builtins.str]] = None,
            template_id: Optional[pulumi.Input[_builtins.str]] = None,
            template_url: Optional[pulumi.Input[_builtins.str]] = None,
            template_version: Optional[pulumi.Input[_builtins.str]] = None) -> 'StackGroup':
        """
        Get an existing StackGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] administration_role_name: The name of the RAM role that you specify for the administrator account in ROS when you create the self-managed stack group. If you do not specify this parameter, the default value AliyunROSStackGroupAdministrationRole is used. You can use the administrator role in ROS to assume the execution role AliyunROSStackGroupExecutionRole to perform operations on the stacks that correspond to stack instances in the stack group.
        :param pulumi.Input[Union['StackGroupAutoDeploymentArgs', 'StackGroupAutoDeploymentArgsDict']] auto_deployment: Automatic deployment setting information. Description
               This parameter is required only if the PermissionModel is SERVICE_MANAGED. See `auto_deployment` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] capabilities: The list of resource stack group options. The maximum length is 1.
        :param pulumi.Input[_builtins.str] description: The description of the stack group.
        :param pulumi.Input[_builtins.str] execution_role_name: The name of the RAM role that you specify for the execution account when you create the self-managed stack group. You can use the administrator role AliyunROSStackGroupAdministrationRole to assume the execution role. If you do not specify this parameter, the default value AliyunROSStackGroupExecutionRole is used. You can use this role in ROS to perform operations on the stacks that correspond to stack instances in the stack group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StackGroupParameterArgs', 'StackGroupParameterArgsDict']]]] parameters: Parameters See `parameters` below.
        :param pulumi.Input[_builtins.str] permission_model: The permission model.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] stack_group_id: The ID of stack group.
        :param pulumi.Input[_builtins.str] stack_group_name: StackGroupName
        :param pulumi.Input[_builtins.str] status: The status of the stack group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The label of the resource stack group.
        :param pulumi.Input[_builtins.str] template_body: The template body.
        :param pulumi.Input[_builtins.str] template_id: The ID of the template.
        :param pulumi.Input[_builtins.str] template_url: The location of the file that contains the template body. The URL must point to the template (1 to 524,288 bytes) located in the HTTP Web server (HTTP or HTTPS) or Alibaba Cloud OSS bucket. The URL of the OSS bucket, such as oss:// ros/template/demo or oss:// ros/template/demo? RegionId = cn-hangzhou. If the OSS region is not specified, the RegionId of the interface is the same by default.
               
               > **NOTE:** You must and can specify only one of the parameters of TemplateBody, TemplateURL, or TemplateId.
        :param pulumi.Input[_builtins.str] template_version: The version of the template.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StackGroupState.__new__(_StackGroupState)

        __props__.__dict__["administration_role_name"] = administration_role_name
        __props__.__dict__["auto_deployment"] = auto_deployment
        __props__.__dict__["capabilities"] = capabilities
        __props__.__dict__["description"] = description
        __props__.__dict__["execution_role_name"] = execution_role_name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["permission_model"] = permission_model
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["stack_group_id"] = stack_group_id
        __props__.__dict__["stack_group_name"] = stack_group_name
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template_body"] = template_body
        __props__.__dict__["template_id"] = template_id
        __props__.__dict__["template_url"] = template_url
        __props__.__dict__["template_version"] = template_version
        return StackGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="administrationRoleName")
    def administration_role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the RAM role that you specify for the administrator account in ROS when you create the self-managed stack group. If you do not specify this parameter, the default value AliyunROSStackGroupAdministrationRole is used. You can use the administrator role in ROS to assume the execution role AliyunROSStackGroupExecutionRole to perform operations on the stacks that correspond to stack instances in the stack group.
        """
        return pulumi.get(self, "administration_role_name")

    @_builtins.property
    @pulumi.getter(name="autoDeployment")
    def auto_deployment(self) -> pulumi.Output[Optional['outputs.StackGroupAutoDeployment']]:
        """
        Automatic deployment setting information. Description
        This parameter is required only if the PermissionModel is SERVICE_MANAGED. See `auto_deployment` below.
        """
        return pulumi.get(self, "auto_deployment")

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of resource stack group options. The maximum length is 1.
        """
        return pulumi.get(self, "capabilities")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the stack group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="executionRoleName")
    def execution_role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the RAM role that you specify for the execution account when you create the self-managed stack group. You can use the administrator role AliyunROSStackGroupAdministrationRole to assume the execution role. If you do not specify this parameter, the default value AliyunROSStackGroupExecutionRole is used. You can use this role in ROS to perform operations on the stacks that correspond to stack instances in the stack group.
        """
        return pulumi.get(self, "execution_role_name")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Sequence['outputs.StackGroupParameter']]]:
        """
        Parameters See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="permissionModel")
    def permission_model(self) -> pulumi.Output[_builtins.str]:
        """
        The permission model.
        """
        return pulumi.get(self, "permission_model")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="stackGroupId")
    def stack_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of stack group.
        """
        return pulumi.get(self, "stack_group_id")

    @_builtins.property
    @pulumi.getter(name="stackGroupName")
    def stack_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        StackGroupName
        """
        return pulumi.get(self, "stack_group_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the stack group.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The label of the resource stack group.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="templateBody")
    def template_body(self) -> pulumi.Output[_builtins.str]:
        """
        The template body.
        """
        return pulumi.get(self, "template_body")

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the template.
        """
        return pulumi.get(self, "template_id")

    @_builtins.property
    @pulumi.getter(name="templateUrl")
    def template_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The location of the file that contains the template body. The URL must point to the template (1 to 524,288 bytes) located in the HTTP Web server (HTTP or HTTPS) or Alibaba Cloud OSS bucket. The URL of the OSS bucket, such as oss:// ros/template/demo or oss:// ros/template/demo? RegionId = cn-hangzhou. If the OSS region is not specified, the RegionId of the interface is the same by default.

        > **NOTE:** You must and can specify only one of the parameters of TemplateBody, TemplateURL, or TemplateId.
        """
        return pulumi.get(self, "template_url")

    @_builtins.property
    @pulumi.getter(name="templateVersion")
    def template_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The version of the template.
        """
        return pulumi.get(self, "template_version")

