# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerInternetArgs', 'LoadBalancerInternet']

@pulumi.input_type
class LoadBalancerInternetArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[_builtins.str],
                 internets: pulumi.Input[Sequence[pulumi.Input['LoadBalancerInternetInternetArgs']]],
                 internet_slb_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LoadBalancerInternet resource.
        :param pulumi.Input[_builtins.str] app_id: The target application ID that needs to be bound to the SLB.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerInternetInternetArgs']]] internets: The bound private network SLB. See `internet` below.
        :param pulumi.Input[_builtins.str] internet_slb_id: The internet SLB ID.
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "internets", internets)
        if internet_slb_id is not None:
            pulumi.set(__self__, "internet_slb_id", internet_slb_id)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The target application ID that needs to be bound to the SLB.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter
    def internets(self) -> pulumi.Input[Sequence[pulumi.Input['LoadBalancerInternetInternetArgs']]]:
        """
        The bound private network SLB. See `internet` below.
        """
        return pulumi.get(self, "internets")

    @internets.setter
    def internets(self, value: pulumi.Input[Sequence[pulumi.Input['LoadBalancerInternetInternetArgs']]]):
        pulumi.set(self, "internets", value)

    @_builtins.property
    @pulumi.getter(name="internetSlbId")
    def internet_slb_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internet SLB ID.
        """
        return pulumi.get(self, "internet_slb_id")

    @internet_slb_id.setter
    def internet_slb_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_slb_id", value)


@pulumi.input_type
class _LoadBalancerInternetState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_slb_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internets: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerInternetInternetArgs']]]] = None):
        """
        Input properties used for looking up and filtering LoadBalancerInternet resources.
        :param pulumi.Input[_builtins.str] app_id: The target application ID that needs to be bound to the SLB.
        :param pulumi.Input[_builtins.str] internet_ip: Use designated public network SLBs that have been purchased to support non-shared instances.
        :param pulumi.Input[_builtins.str] internet_slb_id: The internet SLB ID.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerInternetInternetArgs']]] internets: The bound private network SLB. See `internet` below.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if internet_ip is not None:
            pulumi.set(__self__, "internet_ip", internet_ip)
        if internet_slb_id is not None:
            pulumi.set(__self__, "internet_slb_id", internet_slb_id)
        if internets is not None:
            pulumi.set(__self__, "internets", internets)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target application ID that needs to be bound to the SLB.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Use designated public network SLBs that have been purchased to support non-shared instances.
        """
        return pulumi.get(self, "internet_ip")

    @internet_ip.setter
    def internet_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_ip", value)

    @_builtins.property
    @pulumi.getter(name="internetSlbId")
    def internet_slb_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internet SLB ID.
        """
        return pulumi.get(self, "internet_slb_id")

    @internet_slb_id.setter
    def internet_slb_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_slb_id", value)

    @_builtins.property
    @pulumi.getter
    def internets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerInternetInternetArgs']]]]:
        """
        The bound private network SLB. See `internet` below.
        """
        return pulumi.get(self, "internets")

    @internets.setter
    def internets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerInternetInternetArgs']]]]):
        pulumi.set(self, "internets", value)


@pulumi.type_token("alicloud:sae/loadBalancerInternet:LoadBalancerInternet")
class LoadBalancerInternet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_slb_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerInternetInternetArgs', 'LoadBalancerInternetInternetArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides an Alicloud Serverless App Engine (SAE) Application Load Balancer Attachment resource.

        For information about Serverless App Engine (SAE) Load Balancer Internet Attachment and how to use it, see [sae.LoadBalancerInternet](https://www.alibabacloud.com/help/en/sae/latest/bindslb).

        > **NOTE:** Available since v1.164.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_regions(current=True)
        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default_get_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_get_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default_network.id)
        default_namespace = alicloud.sae.Namespace("default",
            namespace_id=f"{default.regions[0].id}:example{default_integer['result']}",
            namespace_name=name,
            namespace_description=name,
            enable_micro_registration=False)
        default_application = alicloud.sae.Application("default",
            app_description=name,
            app_name=f"{name}-{default_integer['result']}",
            namespace_id=default_namespace.id,
            image_url="registry-vpc.cn-hangzhou.aliyuncs.com/lxepoo/apache-php5",
            package_type="Image",
            jdk="Open JDK 8",
            security_group_id=default_security_group.id,
            vpc_id=default_network.id,
            vswitch_id=default_switch.id,
            timezone="Asia/Beijing",
            replicas=5,
            cpu=500,
            memory=2048,
            micro_registration="0")
        default_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("default",
            load_balancer_name=name,
            vswitch_id=default_switch.id,
            load_balancer_spec="slb.s2.small",
            address_type="internet")
        default_load_balancer_internet = alicloud.sae.LoadBalancerInternet("default",
            app_id=default_application.id,
            internet_slb_id=default_application_load_balancer.id,
            internets=[{
                "protocol": "TCP",
                "port": 80,
                "target_port": 8080,
            }])
        ```

        ## Import

        The resource can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sae/loadBalancerInternet:LoadBalancerInternet example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_id: The target application ID that needs to be bound to the SLB.
        :param pulumi.Input[_builtins.str] internet_slb_id: The internet SLB ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerInternetInternetArgs', 'LoadBalancerInternetInternetArgsDict']]]] internets: The bound private network SLB. See `internet` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerInternetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Alicloud Serverless App Engine (SAE) Application Load Balancer Attachment resource.

        For information about Serverless App Engine (SAE) Load Balancer Internet Attachment and how to use it, see [sae.LoadBalancerInternet](https://www.alibabacloud.com/help/en/sae/latest/bindslb).

        > **NOTE:** Available since v1.164.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_regions(current=True)
        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default_get_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_get_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default_network.id)
        default_namespace = alicloud.sae.Namespace("default",
            namespace_id=f"{default.regions[0].id}:example{default_integer['result']}",
            namespace_name=name,
            namespace_description=name,
            enable_micro_registration=False)
        default_application = alicloud.sae.Application("default",
            app_description=name,
            app_name=f"{name}-{default_integer['result']}",
            namespace_id=default_namespace.id,
            image_url="registry-vpc.cn-hangzhou.aliyuncs.com/lxepoo/apache-php5",
            package_type="Image",
            jdk="Open JDK 8",
            security_group_id=default_security_group.id,
            vpc_id=default_network.id,
            vswitch_id=default_switch.id,
            timezone="Asia/Beijing",
            replicas=5,
            cpu=500,
            memory=2048,
            micro_registration="0")
        default_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("default",
            load_balancer_name=name,
            vswitch_id=default_switch.id,
            load_balancer_spec="slb.s2.small",
            address_type="internet")
        default_load_balancer_internet = alicloud.sae.LoadBalancerInternet("default",
            app_id=default_application.id,
            internet_slb_id=default_application_load_balancer.id,
            internets=[{
                "protocol": "TCP",
                "port": 80,
                "target_port": 8080,
            }])
        ```

        ## Import

        The resource can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sae/loadBalancerInternet:LoadBalancerInternet example <id>
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerInternetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerInternetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_slb_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerInternetInternetArgs', 'LoadBalancerInternetInternetArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerInternetArgs.__new__(LoadBalancerInternetArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["internet_slb_id"] = internet_slb_id
            if internets is None and not opts.urn:
                raise TypeError("Missing required property 'internets'")
            __props__.__dict__["internets"] = internets
            __props__.__dict__["internet_ip"] = None
        super(LoadBalancerInternet, __self__).__init__(
            'alicloud:sae/loadBalancerInternet:LoadBalancerInternet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[_builtins.str]] = None,
            internet_ip: Optional[pulumi.Input[_builtins.str]] = None,
            internet_slb_id: Optional[pulumi.Input[_builtins.str]] = None,
            internets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerInternetInternetArgs', 'LoadBalancerInternetInternetArgsDict']]]]] = None) -> 'LoadBalancerInternet':
        """
        Get an existing LoadBalancerInternet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_id: The target application ID that needs to be bound to the SLB.
        :param pulumi.Input[_builtins.str] internet_ip: Use designated public network SLBs that have been purchased to support non-shared instances.
        :param pulumi.Input[_builtins.str] internet_slb_id: The internet SLB ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerInternetInternetArgs', 'LoadBalancerInternetInternetArgsDict']]]] internets: The bound private network SLB. See `internet` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerInternetState.__new__(_LoadBalancerInternetState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["internet_ip"] = internet_ip
        __props__.__dict__["internet_slb_id"] = internet_slb_id
        __props__.__dict__["internets"] = internets
        return LoadBalancerInternet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The target application ID that needs to be bound to the SLB.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> pulumi.Output[_builtins.str]:
        """
        Use designated public network SLBs that have been purchased to support non-shared instances.
        """
        return pulumi.get(self, "internet_ip")

    @_builtins.property
    @pulumi.getter(name="internetSlbId")
    def internet_slb_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The internet SLB ID.
        """
        return pulumi.get(self, "internet_slb_id")

    @_builtins.property
    @pulumi.getter
    def internets(self) -> pulumi.Output[Sequence['outputs.LoadBalancerInternetInternet']]:
        """
        The bound private network SLB. See `internet` below.
        """
        return pulumi.get(self, "internets")

