# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DataLimitArgs', 'DataLimit']

@pulumi.input_type
class DataLimitArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[_builtins.str],
                 audit_status: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store_day: Optional[pulumi.Input[_builtins.int]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 service_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DataLimit resource.
        :param pulumi.Input[_builtins.str] resource_type: The type of the service to which the data asset belongs. Valid values: `MaxCompute`, `OSS`, `RDS`.
        :param pulumi.Input[_builtins.int] audit_status: Whether to enable the log auditing feature. Valid values: `0`, `1`.
        :param pulumi.Input[_builtins.str] engine_type: The type of the database. Valid values: `MySQL`, `SQLServer`.
        :param pulumi.Input[_builtins.str] lang: The lang.
        :param pulumi.Input[_builtins.int] log_store_day: The retention period of raw logs after you enable the log auditing feature. Unit: day. Valid values: `180`, `30`, `365`, `90`. **NOTE:** The`log_store_day` is valid when the `audit_status` is `1`.
        :param pulumi.Input[_builtins.str] parent_id: The ID of the data asset.
        :param pulumi.Input[_builtins.str] password: The password that is used to connect to the database.
        :param pulumi.Input[_builtins.int] port: The port that is used to connect to the database.
        :param pulumi.Input[_builtins.str] service_region_id: The region ID of the data asset.
        :param pulumi.Input[_builtins.str] user_name: The name of the service to which the data asset belongs.
        """
        pulumi.set(__self__, "resource_type", resource_type)
        if audit_status is not None:
            pulumi.set(__self__, "audit_status", audit_status)
        if engine_type is not None:
            pulumi.set(__self__, "engine_type", engine_type)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if log_store_day is not None:
            pulumi.set(__self__, "log_store_day", log_store_day)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service_region_id is not None:
            pulumi.set(__self__, "service_region_id", service_region_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the service to which the data asset belongs. Valid values: `MaxCompute`, `OSS`, `RDS`.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter(name="auditStatus")
    def audit_status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Whether to enable the log auditing feature. Valid values: `0`, `1`.
        """
        return pulumi.get(self, "audit_status")

    @audit_status.setter
    def audit_status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "audit_status", value)

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the database. Valid values: `MySQL`, `SQLServer`.
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_type", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lang.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter(name="logStoreDay")
    def log_store_day(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention period of raw logs after you enable the log auditing feature. Unit: day. Valid values: `180`, `30`, `365`, `90`. **NOTE:** The`log_store_day` is valid when the `audit_status` is `1`.
        """
        return pulumi.get(self, "log_store_day")

    @log_store_day.setter
    def log_store_day(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_store_day", value)

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the data asset.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password that is used to connect to the database.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port that is used to connect to the database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="serviceRegionId")
    def service_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the data asset.
        """
        return pulumi.get(self, "service_region_id")

    @service_region_id.setter
    def service_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_region_id", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service to which the data asset belongs.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class _DataLimitState:
    def __init__(__self__, *,
                 audit_status: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store_day: Optional[pulumi.Input[_builtins.int]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DataLimit resources.
        :param pulumi.Input[_builtins.int] audit_status: Whether to enable the log auditing feature. Valid values: `0`, `1`.
        :param pulumi.Input[_builtins.str] engine_type: The type of the database. Valid values: `MySQL`, `SQLServer`.
        :param pulumi.Input[_builtins.str] lang: The lang.
        :param pulumi.Input[_builtins.int] log_store_day: The retention period of raw logs after you enable the log auditing feature. Unit: day. Valid values: `180`, `30`, `365`, `90`. **NOTE:** The`log_store_day` is valid when the `audit_status` is `1`.
        :param pulumi.Input[_builtins.str] parent_id: The ID of the data asset.
        :param pulumi.Input[_builtins.str] password: The password that is used to connect to the database.
        :param pulumi.Input[_builtins.int] port: The port that is used to connect to the database.
        :param pulumi.Input[_builtins.str] resource_type: The type of the service to which the data asset belongs. Valid values: `MaxCompute`, `OSS`, `RDS`.
        :param pulumi.Input[_builtins.str] service_region_id: The region ID of the data asset.
        :param pulumi.Input[_builtins.str] user_name: The name of the service to which the data asset belongs.
        """
        if audit_status is not None:
            pulumi.set(__self__, "audit_status", audit_status)
        if engine_type is not None:
            pulumi.set(__self__, "engine_type", engine_type)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if log_store_day is not None:
            pulumi.set(__self__, "log_store_day", log_store_day)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if service_region_id is not None:
            pulumi.set(__self__, "service_region_id", service_region_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="auditStatus")
    def audit_status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Whether to enable the log auditing feature. Valid values: `0`, `1`.
        """
        return pulumi.get(self, "audit_status")

    @audit_status.setter
    def audit_status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "audit_status", value)

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the database. Valid values: `MySQL`, `SQLServer`.
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_type", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lang.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter(name="logStoreDay")
    def log_store_day(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention period of raw logs after you enable the log auditing feature. Unit: day. Valid values: `180`, `30`, `365`, `90`. **NOTE:** The`log_store_day` is valid when the `audit_status` is `1`.
        """
        return pulumi.get(self, "log_store_day")

    @log_store_day.setter
    def log_store_day(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_store_day", value)

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the data asset.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password that is used to connect to the database.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port that is used to connect to the database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the service to which the data asset belongs. Valid values: `MaxCompute`, `OSS`, `RDS`.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter(name="serviceRegionId")
    def service_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the data asset.
        """
        return pulumi.get(self, "service_region_id")

    @service_region_id.setter
    def service_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_region_id", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service to which the data asset belongs.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.type_token("alicloud:sddp/dataLimit:DataLimit")
class DataLimit(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_status: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store_day: Optional[pulumi.Input[_builtins.int]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Data Security Center Data Limit resource.

        For information about Data Security Center Data Limit and how to use it, see [What is Data Limit](https://www.alibabacloud.com/help/en/doc-detail/158987.html).

        > **NOTE:** Available since v1.159.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.get_regions(current=True)
        default_get_zones = alicloud.rds.get_zones(engine="MySQL",
            engine_version="8.0",
            instance_charge_type="PostPaid",
            category="Basic",
            db_instance_storage_type="cloud_essd")
        default_get_instance_classes = alicloud.rds.get_instance_classes(zone_id=default_get_zones.zones[0].id,
            engine="MySQL",
            engine_version="8.0",
            category="Basic",
            db_instance_storage_type="cloud_essd",
            instance_charge_type="PostPaid")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_get_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_instance = alicloud.rds.Instance("default",
            engine="MySQL",
            engine_version="8.0",
            instance_type=default_get_instance_classes.instance_classes[0].instance_class,
            instance_storage=default_get_instance_classes.instance_classes[0].storage_range.min,
            instance_charge_type="Postpaid",
            instance_name=name,
            vswitch_id=default_switch.id,
            monitoring_period=60,
            db_instance_storage_type="cloud_essd",
            security_group_ids=[default_security_group.id])
        default_rds_account = alicloud.rds.RdsAccount("default",
            db_instance_id=default_instance.id,
            account_name=name,
            account_password="Example1234")
        default_database = alicloud.rds.Database("default",
            instance_id=default_instance.id,
            name=name)
        default_account_privilege = alicloud.rds.AccountPrivilege("default",
            instance_id=default_instance.id,
            account_name=default_rds_account.account_name,
            privilege="ReadWrite",
            db_names=[default_database.name])
        default_data_limit = alicloud.sddp.DataLimit("default",
            audit_status=0,
            engine_type="MySQL",
            parent_id=std.join_output(separator=".",
                input=[
                    default_account_privilege.instance_id,
                    default_database.name,
                ]).apply(lambda invoke: invoke.result),
            resource_type="RDS",
            user_name=default_database.name,
            password=default_rds_account.account_password,
            port=3306,
            service_region_id=default.regions[0].id)
        ```

        ## Import

        Data Security Center Data Limit can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sddp/dataLimit:DataLimit example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] audit_status: Whether to enable the log auditing feature. Valid values: `0`, `1`.
        :param pulumi.Input[_builtins.str] engine_type: The type of the database. Valid values: `MySQL`, `SQLServer`.
        :param pulumi.Input[_builtins.str] lang: The lang.
        :param pulumi.Input[_builtins.int] log_store_day: The retention period of raw logs after you enable the log auditing feature. Unit: day. Valid values: `180`, `30`, `365`, `90`. **NOTE:** The`log_store_day` is valid when the `audit_status` is `1`.
        :param pulumi.Input[_builtins.str] parent_id: The ID of the data asset.
        :param pulumi.Input[_builtins.str] password: The password that is used to connect to the database.
        :param pulumi.Input[_builtins.int] port: The port that is used to connect to the database.
        :param pulumi.Input[_builtins.str] resource_type: The type of the service to which the data asset belongs. Valid values: `MaxCompute`, `OSS`, `RDS`.
        :param pulumi.Input[_builtins.str] service_region_id: The region ID of the data asset.
        :param pulumi.Input[_builtins.str] user_name: The name of the service to which the data asset belongs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataLimitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Data Security Center Data Limit resource.

        For information about Data Security Center Data Limit and how to use it, see [What is Data Limit](https://www.alibabacloud.com/help/en/doc-detail/158987.html).

        > **NOTE:** Available since v1.159.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.get_regions(current=True)
        default_get_zones = alicloud.rds.get_zones(engine="MySQL",
            engine_version="8.0",
            instance_charge_type="PostPaid",
            category="Basic",
            db_instance_storage_type="cloud_essd")
        default_get_instance_classes = alicloud.rds.get_instance_classes(zone_id=default_get_zones.zones[0].id,
            engine="MySQL",
            engine_version="8.0",
            category="Basic",
            db_instance_storage_type="cloud_essd",
            instance_charge_type="PostPaid")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_get_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_instance = alicloud.rds.Instance("default",
            engine="MySQL",
            engine_version="8.0",
            instance_type=default_get_instance_classes.instance_classes[0].instance_class,
            instance_storage=default_get_instance_classes.instance_classes[0].storage_range.min,
            instance_charge_type="Postpaid",
            instance_name=name,
            vswitch_id=default_switch.id,
            monitoring_period=60,
            db_instance_storage_type="cloud_essd",
            security_group_ids=[default_security_group.id])
        default_rds_account = alicloud.rds.RdsAccount("default",
            db_instance_id=default_instance.id,
            account_name=name,
            account_password="Example1234")
        default_database = alicloud.rds.Database("default",
            instance_id=default_instance.id,
            name=name)
        default_account_privilege = alicloud.rds.AccountPrivilege("default",
            instance_id=default_instance.id,
            account_name=default_rds_account.account_name,
            privilege="ReadWrite",
            db_names=[default_database.name])
        default_data_limit = alicloud.sddp.DataLimit("default",
            audit_status=0,
            engine_type="MySQL",
            parent_id=std.join_output(separator=".",
                input=[
                    default_account_privilege.instance_id,
                    default_database.name,
                ]).apply(lambda invoke: invoke.result),
            resource_type="RDS",
            user_name=default_database.name,
            password=default_rds_account.account_password,
            port=3306,
            service_region_id=default.regions[0].id)
        ```

        ## Import

        Data Security Center Data Limit can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sddp/dataLimit:DataLimit example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DataLimitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataLimitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_status: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store_day: Optional[pulumi.Input[_builtins.int]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataLimitArgs.__new__(DataLimitArgs)

            __props__.__dict__["audit_status"] = audit_status
            __props__.__dict__["engine_type"] = engine_type
            __props__.__dict__["lang"] = lang
            __props__.__dict__["log_store_day"] = log_store_day
            __props__.__dict__["parent_id"] = parent_id
            __props__.__dict__["password"] = password
            __props__.__dict__["port"] = port
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["service_region_id"] = service_region_id
            __props__.__dict__["user_name"] = user_name
        super(DataLimit, __self__).__init__(
            'alicloud:sddp/dataLimit:DataLimit',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit_status: Optional[pulumi.Input[_builtins.int]] = None,
            engine_type: Optional[pulumi.Input[_builtins.str]] = None,
            lang: Optional[pulumi.Input[_builtins.str]] = None,
            log_store_day: Optional[pulumi.Input[_builtins.int]] = None,
            parent_id: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            service_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'DataLimit':
        """
        Get an existing DataLimit resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] audit_status: Whether to enable the log auditing feature. Valid values: `0`, `1`.
        :param pulumi.Input[_builtins.str] engine_type: The type of the database. Valid values: `MySQL`, `SQLServer`.
        :param pulumi.Input[_builtins.str] lang: The lang.
        :param pulumi.Input[_builtins.int] log_store_day: The retention period of raw logs after you enable the log auditing feature. Unit: day. Valid values: `180`, `30`, `365`, `90`. **NOTE:** The`log_store_day` is valid when the `audit_status` is `1`.
        :param pulumi.Input[_builtins.str] parent_id: The ID of the data asset.
        :param pulumi.Input[_builtins.str] password: The password that is used to connect to the database.
        :param pulumi.Input[_builtins.int] port: The port that is used to connect to the database.
        :param pulumi.Input[_builtins.str] resource_type: The type of the service to which the data asset belongs. Valid values: `MaxCompute`, `OSS`, `RDS`.
        :param pulumi.Input[_builtins.str] service_region_id: The region ID of the data asset.
        :param pulumi.Input[_builtins.str] user_name: The name of the service to which the data asset belongs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataLimitState.__new__(_DataLimitState)

        __props__.__dict__["audit_status"] = audit_status
        __props__.__dict__["engine_type"] = engine_type
        __props__.__dict__["lang"] = lang
        __props__.__dict__["log_store_day"] = log_store_day
        __props__.__dict__["parent_id"] = parent_id
        __props__.__dict__["password"] = password
        __props__.__dict__["port"] = port
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["service_region_id"] = service_region_id
        __props__.__dict__["user_name"] = user_name
        return DataLimit(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="auditStatus")
    def audit_status(self) -> pulumi.Output[_builtins.int]:
        """
        Whether to enable the log auditing feature. Valid values: `0`, `1`.
        """
        return pulumi.get(self, "audit_status")

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the database. Valid values: `MySQL`, `SQLServer`.
        """
        return pulumi.get(self, "engine_type")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The lang.
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter(name="logStoreDay")
    def log_store_day(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The retention period of raw logs after you enable the log auditing feature. Unit: day. Valid values: `180`, `30`, `365`, `90`. **NOTE:** The`log_store_day` is valid when the `audit_status` is `1`.
        """
        return pulumi.get(self, "log_store_day")

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the data asset.
        """
        return pulumi.get(self, "parent_id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password that is used to connect to the database.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The port that is used to connect to the database.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the service to which the data asset belongs. Valid values: `MaxCompute`, `OSS`, `RDS`.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter(name="serviceRegionId")
    def service_region_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region ID of the data asset.
        """
        return pulumi.get(self, "service_region_id")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the service to which the data asset belongs.
        """
        return pulumi.get(self, "user_name")

