# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DbClusterArgs', 'DbCluster']

@pulumi.input_type
class DbClusterArgs:
    def __init__(__self__, *,
                 cache_size: pulumi.Input[_builtins.int],
                 db_cluster_class: pulumi.Input[_builtins.str],
                 db_cluster_description: pulumi.Input[_builtins.str],
                 db_instance_id: pulumi.Input[_builtins.str],
                 payment_type: pulumi.Input[_builtins.str],
                 desired_params: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDesiredParamArgs']]]] = None,
                 desired_status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DbCluster resource.
        :param pulumi.Input[_builtins.int] cache_size: The desired cache size on creating cluster. The number should be divided by 100.
        :param pulumi.Input[_builtins.str] db_cluster_class: The DBCluster class. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
        :param pulumi.Input[_builtins.str] db_cluster_description: The DBCluster description.
        :param pulumi.Input[_builtins.str] db_instance_id: The InstanceId of DBInstance for DBCluster. Every DBCluster requires one DBInstance to rely on.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        :param pulumi.Input[Sequence[pulumi.Input['DbClusterDesiredParamArgs']]] desired_params: The modified parameter in DBCluster. See `desired_params` below.
        :param pulumi.Input[_builtins.str] desired_status: The desired status for the resource. Valid values: `ACTIVATION`,`STOPPED`,`STARTING`,`RESTART`.
        """
        pulumi.set(__self__, "cache_size", cache_size)
        pulumi.set(__self__, "db_cluster_class", db_cluster_class)
        pulumi.set(__self__, "db_cluster_description", db_cluster_description)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "payment_type", payment_type)
        if desired_params is not None:
            pulumi.set(__self__, "desired_params", desired_params)
        if desired_status is not None:
            pulumi.set(__self__, "desired_status", desired_status)

    @_builtins.property
    @pulumi.getter(name="cacheSize")
    def cache_size(self) -> pulumi.Input[_builtins.int]:
        """
        The desired cache size on creating cluster. The number should be divided by 100.
        """
        return pulumi.get(self, "cache_size")

    @cache_size.setter
    def cache_size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cache_size", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterClass")
    def db_cluster_class(self) -> pulumi.Input[_builtins.str]:
        """
        The DBCluster class. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
        """
        return pulumi.get(self, "db_cluster_class")

    @db_cluster_class.setter
    def db_cluster_class(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_cluster_class", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterDescription")
    def db_cluster_description(self) -> pulumi.Input[_builtins.str]:
        """
        The DBCluster description.
        """
        return pulumi.get(self, "db_cluster_description")

    @db_cluster_description.setter
    def db_cluster_description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_cluster_description", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The InstanceId of DBInstance for DBCluster. Every DBCluster requires one DBInstance to rely on.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="desiredParams")
    def desired_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDesiredParamArgs']]]]:
        """
        The modified parameter in DBCluster. See `desired_params` below.
        """
        return pulumi.get(self, "desired_params")

    @desired_params.setter
    def desired_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDesiredParamArgs']]]]):
        pulumi.set(self, "desired_params", value)

    @_builtins.property
    @pulumi.getter(name="desiredStatus")
    def desired_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired status for the resource. Valid values: `ACTIVATION`,`STOPPED`,`STARTING`,`RESTART`.
        """
        return pulumi.get(self, "desired_status")

    @desired_status.setter
    def desired_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_status", value)


@pulumi.input_type
class _DbClusterState:
    def __init__(__self__, *,
                 cache_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu: Optional[pulumi.Input[_builtins.int]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_class: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_params: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDesiredParamArgs']]]] = None,
                 desired_status: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 param_change_logs: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterParamChangeLogArgs']]]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DbCluster resources.
        :param pulumi.Input[_builtins.int] cache_size: The desired cache size on creating cluster. The number should be divided by 100.
        :param pulumi.Input[_builtins.int] cpu: The cpu resource amount of DBCluster. Depends on `db_cluster_class`.
        :param pulumi.Input[_builtins.str] create_time: The time when DBCluster is created.
        :param pulumi.Input[_builtins.str] db_cluster_class: The DBCluster class. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
        :param pulumi.Input[_builtins.str] db_cluster_description: The DBCluster description.
        :param pulumi.Input[_builtins.str] db_cluster_id: The id of the cluster.
        :param pulumi.Input[_builtins.str] db_instance_id: The InstanceId of DBInstance for DBCluster. Every DBCluster requires one DBInstance to rely on.
        :param pulumi.Input[Sequence[pulumi.Input['DbClusterDesiredParamArgs']]] desired_params: The modified parameter in DBCluster. See `desired_params` below.
        :param pulumi.Input[_builtins.str] desired_status: The desired status for the resource. Valid values: `ACTIVATION`,`STOPPED`,`STARTING`,`RESTART`.
        :param pulumi.Input[_builtins.str] engine: The engine of DBCluster. Always `selectdb`.
        :param pulumi.Input[_builtins.str] engine_version: The version of DBCluster.
        :param pulumi.Input[_builtins.int] memory: The memory resource amount of DBCluster. Depends on `db_cluster_class`.
        :param pulumi.Input[Sequence[pulumi.Input['DbClusterParamChangeLogArgs']]] param_change_logs: The details about parameter changelogs in DBCluster returned.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        :param pulumi.Input[_builtins.str] region_id: The ID of region for the cluster.
        :param pulumi.Input[_builtins.str] status: The current status of the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC for the cluster.
        :param pulumi.Input[_builtins.str] zone_id: The ID of zone for the cluster.
        """
        if cache_size is not None:
            pulumi.set(__self__, "cache_size", cache_size)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if db_cluster_class is not None:
            pulumi.set(__self__, "db_cluster_class", db_cluster_class)
        if db_cluster_description is not None:
            pulumi.set(__self__, "db_cluster_description", db_cluster_description)
        if db_cluster_id is not None:
            pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        if db_instance_id is not None:
            pulumi.set(__self__, "db_instance_id", db_instance_id)
        if desired_params is not None:
            pulumi.set(__self__, "desired_params", desired_params)
        if desired_status is not None:
            pulumi.set(__self__, "desired_status", desired_status)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if param_change_logs is not None:
            pulumi.set(__self__, "param_change_logs", param_change_logs)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="cacheSize")
    def cache_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The desired cache size on creating cluster. The number should be divided by 100.
        """
        return pulumi.get(self, "cache_size")

    @cache_size.setter
    def cache_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_size", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The cpu resource amount of DBCluster. Depends on `db_cluster_class`.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when DBCluster is created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterClass")
    def db_cluster_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DBCluster class. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
        """
        return pulumi.get(self, "db_cluster_class")

    @db_cluster_class.setter
    def db_cluster_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_class", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterDescription")
    def db_cluster_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DBCluster description.
        """
        return pulumi.get(self, "db_cluster_description")

    @db_cluster_description.setter
    def db_cluster_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_description", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the cluster.
        """
        return pulumi.get(self, "db_cluster_id")

    @db_cluster_id.setter
    def db_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The InstanceId of DBInstance for DBCluster. Every DBCluster requires one DBInstance to rely on.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="desiredParams")
    def desired_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDesiredParamArgs']]]]:
        """
        The modified parameter in DBCluster. See `desired_params` below.
        """
        return pulumi.get(self, "desired_params")

    @desired_params.setter
    def desired_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDesiredParamArgs']]]]):
        pulumi.set(self, "desired_params", value)

    @_builtins.property
    @pulumi.getter(name="desiredStatus")
    def desired_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired status for the resource. Valid values: `ACTIVATION`,`STOPPED`,`STARTING`,`RESTART`.
        """
        return pulumi.get(self, "desired_status")

    @desired_status.setter
    def desired_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_status", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The engine of DBCluster. Always `selectdb`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of DBCluster.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The memory resource amount of DBCluster. Depends on `db_cluster_class`.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="paramChangeLogs")
    def param_change_logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterParamChangeLogArgs']]]]:
        """
        The details about parameter changelogs in DBCluster returned.
        """
        return pulumi.get(self, "param_change_logs")

    @param_change_logs.setter
    def param_change_logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterParamChangeLogArgs']]]]):
        pulumi.set(self, "param_change_logs", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of region for the cluster.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC for the cluster.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of zone for the cluster.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:selectdb/dbCluster:DbCluster")
class DbCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_size: Optional[pulumi.Input[_builtins.int]] = None,
                 db_cluster_class: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbClusterDesiredParamArgs', 'DbClusterDesiredParamArgsDict']]]]] = None,
                 desired_status: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a SelectDB DBCluster resource.

        For information about SelectDB DBCluster and how to use it, see [What is DBCluster](https://www.alibabacloud.com/help/zh/selectdb/latest/api-selectdb-2023-05-22-createdbcluster).

        > **NOTE:** Available since v1.229.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_zones(available_resource_creation="VSwitch")
        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id=default.zones[0].id)
        default_db_instance = alicloud.selectdb.DbInstance("default",
            db_instance_class="selectdb.xlarge",
            db_instance_description=name,
            cache_size=200,
            payment_type="PayAsYouGo",
            engine_minor_version="3.0.12",
            vpc_id=default_get_switches.vswitches[0].vpc_id,
            zone_id=default_get_switches.vswitches[0].zone_id,
            vswitch_id=default_get_switches.vswitches[0].id)
        default_db_cluster = alicloud.selectdb.DbCluster("default",
            db_instance_id=default_db_instance.id,
            db_cluster_description=name,
            db_cluster_class="selectdb.2xlarge",
            cache_size=400,
            payment_type="PayAsYouGo")
        ```

        ## Import

        SelectDB DBCluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:selectdb/dbCluster:DbCluster example <db_instance_id>:<db_cluster_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cache_size: The desired cache size on creating cluster. The number should be divided by 100.
        :param pulumi.Input[_builtins.str] db_cluster_class: The DBCluster class. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
        :param pulumi.Input[_builtins.str] db_cluster_description: The DBCluster description.
        :param pulumi.Input[_builtins.str] db_instance_id: The InstanceId of DBInstance for DBCluster. Every DBCluster requires one DBInstance to rely on.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbClusterDesiredParamArgs', 'DbClusterDesiredParamArgsDict']]]] desired_params: The modified parameter in DBCluster. See `desired_params` below.
        :param pulumi.Input[_builtins.str] desired_status: The desired status for the resource. Valid values: `ACTIVATION`,`STOPPED`,`STARTING`,`RESTART`.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a SelectDB DBCluster resource.

        For information about SelectDB DBCluster and how to use it, see [What is DBCluster](https://www.alibabacloud.com/help/zh/selectdb/latest/api-selectdb-2023-05-22-createdbcluster).

        > **NOTE:** Available since v1.229.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_zones(available_resource_creation="VSwitch")
        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id=default.zones[0].id)
        default_db_instance = alicloud.selectdb.DbInstance("default",
            db_instance_class="selectdb.xlarge",
            db_instance_description=name,
            cache_size=200,
            payment_type="PayAsYouGo",
            engine_minor_version="3.0.12",
            vpc_id=default_get_switches.vswitches[0].vpc_id,
            zone_id=default_get_switches.vswitches[0].zone_id,
            vswitch_id=default_get_switches.vswitches[0].id)
        default_db_cluster = alicloud.selectdb.DbCluster("default",
            db_instance_id=default_db_instance.id,
            db_cluster_description=name,
            db_cluster_class="selectdb.2xlarge",
            cache_size=400,
            payment_type="PayAsYouGo")
        ```

        ## Import

        SelectDB DBCluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:selectdb/dbCluster:DbCluster example <db_instance_id>:<db_cluster_id>
        ```

        :param str resource_name: The name of the resource.
        :param DbClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_size: Optional[pulumi.Input[_builtins.int]] = None,
                 db_cluster_class: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbClusterDesiredParamArgs', 'DbClusterDesiredParamArgsDict']]]]] = None,
                 desired_status: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbClusterArgs.__new__(DbClusterArgs)

            if cache_size is None and not opts.urn:
                raise TypeError("Missing required property 'cache_size'")
            __props__.__dict__["cache_size"] = cache_size
            if db_cluster_class is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_class'")
            __props__.__dict__["db_cluster_class"] = db_cluster_class
            if db_cluster_description is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_description'")
            __props__.__dict__["db_cluster_description"] = db_cluster_description
            if db_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_id'")
            __props__.__dict__["db_instance_id"] = db_instance_id
            __props__.__dict__["desired_params"] = desired_params
            __props__.__dict__["desired_status"] = desired_status
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["cpu"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["db_cluster_id"] = None
            __props__.__dict__["engine"] = None
            __props__.__dict__["engine_version"] = None
            __props__.__dict__["memory"] = None
            __props__.__dict__["param_change_logs"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["vpc_id"] = None
            __props__.__dict__["zone_id"] = None
        super(DbCluster, __self__).__init__(
            'alicloud:selectdb/dbCluster:DbCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cache_size: Optional[pulumi.Input[_builtins.int]] = None,
            cpu: Optional[pulumi.Input[_builtins.int]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            db_cluster_class: Optional[pulumi.Input[_builtins.str]] = None,
            db_cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
            db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            desired_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbClusterDesiredParamArgs', 'DbClusterDesiredParamArgsDict']]]]] = None,
            desired_status: Optional[pulumi.Input[_builtins.str]] = None,
            engine: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            memory: Optional[pulumi.Input[_builtins.int]] = None,
            param_change_logs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbClusterParamChangeLogArgs', 'DbClusterParamChangeLogArgsDict']]]]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DbCluster':
        """
        Get an existing DbCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cache_size: The desired cache size on creating cluster. The number should be divided by 100.
        :param pulumi.Input[_builtins.int] cpu: The cpu resource amount of DBCluster. Depends on `db_cluster_class`.
        :param pulumi.Input[_builtins.str] create_time: The time when DBCluster is created.
        :param pulumi.Input[_builtins.str] db_cluster_class: The DBCluster class. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
        :param pulumi.Input[_builtins.str] db_cluster_description: The DBCluster description.
        :param pulumi.Input[_builtins.str] db_cluster_id: The id of the cluster.
        :param pulumi.Input[_builtins.str] db_instance_id: The InstanceId of DBInstance for DBCluster. Every DBCluster requires one DBInstance to rely on.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbClusterDesiredParamArgs', 'DbClusterDesiredParamArgsDict']]]] desired_params: The modified parameter in DBCluster. See `desired_params` below.
        :param pulumi.Input[_builtins.str] desired_status: The desired status for the resource. Valid values: `ACTIVATION`,`STOPPED`,`STARTING`,`RESTART`.
        :param pulumi.Input[_builtins.str] engine: The engine of DBCluster. Always `selectdb`.
        :param pulumi.Input[_builtins.str] engine_version: The version of DBCluster.
        :param pulumi.Input[_builtins.int] memory: The memory resource amount of DBCluster. Depends on `db_cluster_class`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbClusterParamChangeLogArgs', 'DbClusterParamChangeLogArgsDict']]]] param_change_logs: The details about parameter changelogs in DBCluster returned.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        :param pulumi.Input[_builtins.str] region_id: The ID of region for the cluster.
        :param pulumi.Input[_builtins.str] status: The current status of the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC for the cluster.
        :param pulumi.Input[_builtins.str] zone_id: The ID of zone for the cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbClusterState.__new__(_DbClusterState)

        __props__.__dict__["cache_size"] = cache_size
        __props__.__dict__["cpu"] = cpu
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["db_cluster_class"] = db_cluster_class
        __props__.__dict__["db_cluster_description"] = db_cluster_description
        __props__.__dict__["db_cluster_id"] = db_cluster_id
        __props__.__dict__["db_instance_id"] = db_instance_id
        __props__.__dict__["desired_params"] = desired_params
        __props__.__dict__["desired_status"] = desired_status
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["memory"] = memory
        __props__.__dict__["param_change_logs"] = param_change_logs
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["zone_id"] = zone_id
        return DbCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cacheSize")
    def cache_size(self) -> pulumi.Output[_builtins.int]:
        """
        The desired cache size on creating cluster. The number should be divided by 100.
        """
        return pulumi.get(self, "cache_size")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> pulumi.Output[_builtins.int]:
        """
        The cpu resource amount of DBCluster. Depends on `db_cluster_class`.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when DBCluster is created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dbClusterClass")
    def db_cluster_class(self) -> pulumi.Output[_builtins.str]:
        """
        The DBCluster class. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
        """
        return pulumi.get(self, "db_cluster_class")

    @_builtins.property
    @pulumi.getter(name="dbClusterDescription")
    def db_cluster_description(self) -> pulumi.Output[_builtins.str]:
        """
        The DBCluster description.
        """
        return pulumi.get(self, "db_cluster_description")

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the cluster.
        """
        return pulumi.get(self, "db_cluster_id")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The InstanceId of DBInstance for DBCluster. Every DBCluster requires one DBInstance to rely on.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter(name="desiredParams")
    def desired_params(self) -> pulumi.Output[Optional[Sequence['outputs.DbClusterDesiredParam']]]:
        """
        The modified parameter in DBCluster. See `desired_params` below.
        """
        return pulumi.get(self, "desired_params")

    @_builtins.property
    @pulumi.getter(name="desiredStatus")
    def desired_status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The desired status for the resource. Valid values: `ACTIVATION`,`STOPPED`,`STARTING`,`RESTART`.
        """
        return pulumi.get(self, "desired_status")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Output[_builtins.str]:
        """
        The engine of DBCluster. Always `selectdb`.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of DBCluster.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> pulumi.Output[_builtins.int]:
        """
        The memory resource amount of DBCluster. Depends on `db_cluster_class`.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="paramChangeLogs")
    def param_change_logs(self) -> pulumi.Output[Sequence['outputs.DbClusterParamChangeLog']]:
        """
        The details about parameter changelogs in DBCluster returned.
        """
        return pulumi.get(self, "param_change_logs")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of region for the cluster.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC for the cluster.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of zone for the cluster.
        """
        return pulumi.get(self, "zone_id")

