# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PrincipalPortfolioAssociationArgs', 'PrincipalPortfolioAssociation']

@pulumi.input_type
class PrincipalPortfolioAssociationArgs:
    def __init__(__self__, *,
                 portfolio_id: pulumi.Input[_builtins.str],
                 principal_id: pulumi.Input[_builtins.str],
                 principal_type: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a PrincipalPortfolioAssociation resource.
        :param pulumi.Input[_builtins.str] portfolio_id: Product Portfolio ID
        :param pulumi.Input[_builtins.str] principal_id: RAM entity ID
        :param pulumi.Input[_builtins.str] principal_type: RAM entity type
        """
        pulumi.set(__self__, "portfolio_id", portfolio_id)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_type", principal_type)

    @_builtins.property
    @pulumi.getter(name="portfolioId")
    def portfolio_id(self) -> pulumi.Input[_builtins.str]:
        """
        Product Portfolio ID
        """
        return pulumi.get(self, "portfolio_id")

    @portfolio_id.setter
    def portfolio_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "portfolio_id", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[_builtins.str]:
        """
        RAM entity ID
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Input[_builtins.str]:
        """
        RAM entity type
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal_type", value)


@pulumi.input_type
class _PrincipalPortfolioAssociationState:
    def __init__(__self__, *,
                 portfolio_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PrincipalPortfolioAssociation resources.
        :param pulumi.Input[_builtins.str] portfolio_id: Product Portfolio ID
        :param pulumi.Input[_builtins.str] principal_id: RAM entity ID
        :param pulumi.Input[_builtins.str] principal_type: RAM entity type
        """
        if portfolio_id is not None:
            pulumi.set(__self__, "portfolio_id", portfolio_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if principal_type is not None:
            pulumi.set(__self__, "principal_type", principal_type)

    @_builtins.property
    @pulumi.getter(name="portfolioId")
    def portfolio_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Product Portfolio ID
        """
        return pulumi.get(self, "portfolio_id")

    @portfolio_id.setter
    def portfolio_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "portfolio_id", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RAM entity ID
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RAM entity type
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_type", value)


@pulumi.type_token("alicloud:servicecatalog/principalPortfolioAssociation:PrincipalPortfolioAssociation")
class PrincipalPortfolioAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 portfolio_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Service Catalog Principal Portfolio Association resource.

        Principal portfolio association.

        For information about Service Catalog Principal Portfolio Association and how to use it, see [What is Principal Portfolio Association](https://www.alibabacloud.com/help/en/service-catalog/developer-reference/api-servicecatalog-2021-09-01-associateprincipalwithportfolio).

        > **NOTE:** Available since v1.230.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_da_x_vx_i = alicloud.servicecatalog.Portfolio("defaultDaXVxI",
            provider_name=name,
            description="desc",
            portfolio_name=name)
        default48_j_hf4 = alicloud.ram.Role("default48JHf4",
            name=name,
            document=\"\"\"    {
                \\"Statement\\": [
                {
                    \\"Action\\": \\"sts:AssumeRole\\",
                    \\"Effect\\": \\"Allow\\",
                    \\"Principal\\": {
                    \\"Service\\": [
                        \\"emr.aliyuncs.com\\",
                        \\"ecs.aliyuncs.com\\"
                    ]
                    }
                }
                ],
                \\"Version\\": \\"1\\"
            }
        \"\"\",
            description="this is a role test.",
            force=True)
        default = alicloud.servicecatalog.PrincipalPortfolioAssociation("default",
            principal_id=default48_j_hf4.id,
            portfolio_id=default_da_x_vx_i.id,
            principal_type="RamRole")
        ```

        ## Import

        Service Catalog Principal Portfolio Association can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:servicecatalog/principalPortfolioAssociation:PrincipalPortfolioAssociation example <principal_id>:<principal_type>:<portfolio_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] portfolio_id: Product Portfolio ID
        :param pulumi.Input[_builtins.str] principal_id: RAM entity ID
        :param pulumi.Input[_builtins.str] principal_type: RAM entity type
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrincipalPortfolioAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Service Catalog Principal Portfolio Association resource.

        Principal portfolio association.

        For information about Service Catalog Principal Portfolio Association and how to use it, see [What is Principal Portfolio Association](https://www.alibabacloud.com/help/en/service-catalog/developer-reference/api-servicecatalog-2021-09-01-associateprincipalwithportfolio).

        > **NOTE:** Available since v1.230.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_da_x_vx_i = alicloud.servicecatalog.Portfolio("defaultDaXVxI",
            provider_name=name,
            description="desc",
            portfolio_name=name)
        default48_j_hf4 = alicloud.ram.Role("default48JHf4",
            name=name,
            document=\"\"\"    {
                \\"Statement\\": [
                {
                    \\"Action\\": \\"sts:AssumeRole\\",
                    \\"Effect\\": \\"Allow\\",
                    \\"Principal\\": {
                    \\"Service\\": [
                        \\"emr.aliyuncs.com\\",
                        \\"ecs.aliyuncs.com\\"
                    ]
                    }
                }
                ],
                \\"Version\\": \\"1\\"
            }
        \"\"\",
            description="this is a role test.",
            force=True)
        default = alicloud.servicecatalog.PrincipalPortfolioAssociation("default",
            principal_id=default48_j_hf4.id,
            portfolio_id=default_da_x_vx_i.id,
            principal_type="RamRole")
        ```

        ## Import

        Service Catalog Principal Portfolio Association can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:servicecatalog/principalPortfolioAssociation:PrincipalPortfolioAssociation example <principal_id>:<principal_type>:<portfolio_id>
        ```

        :param str resource_name: The name of the resource.
        :param PrincipalPortfolioAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrincipalPortfolioAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 portfolio_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrincipalPortfolioAssociationArgs.__new__(PrincipalPortfolioAssociationArgs)

            if portfolio_id is None and not opts.urn:
                raise TypeError("Missing required property 'portfolio_id'")
            __props__.__dict__["portfolio_id"] = portfolio_id
            if principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'principal_id'")
            __props__.__dict__["principal_id"] = principal_id
            if principal_type is None and not opts.urn:
                raise TypeError("Missing required property 'principal_type'")
            __props__.__dict__["principal_type"] = principal_type
        super(PrincipalPortfolioAssociation, __self__).__init__(
            'alicloud:servicecatalog/principalPortfolioAssociation:PrincipalPortfolioAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            portfolio_id: Optional[pulumi.Input[_builtins.str]] = None,
            principal_id: Optional[pulumi.Input[_builtins.str]] = None,
            principal_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'PrincipalPortfolioAssociation':
        """
        Get an existing PrincipalPortfolioAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] portfolio_id: Product Portfolio ID
        :param pulumi.Input[_builtins.str] principal_id: RAM entity ID
        :param pulumi.Input[_builtins.str] principal_type: RAM entity type
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrincipalPortfolioAssociationState.__new__(_PrincipalPortfolioAssociationState)

        __props__.__dict__["portfolio_id"] = portfolio_id
        __props__.__dict__["principal_id"] = principal_id
        __props__.__dict__["principal_type"] = principal_type
        return PrincipalPortfolioAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="portfolioId")
    def portfolio_id(self) -> pulumi.Output[_builtins.str]:
        """
        Product Portfolio ID
        """
        return pulumi.get(self, "portfolio_id")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Output[_builtins.str]:
        """
        RAM entity ID
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Output[_builtins.str]:
        """
        RAM entity type
        """
        return pulumi.get(self, "principal_type")

