# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertArgs', 'Alert']

@pulumi.input_type
class AlertArgs:
    def __init__(__self__, *,
                 alert_name: pulumi.Input[_builtins.str],
                 configuration: pulumi.Input['AlertConfigurationArgs'],
                 display_name: pulumi.Input[_builtins.str],
                 project_name: pulumi.Input[_builtins.str],
                 schedule: pulumi.Input['AlertScheduleArgs'],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Alert resource.
        :param pulumi.Input[_builtins.str] alert_name: Alert rule ID, unique under Project.
        :param pulumi.Input['AlertConfigurationArgs'] configuration: Detailed configuration of alarm monitoring rules. See `configuration` below.
        :param pulumi.Input[_builtins.str] display_name: Display name of the alarm rule.
        :param pulumi.Input[_builtins.str] project_name: Project Name.
        :param pulumi.Input['AlertScheduleArgs'] schedule: Check the frequency-dependent configuration. See `schedule` below.
        :param pulumi.Input[_builtins.str] description: Compatible fields, set to empty strings.
        :param pulumi.Input[_builtins.str] status: Resource attribute field representing alarm status.
        """
        pulumi.set(__self__, "alert_name", alert_name)
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "schedule", schedule)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="alertName")
    def alert_name(self) -> pulumi.Input[_builtins.str]:
        """
        Alert rule ID, unique under Project.
        """
        return pulumi.get(self, "alert_name")

    @alert_name.setter
    def alert_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "alert_name", value)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> pulumi.Input['AlertConfigurationArgs']:
        """
        Detailed configuration of alarm monitoring rules. See `configuration` below.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input['AlertConfigurationArgs']):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Display name of the alarm rule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Input[_builtins.str]:
        """
        Project Name.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_name", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Input['AlertScheduleArgs']:
        """
        Check the frequency-dependent configuration. See `schedule` below.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input['AlertScheduleArgs']):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Compatible fields, set to empty strings.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource attribute field representing alarm status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _AlertState:
    def __init__(__self__, *,
                 alert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input['AlertConfigurationArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input['AlertScheduleArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Alert resources.
        :param pulumi.Input[_builtins.str] alert_name: Alert rule ID, unique under Project.
        :param pulumi.Input['AlertConfigurationArgs'] configuration: Detailed configuration of alarm monitoring rules. See `configuration` below.
        :param pulumi.Input[_builtins.int] create_time: Alarm rule creation time.
        :param pulumi.Input[_builtins.str] description: Compatible fields, set to empty strings.
        :param pulumi.Input[_builtins.str] display_name: Display name of the alarm rule.
        :param pulumi.Input[_builtins.str] project_name: Project Name.
        :param pulumi.Input['AlertScheduleArgs'] schedule: Check the frequency-dependent configuration. See `schedule` below.
        :param pulumi.Input[_builtins.str] status: Resource attribute field representing alarm status.
        """
        if alert_name is not None:
            pulumi.set(__self__, "alert_name", alert_name)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="alertName")
    def alert_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alert rule ID, unique under Project.
        """
        return pulumi.get(self, "alert_name")

    @alert_name.setter
    def alert_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_name", value)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['AlertConfigurationArgs']]:
        """
        Detailed configuration of alarm monitoring rules. See `configuration` below.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['AlertConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Alarm rule creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Compatible fields, set to empty strings.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name of the alarm rule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project Name.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_name", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['AlertScheduleArgs']]:
        """
        Check the frequency-dependent configuration. See `schedule` below.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['AlertScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource attribute field representing alarm status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:sls/alert:Alert")
class Alert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Union['AlertConfigurationArgs', 'AlertConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['AlertScheduleArgs', 'AlertScheduleArgsDict']]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a SLS Alert resource.

        For information about SLS Alert and how to use it, see [What is Alert](https://www.alibabacloud.com/help/en/doc-detail/209202.html).

        > **NOTE:** Available since v1.223.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        alert_name = config.get("alertName")
        if alert_name is None:
            alert_name = "openapi-terraform-alert"
        project_name = config.get("projectName")
        if project_name is None:
            project_name = "terraform-alert-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_ins_mgl = alicloud.log.Project("defaultINsMgl",
            description=f"{project_name}-{default['result']}",
            project_name=f"{project_name}-{default['result']}")
        default_alert = alicloud.sls.Alert("default",
            schedule={
                "type": "FixedRate",
                "run_immdiately": True,
                "interval": "1m",
                "time_zone": "+0800",
                "delay": 10,
            },
            display_name="openapi-terraform",
            description="create alert",
            status="ENABLED",
            configuration={
                "group_configuration": {
                    "fields": [
                        "a",
                        "b",
                    ],
                    "type": "no_group",
                },
                "no_data_fire": False,
                "version": "2",
                "severity_configurations": [{
                    "severity": 6,
                    "eval_condition": {
                        "count_condition": "cnt > 0",
                        "condition": "__count__ > 1",
                    },
                }],
                "labels": [{
                    "key": "a",
                    "value": "b",
                }],
                "auto_annotation": True,
                "template_configuration": {
                    "lang": "cn",
                    "tokens": {
                        "a": "b",
                    },
                    "annotations": {
                        "x": "y",
                    },
                    "template_id": "sls.app.ack.autoscaler.cluster_unhealthy",
                    "type": "sys",
                    "version": "1.0",
                },
                "mute_until": 0,
                "annotations": [{
                    "key": "x",
                    "value": "y",
                }],
                "send_resolved": False,
                "threshold": 1,
                "sink_cms": {
                    "enabled": False,
                },
                "condition_configuration": {
                    "condition": "cnt > 3",
                    "count_condition": "__count__ < 3",
                },
                "policy_configuration": {
                    "alert_policy_id": "sls.builtin.dynamic",
                    "action_policy_id": "wkb-action",
                    "repeat_interval": "1m",
                },
                "dashboard": "internal-alert",
                "type": "tpl",
                "query_lists": [
                    {
                        "ui": "{}",
                        "role_arn": "acs:ram::1654218965343050:role/aliyunslsalertmonitorrole",
                        "query": "* | select *",
                        "time_span_type": "Relative",
                        "project": default_ins_mgl.project_name,
                        "power_sql_mode": "disable",
                        "dashboard_id": "wkb-dashboard",
                        "chart_title": "wkb-chart",
                        "start": "-15m",
                        "end": "now",
                        "store_type": "log",
                        "store": "alert",
                        "region": "cn-shanghai",
                    },
                    {
                        "store_type": "meta",
                        "store": "user.rds_ip_whitelist",
                    },
                    {
                        "store_type": "meta",
                        "store": "myexample1",
                    },
                ],
                "join_configurations": [
                    {
                        "type": "no_join",
                        "condition": "aa",
                    },
                    {
                        "type": "cross_join",
                        "condition": "qqq",
                    },
                    {
                        "type": "inner_join",
                        "condition": "fefefe",
                    },
                ],
                "sink_event_store": {
                    "enabled": True,
                    "endpoint": "cn-shanghai-intranet.log.aliyuncs.com",
                    "project": "wkb-wangren",
                    "event_store": "alert",
                    "role_arn": "acs:ram::1654218965343050:role/aliyunlogetlrole",
                },
                "sink_alerthub": {
                    "enabled": False,
                },
                "no_data_severity": 6,
                "tags": [
                    "wkb",
                    "wangren",
                    "sls",
                ],
            },
            alert_name=alert_name,
            project_name=default_ins_mgl.project_name)
        ```

        ## Import

        SLS Alert can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sls/alert:Alert example <project_name>:<alert_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alert_name: Alert rule ID, unique under Project.
        :param pulumi.Input[Union['AlertConfigurationArgs', 'AlertConfigurationArgsDict']] configuration: Detailed configuration of alarm monitoring rules. See `configuration` below.
        :param pulumi.Input[_builtins.str] description: Compatible fields, set to empty strings.
        :param pulumi.Input[_builtins.str] display_name: Display name of the alarm rule.
        :param pulumi.Input[_builtins.str] project_name: Project Name.
        :param pulumi.Input[Union['AlertScheduleArgs', 'AlertScheduleArgsDict']] schedule: Check the frequency-dependent configuration. See `schedule` below.
        :param pulumi.Input[_builtins.str] status: Resource attribute field representing alarm status.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a SLS Alert resource.

        For information about SLS Alert and how to use it, see [What is Alert](https://www.alibabacloud.com/help/en/doc-detail/209202.html).

        > **NOTE:** Available since v1.223.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        alert_name = config.get("alertName")
        if alert_name is None:
            alert_name = "openapi-terraform-alert"
        project_name = config.get("projectName")
        if project_name is None:
            project_name = "terraform-alert-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_ins_mgl = alicloud.log.Project("defaultINsMgl",
            description=f"{project_name}-{default['result']}",
            project_name=f"{project_name}-{default['result']}")
        default_alert = alicloud.sls.Alert("default",
            schedule={
                "type": "FixedRate",
                "run_immdiately": True,
                "interval": "1m",
                "time_zone": "+0800",
                "delay": 10,
            },
            display_name="openapi-terraform",
            description="create alert",
            status="ENABLED",
            configuration={
                "group_configuration": {
                    "fields": [
                        "a",
                        "b",
                    ],
                    "type": "no_group",
                },
                "no_data_fire": False,
                "version": "2",
                "severity_configurations": [{
                    "severity": 6,
                    "eval_condition": {
                        "count_condition": "cnt > 0",
                        "condition": "__count__ > 1",
                    },
                }],
                "labels": [{
                    "key": "a",
                    "value": "b",
                }],
                "auto_annotation": True,
                "template_configuration": {
                    "lang": "cn",
                    "tokens": {
                        "a": "b",
                    },
                    "annotations": {
                        "x": "y",
                    },
                    "template_id": "sls.app.ack.autoscaler.cluster_unhealthy",
                    "type": "sys",
                    "version": "1.0",
                },
                "mute_until": 0,
                "annotations": [{
                    "key": "x",
                    "value": "y",
                }],
                "send_resolved": False,
                "threshold": 1,
                "sink_cms": {
                    "enabled": False,
                },
                "condition_configuration": {
                    "condition": "cnt > 3",
                    "count_condition": "__count__ < 3",
                },
                "policy_configuration": {
                    "alert_policy_id": "sls.builtin.dynamic",
                    "action_policy_id": "wkb-action",
                    "repeat_interval": "1m",
                },
                "dashboard": "internal-alert",
                "type": "tpl",
                "query_lists": [
                    {
                        "ui": "{}",
                        "role_arn": "acs:ram::1654218965343050:role/aliyunslsalertmonitorrole",
                        "query": "* | select *",
                        "time_span_type": "Relative",
                        "project": default_ins_mgl.project_name,
                        "power_sql_mode": "disable",
                        "dashboard_id": "wkb-dashboard",
                        "chart_title": "wkb-chart",
                        "start": "-15m",
                        "end": "now",
                        "store_type": "log",
                        "store": "alert",
                        "region": "cn-shanghai",
                    },
                    {
                        "store_type": "meta",
                        "store": "user.rds_ip_whitelist",
                    },
                    {
                        "store_type": "meta",
                        "store": "myexample1",
                    },
                ],
                "join_configurations": [
                    {
                        "type": "no_join",
                        "condition": "aa",
                    },
                    {
                        "type": "cross_join",
                        "condition": "qqq",
                    },
                    {
                        "type": "inner_join",
                        "condition": "fefefe",
                    },
                ],
                "sink_event_store": {
                    "enabled": True,
                    "endpoint": "cn-shanghai-intranet.log.aliyuncs.com",
                    "project": "wkb-wangren",
                    "event_store": "alert",
                    "role_arn": "acs:ram::1654218965343050:role/aliyunlogetlrole",
                },
                "sink_alerthub": {
                    "enabled": False,
                },
                "no_data_severity": 6,
                "tags": [
                    "wkb",
                    "wangren",
                    "sls",
                ],
            },
            alert_name=alert_name,
            project_name=default_ins_mgl.project_name)
        ```

        ## Import

        SLS Alert can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sls/alert:Alert example <project_name>:<alert_name>
        ```

        :param str resource_name: The name of the resource.
        :param AlertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Union['AlertConfigurationArgs', 'AlertConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['AlertScheduleArgs', 'AlertScheduleArgsDict']]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertArgs.__new__(AlertArgs)

            if alert_name is None and not opts.urn:
                raise TypeError("Missing required property 'alert_name'")
            __props__.__dict__["alert_name"] = alert_name
            if configuration is None and not opts.urn:
                raise TypeError("Missing required property 'configuration'")
            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if project_name is None and not opts.urn:
                raise TypeError("Missing required property 'project_name'")
            __props__.__dict__["project_name"] = project_name
            if schedule is None and not opts.urn:
                raise TypeError("Missing required property 'schedule'")
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["status"] = status
            __props__.__dict__["create_time"] = None
        super(Alert, __self__).__init__(
            'alicloud:sls/alert:Alert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_name: Optional[pulumi.Input[_builtins.str]] = None,
            configuration: Optional[pulumi.Input[Union['AlertConfigurationArgs', 'AlertConfigurationArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            project_name: Optional[pulumi.Input[_builtins.str]] = None,
            schedule: Optional[pulumi.Input[Union['AlertScheduleArgs', 'AlertScheduleArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'Alert':
        """
        Get an existing Alert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alert_name: Alert rule ID, unique under Project.
        :param pulumi.Input[Union['AlertConfigurationArgs', 'AlertConfigurationArgsDict']] configuration: Detailed configuration of alarm monitoring rules. See `configuration` below.
        :param pulumi.Input[_builtins.int] create_time: Alarm rule creation time.
        :param pulumi.Input[_builtins.str] description: Compatible fields, set to empty strings.
        :param pulumi.Input[_builtins.str] display_name: Display name of the alarm rule.
        :param pulumi.Input[_builtins.str] project_name: Project Name.
        :param pulumi.Input[Union['AlertScheduleArgs', 'AlertScheduleArgsDict']] schedule: Check the frequency-dependent configuration. See `schedule` below.
        :param pulumi.Input[_builtins.str] status: Resource attribute field representing alarm status.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertState.__new__(_AlertState)

        __props__.__dict__["alert_name"] = alert_name
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["status"] = status
        return Alert(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alertName")
    def alert_name(self) -> pulumi.Output[_builtins.str]:
        """
        Alert rule ID, unique under Project.
        """
        return pulumi.get(self, "alert_name")

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> pulumi.Output['outputs.AlertConfiguration']:
        """
        Detailed configuration of alarm monitoring rules. See `configuration` below.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        """
        Alarm rule creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Compatible fields, set to empty strings.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Display name of the alarm rule.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[_builtins.str]:
        """
        Project Name.
        """
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Output['outputs.AlertSchedule']:
        """
        Check the frequency-dependent configuration. See `schedule` below.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Resource attribute field representing alarm status.
        """
        return pulumi.get(self, "status")

