# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetIndexsResult',
    'AwaitableGetIndexsResult',
    'get_indexs',
    'get_indexs_output',
]

@pulumi.output_type
class GetIndexsResult:
    """
    A collection of values returned by getIndexs.
    """
    def __init__(__self__, id=None, ids=None, indexs=None, logstore_name=None, output_file=None, project_name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if indexs and not isinstance(indexs, list):
            raise TypeError("Expected argument 'indexs' to be a list")
        pulumi.set(__self__, "indexs", indexs)
        if logstore_name and not isinstance(logstore_name, str):
            raise TypeError("Expected argument 'logstore_name' to be a str")
        pulumi.set(__self__, "logstore_name", logstore_name)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Index IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def indexs(self) -> Sequence['outputs.GetIndexsIndexResult']:
        """
        A list of Index Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "indexs")

    @_builtins.property
    @pulumi.getter(name="logstoreName")
    def logstore_name(self) -> _builtins.str:
        return pulumi.get(self, "logstore_name")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> _builtins.str:
        return pulumi.get(self, "project_name")


class AwaitableGetIndexsResult(GetIndexsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIndexsResult(
            id=self.id,
            ids=self.ids,
            indexs=self.indexs,
            logstore_name=self.logstore_name,
            output_file=self.output_file,
            project_name=self.project_name)


def get_indexs(ids: Optional[Sequence[_builtins.str]] = None,
               logstore_name: Optional[_builtins.str] = None,
               output_file: Optional[_builtins.str] = None,
               project_name: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIndexsResult:
    """
    This data source provides Sls Index available to the user.[What is Index](https://next.api.alibabacloud.com/document/Sls/2020-12-30/CreateIndex)

    > **NOTE:** Available since v1.262.0.

    ## Example Usage

    ```python
    import pulumi
    import json
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    logstore_name = config.get("logstoreName")
    if logstore_name is None:
        logstore_name = "logstore-example-1"
    project_name = config.get("projectName")
    if project_name is None:
        project_name = "project-for-index-terraform-example-1"
    default_project = alicloud.log.Project("default",
        description="terraform example",
        project_name=project_name)
    default_store = alicloud.log.Store("default",
        hot_ttl=7,
        retention_period=30,
        shard_count=2,
        project_name=default_project.project_name,
        logstore_name=logstore_name)
    default_index = alicloud.sls.Index("default",
        line={
            "chn": True,
            "case_sensitive": True,
            "tokens": ["a"],
            "exclude_keys": ["t"],
        },
        keys=json.dumps({
            "example": {
                "caseSensitive": False,
                "token": [
                    "\\n",
                    "\\x09",
                    ",",
                    " ",
                    ";",
                    "\\"",
                    "'",
                    "(",
                    ")",
                    "{",
                    "}",
                    "[",
                    "]",
                    "<",
                    ">",
                    "?",
                    "/",
                    "#",
                    ":",
                ],
                "type": "text",
                "doc_value": False,
                "alias": "",
                "chn": False,
            },
        }),
        logstore_name=default_store.logstore_name,
        project_name=project_name)
    default = alicloud.sls.get_indexs_output(logstore_name=default_store.logstore_name,
        project_name=default_project.project_name)
    pulumi.export("alicloudSlsIndexExampleId", default.indexs[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Index IDs. The value is formulated as `<project_name>:<logstore_name>`.
    :param _builtins.str logstore_name: Logstore name
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str project_name: Project name
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['logstoreName'] = logstore_name
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:sls/getIndexs:getIndexs', __args__, opts=opts, typ=GetIndexsResult).value

    return AwaitableGetIndexsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        indexs=pulumi.get(__ret__, 'indexs'),
        logstore_name=pulumi.get(__ret__, 'logstore_name'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project_name=pulumi.get(__ret__, 'project_name'))
def get_indexs_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                      logstore_name: Optional[pulumi.Input[_builtins.str]] = None,
                      output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      project_name: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIndexsResult]:
    """
    This data source provides Sls Index available to the user.[What is Index](https://next.api.alibabacloud.com/document/Sls/2020-12-30/CreateIndex)

    > **NOTE:** Available since v1.262.0.

    ## Example Usage

    ```python
    import pulumi
    import json
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    logstore_name = config.get("logstoreName")
    if logstore_name is None:
        logstore_name = "logstore-example-1"
    project_name = config.get("projectName")
    if project_name is None:
        project_name = "project-for-index-terraform-example-1"
    default_project = alicloud.log.Project("default",
        description="terraform example",
        project_name=project_name)
    default_store = alicloud.log.Store("default",
        hot_ttl=7,
        retention_period=30,
        shard_count=2,
        project_name=default_project.project_name,
        logstore_name=logstore_name)
    default_index = alicloud.sls.Index("default",
        line={
            "chn": True,
            "case_sensitive": True,
            "tokens": ["a"],
            "exclude_keys": ["t"],
        },
        keys=json.dumps({
            "example": {
                "caseSensitive": False,
                "token": [
                    "\\n",
                    "\\x09",
                    ",",
                    " ",
                    ";",
                    "\\"",
                    "'",
                    "(",
                    ")",
                    "{",
                    "}",
                    "[",
                    "]",
                    "<",
                    ">",
                    "?",
                    "/",
                    "#",
                    ":",
                ],
                "type": "text",
                "doc_value": False,
                "alias": "",
                "chn": False,
            },
        }),
        logstore_name=default_store.logstore_name,
        project_name=project_name)
    default = alicloud.sls.get_indexs_output(logstore_name=default_store.logstore_name,
        project_name=default_project.project_name)
    pulumi.export("alicloudSlsIndexExampleId", default.indexs[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Index IDs. The value is formulated as `<project_name>:<logstore_name>`.
    :param _builtins.str logstore_name: Logstore name
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str project_name: Project name
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['logstoreName'] = logstore_name
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:sls/getIndexs:getIndexs', __args__, opts=opts, typ=GetIndexsResult)
    return __ret__.apply(lambda __response__: GetIndexsResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        indexs=pulumi.get(__response__, 'indexs'),
        logstore_name=pulumi.get(__response__, 'logstore_name'),
        output_file=pulumi.get(__response__, 'output_file'),
        project_name=pulumi.get(__response__, 'project_name')))
