# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IndexArgs', 'Index']

@pulumi.input_type
class IndexArgs:
    def __init__(__self__, *,
                 logstore_name: pulumi.Input[_builtins.str],
                 project_name: pulumi.Input[_builtins.str],
                 keys: Optional[pulumi.Input[_builtins.str]] = None,
                 line: Optional[pulumi.Input['IndexLineArgs']] = None,
                 log_reduce: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_reduce_black_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_reduce_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_text_len: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Index resource.
        :param pulumi.Input[_builtins.str] logstore_name: Logstore name
        :param pulumi.Input[_builtins.str] project_name: Project name
        :param pulumi.Input[_builtins.str] keys: Field index
        :param pulumi.Input['IndexLineArgs'] line: Full-text index See `line` below.
        :param pulumi.Input[_builtins.bool] log_reduce: Whether log clustering is enabled
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] log_reduce_black_lists: The blacklist of the cluster fields of log clustering is filtered only when log clustering is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] log_reduce_white_lists: The whitelist of the cluster fields for log clustering. This filter is valid only when log clustering is enabled.
        :param pulumi.Input[_builtins.int] max_text_len: Maximum length of statistical field
        """
        pulumi.set(__self__, "logstore_name", logstore_name)
        pulumi.set(__self__, "project_name", project_name)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if line is not None:
            pulumi.set(__self__, "line", line)
        if log_reduce is not None:
            pulumi.set(__self__, "log_reduce", log_reduce)
        if log_reduce_black_lists is not None:
            pulumi.set(__self__, "log_reduce_black_lists", log_reduce_black_lists)
        if log_reduce_white_lists is not None:
            pulumi.set(__self__, "log_reduce_white_lists", log_reduce_white_lists)
        if max_text_len is not None:
            pulumi.set(__self__, "max_text_len", max_text_len)

    @_builtins.property
    @pulumi.getter(name="logstoreName")
    def logstore_name(self) -> pulumi.Input[_builtins.str]:
        """
        Logstore name
        """
        return pulumi.get(self, "logstore_name")

    @logstore_name.setter
    def logstore_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "logstore_name", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Input[_builtins.str]:
        """
        Project name
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_name", value)

    @_builtins.property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field index
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "keys", value)

    @_builtins.property
    @pulumi.getter
    def line(self) -> Optional[pulumi.Input['IndexLineArgs']]:
        """
        Full-text index See `line` below.
        """
        return pulumi.get(self, "line")

    @line.setter
    def line(self, value: Optional[pulumi.Input['IndexLineArgs']]):
        pulumi.set(self, "line", value)

    @_builtins.property
    @pulumi.getter(name="logReduce")
    def log_reduce(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether log clustering is enabled
        """
        return pulumi.get(self, "log_reduce")

    @log_reduce.setter
    def log_reduce(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_reduce", value)

    @_builtins.property
    @pulumi.getter(name="logReduceBlackLists")
    def log_reduce_black_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The blacklist of the cluster fields of log clustering is filtered only when log clustering is enabled.
        """
        return pulumi.get(self, "log_reduce_black_lists")

    @log_reduce_black_lists.setter
    def log_reduce_black_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "log_reduce_black_lists", value)

    @_builtins.property
    @pulumi.getter(name="logReduceWhiteLists")
    def log_reduce_white_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The whitelist of the cluster fields for log clustering. This filter is valid only when log clustering is enabled.
        """
        return pulumi.get(self, "log_reduce_white_lists")

    @log_reduce_white_lists.setter
    def log_reduce_white_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "log_reduce_white_lists", value)

    @_builtins.property
    @pulumi.getter(name="maxTextLen")
    def max_text_len(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum length of statistical field
        """
        return pulumi.get(self, "max_text_len")

    @max_text_len.setter
    def max_text_len(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_text_len", value)


@pulumi.input_type
class _IndexState:
    def __init__(__self__, *,
                 keys: Optional[pulumi.Input[_builtins.str]] = None,
                 line: Optional[pulumi.Input['IndexLineArgs']] = None,
                 log_reduce: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_reduce_black_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_reduce_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 logstore_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_text_len: Optional[pulumi.Input[_builtins.int]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Index resources.
        :param pulumi.Input[_builtins.str] keys: Field index
        :param pulumi.Input['IndexLineArgs'] line: Full-text index See `line` below.
        :param pulumi.Input[_builtins.bool] log_reduce: Whether log clustering is enabled
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] log_reduce_black_lists: The blacklist of the cluster fields of log clustering is filtered only when log clustering is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] log_reduce_white_lists: The whitelist of the cluster fields for log clustering. This filter is valid only when log clustering is enabled.
        :param pulumi.Input[_builtins.str] logstore_name: Logstore name
        :param pulumi.Input[_builtins.int] max_text_len: Maximum length of statistical field
        :param pulumi.Input[_builtins.str] project_name: Project name
        """
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if line is not None:
            pulumi.set(__self__, "line", line)
        if log_reduce is not None:
            pulumi.set(__self__, "log_reduce", log_reduce)
        if log_reduce_black_lists is not None:
            pulumi.set(__self__, "log_reduce_black_lists", log_reduce_black_lists)
        if log_reduce_white_lists is not None:
            pulumi.set(__self__, "log_reduce_white_lists", log_reduce_white_lists)
        if logstore_name is not None:
            pulumi.set(__self__, "logstore_name", logstore_name)
        if max_text_len is not None:
            pulumi.set(__self__, "max_text_len", max_text_len)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)

    @_builtins.property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field index
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "keys", value)

    @_builtins.property
    @pulumi.getter
    def line(self) -> Optional[pulumi.Input['IndexLineArgs']]:
        """
        Full-text index See `line` below.
        """
        return pulumi.get(self, "line")

    @line.setter
    def line(self, value: Optional[pulumi.Input['IndexLineArgs']]):
        pulumi.set(self, "line", value)

    @_builtins.property
    @pulumi.getter(name="logReduce")
    def log_reduce(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether log clustering is enabled
        """
        return pulumi.get(self, "log_reduce")

    @log_reduce.setter
    def log_reduce(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_reduce", value)

    @_builtins.property
    @pulumi.getter(name="logReduceBlackLists")
    def log_reduce_black_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The blacklist of the cluster fields of log clustering is filtered only when log clustering is enabled.
        """
        return pulumi.get(self, "log_reduce_black_lists")

    @log_reduce_black_lists.setter
    def log_reduce_black_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "log_reduce_black_lists", value)

    @_builtins.property
    @pulumi.getter(name="logReduceWhiteLists")
    def log_reduce_white_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The whitelist of the cluster fields for log clustering. This filter is valid only when log clustering is enabled.
        """
        return pulumi.get(self, "log_reduce_white_lists")

    @log_reduce_white_lists.setter
    def log_reduce_white_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "log_reduce_white_lists", value)

    @_builtins.property
    @pulumi.getter(name="logstoreName")
    def logstore_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Logstore name
        """
        return pulumi.get(self, "logstore_name")

    @logstore_name.setter
    def logstore_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logstore_name", value)

    @_builtins.property
    @pulumi.getter(name="maxTextLen")
    def max_text_len(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum length of statistical field
        """
        return pulumi.get(self, "max_text_len")

    @max_text_len.setter
    def max_text_len(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_text_len", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project name
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_name", value)


@pulumi.type_token("alicloud:sls/index:Index")
class Index(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 keys: Optional[pulumi.Input[_builtins.str]] = None,
                 line: Optional[pulumi.Input[Union['IndexLineArgs', 'IndexLineArgsDict']]] = None,
                 log_reduce: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_reduce_black_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_reduce_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 logstore_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_text_len: Optional[pulumi.Input[_builtins.int]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Log Service (SLS) Index resource.

        For information about Log Service (SLS) Index and how to use it, see [What is Index](https://next.api.alibabacloud.com/document/Sls/2020-12-30/CreateIndex).

        > **NOTE:** Available since v1.260.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        logstore_name = config.get("logstoreName")
        if logstore_name is None:
            logstore_name = "logstore-example"
        project_name = config.get("projectName")
        if project_name is None:
            project_name = "project-for-index-terraform-example"
        default = alicloud.log.Project("default",
            description="terraform example",
            project_name=project_name)
        default_store = alicloud.log.Store("default",
            hot_ttl=7,
            retention_period=30,
            shard_count=2,
            project_name=default.project_name,
            logstore_name=logstore_name)
        default_index = alicloud.sls.Index("default",
            line={
                "chn": True,
                "case_sensitive": True,
                "tokens": ["a"],
                "exclude_keys": ["t"],
            },
            keys=json.dumps({
                "example": {
                    "caseSensitive": False,
                    "token": [
                        "\\n",
                        "\\x09",
                        ",",
                        " ",
                        ";",
                        "\\"",
                        "'",
                        "(",
                        ")",
                        "{",
                        "}",
                        "[",
                        "]",
                        "<",
                        ">",
                        "?",
                        "/",
                        "#",
                        ":",
                    ],
                    "type": "text",
                    "doc_value": False,
                    "alias": "",
                    "chn": False,
                },
            }),
            logstore_name=default_store.logstore_name,
            project_name=project_name)
        ```

        ## Import

        Log Service (SLS) Index can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sls/index:Index example <project_name>:<logstore_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] keys: Field index
        :param pulumi.Input[Union['IndexLineArgs', 'IndexLineArgsDict']] line: Full-text index See `line` below.
        :param pulumi.Input[_builtins.bool] log_reduce: Whether log clustering is enabled
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] log_reduce_black_lists: The blacklist of the cluster fields of log clustering is filtered only when log clustering is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] log_reduce_white_lists: The whitelist of the cluster fields for log clustering. This filter is valid only when log clustering is enabled.
        :param pulumi.Input[_builtins.str] logstore_name: Logstore name
        :param pulumi.Input[_builtins.int] max_text_len: Maximum length of statistical field
        :param pulumi.Input[_builtins.str] project_name: Project name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IndexArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Log Service (SLS) Index resource.

        For information about Log Service (SLS) Index and how to use it, see [What is Index](https://next.api.alibabacloud.com/document/Sls/2020-12-30/CreateIndex).

        > **NOTE:** Available since v1.260.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        logstore_name = config.get("logstoreName")
        if logstore_name is None:
            logstore_name = "logstore-example"
        project_name = config.get("projectName")
        if project_name is None:
            project_name = "project-for-index-terraform-example"
        default = alicloud.log.Project("default",
            description="terraform example",
            project_name=project_name)
        default_store = alicloud.log.Store("default",
            hot_ttl=7,
            retention_period=30,
            shard_count=2,
            project_name=default.project_name,
            logstore_name=logstore_name)
        default_index = alicloud.sls.Index("default",
            line={
                "chn": True,
                "case_sensitive": True,
                "tokens": ["a"],
                "exclude_keys": ["t"],
            },
            keys=json.dumps({
                "example": {
                    "caseSensitive": False,
                    "token": [
                        "\\n",
                        "\\x09",
                        ",",
                        " ",
                        ";",
                        "\\"",
                        "'",
                        "(",
                        ")",
                        "{",
                        "}",
                        "[",
                        "]",
                        "<",
                        ">",
                        "?",
                        "/",
                        "#",
                        ":",
                    ],
                    "type": "text",
                    "doc_value": False,
                    "alias": "",
                    "chn": False,
                },
            }),
            logstore_name=default_store.logstore_name,
            project_name=project_name)
        ```

        ## Import

        Log Service (SLS) Index can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sls/index:Index example <project_name>:<logstore_name>
        ```

        :param str resource_name: The name of the resource.
        :param IndexArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IndexArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 keys: Optional[pulumi.Input[_builtins.str]] = None,
                 line: Optional[pulumi.Input[Union['IndexLineArgs', 'IndexLineArgsDict']]] = None,
                 log_reduce: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_reduce_black_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_reduce_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 logstore_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_text_len: Optional[pulumi.Input[_builtins.int]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IndexArgs.__new__(IndexArgs)

            __props__.__dict__["keys"] = keys
            __props__.__dict__["line"] = line
            __props__.__dict__["log_reduce"] = log_reduce
            __props__.__dict__["log_reduce_black_lists"] = log_reduce_black_lists
            __props__.__dict__["log_reduce_white_lists"] = log_reduce_white_lists
            if logstore_name is None and not opts.urn:
                raise TypeError("Missing required property 'logstore_name'")
            __props__.__dict__["logstore_name"] = logstore_name
            __props__.__dict__["max_text_len"] = max_text_len
            if project_name is None and not opts.urn:
                raise TypeError("Missing required property 'project_name'")
            __props__.__dict__["project_name"] = project_name
        super(Index, __self__).__init__(
            'alicloud:sls/index:Index',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            keys: Optional[pulumi.Input[_builtins.str]] = None,
            line: Optional[pulumi.Input[Union['IndexLineArgs', 'IndexLineArgsDict']]] = None,
            log_reduce: Optional[pulumi.Input[_builtins.bool]] = None,
            log_reduce_black_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            log_reduce_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            logstore_name: Optional[pulumi.Input[_builtins.str]] = None,
            max_text_len: Optional[pulumi.Input[_builtins.int]] = None,
            project_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'Index':
        """
        Get an existing Index resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] keys: Field index
        :param pulumi.Input[Union['IndexLineArgs', 'IndexLineArgsDict']] line: Full-text index See `line` below.
        :param pulumi.Input[_builtins.bool] log_reduce: Whether log clustering is enabled
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] log_reduce_black_lists: The blacklist of the cluster fields of log clustering is filtered only when log clustering is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] log_reduce_white_lists: The whitelist of the cluster fields for log clustering. This filter is valid only when log clustering is enabled.
        :param pulumi.Input[_builtins.str] logstore_name: Logstore name
        :param pulumi.Input[_builtins.int] max_text_len: Maximum length of statistical field
        :param pulumi.Input[_builtins.str] project_name: Project name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IndexState.__new__(_IndexState)

        __props__.__dict__["keys"] = keys
        __props__.__dict__["line"] = line
        __props__.__dict__["log_reduce"] = log_reduce
        __props__.__dict__["log_reduce_black_lists"] = log_reduce_black_lists
        __props__.__dict__["log_reduce_white_lists"] = log_reduce_white_lists
        __props__.__dict__["logstore_name"] = logstore_name
        __props__.__dict__["max_text_len"] = max_text_len
        __props__.__dict__["project_name"] = project_name
        return Index(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def keys(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Field index
        """
        return pulumi.get(self, "keys")

    @_builtins.property
    @pulumi.getter
    def line(self) -> pulumi.Output[Optional['outputs.IndexLine']]:
        """
        Full-text index See `line` below.
        """
        return pulumi.get(self, "line")

    @_builtins.property
    @pulumi.getter(name="logReduce")
    def log_reduce(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether log clustering is enabled
        """
        return pulumi.get(self, "log_reduce")

    @_builtins.property
    @pulumi.getter(name="logReduceBlackLists")
    def log_reduce_black_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The blacklist of the cluster fields of log clustering is filtered only when log clustering is enabled.
        """
        return pulumi.get(self, "log_reduce_black_lists")

    @_builtins.property
    @pulumi.getter(name="logReduceWhiteLists")
    def log_reduce_white_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The whitelist of the cluster fields for log clustering. This filter is valid only when log clustering is enabled.
        """
        return pulumi.get(self, "log_reduce_white_lists")

    @_builtins.property
    @pulumi.getter(name="logstoreName")
    def logstore_name(self) -> pulumi.Output[_builtins.str]:
        """
        Logstore name
        """
        return pulumi.get(self, "logstore_name")

    @_builtins.property
    @pulumi.getter(name="maxTextLen")
    def max_text_len(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum length of statistical field
        """
        return pulumi.get(self, "max_text_len")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[_builtins.str]:
        """
        Project name
        """
        return pulumi.get(self, "project_name")

