# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AlertConfiguration',
    'AlertConfigurationAnnotation',
    'AlertConfigurationConditionConfiguration',
    'AlertConfigurationGroupConfiguration',
    'AlertConfigurationJoinConfiguration',
    'AlertConfigurationLabel',
    'AlertConfigurationPolicyConfiguration',
    'AlertConfigurationQueryList',
    'AlertConfigurationSeverityConfiguration',
    'AlertConfigurationSeverityConfigurationEvalCondition',
    'AlertConfigurationSinkAlerthub',
    'AlertConfigurationSinkCms',
    'AlertConfigurationSinkEventStore',
    'AlertConfigurationTemplateConfiguration',
    'AlertSchedule',
    'CollectionPolicyCentralizeConfig',
    'CollectionPolicyDataConfig',
    'CollectionPolicyPolicyConfig',
    'CollectionPolicyResourceDirectory',
    'EtlConfiguration',
    'EtlConfigurationSink',
    'IndexLine',
    'LogtailConfigOutputDetail',
    'MachineGroupGroupAttribute',
    'OssExportSinkConfiguration',
    'OssExportSinkConfigurationSink',
    'ScheduledSqlSchedule',
    'ScheduledSqlScheduledSqlConfiguration',
    'GetAlertsAlertResult',
    'GetAlertsAlertConfigurationResult',
    'GetAlertsAlertConfigurationAnnotationResult',
    'GetAlertsAlertConfigurationConditionConfigurationResult',
    'GetAlertsAlertConfigurationGroupConfigurationResult',
    'GetAlertsAlertConfigurationJoinConfigurationResult',
    'GetAlertsAlertConfigurationLabelResult',
    'GetAlertsAlertConfigurationPolicyConfigurationResult',
    'GetAlertsAlertConfigurationQueryListResult',
    'GetAlertsAlertConfigurationSeverityConfigurationResult',
    'GetAlertsAlertConfigurationSeverityConfigurationEvalConditionResult',
    'GetAlertsAlertConfigurationSinkAlerthubResult',
    'GetAlertsAlertConfigurationSinkCmsResult',
    'GetAlertsAlertConfigurationSinkEventStoreResult',
    'GetAlertsAlertConfigurationTemplateConfigurationResult',
    'GetAlertsAlertScheduleResult',
    'GetEtlsEtlResult',
    'GetEtlsEtlConfigurationResult',
    'GetEtlsEtlConfigurationSinkResult',
    'GetIndexsIndexResult',
    'GetIndexsIndexLineResult',
    'GetLogtailConfigsConfigResult',
    'GetMachineGroupsGroupResult',
]

@pulumi.output_type
class AlertConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoAnnotation":
            suggest = "auto_annotation"
        elif key == "conditionConfiguration":
            suggest = "condition_configuration"
        elif key == "groupConfiguration":
            suggest = "group_configuration"
        elif key == "joinConfigurations":
            suggest = "join_configurations"
        elif key == "muteUntil":
            suggest = "mute_until"
        elif key == "noDataFire":
            suggest = "no_data_fire"
        elif key == "noDataSeverity":
            suggest = "no_data_severity"
        elif key == "policyConfiguration":
            suggest = "policy_configuration"
        elif key == "queryLists":
            suggest = "query_lists"
        elif key == "sendResolved":
            suggest = "send_resolved"
        elif key == "severityConfigurations":
            suggest = "severity_configurations"
        elif key == "sinkAlerthub":
            suggest = "sink_alerthub"
        elif key == "sinkCms":
            suggest = "sink_cms"
        elif key == "sinkEventStore":
            suggest = "sink_event_store"
        elif key == "templateConfiguration":
            suggest = "template_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Optional[Sequence['outputs.AlertConfigurationAnnotation']] = None,
                 auto_annotation: Optional[_builtins.bool] = None,
                 condition_configuration: Optional['outputs.AlertConfigurationConditionConfiguration'] = None,
                 dashboard: Optional[_builtins.str] = None,
                 group_configuration: Optional['outputs.AlertConfigurationGroupConfiguration'] = None,
                 join_configurations: Optional[Sequence['outputs.AlertConfigurationJoinConfiguration']] = None,
                 labels: Optional[Sequence['outputs.AlertConfigurationLabel']] = None,
                 mute_until: Optional[_builtins.int] = None,
                 no_data_fire: Optional[_builtins.bool] = None,
                 no_data_severity: Optional[_builtins.int] = None,
                 policy_configuration: Optional['outputs.AlertConfigurationPolicyConfiguration'] = None,
                 query_lists: Optional[Sequence['outputs.AlertConfigurationQueryList']] = None,
                 send_resolved: Optional[_builtins.bool] = None,
                 severity_configurations: Optional[Sequence['outputs.AlertConfigurationSeverityConfiguration']] = None,
                 sink_alerthub: Optional['outputs.AlertConfigurationSinkAlerthub'] = None,
                 sink_cms: Optional['outputs.AlertConfigurationSinkCms'] = None,
                 sink_event_store: Optional['outputs.AlertConfigurationSinkEventStore'] = None,
                 tags: Optional[Sequence[_builtins.str]] = None,
                 template_configuration: Optional['outputs.AlertConfigurationTemplateConfiguration'] = None,
                 threshold: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param Sequence['AlertConfigurationAnnotationArgs'] annotations: Template Annotations.
        :param _builtins.bool auto_annotation: Whether to turn on automatic labeling. true (default): The automatic annotation function is enabled, and the system automatically adds information such as__county__to the alarm. For more information, see Automatic Labeling. false: Turn off the automatic annotation function.
        :param 'AlertConfigurationConditionConfigurationArgs' condition_configuration: Alarm trigger condition. See `condition_configuration` below.
        :param _builtins.str dashboard: The instrument cluster associated with the alarm. It is recommended to set to internal-alert-analysis.
        :param 'AlertConfigurationGroupConfigurationArgs' group_configuration: Group evaluation configuration. See `group_configuration` below.
        :param Sequence['AlertConfigurationJoinConfigurationArgs'] join_configurations: Set operation configuration. See `join_configurations` below.
        :param Sequence['AlertConfigurationLabelArgs'] labels: Label. See `labels` below.
        :param _builtins.int mute_until: Second-level timestamp representing the temporary shutdown deadline.
        :param _builtins.bool no_data_fire: Whether no data triggers an alarm. true: If the number of times the query and analysis results (if there are multiple results, the result after the collection operation) is no data exceeds the continuous trigger threshold, an alarm is generated. false (default): Turn off the no data alarm function.
        :param _builtins.int no_data_severity: Alarm severity when no data triggers an alarm.
        :param 'AlertConfigurationPolicyConfigurationArgs' policy_configuration: Alert policy configuration. See `policy_configuration` below.
        :param Sequence['AlertConfigurationQueryListArgs'] query_lists: Query the statistical list. See `query_list` below.
        :param _builtins.bool send_resolved: Whether to send a recovery notification. true: A recovery alarm is triggered when the alarm is restored. false (default): Turn off the alarm recovery notification function.
        :param Sequence['AlertConfigurationSeverityConfigurationArgs'] severity_configurations: Trigger condition, set at least one trigger condition. See `severity_configurations` below.
        :param 'AlertConfigurationSinkAlerthubArgs' sink_alerthub: Configuration of Alerts Sent to Alerthub. See `sink_alerthub` below.
        :param 'AlertConfigurationSinkCmsArgs' sink_cms: Configure alerts sent to CloudMonitor. See `sink_cms` below.
        :param 'AlertConfigurationSinkEventStoreArgs' sink_event_store: Configuration of sending alarms to EventStore. See `sink_event_store` below.
        :param Sequence[_builtins.str] tags: Customize the category of alarm monitoring rules.
        :param 'AlertConfigurationTemplateConfigurationArgs' template_configuration: Alarm rule template configuration. See `template_configuration` below.
        :param _builtins.int threshold: Set the continuous trigger threshold. When the cumulative number of triggers reaches this value, an alarm is generated. The statistics are not counted when the trigger condition is not met.
        :param _builtins.str type: Template Type.
        :param _builtins.str version: Template Version.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if auto_annotation is not None:
            pulumi.set(__self__, "auto_annotation", auto_annotation)
        if condition_configuration is not None:
            pulumi.set(__self__, "condition_configuration", condition_configuration)
        if dashboard is not None:
            pulumi.set(__self__, "dashboard", dashboard)
        if group_configuration is not None:
            pulumi.set(__self__, "group_configuration", group_configuration)
        if join_configurations is not None:
            pulumi.set(__self__, "join_configurations", join_configurations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if mute_until is not None:
            pulumi.set(__self__, "mute_until", mute_until)
        if no_data_fire is not None:
            pulumi.set(__self__, "no_data_fire", no_data_fire)
        if no_data_severity is not None:
            pulumi.set(__self__, "no_data_severity", no_data_severity)
        if policy_configuration is not None:
            pulumi.set(__self__, "policy_configuration", policy_configuration)
        if query_lists is not None:
            pulumi.set(__self__, "query_lists", query_lists)
        if send_resolved is not None:
            pulumi.set(__self__, "send_resolved", send_resolved)
        if severity_configurations is not None:
            pulumi.set(__self__, "severity_configurations", severity_configurations)
        if sink_alerthub is not None:
            pulumi.set(__self__, "sink_alerthub", sink_alerthub)
        if sink_cms is not None:
            pulumi.set(__self__, "sink_cms", sink_cms)
        if sink_event_store is not None:
            pulumi.set(__self__, "sink_event_store", sink_event_store)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_configuration is not None:
            pulumi.set(__self__, "template_configuration", template_configuration)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence['outputs.AlertConfigurationAnnotation']]:
        """
        Template Annotations.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="autoAnnotation")
    def auto_annotation(self) -> Optional[_builtins.bool]:
        """
        Whether to turn on automatic labeling. true (default): The automatic annotation function is enabled, and the system automatically adds information such as__county__to the alarm. For more information, see Automatic Labeling. false: Turn off the automatic annotation function.
        """
        return pulumi.get(self, "auto_annotation")

    @_builtins.property
    @pulumi.getter(name="conditionConfiguration")
    def condition_configuration(self) -> Optional['outputs.AlertConfigurationConditionConfiguration']:
        """
        Alarm trigger condition. See `condition_configuration` below.
        """
        return pulumi.get(self, "condition_configuration")

    @_builtins.property
    @pulumi.getter
    def dashboard(self) -> Optional[_builtins.str]:
        """
        The instrument cluster associated with the alarm. It is recommended to set to internal-alert-analysis.
        """
        return pulumi.get(self, "dashboard")

    @_builtins.property
    @pulumi.getter(name="groupConfiguration")
    def group_configuration(self) -> Optional['outputs.AlertConfigurationGroupConfiguration']:
        """
        Group evaluation configuration. See `group_configuration` below.
        """
        return pulumi.get(self, "group_configuration")

    @_builtins.property
    @pulumi.getter(name="joinConfigurations")
    def join_configurations(self) -> Optional[Sequence['outputs.AlertConfigurationJoinConfiguration']]:
        """
        Set operation configuration. See `join_configurations` below.
        """
        return pulumi.get(self, "join_configurations")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Sequence['outputs.AlertConfigurationLabel']]:
        """
        Label. See `labels` below.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="muteUntil")
    def mute_until(self) -> Optional[_builtins.int]:
        """
        Second-level timestamp representing the temporary shutdown deadline.
        """
        return pulumi.get(self, "mute_until")

    @_builtins.property
    @pulumi.getter(name="noDataFire")
    def no_data_fire(self) -> Optional[_builtins.bool]:
        """
        Whether no data triggers an alarm. true: If the number of times the query and analysis results (if there are multiple results, the result after the collection operation) is no data exceeds the continuous trigger threshold, an alarm is generated. false (default): Turn off the no data alarm function.
        """
        return pulumi.get(self, "no_data_fire")

    @_builtins.property
    @pulumi.getter(name="noDataSeverity")
    def no_data_severity(self) -> Optional[_builtins.int]:
        """
        Alarm severity when no data triggers an alarm.
        """
        return pulumi.get(self, "no_data_severity")

    @_builtins.property
    @pulumi.getter(name="policyConfiguration")
    def policy_configuration(self) -> Optional['outputs.AlertConfigurationPolicyConfiguration']:
        """
        Alert policy configuration. See `policy_configuration` below.
        """
        return pulumi.get(self, "policy_configuration")

    @_builtins.property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Optional[Sequence['outputs.AlertConfigurationQueryList']]:
        """
        Query the statistical list. See `query_list` below.
        """
        return pulumi.get(self, "query_lists")

    @_builtins.property
    @pulumi.getter(name="sendResolved")
    def send_resolved(self) -> Optional[_builtins.bool]:
        """
        Whether to send a recovery notification. true: A recovery alarm is triggered when the alarm is restored. false (default): Turn off the alarm recovery notification function.
        """
        return pulumi.get(self, "send_resolved")

    @_builtins.property
    @pulumi.getter(name="severityConfigurations")
    def severity_configurations(self) -> Optional[Sequence['outputs.AlertConfigurationSeverityConfiguration']]:
        """
        Trigger condition, set at least one trigger condition. See `severity_configurations` below.
        """
        return pulumi.get(self, "severity_configurations")

    @_builtins.property
    @pulumi.getter(name="sinkAlerthub")
    def sink_alerthub(self) -> Optional['outputs.AlertConfigurationSinkAlerthub']:
        """
        Configuration of Alerts Sent to Alerthub. See `sink_alerthub` below.
        """
        return pulumi.get(self, "sink_alerthub")

    @_builtins.property
    @pulumi.getter(name="sinkCms")
    def sink_cms(self) -> Optional['outputs.AlertConfigurationSinkCms']:
        """
        Configure alerts sent to CloudMonitor. See `sink_cms` below.
        """
        return pulumi.get(self, "sink_cms")

    @_builtins.property
    @pulumi.getter(name="sinkEventStore")
    def sink_event_store(self) -> Optional['outputs.AlertConfigurationSinkEventStore']:
        """
        Configuration of sending alarms to EventStore. See `sink_event_store` below.
        """
        return pulumi.get(self, "sink_event_store")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Customize the category of alarm monitoring rules.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="templateConfiguration")
    def template_configuration(self) -> Optional['outputs.AlertConfigurationTemplateConfiguration']:
        """
        Alarm rule template configuration. See `template_configuration` below.
        """
        return pulumi.get(self, "template_configuration")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> Optional[_builtins.int]:
        """
        Set the continuous trigger threshold. When the cumulative number of triggers reaches this value, an alarm is generated. The statistics are not counted when the trigger condition is not met.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Template Type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Template Version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class AlertConfigurationAnnotation(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: Field name.
        :param _builtins.str value: Field value.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        Field name.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Field value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AlertConfigurationConditionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countCondition":
            suggest = "count_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertConfigurationConditionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertConfigurationConditionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertConfigurationConditionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: Optional[_builtins.str] = None,
                 count_condition: Optional[_builtins.str] = None):
        """
        :param _builtins.str condition: Data matching expression. When the data content does not need to be determined, set it to an empty string. In other cases, it needs to be set as an expression, for example, errCnt> 10.
        :param _builtins.str count_condition: The number of pieces of data to determine the number of pieces of data to indicate how many pieces of data meet the conditions. If data exists, it is satisfied. Set it to an empty string. In other cases, it needs to be set as an expression, such as__count__> 3.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if count_condition is not None:
            pulumi.set(__self__, "count_condition", count_condition)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[_builtins.str]:
        """
        Data matching expression. When the data content does not need to be determined, set it to an empty string. In other cases, it needs to be set as an expression, for example, errCnt> 10.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="countCondition")
    def count_condition(self) -> Optional[_builtins.str]:
        """
        The number of pieces of data to determine the number of pieces of data to indicate how many pieces of data meet the conditions. If data exists, it is satisfied. Set it to an empty string. In other cases, it needs to be set as an expression, such as__count__> 3.
        """
        return pulumi.get(self, "count_condition")


@pulumi.output_type
class AlertConfigurationGroupConfiguration(dict):
    def __init__(__self__, *,
                 fields: Optional[Sequence[_builtins.str]] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] fields: The field used for grouping evaluation. When type is set to custom, fields must be set.
        """
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def fields(self) -> Optional[Sequence[_builtins.str]]:
        """
        The field used for grouping evaluation. When type is set to custom, fields must be set.
        """
        return pulumi.get(self, "fields")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class AlertConfigurationJoinConfiguration(dict):
    def __init__(__self__, *,
                 condition: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str condition: Data matching expression. When the data content does not need to be determined, set it to an empty string. In other cases, it needs to be set as an expression, for example, errCnt> 10.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[_builtins.str]:
        """
        Data matching expression. When the data content does not need to be determined, set it to an empty string. In other cases, it needs to be set as an expression, for example, errCnt> 10.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class AlertConfigurationLabel(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: Field name.
        :param _builtins.str value: Field value.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        Field name.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Field value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AlertConfigurationPolicyConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionPolicyId":
            suggest = "action_policy_id"
        elif key == "alertPolicyId":
            suggest = "alert_policy_id"
        elif key == "repeatInterval":
            suggest = "repeat_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertConfigurationPolicyConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertConfigurationPolicyConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertConfigurationPolicyConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_policy_id: Optional[_builtins.str] = None,
                 alert_policy_id: Optional[_builtins.str] = None,
                 repeat_interval: Optional[_builtins.str] = None):
        """
        :param _builtins.str action_policy_id: The ID of the action policy used. If the alert policy is in advanced mode and the selected alert policy is not configured with a dynamic action policy, set the actionPolicyId to an empty string.
        :param _builtins.str alert_policy_id: Alarm policy ID. If it is in simple mode or normal mode, set it to sls.builtin.dynamic (dynamic alarm policy built into the system). For advanced mode, set it to the specified alarm policy ID.
        :param _builtins.str repeat_interval: Repeat the waiting time. For example, 5m, 1H, etc.
        """
        if action_policy_id is not None:
            pulumi.set(__self__, "action_policy_id", action_policy_id)
        if alert_policy_id is not None:
            pulumi.set(__self__, "alert_policy_id", alert_policy_id)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)

    @_builtins.property
    @pulumi.getter(name="actionPolicyId")
    def action_policy_id(self) -> Optional[_builtins.str]:
        """
        The ID of the action policy used. If the alert policy is in advanced mode and the selected alert policy is not configured with a dynamic action policy, set the actionPolicyId to an empty string.
        """
        return pulumi.get(self, "action_policy_id")

    @_builtins.property
    @pulumi.getter(name="alertPolicyId")
    def alert_policy_id(self) -> Optional[_builtins.str]:
        """
        Alarm policy ID. If it is in simple mode or normal mode, set it to sls.builtin.dynamic (dynamic alarm policy built into the system). For advanced mode, set it to the specified alarm policy ID.
        """
        return pulumi.get(self, "alert_policy_id")

    @_builtins.property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[_builtins.str]:
        """
        Repeat the waiting time. For example, 5m, 1H, etc.
        """
        return pulumi.get(self, "repeat_interval")


@pulumi.output_type
class AlertConfigurationQueryList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chartTitle":
            suggest = "chart_title"
        elif key == "dashboardId":
            suggest = "dashboard_id"
        elif key == "powerSqlMode":
            suggest = "power_sql_mode"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "storeType":
            suggest = "store_type"
        elif key == "timeSpanType":
            suggest = "time_span_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertConfigurationQueryList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertConfigurationQueryList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertConfigurationQueryList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chart_title: Optional[_builtins.str] = None,
                 dashboard_id: Optional[_builtins.str] = None,
                 end: Optional[_builtins.str] = None,
                 power_sql_mode: Optional[_builtins.str] = None,
                 project: Optional[_builtins.str] = None,
                 query: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 role_arn: Optional[_builtins.str] = None,
                 start: Optional[_builtins.str] = None,
                 store: Optional[_builtins.str] = None,
                 store_type: Optional[_builtins.str] = None,
                 time_span_type: Optional[_builtins.str] = None,
                 ui: Optional[_builtins.str] = None):
        """
        :param _builtins.str chart_title: Chart Name.
        :param _builtins.str dashboard_id: Dashboard ID.
        :param _builtins.str end: End time. When storeType is set to log or metric, end must be set.
        :param _builtins.str power_sql_mode: Whether to use exclusive SQL. The value is as follows: auto: automatic switching. enable: Starts. disable: disable.
        :param _builtins.str project: Project Name.
        :param _builtins.str query: Query and analysis statements. When storeType is set to log or metric, query is set to the query analysis statement. When storeType is set to meta, set query to an empty string.
        :param _builtins.str region: Region of the target Project.
        :param _builtins.str role_arn: Roles used to write alarm data to the event Library.
        :param _builtins.str start: Start time. When storeType is set to log or metric, start must be set.
        :param _builtins.str store: Query the Logstore, Metricstore, or resource data associated with the statistics. When storeType is set to log, store is set to the target Logstore. When storeType is set to metric, store is set to the target Metricstore. When storeType is set to meta, store is set to the target resource data name.
        :param _builtins.str store_type: Query the data source type. The value is as follows: log: Logstore. metric: Time series Library. meta: resource data.
        :param _builtins.str time_span_type: Time Type.
        :param _builtins.str ui: Use of specific scene alarm front end.
        """
        if chart_title is not None:
            pulumi.set(__self__, "chart_title", chart_title)
        if dashboard_id is not None:
            pulumi.set(__self__, "dashboard_id", dashboard_id)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if power_sql_mode is not None:
            pulumi.set(__self__, "power_sql_mode", power_sql_mode)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if start is not None:
            pulumi.set(__self__, "start", start)
        if store is not None:
            pulumi.set(__self__, "store", store)
        if store_type is not None:
            pulumi.set(__self__, "store_type", store_type)
        if time_span_type is not None:
            pulumi.set(__self__, "time_span_type", time_span_type)
        if ui is not None:
            pulumi.set(__self__, "ui", ui)

    @_builtins.property
    @pulumi.getter(name="chartTitle")
    def chart_title(self) -> Optional[_builtins.str]:
        """
        Chart Name.
        """
        return pulumi.get(self, "chart_title")

    @_builtins.property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> Optional[_builtins.str]:
        """
        Dashboard ID.
        """
        return pulumi.get(self, "dashboard_id")

    @_builtins.property
    @pulumi.getter
    def end(self) -> Optional[_builtins.str]:
        """
        End time. When storeType is set to log or metric, end must be set.
        """
        return pulumi.get(self, "end")

    @_builtins.property
    @pulumi.getter(name="powerSqlMode")
    def power_sql_mode(self) -> Optional[_builtins.str]:
        """
        Whether to use exclusive SQL. The value is as follows: auto: automatic switching. enable: Starts. disable: disable.
        """
        return pulumi.get(self, "power_sql_mode")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        """
        Project Name.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def query(self) -> Optional[_builtins.str]:
        """
        Query and analysis statements. When storeType is set to log or metric, query is set to the query analysis statement. When storeType is set to meta, set query to an empty string.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        Region of the target Project.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[_builtins.str]:
        """
        Roles used to write alarm data to the event Library.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def start(self) -> Optional[_builtins.str]:
        """
        Start time. When storeType is set to log or metric, start must be set.
        """
        return pulumi.get(self, "start")

    @_builtins.property
    @pulumi.getter
    def store(self) -> Optional[_builtins.str]:
        """
        Query the Logstore, Metricstore, or resource data associated with the statistics. When storeType is set to log, store is set to the target Logstore. When storeType is set to metric, store is set to the target Metricstore. When storeType is set to meta, store is set to the target resource data name.
        """
        return pulumi.get(self, "store")

    @_builtins.property
    @pulumi.getter(name="storeType")
    def store_type(self) -> Optional[_builtins.str]:
        """
        Query the data source type. The value is as follows: log: Logstore. metric: Time series Library. meta: resource data.
        """
        return pulumi.get(self, "store_type")

    @_builtins.property
    @pulumi.getter(name="timeSpanType")
    def time_span_type(self) -> Optional[_builtins.str]:
        """
        Time Type.
        """
        return pulumi.get(self, "time_span_type")

    @_builtins.property
    @pulumi.getter
    def ui(self) -> Optional[_builtins.str]:
        """
        Use of specific scene alarm front end.
        """
        return pulumi.get(self, "ui")


@pulumi.output_type
class AlertConfigurationSeverityConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evalCondition":
            suggest = "eval_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertConfigurationSeverityConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertConfigurationSeverityConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertConfigurationSeverityConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eval_condition: Optional['outputs.AlertConfigurationSeverityConfigurationEvalCondition'] = None,
                 severity: Optional[_builtins.int] = None):
        """
        :param 'AlertConfigurationSeverityConfigurationEvalConditionArgs' eval_condition: Trigger condition. See `eval_condition` below.
        :param _builtins.int severity: Alarm severity.
        """
        if eval_condition is not None:
            pulumi.set(__self__, "eval_condition", eval_condition)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)

    @_builtins.property
    @pulumi.getter(name="evalCondition")
    def eval_condition(self) -> Optional['outputs.AlertConfigurationSeverityConfigurationEvalCondition']:
        """
        Trigger condition. See `eval_condition` below.
        """
        return pulumi.get(self, "eval_condition")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[_builtins.int]:
        """
        Alarm severity.
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class AlertConfigurationSeverityConfigurationEvalCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countCondition":
            suggest = "count_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertConfigurationSeverityConfigurationEvalCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertConfigurationSeverityConfigurationEvalCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertConfigurationSeverityConfigurationEvalCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: Optional[_builtins.str] = None,
                 count_condition: Optional[_builtins.str] = None):
        """
        :param _builtins.str condition: Data matching expression. When the data content does not need to be determined, set it to an empty string. In other cases, it needs to be set as an expression, for example, errCnt> 10.
        :param _builtins.str count_condition: The number of pieces of data to determine the number of pieces of data to indicate how many pieces of data meet the conditions. If data exists, it is satisfied. Set it to an empty string. In other cases, it needs to be set as an expression, such as__count__> 3.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if count_condition is not None:
            pulumi.set(__self__, "count_condition", count_condition)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[_builtins.str]:
        """
        Data matching expression. When the data content does not need to be determined, set it to an empty string. In other cases, it needs to be set as an expression, for example, errCnt> 10.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="countCondition")
    def count_condition(self) -> Optional[_builtins.str]:
        """
        The number of pieces of data to determine the number of pieces of data to indicate how many pieces of data meet the conditions. If data exists, it is satisfied. Set it to an empty string. In other cases, it needs to be set as an expression, such as__count__> 3.
        """
        return pulumi.get(self, "count_condition")


@pulumi.output_type
class AlertConfigurationSinkAlerthub(dict):
    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enabled: Open.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Open.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class AlertConfigurationSinkCms(dict):
    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enabled: Open.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Open.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class AlertConfigurationSinkEventStore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventStore":
            suggest = "event_store"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertConfigurationSinkEventStore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertConfigurationSinkEventStore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertConfigurationSinkEventStore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 endpoint: Optional[_builtins.str] = None,
                 event_store: Optional[_builtins.str] = None,
                 project: Optional[_builtins.str] = None,
                 role_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Open.
        :param _builtins.str endpoint: SLS service endpoint.
        :param _builtins.str event_store: Event Library Name.
        :param _builtins.str project: Project Name.
        :param _builtins.str role_arn: Roles used to write alarm data to the event Library.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if event_store is not None:
            pulumi.set(__self__, "event_store", event_store)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Open.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[_builtins.str]:
        """
        SLS service endpoint.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="eventStore")
    def event_store(self) -> Optional[_builtins.str]:
        """
        Event Library Name.
        """
        return pulumi.get(self, "event_store")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        """
        Project Name.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[_builtins.str]:
        """
        Roles used to write alarm data to the event Library.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class AlertConfigurationTemplateConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "templateId":
            suggest = "template_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertConfigurationTemplateConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertConfigurationTemplateConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertConfigurationTemplateConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Optional[Mapping[str, _builtins.str]] = None,
                 lang: Optional[_builtins.str] = None,
                 template_id: Optional[_builtins.str] = None,
                 tokens: Optional[Mapping[str, _builtins.str]] = None,
                 type: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param Mapping[str, _builtins.str] annotations: Template Annotations.
        :param _builtins.str lang: Template Language.
        :param _builtins.str template_id: Template ID.
        :param Mapping[str, _builtins.str] tokens: Template Variables.
        :param _builtins.str version: Template Version.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)
        if tokens is not None:
            pulumi.set(__self__, "tokens", tokens)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Template Annotations.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[_builtins.str]:
        """
        Template Language.
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[_builtins.str]:
        """
        Template ID.
        """
        return pulumi.get(self, "template_id")

    @_builtins.property
    @pulumi.getter
    def tokens(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Template Variables.
        """
        return pulumi.get(self, "tokens")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Template Version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class AlertSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronExpression":
            suggest = "cron_expression"
        elif key == "runImmdiately":
            suggest = "run_immdiately"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_expression: Optional[_builtins.str] = None,
                 delay: Optional[_builtins.int] = None,
                 interval: Optional[_builtins.str] = None,
                 run_immdiately: Optional[_builtins.bool] = None,
                 time_zone: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str cron_expression: Cron expression, the minimum accuracy is minutes, 24 hours. For example, 0 0/1 * * * means that the check is conducted every 1 hour from 00:00. When type is set to Cron, cronExpression must be set.
        :param _builtins.int delay: Timed task execution delay (unit: s).
        :param _builtins.str interval: Fixed interval for scheduling.
        :param _builtins.bool run_immdiately: Dispatch immediately.
        :param _builtins.str time_zone: The time zone where the Cron expression is located. The default value is null, indicating the eighth zone in the east.
        :param _builtins.str type: Check the frequency type. Log Service checks the query and analysis results according to the frequency you configured. The values are as follows: Fixedate: checks query and analysis results at regular intervals. Cron: specifies the time interval by using the Cron expression, and checks the query and analysis results at the specified time interval.
        """
        if cron_expression is not None:
            pulumi.set(__self__, "cron_expression", cron_expression)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if run_immdiately is not None:
            pulumi.set(__self__, "run_immdiately", run_immdiately)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> Optional[_builtins.str]:
        """
        Cron expression, the minimum accuracy is minutes, 24 hours. For example, 0 0/1 * * * means that the check is conducted every 1 hour from 00:00. When type is set to Cron, cronExpression must be set.
        """
        return pulumi.get(self, "cron_expression")

    @_builtins.property
    @pulumi.getter
    def delay(self) -> Optional[_builtins.int]:
        """
        Timed task execution delay (unit: s).
        """
        return pulumi.get(self, "delay")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.str]:
        """
        Fixed interval for scheduling.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="runImmdiately")
    def run_immdiately(self) -> Optional[_builtins.bool]:
        """
        Dispatch immediately.
        """
        return pulumi.get(self, "run_immdiately")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[_builtins.str]:
        """
        The time zone where the Cron expression is located. The default value is null, indicating the eighth zone in the east.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Check the frequency type. Log Service checks the query and analysis results according to the frequency you configured. The values are as follows: Fixedate: checks query and analysis results at regular intervals. Cron: specifies the time interval by using the Cron expression, and checks the query and analysis results at the specified time interval.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CollectionPolicyCentralizeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destLogstore":
            suggest = "dest_logstore"
        elif key == "destProject":
            suggest = "dest_project"
        elif key == "destRegion":
            suggest = "dest_region"
        elif key == "destTtl":
            suggest = "dest_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CollectionPolicyCentralizeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CollectionPolicyCentralizeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CollectionPolicyCentralizeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dest_logstore: Optional[_builtins.str] = None,
                 dest_project: Optional[_builtins.str] = None,
                 dest_region: Optional[_builtins.str] = None,
                 dest_ttl: Optional[_builtins.int] = None):
        """
        :param _builtins.str dest_logstore: When the central logstore is transferred to the destination logstore, its geographical attribute should be consistent with the destRegion and belong to the destProject.
        :param _builtins.str dest_project: The geographical attributes of the centralized transfer project should be consistent with the destRegion.
        :param _builtins.str dest_region: Centralized transfer destination area.
        :param _builtins.int dest_ttl: The number of days for the central transfer destination. This is valid only if the central transfer destination log store is not created for the first time.
        """
        if dest_logstore is not None:
            pulumi.set(__self__, "dest_logstore", dest_logstore)
        if dest_project is not None:
            pulumi.set(__self__, "dest_project", dest_project)
        if dest_region is not None:
            pulumi.set(__self__, "dest_region", dest_region)
        if dest_ttl is not None:
            pulumi.set(__self__, "dest_ttl", dest_ttl)

    @_builtins.property
    @pulumi.getter(name="destLogstore")
    def dest_logstore(self) -> Optional[_builtins.str]:
        """
        When the central logstore is transferred to the destination logstore, its geographical attribute should be consistent with the destRegion and belong to the destProject.
        """
        return pulumi.get(self, "dest_logstore")

    @_builtins.property
    @pulumi.getter(name="destProject")
    def dest_project(self) -> Optional[_builtins.str]:
        """
        The geographical attributes of the centralized transfer project should be consistent with the destRegion.
        """
        return pulumi.get(self, "dest_project")

    @_builtins.property
    @pulumi.getter(name="destRegion")
    def dest_region(self) -> Optional[_builtins.str]:
        """
        Centralized transfer destination area.
        """
        return pulumi.get(self, "dest_region")

    @_builtins.property
    @pulumi.getter(name="destTtl")
    def dest_ttl(self) -> Optional[_builtins.int]:
        """
        The number of days for the central transfer destination. This is valid only if the central transfer destination log store is not created for the first time.
        """
        return pulumi.get(self, "dest_ttl")


@pulumi.output_type
class CollectionPolicyDataConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataProject":
            suggest = "data_project"
        elif key == "dataRegion":
            suggest = "data_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CollectionPolicyDataConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CollectionPolicyDataConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CollectionPolicyDataConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_project: Optional[_builtins.str] = None,
                 data_region: Optional[_builtins.str] = None):
        """
        :param _builtins.str data_project: Valid only when the log type is global. For example, if the productCode is sls, the log is collected to the default dedicated Project of the account in a specific dataRegion.
        :param _builtins.str data_region: If and only if the log type is global log type, for example, if productCode is sls, global logs will be collected to the corresponding region during the first configuration.
        """
        if data_project is not None:
            pulumi.set(__self__, "data_project", data_project)
        if data_region is not None:
            pulumi.set(__self__, "data_region", data_region)

    @_builtins.property
    @pulumi.getter(name="dataProject")
    def data_project(self) -> Optional[_builtins.str]:
        """
        Valid only when the log type is global. For example, if the productCode is sls, the log is collected to the default dedicated Project of the account in a specific dataRegion.
        """
        return pulumi.get(self, "data_project")

    @_builtins.property
    @pulumi.getter(name="dataRegion")
    def data_region(self) -> Optional[_builtins.str]:
        """
        If and only if the log type is global log type, for example, if productCode is sls, global logs will be collected to the corresponding region during the first configuration.
        """
        return pulumi.get(self, "data_region")


@pulumi.output_type
class CollectionPolicyPolicyConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceMode":
            suggest = "resource_mode"
        elif key == "instanceIds":
            suggest = "instance_ids"
        elif key == "resourceTags":
            suggest = "resource_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CollectionPolicyPolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CollectionPolicyPolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CollectionPolicyPolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_mode: _builtins.str,
                 instance_ids: Optional[Sequence[_builtins.str]] = None,
                 regions: Optional[Sequence[_builtins.str]] = None,
                 resource_tags: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str resource_mode: Resource collection mode. If all is configured, all instances under the account will be collected to the default logstore. If attributeMode is configured, filtering will be performed according to the region attribute and resource label of the instance. If instanceMode is configured, filtering will be performed according to the instance ID.
        :param Sequence[_builtins.str] instance_ids: A collection of instance IDs, valid only if resourceMode is instanceMode. Only instances whose instance ID is in the instance ID collection are collected.
        :param Sequence[_builtins.str] regions: The region collection to which the instance belongs. Valid only when resourceMode is set to attributeMode. Wildcard characters are supported. If the region collection filter item is an empty array, it means that you do not need to filter by region, and all instances meet the filtering condition of the region collection. Otherwise, only instances with region attributes in the region collection are collected. The region collection and resource label of the instance. The instance objects are collected only when all of them are met.
        :param Mapping[str, _builtins.str] resource_tags: Resource label, valid if and only if resourceMode is attributeMode.
               
               If the resource label filter item is empty, it means that you do not need to filter by resource label, and all instances meet the resource label filter condition. Otherwise, only instances whose resource label attributes meet the resource label configuration are collected.
               
               The resource tag and the region collection to which the instance belongs work together. The instance objects are collected only when all of them are met.
        """
        pulumi.set(__self__, "resource_mode", resource_mode)
        if instance_ids is not None:
            pulumi.set(__self__, "instance_ids", instance_ids)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)

    @_builtins.property
    @pulumi.getter(name="resourceMode")
    def resource_mode(self) -> _builtins.str:
        """
        Resource collection mode. If all is configured, all instances under the account will be collected to the default logstore. If attributeMode is configured, filtering will be performed according to the region attribute and resource label of the instance. If instanceMode is configured, filtering will be performed according to the instance ID.
        """
        return pulumi.get(self, "resource_mode")

    @_builtins.property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A collection of instance IDs, valid only if resourceMode is instanceMode. Only instances whose instance ID is in the instance ID collection are collected.
        """
        return pulumi.get(self, "instance_ids")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[_builtins.str]]:
        """
        The region collection to which the instance belongs. Valid only when resourceMode is set to attributeMode. Wildcard characters are supported. If the region collection filter item is an empty array, it means that you do not need to filter by region, and all instances meet the filtering condition of the region collection. Otherwise, only instances with region attributes in the region collection are collected. The region collection and resource label of the instance. The instance objects are collected only when all of them are met.
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Resource label, valid if and only if resourceMode is attributeMode.

        If the resource label filter item is empty, it means that you do not need to filter by resource label, and all instances meet the resource label filter condition. Otherwise, only instances whose resource label attributes meet the resource label configuration are collected.

        The resource tag and the region collection to which the instance belongs work together. The instance objects are collected only when all of them are met.
        """
        return pulumi.get(self, "resource_tags")


@pulumi.output_type
class CollectionPolicyResourceDirectory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountGroupType":
            suggest = "account_group_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CollectionPolicyResourceDirectory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CollectionPolicyResourceDirectory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CollectionPolicyResourceDirectory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_group_type: Optional[_builtins.str] = None,
                 members: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str account_group_type: Support all mode all and custom mode custom under this resource directory
        :param Sequence[_builtins.str] members: When the resource directory is configured in the custom mode, the corresponding member account list
        """
        if account_group_type is not None:
            pulumi.set(__self__, "account_group_type", account_group_type)
        if members is not None:
            pulumi.set(__self__, "members", members)

    @_builtins.property
    @pulumi.getter(name="accountGroupType")
    def account_group_type(self) -> Optional[_builtins.str]:
        """
        Support all mode all and custom mode custom under this resource directory
        """
        return pulumi.get(self, "account_group_type")

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[Sequence[_builtins.str]]:
        """
        When the resource directory is configured in the custom mode, the corresponding member account list
        """
        return pulumi.get(self, "members")


@pulumi.output_type
class EtlConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromTime":
            suggest = "from_time"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "toTime":
            suggest = "to_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EtlConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EtlConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EtlConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_time: _builtins.int,
                 lang: _builtins.str,
                 logstore: _builtins.str,
                 role_arn: _builtins.str,
                 script: _builtins.str,
                 sinks: Sequence['outputs.EtlConfigurationSink'],
                 to_time: _builtins.int,
                 parameters: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.int from_time: The beginning of the time range for transformation.
        :param _builtins.str lang: Data processing syntax type.
        :param _builtins.str logstore: Destination Logstore Name.
        :param _builtins.str role_arn: The ARN role that authorizes writing to the target Logstore.
        :param _builtins.str script: Processing script.
        :param Sequence['EtlConfigurationSinkArgs'] sinks: Processing result output target list See `sink` below.
        :param _builtins.int to_time: The end of the time range for transformation.
        :param Mapping[str, _builtins.str] parameters: Advanced parameter configuration.
        """
        pulumi.set(__self__, "from_time", from_time)
        pulumi.set(__self__, "lang", lang)
        pulumi.set(__self__, "logstore", logstore)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "script", script)
        pulumi.set(__self__, "sinks", sinks)
        pulumi.set(__self__, "to_time", to_time)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @_builtins.property
    @pulumi.getter(name="fromTime")
    def from_time(self) -> _builtins.int:
        """
        The beginning of the time range for transformation.
        """
        return pulumi.get(self, "from_time")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> _builtins.str:
        """
        Data processing syntax type.
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter
    def logstore(self) -> _builtins.str:
        """
        Destination Logstore Name.
        """
        return pulumi.get(self, "logstore")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> _builtins.str:
        """
        The ARN role that authorizes writing to the target Logstore.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def script(self) -> _builtins.str:
        """
        Processing script.
        """
        return pulumi.get(self, "script")

    @_builtins.property
    @pulumi.getter
    def sinks(self) -> Sequence['outputs.EtlConfigurationSink']:
        """
        Processing result output target list See `sink` below.
        """
        return pulumi.get(self, "sinks")

    @_builtins.property
    @pulumi.getter(name="toTime")
    def to_time(self) -> _builtins.int:
        """
        The end of the time range for transformation.
        """
        return pulumi.get(self, "to_time")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Advanced parameter configuration.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class EtlConfigurationSink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EtlConfigurationSink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EtlConfigurationSink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EtlConfigurationSink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datasets: Sequence[_builtins.str],
                 endpoint: _builtins.str,
                 logstore: _builtins.str,
                 name: _builtins.str,
                 project: _builtins.str,
                 role_arn: _builtins.str):
        """
        :param Sequence[_builtins.str] datasets: Write Result Set.
        :param _builtins.str endpoint: The endpoint of the region where the target Project is located.
        :param _builtins.str logstore: Destination Logstore Name.
        :param _builtins.str name: Output Destination Name.
        :param _builtins.str project: Project Name.
        :param _builtins.str role_arn: The ARN role that authorizes writing to the target Logstore.
        """
        pulumi.set(__self__, "datasets", datasets)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "logstore", logstore)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "role_arn", role_arn)

    @_builtins.property
    @pulumi.getter
    def datasets(self) -> Sequence[_builtins.str]:
        """
        Write Result Set.
        """
        return pulumi.get(self, "datasets")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        The endpoint of the region where the target Project is located.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def logstore(self) -> _builtins.str:
        """
        Destination Logstore Name.
        """
        return pulumi.get(self, "logstore")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Output Destination Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        Project Name.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> _builtins.str:
        """
        The ARN role that authorizes writing to the target Logstore.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class IndexLine(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseSensitive":
            suggest = "case_sensitive"
        elif key == "excludeKeys":
            suggest = "exclude_keys"
        elif key == "includeKeys":
            suggest = "include_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexLine. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexLine.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexLine.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 case_sensitive: _builtins.bool,
                 chn: _builtins.bool,
                 tokens: Sequence[_builtins.str],
                 exclude_keys: Optional[Sequence[_builtins.str]] = None,
                 include_keys: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool case_sensitive: Is case sensitive
        :param _builtins.bool chn: Does it include Chinese
        :param Sequence[_builtins.str] tokens: Delimiter
        :param Sequence[_builtins.str] exclude_keys: List of excluded fields
        :param Sequence[_builtins.str] include_keys: Include field list
        """
        pulumi.set(__self__, "case_sensitive", case_sensitive)
        pulumi.set(__self__, "chn", chn)
        pulumi.set(__self__, "tokens", tokens)
        if exclude_keys is not None:
            pulumi.set(__self__, "exclude_keys", exclude_keys)
        if include_keys is not None:
            pulumi.set(__self__, "include_keys", include_keys)

    @_builtins.property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> _builtins.bool:
        """
        Is case sensitive
        """
        return pulumi.get(self, "case_sensitive")

    @_builtins.property
    @pulumi.getter
    def chn(self) -> _builtins.bool:
        """
        Does it include Chinese
        """
        return pulumi.get(self, "chn")

    @_builtins.property
    @pulumi.getter
    def tokens(self) -> Sequence[_builtins.str]:
        """
        Delimiter
        """
        return pulumi.get(self, "tokens")

    @_builtins.property
    @pulumi.getter(name="excludeKeys")
    def exclude_keys(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of excluded fields
        """
        return pulumi.get(self, "exclude_keys")

    @_builtins.property
    @pulumi.getter(name="includeKeys")
    def include_keys(self) -> Optional[Sequence[_builtins.str]]:
        """
        Include field list
        """
        return pulumi.get(self, "include_keys")


@pulumi.output_type
class LogtailConfigOutputDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logstoreName":
            suggest = "logstore_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogtailConfigOutputDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogtailConfigOutputDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogtailConfigOutputDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: Optional[_builtins.str] = None,
                 logstore_name: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str endpoint: The endpoint of the log project.
        :param _builtins.str logstore_name: The name of the output target logstore.
        :param _builtins.str region: Region
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if logstore_name is not None:
            pulumi.set(__self__, "logstore_name", logstore_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[_builtins.str]:
        """
        The endpoint of the log project.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="logstoreName")
    def logstore_name(self) -> Optional[_builtins.str]:
        """
        The name of the output target logstore.
        """
        return pulumi.get(self, "logstore_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        Region
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class MachineGroupGroupAttribute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalName":
            suggest = "external_name"
        elif key == "groupTopic":
            suggest = "group_topic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MachineGroupGroupAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MachineGroupGroupAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MachineGroupGroupAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_name: Optional[_builtins.str] = None,
                 group_topic: Optional[_builtins.str] = None):
        """
        :param _builtins.str external_name: The external management system identification on which the machine group depends.
        :param _builtins.str group_topic: The log topic of the machine group.
        """
        if external_name is not None:
            pulumi.set(__self__, "external_name", external_name)
        if group_topic is not None:
            pulumi.set(__self__, "group_topic", group_topic)

    @_builtins.property
    @pulumi.getter(name="externalName")
    def external_name(self) -> Optional[_builtins.str]:
        """
        The external management system identification on which the machine group depends.
        """
        return pulumi.get(self, "external_name")

    @_builtins.property
    @pulumi.getter(name="groupTopic")
    def group_topic(self) -> Optional[_builtins.str]:
        """
        The log topic of the machine group.
        """
        return pulumi.get(self, "group_topic")


@pulumi.output_type
class OssExportSinkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromTime":
            suggest = "from_time"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "toTime":
            suggest = "to_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OssExportSinkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OssExportSinkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OssExportSinkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_time: _builtins.int,
                 logstore: _builtins.str,
                 role_arn: _builtins.str,
                 sink: 'outputs.OssExportSinkConfigurationSink',
                 to_time: _builtins.int):
        """
        :param _builtins.int from_time: The beginning of the time range to ship data. The value 1 specifies that the data shipping job ships data from the first log in the Logstore. Example value: 1718380800
        :param _builtins.str logstore: The name of the Logstore.
        :param _builtins.str role_arn: The ARN of the RAM role that is used to write data to OSS. Example value: acs:ram::xxxxxxx
        :param 'OssExportSinkConfigurationSinkArgs' sink: The configurations of the Object Storage Service (OSS) data shipping job. See `sink` below.
        :param _builtins.int to_time: The end of the time range to ship data. The value 0 specifies that the data shipping job continuously ships data until the job is manually stopped. Example value: 1718380800
        """
        pulumi.set(__self__, "from_time", from_time)
        pulumi.set(__self__, "logstore", logstore)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "sink", sink)
        pulumi.set(__self__, "to_time", to_time)

    @_builtins.property
    @pulumi.getter(name="fromTime")
    def from_time(self) -> _builtins.int:
        """
        The beginning of the time range to ship data. The value 1 specifies that the data shipping job ships data from the first log in the Logstore. Example value: 1718380800
        """
        return pulumi.get(self, "from_time")

    @_builtins.property
    @pulumi.getter
    def logstore(self) -> _builtins.str:
        """
        The name of the Logstore.
        """
        return pulumi.get(self, "logstore")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> _builtins.str:
        """
        The ARN of the RAM role that is used to write data to OSS. Example value: acs:ram::xxxxxxx
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def sink(self) -> 'outputs.OssExportSinkConfigurationSink':
        """
        The configurations of the Object Storage Service (OSS) data shipping job. See `sink` below.
        """
        return pulumi.get(self, "sink")

    @_builtins.property
    @pulumi.getter(name="toTime")
    def to_time(self) -> _builtins.int:
        """
        The end of the time range to ship data. The value 0 specifies that the data shipping job continuously ships data until the job is manually stopped. Example value: 1718380800
        """
        return pulumi.get(self, "to_time")


@pulumi.output_type
class OssExportSinkConfigurationSink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bufferInterval":
            suggest = "buffer_interval"
        elif key == "bufferSize":
            suggest = "buffer_size"
        elif key == "compressionType":
            suggest = "compression_type"
        elif key == "contentDetail":
            suggest = "content_detail"
        elif key == "contentType":
            suggest = "content_type"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "timeZone":
            suggest = "time_zone"
        elif key == "delaySeconds":
            suggest = "delay_seconds"
        elif key == "pathFormat":
            suggest = "path_format"
        elif key == "pathFormatType":
            suggest = "path_format_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OssExportSinkConfigurationSink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OssExportSinkConfigurationSink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OssExportSinkConfigurationSink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: _builtins.str,
                 buffer_interval: _builtins.str,
                 buffer_size: _builtins.str,
                 compression_type: _builtins.str,
                 content_detail: _builtins.str,
                 content_type: _builtins.str,
                 endpoint: _builtins.str,
                 role_arn: _builtins.str,
                 time_zone: _builtins.str,
                 delay_seconds: Optional[_builtins.int] = None,
                 path_format: Optional[_builtins.str] = None,
                 path_format_type: Optional[_builtins.str] = None,
                 prefix: Optional[_builtins.str] = None,
                 suffix: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket: The OSS bucket.
        :param _builtins.str buffer_interval: The interval between two data shipping operations. Valid values: 300 to 900. Unit: seconds.
        :param _builtins.str buffer_size: The size of the OSS object to which data is shipped. Valid values: 5 to 256. Unit: MB.
        :param _builtins.str compression_type: Supports four compression types, such as snappy, gzip, zstd, and none.
        :param _builtins.str content_detail: The OSS file content details. Note: the value of this parameter should be updated based on the value of the contentType parameter.
               
               If the contentType value is JSON, the parameters of the contentDetail value are as follows:
               
               If the tag is allowed to be posted, the value of the parameter enableTag is true. Example:{"enableTag": true}
               
               You are not allowed to post tags. The value of the parameter enableTag is false. Example:{"enableTag": false}
               
               If the contentType value is csv, the parameters of the contentDetail value are as follows:
               
               The parameter columns is the key of the log in the source logstore.
               
               The delimiter parameter, which can be ",","|","", or "\\t".
               
               The header parameter determines whether the OSS file retains the header. The optional value is true or false.
               
               The lineFeed parameter. Optional values are "\\t", "\\n", or "".
               
               The invalid field content parameter is null to specify the delivery content when the field name does not exist.
               
               The escape character parameter "quote". Optional values are "" "," '", or" ".
               
               Example:{"null": "-", "header": false, "lineFeed": "\\n", "quote": "", "delimiter": ",", "columns": ["a", "B", "c", "d"]}
               
               When the contentType value is parquet, the parameters of the contentDetail value are as follows:
               
               The columns parameter is the key of the log in the source Logstore and must carry the data type of the key, for example:{"columns": [{"name": "a", "type": "string"}, {"name": "B", "type": "string"}, {"name": "c", "type": "string": "string"}]}
               
               When the contentType value is set to orc, the parameters of the contentDetail value are as follows:
               
               The columns parameter is the key of the log in the source Logstore and must carry the data type of the key, for example:{"columns": [{"name": "a", "type": "string"}, {"name": "B", "type": "string"}, {"name": "c", "type": "string": "string"}]}
        :param _builtins.str content_type: The storage format of the OSS object. Valid values: json, parquet, csv, and orc.
        :param _builtins.str endpoint: The OSS Endpoint can only be an OSS intranet Endpoint and only supports the same region. Example value: https://oss-cn-hangzhou-internal.aliyuncs.com
        :param _builtins.str role_arn: The ARN of the RAM role that is used to write data to OSS. Example value: acs:ram::xxxxxxx
        :param _builtins.str time_zone: The time zone. Example value: +0800
        :param _builtins.int delay_seconds: The latency of data shipping. The value of this parameter cannot exceed the data retention period of the source Logstore.
        :param _builtins.str path_format: The directory is dynamically generated according to the time. The default value is% Y/%m/%d/%H/%M. The corresponding generated directory is, for example, 2017/01/23/12/00. Note that the partition format cannot start and end. Example values:%Y/%m/%d
        :param _builtins.str path_format_type: The partition format type. only support time
        :param _builtins.str prefix: The prefix of the OSS object.
        :param _builtins.str suffix: The suffix of the OSS object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "buffer_interval", buffer_interval)
        pulumi.set(__self__, "buffer_size", buffer_size)
        pulumi.set(__self__, "compression_type", compression_type)
        pulumi.set(__self__, "content_detail", content_detail)
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "time_zone", time_zone)
        if delay_seconds is not None:
            pulumi.set(__self__, "delay_seconds", delay_seconds)
        if path_format is not None:
            pulumi.set(__self__, "path_format", path_format)
        if path_format_type is not None:
            pulumi.set(__self__, "path_format_type", path_format_type)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if suffix is not None:
            pulumi.set(__self__, "suffix", suffix)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The OSS bucket.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="bufferInterval")
    def buffer_interval(self) -> _builtins.str:
        """
        The interval between two data shipping operations. Valid values: 300 to 900. Unit: seconds.
        """
        return pulumi.get(self, "buffer_interval")

    @_builtins.property
    @pulumi.getter(name="bufferSize")
    def buffer_size(self) -> _builtins.str:
        """
        The size of the OSS object to which data is shipped. Valid values: 5 to 256. Unit: MB.
        """
        return pulumi.get(self, "buffer_size")

    @_builtins.property
    @pulumi.getter(name="compressionType")
    def compression_type(self) -> _builtins.str:
        """
        Supports four compression types, such as snappy, gzip, zstd, and none.
        """
        return pulumi.get(self, "compression_type")

    @_builtins.property
    @pulumi.getter(name="contentDetail")
    def content_detail(self) -> _builtins.str:
        """
        The OSS file content details. Note: the value of this parameter should be updated based on the value of the contentType parameter.

        If the contentType value is JSON, the parameters of the contentDetail value are as follows:

        If the tag is allowed to be posted, the value of the parameter enableTag is true. Example:{"enableTag": true}

        You are not allowed to post tags. The value of the parameter enableTag is false. Example:{"enableTag": false}

        If the contentType value is csv, the parameters of the contentDetail value are as follows:

        The parameter columns is the key of the log in the source logstore.

        The delimiter parameter, which can be ",","|","", or "\\t".

        The header parameter determines whether the OSS file retains the header. The optional value is true or false.

        The lineFeed parameter. Optional values are "\\t", "\\n", or "".

        The invalid field content parameter is null to specify the delivery content when the field name does not exist.

        The escape character parameter "quote". Optional values are "" "," '", or" ".

        Example:{"null": "-", "header": false, "lineFeed": "\\n", "quote": "", "delimiter": ",", "columns": ["a", "B", "c", "d"]}

        When the contentType value is parquet, the parameters of the contentDetail value are as follows:

        The columns parameter is the key of the log in the source Logstore and must carry the data type of the key, for example:{"columns": [{"name": "a", "type": "string"}, {"name": "B", "type": "string"}, {"name": "c", "type": "string": "string"}]}

        When the contentType value is set to orc, the parameters of the contentDetail value are as follows:

        The columns parameter is the key of the log in the source Logstore and must carry the data type of the key, for example:{"columns": [{"name": "a", "type": "string"}, {"name": "B", "type": "string"}, {"name": "c", "type": "string": "string"}]}
        """
        return pulumi.get(self, "content_detail")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        """
        The storage format of the OSS object. Valid values: json, parquet, csv, and orc.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        The OSS Endpoint can only be an OSS intranet Endpoint and only supports the same region. Example value: https://oss-cn-hangzhou-internal.aliyuncs.com
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> _builtins.str:
        """
        The ARN of the RAM role that is used to write data to OSS. Example value: acs:ram::xxxxxxx
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> _builtins.str:
        """
        The time zone. Example value: +0800
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter(name="delaySeconds")
    def delay_seconds(self) -> Optional[_builtins.int]:
        """
        The latency of data shipping. The value of this parameter cannot exceed the data retention period of the source Logstore.
        """
        return pulumi.get(self, "delay_seconds")

    @_builtins.property
    @pulumi.getter(name="pathFormat")
    def path_format(self) -> Optional[_builtins.str]:
        """
        The directory is dynamically generated according to the time. The default value is% Y/%m/%d/%H/%M. The corresponding generated directory is, for example, 2017/01/23/12/00. Note that the partition format cannot start and end. Example values:%Y/%m/%d
        """
        return pulumi.get(self, "path_format")

    @_builtins.property
    @pulumi.getter(name="pathFormatType")
    def path_format_type(self) -> Optional[_builtins.str]:
        """
        The partition format type. only support time
        """
        return pulumi.get(self, "path_format_type")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        """
        The prefix of the OSS object.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def suffix(self) -> Optional[_builtins.str]:
        """
        The suffix of the OSS object.
        """
        return pulumi.get(self, "suffix")


@pulumi.output_type
class ScheduledSqlSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronExpression":
            suggest = "cron_expression"
        elif key == "runImmediately":
            suggest = "run_immediately"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledSqlSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledSqlSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledSqlSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_expression: Optional[_builtins.str] = None,
                 delay: Optional[_builtins.int] = None,
                 interval: Optional[_builtins.str] = None,
                 run_immediately: Optional[_builtins.bool] = None,
                 time_zone: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str cron_expression: Cron expression, minimum precision is minutes, 24-hour clock. For example, 0 0/1 **indicates that the check is performed every one hour from 00:00. When type is set to Cron, cronExpression must be set.
        :param _builtins.int delay: Delay time.
        :param _builtins.str interval: Time interval, such as 5m, 1H.
        :param _builtins.bool run_immediately: Whether to execute the OSS import task immediately after it is created.
        :param _builtins.str time_zone: Time Zone.
        :param _builtins.str type: Check the frequency type. Log Service checks the query and analysis results based on the frequency you configured. The value is as follows: FixedRate: checks the query and analysis results at fixed intervals. Cron: specifies a time interval through a Cron expression, and checks the query and analysis results at the specified time interval. Weekly: Check the query and analysis results at a fixed point in time on the day of the week. Daily: checks the query and analysis results at a fixed time point every day. Hourly: Check query and analysis results every hour.
        """
        if cron_expression is not None:
            pulumi.set(__self__, "cron_expression", cron_expression)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if run_immediately is not None:
            pulumi.set(__self__, "run_immediately", run_immediately)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> Optional[_builtins.str]:
        """
        Cron expression, minimum precision is minutes, 24-hour clock. For example, 0 0/1 **indicates that the check is performed every one hour from 00:00. When type is set to Cron, cronExpression must be set.
        """
        return pulumi.get(self, "cron_expression")

    @_builtins.property
    @pulumi.getter
    def delay(self) -> Optional[_builtins.int]:
        """
        Delay time.
        """
        return pulumi.get(self, "delay")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.str]:
        """
        Time interval, such as 5m, 1H.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="runImmediately")
    def run_immediately(self) -> Optional[_builtins.bool]:
        """
        Whether to execute the OSS import task immediately after it is created.
        """
        return pulumi.get(self, "run_immediately")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[_builtins.str]:
        """
        Time Zone.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Check the frequency type. Log Service checks the query and analysis results based on the frequency you configured. The value is as follows: FixedRate: checks the query and analysis results at fixed intervals. Cron: specifies a time interval through a Cron expression, and checks the query and analysis results at the specified time interval. Weekly: Check the query and analysis results at a fixed point in time on the day of the week. Daily: checks the query and analysis results at a fixed time point every day. Hourly: Check query and analysis results every hour.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ScheduledSqlScheduledSqlConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataFormat":
            suggest = "data_format"
        elif key == "destEndpoint":
            suggest = "dest_endpoint"
        elif key == "destLogstore":
            suggest = "dest_logstore"
        elif key == "destProject":
            suggest = "dest_project"
        elif key == "destRoleArn":
            suggest = "dest_role_arn"
        elif key == "fromTime":
            suggest = "from_time"
        elif key == "fromTimeExpr":
            suggest = "from_time_expr"
        elif key == "maxRetries":
            suggest = "max_retries"
        elif key == "maxRunTimeInSeconds":
            suggest = "max_run_time_in_seconds"
        elif key == "resourcePool":
            suggest = "resource_pool"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "sourceLogstore":
            suggest = "source_logstore"
        elif key == "sqlType":
            suggest = "sql_type"
        elif key == "toTime":
            suggest = "to_time"
        elif key == "toTimeExpr":
            suggest = "to_time_expr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledSqlScheduledSqlConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledSqlScheduledSqlConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledSqlScheduledSqlConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_format: Optional[_builtins.str] = None,
                 dest_endpoint: Optional[_builtins.str] = None,
                 dest_logstore: Optional[_builtins.str] = None,
                 dest_project: Optional[_builtins.str] = None,
                 dest_role_arn: Optional[_builtins.str] = None,
                 from_time: Optional[_builtins.int] = None,
                 from_time_expr: Optional[_builtins.str] = None,
                 max_retries: Optional[_builtins.int] = None,
                 max_run_time_in_seconds: Optional[_builtins.int] = None,
                 parameters: Optional[Mapping[str, _builtins.str]] = None,
                 resource_pool: Optional[_builtins.str] = None,
                 role_arn: Optional[_builtins.str] = None,
                 script: Optional[_builtins.str] = None,
                 source_logstore: Optional[_builtins.str] = None,
                 sql_type: Optional[_builtins.str] = None,
                 to_time: Optional[_builtins.int] = None,
                 to_time_expr: Optional[_builtins.str] = None):
        """
        :param _builtins.str data_format: Write Mode.
        :param _builtins.str dest_endpoint: Target Endpoint.
        :param _builtins.str dest_logstore: Target Logstore.
        :param _builtins.str dest_project: Target Project.
        :param _builtins.str dest_role_arn: Write target role ARN.
        :param _builtins.int from_time: Schedule Start Time.
        :param _builtins.str from_time_expr: SQL time window-start.
        :param _builtins.int max_retries: Maximum retries.
        :param _builtins.int max_run_time_in_seconds: SQL timeout.
        :param Mapping[str, _builtins.str] parameters: Parameter configuration.
        :param _builtins.str resource_pool: Resource Pool.
        :param _builtins.str role_arn: Read role ARN.
        :param _builtins.str script: SQL statement.
        :param _builtins.str source_logstore: Source Logstore.
        :param _builtins.str sql_type: SQL type.
        :param _builtins.int to_time: Time at end of schedule.
        :param _builtins.str to_time_expr: SQL time window-end.
        """
        if data_format is not None:
            pulumi.set(__self__, "data_format", data_format)
        if dest_endpoint is not None:
            pulumi.set(__self__, "dest_endpoint", dest_endpoint)
        if dest_logstore is not None:
            pulumi.set(__self__, "dest_logstore", dest_logstore)
        if dest_project is not None:
            pulumi.set(__self__, "dest_project", dest_project)
        if dest_role_arn is not None:
            pulumi.set(__self__, "dest_role_arn", dest_role_arn)
        if from_time is not None:
            pulumi.set(__self__, "from_time", from_time)
        if from_time_expr is not None:
            pulumi.set(__self__, "from_time_expr", from_time_expr)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if max_run_time_in_seconds is not None:
            pulumi.set(__self__, "max_run_time_in_seconds", max_run_time_in_seconds)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if resource_pool is not None:
            pulumi.set(__self__, "resource_pool", resource_pool)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if source_logstore is not None:
            pulumi.set(__self__, "source_logstore", source_logstore)
        if sql_type is not None:
            pulumi.set(__self__, "sql_type", sql_type)
        if to_time is not None:
            pulumi.set(__self__, "to_time", to_time)
        if to_time_expr is not None:
            pulumi.set(__self__, "to_time_expr", to_time_expr)

    @_builtins.property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> Optional[_builtins.str]:
        """
        Write Mode.
        """
        return pulumi.get(self, "data_format")

    @_builtins.property
    @pulumi.getter(name="destEndpoint")
    def dest_endpoint(self) -> Optional[_builtins.str]:
        """
        Target Endpoint.
        """
        return pulumi.get(self, "dest_endpoint")

    @_builtins.property
    @pulumi.getter(name="destLogstore")
    def dest_logstore(self) -> Optional[_builtins.str]:
        """
        Target Logstore.
        """
        return pulumi.get(self, "dest_logstore")

    @_builtins.property
    @pulumi.getter(name="destProject")
    def dest_project(self) -> Optional[_builtins.str]:
        """
        Target Project.
        """
        return pulumi.get(self, "dest_project")

    @_builtins.property
    @pulumi.getter(name="destRoleArn")
    def dest_role_arn(self) -> Optional[_builtins.str]:
        """
        Write target role ARN.
        """
        return pulumi.get(self, "dest_role_arn")

    @_builtins.property
    @pulumi.getter(name="fromTime")
    def from_time(self) -> Optional[_builtins.int]:
        """
        Schedule Start Time.
        """
        return pulumi.get(self, "from_time")

    @_builtins.property
    @pulumi.getter(name="fromTimeExpr")
    def from_time_expr(self) -> Optional[_builtins.str]:
        """
        SQL time window-start.
        """
        return pulumi.get(self, "from_time_expr")

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[_builtins.int]:
        """
        Maximum retries.
        """
        return pulumi.get(self, "max_retries")

    @_builtins.property
    @pulumi.getter(name="maxRunTimeInSeconds")
    def max_run_time_in_seconds(self) -> Optional[_builtins.int]:
        """
        SQL timeout.
        """
        return pulumi.get(self, "max_run_time_in_seconds")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Parameter configuration.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="resourcePool")
    def resource_pool(self) -> Optional[_builtins.str]:
        """
        Resource Pool.
        """
        return pulumi.get(self, "resource_pool")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[_builtins.str]:
        """
        Read role ARN.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def script(self) -> Optional[_builtins.str]:
        """
        SQL statement.
        """
        return pulumi.get(self, "script")

    @_builtins.property
    @pulumi.getter(name="sourceLogstore")
    def source_logstore(self) -> Optional[_builtins.str]:
        """
        Source Logstore.
        """
        return pulumi.get(self, "source_logstore")

    @_builtins.property
    @pulumi.getter(name="sqlType")
    def sql_type(self) -> Optional[_builtins.str]:
        """
        SQL type.
        """
        return pulumi.get(self, "sql_type")

    @_builtins.property
    @pulumi.getter(name="toTime")
    def to_time(self) -> Optional[_builtins.int]:
        """
        Time at end of schedule.
        """
        return pulumi.get(self, "to_time")

    @_builtins.property
    @pulumi.getter(name="toTimeExpr")
    def to_time_expr(self) -> Optional[_builtins.str]:
        """
        SQL time window-end.
        """
        return pulumi.get(self, "to_time_expr")


@pulumi.output_type
class GetAlertsAlertResult(dict):
    def __init__(__self__, *,
                 alert_name: _builtins.str,
                 configuration: 'outputs.GetAlertsAlertConfigurationResult',
                 description: _builtins.str,
                 display_name: _builtins.str,
                 id: _builtins.str,
                 schedule: 'outputs.GetAlertsAlertScheduleResult'):
        """
        :param _builtins.str alert_name: Alert rule ID, unique under Project
        :param 'GetAlertsAlertConfigurationArgs' configuration: Detailed configuration of alarm monitoring rules
        :param _builtins.str description: Compatible fields, set to empty strings.
        :param _builtins.str display_name: Display name of the alarm rule
        :param _builtins.str id: The ID of the resource supplied above.
        :param 'GetAlertsAlertScheduleArgs' schedule: Check the frequency-dependent configuration
        """
        pulumi.set(__self__, "alert_name", alert_name)
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "schedule", schedule)

    @_builtins.property
    @pulumi.getter(name="alertName")
    def alert_name(self) -> _builtins.str:
        """
        Alert rule ID, unique under Project
        """
        return pulumi.get(self, "alert_name")

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> 'outputs.GetAlertsAlertConfigurationResult':
        """
        Detailed configuration of alarm monitoring rules
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Compatible fields, set to empty strings.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Display name of the alarm rule
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource supplied above.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> 'outputs.GetAlertsAlertScheduleResult':
        """
        Check the frequency-dependent configuration
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class GetAlertsAlertConfigurationResult(dict):
    def __init__(__self__, *,
                 annotations: Sequence['outputs.GetAlertsAlertConfigurationAnnotationResult'],
                 auto_annotation: _builtins.bool,
                 condition_configuration: 'outputs.GetAlertsAlertConfigurationConditionConfigurationResult',
                 dashboard: _builtins.str,
                 group_configuration: 'outputs.GetAlertsAlertConfigurationGroupConfigurationResult',
                 join_configurations: Sequence['outputs.GetAlertsAlertConfigurationJoinConfigurationResult'],
                 labels: Sequence['outputs.GetAlertsAlertConfigurationLabelResult'],
                 mute_until: _builtins.int,
                 no_data_fire: _builtins.bool,
                 no_data_severity: _builtins.int,
                 policy_configuration: 'outputs.GetAlertsAlertConfigurationPolicyConfigurationResult',
                 query_lists: Sequence['outputs.GetAlertsAlertConfigurationQueryListResult'],
                 send_resolved: _builtins.bool,
                 severity_configurations: Sequence['outputs.GetAlertsAlertConfigurationSeverityConfigurationResult'],
                 sink_alerthub: 'outputs.GetAlertsAlertConfigurationSinkAlerthubResult',
                 sink_cms: 'outputs.GetAlertsAlertConfigurationSinkCmsResult',
                 sink_event_store: 'outputs.GetAlertsAlertConfigurationSinkEventStoreResult',
                 tags: Sequence[_builtins.str],
                 template_configuration: 'outputs.GetAlertsAlertConfigurationTemplateConfigurationResult',
                 threshold: _builtins.int,
                 type: _builtins.str,
                 version: _builtins.str):
        """
        :param Sequence['GetAlertsAlertConfigurationAnnotationArgs'] annotations: Template Annotations.
        :param _builtins.bool auto_annotation: Whether to turn on automatic labeling.true (default): The automatic annotation function is enabled, and the system automatically adds information such as__county__to the alarm. For more information, see Automatic Labeling.false: Turn off the automatic annotation function.
        :param 'GetAlertsAlertConfigurationConditionConfigurationArgs' condition_configuration: Alarm trigger condition.
        :param _builtins.str dashboard: The instrument cluster associated with the alarm. It is recommended to set to internal-alert-analysis.
        :param 'GetAlertsAlertConfigurationGroupConfigurationArgs' group_configuration: Group evaluation configuration.
        :param Sequence['GetAlertsAlertConfigurationJoinConfigurationArgs'] join_configurations: Set operation configuration.
        :param Sequence['GetAlertsAlertConfigurationLabelArgs'] labels: Label.
        :param _builtins.int mute_until: Second-level timestamp representing the temporary shutdown deadline.
        :param _builtins.bool no_data_fire: Whether no data triggers an alarm.true: If the number of times the query and analysis results (if there are multiple results, the result after the collection operation) is no data exceeds the continuous trigger threshold, an alarm is generated.false (default): Turn off the no data alarm function.
        :param _builtins.int no_data_severity: Alarm severity when no data triggers an alarm.
        :param 'GetAlertsAlertConfigurationPolicyConfigurationArgs' policy_configuration: Alert policy configuration.
        :param Sequence['GetAlertsAlertConfigurationQueryListArgs'] query_lists: Query the statistical list.
        :param _builtins.bool send_resolved: Whether to send a recovery notification.true: A recovery alarm is triggered when the alarm is restored.false (default): Turn off the alarm recovery notification function.
        :param Sequence['GetAlertsAlertConfigurationSeverityConfigurationArgs'] severity_configurations: Trigger condition, set at least one trigger condition.
        :param 'GetAlertsAlertConfigurationSinkAlerthubArgs' sink_alerthub: Configuration of Alerts Sent to Alerthub.
        :param 'GetAlertsAlertConfigurationSinkCmsArgs' sink_cms: Configure alerts sent to CloudMonitor.
        :param 'GetAlertsAlertConfigurationSinkEventStoreArgs' sink_event_store: Configuration of sending alarms to EventStore.
        :param Sequence[_builtins.str] tags: Customize the category of alarm monitoring rules.
        :param 'GetAlertsAlertConfigurationTemplateConfigurationArgs' template_configuration: Alarm rule template configuration.
        :param _builtins.int threshold: Set the continuous trigger threshold. When the cumulative number of triggers reaches this value, an alarm is generated. The statistics are not counted when the trigger condition is not met.
        :param _builtins.str type: Check the frequency type. Log Service checks the query and analysis results according to the frequency you configured. The values are as follows:Fixedate: checks query and analysis results at regular intervals.Cron: specifies the time interval by using the Cron expression, and checks the query and analysis results at the specified time interval.
        :param _builtins.str version: Fixed as 2.0.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "auto_annotation", auto_annotation)
        pulumi.set(__self__, "condition_configuration", condition_configuration)
        pulumi.set(__self__, "dashboard", dashboard)
        pulumi.set(__self__, "group_configuration", group_configuration)
        pulumi.set(__self__, "join_configurations", join_configurations)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "mute_until", mute_until)
        pulumi.set(__self__, "no_data_fire", no_data_fire)
        pulumi.set(__self__, "no_data_severity", no_data_severity)
        pulumi.set(__self__, "policy_configuration", policy_configuration)
        pulumi.set(__self__, "query_lists", query_lists)
        pulumi.set(__self__, "send_resolved", send_resolved)
        pulumi.set(__self__, "severity_configurations", severity_configurations)
        pulumi.set(__self__, "sink_alerthub", sink_alerthub)
        pulumi.set(__self__, "sink_cms", sink_cms)
        pulumi.set(__self__, "sink_event_store", sink_event_store)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "template_configuration", template_configuration)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Sequence['outputs.GetAlertsAlertConfigurationAnnotationResult']:
        """
        Template Annotations.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="autoAnnotation")
    def auto_annotation(self) -> _builtins.bool:
        """
        Whether to turn on automatic labeling.true (default): The automatic annotation function is enabled, and the system automatically adds information such as__county__to the alarm. For more information, see Automatic Labeling.false: Turn off the automatic annotation function.
        """
        return pulumi.get(self, "auto_annotation")

    @_builtins.property
    @pulumi.getter(name="conditionConfiguration")
    def condition_configuration(self) -> 'outputs.GetAlertsAlertConfigurationConditionConfigurationResult':
        """
        Alarm trigger condition.
        """
        return pulumi.get(self, "condition_configuration")

    @_builtins.property
    @pulumi.getter
    def dashboard(self) -> _builtins.str:
        """
        The instrument cluster associated with the alarm. It is recommended to set to internal-alert-analysis.
        """
        return pulumi.get(self, "dashboard")

    @_builtins.property
    @pulumi.getter(name="groupConfiguration")
    def group_configuration(self) -> 'outputs.GetAlertsAlertConfigurationGroupConfigurationResult':
        """
        Group evaluation configuration.
        """
        return pulumi.get(self, "group_configuration")

    @_builtins.property
    @pulumi.getter(name="joinConfigurations")
    def join_configurations(self) -> Sequence['outputs.GetAlertsAlertConfigurationJoinConfigurationResult']:
        """
        Set operation configuration.
        """
        return pulumi.get(self, "join_configurations")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Sequence['outputs.GetAlertsAlertConfigurationLabelResult']:
        """
        Label.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="muteUntil")
    def mute_until(self) -> _builtins.int:
        """
        Second-level timestamp representing the temporary shutdown deadline.
        """
        return pulumi.get(self, "mute_until")

    @_builtins.property
    @pulumi.getter(name="noDataFire")
    def no_data_fire(self) -> _builtins.bool:
        """
        Whether no data triggers an alarm.true: If the number of times the query and analysis results (if there are multiple results, the result after the collection operation) is no data exceeds the continuous trigger threshold, an alarm is generated.false (default): Turn off the no data alarm function.
        """
        return pulumi.get(self, "no_data_fire")

    @_builtins.property
    @pulumi.getter(name="noDataSeverity")
    def no_data_severity(self) -> _builtins.int:
        """
        Alarm severity when no data triggers an alarm.
        """
        return pulumi.get(self, "no_data_severity")

    @_builtins.property
    @pulumi.getter(name="policyConfiguration")
    def policy_configuration(self) -> 'outputs.GetAlertsAlertConfigurationPolicyConfigurationResult':
        """
        Alert policy configuration.
        """
        return pulumi.get(self, "policy_configuration")

    @_builtins.property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Sequence['outputs.GetAlertsAlertConfigurationQueryListResult']:
        """
        Query the statistical list.
        """
        return pulumi.get(self, "query_lists")

    @_builtins.property
    @pulumi.getter(name="sendResolved")
    def send_resolved(self) -> _builtins.bool:
        """
        Whether to send a recovery notification.true: A recovery alarm is triggered when the alarm is restored.false (default): Turn off the alarm recovery notification function.
        """
        return pulumi.get(self, "send_resolved")

    @_builtins.property
    @pulumi.getter(name="severityConfigurations")
    def severity_configurations(self) -> Sequence['outputs.GetAlertsAlertConfigurationSeverityConfigurationResult']:
        """
        Trigger condition, set at least one trigger condition.
        """
        return pulumi.get(self, "severity_configurations")

    @_builtins.property
    @pulumi.getter(name="sinkAlerthub")
    def sink_alerthub(self) -> 'outputs.GetAlertsAlertConfigurationSinkAlerthubResult':
        """
        Configuration of Alerts Sent to Alerthub.
        """
        return pulumi.get(self, "sink_alerthub")

    @_builtins.property
    @pulumi.getter(name="sinkCms")
    def sink_cms(self) -> 'outputs.GetAlertsAlertConfigurationSinkCmsResult':
        """
        Configure alerts sent to CloudMonitor.
        """
        return pulumi.get(self, "sink_cms")

    @_builtins.property
    @pulumi.getter(name="sinkEventStore")
    def sink_event_store(self) -> 'outputs.GetAlertsAlertConfigurationSinkEventStoreResult':
        """
        Configuration of sending alarms to EventStore.
        """
        return pulumi.get(self, "sink_event_store")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Customize the category of alarm monitoring rules.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="templateConfiguration")
    def template_configuration(self) -> 'outputs.GetAlertsAlertConfigurationTemplateConfigurationResult':
        """
        Alarm rule template configuration.
        """
        return pulumi.get(self, "template_configuration")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.int:
        """
        Set the continuous trigger threshold. When the cumulative number of triggers reaches this value, an alarm is generated. The statistics are not counted when the trigger condition is not met.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Check the frequency type. Log Service checks the query and analysis results according to the frequency you configured. The values are as follows:Fixedate: checks query and analysis results at regular intervals.Cron: specifies the time interval by using the Cron expression, and checks the query and analysis results at the specified time interval.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Fixed as 2.0.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetAlertsAlertConfigurationAnnotationResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: Field name.
        :param _builtins.str value: Field value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Field name.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Field value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAlertsAlertConfigurationConditionConfigurationResult(dict):
    def __init__(__self__, *,
                 condition: _builtins.str,
                 count_condition: _builtins.str):
        """
        :param _builtins.str condition: Data matching expression.When the data content does not need to be determined, set it to an empty string.In other cases, it needs to be set as an expression, for example, errCnt> 10.
        :param _builtins.str count_condition: The number of pieces of data to determine the number of pieces of data to indicate how many pieces of data meet the conditions.If data exists, it is satisfied. Set it to an empty string.In other cases, it needs to be set as an expression, such as__count__> 3.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "count_condition", count_condition)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> _builtins.str:
        """
        Data matching expression.When the data content does not need to be determined, set it to an empty string.In other cases, it needs to be set as an expression, for example, errCnt> 10.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="countCondition")
    def count_condition(self) -> _builtins.str:
        """
        The number of pieces of data to determine the number of pieces of data to indicate how many pieces of data meet the conditions.If data exists, it is satisfied. Set it to an empty string.In other cases, it needs to be set as an expression, such as__count__> 3.
        """
        return pulumi.get(self, "count_condition")


@pulumi.output_type
class GetAlertsAlertConfigurationGroupConfigurationResult(dict):
    def __init__(__self__, *,
                 fields: Sequence[_builtins.str],
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] fields: The field used for grouping evaluation.When type is set to custom, fields must be set.
        :param _builtins.str type: Check the frequency type. Log Service checks the query and analysis results according to the frequency you configured. The values are as follows:Fixedate: checks query and analysis results at regular intervals.Cron: specifies the time interval by using the Cron expression, and checks the query and analysis results at the specified time interval.
        """
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def fields(self) -> Sequence[_builtins.str]:
        """
        The field used for grouping evaluation.When type is set to custom, fields must be set.
        """
        return pulumi.get(self, "fields")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Check the frequency type. Log Service checks the query and analysis results according to the frequency you configured. The values are as follows:Fixedate: checks query and analysis results at regular intervals.Cron: specifies the time interval by using the Cron expression, and checks the query and analysis results at the specified time interval.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAlertsAlertConfigurationJoinConfigurationResult(dict):
    def __init__(__self__, *,
                 condition: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str condition: Data matching expression.When the data content does not need to be determined, set it to an empty string.In other cases, it needs to be set as an expression, for example, errCnt> 10.
        :param _builtins.str type: Check the frequency type. Log Service checks the query and analysis results according to the frequency you configured. The values are as follows:Fixedate: checks query and analysis results at regular intervals.Cron: specifies the time interval by using the Cron expression, and checks the query and analysis results at the specified time interval.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> _builtins.str:
        """
        Data matching expression.When the data content does not need to be determined, set it to an empty string.In other cases, it needs to be set as an expression, for example, errCnt> 10.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Check the frequency type. Log Service checks the query and analysis results according to the frequency you configured. The values are as follows:Fixedate: checks query and analysis results at regular intervals.Cron: specifies the time interval by using the Cron expression, and checks the query and analysis results at the specified time interval.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAlertsAlertConfigurationLabelResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: Field name.
        :param _builtins.str value: Field value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Field name.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Field value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAlertsAlertConfigurationPolicyConfigurationResult(dict):
    def __init__(__self__, *,
                 action_policy_id: _builtins.str,
                 alert_policy_id: _builtins.str,
                 repeat_interval: _builtins.str):
        """
        :param _builtins.str action_policy_id: The ID of the action policy used.If the alert policy is in advanced mode and the selected alert policy is not configured with a dynamic action policy, set the actionPolicyId to an empty string.
        :param _builtins.str alert_policy_id: Alarm policy ID.If it is in simple mode or normal mode, set it to sls.builtin.dynamic (dynamic alarm policy built into the system).For advanced mode, set it to the specified alarm policy ID.
        :param _builtins.str repeat_interval: Repeat the waiting time. For example, 5m, 1H, etc.
        """
        pulumi.set(__self__, "action_policy_id", action_policy_id)
        pulumi.set(__self__, "alert_policy_id", alert_policy_id)
        pulumi.set(__self__, "repeat_interval", repeat_interval)

    @_builtins.property
    @pulumi.getter(name="actionPolicyId")
    def action_policy_id(self) -> _builtins.str:
        """
        The ID of the action policy used.If the alert policy is in advanced mode and the selected alert policy is not configured with a dynamic action policy, set the actionPolicyId to an empty string.
        """
        return pulumi.get(self, "action_policy_id")

    @_builtins.property
    @pulumi.getter(name="alertPolicyId")
    def alert_policy_id(self) -> _builtins.str:
        """
        Alarm policy ID.If it is in simple mode or normal mode, set it to sls.builtin.dynamic (dynamic alarm policy built into the system).For advanced mode, set it to the specified alarm policy ID.
        """
        return pulumi.get(self, "alert_policy_id")

    @_builtins.property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> _builtins.str:
        """
        Repeat the waiting time. For example, 5m, 1H, etc.
        """
        return pulumi.get(self, "repeat_interval")


@pulumi.output_type
class GetAlertsAlertConfigurationQueryListResult(dict):
    def __init__(__self__, *,
                 chart_title: _builtins.str,
                 dashboard_id: _builtins.str,
                 end: _builtins.str,
                 power_sql_mode: _builtins.str,
                 project: _builtins.str,
                 query: _builtins.str,
                 region: _builtins.str,
                 role_arn: _builtins.str,
                 start: _builtins.str,
                 store: _builtins.str,
                 store_type: _builtins.str,
                 time_span_type: _builtins.str,
                 ui: _builtins.str):
        """
        :param _builtins.str chart_title: Chart Name.
        :param _builtins.str dashboard_id: Dashboard ID.
        :param _builtins.str end: End time. When storeType is set to log or metric, end must be set.
        :param _builtins.str power_sql_mode: Whether to use exclusive SQL. The value is as follows: auto: automatic switching. enable: Starts. disable: disable.
        :param _builtins.str project: Project Name.
        :param _builtins.str query: Query and analysis statements. When storeType is set to log or metric, query is set to the query analysis statement. When storeType is set to meta, set query to an empty string.
        :param _builtins.str region: Region of the target Project.
        :param _builtins.str role_arn: Roles used to write alarm data to the event Library.
        :param _builtins.str start: Start time. When storeType is set to log or metric, start must be set.
        :param _builtins.str store: Query the Logstore, Metricstore, or resource data associated with the statistics. When storeType is set to log, store is set to the target Logstore. When storeType is set to metric, store is set to the target Metricstore. When storeType is set to meta, store is set to the target resource data name.
        :param _builtins.str store_type: Query the data source type. The value is as follows: log: Logstore. metric: Time series Library. meta: resource data.
        :param _builtins.str time_span_type: Time Type.
        :param _builtins.str ui: Use of specific scene alarm front end.
        """
        pulumi.set(__self__, "chart_title", chart_title)
        pulumi.set(__self__, "dashboard_id", dashboard_id)
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "power_sql_mode", power_sql_mode)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "start", start)
        pulumi.set(__self__, "store", store)
        pulumi.set(__self__, "store_type", store_type)
        pulumi.set(__self__, "time_span_type", time_span_type)
        pulumi.set(__self__, "ui", ui)

    @_builtins.property
    @pulumi.getter(name="chartTitle")
    def chart_title(self) -> _builtins.str:
        """
        Chart Name.
        """
        return pulumi.get(self, "chart_title")

    @_builtins.property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> _builtins.str:
        """
        Dashboard ID.
        """
        return pulumi.get(self, "dashboard_id")

    @_builtins.property
    @pulumi.getter
    def end(self) -> _builtins.str:
        """
        End time. When storeType is set to log or metric, end must be set.
        """
        return pulumi.get(self, "end")

    @_builtins.property
    @pulumi.getter(name="powerSqlMode")
    def power_sql_mode(self) -> _builtins.str:
        """
        Whether to use exclusive SQL. The value is as follows: auto: automatic switching. enable: Starts. disable: disable.
        """
        return pulumi.get(self, "power_sql_mode")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        Project Name.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        Query and analysis statements. When storeType is set to log or metric, query is set to the query analysis statement. When storeType is set to meta, set query to an empty string.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Region of the target Project.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> _builtins.str:
        """
        Roles used to write alarm data to the event Library.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def start(self) -> _builtins.str:
        """
        Start time. When storeType is set to log or metric, start must be set.
        """
        return pulumi.get(self, "start")

    @_builtins.property
    @pulumi.getter
    def store(self) -> _builtins.str:
        """
        Query the Logstore, Metricstore, or resource data associated with the statistics. When storeType is set to log, store is set to the target Logstore. When storeType is set to metric, store is set to the target Metricstore. When storeType is set to meta, store is set to the target resource data name.
        """
        return pulumi.get(self, "store")

    @_builtins.property
    @pulumi.getter(name="storeType")
    def store_type(self) -> _builtins.str:
        """
        Query the data source type. The value is as follows: log: Logstore. metric: Time series Library. meta: resource data.
        """
        return pulumi.get(self, "store_type")

    @_builtins.property
    @pulumi.getter(name="timeSpanType")
    def time_span_type(self) -> _builtins.str:
        """
        Time Type.
        """
        return pulumi.get(self, "time_span_type")

    @_builtins.property
    @pulumi.getter
    def ui(self) -> _builtins.str:
        """
        Use of specific scene alarm front end.
        """
        return pulumi.get(self, "ui")


@pulumi.output_type
class GetAlertsAlertConfigurationSeverityConfigurationResult(dict):
    def __init__(__self__, *,
                 eval_condition: 'outputs.GetAlertsAlertConfigurationSeverityConfigurationEvalConditionResult',
                 severity: _builtins.int):
        """
        :param 'GetAlertsAlertConfigurationSeverityConfigurationEvalConditionArgs' eval_condition: Trigger condition.
        :param _builtins.int severity: Alarm severity.
        """
        pulumi.set(__self__, "eval_condition", eval_condition)
        pulumi.set(__self__, "severity", severity)

    @_builtins.property
    @pulumi.getter(name="evalCondition")
    def eval_condition(self) -> 'outputs.GetAlertsAlertConfigurationSeverityConfigurationEvalConditionResult':
        """
        Trigger condition.
        """
        return pulumi.get(self, "eval_condition")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.int:
        """
        Alarm severity.
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class GetAlertsAlertConfigurationSeverityConfigurationEvalConditionResult(dict):
    def __init__(__self__, *,
                 condition: _builtins.str,
                 count_condition: _builtins.str):
        """
        :param _builtins.str condition: Data matching expression.When the data content does not need to be determined, set it to an empty string.In other cases, it needs to be set as an expression, for example, errCnt> 10.
        :param _builtins.str count_condition: The number of pieces of data to determine the number of pieces of data to indicate how many pieces of data meet the conditions.If data exists, it is satisfied. Set it to an empty string.In other cases, it needs to be set as an expression, such as__count__> 3.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "count_condition", count_condition)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> _builtins.str:
        """
        Data matching expression.When the data content does not need to be determined, set it to an empty string.In other cases, it needs to be set as an expression, for example, errCnt> 10.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="countCondition")
    def count_condition(self) -> _builtins.str:
        """
        The number of pieces of data to determine the number of pieces of data to indicate how many pieces of data meet the conditions.If data exists, it is satisfied. Set it to an empty string.In other cases, it needs to be set as an expression, such as__count__> 3.
        """
        return pulumi.get(self, "count_condition")


@pulumi.output_type
class GetAlertsAlertConfigurationSinkAlerthubResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: Open.
        """
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Open.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetAlertsAlertConfigurationSinkCmsResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: Open.
        """
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Open.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetAlertsAlertConfigurationSinkEventStoreResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 endpoint: _builtins.str,
                 event_store: _builtins.str,
                 project: _builtins.str,
                 role_arn: _builtins.str):
        """
        :param _builtins.bool enabled: Open.
        :param _builtins.str endpoint: SLS service endpoint.
        :param _builtins.str event_store: Event Library Name.
        :param _builtins.str project: Project Name.
        :param _builtins.str role_arn: Roles used to write alarm data to the event Library.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "event_store", event_store)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "role_arn", role_arn)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Open.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        SLS service endpoint.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="eventStore")
    def event_store(self) -> _builtins.str:
        """
        Event Library Name.
        """
        return pulumi.get(self, "event_store")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        Project Name.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> _builtins.str:
        """
        Roles used to write alarm data to the event Library.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class GetAlertsAlertConfigurationTemplateConfigurationResult(dict):
    def __init__(__self__, *,
                 annotations: Mapping[str, _builtins.str],
                 lang: _builtins.str,
                 template_id: _builtins.str,
                 tokens: Mapping[str, _builtins.str],
                 type: _builtins.str,
                 version: _builtins.str):
        """
        :param Mapping[str, _builtins.str] annotations: Template Annotations.
        :param _builtins.str lang: Template Language.
        :param _builtins.str template_id: Template ID.
        :param Mapping[str, _builtins.str] tokens: Template Variables.
        :param _builtins.str type: Check the frequency type. Log Service checks the query and analysis results according to the frequency you configured. The values are as follows:Fixedate: checks query and analysis results at regular intervals.Cron: specifies the time interval by using the Cron expression, and checks the query and analysis results at the specified time interval.
        :param _builtins.str version: Fixed as 2.0.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "lang", lang)
        pulumi.set(__self__, "template_id", template_id)
        pulumi.set(__self__, "tokens", tokens)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        """
        Template Annotations.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> _builtins.str:
        """
        Template Language.
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> _builtins.str:
        """
        Template ID.
        """
        return pulumi.get(self, "template_id")

    @_builtins.property
    @pulumi.getter
    def tokens(self) -> Mapping[str, _builtins.str]:
        """
        Template Variables.
        """
        return pulumi.get(self, "tokens")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Check the frequency type. Log Service checks the query and analysis results according to the frequency you configured. The values are as follows:Fixedate: checks query and analysis results at regular intervals.Cron: specifies the time interval by using the Cron expression, and checks the query and analysis results at the specified time interval.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Fixed as 2.0.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetAlertsAlertScheduleResult(dict):
    def __init__(__self__, *,
                 cron_expression: _builtins.str,
                 delay: _builtins.int,
                 interval: _builtins.str,
                 run_immdiately: _builtins.bool,
                 time_zone: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str cron_expression: Cron expression, the minimum accuracy is minutes, 24 hours. For example, 0 0/1 * * * means that the check is conducted every 1 hour from 00:00.When type is set to Cron, cronExpression must be set.
        :param _builtins.int delay: Timed task execution delay (unit: s).
        :param _builtins.str interval: Fixed interval for scheduling.
        :param _builtins.bool run_immdiately: Dispatch immediately.
        :param _builtins.str time_zone: The time zone where the Cron expression is located. The default value is null, indicating the eighth zone in the east.
        :param _builtins.str type: Check the frequency type. Log Service checks the query and analysis results according to the frequency you configured. The values are as follows:Fixedate: checks query and analysis results at regular intervals.Cron: specifies the time interval by using the Cron expression, and checks the query and analysis results at the specified time interval.
        """
        pulumi.set(__self__, "cron_expression", cron_expression)
        pulumi.set(__self__, "delay", delay)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "run_immdiately", run_immdiately)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> _builtins.str:
        """
        Cron expression, the minimum accuracy is minutes, 24 hours. For example, 0 0/1 * * * means that the check is conducted every 1 hour from 00:00.When type is set to Cron, cronExpression must be set.
        """
        return pulumi.get(self, "cron_expression")

    @_builtins.property
    @pulumi.getter
    def delay(self) -> _builtins.int:
        """
        Timed task execution delay (unit: s).
        """
        return pulumi.get(self, "delay")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.str:
        """
        Fixed interval for scheduling.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="runImmdiately")
    def run_immdiately(self) -> _builtins.bool:
        """
        Dispatch immediately.
        """
        return pulumi.get(self, "run_immdiately")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> _builtins.str:
        """
        The time zone where the Cron expression is located. The default value is null, indicating the eighth zone in the east.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Check the frequency type. Log Service checks the query and analysis results according to the frequency you configured. The values are as follows:Fixedate: checks query and analysis results at regular intervals.Cron: specifies the time interval by using the Cron expression, and checks the query and analysis results at the specified time interval.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetEtlsEtlResult(dict):
    def __init__(__self__, *,
                 configuration: 'outputs.GetEtlsEtlConfigurationResult',
                 create_time: _builtins.int,
                 description: _builtins.str,
                 display_name: _builtins.str,
                 id: _builtins.str,
                 job_name: _builtins.str,
                 last_modified_time: _builtins.int,
                 schedule_id: _builtins.str,
                 status: _builtins.str):
        """
        :param 'GetEtlsEtlConfigurationArgs' configuration: Detailed configuration of data processing tasks
        :param _builtins.int create_time: Task creation time. Example value: 1718787534
        :param _builtins.str description: Data Processing Task Description
        :param _builtins.str display_name: Data processing task display name
        :param _builtins.str id: The ID of the resource supplied above.
        :param _builtins.str job_name: Unique identification of data processing task
        :param _builtins.int last_modified_time: The time when the task was last modified. Example value: 1718787681
        :param _builtins.str schedule_id: The task ID. Example values:
        :param _builtins.str status: Task Status
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "job_name", job_name)
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        pulumi.set(__self__, "schedule_id", schedule_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> 'outputs.GetEtlsEtlConfigurationResult':
        """
        Detailed configuration of data processing tasks
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.int:
        """
        Task creation time. Example value: 1718787534
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Data Processing Task Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Data processing task display name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource supplied above.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="jobName")
    def job_name(self) -> _builtins.str:
        """
        Unique identification of data processing task
        """
        return pulumi.get(self, "job_name")

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> _builtins.int:
        """
        The time when the task was last modified. Example value: 1718787681
        """
        return pulumi.get(self, "last_modified_time")

    @_builtins.property
    @pulumi.getter(name="scheduleId")
    def schedule_id(self) -> _builtins.str:
        """
        The task ID. Example values:
        """
        return pulumi.get(self, "schedule_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Task Status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetEtlsEtlConfigurationResult(dict):
    def __init__(__self__, *,
                 from_time: _builtins.int,
                 lang: _builtins.str,
                 logstore: _builtins.str,
                 parameters: Mapping[str, _builtins.str],
                 role_arn: _builtins.str,
                 script: _builtins.str,
                 sinks: Sequence['outputs.GetEtlsEtlConfigurationSinkResult'],
                 to_time: _builtins.int):
        """
        :param _builtins.int from_time: Processing time start timestamp (accurate to the second). Enter 0 when the first log received from the source Logstore is consumed.
        :param _builtins.str lang: Data processing syntax type.
        :param _builtins.str logstore: Source Logstore Name.
        :param Mapping[str, _builtins.str] parameters: Advanced parameter configuration.
        :param _builtins.str role_arn: The ARN role that authorizes writing to the target Logstore.
        :param _builtins.str script: Processing script.
        :param Sequence['GetEtlsEtlConfigurationSinkArgs'] sinks: Processing result output target list.
        :param _builtins.int to_time: Processing time end timestamp (accurate to seconds). When continuous consumption is stopped manually, fill in 0.
        """
        pulumi.set(__self__, "from_time", from_time)
        pulumi.set(__self__, "lang", lang)
        pulumi.set(__self__, "logstore", logstore)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "script", script)
        pulumi.set(__self__, "sinks", sinks)
        pulumi.set(__self__, "to_time", to_time)

    @_builtins.property
    @pulumi.getter(name="fromTime")
    def from_time(self) -> _builtins.int:
        """
        Processing time start timestamp (accurate to the second). Enter 0 when the first log received from the source Logstore is consumed.
        """
        return pulumi.get(self, "from_time")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> _builtins.str:
        """
        Data processing syntax type.
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter
    def logstore(self) -> _builtins.str:
        """
        Source Logstore Name.
        """
        return pulumi.get(self, "logstore")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Mapping[str, _builtins.str]:
        """
        Advanced parameter configuration.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> _builtins.str:
        """
        The ARN role that authorizes writing to the target Logstore.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def script(self) -> _builtins.str:
        """
        Processing script.
        """
        return pulumi.get(self, "script")

    @_builtins.property
    @pulumi.getter
    def sinks(self) -> Sequence['outputs.GetEtlsEtlConfigurationSinkResult']:
        """
        Processing result output target list.
        """
        return pulumi.get(self, "sinks")

    @_builtins.property
    @pulumi.getter(name="toTime")
    def to_time(self) -> _builtins.int:
        """
        Processing time end timestamp (accurate to seconds). When continuous consumption is stopped manually, fill in 0.
        """
        return pulumi.get(self, "to_time")


@pulumi.output_type
class GetEtlsEtlConfigurationSinkResult(dict):
    def __init__(__self__, *,
                 datasets: Sequence[_builtins.str],
                 endpoint: _builtins.str,
                 logstore: _builtins.str,
                 name: _builtins.str,
                 project: _builtins.str,
                 role_arn: _builtins.str):
        """
        :param Sequence[_builtins.str] datasets: Write Result Set.
        :param _builtins.str endpoint: The endpoint of the region where the target Project is located.
        :param _builtins.str logstore: Source Logstore Name.
        :param _builtins.str name: Output Destination Name.
        :param _builtins.str project: Project Name
        :param _builtins.str role_arn: The ARN role that authorizes writing to the target Logstore.
        """
        pulumi.set(__self__, "datasets", datasets)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "logstore", logstore)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "role_arn", role_arn)

    @_builtins.property
    @pulumi.getter
    def datasets(self) -> Sequence[_builtins.str]:
        """
        Write Result Set.
        """
        return pulumi.get(self, "datasets")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        The endpoint of the region where the target Project is located.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def logstore(self) -> _builtins.str:
        """
        Source Logstore Name.
        """
        return pulumi.get(self, "logstore")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Output Destination Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        Project Name
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> _builtins.str:
        """
        The ARN role that authorizes writing to the target Logstore.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class GetIndexsIndexResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 keys: _builtins.str,
                 line: 'outputs.GetIndexsIndexLineResult',
                 log_reduce_black_lists: Sequence[_builtins.str],
                 log_reduce_white_lists: Sequence[_builtins.str],
                 max_text_len: _builtins.int,
                 ttl: _builtins.int):
        """
        :param _builtins.str id: The ID of the resource supplied above.
        :param _builtins.str keys: Field index
        :param 'GetIndexsIndexLineArgs' line: Full-text index
        :param Sequence[_builtins.str] log_reduce_black_lists: The blacklist of the cluster fields of log clustering is filtered only when log clustering is enabled.
        :param Sequence[_builtins.str] log_reduce_white_lists: The whitelist of the cluster fields for log clustering. This filter is valid only when log clustering is enabled.
        :param _builtins.int max_text_len: Maximum length of statistical field
        :param _builtins.int ttl: Log index storage time
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "keys", keys)
        pulumi.set(__self__, "line", line)
        pulumi.set(__self__, "log_reduce_black_lists", log_reduce_black_lists)
        pulumi.set(__self__, "log_reduce_white_lists", log_reduce_white_lists)
        pulumi.set(__self__, "max_text_len", max_text_len)
        pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource supplied above.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def keys(self) -> _builtins.str:
        """
        Field index
        """
        return pulumi.get(self, "keys")

    @_builtins.property
    @pulumi.getter
    def line(self) -> 'outputs.GetIndexsIndexLineResult':
        """
        Full-text index
        """
        return pulumi.get(self, "line")

    @_builtins.property
    @pulumi.getter(name="logReduceBlackLists")
    def log_reduce_black_lists(self) -> Sequence[_builtins.str]:
        """
        The blacklist of the cluster fields of log clustering is filtered only when log clustering is enabled.
        """
        return pulumi.get(self, "log_reduce_black_lists")

    @_builtins.property
    @pulumi.getter(name="logReduceWhiteLists")
    def log_reduce_white_lists(self) -> Sequence[_builtins.str]:
        """
        The whitelist of the cluster fields for log clustering. This filter is valid only when log clustering is enabled.
        """
        return pulumi.get(self, "log_reduce_white_lists")

    @_builtins.property
    @pulumi.getter(name="maxTextLen")
    def max_text_len(self) -> _builtins.int:
        """
        Maximum length of statistical field
        """
        return pulumi.get(self, "max_text_len")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> _builtins.int:
        """
        Log index storage time
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetIndexsIndexLineResult(dict):
    def __init__(__self__, *,
                 case_sensitive: _builtins.bool,
                 chn: _builtins.bool,
                 exclude_keys: Sequence[_builtins.str],
                 include_keys: Sequence[_builtins.str],
                 tokens: Sequence[_builtins.str]):
        """
        :param _builtins.bool case_sensitive: Is case sensitive.
        :param _builtins.bool chn: Does it include Chinese.
        :param Sequence[_builtins.str] exclude_keys: List of excluded fields.
        :param Sequence[_builtins.str] include_keys: Include field list.
        :param Sequence[_builtins.str] tokens: Delimiter.
        """
        pulumi.set(__self__, "case_sensitive", case_sensitive)
        pulumi.set(__self__, "chn", chn)
        pulumi.set(__self__, "exclude_keys", exclude_keys)
        pulumi.set(__self__, "include_keys", include_keys)
        pulumi.set(__self__, "tokens", tokens)

    @_builtins.property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> _builtins.bool:
        """
        Is case sensitive.
        """
        return pulumi.get(self, "case_sensitive")

    @_builtins.property
    @pulumi.getter
    def chn(self) -> _builtins.bool:
        """
        Does it include Chinese.
        """
        return pulumi.get(self, "chn")

    @_builtins.property
    @pulumi.getter(name="excludeKeys")
    def exclude_keys(self) -> Sequence[_builtins.str]:
        """
        List of excluded fields.
        """
        return pulumi.get(self, "exclude_keys")

    @_builtins.property
    @pulumi.getter(name="includeKeys")
    def include_keys(self) -> Sequence[_builtins.str]:
        """
        Include field list.
        """
        return pulumi.get(self, "include_keys")

    @_builtins.property
    @pulumi.getter
    def tokens(self) -> Sequence[_builtins.str]:
        """
        Delimiter.
        """
        return pulumi.get(self, "tokens")


@pulumi.output_type
class GetLogtailConfigsConfigResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 logtail_config_name: _builtins.str):
        """
        :param _builtins.str id: The ID of the resource supplied above.
        :param _builtins.str logtail_config_name: The name of the resource
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "logtail_config_name", logtail_config_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource supplied above.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="logtailConfigName")
    def logtail_config_name(self) -> _builtins.str:
        """
        The name of the resource
        """
        return pulumi.get(self, "logtail_config_name")


@pulumi.output_type
class GetMachineGroupsGroupResult(dict):
    def __init__(__self__, *,
                 group_name: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str group_name: Machine Group name
        :param _builtins.str id: The ID of the resource supplied above.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> _builtins.str:
        """
        Machine Group name
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource supplied above.
        """
        return pulumi.get(self, "id")


