# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 admin_password: pulumi.Input[_builtins.str],
                 cluster_zone_id: pulumi.Input[_builtins.str],
                 instance_name: pulumi.Input[_builtins.str],
                 package_type: pulumi.Input[_builtins.str],
                 pay_type: pulumi.Input[_builtins.str],
                 run_mode: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend_node_groups: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBackendNodeGroupArgs']]]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 frontend_node_groups: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFrontendNodeGroupArgs']]]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 observer_node_groups: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceObserverNodeGroupArgs']]]] = None,
                 oss_accessing_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitches: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceVswitchArgs']]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] admin_password: Password of admin user.
        :param pulumi.Input[_builtins.str] cluster_zone_id: ZoneId of instance.
        :param pulumi.Input[_builtins.str] instance_name: The name of the instance.
        :param pulumi.Input[_builtins.str] package_type: The package type of the instance:
               - trial
               - official
        :param pulumi.Input[_builtins.str] pay_type: The pay type of the instance:
               - prePaid
               - postPaid
        :param pulumi.Input[_builtins.str] run_mode: The run mode of the instance:
               - shared_nothing
               - shared_data
               - lakehouse
        :param pulumi.Input[_builtins.str] version: The version of the instance.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID of the instance.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to enable automatic renewal. This is only meaningful when payType is set to PrePaid. Disabled by default.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceBackendNodeGroupArgs']]] backend_node_groups: BackendNodeGroups See `backend_node_groups` below.
        :param pulumi.Input[_builtins.int] duration: Duration of purchase. It is only meaningful when payType is set to PrePaid.
        :param pulumi.Input[_builtins.bool] encrypted: Whether encrypted
        :param pulumi.Input[Sequence[pulumi.Input['InstanceFrontendNodeGroupArgs']]] frontend_node_groups: FrontendNodeGroups See `frontend_node_groups` below.
        :param pulumi.Input[_builtins.str] kms_key_id: KmsKeyId
        :param pulumi.Input[Sequence[pulumi.Input['InstanceObserverNodeGroupArgs']]] observer_node_groups: ObserverNodeGroups See `observer_node_groups` below.
        :param pulumi.Input[_builtins.str] oss_accessing_role_name: Role name used for password-free access to OSS.
        :param pulumi.Input[_builtins.str] pricing_cycle: The duration unit for purchasing:
               - Month
               - Year
               This is only meaningful when PayType is set to PrePaid.
        :param pulumi.Input[_builtins.str] promotion_option_no: Promotion
        :param pulumi.Input[_builtins.str] resource_group_id: ResourceGroupId
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tag list of the instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceVswitchArgs']]] vswitches: The VSwitches info of the instance. See `vswitches` below.
        """
        pulumi.set(__self__, "admin_password", admin_password)
        pulumi.set(__self__, "cluster_zone_id", cluster_zone_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "pay_type", pay_type)
        pulumi.set(__self__, "run_mode", run_mode)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if backend_node_groups is not None:
            pulumi.set(__self__, "backend_node_groups", backend_node_groups)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if frontend_node_groups is not None:
            pulumi.set(__self__, "frontend_node_groups", frontend_node_groups)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if observer_node_groups is not None:
            pulumi.set(__self__, "observer_node_groups", observer_node_groups)
        if oss_accessing_role_name is not None:
            pulumi.set(__self__, "oss_accessing_role_name", oss_accessing_role_name)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if promotion_option_no is not None:
            pulumi.set(__self__, "promotion_option_no", promotion_option_no)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vswitches is not None:
            pulumi.set(__self__, "vswitches", vswitches)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Input[_builtins.str]:
        """
        Password of admin user.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "admin_password", value)

    @_builtins.property
    @pulumi.getter(name="clusterZoneId")
    def cluster_zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        ZoneId of instance.
        """
        return pulumi.get(self, "cluster_zone_id")

    @cluster_zone_id.setter
    def cluster_zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> pulumi.Input[_builtins.str]:
        """
        The package type of the instance:
        - trial
        - official
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "package_type", value)

    @_builtins.property
    @pulumi.getter(name="payType")
    def pay_type(self) -> pulumi.Input[_builtins.str]:
        """
        The pay type of the instance:
        - prePaid
        - postPaid
        """
        return pulumi.get(self, "pay_type")

    @pay_type.setter
    def pay_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pay_type", value)

    @_builtins.property
    @pulumi.getter(name="runMode")
    def run_mode(self) -> pulumi.Input[_builtins.str]:
        """
        The run mode of the instance:
        - shared_nothing
        - shared_data
        - lakehouse
        """
        return pulumi.get(self, "run_mode")

    @run_mode.setter
    def run_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "run_mode", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        The version of the instance.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The VPC ID of the instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable automatic renewal. This is only meaningful when payType is set to PrePaid. Disabled by default.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="backendNodeGroups")
    def backend_node_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBackendNodeGroupArgs']]]]:
        """
        BackendNodeGroups See `backend_node_groups` below.
        """
        return pulumi.get(self, "backend_node_groups")

    @backend_node_groups.setter
    def backend_node_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBackendNodeGroupArgs']]]]):
        pulumi.set(self, "backend_node_groups", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration of purchase. It is only meaningful when payType is set to PrePaid.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether encrypted
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encrypted", value)

    @_builtins.property
    @pulumi.getter(name="frontendNodeGroups")
    def frontend_node_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFrontendNodeGroupArgs']]]]:
        """
        FrontendNodeGroups See `frontend_node_groups` below.
        """
        return pulumi.get(self, "frontend_node_groups")

    @frontend_node_groups.setter
    def frontend_node_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFrontendNodeGroupArgs']]]]):
        pulumi.set(self, "frontend_node_groups", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        KmsKeyId
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="observerNodeGroups")
    def observer_node_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceObserverNodeGroupArgs']]]]:
        """
        ObserverNodeGroups See `observer_node_groups` below.
        """
        return pulumi.get(self, "observer_node_groups")

    @observer_node_groups.setter
    def observer_node_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceObserverNodeGroupArgs']]]]):
        pulumi.set(self, "observer_node_groups", value)

    @_builtins.property
    @pulumi.getter(name="ossAccessingRoleName")
    def oss_accessing_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Role name used for password-free access to OSS.
        """
        return pulumi.get(self, "oss_accessing_role_name")

    @oss_accessing_role_name.setter
    def oss_accessing_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_accessing_role_name", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The duration unit for purchasing:
        - Month
        - Year
        This is only meaningful when PayType is set to PrePaid.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="promotionOptionNo")
    def promotion_option_no(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Promotion
        """
        return pulumi.get(self, "promotion_option_no")

    @promotion_option_no.setter
    def promotion_option_no(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "promotion_option_no", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ResourceGroupId
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Tag list of the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def vswitches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceVswitchArgs']]]]:
        """
        The VSwitches info of the instance. See `vswitches` below.
        """
        return pulumi.get(self, "vswitches")

    @vswitches.setter
    def vswitches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceVswitchArgs']]]]):
        pulumi.set(self, "vswitches", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend_node_groups: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBackendNodeGroupArgs']]]] = None,
                 cluster_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 frontend_node_groups: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFrontendNodeGroupArgs']]]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 observer_node_groups: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceObserverNodeGroupArgs']]]] = None,
                 oss_accessing_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 package_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 run_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitches: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceVswitchArgs']]]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] admin_password: Password of admin user.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to enable automatic renewal. This is only meaningful when payType is set to PrePaid. Disabled by default.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceBackendNodeGroupArgs']]] backend_node_groups: BackendNodeGroups See `backend_node_groups` below.
        :param pulumi.Input[_builtins.str] cluster_zone_id: ZoneId of instance.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the instance.
        :param pulumi.Input[_builtins.int] duration: Duration of purchase. It is only meaningful when payType is set to PrePaid.
        :param pulumi.Input[_builtins.bool] encrypted: Whether encrypted
        :param pulumi.Input[Sequence[pulumi.Input['InstanceFrontendNodeGroupArgs']]] frontend_node_groups: FrontendNodeGroups See `frontend_node_groups` below.
        :param pulumi.Input[_builtins.str] instance_name: The name of the instance.
        :param pulumi.Input[_builtins.str] kms_key_id: KmsKeyId
        :param pulumi.Input[Sequence[pulumi.Input['InstanceObserverNodeGroupArgs']]] observer_node_groups: ObserverNodeGroups See `observer_node_groups` below.
        :param pulumi.Input[_builtins.str] oss_accessing_role_name: Role name used for password-free access to OSS.
        :param pulumi.Input[_builtins.str] package_type: The package type of the instance:
               - trial
               - official
        :param pulumi.Input[_builtins.str] pay_type: The pay type of the instance:
               - prePaid
               - postPaid
        :param pulumi.Input[_builtins.str] pricing_cycle: The duration unit for purchasing:
               - Month
               - Year
               This is only meaningful when PayType is set to PrePaid.
        :param pulumi.Input[_builtins.str] promotion_option_no: Promotion
        :param pulumi.Input[_builtins.str] region_id: The region ID of the instance.
        :param pulumi.Input[_builtins.str] resource_group_id: ResourceGroupId
        :param pulumi.Input[_builtins.str] run_mode: The run mode of the instance:
               - shared_nothing
               - shared_data
               - lakehouse
        :param pulumi.Input[_builtins.str] status: The status of the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tag list of the instance.
        :param pulumi.Input[_builtins.str] version: The version of the instance.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID of the instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceVswitchArgs']]] vswitches: The VSwitches info of the instance. See `vswitches` below.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if backend_node_groups is not None:
            pulumi.set(__self__, "backend_node_groups", backend_node_groups)
        if cluster_zone_id is not None:
            pulumi.set(__self__, "cluster_zone_id", cluster_zone_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if frontend_node_groups is not None:
            pulumi.set(__self__, "frontend_node_groups", frontend_node_groups)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if observer_node_groups is not None:
            pulumi.set(__self__, "observer_node_groups", observer_node_groups)
        if oss_accessing_role_name is not None:
            pulumi.set(__self__, "oss_accessing_role_name", oss_accessing_role_name)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)
        if pay_type is not None:
            pulumi.set(__self__, "pay_type", pay_type)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if promotion_option_no is not None:
            pulumi.set(__self__, "promotion_option_no", promotion_option_no)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if run_mode is not None:
            pulumi.set(__self__, "run_mode", run_mode)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitches is not None:
            pulumi.set(__self__, "vswitches", vswitches)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password of admin user.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_password", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable automatic renewal. This is only meaningful when payType is set to PrePaid. Disabled by default.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="backendNodeGroups")
    def backend_node_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBackendNodeGroupArgs']]]]:
        """
        BackendNodeGroups See `backend_node_groups` below.
        """
        return pulumi.get(self, "backend_node_groups")

    @backend_node_groups.setter
    def backend_node_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBackendNodeGroupArgs']]]]):
        pulumi.set(self, "backend_node_groups", value)

    @_builtins.property
    @pulumi.getter(name="clusterZoneId")
    def cluster_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ZoneId of instance.
        """
        return pulumi.get(self, "cluster_zone_id")

    @cluster_zone_id.setter
    def cluster_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the instance.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration of purchase. It is only meaningful when payType is set to PrePaid.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether encrypted
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encrypted", value)

    @_builtins.property
    @pulumi.getter(name="frontendNodeGroups")
    def frontend_node_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFrontendNodeGroupArgs']]]]:
        """
        FrontendNodeGroups See `frontend_node_groups` below.
        """
        return pulumi.get(self, "frontend_node_groups")

    @frontend_node_groups.setter
    def frontend_node_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFrontendNodeGroupArgs']]]]):
        pulumi.set(self, "frontend_node_groups", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        KmsKeyId
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="observerNodeGroups")
    def observer_node_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceObserverNodeGroupArgs']]]]:
        """
        ObserverNodeGroups See `observer_node_groups` below.
        """
        return pulumi.get(self, "observer_node_groups")

    @observer_node_groups.setter
    def observer_node_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceObserverNodeGroupArgs']]]]):
        pulumi.set(self, "observer_node_groups", value)

    @_builtins.property
    @pulumi.getter(name="ossAccessingRoleName")
    def oss_accessing_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Role name used for password-free access to OSS.
        """
        return pulumi.get(self, "oss_accessing_role_name")

    @oss_accessing_role_name.setter
    def oss_accessing_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_accessing_role_name", value)

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The package type of the instance:
        - trial
        - official
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "package_type", value)

    @_builtins.property
    @pulumi.getter(name="payType")
    def pay_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pay type of the instance:
        - prePaid
        - postPaid
        """
        return pulumi.get(self, "pay_type")

    @pay_type.setter
    def pay_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pay_type", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The duration unit for purchasing:
        - Month
        - Year
        This is only meaningful when PayType is set to PrePaid.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="promotionOptionNo")
    def promotion_option_no(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Promotion
        """
        return pulumi.get(self, "promotion_option_no")

    @promotion_option_no.setter
    def promotion_option_no(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "promotion_option_no", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the instance.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ResourceGroupId
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="runMode")
    def run_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The run mode of the instance:
        - shared_nothing
        - shared_data
        - lakehouse
        """
        return pulumi.get(self, "run_mode")

    @run_mode.setter
    def run_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_mode", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Tag list of the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the instance.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID of the instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def vswitches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceVswitchArgs']]]]:
        """
        The VSwitches info of the instance. See `vswitches` below.
        """
        return pulumi.get(self, "vswitches")

    @vswitches.setter
    def vswitches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceVswitchArgs']]]]):
        pulumi.set(self, "vswitches", value)


@pulumi.type_token("alicloud:starrocks/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend_node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceBackendNodeGroupArgs', 'InstanceBackendNodeGroupArgsDict']]]]] = None,
                 cluster_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 frontend_node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceFrontendNodeGroupArgs', 'InstanceFrontendNodeGroupArgsDict']]]]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 observer_node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceObserverNodeGroupArgs', 'InstanceObserverNodeGroupArgsDict']]]]] = None,
                 oss_accessing_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 package_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 run_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceVswitchArgs', 'InstanceVswitchArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Star Rocks Instance resource.

        StarRocks resource instance.

        For information about Star Rocks Instance and how to use it, see [What is Instance](https://next.api.alibabacloud.com/document/starrocks/2022-10-19/CreateInstanceV1).

        > **NOTE:** Available since v1.256.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_b21_jud = alicloud.vpc.Network("defaultB21JUD", cidr_block="172.16.0.0/12")
        default106_dk_e = alicloud.vpc.Switch("default106DkE",
            vpc_id=default_b21_jud.id,
            cidr_block="172.16.1.0/24",
            vswitch_name="sr-example",
            zone_id="cn-hangzhou-i")
        default_instance = alicloud.starrocks.Instance("default",
            instance_name="create-instance-1",
            auto_renew=False,
            frontend_node_groups=[{
                "cu": 8,
                "storage_size": 100,
                "resident_node_number": 3,
                "storage_performance_level": "pl1",
                "spec_type": "standard",
                "disk_number": 1,
                "zone_id": "cn-hangzhou-i",
                "local_storage_instance_type": "null",
            }],
            vswitches=[{
                "vswitch_id": default106_dk_e.id,
                "zone_id": "cn-hangzhou-i",
            }],
            backend_node_groups=[{
                "cu": 8,
                "storage_size": 100,
                "resident_node_number": 3,
                "disk_number": 1,
                "storage_performance_level": "pl1",
                "spec_type": "standard",
                "zone_id": "cn-hangzhou-i",
                "local_storage_instance_type": "null",
            }],
            cluster_zone_id="cn-hangzhou-i",
            duration=1,
            pay_type="postPaid",
            vpc_id=default_b21_jud.id,
            version="3.3",
            run_mode="shared_data",
            package_type="official",
            admin_password="1qaz@QAZ",
            oss_accessing_role_name="AliyunEMRStarRocksAccessingOSSRole",
            pricing_cycle="Month",
            kms_key_id="123",
            promotion_option_no="123",
            encrypted=False,
            observer_node_groups=[{
                "cu": 8,
                "storage_size": 100,
                "storage_performance_level": "pl1",
                "disk_number": 1,
                "resident_node_number": 1,
                "spec_type": "standard",
                "local_storage_instance_type": "null",
                "zone_id": "cn-hangzhou-h",
            }])
        ```

        ## Import

        Star Rocks Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:starrocks/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] admin_password: Password of admin user.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to enable automatic renewal. This is only meaningful when payType is set to PrePaid. Disabled by default.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceBackendNodeGroupArgs', 'InstanceBackendNodeGroupArgsDict']]]] backend_node_groups: BackendNodeGroups See `backend_node_groups` below.
        :param pulumi.Input[_builtins.str] cluster_zone_id: ZoneId of instance.
        :param pulumi.Input[_builtins.int] duration: Duration of purchase. It is only meaningful when payType is set to PrePaid.
        :param pulumi.Input[_builtins.bool] encrypted: Whether encrypted
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceFrontendNodeGroupArgs', 'InstanceFrontendNodeGroupArgsDict']]]] frontend_node_groups: FrontendNodeGroups See `frontend_node_groups` below.
        :param pulumi.Input[_builtins.str] instance_name: The name of the instance.
        :param pulumi.Input[_builtins.str] kms_key_id: KmsKeyId
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceObserverNodeGroupArgs', 'InstanceObserverNodeGroupArgsDict']]]] observer_node_groups: ObserverNodeGroups See `observer_node_groups` below.
        :param pulumi.Input[_builtins.str] oss_accessing_role_name: Role name used for password-free access to OSS.
        :param pulumi.Input[_builtins.str] package_type: The package type of the instance:
               - trial
               - official
        :param pulumi.Input[_builtins.str] pay_type: The pay type of the instance:
               - prePaid
               - postPaid
        :param pulumi.Input[_builtins.str] pricing_cycle: The duration unit for purchasing:
               - Month
               - Year
               This is only meaningful when PayType is set to PrePaid.
        :param pulumi.Input[_builtins.str] promotion_option_no: Promotion
        :param pulumi.Input[_builtins.str] resource_group_id: ResourceGroupId
        :param pulumi.Input[_builtins.str] run_mode: The run mode of the instance:
               - shared_nothing
               - shared_data
               - lakehouse
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tag list of the instance.
        :param pulumi.Input[_builtins.str] version: The version of the instance.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID of the instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceVswitchArgs', 'InstanceVswitchArgsDict']]]] vswitches: The VSwitches info of the instance. See `vswitches` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Star Rocks Instance resource.

        StarRocks resource instance.

        For information about Star Rocks Instance and how to use it, see [What is Instance](https://next.api.alibabacloud.com/document/starrocks/2022-10-19/CreateInstanceV1).

        > **NOTE:** Available since v1.256.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_b21_jud = alicloud.vpc.Network("defaultB21JUD", cidr_block="172.16.0.0/12")
        default106_dk_e = alicloud.vpc.Switch("default106DkE",
            vpc_id=default_b21_jud.id,
            cidr_block="172.16.1.0/24",
            vswitch_name="sr-example",
            zone_id="cn-hangzhou-i")
        default_instance = alicloud.starrocks.Instance("default",
            instance_name="create-instance-1",
            auto_renew=False,
            frontend_node_groups=[{
                "cu": 8,
                "storage_size": 100,
                "resident_node_number": 3,
                "storage_performance_level": "pl1",
                "spec_type": "standard",
                "disk_number": 1,
                "zone_id": "cn-hangzhou-i",
                "local_storage_instance_type": "null",
            }],
            vswitches=[{
                "vswitch_id": default106_dk_e.id,
                "zone_id": "cn-hangzhou-i",
            }],
            backend_node_groups=[{
                "cu": 8,
                "storage_size": 100,
                "resident_node_number": 3,
                "disk_number": 1,
                "storage_performance_level": "pl1",
                "spec_type": "standard",
                "zone_id": "cn-hangzhou-i",
                "local_storage_instance_type": "null",
            }],
            cluster_zone_id="cn-hangzhou-i",
            duration=1,
            pay_type="postPaid",
            vpc_id=default_b21_jud.id,
            version="3.3",
            run_mode="shared_data",
            package_type="official",
            admin_password="1qaz@QAZ",
            oss_accessing_role_name="AliyunEMRStarRocksAccessingOSSRole",
            pricing_cycle="Month",
            kms_key_id="123",
            promotion_option_no="123",
            encrypted=False,
            observer_node_groups=[{
                "cu": 8,
                "storage_size": 100,
                "storage_performance_level": "pl1",
                "disk_number": 1,
                "resident_node_number": 1,
                "spec_type": "standard",
                "local_storage_instance_type": "null",
                "zone_id": "cn-hangzhou-h",
            }])
        ```

        ## Import

        Star Rocks Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:starrocks/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend_node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceBackendNodeGroupArgs', 'InstanceBackendNodeGroupArgsDict']]]]] = None,
                 cluster_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 frontend_node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceFrontendNodeGroupArgs', 'InstanceFrontendNodeGroupArgsDict']]]]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 observer_node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceObserverNodeGroupArgs', 'InstanceObserverNodeGroupArgsDict']]]]] = None,
                 oss_accessing_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 package_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 run_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceVswitchArgs', 'InstanceVswitchArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            if admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'admin_password'")
            __props__.__dict__["admin_password"] = admin_password
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["backend_node_groups"] = backend_node_groups
            if cluster_zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_zone_id'")
            __props__.__dict__["cluster_zone_id"] = cluster_zone_id
            __props__.__dict__["duration"] = duration
            __props__.__dict__["encrypted"] = encrypted
            __props__.__dict__["frontend_node_groups"] = frontend_node_groups
            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["observer_node_groups"] = observer_node_groups
            __props__.__dict__["oss_accessing_role_name"] = oss_accessing_role_name
            if package_type is None and not opts.urn:
                raise TypeError("Missing required property 'package_type'")
            __props__.__dict__["package_type"] = package_type
            if pay_type is None and not opts.urn:
                raise TypeError("Missing required property 'pay_type'")
            __props__.__dict__["pay_type"] = pay_type
            __props__.__dict__["pricing_cycle"] = pricing_cycle
            __props__.__dict__["promotion_option_no"] = promotion_option_no
            __props__.__dict__["resource_group_id"] = resource_group_id
            if run_mode is None and not opts.urn:
                raise TypeError("Missing required property 'run_mode'")
            __props__.__dict__["run_mode"] = run_mode
            __props__.__dict__["tags"] = tags
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitches"] = vswitches
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="alicloud:index/starRocksInstance:StarRocksInstance")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Instance, __self__).__init__(
            'alicloud:starrocks/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_password: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            backend_node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceBackendNodeGroupArgs', 'InstanceBackendNodeGroupArgsDict']]]]] = None,
            cluster_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            duration: Optional[pulumi.Input[_builtins.int]] = None,
            encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
            frontend_node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceFrontendNodeGroupArgs', 'InstanceFrontendNodeGroupArgsDict']]]]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            observer_node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceObserverNodeGroupArgs', 'InstanceObserverNodeGroupArgsDict']]]]] = None,
            oss_accessing_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            package_type: Optional[pulumi.Input[_builtins.str]] = None,
            pay_type: Optional[pulumi.Input[_builtins.str]] = None,
            pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
            promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            run_mode: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceVswitchArgs', 'InstanceVswitchArgsDict']]]]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] admin_password: Password of admin user.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to enable automatic renewal. This is only meaningful when payType is set to PrePaid. Disabled by default.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceBackendNodeGroupArgs', 'InstanceBackendNodeGroupArgsDict']]]] backend_node_groups: BackendNodeGroups See `backend_node_groups` below.
        :param pulumi.Input[_builtins.str] cluster_zone_id: ZoneId of instance.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the instance.
        :param pulumi.Input[_builtins.int] duration: Duration of purchase. It is only meaningful when payType is set to PrePaid.
        :param pulumi.Input[_builtins.bool] encrypted: Whether encrypted
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceFrontendNodeGroupArgs', 'InstanceFrontendNodeGroupArgsDict']]]] frontend_node_groups: FrontendNodeGroups See `frontend_node_groups` below.
        :param pulumi.Input[_builtins.str] instance_name: The name of the instance.
        :param pulumi.Input[_builtins.str] kms_key_id: KmsKeyId
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceObserverNodeGroupArgs', 'InstanceObserverNodeGroupArgsDict']]]] observer_node_groups: ObserverNodeGroups See `observer_node_groups` below.
        :param pulumi.Input[_builtins.str] oss_accessing_role_name: Role name used for password-free access to OSS.
        :param pulumi.Input[_builtins.str] package_type: The package type of the instance:
               - trial
               - official
        :param pulumi.Input[_builtins.str] pay_type: The pay type of the instance:
               - prePaid
               - postPaid
        :param pulumi.Input[_builtins.str] pricing_cycle: The duration unit for purchasing:
               - Month
               - Year
               This is only meaningful when PayType is set to PrePaid.
        :param pulumi.Input[_builtins.str] promotion_option_no: Promotion
        :param pulumi.Input[_builtins.str] region_id: The region ID of the instance.
        :param pulumi.Input[_builtins.str] resource_group_id: ResourceGroupId
        :param pulumi.Input[_builtins.str] run_mode: The run mode of the instance:
               - shared_nothing
               - shared_data
               - lakehouse
        :param pulumi.Input[_builtins.str] status: The status of the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tag list of the instance.
        :param pulumi.Input[_builtins.str] version: The version of the instance.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID of the instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceVswitchArgs', 'InstanceVswitchArgsDict']]]] vswitches: The VSwitches info of the instance. See `vswitches` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["admin_password"] = admin_password
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["backend_node_groups"] = backend_node_groups
        __props__.__dict__["cluster_zone_id"] = cluster_zone_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["duration"] = duration
        __props__.__dict__["encrypted"] = encrypted
        __props__.__dict__["frontend_node_groups"] = frontend_node_groups
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["observer_node_groups"] = observer_node_groups
        __props__.__dict__["oss_accessing_role_name"] = oss_accessing_role_name
        __props__.__dict__["package_type"] = package_type
        __props__.__dict__["pay_type"] = pay_type
        __props__.__dict__["pricing_cycle"] = pricing_cycle
        __props__.__dict__["promotion_option_no"] = promotion_option_no
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["run_mode"] = run_mode
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitches"] = vswitches
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Output[_builtins.str]:
        """
        Password of admin user.
        """
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable automatic renewal. This is only meaningful when payType is set to PrePaid. Disabled by default.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="backendNodeGroups")
    def backend_node_groups(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceBackendNodeGroup']]]:
        """
        BackendNodeGroups See `backend_node_groups` below.
        """
        return pulumi.get(self, "backend_node_groups")

    @_builtins.property
    @pulumi.getter(name="clusterZoneId")
    def cluster_zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        ZoneId of instance.
        """
        return pulumi.get(self, "cluster_zone_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the instance.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Duration of purchase. It is only meaningful when payType is set to PrePaid.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether encrypted
        """
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter(name="frontendNodeGroups")
    def frontend_node_groups(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceFrontendNodeGroup']]]:
        """
        FrontendNodeGroups See `frontend_node_groups` below.
        """
        return pulumi.get(self, "frontend_node_groups")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        KmsKeyId
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="observerNodeGroups")
    def observer_node_groups(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceObserverNodeGroup']]]:
        """
        ObserverNodeGroups See `observer_node_groups` below.
        """
        return pulumi.get(self, "observer_node_groups")

    @_builtins.property
    @pulumi.getter(name="ossAccessingRoleName")
    def oss_accessing_role_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Role name used for password-free access to OSS.
        """
        return pulumi.get(self, "oss_accessing_role_name")

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> pulumi.Output[_builtins.str]:
        """
        The package type of the instance:
        - trial
        - official
        """
        return pulumi.get(self, "package_type")

    @_builtins.property
    @pulumi.getter(name="payType")
    def pay_type(self) -> pulumi.Output[_builtins.str]:
        """
        The pay type of the instance:
        - prePaid
        - postPaid
        """
        return pulumi.get(self, "pay_type")

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The duration unit for purchasing:
        - Month
        - Year
        This is only meaningful when PayType is set to PrePaid.
        """
        return pulumi.get(self, "pricing_cycle")

    @_builtins.property
    @pulumi.getter(name="promotionOptionNo")
    def promotion_option_no(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Promotion
        """
        return pulumi.get(self, "promotion_option_no")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the instance.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        ResourceGroupId
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="runMode")
    def run_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The run mode of the instance:
        - shared_nothing
        - shared_data
        - lakehouse
        """
        return pulumi.get(self, "run_mode")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Tag list of the instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the instance.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC ID of the instance.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter
    def vswitches(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceVswitch']]]:
        """
        The VSwitches info of the instance. See `vswitches` below.
        """
        return pulumi.get(self, "vswitches")

