# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NodeGroupArgs', 'NodeGroup']

@pulumi.input_type
class NodeGroupArgs:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 cu: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_number: Optional[pulumi.Input[_builtins.int]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 fast_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 local_storage_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
                 resident_node_number: Optional[pulumi.Input[_builtins.int]] = None,
                 spec_type: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a NodeGroup resource.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether auto-renewal is enabled.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.int] cu: Number of CUs. CU (Compute Unit) is the basic unit of service measurement, where 1 CU = 1 vCPU + 4 GiB memory. When SpecType is memory-optimized, 1 CU = 1 vCPU + 8 GiB memory.
        :param pulumi.Input[_builtins.str] description: Description of node group.
        :param pulumi.Input[_builtins.int] disk_number: Number of disks.
        :param pulumi.Input[_builtins.int] duration: Duration of node group.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.bool] fast_mode: Whether to restart in fast restart mode. The default is false.
               - true: Reboots the compute node in fast restart mode. Restart computing nodes in multiple batches, restart in parallel within a batch, and execute serially between batches;
               - false: Restarts the compute node in rolling restart mode.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] local_storage_instance_type: Node group local SSD instance specification. This value is only relevant when based on ECS instances and SpecType is set to local SSD/large-scale storage.
        :param pulumi.Input[_builtins.str] node_group_name: The name of the node group.
        :param pulumi.Input[_builtins.str] pay_type: Payment type:
               - PrePaid: Subscription (prepaid).
               - PostPaid: Pay-as-you-go (postpaid).
        :param pulumi.Input[_builtins.str] pricing_cycle: Unit of purchase duration:
               - Month
               - Year
               
               This is only applicable when payType is set to PrePaid.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.int] resident_node_number: Number of nodes.
        :param pulumi.Input[_builtins.str] spec_type: Node group spec types include the following:
               - standard: Standard edition.
               - localSSD: Local SSD.
               - bigData: Large-scale storage.
               - ramEnhanced: Memory-enhanced type.
               - networkEnhanced: Network-enhanced type.
        :param pulumi.Input[_builtins.str] storage_performance_level: Performance levels of the cloud disk. Includes the following values:
               - pl0: Maximum random read/write IOPS of a single disk is 10,000.
               - pl1: Maximum random read/write IOPS of a single disk is 50,000.
               - pl2: Maximum random read/write IOPS of a single disk is 100,000.
               - pl3: Maximum random read/write IOPS of a single disk is 1,000,000.
        :param pulumi.Input[_builtins.int] storage_size: Storage size, measured in GiB.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if cu is not None:
            pulumi.set(__self__, "cu", cu)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_number is not None:
            pulumi.set(__self__, "disk_number", disk_number)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if fast_mode is not None:
            pulumi.set(__self__, "fast_mode", fast_mode)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if local_storage_instance_type is not None:
            pulumi.set(__self__, "local_storage_instance_type", local_storage_instance_type)
        if node_group_name is not None:
            pulumi.set(__self__, "node_group_name", node_group_name)
        if pay_type is not None:
            pulumi.set(__self__, "pay_type", pay_type)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if promotion_option_no is not None:
            pulumi.set(__self__, "promotion_option_no", promotion_option_no)
        if resident_node_number is not None:
            pulumi.set(__self__, "resident_node_number", resident_node_number)
        if spec_type is not None:
            pulumi.set(__self__, "spec_type", spec_type)
        if storage_performance_level is not None:
            pulumi.set(__self__, "storage_performance_level", storage_performance_level)
        if storage_size is not None:
            pulumi.set(__self__, "storage_size", storage_size)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether auto-renewal is enabled.

        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter
    def cu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of CUs. CU (Compute Unit) is the basic unit of service measurement, where 1 CU = 1 vCPU + 4 GiB memory. When SpecType is memory-optimized, 1 CU = 1 vCPU + 8 GiB memory.
        """
        return pulumi.get(self, "cu")

    @cu.setter
    def cu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cu", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of node group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskNumber")
    def disk_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of disks.
        """
        return pulumi.get(self, "disk_number")

    @disk_number.setter
    def disk_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_number", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration of node group.

        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="fastMode")
    def fast_mode(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to restart in fast restart mode. The default is false.
        - true: Reboots the compute node in fast restart mode. Restart computing nodes in multiple batches, restart in parallel within a batch, and execute serially between batches;
        - false: Restarts the compute node in rolling restart mode.

        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "fast_mode")

    @fast_mode.setter
    def fast_mode(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fast_mode", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="localStorageInstanceType")
    def local_storage_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node group local SSD instance specification. This value is only relevant when based on ECS instances and SpecType is set to local SSD/large-scale storage.
        """
        return pulumi.get(self, "local_storage_instance_type")

    @local_storage_instance_type.setter
    def local_storage_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_storage_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the node group.
        """
        return pulumi.get(self, "node_group_name")

    @node_group_name.setter
    def node_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_group_name", value)

    @_builtins.property
    @pulumi.getter(name="payType")
    def pay_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Payment type:
        - PrePaid: Subscription (prepaid).
        - PostPaid: Pay-as-you-go (postpaid).
        """
        return pulumi.get(self, "pay_type")

    @pay_type.setter
    def pay_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pay_type", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unit of purchase duration:
        - Month
        - Year

        This is only applicable when payType is set to PrePaid.

        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="promotionOptionNo")
    def promotion_option_no(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "promotion_option_no")

    @promotion_option_no.setter
    def promotion_option_no(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "promotion_option_no", value)

    @_builtins.property
    @pulumi.getter(name="residentNodeNumber")
    def resident_node_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of nodes.
        """
        return pulumi.get(self, "resident_node_number")

    @resident_node_number.setter
    def resident_node_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resident_node_number", value)

    @_builtins.property
    @pulumi.getter(name="specType")
    def spec_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node group spec types include the following:
        - standard: Standard edition.
        - localSSD: Local SSD.
        - bigData: Large-scale storage.
        - ramEnhanced: Memory-enhanced type.
        - networkEnhanced: Network-enhanced type.
        """
        return pulumi.get(self, "spec_type")

    @spec_type.setter
    def spec_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spec_type", value)

    @_builtins.property
    @pulumi.getter(name="storagePerformanceLevel")
    def storage_performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Performance levels of the cloud disk. Includes the following values:
        - pl0: Maximum random read/write IOPS of a single disk is 10,000.
        - pl1: Maximum random read/write IOPS of a single disk is 50,000.
        - pl2: Maximum random read/write IOPS of a single disk is 100,000.
        - pl3: Maximum random read/write IOPS of a single disk is 1,000,000.
        """
        return pulumi.get(self, "storage_performance_level")

    @storage_performance_level.setter
    def storage_performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_performance_level", value)

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Storage size, measured in GiB.
        """
        return pulumi.get(self, "storage_size")

    @storage_size.setter
    def storage_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_size", value)


@pulumi.input_type
class _NodeGroupState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 cu: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_number: Optional[pulumi.Input[_builtins.int]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 fast_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 local_storage_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resident_node_number: Optional[pulumi.Input[_builtins.int]] = None,
                 spec_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering NodeGroup resources.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether auto-renewal is enabled.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the node group.
        :param pulumi.Input[_builtins.int] cu: Number of CUs. CU (Compute Unit) is the basic unit of service measurement, where 1 CU = 1 vCPU + 4 GiB memory. When SpecType is memory-optimized, 1 CU = 1 vCPU + 8 GiB memory.
        :param pulumi.Input[_builtins.str] description: Description of node group.
        :param pulumi.Input[_builtins.int] disk_number: Number of disks.
        :param pulumi.Input[_builtins.int] duration: Duration of node group.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.bool] fast_mode: Whether to restart in fast restart mode. The default is false.
               - true: Reboots the compute node in fast restart mode. Restart computing nodes in multiple batches, restart in parallel within a batch, and execute serially between batches;
               - false: Restarts the compute node in rolling restart mode.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] local_storage_instance_type: Node group local SSD instance specification. This value is only relevant when based on ECS instances and SpecType is set to local SSD/large-scale storage.
        :param pulumi.Input[_builtins.str] node_group_id: The ID of the node group.
        :param pulumi.Input[_builtins.str] node_group_name: The name of the node group.
        :param pulumi.Input[_builtins.str] pay_type: Payment type:
               - PrePaid: Subscription (prepaid).
               - PostPaid: Pay-as-you-go (postpaid).
        :param pulumi.Input[_builtins.str] pricing_cycle: Unit of purchase duration:
               - Month
               - Year
               
               This is only applicable when payType is set to PrePaid.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the node group.
        :param pulumi.Input[_builtins.int] resident_node_number: Number of nodes.
        :param pulumi.Input[_builtins.str] spec_type: Node group spec types include the following:
               - standard: Standard edition.
               - localSSD: Local SSD.
               - bigData: Large-scale storage.
               - ramEnhanced: Memory-enhanced type.
               - networkEnhanced: Network-enhanced type.
        :param pulumi.Input[_builtins.str] status: Node group status, including the following values:_FAILED: Creation failed._CONFIG: Modifying configuration._TIMEZONE: Modifying timezone._SCALING_OUT: Elastic scaling out._SCALING_IN: Elastic scaling in._OUT: Scaling out._IN: Scaling in._UP: Scaling up (upgrading configuration)._DOWN: Scaling down (downgrading configuration)._PUBLIC_NETWORK: Enabling public network._PUBLIC_NETWORK: Disabling public network._AZ: Switching availability zones.
        :param pulumi.Input[_builtins.str] storage_performance_level: Performance levels of the cloud disk. Includes the following values:
               - pl0: Maximum random read/write IOPS of a single disk is 10,000.
               - pl1: Maximum random read/write IOPS of a single disk is 50,000.
               - pl2: Maximum random read/write IOPS of a single disk is 100,000.
               - pl3: Maximum random read/write IOPS of a single disk is 1,000,000.
        :param pulumi.Input[_builtins.int] storage_size: Storage size, measured in GiB.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if cu is not None:
            pulumi.set(__self__, "cu", cu)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_number is not None:
            pulumi.set(__self__, "disk_number", disk_number)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if fast_mode is not None:
            pulumi.set(__self__, "fast_mode", fast_mode)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if local_storage_instance_type is not None:
            pulumi.set(__self__, "local_storage_instance_type", local_storage_instance_type)
        if node_group_id is not None:
            pulumi.set(__self__, "node_group_id", node_group_id)
        if node_group_name is not None:
            pulumi.set(__self__, "node_group_name", node_group_name)
        if pay_type is not None:
            pulumi.set(__self__, "pay_type", pay_type)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if promotion_option_no is not None:
            pulumi.set(__self__, "promotion_option_no", promotion_option_no)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resident_node_number is not None:
            pulumi.set(__self__, "resident_node_number", resident_node_number)
        if spec_type is not None:
            pulumi.set(__self__, "spec_type", spec_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_performance_level is not None:
            pulumi.set(__self__, "storage_performance_level", storage_performance_level)
        if storage_size is not None:
            pulumi.set(__self__, "storage_size", storage_size)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether auto-renewal is enabled.

        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the node group.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def cu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of CUs. CU (Compute Unit) is the basic unit of service measurement, where 1 CU = 1 vCPU + 4 GiB memory. When SpecType is memory-optimized, 1 CU = 1 vCPU + 8 GiB memory.
        """
        return pulumi.get(self, "cu")

    @cu.setter
    def cu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cu", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of node group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskNumber")
    def disk_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of disks.
        """
        return pulumi.get(self, "disk_number")

    @disk_number.setter
    def disk_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_number", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration of node group.

        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="fastMode")
    def fast_mode(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to restart in fast restart mode. The default is false.
        - true: Reboots the compute node in fast restart mode. Restart computing nodes in multiple batches, restart in parallel within a batch, and execute serially between batches;
        - false: Restarts the compute node in rolling restart mode.

        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "fast_mode")

    @fast_mode.setter
    def fast_mode(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fast_mode", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="localStorageInstanceType")
    def local_storage_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node group local SSD instance specification. This value is only relevant when based on ECS instances and SpecType is set to local SSD/large-scale storage.
        """
        return pulumi.get(self, "local_storage_instance_type")

    @local_storage_instance_type.setter
    def local_storage_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_storage_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupId")
    def node_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the node group.
        """
        return pulumi.get(self, "node_group_id")

    @node_group_id.setter
    def node_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_group_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the node group.
        """
        return pulumi.get(self, "node_group_name")

    @node_group_name.setter
    def node_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_group_name", value)

    @_builtins.property
    @pulumi.getter(name="payType")
    def pay_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Payment type:
        - PrePaid: Subscription (prepaid).
        - PostPaid: Pay-as-you-go (postpaid).
        """
        return pulumi.get(self, "pay_type")

    @pay_type.setter
    def pay_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pay_type", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unit of purchase duration:
        - Month
        - Year

        This is only applicable when payType is set to PrePaid.

        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="promotionOptionNo")
    def promotion_option_no(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "promotion_option_no")

    @promotion_option_no.setter
    def promotion_option_no(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "promotion_option_no", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the node group.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="residentNodeNumber")
    def resident_node_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of nodes.
        """
        return pulumi.get(self, "resident_node_number")

    @resident_node_number.setter
    def resident_node_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resident_node_number", value)

    @_builtins.property
    @pulumi.getter(name="specType")
    def spec_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node group spec types include the following:
        - standard: Standard edition.
        - localSSD: Local SSD.
        - bigData: Large-scale storage.
        - ramEnhanced: Memory-enhanced type.
        - networkEnhanced: Network-enhanced type.
        """
        return pulumi.get(self, "spec_type")

    @spec_type.setter
    def spec_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spec_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node group status, including the following values:_FAILED: Creation failed._CONFIG: Modifying configuration._TIMEZONE: Modifying timezone._SCALING_OUT: Elastic scaling out._SCALING_IN: Elastic scaling in._OUT: Scaling out._IN: Scaling in._UP: Scaling up (upgrading configuration)._DOWN: Scaling down (downgrading configuration)._PUBLIC_NETWORK: Enabling public network._PUBLIC_NETWORK: Disabling public network._AZ: Switching availability zones.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storagePerformanceLevel")
    def storage_performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Performance levels of the cloud disk. Includes the following values:
        - pl0: Maximum random read/write IOPS of a single disk is 10,000.
        - pl1: Maximum random read/write IOPS of a single disk is 50,000.
        - pl2: Maximum random read/write IOPS of a single disk is 100,000.
        - pl3: Maximum random read/write IOPS of a single disk is 1,000,000.
        """
        return pulumi.get(self, "storage_performance_level")

    @storage_performance_level.setter
    def storage_performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_performance_level", value)

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Storage size, measured in GiB.
        """
        return pulumi.get(self, "storage_size")

    @storage_size.setter
    def storage_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_size", value)


@pulumi.type_token("alicloud:starrocks/nodeGroup:NodeGroup")
class NodeGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 cu: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_number: Optional[pulumi.Input[_builtins.int]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 fast_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 local_storage_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
                 resident_node_number: Optional[pulumi.Input[_builtins.int]] = None,
                 spec_type: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Star Rocks Node Group resource.

        For information about Star Rocks Node Group and how to use it, see [What is Node Group](https://next.api.alibabacloud.com/document/starrocks/2022-10-19/CreateNodeGroup).

        > **NOTE:** Available since v1.262.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        defaultq6pc_fe = alicloud.vpc.Network("defaultq6pcFe",
            cidr_block="172.16.0.0/12",
            vpc_name="example-vpc-487")
        defaultujlpy_g = alicloud.vpc.Switch("defaultujlpyG",
            vpc_id=defaultq6pc_fe.id,
            zone_id="cn-hangzhou-i",
            cidr_block="172.16.0.0/24",
            vswitch_name="sr-example-ng")
        defaultvjnp_m0 = alicloud.starrocks.Instance("defaultvjnpM0",
            cluster_zone_id="cn-hangzhou-i",
            encrypted=False,
            auto_renew=False,
            pay_type="postPaid",
            frontend_node_groups=[{
                "cu": 8,
                "storage_size": 100,
                "storage_performance_level": "pl1",
                "disk_number": 1,
                "zone_id": "cn-hangzhou-i",
                "spec_type": "standard",
                "resident_node_number": 1,
            }],
            instance_name="t1",
            vswitches=[{
                "zone_id": "cn-hangzhou-i",
                "vswitch_id": defaultujlpy_g.id,
            }],
            vpc_id=defaultq6pc_fe.id,
            version="3.3",
            run_mode="shared_data",
            package_type="official",
            oss_accessing_role_name="AliyunEMRStarRocksAccessingOSSRolecn",
            admin_password="1qaz@QAZ",
            backend_node_groups=[{
                "cu": 8,
                "storage_size": 200,
                "zone_id": "cn-hangzhou-i",
                "spec_type": "standard",
                "resident_node_number": 3,
                "disk_number": 1,
                "storage_performance_level": "pl1",
            }])
        default = alicloud.starrocks.NodeGroup("default",
            description="example_desc",
            node_group_name="ng_676",
            instance_id=defaultvjnp_m0.id,
            spec_type="standard",
            storage_performance_level="pl1",
            pricing_cycle="1",
            auto_renew=False,
            storage_size=200,
            duration=1,
            pay_type="postPaid",
            cu=8,
            disk_number=1,
            resident_node_number=1,
            local_storage_instance_type="non_local_storage",
            promotion_option_no="blank")
        ```

        ## Import

        Star Rocks Node Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:starrocks/nodeGroup:NodeGroup example <instance_id>:<node_group_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether auto-renewal is enabled.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.int] cu: Number of CUs. CU (Compute Unit) is the basic unit of service measurement, where 1 CU = 1 vCPU + 4 GiB memory. When SpecType is memory-optimized, 1 CU = 1 vCPU + 8 GiB memory.
        :param pulumi.Input[_builtins.str] description: Description of node group.
        :param pulumi.Input[_builtins.int] disk_number: Number of disks.
        :param pulumi.Input[_builtins.int] duration: Duration of node group.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.bool] fast_mode: Whether to restart in fast restart mode. The default is false.
               - true: Reboots the compute node in fast restart mode. Restart computing nodes in multiple batches, restart in parallel within a batch, and execute serially between batches;
               - false: Restarts the compute node in rolling restart mode.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] local_storage_instance_type: Node group local SSD instance specification. This value is only relevant when based on ECS instances and SpecType is set to local SSD/large-scale storage.
        :param pulumi.Input[_builtins.str] node_group_name: The name of the node group.
        :param pulumi.Input[_builtins.str] pay_type: Payment type:
               - PrePaid: Subscription (prepaid).
               - PostPaid: Pay-as-you-go (postpaid).
        :param pulumi.Input[_builtins.str] pricing_cycle: Unit of purchase duration:
               - Month
               - Year
               
               This is only applicable when payType is set to PrePaid.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.int] resident_node_number: Number of nodes.
        :param pulumi.Input[_builtins.str] spec_type: Node group spec types include the following:
               - standard: Standard edition.
               - localSSD: Local SSD.
               - bigData: Large-scale storage.
               - ramEnhanced: Memory-enhanced type.
               - networkEnhanced: Network-enhanced type.
        :param pulumi.Input[_builtins.str] storage_performance_level: Performance levels of the cloud disk. Includes the following values:
               - pl0: Maximum random read/write IOPS of a single disk is 10,000.
               - pl1: Maximum random read/write IOPS of a single disk is 50,000.
               - pl2: Maximum random read/write IOPS of a single disk is 100,000.
               - pl3: Maximum random read/write IOPS of a single disk is 1,000,000.
        :param pulumi.Input[_builtins.int] storage_size: Storage size, measured in GiB.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NodeGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Star Rocks Node Group resource.

        For information about Star Rocks Node Group and how to use it, see [What is Node Group](https://next.api.alibabacloud.com/document/starrocks/2022-10-19/CreateNodeGroup).

        > **NOTE:** Available since v1.262.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        defaultq6pc_fe = alicloud.vpc.Network("defaultq6pcFe",
            cidr_block="172.16.0.0/12",
            vpc_name="example-vpc-487")
        defaultujlpy_g = alicloud.vpc.Switch("defaultujlpyG",
            vpc_id=defaultq6pc_fe.id,
            zone_id="cn-hangzhou-i",
            cidr_block="172.16.0.0/24",
            vswitch_name="sr-example-ng")
        defaultvjnp_m0 = alicloud.starrocks.Instance("defaultvjnpM0",
            cluster_zone_id="cn-hangzhou-i",
            encrypted=False,
            auto_renew=False,
            pay_type="postPaid",
            frontend_node_groups=[{
                "cu": 8,
                "storage_size": 100,
                "storage_performance_level": "pl1",
                "disk_number": 1,
                "zone_id": "cn-hangzhou-i",
                "spec_type": "standard",
                "resident_node_number": 1,
            }],
            instance_name="t1",
            vswitches=[{
                "zone_id": "cn-hangzhou-i",
                "vswitch_id": defaultujlpy_g.id,
            }],
            vpc_id=defaultq6pc_fe.id,
            version="3.3",
            run_mode="shared_data",
            package_type="official",
            oss_accessing_role_name="AliyunEMRStarRocksAccessingOSSRolecn",
            admin_password="1qaz@QAZ",
            backend_node_groups=[{
                "cu": 8,
                "storage_size": 200,
                "zone_id": "cn-hangzhou-i",
                "spec_type": "standard",
                "resident_node_number": 3,
                "disk_number": 1,
                "storage_performance_level": "pl1",
            }])
        default = alicloud.starrocks.NodeGroup("default",
            description="example_desc",
            node_group_name="ng_676",
            instance_id=defaultvjnp_m0.id,
            spec_type="standard",
            storage_performance_level="pl1",
            pricing_cycle="1",
            auto_renew=False,
            storage_size=200,
            duration=1,
            pay_type="postPaid",
            cu=8,
            disk_number=1,
            resident_node_number=1,
            local_storage_instance_type="non_local_storage",
            promotion_option_no="blank")
        ```

        ## Import

        Star Rocks Node Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:starrocks/nodeGroup:NodeGroup example <instance_id>:<node_group_id>
        ```

        :param str resource_name: The name of the resource.
        :param NodeGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodeGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 cu: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_number: Optional[pulumi.Input[_builtins.int]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 fast_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 local_storage_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
                 resident_node_number: Optional[pulumi.Input[_builtins.int]] = None,
                 spec_type: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodeGroupArgs.__new__(NodeGroupArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["cu"] = cu
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_number"] = disk_number
            __props__.__dict__["duration"] = duration
            __props__.__dict__["fast_mode"] = fast_mode
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["local_storage_instance_type"] = local_storage_instance_type
            __props__.__dict__["node_group_name"] = node_group_name
            __props__.__dict__["pay_type"] = pay_type
            __props__.__dict__["pricing_cycle"] = pricing_cycle
            __props__.__dict__["promotion_option_no"] = promotion_option_no
            __props__.__dict__["resident_node_number"] = resident_node_number
            __props__.__dict__["spec_type"] = spec_type
            __props__.__dict__["storage_performance_level"] = storage_performance_level
            __props__.__dict__["storage_size"] = storage_size
            __props__.__dict__["create_time"] = None
            __props__.__dict__["node_group_id"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(NodeGroup, __self__).__init__(
            'alicloud:starrocks/nodeGroup:NodeGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            cu: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_number: Optional[pulumi.Input[_builtins.int]] = None,
            duration: Optional[pulumi.Input[_builtins.int]] = None,
            fast_mode: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            local_storage_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            node_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            node_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            pay_type: Optional[pulumi.Input[_builtins.str]] = None,
            pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
            promotion_option_no: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resident_node_number: Optional[pulumi.Input[_builtins.int]] = None,
            spec_type: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
            storage_size: Optional[pulumi.Input[_builtins.int]] = None) -> 'NodeGroup':
        """
        Get an existing NodeGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether auto-renewal is enabled.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the node group.
        :param pulumi.Input[_builtins.int] cu: Number of CUs. CU (Compute Unit) is the basic unit of service measurement, where 1 CU = 1 vCPU + 4 GiB memory. When SpecType is memory-optimized, 1 CU = 1 vCPU + 8 GiB memory.
        :param pulumi.Input[_builtins.str] description: Description of node group.
        :param pulumi.Input[_builtins.int] disk_number: Number of disks.
        :param pulumi.Input[_builtins.int] duration: Duration of node group.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.bool] fast_mode: Whether to restart in fast restart mode. The default is false.
               - true: Reboots the compute node in fast restart mode. Restart computing nodes in multiple batches, restart in parallel within a batch, and execute serially between batches;
               - false: Restarts the compute node in rolling restart mode.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] local_storage_instance_type: Node group local SSD instance specification. This value is only relevant when based on ECS instances and SpecType is set to local SSD/large-scale storage.
        :param pulumi.Input[_builtins.str] node_group_id: The ID of the node group.
        :param pulumi.Input[_builtins.str] node_group_name: The name of the node group.
        :param pulumi.Input[_builtins.str] pay_type: Payment type:
               - PrePaid: Subscription (prepaid).
               - PostPaid: Pay-as-you-go (postpaid).
        :param pulumi.Input[_builtins.str] pricing_cycle: Unit of purchase duration:
               - Month
               - Year
               
               This is only applicable when payType is set to PrePaid.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the node group.
        :param pulumi.Input[_builtins.int] resident_node_number: Number of nodes.
        :param pulumi.Input[_builtins.str] spec_type: Node group spec types include the following:
               - standard: Standard edition.
               - localSSD: Local SSD.
               - bigData: Large-scale storage.
               - ramEnhanced: Memory-enhanced type.
               - networkEnhanced: Network-enhanced type.
        :param pulumi.Input[_builtins.str] status: Node group status, including the following values:_FAILED: Creation failed._CONFIG: Modifying configuration._TIMEZONE: Modifying timezone._SCALING_OUT: Elastic scaling out._SCALING_IN: Elastic scaling in._OUT: Scaling out._IN: Scaling in._UP: Scaling up (upgrading configuration)._DOWN: Scaling down (downgrading configuration)._PUBLIC_NETWORK: Enabling public network._PUBLIC_NETWORK: Disabling public network._AZ: Switching availability zones.
        :param pulumi.Input[_builtins.str] storage_performance_level: Performance levels of the cloud disk. Includes the following values:
               - pl0: Maximum random read/write IOPS of a single disk is 10,000.
               - pl1: Maximum random read/write IOPS of a single disk is 50,000.
               - pl2: Maximum random read/write IOPS of a single disk is 100,000.
               - pl3: Maximum random read/write IOPS of a single disk is 1,000,000.
        :param pulumi.Input[_builtins.int] storage_size: Storage size, measured in GiB.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NodeGroupState.__new__(_NodeGroupState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["cu"] = cu
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_number"] = disk_number
        __props__.__dict__["duration"] = duration
        __props__.__dict__["fast_mode"] = fast_mode
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["local_storage_instance_type"] = local_storage_instance_type
        __props__.__dict__["node_group_id"] = node_group_id
        __props__.__dict__["node_group_name"] = node_group_name
        __props__.__dict__["pay_type"] = pay_type
        __props__.__dict__["pricing_cycle"] = pricing_cycle
        __props__.__dict__["promotion_option_no"] = promotion_option_no
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resident_node_number"] = resident_node_number
        __props__.__dict__["spec_type"] = spec_type
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_performance_level"] = storage_performance_level
        __props__.__dict__["storage_size"] = storage_size
        return NodeGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether auto-renewal is enabled.

        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the node group.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def cu(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of CUs. CU (Compute Unit) is the basic unit of service measurement, where 1 CU = 1 vCPU + 4 GiB memory. When SpecType is memory-optimized, 1 CU = 1 vCPU + 8 GiB memory.
        """
        return pulumi.get(self, "cu")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of node group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskNumber")
    def disk_number(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of disks.
        """
        return pulumi.get(self, "disk_number")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Duration of node group.

        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="fastMode")
    def fast_mode(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to restart in fast restart mode. The default is false.
        - true: Reboots the compute node in fast restart mode. Restart computing nodes in multiple batches, restart in parallel within a batch, and execute serially between batches;
        - false: Restarts the compute node in rolling restart mode.

        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "fast_mode")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="localStorageInstanceType")
    def local_storage_instance_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Node group local SSD instance specification. This value is only relevant when based on ECS instances and SpecType is set to local SSD/large-scale storage.
        """
        return pulumi.get(self, "local_storage_instance_type")

    @_builtins.property
    @pulumi.getter(name="nodeGroupId")
    def node_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the node group.
        """
        return pulumi.get(self, "node_group_id")

    @_builtins.property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the node group.
        """
        return pulumi.get(self, "node_group_name")

    @_builtins.property
    @pulumi.getter(name="payType")
    def pay_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Payment type:
        - PrePaid: Subscription (prepaid).
        - PostPaid: Pay-as-you-go (postpaid).
        """
        return pulumi.get(self, "pay_type")

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unit of purchase duration:
        - Month
        - Year

        This is only applicable when payType is set to PrePaid.

        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "pricing_cycle")

    @_builtins.property
    @pulumi.getter(name="promotionOptionNo")
    def promotion_option_no(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "promotion_option_no")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the node group.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="residentNodeNumber")
    def resident_node_number(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of nodes.
        """
        return pulumi.get(self, "resident_node_number")

    @_builtins.property
    @pulumi.getter(name="specType")
    def spec_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Node group spec types include the following:
        - standard: Standard edition.
        - localSSD: Local SSD.
        - bigData: Large-scale storage.
        - ramEnhanced: Memory-enhanced type.
        - networkEnhanced: Network-enhanced type.
        """
        return pulumi.get(self, "spec_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Node group status, including the following values:_FAILED: Creation failed._CONFIG: Modifying configuration._TIMEZONE: Modifying timezone._SCALING_OUT: Elastic scaling out._SCALING_IN: Elastic scaling in._OUT: Scaling out._IN: Scaling in._UP: Scaling up (upgrading configuration)._DOWN: Scaling down (downgrading configuration)._PUBLIC_NETWORK: Enabling public network._PUBLIC_NETWORK: Disabling public network._AZ: Switching availability zones.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storagePerformanceLevel")
    def storage_performance_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Performance levels of the cloud disk. Includes the following values:
        - pl0: Maximum random read/write IOPS of a single disk is 10,000.
        - pl1: Maximum random read/write IOPS of a single disk is 50,000.
        - pl2: Maximum random read/write IOPS of a single disk is 100,000.
        - pl3: Maximum random read/write IOPS of a single disk is 1,000,000.
        """
        return pulumi.get(self, "storage_performance_level")

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Storage size, measured in GiB.
        """
        return pulumi.get(self, "storage_size")

