# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PolicyArgs', 'Policy']

@pulumi.input_type
class PolicyArgs:
    def __init__(__self__, *,
                 policy_content: pulumi.Input[_builtins.str],
                 policy_name: pulumi.Input[_builtins.str],
                 policy_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Policy resource.
        :param pulumi.Input[_builtins.str] policy_content: The document of the tag policy.
        :param pulumi.Input[_builtins.str] policy_name: The name of the tag policy. The name must be 1 to 128 characters in length and can contain letters, digits, and underscores (_).
        :param pulumi.Input[_builtins.str] policy_desc: The description of the policy. The description must be 1 to 512 characters in length.
        :param pulumi.Input[_builtins.str] user_type: The mode of the Tag Policy feature. Valid values: `USER`, `RD`.
        """
        pulumi.set(__self__, "policy_content", policy_content)
        pulumi.set(__self__, "policy_name", policy_name)
        if policy_desc is not None:
            pulumi.set(__self__, "policy_desc", policy_desc)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)

    @_builtins.property
    @pulumi.getter(name="policyContent")
    def policy_content(self) -> pulumi.Input[_builtins.str]:
        """
        The document of the tag policy.
        """
        return pulumi.get(self, "policy_content")

    @policy_content.setter
    def policy_content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_content", value)

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the tag policy. The name must be 1 to 128 characters in length and can contain letters, digits, and underscores (_).
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_name", value)

    @_builtins.property
    @pulumi.getter(name="policyDesc")
    def policy_desc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the policy. The description must be 1 to 512 characters in length.
        """
        return pulumi.get(self, "policy_desc")

    @policy_desc.setter
    def policy_desc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_desc", value)

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode of the Tag Policy feature. Valid values: `USER`, `RD`.
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_type", value)


@pulumi.input_type
class _PolicyState:
    def __init__(__self__, *,
                 policy_content: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Policy resources.
        :param pulumi.Input[_builtins.str] policy_content: The document of the tag policy.
        :param pulumi.Input[_builtins.str] policy_desc: The description of the policy. The description must be 1 to 512 characters in length.
        :param pulumi.Input[_builtins.str] policy_name: The name of the tag policy. The name must be 1 to 128 characters in length and can contain letters, digits, and underscores (_).
        :param pulumi.Input[_builtins.str] user_type: The mode of the Tag Policy feature. Valid values: `USER`, `RD`.
        """
        if policy_content is not None:
            pulumi.set(__self__, "policy_content", policy_content)
        if policy_desc is not None:
            pulumi.set(__self__, "policy_desc", policy_desc)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)

    @_builtins.property
    @pulumi.getter(name="policyContent")
    def policy_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The document of the tag policy.
        """
        return pulumi.get(self, "policy_content")

    @policy_content.setter
    def policy_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_content", value)

    @_builtins.property
    @pulumi.getter(name="policyDesc")
    def policy_desc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the policy. The description must be 1 to 512 characters in length.
        """
        return pulumi.get(self, "policy_desc")

    @policy_desc.setter
    def policy_desc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_desc", value)

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the tag policy. The name must be 1 to 128 characters in length and can contain letters, digits, and underscores (_).
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_name", value)

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode of the Tag Policy feature. Valid values: `USER`, `RD`.
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_type", value)


@pulumi.type_token("alicloud:tag/policy:Policy")
class Policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_content: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a TAG Policy resource.

        For information about TAG Policy and how to use it, see [What is Policy](https://www.alibabacloud.com/help/en/resource-management/latest/create-policy).

        > **NOTE:** Available since v1.203.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example = alicloud.tag.Policy("example",
            policy_name=name,
            policy_desc=name,
            user_type="USER",
            policy_content="\\\\t\\\\t{\\\\\\"tags\\\\\\":{\\\\\\"CostCenter\\\\\\":{\\\\\\"tag_value\\\\\\":{\\\\\\"@@assign\\\\\\":[\\\\\\"Beijing\\\\\\",\\\\\\"Shanghai\\\\\\"]},\\\\\\"tag_key\\\\\\":{\\\\\\"@@assign\\\\\\":\\\\\\"CostCenter\\\\\\"}}}}\\n")
        ```

        ## Import

        TAG Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:tag/policy:Policy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] policy_content: The document of the tag policy.
        :param pulumi.Input[_builtins.str] policy_desc: The description of the policy. The description must be 1 to 512 characters in length.
        :param pulumi.Input[_builtins.str] policy_name: The name of the tag policy. The name must be 1 to 128 characters in length and can contain letters, digits, and underscores (_).
        :param pulumi.Input[_builtins.str] user_type: The mode of the Tag Policy feature. Valid values: `USER`, `RD`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a TAG Policy resource.

        For information about TAG Policy and how to use it, see [What is Policy](https://www.alibabacloud.com/help/en/resource-management/latest/create-policy).

        > **NOTE:** Available since v1.203.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example = alicloud.tag.Policy("example",
            policy_name=name,
            policy_desc=name,
            user_type="USER",
            policy_content="\\\\t\\\\t{\\\\\\"tags\\\\\\":{\\\\\\"CostCenter\\\\\\":{\\\\\\"tag_value\\\\\\":{\\\\\\"@@assign\\\\\\":[\\\\\\"Beijing\\\\\\",\\\\\\"Shanghai\\\\\\"]},\\\\\\"tag_key\\\\\\":{\\\\\\"@@assign\\\\\\":\\\\\\"CostCenter\\\\\\"}}}}\\n")
        ```

        ## Import

        TAG Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:tag/policy:Policy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param PolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_content: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyArgs.__new__(PolicyArgs)

            if policy_content is None and not opts.urn:
                raise TypeError("Missing required property 'policy_content'")
            __props__.__dict__["policy_content"] = policy_content
            __props__.__dict__["policy_desc"] = policy_desc
            if policy_name is None and not opts.urn:
                raise TypeError("Missing required property 'policy_name'")
            __props__.__dict__["policy_name"] = policy_name
            __props__.__dict__["user_type"] = user_type
        super(Policy, __self__).__init__(
            'alicloud:tag/policy:Policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            policy_content: Optional[pulumi.Input[_builtins.str]] = None,
            policy_desc: Optional[pulumi.Input[_builtins.str]] = None,
            policy_name: Optional[pulumi.Input[_builtins.str]] = None,
            user_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Policy':
        """
        Get an existing Policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] policy_content: The document of the tag policy.
        :param pulumi.Input[_builtins.str] policy_desc: The description of the policy. The description must be 1 to 512 characters in length.
        :param pulumi.Input[_builtins.str] policy_name: The name of the tag policy. The name must be 1 to 128 characters in length and can contain letters, digits, and underscores (_).
        :param pulumi.Input[_builtins.str] user_type: The mode of the Tag Policy feature. Valid values: `USER`, `RD`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyState.__new__(_PolicyState)

        __props__.__dict__["policy_content"] = policy_content
        __props__.__dict__["policy_desc"] = policy_desc
        __props__.__dict__["policy_name"] = policy_name
        __props__.__dict__["user_type"] = user_type
        return Policy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="policyContent")
    def policy_content(self) -> pulumi.Output[_builtins.str]:
        """
        The document of the tag policy.
        """
        return pulumi.get(self, "policy_content")

    @_builtins.property
    @pulumi.getter(name="policyDesc")
    def policy_desc(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the policy. The description must be 1 to 512 characters in length.
        """
        return pulumi.get(self, "policy_desc")

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the tag policy. The name must be 1 to 128 characters in length and can contain letters, digits, and underscores (_).
        """
        return pulumi.get(self, "policy_name")

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> pulumi.Output[_builtins.str]:
        """
        The mode of the Tag Policy feature. Valid values: `USER`, `RD`.
        """
        return pulumi.get(self, "user_type")

