# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AssetSelectionConfigArgs', 'AssetSelectionConfig']

@pulumi.input_type
class AssetSelectionConfigArgs:
    def __init__(__self__, *,
                 business_type: pulumi.Input[_builtins.str],
                 target_type: pulumi.Input[_builtins.str],
                 platform: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AssetSelectionConfig resource.
        :param pulumi.Input[_builtins.str] business_type: The first ID of the resource
        :param pulumi.Input[_builtins.str] target_type: Target object type.
        :param pulumi.Input[_builtins.str] platform: The operating system type.
        """
        pulumi.set(__self__, "business_type", business_type)
        pulumi.set(__self__, "target_type", target_type)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)

    @_builtins.property
    @pulumi.getter(name="businessType")
    def business_type(self) -> pulumi.Input[_builtins.str]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "business_type")

    @business_type.setter
    def business_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "business_type", value)

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Input[_builtins.str]:
        """
        Target object type.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_type", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operating system type.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform", value)


@pulumi.input_type
class _AssetSelectionConfigState:
    def __init__(__self__, *,
                 business_type: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 target_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AssetSelectionConfig resources.
        :param pulumi.Input[_builtins.str] business_type: The first ID of the resource
        :param pulumi.Input[_builtins.str] platform: The operating system type.
        :param pulumi.Input[_builtins.str] target_type: Target object type.
        """
        if business_type is not None:
            pulumi.set(__self__, "business_type", business_type)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)

    @_builtins.property
    @pulumi.getter(name="businessType")
    def business_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "business_type")

    @business_type.setter
    def business_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "business_type", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operating system type.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform", value)

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target object type.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_type", value)


@pulumi.type_token("alicloud:threatdetection/assetSelectionConfig:AssetSelectionConfig")
class AssetSelectionConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 business_type: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 target_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Threat Detection Asset Selection Config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:threatdetection/assetSelectionConfig:AssetSelectionConfig example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] business_type: The first ID of the resource
        :param pulumi.Input[_builtins.str] platform: The operating system type.
        :param pulumi.Input[_builtins.str] target_type: Target object type.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AssetSelectionConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Threat Detection Asset Selection Config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:threatdetection/assetSelectionConfig:AssetSelectionConfig example <id>
        ```

        :param str resource_name: The name of the resource.
        :param AssetSelectionConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssetSelectionConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 business_type: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 target_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssetSelectionConfigArgs.__new__(AssetSelectionConfigArgs)

            if business_type is None and not opts.urn:
                raise TypeError("Missing required property 'business_type'")
            __props__.__dict__["business_type"] = business_type
            __props__.__dict__["platform"] = platform
            if target_type is None and not opts.urn:
                raise TypeError("Missing required property 'target_type'")
            __props__.__dict__["target_type"] = target_type
        super(AssetSelectionConfig, __self__).__init__(
            'alicloud:threatdetection/assetSelectionConfig:AssetSelectionConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            business_type: Optional[pulumi.Input[_builtins.str]] = None,
            platform: Optional[pulumi.Input[_builtins.str]] = None,
            target_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'AssetSelectionConfig':
        """
        Get an existing AssetSelectionConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] business_type: The first ID of the resource
        :param pulumi.Input[_builtins.str] platform: The operating system type.
        :param pulumi.Input[_builtins.str] target_type: Target object type.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AssetSelectionConfigState.__new__(_AssetSelectionConfigState)

        __props__.__dict__["business_type"] = business_type
        __props__.__dict__["platform"] = platform
        __props__.__dict__["target_type"] = target_type
        return AssetSelectionConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="businessType")
    def business_type(self) -> pulumi.Output[_builtins.str]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "business_type")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The operating system type.
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Output[_builtins.str]:
        """
        Target object type.
        """
        return pulumi.get(self, "target_type")

