# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HoneypotPresetArgs', 'HoneypotPreset']

@pulumi.input_type
class HoneypotPresetArgs:
    def __init__(__self__, *,
                 honeypot_image_name: pulumi.Input[_builtins.str],
                 meta: pulumi.Input['HoneypotPresetMetaArgs'],
                 node_id: pulumi.Input[_builtins.str],
                 preset_name: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a HoneypotPreset resource.
        :param pulumi.Input[_builtins.str] honeypot_image_name: Honeypot mirror name
        :param pulumi.Input['HoneypotPresetMetaArgs'] meta: Honeypot template custom parameters. See `meta` below.
        :param pulumi.Input[_builtins.str] node_id: Unique id of management node
        :param pulumi.Input[_builtins.str] preset_name: Honeypot template custom name
        """
        pulumi.set(__self__, "honeypot_image_name", honeypot_image_name)
        pulumi.set(__self__, "meta", meta)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "preset_name", preset_name)

    @_builtins.property
    @pulumi.getter(name="honeypotImageName")
    def honeypot_image_name(self) -> pulumi.Input[_builtins.str]:
        """
        Honeypot mirror name
        """
        return pulumi.get(self, "honeypot_image_name")

    @honeypot_image_name.setter
    def honeypot_image_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "honeypot_image_name", value)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> pulumi.Input['HoneypotPresetMetaArgs']:
        """
        Honeypot template custom parameters. See `meta` below.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: pulumi.Input['HoneypotPresetMetaArgs']):
        pulumi.set(self, "meta", value)

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique id of management node
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node_id", value)

    @_builtins.property
    @pulumi.getter(name="presetName")
    def preset_name(self) -> pulumi.Input[_builtins.str]:
        """
        Honeypot template custom name
        """
        return pulumi.get(self, "preset_name")

    @preset_name.setter
    def preset_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "preset_name", value)


@pulumi.input_type
class _HoneypotPresetState:
    def __init__(__self__, *,
                 honeypot_image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 honeypot_preset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 meta: Optional[pulumi.Input['HoneypotPresetMetaArgs']] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 preset_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HoneypotPreset resources.
        :param pulumi.Input[_builtins.str] honeypot_image_name: Honeypot mirror name
        :param pulumi.Input[_builtins.str] honeypot_preset_id: Unique ID of honeypot Template
        :param pulumi.Input['HoneypotPresetMetaArgs'] meta: Honeypot template custom parameters. See `meta` below.
        :param pulumi.Input[_builtins.str] node_id: Unique id of management node
        :param pulumi.Input[_builtins.str] preset_name: Honeypot template custom name
        """
        if honeypot_image_name is not None:
            pulumi.set(__self__, "honeypot_image_name", honeypot_image_name)
        if honeypot_preset_id is not None:
            pulumi.set(__self__, "honeypot_preset_id", honeypot_preset_id)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if preset_name is not None:
            pulumi.set(__self__, "preset_name", preset_name)

    @_builtins.property
    @pulumi.getter(name="honeypotImageName")
    def honeypot_image_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Honeypot mirror name
        """
        return pulumi.get(self, "honeypot_image_name")

    @honeypot_image_name.setter
    def honeypot_image_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "honeypot_image_name", value)

    @_builtins.property
    @pulumi.getter(name="honeypotPresetId")
    def honeypot_preset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique ID of honeypot Template
        """
        return pulumi.get(self, "honeypot_preset_id")

    @honeypot_preset_id.setter
    def honeypot_preset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "honeypot_preset_id", value)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input['HoneypotPresetMetaArgs']]:
        """
        Honeypot template custom parameters. See `meta` below.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input['HoneypotPresetMetaArgs']]):
        pulumi.set(self, "meta", value)

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique id of management node
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_id", value)

    @_builtins.property
    @pulumi.getter(name="presetName")
    def preset_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Honeypot template custom name
        """
        return pulumi.get(self, "preset_name")

    @preset_name.setter
    def preset_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preset_name", value)


@pulumi.type_token("alicloud:threatdetection/honeypotPreset:HoneypotPreset")
class HoneypotPreset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 honeypot_image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 meta: Optional[pulumi.Input[Union['HoneypotPresetMetaArgs', 'HoneypotPresetMetaArgsDict']]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 preset_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Threat Detection Honeypot Preset resource.

        For information about Threat Detection Honeypot Preset and how to use it, see [What is Honeypot Preset](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createhoneypotpreset).

        > **NOTE:** Available since v1.195.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tfexample"
        default = alicloud.threatdetection.get_honeypot_images(name_regex="^ruoyi")
        default_honeypot_node = alicloud.threatdetection.HoneypotNode("default",
            node_name=name,
            available_probe_num=20,
            security_group_probe_ip_lists=["0.0.0.0/0"])
        default_honeypot_preset = alicloud.threatdetection.HoneypotPreset("default",
            preset_name=name,
            node_id=default_honeypot_node.id,
            honeypot_image_name=default.images[0].honeypot_image_name,
            meta={
                "portrait_option": True,
                "burp": "open",
                "trojan_git": "open",
            })
        ```

        ## Import

        Threat Detection Honeypot Preset can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:threatdetection/honeypotPreset:HoneypotPreset example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] honeypot_image_name: Honeypot mirror name
        :param pulumi.Input[Union['HoneypotPresetMetaArgs', 'HoneypotPresetMetaArgsDict']] meta: Honeypot template custom parameters. See `meta` below.
        :param pulumi.Input[_builtins.str] node_id: Unique id of management node
        :param pulumi.Input[_builtins.str] preset_name: Honeypot template custom name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HoneypotPresetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Threat Detection Honeypot Preset resource.

        For information about Threat Detection Honeypot Preset and how to use it, see [What is Honeypot Preset](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createhoneypotpreset).

        > **NOTE:** Available since v1.195.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tfexample"
        default = alicloud.threatdetection.get_honeypot_images(name_regex="^ruoyi")
        default_honeypot_node = alicloud.threatdetection.HoneypotNode("default",
            node_name=name,
            available_probe_num=20,
            security_group_probe_ip_lists=["0.0.0.0/0"])
        default_honeypot_preset = alicloud.threatdetection.HoneypotPreset("default",
            preset_name=name,
            node_id=default_honeypot_node.id,
            honeypot_image_name=default.images[0].honeypot_image_name,
            meta={
                "portrait_option": True,
                "burp": "open",
                "trojan_git": "open",
            })
        ```

        ## Import

        Threat Detection Honeypot Preset can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:threatdetection/honeypotPreset:HoneypotPreset example <id>
        ```

        :param str resource_name: The name of the resource.
        :param HoneypotPresetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HoneypotPresetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 honeypot_image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 meta: Optional[pulumi.Input[Union['HoneypotPresetMetaArgs', 'HoneypotPresetMetaArgsDict']]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 preset_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HoneypotPresetArgs.__new__(HoneypotPresetArgs)

            if honeypot_image_name is None and not opts.urn:
                raise TypeError("Missing required property 'honeypot_image_name'")
            __props__.__dict__["honeypot_image_name"] = honeypot_image_name
            if meta is None and not opts.urn:
                raise TypeError("Missing required property 'meta'")
            __props__.__dict__["meta"] = meta
            if node_id is None and not opts.urn:
                raise TypeError("Missing required property 'node_id'")
            __props__.__dict__["node_id"] = node_id
            if preset_name is None and not opts.urn:
                raise TypeError("Missing required property 'preset_name'")
            __props__.__dict__["preset_name"] = preset_name
            __props__.__dict__["honeypot_preset_id"] = None
        super(HoneypotPreset, __self__).__init__(
            'alicloud:threatdetection/honeypotPreset:HoneypotPreset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            honeypot_image_name: Optional[pulumi.Input[_builtins.str]] = None,
            honeypot_preset_id: Optional[pulumi.Input[_builtins.str]] = None,
            meta: Optional[pulumi.Input[Union['HoneypotPresetMetaArgs', 'HoneypotPresetMetaArgsDict']]] = None,
            node_id: Optional[pulumi.Input[_builtins.str]] = None,
            preset_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'HoneypotPreset':
        """
        Get an existing HoneypotPreset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] honeypot_image_name: Honeypot mirror name
        :param pulumi.Input[_builtins.str] honeypot_preset_id: Unique ID of honeypot Template
        :param pulumi.Input[Union['HoneypotPresetMetaArgs', 'HoneypotPresetMetaArgsDict']] meta: Honeypot template custom parameters. See `meta` below.
        :param pulumi.Input[_builtins.str] node_id: Unique id of management node
        :param pulumi.Input[_builtins.str] preset_name: Honeypot template custom name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HoneypotPresetState.__new__(_HoneypotPresetState)

        __props__.__dict__["honeypot_image_name"] = honeypot_image_name
        __props__.__dict__["honeypot_preset_id"] = honeypot_preset_id
        __props__.__dict__["meta"] = meta
        __props__.__dict__["node_id"] = node_id
        __props__.__dict__["preset_name"] = preset_name
        return HoneypotPreset(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="honeypotImageName")
    def honeypot_image_name(self) -> pulumi.Output[_builtins.str]:
        """
        Honeypot mirror name
        """
        return pulumi.get(self, "honeypot_image_name")

    @_builtins.property
    @pulumi.getter(name="honeypotPresetId")
    def honeypot_preset_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique ID of honeypot Template
        """
        return pulumi.get(self, "honeypot_preset_id")

    @_builtins.property
    @pulumi.getter
    def meta(self) -> pulumi.Output['outputs.HoneypotPresetMeta']:
        """
        Honeypot template custom parameters. See `meta` below.
        """
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique id of management node
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="presetName")
    def preset_name(self) -> pulumi.Output[_builtins.str]:
        """
        Honeypot template custom name
        """
        return pulumi.get(self, "preset_name")

