# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CommonBandwithPackageArgs', 'CommonBandwithPackage']

@pulumi.input_type
class CommonBandwithPackageArgs:
    def __init__(__self__, *,
                 bandwidth: pulumi.Input[_builtins.str],
                 bandwidth_package_name: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CommonBandwithPackage resource.
        :param pulumi.Input[_builtins.str] bandwidth: The maximum bandwidth of the Internet Shared Bandwidth instance. Unit: Mbit/s.
               Valid values: `1` to `1000`. Default value: `1`.
        :param pulumi.Input[_builtins.str] bandwidth_package_name: The description of the EIP bandwidth plan. The description must be 2 to 256 characters in length. It must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.bool] deletion_protection: Specifies whether to enable deletion protection. Valid values:
        :param pulumi.Input[_builtins.str] description: The description of the Internet Shared Bandwidth instance.
               The description must be 0 to 256 characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] force: Specifies whether to forcefully delete the Internet Shared Bandwidth instance. Valid values:
        :param pulumi.Input[_builtins.str] internet_charge_type: Billing method of Internet Shared Bandwidth. Valid values:
               `PayByTraffic`: billed by primary traffic.
               
               - `PayByBandwidth` (default): Billing by bandwidth.
               - `PayBy95`: Billed as Enhanced 95.
               - `PayByDominantTraffic`: billed by primary traffic.
        :param pulumi.Input[_builtins.str] isp: The line type. Valid values:
               
               - `BGP` (default) All regions support BGP (Multi-ISP).
               - `BGP_PRO` BGP (Multi-ISP) Pro lines are available in the China (Hong Kong), Singapore, Japan (Tokyo), Philippines (Manila), Malaysia (Kuala Lumpur), Indonesia (Jakarta), and Thailand (Bangkok) regions.
               
               If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
               
               - `ChinaTelecom`
               - `ChinaUnicom`
               - `ChinaMobile`
               - `ChinaTelecom_L2`
               - `ChinaUnicom_L2`
               - `ChinaMobile_L2`
               
               If your services are deployed in China East 1 Finance, this parameter is required and you must set the value to `BGP_FinanceCloud`.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.120.0. New field 'bandwidth_package_name' instead.
        :param pulumi.Input[_builtins.int] ratio: The percentage of the minimum bandwidth commitment. The value is only `20`.
               
               This parameter is required when the value of `InternetChargeType` is `PayBy95`.
               
               > **NOTE:** This parameter is available only on the Alibaba Cloud China site.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which you want to move the resource.
               
               > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_protection_types: The edition of Anti-DDoS. If you do not set this parameter, Anti-DDoS Origin Basic is used. If you set the value to AntiDDoS_Enhanced, Anti-DDoS Pro(Premium) is used. It is valid when `internet_charge_type` is `PayBy95`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] zone: The zone of the Internet Shared Bandwidth instance. This parameter is required if you create an Internet Shared Bandwidth instance for a cloud box.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        if bandwidth_package_name is not None:
            pulumi.set(__self__, "bandwidth_package_name", bandwidth_package_name)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.120.0. New field 'bandwidth_package_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.120.0. New field 'bandwidth_package_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ratio is not None:
            pulumi.set(__self__, "ratio", ratio)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_protection_types is not None:
            pulumi.set(__self__, "security_protection_types", security_protection_types)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Input[_builtins.str]:
        """
        The maximum bandwidth of the Internet Shared Bandwidth instance. Unit: Mbit/s.
        Valid values: `1` to `1000`. Default value: `1`.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageName")
    def bandwidth_package_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the EIP bandwidth plan. The description must be 2 to 256 characters in length. It must start with a letter but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "bandwidth_package_name")

    @bandwidth_package_name.setter
    def bandwidth_package_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_package_name", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable deletion protection. Valid values:
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Internet Shared Bandwidth instance.
        The description must be 0 to 256 characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to forcefully delete the Internet Shared Bandwidth instance. Valid values:
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Billing method of Internet Shared Bandwidth. Valid values:
        `PayByTraffic`: billed by primary traffic.

        - `PayByBandwidth` (default): Billing by bandwidth.
        - `PayBy95`: Billed as Enhanced 95.
        - `PayByDominantTraffic`: billed by primary traffic.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The line type. Valid values:

        - `BGP` (default) All regions support BGP (Multi-ISP).
        - `BGP_PRO` BGP (Multi-ISP) Pro lines are available in the China (Hong Kong), Singapore, Japan (Tokyo), Philippines (Manila), Malaysia (Kuala Lumpur), Indonesia (Jakarta), and Thailand (Bangkok) regions.

        If you are allowed to use single-ISP bandwidth, you can also use one of the following values:

        - `ChinaTelecom`
        - `ChinaUnicom`
        - `ChinaMobile`
        - `ChinaTelecom_L2`
        - `ChinaUnicom_L2`
        - `ChinaMobile_L2`

        If your services are deployed in China East 1 Finance, this parameter is required and you must set the value to `BGP_FinanceCloud`.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isp", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.120.0. New field 'bandwidth_package_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.120.0. New field 'bandwidth_package_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def ratio(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The percentage of the minimum bandwidth commitment. The value is only `20`.

        This parameter is required when the value of `InternetChargeType` is `PayBy95`.

        > **NOTE:** This parameter is available only on the Alibaba Cloud China site.
        """
        return pulumi.get(self, "ratio")

    @ratio.setter
    def ratio(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ratio", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which you want to move the resource.

        > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityProtectionTypes")
    def security_protection_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The edition of Anti-DDoS. If you do not set this parameter, Anti-DDoS Origin Basic is used. If you set the value to AntiDDoS_Enhanced, Anti-DDoS Pro(Premium) is used. It is valid when `internet_charge_type` is `PayBy95`.
        """
        return pulumi.get(self, "security_protection_types")

    @security_protection_types.setter
    def security_protection_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_protection_types", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone of the Internet Shared Bandwidth instance. This parameter is required if you create an Internet Shared Bandwidth instance for a cloud box.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _CommonBandwithPackageState:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_package_name: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CommonBandwithPackage resources.
        :param pulumi.Input[_builtins.str] bandwidth: The maximum bandwidth of the Internet Shared Bandwidth instance. Unit: Mbit/s.
               Valid values: `1` to `1000`. Default value: `1`.
        :param pulumi.Input[_builtins.str] bandwidth_package_name: The description of the EIP bandwidth plan. The description must be 2 to 256 characters in length. It must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] create_time: The creation time.
        :param pulumi.Input[_builtins.bool] deletion_protection: Specifies whether to enable deletion protection. Valid values:
        :param pulumi.Input[_builtins.str] description: The description of the Internet Shared Bandwidth instance.
               The description must be 0 to 256 characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] force: Specifies whether to forcefully delete the Internet Shared Bandwidth instance. Valid values:
        :param pulumi.Input[_builtins.str] internet_charge_type: Billing method of Internet Shared Bandwidth. Valid values:
               `PayByTraffic`: billed by primary traffic.
               
               - `PayByBandwidth` (default): Billing by bandwidth.
               - `PayBy95`: Billed as Enhanced 95.
               - `PayByDominantTraffic`: billed by primary traffic.
        :param pulumi.Input[_builtins.str] isp: The line type. Valid values:
               
               - `BGP` (default) All regions support BGP (Multi-ISP).
               - `BGP_PRO` BGP (Multi-ISP) Pro lines are available in the China (Hong Kong), Singapore, Japan (Tokyo), Philippines (Manila), Malaysia (Kuala Lumpur), Indonesia (Jakarta), and Thailand (Bangkok) regions.
               
               If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
               
               - `ChinaTelecom`
               - `ChinaUnicom`
               - `ChinaMobile`
               - `ChinaTelecom_L2`
               - `ChinaUnicom_L2`
               - `ChinaMobile_L2`
               
               If your services are deployed in China East 1 Finance, this parameter is required and you must set the value to `BGP_FinanceCloud`.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.120.0. New field 'bandwidth_package_name' instead.
        :param pulumi.Input[_builtins.str] payment_type: The billing type of the Internet Shared Bandwidth instance. Valid values: `PayAsYouGo`, `Subscription`.
        :param pulumi.Input[_builtins.int] ratio: The percentage of the minimum bandwidth commitment. The value is only `20`.
               
               This parameter is required when the value of `InternetChargeType` is `PayBy95`.
               
               > **NOTE:** This parameter is available only on the Alibaba Cloud China site.
        :param pulumi.Input[_builtins.str] region_id: The pagination token that is used in the next request to retrieve a new page of results.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which you want to move the resource.
               
               > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_protection_types: The edition of Anti-DDoS. If you do not set this parameter, Anti-DDoS Origin Basic is used. If you set the value to AntiDDoS_Enhanced, Anti-DDoS Pro(Premium) is used. It is valid when `internet_charge_type` is `PayBy95`.
        :param pulumi.Input[_builtins.str] status: The status of the Internet Shared Bandwidth instance. Default value: `Available`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] zone: The zone of the Internet Shared Bandwidth instance. This parameter is required if you create an Internet Shared Bandwidth instance for a cloud box.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if bandwidth_package_name is not None:
            pulumi.set(__self__, "bandwidth_package_name", bandwidth_package_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.120.0. New field 'bandwidth_package_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.120.0. New field 'bandwidth_package_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if ratio is not None:
            pulumi.set(__self__, "ratio", ratio)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_protection_types is not None:
            pulumi.set(__self__, "security_protection_types", security_protection_types)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum bandwidth of the Internet Shared Bandwidth instance. Unit: Mbit/s.
        Valid values: `1` to `1000`. Default value: `1`.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageName")
    def bandwidth_package_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the EIP bandwidth plan. The description must be 2 to 256 characters in length. It must start with a letter but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "bandwidth_package_name")

    @bandwidth_package_name.setter
    def bandwidth_package_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_package_name", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable deletion protection. Valid values:
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Internet Shared Bandwidth instance.
        The description must be 0 to 256 characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to forcefully delete the Internet Shared Bandwidth instance. Valid values:
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Billing method of Internet Shared Bandwidth. Valid values:
        `PayByTraffic`: billed by primary traffic.

        - `PayByBandwidth` (default): Billing by bandwidth.
        - `PayBy95`: Billed as Enhanced 95.
        - `PayByDominantTraffic`: billed by primary traffic.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The line type. Valid values:

        - `BGP` (default) All regions support BGP (Multi-ISP).
        - `BGP_PRO` BGP (Multi-ISP) Pro lines are available in the China (Hong Kong), Singapore, Japan (Tokyo), Philippines (Manila), Malaysia (Kuala Lumpur), Indonesia (Jakarta), and Thailand (Bangkok) regions.

        If you are allowed to use single-ISP bandwidth, you can also use one of the following values:

        - `ChinaTelecom`
        - `ChinaUnicom`
        - `ChinaMobile`
        - `ChinaTelecom_L2`
        - `ChinaUnicom_L2`
        - `ChinaMobile_L2`

        If your services are deployed in China East 1 Finance, this parameter is required and you must set the value to `BGP_FinanceCloud`.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isp", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.120.0. New field 'bandwidth_package_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.120.0. New field 'bandwidth_package_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing type of the Internet Shared Bandwidth instance. Valid values: `PayAsYouGo`, `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def ratio(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The percentage of the minimum bandwidth commitment. The value is only `20`.

        This parameter is required when the value of `InternetChargeType` is `PayBy95`.

        > **NOTE:** This parameter is available only on the Alibaba Cloud China site.
        """
        return pulumi.get(self, "ratio")

    @ratio.setter
    def ratio(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ratio", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pagination token that is used in the next request to retrieve a new page of results.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which you want to move the resource.

        > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityProtectionTypes")
    def security_protection_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The edition of Anti-DDoS. If you do not set this parameter, Anti-DDoS Origin Basic is used. If you set the value to AntiDDoS_Enhanced, Anti-DDoS Pro(Premium) is used. It is valid when `internet_charge_type` is `PayBy95`.
        """
        return pulumi.get(self, "security_protection_types")

    @security_protection_types.setter
    def security_protection_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_protection_types", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Internet Shared Bandwidth instance. Default value: `Available`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone of the Internet Shared Bandwidth instance. This parameter is required if you create an Internet Shared Bandwidth instance for a cloud box.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("alicloud:vpc/commonBandwithPackage:CommonBandwithPackage")
class CommonBandwithPackage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_package_name: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        EIP Bandwidth Plan (CBWP) Common Bandwidth Package can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/commonBandwithPackage:CommonBandwithPackage example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bandwidth: The maximum bandwidth of the Internet Shared Bandwidth instance. Unit: Mbit/s.
               Valid values: `1` to `1000`. Default value: `1`.
        :param pulumi.Input[_builtins.str] bandwidth_package_name: The description of the EIP bandwidth plan. The description must be 2 to 256 characters in length. It must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.bool] deletion_protection: Specifies whether to enable deletion protection. Valid values:
        :param pulumi.Input[_builtins.str] description: The description of the Internet Shared Bandwidth instance.
               The description must be 0 to 256 characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] force: Specifies whether to forcefully delete the Internet Shared Bandwidth instance. Valid values:
        :param pulumi.Input[_builtins.str] internet_charge_type: Billing method of Internet Shared Bandwidth. Valid values:
               `PayByTraffic`: billed by primary traffic.
               
               - `PayByBandwidth` (default): Billing by bandwidth.
               - `PayBy95`: Billed as Enhanced 95.
               - `PayByDominantTraffic`: billed by primary traffic.
        :param pulumi.Input[_builtins.str] isp: The line type. Valid values:
               
               - `BGP` (default) All regions support BGP (Multi-ISP).
               - `BGP_PRO` BGP (Multi-ISP) Pro lines are available in the China (Hong Kong), Singapore, Japan (Tokyo), Philippines (Manila), Malaysia (Kuala Lumpur), Indonesia (Jakarta), and Thailand (Bangkok) regions.
               
               If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
               
               - `ChinaTelecom`
               - `ChinaUnicom`
               - `ChinaMobile`
               - `ChinaTelecom_L2`
               - `ChinaUnicom_L2`
               - `ChinaMobile_L2`
               
               If your services are deployed in China East 1 Finance, this parameter is required and you must set the value to `BGP_FinanceCloud`.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.120.0. New field 'bandwidth_package_name' instead.
        :param pulumi.Input[_builtins.int] ratio: The percentage of the minimum bandwidth commitment. The value is only `20`.
               
               This parameter is required when the value of `InternetChargeType` is `PayBy95`.
               
               > **NOTE:** This parameter is available only on the Alibaba Cloud China site.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which you want to move the resource.
               
               > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_protection_types: The edition of Anti-DDoS. If you do not set this parameter, Anti-DDoS Origin Basic is used. If you set the value to AntiDDoS_Enhanced, Anti-DDoS Pro(Premium) is used. It is valid when `internet_charge_type` is `PayBy95`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] zone: The zone of the Internet Shared Bandwidth instance. This parameter is required if you create an Internet Shared Bandwidth instance for a cloud box.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CommonBandwithPackageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        EIP Bandwidth Plan (CBWP) Common Bandwidth Package can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/commonBandwithPackage:CommonBandwithPackage example <id>
        ```

        :param str resource_name: The name of the resource.
        :param CommonBandwithPackageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CommonBandwithPackageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_package_name: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CommonBandwithPackageArgs.__new__(CommonBandwithPackageArgs)

            if bandwidth is None and not opts.urn:
                raise TypeError("Missing required property 'bandwidth'")
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["bandwidth_package_name"] = bandwidth_package_name
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["force"] = force
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["isp"] = isp
            __props__.__dict__["name"] = name
            __props__.__dict__["ratio"] = ratio
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["security_protection_types"] = security_protection_types
            __props__.__dict__["tags"] = tags
            __props__.__dict__["zone"] = zone
            __props__.__dict__["create_time"] = None
            __props__.__dict__["payment_type"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(CommonBandwithPackage, __self__).__init__(
            'alicloud:vpc/commonBandwithPackage:CommonBandwithPackage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth_package_name: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            force: Optional[pulumi.Input[_builtins.str]] = None,
            internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            isp: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            ratio: Optional[pulumi.Input[_builtins.int]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'CommonBandwithPackage':
        """
        Get an existing CommonBandwithPackage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bandwidth: The maximum bandwidth of the Internet Shared Bandwidth instance. Unit: Mbit/s.
               Valid values: `1` to `1000`. Default value: `1`.
        :param pulumi.Input[_builtins.str] bandwidth_package_name: The description of the EIP bandwidth plan. The description must be 2 to 256 characters in length. It must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] create_time: The creation time.
        :param pulumi.Input[_builtins.bool] deletion_protection: Specifies whether to enable deletion protection. Valid values:
        :param pulumi.Input[_builtins.str] description: The description of the Internet Shared Bandwidth instance.
               The description must be 0 to 256 characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] force: Specifies whether to forcefully delete the Internet Shared Bandwidth instance. Valid values:
        :param pulumi.Input[_builtins.str] internet_charge_type: Billing method of Internet Shared Bandwidth. Valid values:
               `PayByTraffic`: billed by primary traffic.
               
               - `PayByBandwidth` (default): Billing by bandwidth.
               - `PayBy95`: Billed as Enhanced 95.
               - `PayByDominantTraffic`: billed by primary traffic.
        :param pulumi.Input[_builtins.str] isp: The line type. Valid values:
               
               - `BGP` (default) All regions support BGP (Multi-ISP).
               - `BGP_PRO` BGP (Multi-ISP) Pro lines are available in the China (Hong Kong), Singapore, Japan (Tokyo), Philippines (Manila), Malaysia (Kuala Lumpur), Indonesia (Jakarta), and Thailand (Bangkok) regions.
               
               If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
               
               - `ChinaTelecom`
               - `ChinaUnicom`
               - `ChinaMobile`
               - `ChinaTelecom_L2`
               - `ChinaUnicom_L2`
               - `ChinaMobile_L2`
               
               If your services are deployed in China East 1 Finance, this parameter is required and you must set the value to `BGP_FinanceCloud`.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.120.0. New field 'bandwidth_package_name' instead.
        :param pulumi.Input[_builtins.str] payment_type: The billing type of the Internet Shared Bandwidth instance. Valid values: `PayAsYouGo`, `Subscription`.
        :param pulumi.Input[_builtins.int] ratio: The percentage of the minimum bandwidth commitment. The value is only `20`.
               
               This parameter is required when the value of `InternetChargeType` is `PayBy95`.
               
               > **NOTE:** This parameter is available only on the Alibaba Cloud China site.
        :param pulumi.Input[_builtins.str] region_id: The pagination token that is used in the next request to retrieve a new page of results.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which you want to move the resource.
               
               > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_protection_types: The edition of Anti-DDoS. If you do not set this parameter, Anti-DDoS Origin Basic is used. If you set the value to AntiDDoS_Enhanced, Anti-DDoS Pro(Premium) is used. It is valid when `internet_charge_type` is `PayBy95`.
        :param pulumi.Input[_builtins.str] status: The status of the Internet Shared Bandwidth instance. Default value: `Available`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] zone: The zone of the Internet Shared Bandwidth instance. This parameter is required if you create an Internet Shared Bandwidth instance for a cloud box.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CommonBandwithPackageState.__new__(_CommonBandwithPackageState)

        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["bandwidth_package_name"] = bandwidth_package_name
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["force"] = force
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["isp"] = isp
        __props__.__dict__["name"] = name
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["ratio"] = ratio
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_protection_types"] = security_protection_types
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["zone"] = zone
        return CommonBandwithPackage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[_builtins.str]:
        """
        The maximum bandwidth of the Internet Shared Bandwidth instance. Unit: Mbit/s.
        Valid values: `1` to `1000`. Default value: `1`.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageName")
    def bandwidth_package_name(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the EIP bandwidth plan. The description must be 2 to 256 characters in length. It must start with a letter but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "bandwidth_package_name")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable deletion protection. Valid values:
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Internet Shared Bandwidth instance.
        The description must be 0 to 256 characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to forcefully delete the Internet Shared Bandwidth instance. Valid values:
        """
        return pulumi.get(self, "force")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Billing method of Internet Shared Bandwidth. Valid values:
        `PayByTraffic`: billed by primary traffic.

        - `PayByBandwidth` (default): Billing by bandwidth.
        - `PayBy95`: Billed as Enhanced 95.
        - `PayByDominantTraffic`: billed by primary traffic.
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter
    def isp(self) -> pulumi.Output[_builtins.str]:
        """
        The line type. Valid values:

        - `BGP` (default) All regions support BGP (Multi-ISP).
        - `BGP_PRO` BGP (Multi-ISP) Pro lines are available in the China (Hong Kong), Singapore, Japan (Tokyo), Philippines (Manila), Malaysia (Kuala Lumpur), Indonesia (Jakarta), and Thailand (Bangkok) regions.

        If you are allowed to use single-ISP bandwidth, you can also use one of the following values:

        - `ChinaTelecom`
        - `ChinaUnicom`
        - `ChinaMobile`
        - `ChinaTelecom_L2`
        - `ChinaUnicom_L2`
        - `ChinaMobile_L2`

        If your services are deployed in China East 1 Finance, this parameter is required and you must set the value to `BGP_FinanceCloud`.
        """
        return pulumi.get(self, "isp")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.120.0. New field 'bandwidth_package_name' instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'name' has been deprecated from provider version 1.120.0. New field 'bandwidth_package_name' instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The billing type of the Internet Shared Bandwidth instance. Valid values: `PayAsYouGo`, `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def ratio(self) -> pulumi.Output[_builtins.int]:
        """
        The percentage of the minimum bandwidth commitment. The value is only `20`.

        This parameter is required when the value of `InternetChargeType` is `PayBy95`.

        > **NOTE:** This parameter is available only on the Alibaba Cloud China site.
        """
        return pulumi.get(self, "ratio")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The pagination token that is used in the next request to retrieve a new page of results.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group to which you want to move the resource.

        > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="securityProtectionTypes")
    def security_protection_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The edition of Anti-DDoS. If you do not set this parameter, Anti-DDoS Origin Basic is used. If you set the value to AntiDDoS_Enhanced, Anti-DDoS Pro(Premium) is used. It is valid when `internet_charge_type` is `PayBy95`.
        """
        return pulumi.get(self, "security_protection_types")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Internet Shared Bandwidth instance. Default value: `Available`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The zone of the Internet Shared Bandwidth instance. This parameter is required if you create an Internet Shared Bandwidth instance for a cloud box.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "zone")

