# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GatewayEndpointRouteTableAttachmentArgs', 'GatewayEndpointRouteTableAttachment']

@pulumi.input_type
class GatewayEndpointRouteTableAttachmentArgs:
    def __init__(__self__, *,
                 gateway_endpoint_id: pulumi.Input[_builtins.str],
                 route_table_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a GatewayEndpointRouteTableAttachment resource.
        :param pulumi.Input[_builtins.str] gateway_endpoint_id: The ID of the gateway endpoint instance to which you want to associate the route table.
        :param pulumi.Input[_builtins.str] route_table_id: Routing table ID.
        """
        pulumi.set(__self__, "gateway_endpoint_id", gateway_endpoint_id)
        pulumi.set(__self__, "route_table_id", route_table_id)

    @_builtins.property
    @pulumi.getter(name="gatewayEndpointId")
    def gateway_endpoint_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the gateway endpoint instance to which you want to associate the route table.
        """
        return pulumi.get(self, "gateway_endpoint_id")

    @gateway_endpoint_id.setter
    def gateway_endpoint_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gateway_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Input[_builtins.str]:
        """
        Routing table ID.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "route_table_id", value)


@pulumi.input_type
class _GatewayEndpointRouteTableAttachmentState:
    def __init__(__self__, *,
                 gateway_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GatewayEndpointRouteTableAttachment resources.
        :param pulumi.Input[_builtins.str] gateway_endpoint_id: The ID of the gateway endpoint instance to which you want to associate the route table.
        :param pulumi.Input[_builtins.str] route_table_id: Routing table ID.
        :param pulumi.Input[_builtins.str] status: Status of the gateway endpoint.
        """
        if gateway_endpoint_id is not None:
            pulumi.set(__self__, "gateway_endpoint_id", gateway_endpoint_id)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="gatewayEndpointId")
    def gateway_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the gateway endpoint instance to which you want to associate the route table.
        """
        return pulumi.get(self, "gateway_endpoint_id")

    @gateway_endpoint_id.setter
    def gateway_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Routing table ID.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the gateway endpoint.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:vpc/gatewayEndpointRouteTableAttachment:GatewayEndpointRouteTableAttachment")
class GatewayEndpointRouteTableAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateway_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a VPC Gateway Endpoint Route Table Attachment resource. VPC gateway node association route.

        For information about VPC Gateway Endpoint Route Table Attachment and how to use it, see [What is Gateway Endpoint Route Table Attachment](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/311148).

        > **NOTE:** Available since v1.208.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        defaulte_vpc = alicloud.vpc.Network("defaulteVpc", description="test")
        default_ge = alicloud.vpc.GatewayEndpoint("defaultGE",
            service_name="com.aliyun.cn-hangzhou.oss",
            policy_document=\"\"\"        {
                  \\"Version\\": \\"1\\",
                  \\"Statement\\": [{
                    \\"Effect\\": \\"Allow\\",
                    \\"Resource\\": [\\"*\\"],
                    \\"Action\\": [\\"*\\"],
                    \\"Principal\\": [\\"*\\"]
                  }]
                }
        \"\"\",
            vpc_id=defaulte_vpc.id,
            gateway_endpoint_descrption="test-gateway-endpoint",
            gateway_endpoint_name=f"{name}1")
        default_rt = alicloud.vpc.RouteTable("defaultRT",
            vpc_id=defaulte_vpc.id,
            route_table_name=f"{name}2")
        default = alicloud.vpc.GatewayEndpointRouteTableAttachment("default",
            gateway_endpoint_id=default_ge.id,
            route_table_id=default_rt.id)
        ```

        ## Import

        VPC Gateway Endpoint Route Table Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/gatewayEndpointRouteTableAttachment:GatewayEndpointRouteTableAttachment example <gateway_endpoint_id>:<route_table_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] gateway_endpoint_id: The ID of the gateway endpoint instance to which you want to associate the route table.
        :param pulumi.Input[_builtins.str] route_table_id: Routing table ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayEndpointRouteTableAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VPC Gateway Endpoint Route Table Attachment resource. VPC gateway node association route.

        For information about VPC Gateway Endpoint Route Table Attachment and how to use it, see [What is Gateway Endpoint Route Table Attachment](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/311148).

        > **NOTE:** Available since v1.208.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        defaulte_vpc = alicloud.vpc.Network("defaulteVpc", description="test")
        default_ge = alicloud.vpc.GatewayEndpoint("defaultGE",
            service_name="com.aliyun.cn-hangzhou.oss",
            policy_document=\"\"\"        {
                  \\"Version\\": \\"1\\",
                  \\"Statement\\": [{
                    \\"Effect\\": \\"Allow\\",
                    \\"Resource\\": [\\"*\\"],
                    \\"Action\\": [\\"*\\"],
                    \\"Principal\\": [\\"*\\"]
                  }]
                }
        \"\"\",
            vpc_id=defaulte_vpc.id,
            gateway_endpoint_descrption="test-gateway-endpoint",
            gateway_endpoint_name=f"{name}1")
        default_rt = alicloud.vpc.RouteTable("defaultRT",
            vpc_id=defaulte_vpc.id,
            route_table_name=f"{name}2")
        default = alicloud.vpc.GatewayEndpointRouteTableAttachment("default",
            gateway_endpoint_id=default_ge.id,
            route_table_id=default_rt.id)
        ```

        ## Import

        VPC Gateway Endpoint Route Table Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/gatewayEndpointRouteTableAttachment:GatewayEndpointRouteTableAttachment example <gateway_endpoint_id>:<route_table_id>
        ```

        :param str resource_name: The name of the resource.
        :param GatewayEndpointRouteTableAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayEndpointRouteTableAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateway_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayEndpointRouteTableAttachmentArgs.__new__(GatewayEndpointRouteTableAttachmentArgs)

            if gateway_endpoint_id is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_endpoint_id'")
            __props__.__dict__["gateway_endpoint_id"] = gateway_endpoint_id
            if route_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_table_id'")
            __props__.__dict__["route_table_id"] = route_table_id
            __props__.__dict__["status"] = None
        super(GatewayEndpointRouteTableAttachment, __self__).__init__(
            'alicloud:vpc/gatewayEndpointRouteTableAttachment:GatewayEndpointRouteTableAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            gateway_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'GatewayEndpointRouteTableAttachment':
        """
        Get an existing GatewayEndpointRouteTableAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] gateway_endpoint_id: The ID of the gateway endpoint instance to which you want to associate the route table.
        :param pulumi.Input[_builtins.str] route_table_id: Routing table ID.
        :param pulumi.Input[_builtins.str] status: Status of the gateway endpoint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayEndpointRouteTableAttachmentState.__new__(_GatewayEndpointRouteTableAttachmentState)

        __props__.__dict__["gateway_endpoint_id"] = gateway_endpoint_id
        __props__.__dict__["route_table_id"] = route_table_id
        __props__.__dict__["status"] = status
        return GatewayEndpointRouteTableAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="gatewayEndpointId")
    def gateway_endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the gateway endpoint instance to which you want to associate the route table.
        """
        return pulumi.get(self, "gateway_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        Routing table ID.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the gateway endpoint.
        """
        return pulumi.get(self, "status")

