# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HAVipAttachmentArgs', 'HAVipAttachment']

@pulumi.input_type
class HAVipAttachmentArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 ha_vip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 havip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a HAVipAttachment resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the ECS instance bound to the HaVip instance.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to force delete the snapshot.
        :param pulumi.Input[_builtins.str] ha_vip_id: The ID of the HaVip instance.
        :param pulumi.Input[_builtins.str] havip_id: . Field 'havip_id' has been deprecated from provider version 1.259.0. New field 'ha_vip_id' instead.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance to be associated with the HAVIP. Valid values: * `EcsInstance`: an ECS instance * `NetworkInterface`: an ENI. If you want to associate the HAVIP with an ENI, this parameter is required.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if ha_vip_id is not None:
            pulumi.set(__self__, "ha_vip_id", ha_vip_id)
        if havip_id is not None:
            warnings.warn("""Field 'havip_id' has been deprecated since provider version 1.211.0. New field 'ha_vip_id' instead.""", DeprecationWarning)
            pulumi.log.warn("""havip_id is deprecated: Field 'havip_id' has been deprecated since provider version 1.211.0. New field 'ha_vip_id' instead.""")
        if havip_id is not None:
            pulumi.set(__self__, "havip_id", havip_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the ECS instance bound to the HaVip instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to force delete the snapshot.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="haVipId")
    def ha_vip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the HaVip instance.
        """
        return pulumi.get(self, "ha_vip_id")

    @ha_vip_id.setter
    def ha_vip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ha_vip_id", value)

    @_builtins.property
    @pulumi.getter(name="havipId")
    @_utilities.deprecated("""Field 'havip_id' has been deprecated since provider version 1.211.0. New field 'ha_vip_id' instead.""")
    def havip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'havip_id' has been deprecated from provider version 1.259.0. New field 'ha_vip_id' instead.
        """
        return pulumi.get(self, "havip_id")

    @havip_id.setter
    def havip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "havip_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the instance to be associated with the HAVIP. Valid values: * `EcsInstance`: an ECS instance * `NetworkInterface`: an ENI. If you want to associate the HAVIP with an ENI, this parameter is required.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)


@pulumi.input_type
class _HAVipAttachmentState:
    def __init__(__self__, *,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 ha_vip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 havip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HAVipAttachment resources.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to force delete the snapshot.
        :param pulumi.Input[_builtins.str] ha_vip_id: The ID of the HaVip instance.
        :param pulumi.Input[_builtins.str] havip_id: . Field 'havip_id' has been deprecated from provider version 1.259.0. New field 'ha_vip_id' instead.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the ECS instance bound to the HaVip instance.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance to be associated with the HAVIP. Valid values: * `EcsInstance`: an ECS instance * `NetworkInterface`: an ENI. If you want to associate the HAVIP with an ENI, this parameter is required.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        if force is not None:
            pulumi.set(__self__, "force", force)
        if ha_vip_id is not None:
            pulumi.set(__self__, "ha_vip_id", ha_vip_id)
        if havip_id is not None:
            warnings.warn("""Field 'havip_id' has been deprecated since provider version 1.211.0. New field 'ha_vip_id' instead.""", DeprecationWarning)
            pulumi.log.warn("""havip_id is deprecated: Field 'havip_id' has been deprecated since provider version 1.211.0. New field 'ha_vip_id' instead.""")
        if havip_id is not None:
            pulumi.set(__self__, "havip_id", havip_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to force delete the snapshot.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="haVipId")
    def ha_vip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the HaVip instance.
        """
        return pulumi.get(self, "ha_vip_id")

    @ha_vip_id.setter
    def ha_vip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ha_vip_id", value)

    @_builtins.property
    @pulumi.getter(name="havipId")
    @_utilities.deprecated("""Field 'havip_id' has been deprecated since provider version 1.211.0. New field 'ha_vip_id' instead.""")
    def havip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'havip_id' has been deprecated from provider version 1.259.0. New field 'ha_vip_id' instead.
        """
        return pulumi.get(self, "havip_id")

    @havip_id.setter
    def havip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "havip_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the ECS instance bound to the HaVip instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the instance to be associated with the HAVIP. Valid values: * `EcsInstance`: an ECS instance * `NetworkInterface`: an ENI. If you want to associate the HAVIP with an ENI, this parameter is required.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:vpc/hAVipAttachment:HAVipAttachment")
class HAVipAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 ha_vip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 havip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a VPC Ha Vip Attachment resource.

        Attaching ECS instance to Havip.

        For information about VPC Ha Vip Attachment and how to use it, see [What is Ha Vip Attachment](https://next.api.alibabacloud.com/document/Vpc/2016-04-28/AssociateHaVip).

        > **NOTE:** Available since v1.18.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        example = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        example_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            owners="system")
        example_network = alicloud.vpc.Network("example",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        example_switch = alicloud.vpc.Switch("example",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=example_network.id,
            zone_id=default.zones[0].id)
        example_ha_vip = alicloud.vpc.HAVip("example",
            vswitch_id=example_switch.id,
            description=name)
        example_security_group = alicloud.ecs.SecurityGroup("example",
            name=name,
            description=name,
            vpc_id=example_network.id)
        example_instance = alicloud.ecs.Instance("example",
            availability_zone=default.zones[0].id,
            vswitch_id=example_switch.id,
            image_id=example_get_images.images[0].id,
            instance_type=example.instance_types[0].id,
            system_disk_category="cloud_efficiency",
            internet_charge_type="PayByTraffic",
            internet_max_bandwidth_out=5,
            security_groups=[example_security_group.id],
            instance_name=name,
            user_data="echo 'net.ipv4.ip_forward=1'>> /etc/sysctl.conf")
        example_ha_vip_attachment = alicloud.vpc.HAVipAttachment("example",
            ha_vip_id=example_ha_vip.id,
            instance_id=example_instance.id)
        ```

        ## Import

        VPC Ha Vip Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/hAVipAttachment:HAVipAttachment example <ha_vip_id>:<instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to force delete the snapshot.
        :param pulumi.Input[_builtins.str] ha_vip_id: The ID of the HaVip instance.
        :param pulumi.Input[_builtins.str] havip_id: . Field 'havip_id' has been deprecated from provider version 1.259.0. New field 'ha_vip_id' instead.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the ECS instance bound to the HaVip instance.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance to be associated with the HAVIP. Valid values: * `EcsInstance`: an ECS instance * `NetworkInterface`: an ENI. If you want to associate the HAVIP with an ENI, this parameter is required.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HAVipAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VPC Ha Vip Attachment resource.

        Attaching ECS instance to Havip.

        For information about VPC Ha Vip Attachment and how to use it, see [What is Ha Vip Attachment](https://next.api.alibabacloud.com/document/Vpc/2016-04-28/AssociateHaVip).

        > **NOTE:** Available since v1.18.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        example = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        example_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            owners="system")
        example_network = alicloud.vpc.Network("example",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        example_switch = alicloud.vpc.Switch("example",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=example_network.id,
            zone_id=default.zones[0].id)
        example_ha_vip = alicloud.vpc.HAVip("example",
            vswitch_id=example_switch.id,
            description=name)
        example_security_group = alicloud.ecs.SecurityGroup("example",
            name=name,
            description=name,
            vpc_id=example_network.id)
        example_instance = alicloud.ecs.Instance("example",
            availability_zone=default.zones[0].id,
            vswitch_id=example_switch.id,
            image_id=example_get_images.images[0].id,
            instance_type=example.instance_types[0].id,
            system_disk_category="cloud_efficiency",
            internet_charge_type="PayByTraffic",
            internet_max_bandwidth_out=5,
            security_groups=[example_security_group.id],
            instance_name=name,
            user_data="echo 'net.ipv4.ip_forward=1'>> /etc/sysctl.conf")
        example_ha_vip_attachment = alicloud.vpc.HAVipAttachment("example",
            ha_vip_id=example_ha_vip.id,
            instance_id=example_instance.id)
        ```

        ## Import

        VPC Ha Vip Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/hAVipAttachment:HAVipAttachment example <ha_vip_id>:<instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param HAVipAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HAVipAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 ha_vip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 havip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HAVipAttachmentArgs.__new__(HAVipAttachmentArgs)

            __props__.__dict__["force"] = force
            __props__.__dict__["ha_vip_id"] = ha_vip_id
            __props__.__dict__["havip_id"] = havip_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["status"] = None
        super(HAVipAttachment, __self__).__init__(
            'alicloud:vpc/hAVipAttachment:HAVipAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            force: Optional[pulumi.Input[_builtins.bool]] = None,
            ha_vip_id: Optional[pulumi.Input[_builtins.str]] = None,
            havip_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'HAVipAttachment':
        """
        Get an existing HAVipAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to force delete the snapshot.
        :param pulumi.Input[_builtins.str] ha_vip_id: The ID of the HaVip instance.
        :param pulumi.Input[_builtins.str] havip_id: . Field 'havip_id' has been deprecated from provider version 1.259.0. New field 'ha_vip_id' instead.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the ECS instance bound to the HaVip instance.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance to be associated with the HAVIP. Valid values: * `EcsInstance`: an ECS instance * `NetworkInterface`: an ENI. If you want to associate the HAVIP with an ENI, this parameter is required.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HAVipAttachmentState.__new__(_HAVipAttachmentState)

        __props__.__dict__["force"] = force
        __props__.__dict__["ha_vip_id"] = ha_vip_id
        __props__.__dict__["havip_id"] = havip_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["status"] = status
        return HAVipAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to force delete the snapshot.
        """
        return pulumi.get(self, "force")

    @_builtins.property
    @pulumi.getter(name="haVipId")
    def ha_vip_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the HaVip instance.
        """
        return pulumi.get(self, "ha_vip_id")

    @_builtins.property
    @pulumi.getter(name="havipId")
    @_utilities.deprecated("""Field 'havip_id' has been deprecated since provider version 1.211.0. New field 'ha_vip_id' instead.""")
    def havip_id(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'havip_id' has been deprecated from provider version 1.259.0. New field 'ha_vip_id' instead.
        """
        return pulumi.get(self, "havip_id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the ECS instance bound to the HaVip instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the instance to be associated with the HAVIP. Valid values: * `EcsInstance`: an ECS instance * `NetworkInterface`: an ENI. If you want to associate the HAVIP with an ENI, this parameter is required.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

