# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IpamIpamArgs', 'IpamIpam']

@pulumi.input_type
class IpamIpamArgs:
    def __init__(__self__, *,
                 operating_region_lists: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 ipam_description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a IpamIpam resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] operating_region_lists: List of IPAM effective regions.
        :param pulumi.Input[_builtins.str] ipam_description: The description of IPAM.
               It must be 2 to 256 characters in length and must start with an uppercase letter or a Chinese character, but cannot start with 'http: // 'or 'https. If the description is not filled in, it is blank. The default value is blank.
        :param pulumi.Input[_builtins.str] ipam_name: The name of the resource.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        pulumi.set(__self__, "operating_region_lists", operating_region_lists)
        if ipam_description is not None:
            pulumi.set(__self__, "ipam_description", ipam_description)
        if ipam_name is not None:
            pulumi.set(__self__, "ipam_name", ipam_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="operatingRegionLists")
    def operating_region_lists(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of IPAM effective regions.
        """
        return pulumi.get(self, "operating_region_lists")

    @operating_region_lists.setter
    def operating_region_lists(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "operating_region_lists", value)

    @_builtins.property
    @pulumi.getter(name="ipamDescription")
    def ipam_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of IPAM.
        It must be 2 to 256 characters in length and must start with an uppercase letter or a Chinese character, but cannot start with 'http: // 'or 'https. If the description is not filled in, it is blank. The default value is blank.
        """
        return pulumi.get(self, "ipam_description")

    @ipam_description.setter
    def ipam_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_description", value)

    @_builtins.property
    @pulumi.getter(name="ipamName")
    def ipam_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "ipam_name")

    @ipam_name.setter
    def ipam_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _IpamIpamState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_name: Optional[pulumi.Input[_builtins.str]] = None,
                 operating_region_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_default_scope_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering IpamIpam resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] ipam_description: The description of IPAM.
               It must be 2 to 256 characters in length and must start with an uppercase letter or a Chinese character, but cannot start with 'http: // 'or 'https. If the description is not filled in, it is blank. The default value is blank.
        :param pulumi.Input[_builtins.str] ipam_name: The name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] operating_region_lists: List of IPAM effective regions.
        :param pulumi.Input[_builtins.str] private_default_scope_id: After an IPAM is created, the scope of the private network IPAM created by the system by default.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if ipam_description is not None:
            pulumi.set(__self__, "ipam_description", ipam_description)
        if ipam_name is not None:
            pulumi.set(__self__, "ipam_name", ipam_name)
        if operating_region_lists is not None:
            pulumi.set(__self__, "operating_region_lists", operating_region_lists)
        if private_default_scope_id is not None:
            pulumi.set(__self__, "private_default_scope_id", private_default_scope_id)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="ipamDescription")
    def ipam_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of IPAM.
        It must be 2 to 256 characters in length and must start with an uppercase letter or a Chinese character, but cannot start with 'http: // 'or 'https. If the description is not filled in, it is blank. The default value is blank.
        """
        return pulumi.get(self, "ipam_description")

    @ipam_description.setter
    def ipam_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_description", value)

    @_builtins.property
    @pulumi.getter(name="ipamName")
    def ipam_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "ipam_name")

    @ipam_name.setter
    def ipam_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_name", value)

    @_builtins.property
    @pulumi.getter(name="operatingRegionLists")
    def operating_region_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IPAM effective regions.
        """
        return pulumi.get(self, "operating_region_lists")

    @operating_region_lists.setter
    def operating_region_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "operating_region_lists", value)

    @_builtins.property
    @pulumi.getter(name="privateDefaultScopeId")
    def private_default_scope_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        After an IPAM is created, the scope of the private network IPAM created by the system by default.
        """
        return pulumi.get(self, "private_default_scope_id")

    @private_default_scope_id.setter
    def private_default_scope_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_default_scope_id", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the resource.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:vpc/ipamIpam:IpamIpam")
class IpamIpam(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ipam_description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_name: Optional[pulumi.Input[_builtins.str]] = None,
                 operating_region_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Vpc Ipam Ipam resource.

        IP Address Management.

        For information about Vpc Ipam Ipam and how to use it, see [What is Ipam](https://next.api.alibabacloud.com/document/VpcIpam/2023-02-28/CreateIpam).

        > **NOTE:** Available since v1.234.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_ipam_ipam = alicloud.vpc.IpamIpam("default",
            ipam_description="This is my first Ipam.",
            ipam_name=name,
            operating_region_lists=["cn-hangzhou"])
        ```

        ## Import

        Vpc Ipam Ipam can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/ipamIpam:IpamIpam example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ipam_description: The description of IPAM.
               It must be 2 to 256 characters in length and must start with an uppercase letter or a Chinese character, but cannot start with 'http: // 'or 'https. If the description is not filled in, it is blank. The default value is blank.
        :param pulumi.Input[_builtins.str] ipam_name: The name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] operating_region_lists: List of IPAM effective regions.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpamIpamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vpc Ipam Ipam resource.

        IP Address Management.

        For information about Vpc Ipam Ipam and how to use it, see [What is Ipam](https://next.api.alibabacloud.com/document/VpcIpam/2023-02-28/CreateIpam).

        > **NOTE:** Available since v1.234.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_ipam_ipam = alicloud.vpc.IpamIpam("default",
            ipam_description="This is my first Ipam.",
            ipam_name=name,
            operating_region_lists=["cn-hangzhou"])
        ```

        ## Import

        Vpc Ipam Ipam can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/ipamIpam:IpamIpam example <id>
        ```

        :param str resource_name: The name of the resource.
        :param IpamIpamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpamIpamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ipam_description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_name: Optional[pulumi.Input[_builtins.str]] = None,
                 operating_region_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpamIpamArgs.__new__(IpamIpamArgs)

            __props__.__dict__["ipam_description"] = ipam_description
            __props__.__dict__["ipam_name"] = ipam_name
            if operating_region_lists is None and not opts.urn:
                raise TypeError("Missing required property 'operating_region_lists'")
            __props__.__dict__["operating_region_lists"] = operating_region_lists
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
            __props__.__dict__["private_default_scope_id"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(IpamIpam, __self__).__init__(
            'alicloud:vpc/ipamIpam:IpamIpam',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            ipam_description: Optional[pulumi.Input[_builtins.str]] = None,
            ipam_name: Optional[pulumi.Input[_builtins.str]] = None,
            operating_region_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            private_default_scope_id: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'IpamIpam':
        """
        Get an existing IpamIpam resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] ipam_description: The description of IPAM.
               It must be 2 to 256 characters in length and must start with an uppercase letter or a Chinese character, but cannot start with 'http: // 'or 'https. If the description is not filled in, it is blank. The default value is blank.
        :param pulumi.Input[_builtins.str] ipam_name: The name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] operating_region_lists: List of IPAM effective regions.
        :param pulumi.Input[_builtins.str] private_default_scope_id: After an IPAM is created, the scope of the private network IPAM created by the system by default.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpamIpamState.__new__(_IpamIpamState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["ipam_description"] = ipam_description
        __props__.__dict__["ipam_name"] = ipam_name
        __props__.__dict__["operating_region_lists"] = operating_region_lists
        __props__.__dict__["private_default_scope_id"] = private_default_scope_id
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return IpamIpam(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="ipamDescription")
    def ipam_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of IPAM.
        It must be 2 to 256 characters in length and must start with an uppercase letter or a Chinese character, but cannot start with 'http: // 'or 'https. If the description is not filled in, it is blank. The default value is blank.
        """
        return pulumi.get(self, "ipam_description")

    @_builtins.property
    @pulumi.getter(name="ipamName")
    def ipam_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "ipam_name")

    @_builtins.property
    @pulumi.getter(name="operatingRegionLists")
    def operating_region_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of IPAM effective regions.
        """
        return pulumi.get(self, "operating_region_lists")

    @_builtins.property
    @pulumi.getter(name="privateDefaultScopeId")
    def private_default_scope_id(self) -> pulumi.Output[_builtins.str]:
        """
        After an IPAM is created, the scope of the private network IPAM created by the system by default.
        """
        return pulumi.get(self, "private_default_scope_id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the resource.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

