# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkArgs', 'Network']

@pulumi.input_type
class NetworkArgs:
    def __init__(__self__, *,
                 cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 classic_link_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_hostname_status: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv4_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv4_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_isp: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secondary_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 system_route_table_description: Optional[pulumi.Input[_builtins.str]] = None,
                 system_route_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_route_table_route_propagation_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Network resource.
        :param pulumi.Input[_builtins.str] cidr_block: The CIDR block of the VPC.
               
               - You can specify one of the following CIDR blocks or their subsets as the primary IPv4 CIDR block of the VPC: 192.168.0.0/16, 172.16.0.0/12, and 10.0.0.0/8. These CIDR blocks are standard private CIDR blocks as defined by Request for Comments (RFC) documents. The subnet mask must be 8 to 28 bits in length.
               - You can also use a custom CIDR block other than 100.64.0.0/10, 224.0.0.0/4, 127.0.0.0/8, 169.254.0.0/16, and their subnets as the primary IPv4 CIDR block of the VPC.
        :param pulumi.Input[_builtins.bool] classic_link_enabled: The status of ClassicLink function.
        :param pulumi.Input[_builtins.str] description: The new description of the VPC.
               The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] dns_hostname_status: The status of VPC DNS Hostname
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
        :param pulumi.Input[_builtins.bool] enable_ipv6: Whether to enable the IPv6 network segment. Value:
        :param pulumi.Input[_builtins.bool] force_delete: Force delete vpc or not.
        :param pulumi.Input[_builtins.int] ipv4_cidr_mask: Allocate VPC from The IPAM address pool by entering a mask.
               
               > **NOTE:**  when you specify the IPAM address pool to create a VPC, enter at least one of the CidrBlock or Ipv4CidrMask parameters.
        :param pulumi.Input[_builtins.str] ipv4_ipam_pool_id: The ID of the IP Address Manager (IPAM) pool that contains IPv4 addresses.
        :param pulumi.Input[_builtins.str] ipv6_cidr_block: The IPv6 CIDR block of the default VPC.
               
               > **NOTE:**  When `EnableIpv6` is set to `true`, this parameter is required.
        :param pulumi.Input[_builtins.str] ipv6_isp: The IPv6 address segment type of the VPC. Value:
               - `BGP` (default): Alibaba Cloud BGP IPv6.
               - `ChinaMobile`: China Mobile (single line).
               - `ChinaUnicom`: China Unicom (single line).
               - `ChinaTelecom`: China Telecom (single line).
               
               > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to `ChinaTelecom` (China Telecom), `ChinaUnicom` (China Unicom), or `ChinaMobile` (China Mobile).
        :param pulumi.Input[_builtins.bool] is_default: Specifies whether to create the default VPC in the specified region. Valid values:
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.119.0. New field 'vpc_name' instead.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which you want to move the resource.
               
               > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_cidr_blocks: Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.
        :param pulumi.Input[_builtins.int] secondary_cidr_mask: Field 'router_table_id' has been deprecated from provider version 1.248.0. New resource 'alicloud_vpc_ipv4_cidr_block' instead.
        :param pulumi.Input[_builtins.str] system_route_table_description: The description of the route table.
               The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] system_route_table_name: The name of the route table.
               The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.bool] system_route_table_route_propagation_enable: Whether the system route table receives propagation routes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of Vpc.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_cidrs: A list of user CIDRs.
        :param pulumi.Input[_builtins.str] vpc_name: The new name of the VPC.
               The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if classic_link_enabled is not None:
            pulumi.set(__self__, "classic_link_enabled", classic_link_enabled)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_hostname_status is not None:
            pulumi.set(__self__, "dns_hostname_status", dns_hostname_status)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if ipv4_cidr_mask is not None:
            pulumi.set(__self__, "ipv4_cidr_mask", ipv4_cidr_mask)
        if ipv4_ipam_pool_id is not None:
            pulumi.set(__self__, "ipv4_ipam_pool_id", ipv4_ipam_pool_id)
        if ipv6_cidr_block is not None:
            pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        if ipv6_isp is not None:
            pulumi.set(__self__, "ipv6_isp", ipv6_isp)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.119.0. New field 'vpc_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.119.0. New field 'vpc_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if secondary_cidr_blocks is not None:
            warnings.warn("""Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0. Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.""", DeprecationWarning)
            pulumi.log.warn("""secondary_cidr_blocks is deprecated: Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0. Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.""")
        if secondary_cidr_blocks is not None:
            pulumi.set(__self__, "secondary_cidr_blocks", secondary_cidr_blocks)
        if secondary_cidr_mask is not None:
            warnings.warn("""Field 'secondary_cidr_mask' has been deprecated from provider version 1.248.0. Field 'secondary_cidr_blocks' has been deprecated from provider version 1.248.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_mask` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.""", DeprecationWarning)
            pulumi.log.warn("""secondary_cidr_mask is deprecated: Field 'secondary_cidr_mask' has been deprecated from provider version 1.248.0. Field 'secondary_cidr_blocks' has been deprecated from provider version 1.248.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_mask` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.""")
        if secondary_cidr_mask is not None:
            pulumi.set(__self__, "secondary_cidr_mask", secondary_cidr_mask)
        if system_route_table_description is not None:
            pulumi.set(__self__, "system_route_table_description", system_route_table_description)
        if system_route_table_name is not None:
            pulumi.set(__self__, "system_route_table_name", system_route_table_name)
        if system_route_table_route_propagation_enable is not None:
            pulumi.set(__self__, "system_route_table_route_propagation_enable", system_route_table_route_propagation_enable)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_cidrs is not None:
            pulumi.set(__self__, "user_cidrs", user_cidrs)
        if vpc_name is not None:
            pulumi.set(__self__, "vpc_name", vpc_name)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR block of the VPC.

        - You can specify one of the following CIDR blocks or their subsets as the primary IPv4 CIDR block of the VPC: 192.168.0.0/16, 172.16.0.0/12, and 10.0.0.0/8. These CIDR blocks are standard private CIDR blocks as defined by Request for Comments (RFC) documents. The subnet mask must be 8 to 28 bits in length.
        - You can also use a custom CIDR block other than 100.64.0.0/10, 224.0.0.0/4, 127.0.0.0/8, 169.254.0.0/16, and their subnets as the primary IPv4 CIDR block of the VPC.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="classicLinkEnabled")
    def classic_link_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The status of ClassicLink function.
        """
        return pulumi.get(self, "classic_link_enabled")

    @classic_link_enabled.setter
    def classic_link_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "classic_link_enabled", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new description of the VPC.
        The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dnsHostnameStatus")
    def dns_hostname_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of VPC DNS Hostname
        """
        return pulumi.get(self, "dns_hostname_status")

    @dns_hostname_status.setter
    def dns_hostname_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_hostname_status", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to PreCheck only this request. Value:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the IPv6 network segment. Value:
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Force delete vpc or not.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="ipv4CidrMask")
    def ipv4_cidr_mask(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Allocate VPC from The IPAM address pool by entering a mask.

        > **NOTE:**  when you specify the IPAM address pool to create a VPC, enter at least one of the CidrBlock or Ipv4CidrMask parameters.
        """
        return pulumi.get(self, "ipv4_cidr_mask")

    @ipv4_cidr_mask.setter
    def ipv4_cidr_mask(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv4_cidr_mask", value)

    @_builtins.property
    @pulumi.getter(name="ipv4IpamPoolId")
    def ipv4_ipam_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IP Address Manager (IPAM) pool that contains IPv4 addresses.
        """
        return pulumi.get(self, "ipv4_ipam_pool_id")

    @ipv4_ipam_pool_id.setter
    def ipv4_ipam_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_ipam_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 CIDR block of the default VPC.

        > **NOTE:**  When `EnableIpv6` is set to `true`, this parameter is required.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @ipv6_cidr_block.setter
    def ipv6_cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Isp")
    def ipv6_isp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 address segment type of the VPC. Value:
        - `BGP` (default): Alibaba Cloud BGP IPv6.
        - `ChinaMobile`: China Mobile (single line).
        - `ChinaUnicom`: China Unicom (single line).
        - `ChinaTelecom`: China Telecom (single line).

        > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to `ChinaTelecom` (China Telecom), `ChinaUnicom` (China Unicom), or `ChinaMobile` (China Mobile).
        """
        return pulumi.get(self, "ipv6_isp")

    @ipv6_isp.setter
    def ipv6_isp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_isp", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to create the default VPC in the specified region. Valid values:
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.119.0. New field 'vpc_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.119.0. New field 'vpc_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which you want to move the resource.

        > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="secondaryCidrBlocks")
    @_utilities.deprecated("""Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0. Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.""")
    def secondary_cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.
        """
        return pulumi.get(self, "secondary_cidr_blocks")

    @secondary_cidr_blocks.setter
    def secondary_cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secondary_cidr_blocks", value)

    @_builtins.property
    @pulumi.getter(name="secondaryCidrMask")
    @_utilities.deprecated("""Field 'secondary_cidr_mask' has been deprecated from provider version 1.248.0. Field 'secondary_cidr_blocks' has been deprecated from provider version 1.248.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_mask` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.""")
    def secondary_cidr_mask(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Field 'router_table_id' has been deprecated from provider version 1.248.0. New resource 'alicloud_vpc_ipv4_cidr_block' instead.
        """
        return pulumi.get(self, "secondary_cidr_mask")

    @secondary_cidr_mask.setter
    def secondary_cidr_mask(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secondary_cidr_mask", value)

    @_builtins.property
    @pulumi.getter(name="systemRouteTableDescription")
    def system_route_table_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the route table.
        The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "system_route_table_description")

    @system_route_table_description.setter
    def system_route_table_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_route_table_description", value)

    @_builtins.property
    @pulumi.getter(name="systemRouteTableName")
    def system_route_table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the route table.
        The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "system_route_table_name")

    @system_route_table_name.setter
    def system_route_table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_route_table_name", value)

    @_builtins.property
    @pulumi.getter(name="systemRouteTableRoutePropagationEnable")
    def system_route_table_route_propagation_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the system route table receives propagation routes.
        """
        return pulumi.get(self, "system_route_table_route_propagation_enable")

    @system_route_table_route_propagation_enable.setter
    def system_route_table_route_propagation_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system_route_table_route_propagation_enable", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags of Vpc.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userCidrs")
    def user_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of user CIDRs.
        """
        return pulumi.get(self, "user_cidrs")

    @user_cidrs.setter
    def user_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new name of the VPC.
        The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "vpc_name")

    @vpc_name.setter
    def vpc_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_name", value)


@pulumi.input_type
class _NetworkState:
    def __init__(__self__, *,
                 cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 classic_link_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_hostname_status: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv4_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv4_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkIpv6CidrBlockArgs']]]] = None,
                 ipv6_isp: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 router_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secondary_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 system_route_table_description: Optional[pulumi.Input[_builtins.str]] = None,
                 system_route_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_route_table_route_propagation_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Network resources.
        :param pulumi.Input[_builtins.str] cidr_block: The CIDR block of the VPC.
               
               - You can specify one of the following CIDR blocks or their subsets as the primary IPv4 CIDR block of the VPC: 192.168.0.0/16, 172.16.0.0/12, and 10.0.0.0/8. These CIDR blocks are standard private CIDR blocks as defined by Request for Comments (RFC) documents. The subnet mask must be 8 to 28 bits in length.
               - You can also use a custom CIDR block other than 100.64.0.0/10, 224.0.0.0/4, 127.0.0.0/8, 169.254.0.0/16, and their subnets as the primary IPv4 CIDR block of the VPC.
        :param pulumi.Input[_builtins.bool] classic_link_enabled: The status of ClassicLink function.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the VPC.
        :param pulumi.Input[_builtins.str] description: The new description of the VPC.
               The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] dns_hostname_status: The status of VPC DNS Hostname
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
        :param pulumi.Input[_builtins.bool] enable_ipv6: Whether to enable the IPv6 network segment. Value:
        :param pulumi.Input[_builtins.bool] force_delete: Force delete vpc or not.
        :param pulumi.Input[_builtins.int] ipv4_cidr_mask: Allocate VPC from The IPAM address pool by entering a mask.
               
               > **NOTE:**  when you specify the IPAM address pool to create a VPC, enter at least one of the CidrBlock or Ipv4CidrMask parameters.
        :param pulumi.Input[_builtins.str] ipv4_ipam_pool_id: The ID of the IP Address Manager (IPAM) pool that contains IPv4 addresses.
        :param pulumi.Input[_builtins.str] ipv6_cidr_block: The IPv6 CIDR block of the default VPC.
               
               > **NOTE:**  When `EnableIpv6` is set to `true`, this parameter is required.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkIpv6CidrBlockArgs']]] ipv6_cidr_blocks: The IPv6 CIDR block information of the VPC.
        :param pulumi.Input[_builtins.str] ipv6_isp: The IPv6 address segment type of the VPC. Value:
               - `BGP` (default): Alibaba Cloud BGP IPv6.
               - `ChinaMobile`: China Mobile (single line).
               - `ChinaUnicom`: China Unicom (single line).
               - `ChinaTelecom`: China Telecom (single line).
               
               > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to `ChinaTelecom` (China Telecom), `ChinaUnicom` (China Unicom), or `ChinaMobile` (China Mobile).
        :param pulumi.Input[_builtins.bool] is_default: Specifies whether to create the default VPC in the specified region. Valid values:
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.119.0. New field 'vpc_name' instead.
        :param pulumi.Input[_builtins.str] region_id: The ID of the region where the VPC is located.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which you want to move the resource.
               
               > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the system route table.
        :param pulumi.Input[_builtins.str] router_id: The region ID of the VPC to which the route table belongs.
        :param pulumi.Input[_builtins.str] router_table_id: . Field 'router_table_id' has been deprecated from provider version 1.227.1. New field 'route_table_id' instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_cidr_blocks: Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.
        :param pulumi.Input[_builtins.int] secondary_cidr_mask: Field 'router_table_id' has been deprecated from provider version 1.248.0. New resource 'alicloud_vpc_ipv4_cidr_block' instead.
        :param pulumi.Input[_builtins.str] status: The status of the VPC.   `Pending`: The VPC is being configured. `Available`: The VPC is available.
        :param pulumi.Input[_builtins.str] system_route_table_description: The description of the route table.
               The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] system_route_table_name: The name of the route table.
               The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.bool] system_route_table_route_propagation_enable: Whether the system route table receives propagation routes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of Vpc.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_cidrs: A list of user CIDRs.
        :param pulumi.Input[_builtins.str] vpc_name: The new name of the VPC.
               The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if classic_link_enabled is not None:
            pulumi.set(__self__, "classic_link_enabled", classic_link_enabled)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_hostname_status is not None:
            pulumi.set(__self__, "dns_hostname_status", dns_hostname_status)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if ipv4_cidr_mask is not None:
            pulumi.set(__self__, "ipv4_cidr_mask", ipv4_cidr_mask)
        if ipv4_ipam_pool_id is not None:
            pulumi.set(__self__, "ipv4_ipam_pool_id", ipv4_ipam_pool_id)
        if ipv6_cidr_block is not None:
            pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        if ipv6_cidr_blocks is not None:
            pulumi.set(__self__, "ipv6_cidr_blocks", ipv6_cidr_blocks)
        if ipv6_isp is not None:
            pulumi.set(__self__, "ipv6_isp", ipv6_isp)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.119.0. New field 'vpc_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.119.0. New field 'vpc_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if router_id is not None:
            pulumi.set(__self__, "router_id", router_id)
        if router_table_id is not None:
            warnings.warn("""Field 'router_table_id' has been deprecated since provider version 1.221.0. New field 'route_table_id' instead.""", DeprecationWarning)
            pulumi.log.warn("""router_table_id is deprecated: Field 'router_table_id' has been deprecated since provider version 1.221.0. New field 'route_table_id' instead.""")
        if router_table_id is not None:
            pulumi.set(__self__, "router_table_id", router_table_id)
        if secondary_cidr_blocks is not None:
            warnings.warn("""Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0. Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.""", DeprecationWarning)
            pulumi.log.warn("""secondary_cidr_blocks is deprecated: Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0. Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.""")
        if secondary_cidr_blocks is not None:
            pulumi.set(__self__, "secondary_cidr_blocks", secondary_cidr_blocks)
        if secondary_cidr_mask is not None:
            warnings.warn("""Field 'secondary_cidr_mask' has been deprecated from provider version 1.248.0. Field 'secondary_cidr_blocks' has been deprecated from provider version 1.248.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_mask` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.""", DeprecationWarning)
            pulumi.log.warn("""secondary_cidr_mask is deprecated: Field 'secondary_cidr_mask' has been deprecated from provider version 1.248.0. Field 'secondary_cidr_blocks' has been deprecated from provider version 1.248.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_mask` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.""")
        if secondary_cidr_mask is not None:
            pulumi.set(__self__, "secondary_cidr_mask", secondary_cidr_mask)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_route_table_description is not None:
            pulumi.set(__self__, "system_route_table_description", system_route_table_description)
        if system_route_table_name is not None:
            pulumi.set(__self__, "system_route_table_name", system_route_table_name)
        if system_route_table_route_propagation_enable is not None:
            pulumi.set(__self__, "system_route_table_route_propagation_enable", system_route_table_route_propagation_enable)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_cidrs is not None:
            pulumi.set(__self__, "user_cidrs", user_cidrs)
        if vpc_name is not None:
            pulumi.set(__self__, "vpc_name", vpc_name)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR block of the VPC.

        - You can specify one of the following CIDR blocks or their subsets as the primary IPv4 CIDR block of the VPC: 192.168.0.0/16, 172.16.0.0/12, and 10.0.0.0/8. These CIDR blocks are standard private CIDR blocks as defined by Request for Comments (RFC) documents. The subnet mask must be 8 to 28 bits in length.
        - You can also use a custom CIDR block other than 100.64.0.0/10, 224.0.0.0/4, 127.0.0.0/8, 169.254.0.0/16, and their subnets as the primary IPv4 CIDR block of the VPC.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="classicLinkEnabled")
    def classic_link_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The status of ClassicLink function.
        """
        return pulumi.get(self, "classic_link_enabled")

    @classic_link_enabled.setter
    def classic_link_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "classic_link_enabled", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the VPC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new description of the VPC.
        The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dnsHostnameStatus")
    def dns_hostname_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of VPC DNS Hostname
        """
        return pulumi.get(self, "dns_hostname_status")

    @dns_hostname_status.setter
    def dns_hostname_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_hostname_status", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to PreCheck only this request. Value:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the IPv6 network segment. Value:
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Force delete vpc or not.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="ipv4CidrMask")
    def ipv4_cidr_mask(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Allocate VPC from The IPAM address pool by entering a mask.

        > **NOTE:**  when you specify the IPAM address pool to create a VPC, enter at least one of the CidrBlock or Ipv4CidrMask parameters.
        """
        return pulumi.get(self, "ipv4_cidr_mask")

    @ipv4_cidr_mask.setter
    def ipv4_cidr_mask(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv4_cidr_mask", value)

    @_builtins.property
    @pulumi.getter(name="ipv4IpamPoolId")
    def ipv4_ipam_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IP Address Manager (IPAM) pool that contains IPv4 addresses.
        """
        return pulumi.get(self, "ipv4_ipam_pool_id")

    @ipv4_ipam_pool_id.setter
    def ipv4_ipam_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_ipam_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 CIDR block of the default VPC.

        > **NOTE:**  When `EnableIpv6` is set to `true`, this parameter is required.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @ipv6_cidr_block.setter
    def ipv6_cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="ipv6CidrBlocks")
    def ipv6_cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkIpv6CidrBlockArgs']]]]:
        """
        The IPv6 CIDR block information of the VPC.
        """
        return pulumi.get(self, "ipv6_cidr_blocks")

    @ipv6_cidr_blocks.setter
    def ipv6_cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkIpv6CidrBlockArgs']]]]):
        pulumi.set(self, "ipv6_cidr_blocks", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Isp")
    def ipv6_isp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 address segment type of the VPC. Value:
        - `BGP` (default): Alibaba Cloud BGP IPv6.
        - `ChinaMobile`: China Mobile (single line).
        - `ChinaUnicom`: China Unicom (single line).
        - `ChinaTelecom`: China Telecom (single line).

        > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to `ChinaTelecom` (China Telecom), `ChinaUnicom` (China Unicom), or `ChinaMobile` (China Mobile).
        """
        return pulumi.get(self, "ipv6_isp")

    @ipv6_isp.setter
    def ipv6_isp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_isp", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to create the default VPC in the specified region. Valid values:
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.119.0. New field 'vpc_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.119.0. New field 'vpc_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region where the VPC is located.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which you want to move the resource.

        > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the system route table.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter(name="routerId")
    def router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the VPC to which the route table belongs.
        """
        return pulumi.get(self, "router_id")

    @router_id.setter
    def router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "router_id", value)

    @_builtins.property
    @pulumi.getter(name="routerTableId")
    @_utilities.deprecated("""Field 'router_table_id' has been deprecated since provider version 1.221.0. New field 'route_table_id' instead.""")
    def router_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'router_table_id' has been deprecated from provider version 1.227.1. New field 'route_table_id' instead.
        """
        return pulumi.get(self, "router_table_id")

    @router_table_id.setter
    def router_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "router_table_id", value)

    @_builtins.property
    @pulumi.getter(name="secondaryCidrBlocks")
    @_utilities.deprecated("""Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0. Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.""")
    def secondary_cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.
        """
        return pulumi.get(self, "secondary_cidr_blocks")

    @secondary_cidr_blocks.setter
    def secondary_cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secondary_cidr_blocks", value)

    @_builtins.property
    @pulumi.getter(name="secondaryCidrMask")
    @_utilities.deprecated("""Field 'secondary_cidr_mask' has been deprecated from provider version 1.248.0. Field 'secondary_cidr_blocks' has been deprecated from provider version 1.248.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_mask` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.""")
    def secondary_cidr_mask(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Field 'router_table_id' has been deprecated from provider version 1.248.0. New resource 'alicloud_vpc_ipv4_cidr_block' instead.
        """
        return pulumi.get(self, "secondary_cidr_mask")

    @secondary_cidr_mask.setter
    def secondary_cidr_mask(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secondary_cidr_mask", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the VPC.   `Pending`: The VPC is being configured. `Available`: The VPC is available.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="systemRouteTableDescription")
    def system_route_table_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the route table.
        The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "system_route_table_description")

    @system_route_table_description.setter
    def system_route_table_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_route_table_description", value)

    @_builtins.property
    @pulumi.getter(name="systemRouteTableName")
    def system_route_table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the route table.
        The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "system_route_table_name")

    @system_route_table_name.setter
    def system_route_table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_route_table_name", value)

    @_builtins.property
    @pulumi.getter(name="systemRouteTableRoutePropagationEnable")
    def system_route_table_route_propagation_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the system route table receives propagation routes.
        """
        return pulumi.get(self, "system_route_table_route_propagation_enable")

    @system_route_table_route_propagation_enable.setter
    def system_route_table_route_propagation_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system_route_table_route_propagation_enable", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags of Vpc.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userCidrs")
    def user_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of user CIDRs.
        """
        return pulumi.get(self, "user_cidrs")

    @user_cidrs.setter
    def user_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new name of the VPC.
        The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "vpc_name")

    @vpc_name.setter
    def vpc_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_name", value)


@pulumi.type_token("alicloud:vpc/network:Network")
class Network(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 classic_link_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_hostname_status: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv4_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv4_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_isp: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secondary_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 system_route_table_description: Optional[pulumi.Input[_builtins.str]] = None,
                 system_route_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_route_table_route_propagation_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a VPC VPC resource.

        A VPC instance creates a VPC. You can fully control your own VPC, such as selecting IP address ranges, configuring routing tables, and gateways. You can use Alibaba cloud resources such as cloud servers, apsaradb for RDS, and load balancer in your own VPC.

        > **NOTE:** This resource will auto build a router and a route table while it uses `vpc.Network` to build a vpc resource.

        > **NOTE:** Available since v1.0.0.

        ## Module Support

        You can use the existing vpc module
        to create a VPC and several VSwitches one-click.

        For information about VPC VPC and how to use it, see [What is VPC](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/what-is-a-vpc).

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.vpc.Network("default",
            ipv6_isp="BGP",
            description="test",
            cidr_block="10.0.0.0/8",
            vpc_name=name,
            enable_ipv6=True)
        ```

        ## Import

        VPC VPC can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/network:Network example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cidr_block: The CIDR block of the VPC.
               
               - You can specify one of the following CIDR blocks or their subsets as the primary IPv4 CIDR block of the VPC: 192.168.0.0/16, 172.16.0.0/12, and 10.0.0.0/8. These CIDR blocks are standard private CIDR blocks as defined by Request for Comments (RFC) documents. The subnet mask must be 8 to 28 bits in length.
               - You can also use a custom CIDR block other than 100.64.0.0/10, 224.0.0.0/4, 127.0.0.0/8, 169.254.0.0/16, and their subnets as the primary IPv4 CIDR block of the VPC.
        :param pulumi.Input[_builtins.bool] classic_link_enabled: The status of ClassicLink function.
        :param pulumi.Input[_builtins.str] description: The new description of the VPC.
               The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] dns_hostname_status: The status of VPC DNS Hostname
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
        :param pulumi.Input[_builtins.bool] enable_ipv6: Whether to enable the IPv6 network segment. Value:
        :param pulumi.Input[_builtins.bool] force_delete: Force delete vpc or not.
        :param pulumi.Input[_builtins.int] ipv4_cidr_mask: Allocate VPC from The IPAM address pool by entering a mask.
               
               > **NOTE:**  when you specify the IPAM address pool to create a VPC, enter at least one of the CidrBlock or Ipv4CidrMask parameters.
        :param pulumi.Input[_builtins.str] ipv4_ipam_pool_id: The ID of the IP Address Manager (IPAM) pool that contains IPv4 addresses.
        :param pulumi.Input[_builtins.str] ipv6_cidr_block: The IPv6 CIDR block of the default VPC.
               
               > **NOTE:**  When `EnableIpv6` is set to `true`, this parameter is required.
        :param pulumi.Input[_builtins.str] ipv6_isp: The IPv6 address segment type of the VPC. Value:
               - `BGP` (default): Alibaba Cloud BGP IPv6.
               - `ChinaMobile`: China Mobile (single line).
               - `ChinaUnicom`: China Unicom (single line).
               - `ChinaTelecom`: China Telecom (single line).
               
               > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to `ChinaTelecom` (China Telecom), `ChinaUnicom` (China Unicom), or `ChinaMobile` (China Mobile).
        :param pulumi.Input[_builtins.bool] is_default: Specifies whether to create the default VPC in the specified region. Valid values:
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.119.0. New field 'vpc_name' instead.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which you want to move the resource.
               
               > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_cidr_blocks: Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.
        :param pulumi.Input[_builtins.int] secondary_cidr_mask: Field 'router_table_id' has been deprecated from provider version 1.248.0. New resource 'alicloud_vpc_ipv4_cidr_block' instead.
        :param pulumi.Input[_builtins.str] system_route_table_description: The description of the route table.
               The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] system_route_table_name: The name of the route table.
               The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.bool] system_route_table_route_propagation_enable: Whether the system route table receives propagation routes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of Vpc.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_cidrs: A list of user CIDRs.
        :param pulumi.Input[_builtins.str] vpc_name: The new name of the VPC.
               The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NetworkArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VPC VPC resource.

        A VPC instance creates a VPC. You can fully control your own VPC, such as selecting IP address ranges, configuring routing tables, and gateways. You can use Alibaba cloud resources such as cloud servers, apsaradb for RDS, and load balancer in your own VPC.

        > **NOTE:** This resource will auto build a router and a route table while it uses `vpc.Network` to build a vpc resource.

        > **NOTE:** Available since v1.0.0.

        ## Module Support

        You can use the existing vpc module
        to create a VPC and several VSwitches one-click.

        For information about VPC VPC and how to use it, see [What is VPC](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/what-is-a-vpc).

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.vpc.Network("default",
            ipv6_isp="BGP",
            description="test",
            cidr_block="10.0.0.0/8",
            vpc_name=name,
            enable_ipv6=True)
        ```

        ## Import

        VPC VPC can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/network:Network example <id>
        ```

        :param str resource_name: The name of the resource.
        :param NetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 classic_link_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_hostname_status: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv4_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv4_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_isp: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secondary_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 system_route_table_description: Optional[pulumi.Input[_builtins.str]] = None,
                 system_route_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_route_table_route_propagation_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkArgs.__new__(NetworkArgs)

            __props__.__dict__["cidr_block"] = cidr_block
            __props__.__dict__["classic_link_enabled"] = classic_link_enabled
            __props__.__dict__["description"] = description
            __props__.__dict__["dns_hostname_status"] = dns_hostname_status
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["enable_ipv6"] = enable_ipv6
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["ipv4_cidr_mask"] = ipv4_cidr_mask
            __props__.__dict__["ipv4_ipam_pool_id"] = ipv4_ipam_pool_id
            __props__.__dict__["ipv6_cidr_block"] = ipv6_cidr_block
            __props__.__dict__["ipv6_isp"] = ipv6_isp
            __props__.__dict__["is_default"] = is_default
            __props__.__dict__["name"] = name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["secondary_cidr_blocks"] = secondary_cidr_blocks
            __props__.__dict__["secondary_cidr_mask"] = secondary_cidr_mask
            __props__.__dict__["system_route_table_description"] = system_route_table_description
            __props__.__dict__["system_route_table_name"] = system_route_table_name
            __props__.__dict__["system_route_table_route_propagation_enable"] = system_route_table_route_propagation_enable
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_cidrs"] = user_cidrs
            __props__.__dict__["vpc_name"] = vpc_name
            __props__.__dict__["create_time"] = None
            __props__.__dict__["ipv6_cidr_blocks"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["route_table_id"] = None
            __props__.__dict__["router_id"] = None
            __props__.__dict__["router_table_id"] = None
            __props__.__dict__["status"] = None
        super(Network, __self__).__init__(
            'alicloud:vpc/network:Network',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
            classic_link_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dns_hostname_status: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
            force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            ipv4_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
            ipv4_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkIpv6CidrBlockArgs', 'NetworkIpv6CidrBlockArgsDict']]]]] = None,
            ipv6_isp: Optional[pulumi.Input[_builtins.str]] = None,
            is_default: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
            router_id: Optional[pulumi.Input[_builtins.str]] = None,
            router_table_id: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            secondary_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            system_route_table_description: Optional[pulumi.Input[_builtins.str]] = None,
            system_route_table_name: Optional[pulumi.Input[_builtins.str]] = None,
            system_route_table_route_propagation_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            user_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            vpc_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'Network':
        """
        Get an existing Network resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cidr_block: The CIDR block of the VPC.
               
               - You can specify one of the following CIDR blocks or their subsets as the primary IPv4 CIDR block of the VPC: 192.168.0.0/16, 172.16.0.0/12, and 10.0.0.0/8. These CIDR blocks are standard private CIDR blocks as defined by Request for Comments (RFC) documents. The subnet mask must be 8 to 28 bits in length.
               - You can also use a custom CIDR block other than 100.64.0.0/10, 224.0.0.0/4, 127.0.0.0/8, 169.254.0.0/16, and their subnets as the primary IPv4 CIDR block of the VPC.
        :param pulumi.Input[_builtins.bool] classic_link_enabled: The status of ClassicLink function.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the VPC.
        :param pulumi.Input[_builtins.str] description: The new description of the VPC.
               The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] dns_hostname_status: The status of VPC DNS Hostname
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
        :param pulumi.Input[_builtins.bool] enable_ipv6: Whether to enable the IPv6 network segment. Value:
        :param pulumi.Input[_builtins.bool] force_delete: Force delete vpc or not.
        :param pulumi.Input[_builtins.int] ipv4_cidr_mask: Allocate VPC from The IPAM address pool by entering a mask.
               
               > **NOTE:**  when you specify the IPAM address pool to create a VPC, enter at least one of the CidrBlock or Ipv4CidrMask parameters.
        :param pulumi.Input[_builtins.str] ipv4_ipam_pool_id: The ID of the IP Address Manager (IPAM) pool that contains IPv4 addresses.
        :param pulumi.Input[_builtins.str] ipv6_cidr_block: The IPv6 CIDR block of the default VPC.
               
               > **NOTE:**  When `EnableIpv6` is set to `true`, this parameter is required.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkIpv6CidrBlockArgs', 'NetworkIpv6CidrBlockArgsDict']]]] ipv6_cidr_blocks: The IPv6 CIDR block information of the VPC.
        :param pulumi.Input[_builtins.str] ipv6_isp: The IPv6 address segment type of the VPC. Value:
               - `BGP` (default): Alibaba Cloud BGP IPv6.
               - `ChinaMobile`: China Mobile (single line).
               - `ChinaUnicom`: China Unicom (single line).
               - `ChinaTelecom`: China Telecom (single line).
               
               > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to `ChinaTelecom` (China Telecom), `ChinaUnicom` (China Unicom), or `ChinaMobile` (China Mobile).
        :param pulumi.Input[_builtins.bool] is_default: Specifies whether to create the default VPC in the specified region. Valid values:
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.119.0. New field 'vpc_name' instead.
        :param pulumi.Input[_builtins.str] region_id: The ID of the region where the VPC is located.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which you want to move the resource.
               
               > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the system route table.
        :param pulumi.Input[_builtins.str] router_id: The region ID of the VPC to which the route table belongs.
        :param pulumi.Input[_builtins.str] router_table_id: . Field 'router_table_id' has been deprecated from provider version 1.227.1. New field 'route_table_id' instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_cidr_blocks: Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.
        :param pulumi.Input[_builtins.int] secondary_cidr_mask: Field 'router_table_id' has been deprecated from provider version 1.248.0. New resource 'alicloud_vpc_ipv4_cidr_block' instead.
        :param pulumi.Input[_builtins.str] status: The status of the VPC.   `Pending`: The VPC is being configured. `Available`: The VPC is available.
        :param pulumi.Input[_builtins.str] system_route_table_description: The description of the route table.
               The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] system_route_table_name: The name of the route table.
               The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.bool] system_route_table_route_propagation_enable: Whether the system route table receives propagation routes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of Vpc.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_cidrs: A list of user CIDRs.
        :param pulumi.Input[_builtins.str] vpc_name: The new name of the VPC.
               The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkState.__new__(_NetworkState)

        __props__.__dict__["cidr_block"] = cidr_block
        __props__.__dict__["classic_link_enabled"] = classic_link_enabled
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["dns_hostname_status"] = dns_hostname_status
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["enable_ipv6"] = enable_ipv6
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["ipv4_cidr_mask"] = ipv4_cidr_mask
        __props__.__dict__["ipv4_ipam_pool_id"] = ipv4_ipam_pool_id
        __props__.__dict__["ipv6_cidr_block"] = ipv6_cidr_block
        __props__.__dict__["ipv6_cidr_blocks"] = ipv6_cidr_blocks
        __props__.__dict__["ipv6_isp"] = ipv6_isp
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["name"] = name
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["route_table_id"] = route_table_id
        __props__.__dict__["router_id"] = router_id
        __props__.__dict__["router_table_id"] = router_table_id
        __props__.__dict__["secondary_cidr_blocks"] = secondary_cidr_blocks
        __props__.__dict__["secondary_cidr_mask"] = secondary_cidr_mask
        __props__.__dict__["status"] = status
        __props__.__dict__["system_route_table_description"] = system_route_table_description
        __props__.__dict__["system_route_table_name"] = system_route_table_name
        __props__.__dict__["system_route_table_route_propagation_enable"] = system_route_table_route_propagation_enable
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_cidrs"] = user_cidrs
        __props__.__dict__["vpc_name"] = vpc_name
        return Network(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Output[_builtins.str]:
        """
        The CIDR block of the VPC.

        - You can specify one of the following CIDR blocks or their subsets as the primary IPv4 CIDR block of the VPC: 192.168.0.0/16, 172.16.0.0/12, and 10.0.0.0/8. These CIDR blocks are standard private CIDR blocks as defined by Request for Comments (RFC) documents. The subnet mask must be 8 to 28 bits in length.
        - You can also use a custom CIDR block other than 100.64.0.0/10, 224.0.0.0/4, 127.0.0.0/8, 169.254.0.0/16, and their subnets as the primary IPv4 CIDR block of the VPC.
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter(name="classicLinkEnabled")
    def classic_link_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The status of ClassicLink function.
        """
        return pulumi.get(self, "classic_link_enabled")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the VPC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The new description of the VPC.
        The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsHostnameStatus")
    def dns_hostname_status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of VPC DNS Hostname
        """
        return pulumi.get(self, "dns_hostname_status")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to PreCheck only this request. Value:
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable the IPv6 network segment. Value:
        """
        return pulumi.get(self, "enable_ipv6")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Force delete vpc or not.
        """
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter(name="ipv4CidrMask")
    def ipv4_cidr_mask(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Allocate VPC from The IPAM address pool by entering a mask.

        > **NOTE:**  when you specify the IPAM address pool to create a VPC, enter at least one of the CidrBlock or Ipv4CidrMask parameters.
        """
        return pulumi.get(self, "ipv4_cidr_mask")

    @_builtins.property
    @pulumi.getter(name="ipv4IpamPoolId")
    def ipv4_ipam_pool_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the IP Address Manager (IPAM) pool that contains IPv4 addresses.
        """
        return pulumi.get(self, "ipv4_ipam_pool_id")

    @_builtins.property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> pulumi.Output[_builtins.str]:
        """
        The IPv6 CIDR block of the default VPC.

        > **NOTE:**  When `EnableIpv6` is set to `true`, this parameter is required.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @_builtins.property
    @pulumi.getter(name="ipv6CidrBlocks")
    def ipv6_cidr_blocks(self) -> pulumi.Output[Sequence['outputs.NetworkIpv6CidrBlock']]:
        """
        The IPv6 CIDR block information of the VPC.
        """
        return pulumi.get(self, "ipv6_cidr_blocks")

    @_builtins.property
    @pulumi.getter(name="ipv6Isp")
    def ipv6_isp(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IPv6 address segment type of the VPC. Value:
        - `BGP` (default): Alibaba Cloud BGP IPv6.
        - `ChinaMobile`: China Mobile (single line).
        - `ChinaUnicom`: China Unicom (single line).
        - `ChinaTelecom`: China Telecom (single line).

        > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to `ChinaTelecom` (China Telecom), `ChinaUnicom` (China Unicom), or `ChinaMobile` (China Mobile).
        """
        return pulumi.get(self, "ipv6_isp")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to create the default VPC in the specified region. Valid values:
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.119.0. New field 'vpc_name' instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'name' has been deprecated from provider version 1.119.0. New field 'vpc_name' instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region where the VPC is located.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group to which you want to move the resource.

        > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the system route table.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter(name="routerId")
    def router_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the VPC to which the route table belongs.
        """
        return pulumi.get(self, "router_id")

    @_builtins.property
    @pulumi.getter(name="routerTableId")
    @_utilities.deprecated("""Field 'router_table_id' has been deprecated since provider version 1.221.0. New field 'route_table_id' instead.""")
    def router_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'router_table_id' has been deprecated from provider version 1.227.1. New field 'route_table_id' instead.
        """
        return pulumi.get(self, "router_table_id")

    @_builtins.property
    @pulumi.getter(name="secondaryCidrBlocks")
    @_utilities.deprecated("""Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0. Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.""")
    def secondary_cidr_blocks(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Field 'secondary_cidr_blocks' has been deprecated from provider version 1.185.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_blocks` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.
        """
        return pulumi.get(self, "secondary_cidr_blocks")

    @_builtins.property
    @pulumi.getter(name="secondaryCidrMask")
    @_utilities.deprecated("""Field 'secondary_cidr_mask' has been deprecated from provider version 1.248.0. Field 'secondary_cidr_blocks' has been deprecated from provider version 1.248.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_ipv4_cidr_block'. `secondary_cidr_mask` attributes and `vpc.Ipv4CidrBlock` resource cannot be used at the same time.""")
    def secondary_cidr_mask(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Field 'router_table_id' has been deprecated from provider version 1.248.0. New resource 'alicloud_vpc_ipv4_cidr_block' instead.
        """
        return pulumi.get(self, "secondary_cidr_mask")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the VPC.   `Pending`: The VPC is being configured. `Available`: The VPC is available.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="systemRouteTableDescription")
    def system_route_table_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the route table.
        The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "system_route_table_description")

    @_builtins.property
    @pulumi.getter(name="systemRouteTableName")
    def system_route_table_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the route table.
        The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "system_route_table_name")

    @_builtins.property
    @pulumi.getter(name="systemRouteTableRoutePropagationEnable")
    def system_route_table_route_propagation_enable(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the system route table receives propagation routes.
        """
        return pulumi.get(self, "system_route_table_route_propagation_enable")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tags of Vpc.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userCidrs")
    def user_cidrs(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of user CIDRs.
        """
        return pulumi.get(self, "user_cidrs")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> pulumi.Output[_builtins.str]:
        """
        The new name of the VPC.
        The name must be 1 to 128 characters in length and cannot start with `http://` or `https://`.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "vpc_name")

