# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkAclEntriesArgs', 'NetworkAclEntries']

@pulumi.input_type
class NetworkAclEntriesArgs:
    def __init__(__self__, *,
                 network_acl_id: pulumi.Input[_builtins.str],
                 egresses: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclEntriesEgressArgs']]]] = None,
                 ingresses: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclEntriesIngressArgs']]]] = None):
        """
        The set of arguments for constructing a NetworkAclEntries resource.
        :param pulumi.Input[_builtins.str] network_acl_id: The id of the network acl, the field can't be changed.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAclEntriesEgressArgs']]] egresses: List of the egress entries of the network acl. The order of the egress entries determines the priority. See `egress` below.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAclEntriesIngressArgs']]] ingresses: List of the ingress entries of the network acl. The order of the ingress entries determines the priority. See `ingress` below.
        """
        pulumi.set(__self__, "network_acl_id", network_acl_id)
        if egresses is not None:
            pulumi.set(__self__, "egresses", egresses)
        if ingresses is not None:
            pulumi.set(__self__, "ingresses", ingresses)

    @_builtins.property
    @pulumi.getter(name="networkAclId")
    def network_acl_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the network acl, the field can't be changed.
        """
        return pulumi.get(self, "network_acl_id")

    @network_acl_id.setter
    def network_acl_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_acl_id", value)

    @_builtins.property
    @pulumi.getter
    def egresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclEntriesEgressArgs']]]]:
        """
        List of the egress entries of the network acl. The order of the egress entries determines the priority. See `egress` below.
        """
        return pulumi.get(self, "egresses")

    @egresses.setter
    def egresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclEntriesEgressArgs']]]]):
        pulumi.set(self, "egresses", value)

    @_builtins.property
    @pulumi.getter
    def ingresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclEntriesIngressArgs']]]]:
        """
        List of the ingress entries of the network acl. The order of the ingress entries determines the priority. See `ingress` below.
        """
        return pulumi.get(self, "ingresses")

    @ingresses.setter
    def ingresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclEntriesIngressArgs']]]]):
        pulumi.set(self, "ingresses", value)


@pulumi.input_type
class _NetworkAclEntriesState:
    def __init__(__self__, *,
                 egresses: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclEntriesEgressArgs']]]] = None,
                 ingresses: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclEntriesIngressArgs']]]] = None,
                 network_acl_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkAclEntries resources.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAclEntriesEgressArgs']]] egresses: List of the egress entries of the network acl. The order of the egress entries determines the priority. See `egress` below.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAclEntriesIngressArgs']]] ingresses: List of the ingress entries of the network acl. The order of the ingress entries determines the priority. See `ingress` below.
        :param pulumi.Input[_builtins.str] network_acl_id: The id of the network acl, the field can't be changed.
        """
        if egresses is not None:
            pulumi.set(__self__, "egresses", egresses)
        if ingresses is not None:
            pulumi.set(__self__, "ingresses", ingresses)
        if network_acl_id is not None:
            pulumi.set(__self__, "network_acl_id", network_acl_id)

    @_builtins.property
    @pulumi.getter
    def egresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclEntriesEgressArgs']]]]:
        """
        List of the egress entries of the network acl. The order of the egress entries determines the priority. See `egress` below.
        """
        return pulumi.get(self, "egresses")

    @egresses.setter
    def egresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclEntriesEgressArgs']]]]):
        pulumi.set(self, "egresses", value)

    @_builtins.property
    @pulumi.getter
    def ingresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclEntriesIngressArgs']]]]:
        """
        List of the ingress entries of the network acl. The order of the ingress entries determines the priority. See `ingress` below.
        """
        return pulumi.get(self, "ingresses")

    @ingresses.setter
    def ingresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclEntriesIngressArgs']]]]):
        pulumi.set(self, "ingresses", value)

    @_builtins.property
    @pulumi.getter(name="networkAclId")
    def network_acl_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the network acl, the field can't be changed.
        """
        return pulumi.get(self, "network_acl_id")

    @network_acl_id.setter
    def network_acl_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_acl_id", value)


@pulumi.type_token("alicloud:vpc/networkAclEntries:NetworkAclEntries")
class NetworkAclEntries(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 egresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclEntriesEgressArgs', 'NetworkAclEntriesEgressArgsDict']]]]] = None,
                 ingresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclEntriesIngressArgs', 'NetworkAclEntriesIngressArgsDict']]]]] = None,
                 network_acl_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a network acl entries resource to create ingress and egress entries.

        > **NOTE:** Available in 1.45.0+.

        > **NOTE:** It doesn't support concurrency and the order of the ingress and egress entries determines the priority.

        > **DEPRECATED:**  This resource  has been deprecated from version `1.122.0`. Replace by `ingress_acl_entries` and `egress_acl_entries` with the resource alicloud_network_acl.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "NetworkAclEntries"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            name=name,
            cidr_block="172.16.0.0/12")
        default_network_acl = alicloud.vpc.NetworkAcl("default",
            vpc_id=default_network.id,
            name=name)
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/21",
            zone_id=default.zones[0].id,
            name=name)
        default_network_acl_attachment = alicloud.vpc.NetworkAclAttachment("default",
            network_acl_id=default_network_acl.id,
            resources=[{
                "resource_id": default_switch.id,
                "resource_type": "VSwitch",
            }])
        default_network_acl_entries = alicloud.vpc.NetworkAclEntries("default",
            network_acl_id=default_network_acl.id,
            ingresses=[{
                "protocol": "all",
                "port": "-1/-1",
                "source_cidr_ip": "0.0.0.0/32",
                "name": name,
                "entry_type": "custom",
                "policy": "accept",
                "description": name,
            }],
            egresses=[{
                "protocol": "all",
                "port": "-1/-1",
                "destination_cidr_ip": "0.0.0.0/32",
                "name": name,
                "entry_type": "custom",
                "policy": "accept",
                "description": name,
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclEntriesEgressArgs', 'NetworkAclEntriesEgressArgsDict']]]] egresses: List of the egress entries of the network acl. The order of the egress entries determines the priority. See `egress` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclEntriesIngressArgs', 'NetworkAclEntriesIngressArgsDict']]]] ingresses: List of the ingress entries of the network acl. The order of the ingress entries determines the priority. See `ingress` below.
        :param pulumi.Input[_builtins.str] network_acl_id: The id of the network acl, the field can't be changed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkAclEntriesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a network acl entries resource to create ingress and egress entries.

        > **NOTE:** Available in 1.45.0+.

        > **NOTE:** It doesn't support concurrency and the order of the ingress and egress entries determines the priority.

        > **DEPRECATED:**  This resource  has been deprecated from version `1.122.0`. Replace by `ingress_acl_entries` and `egress_acl_entries` with the resource alicloud_network_acl.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "NetworkAclEntries"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            name=name,
            cidr_block="172.16.0.0/12")
        default_network_acl = alicloud.vpc.NetworkAcl("default",
            vpc_id=default_network.id,
            name=name)
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/21",
            zone_id=default.zones[0].id,
            name=name)
        default_network_acl_attachment = alicloud.vpc.NetworkAclAttachment("default",
            network_acl_id=default_network_acl.id,
            resources=[{
                "resource_id": default_switch.id,
                "resource_type": "VSwitch",
            }])
        default_network_acl_entries = alicloud.vpc.NetworkAclEntries("default",
            network_acl_id=default_network_acl.id,
            ingresses=[{
                "protocol": "all",
                "port": "-1/-1",
                "source_cidr_ip": "0.0.0.0/32",
                "name": name,
                "entry_type": "custom",
                "policy": "accept",
                "description": name,
            }],
            egresses=[{
                "protocol": "all",
                "port": "-1/-1",
                "destination_cidr_ip": "0.0.0.0/32",
                "name": name,
                "entry_type": "custom",
                "policy": "accept",
                "description": name,
            }])
        ```

        :param str resource_name: The name of the resource.
        :param NetworkAclEntriesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkAclEntriesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 egresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclEntriesEgressArgs', 'NetworkAclEntriesEgressArgsDict']]]]] = None,
                 ingresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclEntriesIngressArgs', 'NetworkAclEntriesIngressArgsDict']]]]] = None,
                 network_acl_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkAclEntriesArgs.__new__(NetworkAclEntriesArgs)

            __props__.__dict__["egresses"] = egresses
            __props__.__dict__["ingresses"] = ingresses
            if network_acl_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_acl_id'")
            __props__.__dict__["network_acl_id"] = network_acl_id
        super(NetworkAclEntries, __self__).__init__(
            'alicloud:vpc/networkAclEntries:NetworkAclEntries',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            egresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclEntriesEgressArgs', 'NetworkAclEntriesEgressArgsDict']]]]] = None,
            ingresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclEntriesIngressArgs', 'NetworkAclEntriesIngressArgsDict']]]]] = None,
            network_acl_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkAclEntries':
        """
        Get an existing NetworkAclEntries resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclEntriesEgressArgs', 'NetworkAclEntriesEgressArgsDict']]]] egresses: List of the egress entries of the network acl. The order of the egress entries determines the priority. See `egress` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclEntriesIngressArgs', 'NetworkAclEntriesIngressArgsDict']]]] ingresses: List of the ingress entries of the network acl. The order of the ingress entries determines the priority. See `ingress` below.
        :param pulumi.Input[_builtins.str] network_acl_id: The id of the network acl, the field can't be changed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkAclEntriesState.__new__(_NetworkAclEntriesState)

        __props__.__dict__["egresses"] = egresses
        __props__.__dict__["ingresses"] = ingresses
        __props__.__dict__["network_acl_id"] = network_acl_id
        return NetworkAclEntries(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def egresses(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkAclEntriesEgress']]]:
        """
        List of the egress entries of the network acl. The order of the egress entries determines the priority. See `egress` below.
        """
        return pulumi.get(self, "egresses")

    @_builtins.property
    @pulumi.getter
    def ingresses(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkAclEntriesIngress']]]:
        """
        List of the ingress entries of the network acl. The order of the ingress entries determines the priority. See `ingress` below.
        """
        return pulumi.get(self, "ingresses")

    @_builtins.property
    @pulumi.getter(name="networkAclId")
    def network_acl_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the network acl, the field can't be changed.
        """
        return pulumi.get(self, "network_acl_id")

