# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PeerConnectionAccepterArgs', 'PeerConnectionAccepter']

@pulumi.input_type
class PeerConnectionAccepterArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_connection_accepter_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PeerConnectionAccepter resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the VPC peering connection whose name or description you want to modify.
        :param pulumi.Input[_builtins.int] bandwidth: The new bandwidth of the VPC peering connection. Unit: Mbit/s. The value must be an integer greater than 0.
        :param pulumi.Input[_builtins.str] description: The new description of the VPC peering connection.
               The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[_builtins.bool] force_delete: Specifies whether to forcefully delete the VPC peering connection. Valid values:
        :param pulumi.Input[_builtins.str] link_type: Link Type
        :param pulumi.Input[_builtins.str] peer_connection_accepter_name: The new name of the VPC peering connection.
               The name must be 1 to 128 characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the new resource group.
               
               > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if link_type is not None:
            pulumi.set(__self__, "link_type", link_type)
        if peer_connection_accepter_name is not None:
            pulumi.set(__self__, "peer_connection_accepter_name", peer_connection_accepter_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VPC peering connection whose name or description you want to modify.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The new bandwidth of the VPC peering connection. Unit: Mbit/s. The value must be an integer greater than 0.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new description of the VPC peering connection.
        The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to forcefully delete the VPC peering connection. Valid values:
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="linkType")
    def link_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Link Type
        """
        return pulumi.get(self, "link_type")

    @link_type.setter
    def link_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link_type", value)

    @_builtins.property
    @pulumi.getter(name="peerConnectionAccepterName")
    def peer_connection_accepter_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new name of the VPC peering connection.
        The name must be 1 to 128 characters in length, and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "peer_connection_accepter_name")

    @peer_connection_accepter_name.setter
    def peer_connection_accepter_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_connection_accepter_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the new resource group.

        > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)


@pulumi.input_type
class _PeerConnectionAccepterState:
    def __init__(__self__, *,
                 accepting_owner_uid: Optional[pulumi.Input[_builtins.int]] = None,
                 accepting_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 accepting_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_connection_accepter_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PeerConnectionAccepter resources.
        :param pulumi.Input[_builtins.int] accepting_owner_uid: The ID of the Alibaba Cloud account (primary account) of the receiving end of the VPC peering connection to be created.-to-peer connection to the VPC account.-account VPC peer-to-peer connection.
        :param pulumi.Input[_builtins.str] accepting_region_id: The region ID of the recipient of the VPC peering connection to be created.-to-peer connection in the same region, enter the same region ID as the region ID of the initiator.-region VPC peer-to-peer connection, enter a region ID that is different from the region ID of the initiator.
        :param pulumi.Input[_builtins.str] accepting_vpc_id: The VPC ID of the receiving end of the VPC peer connection.
        :param pulumi.Input[_builtins.int] bandwidth: The new bandwidth of the VPC peering connection. Unit: Mbit/s. The value must be an integer greater than 0.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the VPC peer connection. Use UTC time in the format' YYYY-MM-DDThh:mm:ssZ '.
        :param pulumi.Input[_builtins.str] description: The new description of the VPC peering connection.
               The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[_builtins.bool] force_delete: Specifies whether to forcefully delete the VPC peering connection. Valid values:
        :param pulumi.Input[_builtins.str] instance_id: The ID of the VPC peering connection whose name or description you want to modify.
        :param pulumi.Input[_builtins.str] link_type: Link Type
        :param pulumi.Input[_builtins.str] peer_connection_accepter_name: The new name of the VPC peering connection.
               The name must be 1 to 128 characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] region_id: The ID of the region where you want to query VPC peering connections.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the new resource group.
               
               > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID of the initiator of the VPC peering connection.
        """
        if accepting_owner_uid is not None:
            pulumi.set(__self__, "accepting_owner_uid", accepting_owner_uid)
        if accepting_region_id is not None:
            pulumi.set(__self__, "accepting_region_id", accepting_region_id)
        if accepting_vpc_id is not None:
            pulumi.set(__self__, "accepting_vpc_id", accepting_vpc_id)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if link_type is not None:
            pulumi.set(__self__, "link_type", link_type)
        if peer_connection_accepter_name is not None:
            pulumi.set(__self__, "peer_connection_accepter_name", peer_connection_accepter_name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="acceptingOwnerUid")
    def accepting_owner_uid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Alibaba Cloud account (primary account) of the receiving end of the VPC peering connection to be created.-to-peer connection to the VPC account.-account VPC peer-to-peer connection.
        """
        return pulumi.get(self, "accepting_owner_uid")

    @accepting_owner_uid.setter
    def accepting_owner_uid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "accepting_owner_uid", value)

    @_builtins.property
    @pulumi.getter(name="acceptingRegionId")
    def accepting_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the recipient of the VPC peering connection to be created.-to-peer connection in the same region, enter the same region ID as the region ID of the initiator.-region VPC peer-to-peer connection, enter a region ID that is different from the region ID of the initiator.
        """
        return pulumi.get(self, "accepting_region_id")

    @accepting_region_id.setter
    def accepting_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accepting_region_id", value)

    @_builtins.property
    @pulumi.getter(name="acceptingVpcId")
    def accepting_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID of the receiving end of the VPC peer connection.
        """
        return pulumi.get(self, "accepting_vpc_id")

    @accepting_vpc_id.setter
    def accepting_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accepting_vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The new bandwidth of the VPC peering connection. Unit: Mbit/s. The value must be an integer greater than 0.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the VPC peer connection. Use UTC time in the format' YYYY-MM-DDThh:mm:ssZ '.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new description of the VPC peering connection.
        The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to forcefully delete the VPC peering connection. Valid values:
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC peering connection whose name or description you want to modify.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="linkType")
    def link_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Link Type
        """
        return pulumi.get(self, "link_type")

    @link_type.setter
    def link_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link_type", value)

    @_builtins.property
    @pulumi.getter(name="peerConnectionAccepterName")
    def peer_connection_accepter_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new name of the VPC peering connection.
        The name must be 1 to 128 characters in length, and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "peer_connection_accepter_name")

    @peer_connection_accepter_name.setter
    def peer_connection_accepter_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_connection_accepter_name", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region where you want to query VPC peering connections.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the new resource group.

        > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID of the initiator of the VPC peering connection.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("alicloud:vpc/peerConnectionAccepter:PeerConnectionAccepter")
class PeerConnectionAccepter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_connection_accepter_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Vpc Peer Peer Connection Accepter resource.

        Vpc peer connection receiver.

        For information about Vpc Peer Peer Connection Accepter and how to use it, see [What is Peer Connection Accepter](https://www.alibabacloud.com/help/en/vpc/developer-reference/api-vpcpeer-2022-01-01-acceptvpcpeerconnection).

        > **NOTE:** Available since v1.196.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        accepting_region = config.get("acceptingRegion")
        if accepting_region is None:
            accepting_region = "cn-beijing"
        another_uid = config.get("anotherUid")
        if another_uid is None:
            another_uid = "xxxx"
        local = alicloud.vpc.Network("local",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        accepting_network = alicloud.vpc.Network("accepting",
            vpc_name=name,
            cidr_block="192.168.0.0/16")
        accepting = alicloud.get_account()
        default = alicloud.vpc.PeerConnection("default",
            peer_connection_name=name,
            vpc_id=local.id,
            accepting_ali_uid=accepting.id,
            accepting_region_id=accepting_region,
            accepting_vpc_id=accepting_network.id,
            description=name)
        default_peer_connection_accepter = alicloud.vpc.PeerConnectionAccepter("default", instance_id=default.id)
        ```

        ## Import

        Vpc Peer Peer Connection Accepter can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/peerConnectionAccepter:PeerConnectionAccepter example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] bandwidth: The new bandwidth of the VPC peering connection. Unit: Mbit/s. The value must be an integer greater than 0.
        :param pulumi.Input[_builtins.str] description: The new description of the VPC peering connection.
               The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[_builtins.bool] force_delete: Specifies whether to forcefully delete the VPC peering connection. Valid values:
        :param pulumi.Input[_builtins.str] instance_id: The ID of the VPC peering connection whose name or description you want to modify.
        :param pulumi.Input[_builtins.str] link_type: Link Type
        :param pulumi.Input[_builtins.str] peer_connection_accepter_name: The new name of the VPC peering connection.
               The name must be 1 to 128 characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the new resource group.
               
               > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PeerConnectionAccepterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vpc Peer Peer Connection Accepter resource.

        Vpc peer connection receiver.

        For information about Vpc Peer Peer Connection Accepter and how to use it, see [What is Peer Connection Accepter](https://www.alibabacloud.com/help/en/vpc/developer-reference/api-vpcpeer-2022-01-01-acceptvpcpeerconnection).

        > **NOTE:** Available since v1.196.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        accepting_region = config.get("acceptingRegion")
        if accepting_region is None:
            accepting_region = "cn-beijing"
        another_uid = config.get("anotherUid")
        if another_uid is None:
            another_uid = "xxxx"
        local = alicloud.vpc.Network("local",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        accepting_network = alicloud.vpc.Network("accepting",
            vpc_name=name,
            cidr_block="192.168.0.0/16")
        accepting = alicloud.get_account()
        default = alicloud.vpc.PeerConnection("default",
            peer_connection_name=name,
            vpc_id=local.id,
            accepting_ali_uid=accepting.id,
            accepting_region_id=accepting_region,
            accepting_vpc_id=accepting_network.id,
            description=name)
        default_peer_connection_accepter = alicloud.vpc.PeerConnectionAccepter("default", instance_id=default.id)
        ```

        ## Import

        Vpc Peer Peer Connection Accepter can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/peerConnectionAccepter:PeerConnectionAccepter example <id>
        ```

        :param str resource_name: The name of the resource.
        :param PeerConnectionAccepterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PeerConnectionAccepterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_connection_accepter_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PeerConnectionAccepterArgs.__new__(PeerConnectionAccepterArgs)

            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["description"] = description
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["force_delete"] = force_delete
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["link_type"] = link_type
            __props__.__dict__["peer_connection_accepter_name"] = peer_connection_accepter_name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["accepting_owner_uid"] = None
            __props__.__dict__["accepting_region_id"] = None
            __props__.__dict__["accepting_vpc_id"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["vpc_id"] = None
        super(PeerConnectionAccepter, __self__).__init__(
            'alicloud:vpc/peerConnectionAccepter:PeerConnectionAccepter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accepting_owner_uid: Optional[pulumi.Input[_builtins.int]] = None,
            accepting_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            accepting_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            link_type: Optional[pulumi.Input[_builtins.str]] = None,
            peer_connection_accepter_name: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'PeerConnectionAccepter':
        """
        Get an existing PeerConnectionAccepter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] accepting_owner_uid: The ID of the Alibaba Cloud account (primary account) of the receiving end of the VPC peering connection to be created.-to-peer connection to the VPC account.-account VPC peer-to-peer connection.
        :param pulumi.Input[_builtins.str] accepting_region_id: The region ID of the recipient of the VPC peering connection to be created.-to-peer connection in the same region, enter the same region ID as the region ID of the initiator.-region VPC peer-to-peer connection, enter a region ID that is different from the region ID of the initiator.
        :param pulumi.Input[_builtins.str] accepting_vpc_id: The VPC ID of the receiving end of the VPC peer connection.
        :param pulumi.Input[_builtins.int] bandwidth: The new bandwidth of the VPC peering connection. Unit: Mbit/s. The value must be an integer greater than 0.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the VPC peer connection. Use UTC time in the format' YYYY-MM-DDThh:mm:ssZ '.
        :param pulumi.Input[_builtins.str] description: The new description of the VPC peering connection.
               The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[_builtins.bool] force_delete: Specifies whether to forcefully delete the VPC peering connection. Valid values:
        :param pulumi.Input[_builtins.str] instance_id: The ID of the VPC peering connection whose name or description you want to modify.
        :param pulumi.Input[_builtins.str] link_type: Link Type
        :param pulumi.Input[_builtins.str] peer_connection_accepter_name: The new name of the VPC peering connection.
               The name must be 1 to 128 characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] region_id: The ID of the region where you want to query VPC peering connections.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the new resource group.
               
               > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID of the initiator of the VPC peering connection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PeerConnectionAccepterState.__new__(_PeerConnectionAccepterState)

        __props__.__dict__["accepting_owner_uid"] = accepting_owner_uid
        __props__.__dict__["accepting_region_id"] = accepting_region_id
        __props__.__dict__["accepting_vpc_id"] = accepting_vpc_id
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["link_type"] = link_type
        __props__.__dict__["peer_connection_accepter_name"] = peer_connection_accepter_name
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_id"] = vpc_id
        return PeerConnectionAccepter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acceptingOwnerUid")
    def accepting_owner_uid(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the Alibaba Cloud account (primary account) of the receiving end of the VPC peering connection to be created.-to-peer connection to the VPC account.-account VPC peer-to-peer connection.
        """
        return pulumi.get(self, "accepting_owner_uid")

    @_builtins.property
    @pulumi.getter(name="acceptingRegionId")
    def accepting_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the recipient of the VPC peering connection to be created.-to-peer connection in the same region, enter the same region ID as the region ID of the initiator.-region VPC peer-to-peer connection, enter a region ID that is different from the region ID of the initiator.
        """
        return pulumi.get(self, "accepting_region_id")

    @_builtins.property
    @pulumi.getter(name="acceptingVpcId")
    def accepting_vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC ID of the receiving end of the VPC peer connection.
        """
        return pulumi.get(self, "accepting_vpc_id")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[_builtins.int]:
        """
        The new bandwidth of the VPC peering connection. Unit: Mbit/s. The value must be an integer greater than 0.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the VPC peer connection. Use UTC time in the format' YYYY-MM-DDThh:mm:ssZ '.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The new description of the VPC peering connection.
        The description must be 1 to 256 characters in length, and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to forcefully delete the VPC peering connection. Valid values:
        """
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC peering connection whose name or description you want to modify.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="linkType")
    def link_type(self) -> pulumi.Output[_builtins.str]:
        """
        Link Type
        """
        return pulumi.get(self, "link_type")

    @_builtins.property
    @pulumi.getter(name="peerConnectionAccepterName")
    def peer_connection_accepter_name(self) -> pulumi.Output[_builtins.str]:
        """
        The new name of the VPC peering connection.
        The name must be 1 to 128 characters in length, and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "peer_connection_accepter_name")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region where you want to query VPC peering connections.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the new resource group.

        > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC ID of the initiator of the VPC peering connection.
        """
        return pulumi.get(self, "vpc_id")

