# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouteEntryArgs', 'RouteEntry']

@pulumi.input_type
class RouteEntryArgs:
    def __init__(__self__, *,
                 route_table_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_cidrblock: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RouteEntry resource.
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the Route Table.
        :param pulumi.Input[_builtins.str] description: The description of the Route Entry. The description must be `1` to `256` characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] destination_cidrblock: The destination CIDR block of the custom route entry.
        :param pulumi.Input[_builtins.str] name: The name of the Route Entry. The name must be `1` to `128` characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] nexthop_id: The ID of Next Hop.
        :param pulumi.Input[_builtins.str] nexthop_type: The type of Next Hop. Valid values:
               - `Instance`: An Elastic Compute Service (ECS) instance.
               - `HaVip`: A high-availability virtual IP address (HAVIP).
               - `RouterInterface`: A router interface.
               - `NetworkInterface`: An elastic network interface (ENI).
               - `VpnGateway`: A VPN Gateway.
               - `IPv6Gateway`: An IPv6 gateway.
               - `NatGateway`: A Nat Gateway.
               - `Attachment`: A transit router.
               - `VpcPeer`: A VPC Peering Connection.
               - `Ipv4Gateway`: An IPv4 gateway.
               - `GatewayEndpoint`: A gateway endpoint.
               - `Ecr`: A Express Connect Router (ECR).
        """
        pulumi.set(__self__, "route_table_id", route_table_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_cidrblock is not None:
            pulumi.set(__self__, "destination_cidrblock", destination_cidrblock)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nexthop_id is not None:
            pulumi.set(__self__, "nexthop_id", nexthop_id)
        if nexthop_type is not None:
            pulumi.set(__self__, "nexthop_type", nexthop_type)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Route Table.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Route Entry. The description must be `1` to `256` characters in length, and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationCidrblock")
    def destination_cidrblock(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination CIDR block of the custom route entry.
        """
        return pulumi.get(self, "destination_cidrblock")

    @destination_cidrblock.setter
    def destination_cidrblock(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_cidrblock", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Route Entry. The name must be `1` to `128` characters in length, and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nexthopId")
    def nexthop_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of Next Hop.
        """
        return pulumi.get(self, "nexthop_id")

    @nexthop_id.setter
    def nexthop_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nexthop_id", value)

    @_builtins.property
    @pulumi.getter(name="nexthopType")
    def nexthop_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of Next Hop. Valid values:
        - `Instance`: An Elastic Compute Service (ECS) instance.
        - `HaVip`: A high-availability virtual IP address (HAVIP).
        - `RouterInterface`: A router interface.
        - `NetworkInterface`: An elastic network interface (ENI).
        - `VpnGateway`: A VPN Gateway.
        - `IPv6Gateway`: An IPv6 gateway.
        - `NatGateway`: A Nat Gateway.
        - `Attachment`: A transit router.
        - `VpcPeer`: A VPC Peering Connection.
        - `Ipv4Gateway`: An IPv4 gateway.
        - `GatewayEndpoint`: A gateway endpoint.
        - `Ecr`: A Express Connect Router (ECR).
        """
        return pulumi.get(self, "nexthop_type")

    @nexthop_type.setter
    def nexthop_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nexthop_type", value)


@pulumi.input_type
class _RouteEntryState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_cidrblock: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop_type: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 router_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RouteEntry resources.
        :param pulumi.Input[_builtins.str] description: The description of the Route Entry. The description must be `1` to `256` characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] destination_cidrblock: The destination CIDR block of the custom route entry.
        :param pulumi.Input[_builtins.str] name: The name of the Route Entry. The name must be `1` to `128` characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] nexthop_id: The ID of Next Hop.
        :param pulumi.Input[_builtins.str] nexthop_type: The type of Next Hop. Valid values:
               - `Instance`: An Elastic Compute Service (ECS) instance.
               - `HaVip`: A high-availability virtual IP address (HAVIP).
               - `RouterInterface`: A router interface.
               - `NetworkInterface`: An elastic network interface (ENI).
               - `VpnGateway`: A VPN Gateway.
               - `IPv6Gateway`: An IPv6 gateway.
               - `NatGateway`: A Nat Gateway.
               - `Attachment`: A transit router.
               - `VpcPeer`: A VPC Peering Connection.
               - `Ipv4Gateway`: An IPv4 gateway.
               - `GatewayEndpoint`: A gateway endpoint.
               - `Ecr`: A Express Connect Router (ECR).
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the Route Table.
        :param pulumi.Input[_builtins.str] router_id: This argument has been deprecated. Please use other arguments to launch a custom route entry.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_cidrblock is not None:
            pulumi.set(__self__, "destination_cidrblock", destination_cidrblock)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nexthop_id is not None:
            pulumi.set(__self__, "nexthop_id", nexthop_id)
        if nexthop_type is not None:
            pulumi.set(__self__, "nexthop_type", nexthop_type)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if router_id is not None:
            warnings.warn("""Attribute router_id has been deprecated and suggest removing it from your template.""", DeprecationWarning)
            pulumi.log.warn("""router_id is deprecated: Attribute router_id has been deprecated and suggest removing it from your template.""")
        if router_id is not None:
            pulumi.set(__self__, "router_id", router_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Route Entry. The description must be `1` to `256` characters in length, and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationCidrblock")
    def destination_cidrblock(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination CIDR block of the custom route entry.
        """
        return pulumi.get(self, "destination_cidrblock")

    @destination_cidrblock.setter
    def destination_cidrblock(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_cidrblock", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Route Entry. The name must be `1` to `128` characters in length, and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nexthopId")
    def nexthop_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of Next Hop.
        """
        return pulumi.get(self, "nexthop_id")

    @nexthop_id.setter
    def nexthop_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nexthop_id", value)

    @_builtins.property
    @pulumi.getter(name="nexthopType")
    def nexthop_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of Next Hop. Valid values:
        - `Instance`: An Elastic Compute Service (ECS) instance.
        - `HaVip`: A high-availability virtual IP address (HAVIP).
        - `RouterInterface`: A router interface.
        - `NetworkInterface`: An elastic network interface (ENI).
        - `VpnGateway`: A VPN Gateway.
        - `IPv6Gateway`: An IPv6 gateway.
        - `NatGateway`: A Nat Gateway.
        - `Attachment`: A transit router.
        - `VpcPeer`: A VPC Peering Connection.
        - `Ipv4Gateway`: An IPv4 gateway.
        - `GatewayEndpoint`: A gateway endpoint.
        - `Ecr`: A Express Connect Router (ECR).
        """
        return pulumi.get(self, "nexthop_type")

    @nexthop_type.setter
    def nexthop_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nexthop_type", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Route Table.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter(name="routerId")
    @_utilities.deprecated("""Attribute router_id has been deprecated and suggest removing it from your template.""")
    def router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This argument has been deprecated. Please use other arguments to launch a custom route entry.
        """
        return pulumi.get(self, "router_id")

    @router_id.setter
    def router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "router_id", value)


@pulumi.type_token("alicloud:vpc/routeEntry:RouteEntry")
class RouteEntry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_cidrblock: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop_type: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Route Entry resource. A Route Entry represents a route item of one VPC Route Table.

        For information about Route Entry and how to use it, see [What is Route Entry](https://www.alibabacloud.com/help/en/vpc/developer-reference/api-vpc-2016-04-28-createrouteentry).

        > **NOTE:** Available since v0.1.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_get_images = alicloud.ecs.get_images(most_recent=True,
            owners="system")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=2,
            memory_size=8,
            instance_type_family="ecs.g6")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="192.168.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            vpc_id=default_network.id,
            cidr_block="192.168.192.0/24",
            zone_id=default.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("default",
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            security_groups=[__item.id for __item in [default_security_group]],
            internet_charge_type="PayByTraffic",
            internet_max_bandwidth_out=10,
            availability_zone=default_get_instance_types.instance_types[0].availability_zones[0],
            instance_charge_type="PostPaid",
            system_disk_category="cloud_efficiency",
            vswitch_id=default_switch.id,
            instance_name=name)
        default_route_entry = alicloud.vpc.RouteEntry("default",
            route_table_id=default_network.route_table_id,
            destination_cidrblock="172.11.1.1/32",
            nexthop_type="Instance",
            nexthop_id=default_instance.id)
        ```

        ## Module Support

        You can use to the existing vpc module
        to create a VPC, several VSwitches and add several route entries one-click.

        ## Import

        Route Entry can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/routeEntry:RouteEntry example <route_table_id>:<router_id>:<destination_cidrblock>:<nexthop_type>:<nexthop_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the Route Entry. The description must be `1` to `256` characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] destination_cidrblock: The destination CIDR block of the custom route entry.
        :param pulumi.Input[_builtins.str] name: The name of the Route Entry. The name must be `1` to `128` characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] nexthop_id: The ID of Next Hop.
        :param pulumi.Input[_builtins.str] nexthop_type: The type of Next Hop. Valid values:
               - `Instance`: An Elastic Compute Service (ECS) instance.
               - `HaVip`: A high-availability virtual IP address (HAVIP).
               - `RouterInterface`: A router interface.
               - `NetworkInterface`: An elastic network interface (ENI).
               - `VpnGateway`: A VPN Gateway.
               - `IPv6Gateway`: An IPv6 gateway.
               - `NatGateway`: A Nat Gateway.
               - `Attachment`: A transit router.
               - `VpcPeer`: A VPC Peering Connection.
               - `Ipv4Gateway`: An IPv4 gateway.
               - `GatewayEndpoint`: A gateway endpoint.
               - `Ecr`: A Express Connect Router (ECR).
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the Route Table.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteEntryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Route Entry resource. A Route Entry represents a route item of one VPC Route Table.

        For information about Route Entry and how to use it, see [What is Route Entry](https://www.alibabacloud.com/help/en/vpc/developer-reference/api-vpc-2016-04-28-createrouteentry).

        > **NOTE:** Available since v0.1.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_get_images = alicloud.ecs.get_images(most_recent=True,
            owners="system")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=2,
            memory_size=8,
            instance_type_family="ecs.g6")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="192.168.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            vpc_id=default_network.id,
            cidr_block="192.168.192.0/24",
            zone_id=default.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("default",
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            security_groups=[__item.id for __item in [default_security_group]],
            internet_charge_type="PayByTraffic",
            internet_max_bandwidth_out=10,
            availability_zone=default_get_instance_types.instance_types[0].availability_zones[0],
            instance_charge_type="PostPaid",
            system_disk_category="cloud_efficiency",
            vswitch_id=default_switch.id,
            instance_name=name)
        default_route_entry = alicloud.vpc.RouteEntry("default",
            route_table_id=default_network.route_table_id,
            destination_cidrblock="172.11.1.1/32",
            nexthop_type="Instance",
            nexthop_id=default_instance.id)
        ```

        ## Module Support

        You can use to the existing vpc module
        to create a VPC, several VSwitches and add several route entries one-click.

        ## Import

        Route Entry can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/routeEntry:RouteEntry example <route_table_id>:<router_id>:<destination_cidrblock>:<nexthop_type>:<nexthop_id>
        ```

        :param str resource_name: The name of the resource.
        :param RouteEntryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteEntryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_cidrblock: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop_type: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteEntryArgs.__new__(RouteEntryArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["destination_cidrblock"] = destination_cidrblock
            __props__.__dict__["name"] = name
            __props__.__dict__["nexthop_id"] = nexthop_id
            __props__.__dict__["nexthop_type"] = nexthop_type
            if route_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_table_id'")
            __props__.__dict__["route_table_id"] = route_table_id
            __props__.__dict__["router_id"] = None
        super(RouteEntry, __self__).__init__(
            'alicloud:vpc/routeEntry:RouteEntry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_cidrblock: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nexthop_id: Optional[pulumi.Input[_builtins.str]] = None,
            nexthop_type: Optional[pulumi.Input[_builtins.str]] = None,
            route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
            router_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RouteEntry':
        """
        Get an existing RouteEntry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the Route Entry. The description must be `1` to `256` characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] destination_cidrblock: The destination CIDR block of the custom route entry.
        :param pulumi.Input[_builtins.str] name: The name of the Route Entry. The name must be `1` to `128` characters in length, and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] nexthop_id: The ID of Next Hop.
        :param pulumi.Input[_builtins.str] nexthop_type: The type of Next Hop. Valid values:
               - `Instance`: An Elastic Compute Service (ECS) instance.
               - `HaVip`: A high-availability virtual IP address (HAVIP).
               - `RouterInterface`: A router interface.
               - `NetworkInterface`: An elastic network interface (ENI).
               - `VpnGateway`: A VPN Gateway.
               - `IPv6Gateway`: An IPv6 gateway.
               - `NatGateway`: A Nat Gateway.
               - `Attachment`: A transit router.
               - `VpcPeer`: A VPC Peering Connection.
               - `Ipv4Gateway`: An IPv4 gateway.
               - `GatewayEndpoint`: A gateway endpoint.
               - `Ecr`: A Express Connect Router (ECR).
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the Route Table.
        :param pulumi.Input[_builtins.str] router_id: This argument has been deprecated. Please use other arguments to launch a custom route entry.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteEntryState.__new__(_RouteEntryState)

        __props__.__dict__["description"] = description
        __props__.__dict__["destination_cidrblock"] = destination_cidrblock
        __props__.__dict__["name"] = name
        __props__.__dict__["nexthop_id"] = nexthop_id
        __props__.__dict__["nexthop_type"] = nexthop_type
        __props__.__dict__["route_table_id"] = route_table_id
        __props__.__dict__["router_id"] = router_id
        return RouteEntry(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Route Entry. The description must be `1` to `256` characters in length, and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationCidrblock")
    def destination_cidrblock(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The destination CIDR block of the custom route entry.
        """
        return pulumi.get(self, "destination_cidrblock")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Route Entry. The name must be `1` to `128` characters in length, and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nexthopId")
    def nexthop_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of Next Hop.
        """
        return pulumi.get(self, "nexthop_id")

    @_builtins.property
    @pulumi.getter(name="nexthopType")
    def nexthop_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of Next Hop. Valid values:
        - `Instance`: An Elastic Compute Service (ECS) instance.
        - `HaVip`: A high-availability virtual IP address (HAVIP).
        - `RouterInterface`: A router interface.
        - `NetworkInterface`: An elastic network interface (ENI).
        - `VpnGateway`: A VPN Gateway.
        - `IPv6Gateway`: An IPv6 gateway.
        - `NatGateway`: A Nat Gateway.
        - `Attachment`: A transit router.
        - `VpcPeer`: A VPC Peering Connection.
        - `Ipv4Gateway`: An IPv4 gateway.
        - `GatewayEndpoint`: A gateway endpoint.
        - `Ecr`: A Express Connect Router (ECR).
        """
        return pulumi.get(self, "nexthop_type")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Route Table.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter(name="routerId")
    @_utilities.deprecated("""Attribute router_id has been deprecated and suggest removing it from your template.""")
    def router_id(self) -> pulumi.Output[_builtins.str]:
        """
        This argument has been deprecated. Please use other arguments to launch a custom route entry.
        """
        return pulumi.get(self, "router_id")

