# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetGatewaysResult',
    'AwaitableGetGatewaysResult',
    'get_gateways',
    'get_gateways_output',
]

@pulumi.output_type
class GetGatewaysResult:
    """
    A collection of values returned by getGateways.
    """
    def __init__(__self__, business_status=None, enable_ipsec=None, gateways=None, id=None, ids=None, include_reservation_data=None, name_regex=None, names=None, output_file=None, ssl_vpn=None, status=None, vpc_id=None):
        if business_status and not isinstance(business_status, str):
            raise TypeError("Expected argument 'business_status' to be a str")
        pulumi.set(__self__, "business_status", business_status)
        if enable_ipsec and not isinstance(enable_ipsec, bool):
            raise TypeError("Expected argument 'enable_ipsec' to be a bool")
        pulumi.set(__self__, "enable_ipsec", enable_ipsec)
        if gateways and not isinstance(gateways, list):
            raise TypeError("Expected argument 'gateways' to be a list")
        pulumi.set(__self__, "gateways", gateways)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if include_reservation_data and not isinstance(include_reservation_data, bool):
            raise TypeError("Expected argument 'include_reservation_data' to be a bool")
        pulumi.set(__self__, "include_reservation_data", include_reservation_data)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if ssl_vpn and not isinstance(ssl_vpn, str):
            raise TypeError("Expected argument 'ssl_vpn' to be a str")
        pulumi.set(__self__, "ssl_vpn", ssl_vpn)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> Optional[_builtins.str]:
        """
        The business status of the VPN gateway.
        """
        return pulumi.get(self, "business_status")

    @_builtins.property
    @pulumi.getter(name="enableIpsec")
    @_utilities.deprecated("""Field 'enable_ipsec' has been deprecated from provider version 1.193.0 and it will be removed in the future version.""")
    def enable_ipsec(self) -> Optional[_builtins.bool]:
        """
        Whether the ipsec function is enabled.
        """
        return pulumi.get(self, "enable_ipsec")

    @_builtins.property
    @pulumi.getter
    def gateways(self) -> Sequence['outputs.GetGatewaysGatewayResult']:
        """
        A list of VPN gateways. Each element contains the following attributes:
        """
        return pulumi.get(self, "gateways")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        IDs of the VPN.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="includeReservationData")
    def include_reservation_data(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "include_reservation_data")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        names of the VPN.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="sslVpn")
    def ssl_vpn(self) -> Optional[_builtins.str]:
        """
        Whether the ssl function is enabled.
        """
        return pulumi.get(self, "ssl_vpn")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the VPN
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        ID of the VPC that the VPN belongs.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetGatewaysResult(GetGatewaysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGatewaysResult(
            business_status=self.business_status,
            enable_ipsec=self.enable_ipsec,
            gateways=self.gateways,
            id=self.id,
            ids=self.ids,
            include_reservation_data=self.include_reservation_data,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            ssl_vpn=self.ssl_vpn,
            status=self.status,
            vpc_id=self.vpc_id)


def get_gateways(business_status: Optional[_builtins.str] = None,
                 enable_ipsec: Optional[_builtins.bool] = None,
                 ids: Optional[Sequence[_builtins.str]] = None,
                 include_reservation_data: Optional[_builtins.bool] = None,
                 name_regex: Optional[_builtins.str] = None,
                 output_file: Optional[_builtins.str] = None,
                 ssl_vpn: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 vpc_id: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGatewaysResult:
    """
    The VPNs data source lists a number of VPNs resource information owned by an Alicloud account.

    > **NOTE:** Available since v1.18.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_std as std

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    spec = config.get("spec")
    if spec is None:
        spec = "20"
    default = alicloud.get_zones(available_resource_creation="VSwitch")
    default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
    default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
        zone_id="me-east-1a")
    vswitch = []
    def create_vswitch(range_body):
        for range in [{"value": i} for i in range(0, range_body)]:
            vswitch.append(alicloud.vpc.Switch(f"vswitch-{range['value']}",
                vpc_id=default_get_networks.ids[0],
                cidr_block=std.cidrsubnet(input=default_get_networks.vpcs[0].cidr_block,
                    newbits=8,
                    netnum=8).result,
                zone_id="me-east-1a",
                vswitch_name=name))

    len(default_get_switches.ids).apply(lambda resolved_outputs: create_vswitch(0 if resolved_outputs['length'] > 0 else 1))
    vswitch_id = len(default_get_switches.ids).apply(lambda length: default_get_switches.ids[0] if length > 0 else std.concat(input=[
        [__item.id for __item in vswitch],
        [""],
    ]).result[0])
    default_gateway = alicloud.vpn.Gateway("default",
        vpn_type="Normal",
        vpn_gateway_name=name,
        vswitch_id=vswitch_id,
        auto_pay=True,
        vpc_id=default_get_networks.ids[0],
        network_type="public",
        payment_type="Subscription",
        enable_ipsec=True,
        bandwidth=spec)
    vpn_gateways = alicloud.vpn.get_gateways_output(ids=[default_gateway.id],
        include_reservation_data=True,
        output_file="/tmp/vpns")
    ```


    :param _builtins.str business_status: Limit search to specific business status - valid value is "Normal", "FinancialLocked".
    :param _builtins.bool enable_ipsec: Indicates whether the IPsec-VPN feature is enabled.
    :param Sequence[_builtins.str] ids: IDs of the VPN.
    :param _builtins.bool include_reservation_data: Include ineffective ordering data.
    :param _builtins.str name_regex: A regex string of VPN name.
    :param _builtins.str output_file: Save the result to the file.
    :param _builtins.str ssl_vpn: Indicates whether the SSL-VPN feature is enabled. Valid value is `enable`, `disable`.
    :param _builtins.str status: Limit search to specific status - valid value is "Init", "Provisioning", "Active", "Updating", "Deleting".
    :param _builtins.str vpc_id: Use the VPC ID as the search key.
    """
    __args__ = dict()
    __args__['businessStatus'] = business_status
    __args__['enableIpsec'] = enable_ipsec
    __args__['ids'] = ids
    __args__['includeReservationData'] = include_reservation_data
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['sslVpn'] = ssl_vpn
    __args__['status'] = status
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpn/getGateways:getGateways', __args__, opts=opts, typ=GetGatewaysResult).value

    return AwaitableGetGatewaysResult(
        business_status=pulumi.get(__ret__, 'business_status'),
        enable_ipsec=pulumi.get(__ret__, 'enable_ipsec'),
        gateways=pulumi.get(__ret__, 'gateways'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        include_reservation_data=pulumi.get(__ret__, 'include_reservation_data'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        ssl_vpn=pulumi.get(__ret__, 'ssl_vpn'),
        status=pulumi.get(__ret__, 'status'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_gateways_output(business_status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        enable_ipsec: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                        ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                        include_reservation_data: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                        name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        ssl_vpn: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGatewaysResult]:
    """
    The VPNs data source lists a number of VPNs resource information owned by an Alicloud account.

    > **NOTE:** Available since v1.18.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_std as std

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    spec = config.get("spec")
    if spec is None:
        spec = "20"
    default = alicloud.get_zones(available_resource_creation="VSwitch")
    default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
    default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
        zone_id="me-east-1a")
    vswitch = []
    def create_vswitch(range_body):
        for range in [{"value": i} for i in range(0, range_body)]:
            vswitch.append(alicloud.vpc.Switch(f"vswitch-{range['value']}",
                vpc_id=default_get_networks.ids[0],
                cidr_block=std.cidrsubnet(input=default_get_networks.vpcs[0].cidr_block,
                    newbits=8,
                    netnum=8).result,
                zone_id="me-east-1a",
                vswitch_name=name))

    len(default_get_switches.ids).apply(lambda resolved_outputs: create_vswitch(0 if resolved_outputs['length'] > 0 else 1))
    vswitch_id = len(default_get_switches.ids).apply(lambda length: default_get_switches.ids[0] if length > 0 else std.concat(input=[
        [__item.id for __item in vswitch],
        [""],
    ]).result[0])
    default_gateway = alicloud.vpn.Gateway("default",
        vpn_type="Normal",
        vpn_gateway_name=name,
        vswitch_id=vswitch_id,
        auto_pay=True,
        vpc_id=default_get_networks.ids[0],
        network_type="public",
        payment_type="Subscription",
        enable_ipsec=True,
        bandwidth=spec)
    vpn_gateways = alicloud.vpn.get_gateways_output(ids=[default_gateway.id],
        include_reservation_data=True,
        output_file="/tmp/vpns")
    ```


    :param _builtins.str business_status: Limit search to specific business status - valid value is "Normal", "FinancialLocked".
    :param _builtins.bool enable_ipsec: Indicates whether the IPsec-VPN feature is enabled.
    :param Sequence[_builtins.str] ids: IDs of the VPN.
    :param _builtins.bool include_reservation_data: Include ineffective ordering data.
    :param _builtins.str name_regex: A regex string of VPN name.
    :param _builtins.str output_file: Save the result to the file.
    :param _builtins.str ssl_vpn: Indicates whether the SSL-VPN feature is enabled. Valid value is `enable`, `disable`.
    :param _builtins.str status: Limit search to specific status - valid value is "Init", "Provisioning", "Active", "Updating", "Deleting".
    :param _builtins.str vpc_id: Use the VPC ID as the search key.
    """
    __args__ = dict()
    __args__['businessStatus'] = business_status
    __args__['enableIpsec'] = enable_ipsec
    __args__['ids'] = ids
    __args__['includeReservationData'] = include_reservation_data
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['sslVpn'] = ssl_vpn
    __args__['status'] = status
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:vpn/getGateways:getGateways', __args__, opts=opts, typ=GetGatewaysResult)
    return __ret__.apply(lambda __response__: GetGatewaysResult(
        business_status=pulumi.get(__response__, 'business_status'),
        enable_ipsec=pulumi.get(__response__, 'enable_ipsec'),
        gateways=pulumi.get(__response__, 'gateways'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        include_reservation_data=pulumi.get(__response__, 'include_reservation_data'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        ssl_vpn=pulumi.get(__response__, 'ssl_vpn'),
        status=pulumi.get(__response__, 'status'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
