# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainArgs', 'Domain']

@pulumi.input_type
class DomainArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 is_access_product: pulumi.Input[_builtins.str],
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_time: Optional[pulumi.Input[_builtins.int]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 http2_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 http_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 http_to_user_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 https_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 https_redirect: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing: Optional[pulumi.Input[_builtins.str]] = None,
                 log_headers: Optional[pulumi.Input[Sequence[pulumi.Input['DomainLogHeaderArgs']]]] = None,
                 read_time: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 write_time: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Domain resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the WAF instance.
        :param pulumi.Input[_builtins.str] is_access_product: Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: `On` and `Off`. Default to `Off`.
        :param pulumi.Input[_builtins.str] cluster_type: The type of the WAF cluster. Valid values: `PhysicalCluster` and `VirtualCluster`. Default to `PhysicalCluster`.
        :param pulumi.Input[_builtins.int] connection_time: The connection timeout for WAF exclusive clusters. Unit: seconds.
        :param pulumi.Input[_builtins.str] domain: Field `domain` has been deprecated from version 1.94.0. Use `domain_name` instead.
        :param pulumi.Input[_builtins.str] domain_name: The domain that you want to add to WAF. The `domain_name` is required when the value of the `domain`  is Empty.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] http2_ports: List of the HTTP 2.0 ports.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] http_ports: List of the HTTP ports.
        :param pulumi.Input[_builtins.str] http_to_user_ip: Specifies whether to enable the HTTP back-to-origin feature. After this feature is enabled, the WAF instance can use HTTP to forward HTTPS requests to the origin server. 
               By default, port 80 is used to forward the requests to the origin server. Valid values: `On` and `Off`. Default to `Off`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] https_ports: List of the HTTPS ports.
        :param pulumi.Input[_builtins.str] https_redirect: Specifies whether to redirect HTTP requests as HTTPS requests. Valid values: "On" and `Off`. Default to `Off`.
        :param pulumi.Input[_builtins.str] load_balancing: The load balancing algorithm that is used to forward requests to the origin. Valid values: `IpHash` and `RoundRobin`. Default to `IpHash`.
        :param pulumi.Input[Sequence[pulumi.Input['DomainLogHeaderArgs']]] log_headers: The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
               * key: The key of label
               * value: The value of label
        :param pulumi.Input[_builtins.int] read_time: The read timeout of a WAF exclusive cluster. Unit: seconds.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the queried domain belongs in Resource Management. By default, no value is specified, indicating that the domain belongs to the default resource group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_ips: List of the IP address or domain of the origin server to which the specified domain points.
        :param pulumi.Input[_builtins.int] write_time: The timeout period for a WAF exclusive cluster write connection. Unit: seconds.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "is_access_product", is_access_product)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if connection_time is not None:
            pulumi.set(__self__, "connection_time", connection_time)
        if domain is not None:
            warnings.warn("""Field 'domain' has been deprecated from version 1.94.0. Use 'domain_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""domain is deprecated: Field 'domain' has been deprecated from version 1.94.0. Use 'domain_name' instead.""")
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if http2_ports is not None:
            pulumi.set(__self__, "http2_ports", http2_ports)
        if http_ports is not None:
            pulumi.set(__self__, "http_ports", http_ports)
        if http_to_user_ip is not None:
            pulumi.set(__self__, "http_to_user_ip", http_to_user_ip)
        if https_ports is not None:
            pulumi.set(__self__, "https_ports", https_ports)
        if https_redirect is not None:
            pulumi.set(__self__, "https_redirect", https_redirect)
        if load_balancing is not None:
            pulumi.set(__self__, "load_balancing", load_balancing)
        if log_headers is not None:
            pulumi.set(__self__, "log_headers", log_headers)
        if read_time is not None:
            pulumi.set(__self__, "read_time", read_time)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if source_ips is not None:
            pulumi.set(__self__, "source_ips", source_ips)
        if write_time is not None:
            pulumi.set(__self__, "write_time", write_time)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the WAF instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="isAccessProduct")
    def is_access_product(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: `On` and `Off`. Default to `Off`.
        """
        return pulumi.get(self, "is_access_product")

    @is_access_product.setter
    def is_access_product(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "is_access_product", value)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the WAF cluster. Valid values: `PhysicalCluster` and `VirtualCluster`. Default to `PhysicalCluster`.
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter(name="connectionTime")
    def connection_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The connection timeout for WAF exclusive clusters. Unit: seconds.
        """
        return pulumi.get(self, "connection_time")

    @connection_time.setter
    def connection_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_time", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'domain' has been deprecated from version 1.94.0. Use 'domain_name' instead.""")
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `domain` has been deprecated from version 1.94.0. Use `domain_name` instead.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain that you want to add to WAF. The `domain_name` is required when the value of the `domain`  is Empty.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="http2Ports")
    def http2_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of the HTTP 2.0 ports.
        """
        return pulumi.get(self, "http2_ports")

    @http2_ports.setter
    def http2_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "http2_ports", value)

    @_builtins.property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of the HTTP ports.
        """
        return pulumi.get(self, "http_ports")

    @http_ports.setter
    def http_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "http_ports", value)

    @_builtins.property
    @pulumi.getter(name="httpToUserIp")
    def http_to_user_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable the HTTP back-to-origin feature. After this feature is enabled, the WAF instance can use HTTP to forward HTTPS requests to the origin server. 
        By default, port 80 is used to forward the requests to the origin server. Valid values: `On` and `Off`. Default to `Off`.
        """
        return pulumi.get(self, "http_to_user_ip")

    @http_to_user_ip.setter
    def http_to_user_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_to_user_ip", value)

    @_builtins.property
    @pulumi.getter(name="httpsPorts")
    def https_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of the HTTPS ports.
        """
        return pulumi.get(self, "https_ports")

    @https_ports.setter
    def https_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "https_ports", value)

    @_builtins.property
    @pulumi.getter(name="httpsRedirect")
    def https_redirect(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to redirect HTTP requests as HTTPS requests. Valid values: "On" and `Off`. Default to `Off`.
        """
        return pulumi.get(self, "https_redirect")

    @https_redirect.setter
    def https_redirect(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https_redirect", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancing")
    def load_balancing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The load balancing algorithm that is used to forward requests to the origin. Valid values: `IpHash` and `RoundRobin`. Default to `IpHash`.
        """
        return pulumi.get(self, "load_balancing")

    @load_balancing.setter
    def load_balancing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancing", value)

    @_builtins.property
    @pulumi.getter(name="logHeaders")
    def log_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainLogHeaderArgs']]]]:
        """
        The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
        * key: The key of label
        * value: The value of label
        """
        return pulumi.get(self, "log_headers")

    @log_headers.setter
    def log_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainLogHeaderArgs']]]]):
        pulumi.set(self, "log_headers", value)

    @_builtins.property
    @pulumi.getter(name="readTime")
    def read_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The read timeout of a WAF exclusive cluster. Unit: seconds.
        """
        return pulumi.get(self, "read_time")

    @read_time.setter
    def read_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_time", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the queried domain belongs in Resource Management. By default, no value is specified, indicating that the domain belongs to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceIps")
    def source_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of the IP address or domain of the origin server to which the specified domain points.
        """
        return pulumi.get(self, "source_ips")

    @source_ips.setter
    def source_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_ips", value)

    @_builtins.property
    @pulumi.getter(name="writeTime")
    def write_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout period for a WAF exclusive cluster write connection. Unit: seconds.
        """
        return pulumi.get(self, "write_time")

    @write_time.setter
    def write_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "write_time", value)


@pulumi.input_type
class _DomainState:
    def __init__(__self__, *,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cname: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_time: Optional[pulumi.Input[_builtins.int]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 http2_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 http_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 http_to_user_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 https_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 https_redirect: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_access_product: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing: Optional[pulumi.Input[_builtins.str]] = None,
                 log_headers: Optional[pulumi.Input[Sequence[pulumi.Input['DomainLogHeaderArgs']]]] = None,
                 read_time: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 write_time: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Domain resources.
        :param pulumi.Input[_builtins.str] cluster_type: The type of the WAF cluster. Valid values: `PhysicalCluster` and `VirtualCluster`. Default to `PhysicalCluster`.
        :param pulumi.Input[_builtins.str] cname: The CNAME record assigned by the WAF instance to the specified domain.
        :param pulumi.Input[_builtins.int] connection_time: The connection timeout for WAF exclusive clusters. Unit: seconds.
        :param pulumi.Input[_builtins.str] domain: Field `domain` has been deprecated from version 1.94.0. Use `domain_name` instead.
        :param pulumi.Input[_builtins.str] domain_name: The domain that you want to add to WAF. The `domain_name` is required when the value of the `domain`  is Empty.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] http2_ports: List of the HTTP 2.0 ports.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] http_ports: List of the HTTP ports.
        :param pulumi.Input[_builtins.str] http_to_user_ip: Specifies whether to enable the HTTP back-to-origin feature. After this feature is enabled, the WAF instance can use HTTP to forward HTTPS requests to the origin server. 
               By default, port 80 is used to forward the requests to the origin server. Valid values: `On` and `Off`. Default to `Off`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] https_ports: List of the HTTPS ports.
        :param pulumi.Input[_builtins.str] https_redirect: Specifies whether to redirect HTTP requests as HTTPS requests. Valid values: "On" and `Off`. Default to `Off`.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the WAF instance.
        :param pulumi.Input[_builtins.str] is_access_product: Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: `On` and `Off`. Default to `Off`.
        :param pulumi.Input[_builtins.str] load_balancing: The load balancing algorithm that is used to forward requests to the origin. Valid values: `IpHash` and `RoundRobin`. Default to `IpHash`.
        :param pulumi.Input[Sequence[pulumi.Input['DomainLogHeaderArgs']]] log_headers: The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
               * key: The key of label
               * value: The value of label
        :param pulumi.Input[_builtins.int] read_time: The read timeout of a WAF exclusive cluster. Unit: seconds.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the queried domain belongs in Resource Management. By default, no value is specified, indicating that the domain belongs to the default resource group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_ips: List of the IP address or domain of the origin server to which the specified domain points.
        :param pulumi.Input[_builtins.int] write_time: The timeout period for a WAF exclusive cluster write connection. Unit: seconds.
        """
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if connection_time is not None:
            pulumi.set(__self__, "connection_time", connection_time)
        if domain is not None:
            warnings.warn("""Field 'domain' has been deprecated from version 1.94.0. Use 'domain_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""domain is deprecated: Field 'domain' has been deprecated from version 1.94.0. Use 'domain_name' instead.""")
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if http2_ports is not None:
            pulumi.set(__self__, "http2_ports", http2_ports)
        if http_ports is not None:
            pulumi.set(__self__, "http_ports", http_ports)
        if http_to_user_ip is not None:
            pulumi.set(__self__, "http_to_user_ip", http_to_user_ip)
        if https_ports is not None:
            pulumi.set(__self__, "https_ports", https_ports)
        if https_redirect is not None:
            pulumi.set(__self__, "https_redirect", https_redirect)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if is_access_product is not None:
            pulumi.set(__self__, "is_access_product", is_access_product)
        if load_balancing is not None:
            pulumi.set(__self__, "load_balancing", load_balancing)
        if log_headers is not None:
            pulumi.set(__self__, "log_headers", log_headers)
        if read_time is not None:
            pulumi.set(__self__, "read_time", read_time)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if source_ips is not None:
            pulumi.set(__self__, "source_ips", source_ips)
        if write_time is not None:
            pulumi.set(__self__, "write_time", write_time)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the WAF cluster. Valid values: `PhysicalCluster` and `VirtualCluster`. Default to `PhysicalCluster`.
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter
    def cname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CNAME record assigned by the WAF instance to the specified domain.
        """
        return pulumi.get(self, "cname")

    @cname.setter
    def cname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cname", value)

    @_builtins.property
    @pulumi.getter(name="connectionTime")
    def connection_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The connection timeout for WAF exclusive clusters. Unit: seconds.
        """
        return pulumi.get(self, "connection_time")

    @connection_time.setter
    def connection_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_time", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'domain' has been deprecated from version 1.94.0. Use 'domain_name' instead.""")
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `domain` has been deprecated from version 1.94.0. Use `domain_name` instead.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain that you want to add to WAF. The `domain_name` is required when the value of the `domain`  is Empty.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="http2Ports")
    def http2_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of the HTTP 2.0 ports.
        """
        return pulumi.get(self, "http2_ports")

    @http2_ports.setter
    def http2_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "http2_ports", value)

    @_builtins.property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of the HTTP ports.
        """
        return pulumi.get(self, "http_ports")

    @http_ports.setter
    def http_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "http_ports", value)

    @_builtins.property
    @pulumi.getter(name="httpToUserIp")
    def http_to_user_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable the HTTP back-to-origin feature. After this feature is enabled, the WAF instance can use HTTP to forward HTTPS requests to the origin server. 
        By default, port 80 is used to forward the requests to the origin server. Valid values: `On` and `Off`. Default to `Off`.
        """
        return pulumi.get(self, "http_to_user_ip")

    @http_to_user_ip.setter
    def http_to_user_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_to_user_ip", value)

    @_builtins.property
    @pulumi.getter(name="httpsPorts")
    def https_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of the HTTPS ports.
        """
        return pulumi.get(self, "https_ports")

    @https_ports.setter
    def https_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "https_ports", value)

    @_builtins.property
    @pulumi.getter(name="httpsRedirect")
    def https_redirect(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to redirect HTTP requests as HTTPS requests. Valid values: "On" and `Off`. Default to `Off`.
        """
        return pulumi.get(self, "https_redirect")

    @https_redirect.setter
    def https_redirect(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https_redirect", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the WAF instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="isAccessProduct")
    def is_access_product(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: `On` and `Off`. Default to `Off`.
        """
        return pulumi.get(self, "is_access_product")

    @is_access_product.setter
    def is_access_product(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_access_product", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancing")
    def load_balancing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The load balancing algorithm that is used to forward requests to the origin. Valid values: `IpHash` and `RoundRobin`. Default to `IpHash`.
        """
        return pulumi.get(self, "load_balancing")

    @load_balancing.setter
    def load_balancing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancing", value)

    @_builtins.property
    @pulumi.getter(name="logHeaders")
    def log_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainLogHeaderArgs']]]]:
        """
        The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
        * key: The key of label
        * value: The value of label
        """
        return pulumi.get(self, "log_headers")

    @log_headers.setter
    def log_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainLogHeaderArgs']]]]):
        pulumi.set(self, "log_headers", value)

    @_builtins.property
    @pulumi.getter(name="readTime")
    def read_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The read timeout of a WAF exclusive cluster. Unit: seconds.
        """
        return pulumi.get(self, "read_time")

    @read_time.setter
    def read_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_time", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the queried domain belongs in Resource Management. By default, no value is specified, indicating that the domain belongs to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceIps")
    def source_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of the IP address or domain of the origin server to which the specified domain points.
        """
        return pulumi.get(self, "source_ips")

    @source_ips.setter
    def source_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_ips", value)

    @_builtins.property
    @pulumi.getter(name="writeTime")
    def write_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout period for a WAF exclusive cluster write connection. Unit: seconds.
        """
        return pulumi.get(self, "write_time")

    @write_time.setter
    def write_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "write_time", value)


@pulumi.type_token("alicloud:waf/domain:Domain")
class Domain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_time: Optional[pulumi.Input[_builtins.int]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 http2_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 http_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 http_to_user_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 https_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 https_redirect: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_access_product: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing: Optional[pulumi.Input[_builtins.str]] = None,
                 log_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainLogHeaderArgs', 'DomainLogHeaderArgsDict']]]]] = None,
                 read_time: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 write_time: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        > **DEPRECATED:**  This resource has been deprecated and using wafv3.Domain instead.

        Provides a WAF Domain resource to create domain in the Web Application Firewall.

        For information about WAF and how to use it, see [What is Alibaba Cloud WAF](https://www.alibabacloud.com/help/doc-detail/28517.htm).

        > **NOTE:** Available since v1.82.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        domain = alicloud.waf.Domain("domain",
            domain_name="alicloud-provider.cn",
            instance_id="waf-123455",
            is_access_product="On",
            source_ips=["1.1.1.1"],
            cluster_type="PhysicalCluster",
            http2_ports=["443"],
            http_ports=["80"],
            https_ports=["443"],
            http_to_user_ip="Off",
            https_redirect="Off",
            load_balancing="IpHash",
            log_headers=[{
                "key": "foo",
                "value": "http",
            }])
        ```

        ## Import

        WAF domain can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:waf/domain:Domain domain waf-132435:www.domain.com
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_type: The type of the WAF cluster. Valid values: `PhysicalCluster` and `VirtualCluster`. Default to `PhysicalCluster`.
        :param pulumi.Input[_builtins.int] connection_time: The connection timeout for WAF exclusive clusters. Unit: seconds.
        :param pulumi.Input[_builtins.str] domain: Field `domain` has been deprecated from version 1.94.0. Use `domain_name` instead.
        :param pulumi.Input[_builtins.str] domain_name: The domain that you want to add to WAF. The `domain_name` is required when the value of the `domain`  is Empty.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] http2_ports: List of the HTTP 2.0 ports.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] http_ports: List of the HTTP ports.
        :param pulumi.Input[_builtins.str] http_to_user_ip: Specifies whether to enable the HTTP back-to-origin feature. After this feature is enabled, the WAF instance can use HTTP to forward HTTPS requests to the origin server. 
               By default, port 80 is used to forward the requests to the origin server. Valid values: `On` and `Off`. Default to `Off`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] https_ports: List of the HTTPS ports.
        :param pulumi.Input[_builtins.str] https_redirect: Specifies whether to redirect HTTP requests as HTTPS requests. Valid values: "On" and `Off`. Default to `Off`.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the WAF instance.
        :param pulumi.Input[_builtins.str] is_access_product: Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: `On` and `Off`. Default to `Off`.
        :param pulumi.Input[_builtins.str] load_balancing: The load balancing algorithm that is used to forward requests to the origin. Valid values: `IpHash` and `RoundRobin`. Default to `IpHash`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainLogHeaderArgs', 'DomainLogHeaderArgsDict']]]] log_headers: The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
               * key: The key of label
               * value: The value of label
        :param pulumi.Input[_builtins.int] read_time: The read timeout of a WAF exclusive cluster. Unit: seconds.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the queried domain belongs in Resource Management. By default, no value is specified, indicating that the domain belongs to the default resource group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_ips: List of the IP address or domain of the origin server to which the specified domain points.
        :param pulumi.Input[_builtins.int] write_time: The timeout period for a WAF exclusive cluster write connection. Unit: seconds.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **DEPRECATED:**  This resource has been deprecated and using wafv3.Domain instead.

        Provides a WAF Domain resource to create domain in the Web Application Firewall.

        For information about WAF and how to use it, see [What is Alibaba Cloud WAF](https://www.alibabacloud.com/help/doc-detail/28517.htm).

        > **NOTE:** Available since v1.82.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        domain = alicloud.waf.Domain("domain",
            domain_name="alicloud-provider.cn",
            instance_id="waf-123455",
            is_access_product="On",
            source_ips=["1.1.1.1"],
            cluster_type="PhysicalCluster",
            http2_ports=["443"],
            http_ports=["80"],
            https_ports=["443"],
            http_to_user_ip="Off",
            https_redirect="Off",
            load_balancing="IpHash",
            log_headers=[{
                "key": "foo",
                "value": "http",
            }])
        ```

        ## Import

        WAF domain can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:waf/domain:Domain domain waf-132435:www.domain.com
        ```

        :param str resource_name: The name of the resource.
        :param DomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_time: Optional[pulumi.Input[_builtins.int]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 http2_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 http_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 http_to_user_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 https_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 https_redirect: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_access_product: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing: Optional[pulumi.Input[_builtins.str]] = None,
                 log_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainLogHeaderArgs', 'DomainLogHeaderArgsDict']]]]] = None,
                 read_time: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 write_time: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainArgs.__new__(DomainArgs)

            __props__.__dict__["cluster_type"] = cluster_type
            __props__.__dict__["connection_time"] = connection_time
            __props__.__dict__["domain"] = domain
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["http2_ports"] = http2_ports
            __props__.__dict__["http_ports"] = http_ports
            __props__.__dict__["http_to_user_ip"] = http_to_user_ip
            __props__.__dict__["https_ports"] = https_ports
            __props__.__dict__["https_redirect"] = https_redirect
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if is_access_product is None and not opts.urn:
                raise TypeError("Missing required property 'is_access_product'")
            __props__.__dict__["is_access_product"] = is_access_product
            __props__.__dict__["load_balancing"] = load_balancing
            __props__.__dict__["log_headers"] = log_headers
            __props__.__dict__["read_time"] = read_time
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["source_ips"] = source_ips
            __props__.__dict__["write_time"] = write_time
            __props__.__dict__["cname"] = None
        super(Domain, __self__).__init__(
            'alicloud:waf/domain:Domain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
            cname: Optional[pulumi.Input[_builtins.str]] = None,
            connection_time: Optional[pulumi.Input[_builtins.int]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            http2_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            http_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            http_to_user_ip: Optional[pulumi.Input[_builtins.str]] = None,
            https_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            https_redirect: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_access_product: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancing: Optional[pulumi.Input[_builtins.str]] = None,
            log_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainLogHeaderArgs', 'DomainLogHeaderArgsDict']]]]] = None,
            read_time: Optional[pulumi.Input[_builtins.int]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            write_time: Optional[pulumi.Input[_builtins.int]] = None) -> 'Domain':
        """
        Get an existing Domain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_type: The type of the WAF cluster. Valid values: `PhysicalCluster` and `VirtualCluster`. Default to `PhysicalCluster`.
        :param pulumi.Input[_builtins.str] cname: The CNAME record assigned by the WAF instance to the specified domain.
        :param pulumi.Input[_builtins.int] connection_time: The connection timeout for WAF exclusive clusters. Unit: seconds.
        :param pulumi.Input[_builtins.str] domain: Field `domain` has been deprecated from version 1.94.0. Use `domain_name` instead.
        :param pulumi.Input[_builtins.str] domain_name: The domain that you want to add to WAF. The `domain_name` is required when the value of the `domain`  is Empty.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] http2_ports: List of the HTTP 2.0 ports.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] http_ports: List of the HTTP ports.
        :param pulumi.Input[_builtins.str] http_to_user_ip: Specifies whether to enable the HTTP back-to-origin feature. After this feature is enabled, the WAF instance can use HTTP to forward HTTPS requests to the origin server. 
               By default, port 80 is used to forward the requests to the origin server. Valid values: `On` and `Off`. Default to `Off`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] https_ports: List of the HTTPS ports.
        :param pulumi.Input[_builtins.str] https_redirect: Specifies whether to redirect HTTP requests as HTTPS requests. Valid values: "On" and `Off`. Default to `Off`.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the WAF instance.
        :param pulumi.Input[_builtins.str] is_access_product: Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: `On` and `Off`. Default to `Off`.
        :param pulumi.Input[_builtins.str] load_balancing: The load balancing algorithm that is used to forward requests to the origin. Valid values: `IpHash` and `RoundRobin`. Default to `IpHash`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainLogHeaderArgs', 'DomainLogHeaderArgsDict']]]] log_headers: The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
               * key: The key of label
               * value: The value of label
        :param pulumi.Input[_builtins.int] read_time: The read timeout of a WAF exclusive cluster. Unit: seconds.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the queried domain belongs in Resource Management. By default, no value is specified, indicating that the domain belongs to the default resource group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_ips: List of the IP address or domain of the origin server to which the specified domain points.
        :param pulumi.Input[_builtins.int] write_time: The timeout period for a WAF exclusive cluster write connection. Unit: seconds.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainState.__new__(_DomainState)

        __props__.__dict__["cluster_type"] = cluster_type
        __props__.__dict__["cname"] = cname
        __props__.__dict__["connection_time"] = connection_time
        __props__.__dict__["domain"] = domain
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["http2_ports"] = http2_ports
        __props__.__dict__["http_ports"] = http_ports
        __props__.__dict__["http_to_user_ip"] = http_to_user_ip
        __props__.__dict__["https_ports"] = https_ports
        __props__.__dict__["https_redirect"] = https_redirect
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["is_access_product"] = is_access_product
        __props__.__dict__["load_balancing"] = load_balancing
        __props__.__dict__["log_headers"] = log_headers
        __props__.__dict__["read_time"] = read_time
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["source_ips"] = source_ips
        __props__.__dict__["write_time"] = write_time
        return Domain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the WAF cluster. Valid values: `PhysicalCluster` and `VirtualCluster`. Default to `PhysicalCluster`.
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter
    def cname(self) -> pulumi.Output[_builtins.str]:
        """
        The CNAME record assigned by the WAF instance to the specified domain.
        """
        return pulumi.get(self, "cname")

    @_builtins.property
    @pulumi.getter(name="connectionTime")
    def connection_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The connection timeout for WAF exclusive clusters. Unit: seconds.
        """
        return pulumi.get(self, "connection_time")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'domain' has been deprecated from version 1.94.0. Use 'domain_name' instead.""")
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        Field `domain` has been deprecated from version 1.94.0. Use `domain_name` instead.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        The domain that you want to add to WAF. The `domain_name` is required when the value of the `domain`  is Empty.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="http2Ports")
    def http2_ports(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of the HTTP 2.0 ports.
        """
        return pulumi.get(self, "http2_ports")

    @_builtins.property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of the HTTP ports.
        """
        return pulumi.get(self, "http_ports")

    @_builtins.property
    @pulumi.getter(name="httpToUserIp")
    def http_to_user_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to enable the HTTP back-to-origin feature. After this feature is enabled, the WAF instance can use HTTP to forward HTTPS requests to the origin server. 
        By default, port 80 is used to forward the requests to the origin server. Valid values: `On` and `Off`. Default to `Off`.
        """
        return pulumi.get(self, "http_to_user_ip")

    @_builtins.property
    @pulumi.getter(name="httpsPorts")
    def https_ports(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of the HTTPS ports.
        """
        return pulumi.get(self, "https_ports")

    @_builtins.property
    @pulumi.getter(name="httpsRedirect")
    def https_redirect(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to redirect HTTP requests as HTTPS requests. Valid values: "On" and `Off`. Default to `Off`.
        """
        return pulumi.get(self, "https_redirect")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the WAF instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="isAccessProduct")
    def is_access_product(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: `On` and `Off`. Default to `Off`.
        """
        return pulumi.get(self, "is_access_product")

    @_builtins.property
    @pulumi.getter(name="loadBalancing")
    def load_balancing(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The load balancing algorithm that is used to forward requests to the origin. Valid values: `IpHash` and `RoundRobin`. Default to `IpHash`.
        """
        return pulumi.get(self, "load_balancing")

    @_builtins.property
    @pulumi.getter(name="logHeaders")
    def log_headers(self) -> pulumi.Output[Optional[Sequence['outputs.DomainLogHeader']]]:
        """
        The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
        * key: The key of label
        * value: The value of label
        """
        return pulumi.get(self, "log_headers")

    @_builtins.property
    @pulumi.getter(name="readTime")
    def read_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The read timeout of a WAF exclusive cluster. Unit: seconds.
        """
        return pulumi.get(self, "read_time")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group to which the queried domain belongs in Resource Management. By default, no value is specified, indicating that the domain belongs to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="sourceIps")
    def source_ips(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of the IP address or domain of the origin server to which the specified domain points.
        """
        return pulumi.get(self, "source_ips")

    @_builtins.property
    @pulumi.getter(name="writeTime")
    def write_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The timeout period for a WAF exclusive cluster write connection. Unit: seconds.
        """
        return pulumi.get(self, "write_time")

