# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DefenseRuleArgs', 'DefenseRule']

@pulumi.input_type
class DefenseRuleArgs:
    def __init__(__self__, *,
                 config: pulumi.Input['DefenseRuleConfigArgs'],
                 defense_scene: pulumi.Input[_builtins.str],
                 defense_type: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 defense_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 resource: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_status: Optional[pulumi.Input[_builtins.int]] = None,
                 template_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a DefenseRule resource.
        :param pulumi.Input['DefenseRuleConfigArgs'] config: Rule configuration content, in JSON format, constructed with a series of parameters.
               
               > **NOTE:**  Depending on the specified **protection rule type**(`DefenseScene`), the specific parameters vary. For more information, see **Protection Rule Parameter Description**.
               See `config` below.
        :param pulumi.Input[_builtins.str] defense_scene: The WAF protection scenario to be created.
               
               When the protection rule type `DefenseType` is set to `template`, the value is as follows:
        :param pulumi.Input[_builtins.str] defense_type: The protection rule type. Value:
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Web Application Firewall (WAF) instance.
        :param pulumi.Input[_builtins.str] defense_origin: Sources of protection. Value:
        :param pulumi.Input[_builtins.str] resource: The protection object corresponding to the rule to be queried.
               
               > **NOTE:**  This parameter is required only when `DefenseType` is set to `resource`.
        :param pulumi.Input[_builtins.str] rule_name: The rule name.
        :param pulumi.Input[_builtins.int] rule_status: Protection rule status.
        :param pulumi.Input[_builtins.int] template_id: The protection template ID of the protection rule to be created.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "defense_scene", defense_scene)
        pulumi.set(__self__, "defense_type", defense_type)
        pulumi.set(__self__, "instance_id", instance_id)
        if defense_origin is not None:
            pulumi.set(__self__, "defense_origin", defense_origin)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if rule_status is not None:
            pulumi.set(__self__, "rule_status", rule_status)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Input['DefenseRuleConfigArgs']:
        """
        Rule configuration content, in JSON format, constructed with a series of parameters.

        > **NOTE:**  Depending on the specified **protection rule type**(`DefenseScene`), the specific parameters vary. For more information, see **Protection Rule Parameter Description**.
        See `config` below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input['DefenseRuleConfigArgs']):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="defenseScene")
    def defense_scene(self) -> pulumi.Input[_builtins.str]:
        """
        The WAF protection scenario to be created.

        When the protection rule type `DefenseType` is set to `template`, the value is as follows:
        """
        return pulumi.get(self, "defense_scene")

    @defense_scene.setter
    def defense_scene(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "defense_scene", value)

    @_builtins.property
    @pulumi.getter(name="defenseType")
    def defense_type(self) -> pulumi.Input[_builtins.str]:
        """
        The protection rule type. Value:
        """
        return pulumi.get(self, "defense_type")

    @defense_type.setter
    def defense_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "defense_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Web Application Firewall (WAF) instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="defenseOrigin")
    def defense_origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sources of protection. Value:
        """
        return pulumi.get(self, "defense_origin")

    @defense_origin.setter
    def defense_origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defense_origin", value)

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protection object corresponding to the rule to be queried.

        > **NOTE:**  This parameter is required only when `DefenseType` is set to `resource`.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule name.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="ruleStatus")
    def rule_status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Protection rule status.
        """
        return pulumi.get(self, "rule_status")

    @rule_status.setter
    def rule_status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rule_status", value)

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The protection template ID of the protection rule to be created.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "template_id", value)


@pulumi.input_type
class _DefenseRuleState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['DefenseRuleConfigArgs']] = None,
                 defense_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 defense_scene: Optional[pulumi.Input[_builtins.str]] = None,
                 defense_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_id: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_status: Optional[pulumi.Input[_builtins.int]] = None,
                 template_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering DefenseRule resources.
        :param pulumi.Input['DefenseRuleConfigArgs'] config: Rule configuration content, in JSON format, constructed with a series of parameters.
               
               > **NOTE:**  Depending on the specified **protection rule type**(`DefenseScene`), the specific parameters vary. For more information, see **Protection Rule Parameter Description**.
               See `config` below.
        :param pulumi.Input[_builtins.str] defense_origin: Sources of protection. Value:
        :param pulumi.Input[_builtins.str] defense_scene: The WAF protection scenario to be created.
               
               When the protection rule type `DefenseType` is set to `template`, the value is as follows:
        :param pulumi.Input[_builtins.str] defense_type: The protection rule type. Value:
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Web Application Firewall (WAF) instance.
        :param pulumi.Input[_builtins.str] resource: The protection object corresponding to the rule to be queried.
               
               > **NOTE:**  This parameter is required only when `DefenseType` is set to `resource`.
        :param pulumi.Input[_builtins.int] rule_id: The protection rule ID.
        :param pulumi.Input[_builtins.str] rule_name: The rule name.
        :param pulumi.Input[_builtins.int] rule_status: Protection rule status.
        :param pulumi.Input[_builtins.int] template_id: The protection template ID of the protection rule to be created.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if defense_origin is not None:
            pulumi.set(__self__, "defense_origin", defense_origin)
        if defense_scene is not None:
            pulumi.set(__self__, "defense_scene", defense_scene)
        if defense_type is not None:
            pulumi.set(__self__, "defense_type", defense_type)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if rule_status is not None:
            pulumi.set(__self__, "rule_status", rule_status)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['DefenseRuleConfigArgs']]:
        """
        Rule configuration content, in JSON format, constructed with a series of parameters.

        > **NOTE:**  Depending on the specified **protection rule type**(`DefenseScene`), the specific parameters vary. For more information, see **Protection Rule Parameter Description**.
        See `config` below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['DefenseRuleConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="defenseOrigin")
    def defense_origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sources of protection. Value:
        """
        return pulumi.get(self, "defense_origin")

    @defense_origin.setter
    def defense_origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defense_origin", value)

    @_builtins.property
    @pulumi.getter(name="defenseScene")
    def defense_scene(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The WAF protection scenario to be created.

        When the protection rule type `DefenseType` is set to `template`, the value is as follows:
        """
        return pulumi.get(self, "defense_scene")

    @defense_scene.setter
    def defense_scene(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defense_scene", value)

    @_builtins.property
    @pulumi.getter(name="defenseType")
    def defense_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protection rule type. Value:
        """
        return pulumi.get(self, "defense_type")

    @defense_type.setter
    def defense_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defense_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Web Application Firewall (WAF) instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protection object corresponding to the rule to be queried.

        > **NOTE:**  This parameter is required only when `DefenseType` is set to `resource`.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource", value)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The protection rule ID.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rule_id", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule name.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="ruleStatus")
    def rule_status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Protection rule status.
        """
        return pulumi.get(self, "rule_status")

    @rule_status.setter
    def rule_status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rule_status", value)

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The protection template ID of the protection rule to be created.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "template_id", value)


@pulumi.type_token("alicloud:wafv3/defenseRule:DefenseRule")
class DefenseRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['DefenseRuleConfigArgs', 'DefenseRuleConfigArgsDict']]] = None,
                 defense_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 defense_scene: Optional[pulumi.Input[_builtins.str]] = None,
                 defense_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_status: Optional[pulumi.Input[_builtins.int]] = None,
                 template_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a WAFV3 Defense Rule resource.

        For information about WAFV3 Defense Rule and how to use it, see [What is Defense Rule](https://next.api.alibabacloud.com/document/waf-openapi/2021-10-01/CreateDefenseRule).

        > **NOTE:** Available since v1.257.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tfexample"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-hangzhou"
        domain = config.get("domain")
        if domain is None:
            domain = "example.wafqax.top"
        default = alicloud.wafv3.get_instances()
        default_icm_rhk = alicloud.wafv3.Domain("defaultICMRhk",
            redirect={
                "loadbalance": "iphash",
                "backends": ["39.98.217.197"],
                "connect_timeout": 5,
                "read_timeout": 120,
                "write_timeout": 120,
            },
            domain="example.wafqax.top",
            access_type="share",
            instance_id=default.ids[0],
            listen={
                "http_ports": [80],
            })
        default_defense_rule = alicloud.wafv3.DefenseRule("default",
            defense_type="resource",
            defense_scene="account_identifier",
            rule_status=1,
            resource=default_icm_rhk.domain_id,
            defense_origin="custom",
            config={
                "account_identifiers": [{
                    "position": "jwt",
                    "priority": 2,
                    "decode_type": "jwt",
                    "key": "Query-Arg",
                    "sub_key": "adb",
                }],
            },
            instance_id=default.ids[0])
        ```

        ## Import

        WAFV3 Defense Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:wafv3/defenseRule:DefenseRule example <instance_id>:<defense_type>:<rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DefenseRuleConfigArgs', 'DefenseRuleConfigArgsDict']] config: Rule configuration content, in JSON format, constructed with a series of parameters.
               
               > **NOTE:**  Depending on the specified **protection rule type**(`DefenseScene`), the specific parameters vary. For more information, see **Protection Rule Parameter Description**.
               See `config` below.
        :param pulumi.Input[_builtins.str] defense_origin: Sources of protection. Value:
        :param pulumi.Input[_builtins.str] defense_scene: The WAF protection scenario to be created.
               
               When the protection rule type `DefenseType` is set to `template`, the value is as follows:
        :param pulumi.Input[_builtins.str] defense_type: The protection rule type. Value:
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Web Application Firewall (WAF) instance.
        :param pulumi.Input[_builtins.str] resource: The protection object corresponding to the rule to be queried.
               
               > **NOTE:**  This parameter is required only when `DefenseType` is set to `resource`.
        :param pulumi.Input[_builtins.str] rule_name: The rule name.
        :param pulumi.Input[_builtins.int] rule_status: Protection rule status.
        :param pulumi.Input[_builtins.int] template_id: The protection template ID of the protection rule to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DefenseRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a WAFV3 Defense Rule resource.

        For information about WAFV3 Defense Rule and how to use it, see [What is Defense Rule](https://next.api.alibabacloud.com/document/waf-openapi/2021-10-01/CreateDefenseRule).

        > **NOTE:** Available since v1.257.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tfexample"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-hangzhou"
        domain = config.get("domain")
        if domain is None:
            domain = "example.wafqax.top"
        default = alicloud.wafv3.get_instances()
        default_icm_rhk = alicloud.wafv3.Domain("defaultICMRhk",
            redirect={
                "loadbalance": "iphash",
                "backends": ["39.98.217.197"],
                "connect_timeout": 5,
                "read_timeout": 120,
                "write_timeout": 120,
            },
            domain="example.wafqax.top",
            access_type="share",
            instance_id=default.ids[0],
            listen={
                "http_ports": [80],
            })
        default_defense_rule = alicloud.wafv3.DefenseRule("default",
            defense_type="resource",
            defense_scene="account_identifier",
            rule_status=1,
            resource=default_icm_rhk.domain_id,
            defense_origin="custom",
            config={
                "account_identifiers": [{
                    "position": "jwt",
                    "priority": 2,
                    "decode_type": "jwt",
                    "key": "Query-Arg",
                    "sub_key": "adb",
                }],
            },
            instance_id=default.ids[0])
        ```

        ## Import

        WAFV3 Defense Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:wafv3/defenseRule:DefenseRule example <instance_id>:<defense_type>:<rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param DefenseRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DefenseRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['DefenseRuleConfigArgs', 'DefenseRuleConfigArgsDict']]] = None,
                 defense_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 defense_scene: Optional[pulumi.Input[_builtins.str]] = None,
                 defense_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_status: Optional[pulumi.Input[_builtins.int]] = None,
                 template_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DefenseRuleArgs.__new__(DefenseRuleArgs)

            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            __props__.__dict__["defense_origin"] = defense_origin
            if defense_scene is None and not opts.urn:
                raise TypeError("Missing required property 'defense_scene'")
            __props__.__dict__["defense_scene"] = defense_scene
            if defense_type is None and not opts.urn:
                raise TypeError("Missing required property 'defense_type'")
            __props__.__dict__["defense_type"] = defense_type
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["resource"] = resource
            __props__.__dict__["rule_name"] = rule_name
            __props__.__dict__["rule_status"] = rule_status
            __props__.__dict__["template_id"] = template_id
            __props__.__dict__["rule_id"] = None
        super(DefenseRule, __self__).__init__(
            'alicloud:wafv3/defenseRule:DefenseRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[Union['DefenseRuleConfigArgs', 'DefenseRuleConfigArgsDict']]] = None,
            defense_origin: Optional[pulumi.Input[_builtins.str]] = None,
            defense_scene: Optional[pulumi.Input[_builtins.str]] = None,
            defense_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource: Optional[pulumi.Input[_builtins.str]] = None,
            rule_id: Optional[pulumi.Input[_builtins.int]] = None,
            rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            rule_status: Optional[pulumi.Input[_builtins.int]] = None,
            template_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'DefenseRule':
        """
        Get an existing DefenseRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DefenseRuleConfigArgs', 'DefenseRuleConfigArgsDict']] config: Rule configuration content, in JSON format, constructed with a series of parameters.
               
               > **NOTE:**  Depending on the specified **protection rule type**(`DefenseScene`), the specific parameters vary. For more information, see **Protection Rule Parameter Description**.
               See `config` below.
        :param pulumi.Input[_builtins.str] defense_origin: Sources of protection. Value:
        :param pulumi.Input[_builtins.str] defense_scene: The WAF protection scenario to be created.
               
               When the protection rule type `DefenseType` is set to `template`, the value is as follows:
        :param pulumi.Input[_builtins.str] defense_type: The protection rule type. Value:
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Web Application Firewall (WAF) instance.
        :param pulumi.Input[_builtins.str] resource: The protection object corresponding to the rule to be queried.
               
               > **NOTE:**  This parameter is required only when `DefenseType` is set to `resource`.
        :param pulumi.Input[_builtins.int] rule_id: The protection rule ID.
        :param pulumi.Input[_builtins.str] rule_name: The rule name.
        :param pulumi.Input[_builtins.int] rule_status: Protection rule status.
        :param pulumi.Input[_builtins.int] template_id: The protection template ID of the protection rule to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DefenseRuleState.__new__(_DefenseRuleState)

        __props__.__dict__["config"] = config
        __props__.__dict__["defense_origin"] = defense_origin
        __props__.__dict__["defense_scene"] = defense_scene
        __props__.__dict__["defense_type"] = defense_type
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["resource"] = resource
        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["rule_status"] = rule_status
        __props__.__dict__["template_id"] = template_id
        return DefenseRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.DefenseRuleConfig']:
        """
        Rule configuration content, in JSON format, constructed with a series of parameters.

        > **NOTE:**  Depending on the specified **protection rule type**(`DefenseScene`), the specific parameters vary. For more information, see **Protection Rule Parameter Description**.
        See `config` below.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="defenseOrigin")
    def defense_origin(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Sources of protection. Value:
        """
        return pulumi.get(self, "defense_origin")

    @_builtins.property
    @pulumi.getter(name="defenseScene")
    def defense_scene(self) -> pulumi.Output[_builtins.str]:
        """
        The WAF protection scenario to be created.

        When the protection rule type `DefenseType` is set to `template`, the value is as follows:
        """
        return pulumi.get(self, "defense_scene")

    @_builtins.property
    @pulumi.getter(name="defenseType")
    def defense_type(self) -> pulumi.Output[_builtins.str]:
        """
        The protection rule type. Value:
        """
        return pulumi.get(self, "defense_type")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Web Application Firewall (WAF) instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> pulumi.Output[_builtins.str]:
        """
        The protection object corresponding to the rule to be queried.

        > **NOTE:**  This parameter is required only when `DefenseType` is set to `resource`.
        """
        return pulumi.get(self, "resource")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[_builtins.int]:
        """
        The protection rule ID.
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[_builtins.str]:
        """
        The rule name.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter(name="ruleStatus")
    def rule_status(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Protection rule status.
        """
        return pulumi.get(self, "rule_status")

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The protection template ID of the protection rule to be created.
        """
        return pulumi.get(self, "template_id")

