from typing import Optional, Protocol


class BigdataConnectionProtocol(Protocol):
    """Used to have typing in Watchlist avoiding a circular dependency with BigdataConnection"""

    def get_single_watchlist(self, id_): ...

    def create_watchlist(self, request): ...

    def patch_watchlist(self, id_, request): ...

    def delete_watchlist(self, id_): ...

    def get_all_watchlists(self, owned: bool): ...

    def share_unshare_watchlist(self, id_, request): ...

    def autosuggest(
        self, items, limit, categories, group1, group2, group3, group4, group5
    ): ...

    def autosuggest_async(self, items, limit): ...

    def by_ids(self, request) -> "ByIdsResponse":  # noqa
        ...

    def share_file_with_company(self, file_id): ...

    def unshare_file_with_company(self, file_id): ...

    def download_annotated_dict(self, id_: str) -> dict: ...

    def get_companies_by_isin(self, isins: list[str]): ...

    def get_companies_by_cusip(self, cusips: list[str]): ...

    def get_companies_by_sedol(self, sedols: list[str]): ...

    def get_companies_by_listing(self, listings: list[str]): ...

    def get_chat(self, id_): ...

    def get_all_chats(self): ...

    def create_chat(self, name): ...

    def delete_chat(self, id_): ...

    def ask_chat(
        self,
        id_,
        question,
        *,
        scope: Optional[str] = None,
        source_filter: Optional[list[str]] = None,
    ): ...
