"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StringResource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/random/r/string random_string}
*/
class StringResource extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/random/r/string random_string} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StringResourceConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'random_string',
            terraformGeneratorMetadata: {
                providerName: 'random',
                providerVersion: '3.2.0',
                providerVersionConstraint: '~> 3.1'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._keepers = config.keepers;
        this._length = config.length;
        this._lower = config.lower;
        this._minLower = config.minLower;
        this._minNumeric = config.minNumeric;
        this._minSpecial = config.minSpecial;
        this._minUpper = config.minUpper;
        this._number = config.number;
        this._overrideSpecial = config.overrideSpecial;
        this._special = config.special;
        this._upper = config.upper;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // id - computed: true, optional: false, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get keepers() {
        return this.getStringMapAttribute('keepers');
    }
    set keepers(value) {
        this._keepers = value;
    }
    resetKeepers() {
        this._keepers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keepersInput() {
        return this._keepers;
    }
    get length() {
        return this.getNumberAttribute('length');
    }
    set length(value) {
        this._length = value;
    }
    // Temporarily expose input value. Use with caution.
    get lengthInput() {
        return this._length;
    }
    get lower() {
        return this.getBooleanAttribute('lower');
    }
    set lower(value) {
        this._lower = value;
    }
    resetLower() {
        this._lower = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lowerInput() {
        return this._lower;
    }
    get minLower() {
        return this.getNumberAttribute('min_lower');
    }
    set minLower(value) {
        this._minLower = value;
    }
    resetMinLower() {
        this._minLower = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minLowerInput() {
        return this._minLower;
    }
    get minNumeric() {
        return this.getNumberAttribute('min_numeric');
    }
    set minNumeric(value) {
        this._minNumeric = value;
    }
    resetMinNumeric() {
        this._minNumeric = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minNumericInput() {
        return this._minNumeric;
    }
    get minSpecial() {
        return this.getNumberAttribute('min_special');
    }
    set minSpecial(value) {
        this._minSpecial = value;
    }
    resetMinSpecial() {
        this._minSpecial = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minSpecialInput() {
        return this._minSpecial;
    }
    get minUpper() {
        return this.getNumberAttribute('min_upper');
    }
    set minUpper(value) {
        this._minUpper = value;
    }
    resetMinUpper() {
        this._minUpper = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minUpperInput() {
        return this._minUpper;
    }
    get number() {
        return this.getBooleanAttribute('number');
    }
    set number(value) {
        this._number = value;
    }
    resetNumber() {
        this._number = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numberInput() {
        return this._number;
    }
    get overrideSpecial() {
        return this.getStringAttribute('override_special');
    }
    set overrideSpecial(value) {
        this._overrideSpecial = value;
    }
    resetOverrideSpecial() {
        this._overrideSpecial = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get overrideSpecialInput() {
        return this._overrideSpecial;
    }
    // result - computed: true, optional: false, required: false
    get result() {
        return this.getStringAttribute('result');
    }
    get special() {
        return this.getBooleanAttribute('special');
    }
    set special(value) {
        this._special = value;
    }
    resetSpecial() {
        this._special = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get specialInput() {
        return this._special;
    }
    get upper() {
        return this.getBooleanAttribute('upper');
    }
    set upper(value) {
        this._upper = value;
    }
    resetUpper() {
        this._upper = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get upperInput() {
        return this._upper;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            keepers: cdktf.hashMapper(cdktf.stringToTerraform)(this._keepers),
            length: cdktf.numberToTerraform(this._length),
            lower: cdktf.booleanToTerraform(this._lower),
            min_lower: cdktf.numberToTerraform(this._minLower),
            min_numeric: cdktf.numberToTerraform(this._minNumeric),
            min_special: cdktf.numberToTerraform(this._minSpecial),
            min_upper: cdktf.numberToTerraform(this._minUpper),
            number: cdktf.booleanToTerraform(this._number),
            override_special: cdktf.stringToTerraform(this._overrideSpecial),
            special: cdktf.booleanToTerraform(this._special),
            upper: cdktf.booleanToTerraform(this._upper),
        };
    }
}
exports.StringResource = StringResource;
_a = JSII_RTTI_SYMBOL_1;
StringResource[_a] = { fqn: "@cdktf/provider-random.StringResource", version: "0.3.10" };
// =================
// STATIC PROPERTIES
// =================
StringResource.tfResourceType = "random_string";
//# sourceMappingURL=data:application/json;base64,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