from collections import defaultdict

LA = 'la'
LA_AVG = 'avg_la'
PSI = 'psi'
RHO = 'rho'
INFECTIOUS_TIME = 'd_I'
REPRODUCTIVE_NUMBER = 'R'

F_E = 'f_E'
MU = 'mu'
INCUBATION_PERIOD = 'd_E'

F_S = 'f_S'
X_S = 'X_S'

F_S_X_S = 'f_S_X_S'

PI_I = 'pi_I'
PI_IC = 'pi_IC'
PI_S = 'pi_S'
PI_SC = 'pi_SC'
PI_E = 'pi_E'
PI_EC = 'pi_EC'

PIS = 'pi'


X_C = 'X_C'
UPSILON = 'upsilon'

UPS_X_C = 'upsilon_X_C'

KAPPA = 'kappa'
PHI = 'phi'
REMOVAL_TIME_AFTER_NOTIFICATION = 'd_C'

RATE_PARAMETERS = (LA, PSI, PHI, MU, LA_AVG)
TIME_PARAMETERS = (INCUBATION_PERIOD, INFECTIOUS_TIME, REMOVAL_TIME_AFTER_NOTIFICATION)



DEFAULT_MIN_PROB = 1e-6
DEFAULT_MAX_PROB = 1
DEFAULT_MIN_RATE = 1e-3
DEFAULT_MAX_RATE = 1e3


BD = 'BD'
BDCT = 'BDCT'
BDCT1 = 'BDCT1'
BDCT2 = 'BDCT2'
BDCT2000 = 'BDCT2000'

BDEI = 'BDEI'
BDEICT = 'BDEICT'
BDEICT1 = 'BDEICT1'
BDEICT2 = 'BDEICT2'
BDEICT2000 = 'BDEICT2000'

BDSS = 'BDSS'
BDSSCT = 'BDSSCT'
BDSSCT1 = 'BDSSCT1'
BDSSCT2 = 'BDSSCT2'
BDSSCT2000 = 'BDSSCT2000'

BDEISS = 'BDEISS'
BDEISSCT = 'BDEISSCT'
BDEISSCT1 = 'BDEISSCT1'
BDEISSCT2 = 'BDEISSCT2'
BDEISSCT2000 = 'BDEISSCT2000'



MODEL_FINDER = 'MF'

MODELS = (BD, BDCT, \
          BDEI, BDEICT, \
          BDSS, BDSSCT, \
          BDEISS, BDEISSCT)

DATA_TYPES = ['tree']


WITH_PIS = False

# TARGET_COLUMNS_BDCT = (REPRODUCTIVE_NUMBER, INFECTIOUS_TIME, REMOVAL_TIME_AFTER_NOTIFICATION, UPSILON)
# TARGET_COLUMNS_BD = (REPRODUCTIVE_NUMBER, INFECTIOUS_TIME)
# TARGET_CT_COLUMNS = (UPSILON, X_C, KAPPA)
TARGET_CT_COLUMNS = (UPSILON, X_C)
TARGET_INCUBATION_COLUMNS = (F_E,)
TARGET_SS_COLUMNS = (F_S, X_S)
TARGET_COLUMNS_BD = (LA, PSI)
TARGET_COLUMNS_BDCT = TARGET_COLUMNS_BD + TARGET_CT_COLUMNS
TARGET_COLUMNS_BDEI = TARGET_COLUMNS_BD + (LA_AVG,) + TARGET_INCUBATION_COLUMNS
TARGET_COLUMNS_BDEICT = TARGET_COLUMNS_BDEI + TARGET_CT_COLUMNS
TARGET_COLUMNS_BDSS = TARGET_COLUMNS_BD + (LA_AVG,) + TARGET_SS_COLUMNS
TARGET_COLUMNS_BDSSCT = TARGET_COLUMNS_BDSS + TARGET_CT_COLUMNS
TARGET_COLUMNS_BDEISS = TARGET_COLUMNS_BDEI + TARGET_SS_COLUMNS
TARGET_COLUMNS_BDEISSCT = TARGET_COLUMNS_BDEISS + TARGET_CT_COLUMNS

if WITH_PIS:
    TARGET_COLUMNS_BD = TARGET_COLUMNS_BD
    TARGET_COLUMNS_BDCT = TARGET_COLUMNS_BDCT + (PI_I, PI_IC, )
    TARGET_COLUMNS_BDEI = TARGET_COLUMNS_BDEI + (PI_E, PI_I, )
    TARGET_COLUMNS_BDSS = TARGET_COLUMNS_BDSS + (PI_I, PI_S, )
    TARGET_COLUMNS_BDEISS = TARGET_COLUMNS_BDEISS + (PI_E, PI_I, PI_S)
    TARGET_COLUMNS_BDEICT = TARGET_COLUMNS_BDEICT + (PI_E, PI_I, PI_EC, PI_IC)
    TARGET_COLUMNS_BDSSCT = TARGET_COLUMNS_BDSSCT + (PI_I, PI_S, PI_IC, PI_SC)
    TARGET_COLUMNS_BDEISSCT = TARGET_COLUMNS_BDEISSCT + (PI_E, PI_I, PI_S, PI_EC, PI_IC, PI_SC)


MODEL2TARGET_COLUMNS = defaultdict(lambda: TARGET_COLUMNS_BDEISSCT)

MODEL2TARGET_COLUMNS[BD] = TARGET_COLUMNS_BD
MODEL2TARGET_COLUMNS[BDEI] = TARGET_COLUMNS_BDEI
MODEL2TARGET_COLUMNS[BDSS] = TARGET_COLUMNS_BDSS
MODEL2TARGET_COLUMNS[BDEISS] = TARGET_COLUMNS_BDEISS
for model in (BDCT, BDCT1, BDCT2, BDCT2000):
    MODEL2TARGET_COLUMNS[model] = TARGET_COLUMNS_BDCT
for model in (BDEICT, BDEICT1, BDEICT2, BDEICT2000):
    MODEL2TARGET_COLUMNS[model] = TARGET_COLUMNS_BDEICT
for model in (BDSSCT, BDSSCT1, BDSSCT2, BDSSCT2000):
    MODEL2TARGET_COLUMNS[model] = TARGET_COLUMNS_BDSSCT
for model in (BDEISSCT, BDEISSCT1, BDEISSCT2, BDEISSCT2000):
    MODEL2TARGET_COLUMNS[model] = TARGET_COLUMNS_BDEISSCT

