window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"kerykeion": {"fullname": "kerykeion", "modulename": "kerykeion", "kind": "module", "doc": "<p>This is part of Kerykeion (C) 2025 Giacomo Battaglia</p>\n\n<h1 id=\"kerykeion\" align=\"center\">Kerykeion</h1>\n\n<div align=\"center\">\n    <img src=\"https://img.shields.io/github/stars/g-battaglia/kerykeion.svg?logo=github\" alt=\"stars\">\n    <img src=\"https://img.shields.io/github/forks/g-battaglia/kerykeion.svg?logo=github\" alt=\"forks\">\n</div>\n\n<div align=\"center\">\n    <img src=\"https://static.pepy.tech/badge/kerykeion/month\" alt=\"PyPI Downloads\">\n    <img src=\"https://static.pepy.tech/badge/kerykeion/week\" alt=\"PyPI Downloads\">\n    <img src=\"https://img.shields.io/github/contributors/g-battaglia/kerykeion?color=blue&logo=github\" alt=\"contributors\">\n    <img src=\"https://img.shields.io/pypi/v/kerykeion?label=pypi%20package\" alt=\"Package version\">\n    <img src=\"https://img.shields.io/pypi/pyversions/kerykeion.svg\" alt=\"Supported Python versions\">\n</div>\n\n<p align=\"center\">\u2b50 Like this project? Star it on GitHub and help it grow! \u2b50</p>\n\n<p>&nbsp;</p>\n\n<p>Kerykeion is a Python library for astrology. It computes planetary and house positions, detects aspects, and generates SVG charts\u2014including birth, synastry, transit, and composite charts. You can also customize which planets to include in your calculations.</p>\n\n<p>The main goal of this project is to offer a clean, data-driven approach to astrology, making it accessible and programmable.</p>\n\n<p>Kerykeion also integrates seamlessly with LLM and AI applications. </p>\n\n<p>Here is an example of a birthchart:</p>\n\n<p><img src=\"https://raw.githubusercontent.com/g-battaglia/kerykeion/refs/heads/master/tests/charts/svg/John%20Lennon%20-%20Dark%20Theme%20-%20Natal%20Chart.svg\" alt=\"John Lenon Chart\" /></p>\n\n<h2 id=\"web-api\"><strong>Web API</strong></h2>\n\n<p>If you want to use Kerykeion in a web application, you can try the dedicated web API:</p>\n\n<p><strong><a href=\"https://rapidapi.com/gbattaglia/api/astrologer/pricing\">AstrologerAPI</a></strong></p>\n\n<p>It is <a href=\"https://github.com/g-battaglia/Astrologer-API\">open source</a> and directly supports this project.</p>\n\n<h2 id=\"donate\"><strong>Donate</strong></h2>\n\n<p>Maintaining this project requires substantial time and effort. The Astrologer API alone cannot cover the costs of full-time development. If you find Kerykeion valuable and would like to support further development, please consider donating:</p>\n\n<p><a href=\"https://ko-fi.com/kerykeion\"><img src=\"https://ko-fi.com/img/githubbutton_sm.svg\" alt=\"ko-fi\" /></a></p>\n\n<h2 id=\"development-branch-notice\">\u26a0\ufe0f Development Branch Notice</h2>\n\n<p>This branch (<code>next</code>) is <strong>not the stable version</strong> of Kerykeion. It is the <strong>development branch for the upcoming V5 release</strong>.</p>\n\n<p>If you're looking for the latest stable version, please check out the <a href=\"https://github.com/g-battaglia/kerykeion/tree/master\"><code>master</code></a> branch instead.</p>\n\n<h2 id=\"table-of-contents\">Table of Contents</h2>\n\n<ul>\n<li><a href=\"#web-api\"><strong>Web API</strong></a></li>\n<li><a href=\"#donate\"><strong>Donate</strong></a></li>\n<li><a href=\"#\ufe0f-development-branch-notice\">\u26a0\ufe0f Development Branch Notice</a></li>\n<li><a href=\"#table-of-contents\">Table of Contents</a></li>\n<li><a href=\"#installation\">Installation</a></li>\n<li><a href=\"#basic-usage\">Basic Usage</a></li>\n<li><a href=\"#generate-a-svg-chart\">Generate a SVG Chart</a>\n<ul>\n<li><a href=\"#birth-chart\">Birth Chart</a></li>\n<li><a href=\"#external-birth-chart\">External Birth Chart</a></li>\n<li><a href=\"#synastry-chart\">Synastry Chart</a></li>\n<li><a href=\"#transit-chart\">Transit Chart</a></li>\n<li><a href=\"#composite-chart\">Composite Chart</a></li>\n</ul></li>\n<li><a href=\"#wheel-only-charts\">Wheel Only Charts</a>\n<ul>\n<li><a href=\"#birth-chart-1\">Birth Chart</a></li>\n<li><a href=\"#wheel-only-birth-chart-external\">Wheel Only Birth Chart (External)</a></li>\n<li><a href=\"#synastry-chart-1\">Synastry Chart</a></li>\n<li><a href=\"#change-the-output-directory\">Change the Output Directory</a></li>\n<li><a href=\"#change-language\">Change Language</a></li>\n<li><a href=\"#minified-svg\">Minified SVG</a></li>\n<li><a href=\"#svg-without-css-variables\">SVG without CSS Variables</a></li>\n<li><a href=\"#grid-only-svg\">Grid Only SVG</a></li>\n</ul></li>\n<li><a href=\"#report\">ReportGenerator</a></li>\n<li><a href=\"#example-retrieving-aspects\">Example: Retrieving Aspects</a></li>\n<li><a href=\"#ayanamsa-sidereal-modes\">Ayanamsa (Sidereal Modes)</a></li>\n<li><a href=\"#house-systems\">House Systems</a></li>\n<li><a href=\"#perspective-type\">Perspective Type</a></li>\n<li><a href=\"#themes\">Themes</a></li>\n<li><a href=\"#alternative-initialization\">Alternative Initialization</a></li>\n<li><a href=\"#lunar-nodes-rahu--ketu\">Lunar Nodes (Rahu \\&amp; Ketu)</a></li>\n<li><a href=\"#json-support\">JSON Support</a></li>\n<li><a href=\"#auto-generated-documentation\">Auto Generated Documentation</a></li>\n<li><a href=\"#development\">Development</a></li>\n<li><a href=\"#integrating-kerykeion-into-your-project\">Integrating Kerykeion into Your Project</a></li>\n<li><a href=\"#license\">License</a></li>\n<li><a href=\"#contributing\">Contributing</a></li>\n<li><a href=\"#citations\">Citations</a></li>\n</ul>\n\n<h2 id=\"installation\">Installation</h2>\n\n<p>Kerykeion requires <strong>Python 3.9</strong> or higher.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code>pip3<span class=\"w\"> </span>install<span class=\"w\"> </span>kerykeion\n</code></pre>\n</div>\n\n<h2 id=\"basic-usage\">Basic Usage</h2>\n\n<p>Below is a simple example illustrating the creation of an astrological subject and retrieving astrological details:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">AstrologicalSubjectFactory</span>\n\n<span class=\"c1\"># Create an instance of the AstrologicalSubjectFactory class.</span>\n<span class=\"c1\"># Arguments: Name, year, month, day, hour, minutes, city, nation</span>\n<span class=\"n\">john</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;John Lennon&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1940</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># Retrieve information about the Sun:</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">john</span><span class=\"o\">.</span><span class=\"n\">sun</span><span class=\"o\">.</span><span class=\"n\">model_dump_json</span><span class=\"p\">())</span>\n<span class=\"c1\"># &gt; {&quot;name&quot;:&quot;Sun&quot;,&quot;quality&quot;:&quot;Cardinal&quot;,&quot;element&quot;:&quot;Air&quot;,&quot;sign&quot;:&quot;Lib&quot;,&quot;sign_num&quot;:6,&quot;position&quot;:16.26789199474399,&quot;abs_pos&quot;:196.267891994744,&quot;emoji&quot;:&quot;\u264e\ufe0f&quot;,&quot;point_type&quot;:&quot;AstrologicalPoint&quot;,&quot;house&quot;:&quot;Sixth_House&quot;,&quot;retrograde&quot;:false}</span>\n\n<span class=\"c1\"># Retrieve information about the first house:</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">john</span><span class=\"o\">.</span><span class=\"n\">first_house</span><span class=\"o\">.</span><span class=\"n\">model_dump_json</span><span class=\"p\">())</span>\n<span class=\"c1\"># &gt; {&quot;name&quot;:&quot;First_House&quot;,&quot;quality&quot;:&quot;Cardinal&quot;,&quot;element&quot;:&quot;Fire&quot;,&quot;sign&quot;:&quot;Ari&quot;,&quot;sign_num&quot;:0,&quot;position&quot;:19.74676624176799,&quot;abs_pos&quot;:19.74676624176799,&quot;emoji&quot;:&quot;\u2648\ufe0f&quot;,&quot;point_type&quot;:&quot;House&quot;,&quot;house&quot;:null,&quot;retrograde&quot;:null}</span>\n\n<span class=\"c1\"># Retrieve the element of the Moon sign:</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">john</span><span class=\"o\">.</span><span class=\"n\">moon</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"p\">)</span>\n<span class=\"c1\"># &gt; &#39;Air&#39;</span>\n</code></pre>\n</div>\n\n<p><strong>To avoid using GeoNames online, specify longitude, latitude, and timezone instead of city and nation:</strong></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">john</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span>\n    <span class=\"s2\">&quot;John Lennon&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1940</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span>\n    <span class=\"n\">lng</span><span class=\"o\">=-</span><span class=\"mf\">2.9833</span><span class=\"p\">,</span>  <span class=\"c1\"># Longitude for Liverpool</span>\n    <span class=\"n\">lat</span><span class=\"o\">=</span><span class=\"mf\">53.4000</span><span class=\"p\">,</span>  <span class=\"c1\"># Latitude for Liverpool</span>\n    <span class=\"n\">tz_str</span><span class=\"o\">=</span><span class=\"s2\">&quot;Europe/London&quot;</span><span class=\"p\">,</span>  <span class=\"c1\"># Timezone for Liverpool</span>\n    <span class=\"n\">city</span><span class=\"o\">=</span><span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> \n<span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<h2 id=\"generate-a-svg-chart\">Generate a SVG Chart</h2>\n\n<p>To generate a chart, use the <code>ChartDrawer</code> class. You can create various types of charts, including birth, synastry, transit, and composite charts.</p>\n\n<p><strong>Tip:</strong> \nThe optimized way to open the generated SVG files is with a web browser (e.g., Chrome, Firefox).\nTo improve compatibility across different applications, you can use the <code>remove_css_variables</code> parameter when generating the SVG. This will inline all styles and eliminate CSS variables, resulting in an SVG that is more broadly supported.</p>\n\n<h3 id=\"birth-chart\">Birth Chart</h3>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"p\">,</span> <span class=\"n\">ChartDrawer</span>\n\n<span class=\"n\">john</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;John Lennon&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1940</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">birth_chart_svg</span> <span class=\"o\">=</span> <span class=\"n\">ChartDrawer</span><span class=\"p\">(</span><span class=\"n\">john</span><span class=\"p\">)</span>\n<span class=\"n\">birth_chart_svg</span><span class=\"o\">.</span><span class=\"n\">makeSVG</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p>The SVG file will be saved in the home directory.\n<img src=\"https://raw.githubusercontent.com/g-battaglia/kerykeion/refs/heads/master/tests/charts/svg/John%20Lennon%20-%20Natal%20Chart.svg\" alt=\"John Lennon Birth Chart\" /></p>\n\n<h3 id=\"external-birth-chart\">External Birth Chart</h3>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"p\">,</span> <span class=\"n\">ChartDrawer</span>\n<span class=\"n\">birth_chart</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;John Lennon&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1940</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">birth_chart_svg</span> <span class=\"o\">=</span> <span class=\"n\">ChartDrawer</span><span class=\"p\">(</span><span class=\"n\">birth_chart</span><span class=\"p\">,</span> <span class=\"n\">chart_type</span><span class=\"o\">=</span><span class=\"s2\">&quot;ExternalNatal&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">birth_chart_svg</span><span class=\"o\">.</span><span class=\"n\">makeSVG</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p><img src=\"https://raw.githubusercontent.com/g-battaglia/kerykeion/refs/heads/master/tests/charts/svg/John%20Lennon%20-%20ExternalNatal%20Chart.svg\" alt=\"John Lennon External Birth Chart\" /></p>\n\n<h3 id=\"synastry-chart\">Synastry Chart</h3>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"p\">,</span> <span class=\"n\">ChartDrawer</span>\n\n<span class=\"n\">first</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;John Lennon&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1940</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">second</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;Paul McCartney&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1942</span><span class=\"p\">,</span> <span class=\"mi\">6</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">15</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n\n<span class=\"n\">synastry_chart</span> <span class=\"o\">=</span> <span class=\"n\">ChartDrawer</span><span class=\"p\">(</span><span class=\"n\">first</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Synastry&quot;</span><span class=\"p\">,</span> <span class=\"n\">second</span><span class=\"p\">)</span>\n<span class=\"n\">synastry_chart</span><span class=\"o\">.</span><span class=\"n\">makeSVG</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p><img src=\"https://www.kerykeion.net/img/examples/synastry-chart.svg\" alt=\"John Lennon and Paul McCartney Synastry\" /></p>\n\n<h3 id=\"transit-chart\">Transit Chart</h3>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"p\">,</span> <span class=\"n\">ChartDrawer</span>\n\n<span class=\"n\">transit</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;Transit&quot;</span><span class=\"p\">,</span> <span class=\"mi\">2025</span><span class=\"p\">,</span> <span class=\"mi\">6</span><span class=\"p\">,</span> <span class=\"mi\">8</span><span class=\"p\">,</span> <span class=\"mi\">8</span><span class=\"p\">,</span> <span class=\"mi\">45</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Atlanta&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;US&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">subject</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;John Lennon&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1940</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n\n<span class=\"n\">transit_chart</span> <span class=\"o\">=</span> <span class=\"n\">ChartDrawer</span><span class=\"p\">(</span><span class=\"n\">subject</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Transit&quot;</span><span class=\"p\">,</span> <span class=\"n\">transit</span><span class=\"p\">)</span>\n<span class=\"n\">transit_chart</span><span class=\"o\">.</span><span class=\"n\">makeSVG</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p><img src=\"https://raw.githubusercontent.com/g-battaglia/kerykeion/refs/heads/master/tests/charts/svg/John%20Lennon%20-%20Transit%20Chart.svg\" alt=\"John Lennon Transit Chart\" /></p>\n\n<h3 id=\"composite-chart\">Composite Chart</h3>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">CompositeSubjectFactory</span><span class=\"p\">,</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"p\">,</span> <span class=\"n\">ChartDrawer</span>\n\n<span class=\"n\">angelina</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;Angelina Jolie&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1975</span><span class=\"p\">,</span> <span class=\"mi\">6</span><span class=\"p\">,</span> <span class=\"mi\">4</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Los Angeles&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;US&quot;</span><span class=\"p\">,</span> <span class=\"n\">lng</span><span class=\"o\">=-</span><span class=\"mf\">118.15</span><span class=\"p\">,</span> <span class=\"n\">lat</span><span class=\"o\">=</span><span class=\"mf\">34.03</span><span class=\"p\">,</span> <span class=\"n\">tz_str</span><span class=\"o\">=</span><span class=\"s2\">&quot;America/Los_Angeles&quot;</span><span class=\"p\">)</span>\n\n<span class=\"n\">brad</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;Brad Pitt&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1963</span><span class=\"p\">,</span> <span class=\"mi\">12</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">6</span><span class=\"p\">,</span> <span class=\"mi\">31</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Shawnee&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;US&quot;</span><span class=\"p\">,</span> <span class=\"n\">lng</span><span class=\"o\">=-</span><span class=\"mf\">96.56</span><span class=\"p\">,</span> <span class=\"n\">lat</span><span class=\"o\">=</span><span class=\"mf\">35.20</span><span class=\"p\">,</span> <span class=\"n\">tz_str</span><span class=\"o\">=</span><span class=\"s2\">&quot;America/Chicago&quot;</span><span class=\"p\">)</span>\n\n<span class=\"n\">factory</span> <span class=\"o\">=</span> <span class=\"n\">CompositeSubjectFactory</span><span class=\"p\">(</span><span class=\"n\">angelina</span><span class=\"p\">,</span> <span class=\"n\">brad</span><span class=\"p\">)</span>\n<span class=\"n\">composite_model</span> <span class=\"o\">=</span> <span class=\"n\">factory</span><span class=\"o\">.</span><span class=\"n\">get_midpoint_composite_subject_model</span><span class=\"p\">()</span>\n\n<span class=\"n\">composite_chart</span> <span class=\"o\">=</span> <span class=\"n\">ChartDrawer</span><span class=\"p\">(</span><span class=\"n\">composite_model</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Composite&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">composite_chart</span><span class=\"o\">.</span><span class=\"n\">makeSVG</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p><img src=\"https://raw.githubusercontent.com/g-battaglia/kerykeion/refs/heads/master/tests/charts/svg/Angelina%20Jolie%20and%20Brad%20Pitt%20Composite%20Chart%20-%20Composite%20Chart.svg\" alt=\"Angelina Jolie and Brad Pitt Composite Chart\" /></p>\n\n<h2 id=\"wheel-only-charts\">Wheel Only Charts</h2>\n\n<p>For <em>all</em> the charts, you can generate a wheel-only chart by using the method <code>makeWheelOnlySVG()</code>:</p>\n\n<h3 id=\"birth-chart-2\">Birth Chart</h3>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"p\">,</span> <span class=\"n\">ChartDrawer</span>\n\n<span class=\"n\">birth_chart</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;John Lennon&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1940</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">birth_chart_svg</span> <span class=\"o\">=</span> <span class=\"n\">ChartDrawer</span><span class=\"p\">(</span><span class=\"n\">birth_chart</span><span class=\"p\">)</span>\n<span class=\"n\">birth_chart_svg</span><span class=\"o\">.</span><span class=\"n\">makeWheelOnlySVG</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p><img src=\"https://raw.githubusercontent.com/g-battaglia/kerykeion/refs/heads/master/tests/charts/svg/John%20Lennon%20-%20Wheel%20Only%20-%20Natal%20Chart%20-%20Wheel%20Only.svg\" alt=\"John Lennon Birth Chart\" /></p>\n\n<h3 id=\"wheel-only-birth-chart-external\">Wheel Only Birth Chart (External)</h3>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"p\">,</span> <span class=\"n\">ChartDrawer</span>\n<span class=\"n\">birth_chart</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;John Lennon&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1940</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">birth_chart_svg</span> <span class=\"o\">=</span> <span class=\"n\">ChartDrawer</span><span class=\"p\">(</span><span class=\"n\">birth_chart</span><span class=\"p\">,</span> <span class=\"n\">chart_type</span><span class=\"o\">=</span><span class=\"s2\">&quot;ExternalNatal&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">birth_chart_svg</span><span class=\"o\">.</span><span class=\"n\">makeWheelOnlySVG</span><span class=\"p\">(</span>\n    <span class=\"n\">wheel_only</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">,</span>\n    <span class=\"n\">wheel_only_external</span><span class=\"o\">=</span><span class=\"kc\">True</span>\n<span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p><img src=\"https://raw.githubusercontent.com/g-battaglia/kerykeion/refs/heads/master/tests/charts/svg/John%20Lennon%20-%20Wheel%20External%20Only%20-%20ExternalNatal%20Chart%20-%20Wheel%20Only.svg\" alt=\"John Lennon Birth Chart\" /></p>\n\n<h3 id=\"synastry-chart-2\">Synastry Chart</h3>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"p\">,</span> <span class=\"n\">ChartDrawer</span>\n<span class=\"n\">first</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;John Lennon&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1940</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">second</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;Paul McCartney&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1942</span><span class=\"p\">,</span> <span class=\"mi\">6</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">15</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">synastry_chart</span> <span class=\"o\">=</span> <span class=\"n\">ChartDrawer</span><span class=\"p\">(</span>\n    <span class=\"n\">first</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Synastry&quot;</span><span class=\"p\">,</span> <span class=\"n\">second</span>\n<span class=\"p\">)</span>\n<span class=\"n\">synastry_chart</span><span class=\"o\">.</span><span class=\"n\">makeWheelOnlySVG</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p><img src=\"https://raw.githubusercontent.com/g-battaglia/kerykeion/refs/heads/master/tests/charts/svg/John%20Lennon%20-%20Wheel%20Synastry%20Only%20-%20Synastry%20Chart%20-%20Wheel%20Only.svg\" alt=\"John Lennon and Paul McCartney Synastry\" /></p>\n\n<h3 id=\"change-the-output-directory\">Change the Output Directory</h3>\n\n<p>To save the SVG file in a custom location, specify <code>new_output_directory</code>:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"p\">,</span> <span class=\"n\">ChartDrawer</span>\n\n<span class=\"n\">first</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;John Lennon&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1940</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">second</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;Paul McCartney&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1942</span><span class=\"p\">,</span> <span class=\"mi\">6</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">15</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n\n<span class=\"n\">synastry_chart</span> <span class=\"o\">=</span> <span class=\"n\">ChartDrawer</span><span class=\"p\">(</span>\n    <span class=\"n\">first</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Synastry&quot;</span><span class=\"p\">,</span> <span class=\"n\">second</span><span class=\"p\">,</span>\n    <span class=\"n\">new_output_directory</span><span class=\"o\">=</span><span class=\"s2\">&quot;.&quot;</span>\n<span class=\"p\">)</span>\n<span class=\"n\">synastry_chart</span><span class=\"o\">.</span><span class=\"n\">makeSVG</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<h3 id=\"change-language\">Change Language</h3>\n\n<p>You can switch chart language by passing <code>chart_language</code> to the  <code>ChartDrawer</code> class:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"p\">,</span> <span class=\"n\">ChartDrawer</span>\n\n<span class=\"n\">birth_chart</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;John Lennon&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1940</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">birth_chart_svg</span> <span class=\"o\">=</span> <span class=\"n\">ChartDrawer</span><span class=\"p\">(</span>\n    <span class=\"n\">birth_chart</span><span class=\"p\">,</span>\n    <span class=\"n\">chart_language</span><span class=\"o\">=</span><span class=\"s2\">&quot;IT&quot;</span>  <span class=\"c1\"># Change to Italian</span>\n<span class=\"p\">)</span>\n<span class=\"n\">birth_chart_svg</span><span class=\"o\">.</span><span class=\"n\">makeSVG</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p>More details <a href=\"https://www.kerykeion.net/docs/chart-language\">here</a>.</p>\n\n<p>The available languages are:</p>\n\n<ul>\n<li>EN (English)</li>\n<li>FR (French)</li>\n<li>PT (Portuguese)</li>\n<li>ES (Spanish)</li>\n<li>TR (Turkish)</li>\n<li>RU (Russian)</li>\n<li>IT (Italian)</li>\n<li>CN (Chinese)</li>\n<li>DE (German)</li>\n</ul>\n\n<h3 id=\"minified-svg\">Minified SVG</h3>\n\n<p>To generate a minified SVG, set <code>minify_svg=True</code> in the <code>makeSVG()</code> method:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"p\">,</span> <span class=\"n\">ChartDrawer</span>\n<span class=\"n\">birth_chart</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;John Lennon&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1940</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">birth_chart_svg</span> <span class=\"o\">=</span> <span class=\"n\">ChartDrawer</span><span class=\"p\">(</span><span class=\"n\">birth_chart</span><span class=\"p\">)</span>\n<span class=\"n\">birth_chart_svg</span><span class=\"o\">.</span><span class=\"n\">makeSVG</span><span class=\"p\">(</span>\n    <span class=\"n\">minify</span><span class=\"o\">=</span><span class=\"kc\">True</span>\n<span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<h3 id=\"svg-without-css-variables\">SVG without CSS Variables</h3>\n\n<p>To generate an SVG without CSS variables, set <code>remove_css_variables=True</code> in the <code>makeSVG()</code> method:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"p\">,</span> <span class=\"n\">ChartDrawer</span>\n\n<span class=\"n\">birth_chart</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;John Lennon&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1940</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">birth_chart_svg</span> <span class=\"o\">=</span> <span class=\"n\">ChartDrawer</span><span class=\"p\">(</span><span class=\"n\">birth_chart</span><span class=\"p\">)</span>\n<span class=\"n\">birth_chart_svg</span><span class=\"o\">.</span><span class=\"n\">makeSVG</span><span class=\"p\">(</span>\n    <span class=\"n\">remove_css_variables</span><span class=\"o\">=</span><span class=\"kc\">True</span>\n<span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>This will inline all styles and eliminate CSS variables, resulting in an SVG that is more broadly supported.</p>\n\n<h3 id=\"grid-only-svg\">Grid Only SVG</h3>\n\n<p>It's possible to generate a grid-only SVG, useful for creating a custom layout. To do this, use the <code>makeAspectGridOnlySVG()</code> method:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"p\">,</span> <span class=\"n\">ChartDrawer</span>\n<span class=\"n\">birth_chart</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;John Lennon&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1940</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">second</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;Paul McCartney&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1942</span><span class=\"p\">,</span> <span class=\"mi\">6</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">15</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">aspect_grid_chart</span> <span class=\"o\">=</span> <span class=\"n\">ChartDrawer</span><span class=\"p\">(</span><span class=\"n\">birth_chart</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Synastry&quot;</span><span class=\"p\">,</span> <span class=\"n\">second</span><span class=\"p\">,</span> <span class=\"n\">theme</span><span class=\"o\">=</span><span class=\"s2\">&quot;dark&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">aspect_grid_chart</span><span class=\"o\">.</span><span class=\"n\">makeAspectGridOnlySVG</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p><img src=\"https://raw.githubusercontent.com/g-battaglia/kerykeion/refs/heads/master/tests/charts/svg/John%20Lennon%20-%20Aspect%20Grid%20Only%20-%20Natal%20Chart%20-%20Aspect%20Grid%20Only.svg\" alt=\"John Lennon Birth Chart\" /></p>\n\n<h2 id=\"report\">ReportGenerator</h2>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">ReportGenerator</span><span class=\"p\">,</span> <span class=\"n\">AstrologicalSubjectFactory</span>\n\n<span class=\"n\">john</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span>\n    <span class=\"s2\">&quot;John Lennon&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1940</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span>\n    <span class=\"n\">lng</span><span class=\"o\">=-</span><span class=\"mf\">2.9833</span><span class=\"p\">,</span>  <span class=\"c1\"># Longitude for Liverpool</span>\n    <span class=\"n\">lat</span><span class=\"o\">=</span><span class=\"mf\">53.4000</span><span class=\"p\">,</span>  <span class=\"c1\"># Latitude for Liverpool</span>\n    <span class=\"n\">tz_str</span><span class=\"o\">=</span><span class=\"s2\">&quot;Europe/London&quot;</span><span class=\"p\">,</span>  <span class=\"c1\"># Timezone for Liverpool</span>\n    <span class=\"n\">city</span><span class=\"o\">=</span><span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span>\n<span class=\"p\">)</span>\n<span class=\"n\">report</span> <span class=\"o\">=</span> <span class=\"n\">ReportGenerator</span><span class=\"p\">(</span><span class=\"n\">john</span><span class=\"p\">)</span>\n<span class=\"n\">report</span><span class=\"o\">.</span><span class=\"n\">print_report</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p>ReportGenerator output:</p>\n\n<pre><code>+- Kerykeion report for John Lennon -+\n+-----------+-------+---------------+-----------+----------+\n| Date      | Time  | Location      | Longitude | Latitude |\n+-----------+-------+---------------+-----------+----------+\n| 9/10/1940 | 18:30 | Liverpool, GB | -2.9833   | 53.4     |\n+-----------+-------+---------------+-----------+----------+\n+-------------------+------+-------+------+----------------+\n| AstrologicalPoint | Sign | Pos.  | Ret. | House          |\n+-------------------+------+-------+------+----------------+\n| Sun               | Lib  | 16.27 | -    | Sixth_House    |\n| Moon              | Aqu  | 3.55  | -    | Eleventh_House |\n| Mercury           | Sco  | 8.56  | -    | Seventh_House  |\n| Venus             | Vir  | 3.22  | -    | Sixth_House    |\n| Mars              | Lib  | 2.66  | -    | Sixth_House    |\n| Jupiter           | Tau  | 13.69 | R    | First_House    |\n| Saturn            | Tau  | 13.22 | R    | First_House    |\n| Uranus            | Tau  | 25.55 | R    | First_House    |\n| Neptune           | Vir  | 26.03 | -    | Sixth_House    |\n| Pluto             | Leo  | 4.19  | -    | Fifth_House    |\n| Mean_Node         | Lib  | 10.58 | R    | Sixth_House    |\n| Mean_South_Node   | Ari  | 10.58 | R    | Twelfth_House  |\n| Mean_Lilith       | Ari  | 13.37 | -    | Twelfth_House  |\n| Chiron            | Leo  | 0.57  | -    | Fifth_House    |\n+-------------------+------+-------+------+----------------+\n+----------------+------+----------+\n| House          | Sign | Position |\n+----------------+------+----------+\n| First_House    | Ari  | 19.72    |\n| Second_House   | Tau  | 29.52    |\n| Third_House    | Gem  | 20.23    |\n| Fourth_House   | Can  | 7.07     |\n| Fifth_House    | Can  | 25.31    |\n| Sixth_House    | Leo  | 22.11    |\n| Seventh_House  | Lib  | 19.72    |\n| Eighth_House   | Sco  | 29.52    |\n| Ninth_House    | Sag  | 20.23    |\n| Tenth_House    | Cap  | 7.07     |\n| Eleventh_House | Cap  | 25.31    |\n| Twelfth_House  | Aqu  | 22.11    |\n+----------------+------+----------+\n</code></pre>\n\n<p>To export to a file:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code>python3<span class=\"w\"> </span>your_script_name.py<span class=\"w\"> </span>&gt;<span class=\"w\"> </span>file.txt\n</code></pre>\n</div>\n\n<h2 id=\"example-retrieving-aspects\">Example: Retrieving Aspects</h2>\n\n<p>Kerykeion provides a unified <code>AspectsFactory</code> class for calculating astrological aspects within single charts or between two charts:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">AspectsFactory</span><span class=\"p\">,</span> <span class=\"n\">AstrologicalSubjectFactory</span>\n\n<span class=\"c1\"># Create astrological subjects</span>\n<span class=\"n\">jack</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;Jack&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1990</span><span class=\"p\">,</span> <span class=\"mi\">6</span><span class=\"p\">,</span> <span class=\"mi\">15</span><span class=\"p\">,</span> <span class=\"mi\">15</span><span class=\"p\">,</span> <span class=\"mi\">15</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Roma&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;IT&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">jane</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;Jane&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1991</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">25</span><span class=\"p\">,</span> <span class=\"mi\">21</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Roma&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;IT&quot;</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># For single chart aspects (natal, return, composite, etc.)</span>\n<span class=\"n\">single_chart_aspects</span> <span class=\"o\">=</span> <span class=\"n\">AspectsFactory</span><span class=\"o\">.</span><span class=\"n\">single_chart_aspects</span><span class=\"p\">(</span><span class=\"n\">jack</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"sa\">f</span><span class=\"s2\">&quot;Found </span><span class=\"si\">{</span><span class=\"nb\">len</span><span class=\"p\">(</span><span class=\"n\">single_chart_aspects</span><span class=\"p\">)</span><span class=\"si\">}</span><span class=\"s2\"> aspects in Jack&#39;s chart&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">single_chart_aspects</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">])</span>\n<span class=\"c1\"># Output: AspectModel with details like aspect type, orb, planets involved, etc.</span>\n\n<span class=\"c1\"># For dual chart aspects (synastry, transits, comparisons, etc.)</span>\n<span class=\"n\">dual_chart_aspects</span> <span class=\"o\">=</span> <span class=\"n\">AspectsFactory</span><span class=\"o\">.</span><span class=\"n\">dual_chart_aspects</span><span class=\"p\">(</span><span class=\"n\">jack</span><span class=\"p\">,</span> <span class=\"n\">jane</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"sa\">f</span><span class=\"s2\">&quot;Found </span><span class=\"si\">{</span><span class=\"nb\">len</span><span class=\"p\">(</span><span class=\"n\">dual_chart_aspects</span><span class=\"p\">)</span><span class=\"si\">}</span><span class=\"s2\"> aspects between Jack and Jane&#39;s charts&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">dual_chart_aspects</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">])</span>\n<span class=\"c1\"># Output: AspectModel with cross-chart aspect details</span>\n\n<span class=\"c1\"># The factory returns structured AspectModel objects with properties like:</span>\n<span class=\"c1\"># - p1_name, p2_name: Planet/point names</span>\n<span class=\"c1\"># - aspect: Aspect type (conjunction, trine, square, etc.)</span>\n<span class=\"c1\"># - orbit: Orb tolerance in degrees</span>\n<span class=\"c1\"># - aspect_degrees: Exact degrees for the aspect (0, 60, 90, 120, 180, etc.)</span>\n<span class=\"c1\"># - color: Hex color code for visualization</span>\n</code></pre>\n</div>\n\n<p><strong>Advanced Usage with Custom Settings:</strong></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># You can also customize aspect calculations with custom orb settings</span>\n<span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion.settings.config_constants</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">DEFAULT_ACTIVE_ASPECTS</span>\n\n<span class=\"c1\"># Modify aspect settings if needed</span>\n<span class=\"n\">custom_aspects</span> <span class=\"o\">=</span> <span class=\"n\">DEFAULT_ACTIVE_ASPECTS</span><span class=\"o\">.</span><span class=\"n\">copy</span><span class=\"p\">()</span>\n<span class=\"c1\"># ... modify as needed</span>\n\n<span class=\"c1\"># The factory automatically uses the configured settings for orb calculations</span>\n<span class=\"c1\"># and filters aspects based on relevance and orb thresholds</span>\n</code></pre>\n</div>\n\n<h2 id=\"ayanamsa-sidereal-modes\">Ayanamsa (Sidereal Modes)</h2>\n\n<p>By default, the zodiac type is <strong>Tropical</strong>. To use <strong>Sidereal</strong>, specify the sidereal mode:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">johnny</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span>\n    <span class=\"s2\">&quot;Johnny Depp&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1963</span><span class=\"p\">,</span> <span class=\"mi\">6</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">,</span>\n    <span class=\"s2\">&quot;Owensboro&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;US&quot;</span><span class=\"p\">,</span>\n    <span class=\"n\">zodiac_type</span><span class=\"o\">=</span><span class=\"s2\">&quot;Sidereal&quot;</span><span class=\"p\">,</span>\n    <span class=\"n\">sidereal_mode</span><span class=\"o\">=</span><span class=\"s2\">&quot;LAHIRI&quot;</span>\n<span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>More examples <a href=\"https://www.kerykeion.net/docs//sidereal-modes/\">here</a>.</p>\n\n<p>Full list of supported sidereal modes <a href=\"https://www.kerykeion.net/pydocs/kerykeion/schemas/kr_literals.html#SiderealMode\">here</a>.</p>\n\n<h2 id=\"house-systems\">House Systems</h2>\n\n<p>By default, houses are calculated using <strong>Placidus</strong>. Configure a different house system as follows:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">johnny</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span>\n    <span class=\"s2\">&quot;Johnny Depp&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1963</span><span class=\"p\">,</span> <span class=\"mi\">6</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">,</span>\n    <span class=\"s2\">&quot;Owensboro&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;US&quot;</span><span class=\"p\">,</span>\n    <span class=\"n\">houses_system</span><span class=\"o\">=</span><span class=\"s2\">&quot;M&quot;</span>\n<span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>More examples <a href=\"https://www.kerykeion.net/docs//houses-systems/\">here</a>.</p>\n\n<p>Full list of supported house systems <a href=\"https://www.kerykeion.net/pydocs/kerykeion/schemas/kr_literals.html#HousesSystem\">here</a>.</p>\n\n<p>So far all the available houses system in the Swiss Ephemeris are supported but the Gauquelin Sectors.</p>\n\n<h2 id=\"perspective-type\">Perspective Type</h2>\n\n<p>By default, Kerykeion uses the <strong>Apparent Geocentric</strong> perspective (the most standard in astrology). Other perspectives (e.g., <strong>Heliocentric</strong>) can be set this way:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">johnny</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span>\n    <span class=\"s2\">&quot;Johnny Depp&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1963</span><span class=\"p\">,</span> <span class=\"mi\">6</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">,</span>\n    <span class=\"s2\">&quot;Owensboro&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;US&quot;</span><span class=\"p\">,</span>\n    <span class=\"n\">perspective_type</span><span class=\"o\">=</span><span class=\"s2\">&quot;Heliocentric&quot;</span>\n<span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>More examples <a href=\"https://www.kerykeion.net/docs//perspective-type/\">here</a>.</p>\n\n<p>Full list of supported perspective types <a href=\"https://www.kerykeion.net/pydocs/kerykeion/schemas/kr_literals.html#PerspectiveType\">here</a>.</p>\n\n<h2 id=\"themes\">Themes</h2>\n\n<p>Kerykeion provides several chart themes:</p>\n\n<ul>\n<li><strong>Classic</strong> (default)</li>\n<li><strong>Dark</strong></li>\n<li><strong>Dark High Contrast</strong></li>\n<li><strong>Light</strong></li>\n</ul>\n\n<p>Each theme offers a distinct visual style, allowing you to choose the one that best suits your preferences or presentation needs. If you prefer more control over the appearance, you can opt not to set any theme, making it easier to customize the chart by overriding the default CSS variables. For more detailed instructions on how to apply themes, check the <a href=\"https://www.kerykeion.net/docs/theming\">documentation</a></p>\n\n<p>Here's an example of how to set the theme:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"p\">,</span> <span class=\"n\">ChartDrawer</span>\n\n<span class=\"n\">dark_theme_subject</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;John Lennon - Dark Theme&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1940</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">dark_theme_natal_chart</span> <span class=\"o\">=</span> <span class=\"n\">ChartDrawer</span><span class=\"p\">(</span><span class=\"n\">dark_theme_subject</span><span class=\"p\">,</span> <span class=\"n\">theme</span><span class=\"o\">=</span><span class=\"s2\">&quot;dark_high_contrast&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">dark_theme_natal_chart</span><span class=\"o\">.</span><span class=\"n\">makeSVG</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p><img src=\"https://www.kerykeion.net/img/showcase/John%20Lennon%20-%20Dark%20-%20Natal%20Chart.svg\" alt=\"John Lennon\" /></p>\n\n<h2 id=\"alternative-initialization\">Alternative Initialization</h2>\n\n<p>Create an <code>AstrologicalSubject</code> from a UTC ISO 8601 string:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">subject</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubject</span><span class=\"o\">.</span><span class=\"n\">get_from_iso_utc_time</span><span class=\"p\">(</span>\n    <span class=\"s2\">&quot;Johnny Depp&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;1963-06-09T05:00:00Z&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Owensboro&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;US&quot;</span>\n<span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>If you set <code>online=True</code>, provide a <code>geonames_username</code> to allow city-based geolocation:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion.astrological_subject</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">AstrologicalSubjectFactory</span>\n\n<span class=\"n\">subject</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubject</span><span class=\"o\">.</span><span class=\"n\">get_from_iso_utc_time</span><span class=\"p\">(</span>\n    <span class=\"s2\">&quot;Johnny Depp&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;1963-06-09T05:00:00Z&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Owensboro&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;US&quot;</span><span class=\"p\">,</span> <span class=\"n\">online</span><span class=\"o\">=</span><span class=\"kc\">True</span>\n<span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<h2 id=\"lunar-nodes-rahu-ketu\">Lunar Nodes (Rahu &amp; Ketu)</h2>\n\n<p>Kerykeion supports both <strong>True</strong> and <strong>Mean</strong> Lunar Nodes:</p>\n\n<ul>\n<li><strong>True North Lunar Node</strong>: <code>\"true_node\"</code> (name kept without \"north\" for backward compatibility).</li>\n<li><strong>True South Lunar Node</strong>: <code>\"true_south_node\"</code>.</li>\n<li><strong>Mean North Lunar Node</strong>: <code>\"mean_node\"</code> (name kept without \"north\" for backward compatibility).</li>\n<li><strong>Mean South Lunar Node</strong>: <code>\"mean_south_node\"</code>.</li>\n</ul>\n\n<p>In instances of the classes used to generate aspects and SVG charts, only the mean nodes are active. To activate the true nodes, you need to pass the <code>active_points</code> parameter to the <code>ChartDrawer</code> class.</p>\n\n<p>Example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"p\">,</span> <span class=\"n\">ChartDrawer</span>\n\n<span class=\"n\">subject</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;John Lennon&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1940</span><span class=\"p\">,</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Liverpool&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;GB&quot;</span><span class=\"p\">)</span>\n\n<span class=\"n\">chart</span> <span class=\"o\">=</span> <span class=\"n\">ChartDrawer</span><span class=\"p\">(</span>\n    <span class=\"n\">subject</span><span class=\"p\">,</span>\n    <span class=\"n\">active_points</span><span class=\"o\">=</span><span class=\"p\">[</span>\n        <span class=\"s2\">&quot;Sun&quot;</span><span class=\"p\">,</span> \n        <span class=\"s2\">&quot;Moon&quot;</span><span class=\"p\">,</span> \n        <span class=\"s2\">&quot;Mercury&quot;</span><span class=\"p\">,</span> \n        <span class=\"s2\">&quot;Venus&quot;</span><span class=\"p\">,</span> \n        <span class=\"s2\">&quot;Mars&quot;</span><span class=\"p\">,</span> \n        <span class=\"s2\">&quot;Jupiter&quot;</span><span class=\"p\">,</span> \n        <span class=\"s2\">&quot;Saturn&quot;</span><span class=\"p\">,</span>\n        <span class=\"s2\">&quot;Uranus&quot;</span><span class=\"p\">,</span> \n        <span class=\"s2\">&quot;Neptune&quot;</span><span class=\"p\">,</span> \n        <span class=\"s2\">&quot;Pluto&quot;</span><span class=\"p\">,</span> \n        <span class=\"s2\">&quot;Mean_Node&quot;</span><span class=\"p\">,</span> \n        <span class=\"s2\">&quot;Mean_South_Node&quot;</span><span class=\"p\">,</span> \n        <span class=\"s2\">&quot;True_Node&quot;</span><span class=\"p\">,</span>       <span class=\"c1\"># Activates True North Node </span>\n        <span class=\"s2\">&quot;True_South_Node&quot;</span><span class=\"p\">,</span> <span class=\"c1\"># Activates True South Node</span>\n        <span class=\"s2\">&quot;Ascendant&quot;</span><span class=\"p\">,</span>\n        <span class=\"s2\">&quot;Medium_Coeli&quot;</span><span class=\"p\">,</span> \n        <span class=\"s2\">&quot;Descendant&quot;</span><span class=\"p\">,</span> \n        <span class=\"s2\">&quot;Imum_Coeli&quot;</span>\n    <span class=\"p\">]</span>\n<span class=\"p\">)</span>\n<span class=\"n\">chart</span><span class=\"o\">.</span><span class=\"n\">makeSVG</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<h2 id=\"json-support\">JSON Support</h2>\n\n<p>You can serialize the astrological subject (the base data used throughout the library) to JSON:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">kerykeion</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">AstrologicalSubjectFactory</span>\n\n<span class=\"n\">johnny</span> <span class=\"o\">=</span> <span class=\"n\">AstrologicalSubjectFactory</span><span class=\"o\">.</span><span class=\"n\">from_birth_data</span><span class=\"p\">(</span><span class=\"s2\">&quot;Johnny Depp&quot;</span><span class=\"p\">,</span> <span class=\"mi\">1963</span><span class=\"p\">,</span> <span class=\"mi\">6</span><span class=\"p\">,</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Owensboro&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;US&quot;</span><span class=\"p\">)</span>\n\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">johnny</span><span class=\"o\">.</span><span class=\"n\">json</span><span class=\"p\">(</span><span class=\"n\">dump</span><span class=\"o\">=</span><span class=\"kc\">False</span><span class=\"p\">,</span> <span class=\"n\">indent</span><span class=\"o\">=</span><span class=\"mi\">2</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<h2 id=\"auto-generated-documentation\">Auto Generated Documentation</h2>\n\n<p>You can find auto-generated documentation <a href=\"https://www.kerykeion.net/pydocs/kerykeion.html\">here</a>. Most classes and functions include docstrings.</p>\n\n<h2 id=\"development\">Development</h2>\n\n<p>Clone the repository or download the ZIP via the GitHub interface.</p>\n\n<h2 id=\"integrating-kerykeion-into-your-project\">Integrating Kerykeion into Your Project</h2>\n\n<p>If you would like to incorporate Kerykeion's astrological features into your application, please reach out via <a href=\"mailto:kerykeion.astrology@gmail.com?subject=Integration%20Request\">email</a>. Whether you need custom features, support, or specialized consulting, I am happy to discuss potential collaborations.</p>\n\n<h2 id=\"license\">License</h2>\n\n<p>This project is covered under the AGPL-3.0 License. For detailed information, please see the <a href=\"LICENSE\">LICENSE</a> file. If you have questions, feel free to contact me at <a href=\"mailto:kerykeion.astrology@gmail.com?subject=Kerykeion\">kerykeion.astrology@gmail.com</a>.</p>\n\n<p>As a rule of thumb, if you use this library in a project, you should open-source that project under a compatible license. Alternatively, if you wish to keep your source closed, consider using the <a href=\"https://rapidapi.com/gbattaglia/api/astrologer/\">AstrologerAPI</a>, which is AGPL-3.0 compliant and also helps support the project.</p>\n\n<p>Since the AstrologerAPI is an external third-party service, using it does <em>not</em> require your code to be open-source.</p>\n\n<h2 id=\"contributing\">Contributing</h2>\n\n<p>Contributions are welcome! Feel free to submit pull requests or report issues.</p>\n\n<h2 id=\"citations\">Citations</h2>\n\n<p>If using Kerykeion in published or academic work, please cite as follows:</p>\n\n<pre><code>Battaglia, G. (2025). Kerykeion: A Python Library for Astrological Calculations and Chart Generation.\nhttps://github.com/g-battaglia/kerykeion\n</code></pre>\n"}, "kerykeion.AspectsFactory": {"fullname": "kerykeion.AspectsFactory", "modulename": "kerykeion", "qualname": "AspectsFactory", "kind": "class", "doc": "<p>Unified factory class for creating both single chart and dual chart aspects analysis.</p>\n\n<p>This factory provides methods to calculate all aspects within a single chart or\nbetween two charts. It consolidates the common functionality between different\ntypes of aspect calculations while providing specialized methods for each type.</p>\n\n<p>The factory provides both comprehensive and filtered aspect lists based on orb settings\nand relevance criteria.</p>\n\n<p>Key Features:\n    - Calculates aspects within a single chart (natal, returns, composite, etc.)\n    - Calculates aspects between two charts (synastry, transits, comparisons, etc.)\n    - Filters aspects based on orb thresholds\n    - Applies stricter orb limits for chart axes (ASC, MC, DSC, IC)\n    - Supports multiple subject types (natal, composite, planetary returns)</p>\n\n<p>Example:</p>\n\n<blockquote>\n  <blockquote>\n    <blockquote>\n      <h1 id=\"for-single-chart-aspects-natal-returns-etc\">For single chart aspects (natal, returns, etc.)</h1>\n      \n      <p>johnny = AstrologicalSubjectFactory.from_birth_data(\"Johnny\", 1963, 6, 9, 0, 0, \"Owensboro\", \"US\")\n      single_chart_aspects = AspectsFactory.single_chart_aspects(johnny)</p>\n      \n      <h1 id=\"for-dual-chart-aspects-synastry-comparisons-etc\">For dual chart aspects (synastry, comparisons, etc.)</h1>\n      \n      <p>john = AstrologicalSubjectFactory.from_birth_data(\"John\", 1990, 1, 1, 12, 0, \"London\", \"GB\")\n      jane = AstrologicalSubjectFactory.from_birth_data(\"Jane\", 1992, 6, 15, 14, 30, \"Paris\", \"FR\")\n      dual_chart_aspects = AspectsFactory.dual_chart_aspects(john, jane)</p>\n    </blockquote>\n  </blockquote>\n</blockquote>\n"}, "kerykeion.AspectsFactory.single_chart_aspects": {"fullname": "kerykeion.AspectsFactory.single_chart_aspects", "modulename": "kerykeion", "qualname": "AspectsFactory.single_chart_aspects", "kind": "function", "doc": "<p>Create aspects analysis for a single astrological chart.</p>\n\n<p>This method calculates all astrological aspects (angular relationships)\nwithin a single chart. Can be used for any type of chart including:</p>\n\n<ul>\n<li>Natal charts</li>\n<li>Planetary return charts</li>\n<li>Composite charts</li>\n<li>Any other single chart type</li>\n</ul>\n\n<p>Args:\n    subject: The astrological subject for aspect calculation</p>\n\n<p>Kwargs:\n    active_points: List of points to include in calculations\n    active_aspects: List of aspects with their orb settings</p>\n\n<p>Returns:\n    SingleChartAspectsModel containing all calculated aspects data</p>\n\n<p>Example:</p>\n\n<blockquote>\n  <blockquote>\n    <blockquote>\n      <p>johnny = AstrologicalSubjectFactory.from_birth_data(\"Johnny\", 1963, 6, 9, 0, 0, \"Owensboro\", \"US\")\n      chart_aspects = AspectsFactory.single_chart_aspects(johnny)\n      print(f\"Found {len(chart_aspects.relevant_aspects)} relevant aspects\")</p>\n    </blockquote>\n  </blockquote>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">subject</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">CompositeSubjectModel</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">PlanetReturnModel</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">active_points</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Sun&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Moon&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mercury&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Venus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mars&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Jupiter&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Saturn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Uranus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Neptune&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pluto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Chiron&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Earth&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pholus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ceres&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pallas&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Juno&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vesta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Eris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Sedna&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Haumea&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Makemake&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ixion&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Orcus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Quaoar&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Regulus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Spica&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fortunae&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Spiritus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Amoris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fidei&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Anti_Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ascendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Medium_Coeli&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Descendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Imum_Coeli&#39;</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">active_aspects</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">ActiveAspect</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">SingleChartAspectsModel</span>:</span></span>", "funcdef": "def"}, "kerykeion.AspectsFactory.dual_chart_aspects": {"fullname": "kerykeion.AspectsFactory.dual_chart_aspects", "modulename": "kerykeion", "qualname": "AspectsFactory.dual_chart_aspects", "kind": "function", "doc": "<p>Create aspects analysis between two astrological charts.</p>\n\n<p>This method calculates all astrological aspects (angular relationships)\nbetween planets and points in two different charts. Can be used for:</p>\n\n<ul>\n<li>Synastry (relationship compatibility)</li>\n<li>Transit comparisons</li>\n<li>Composite vs natal comparisons</li>\n<li>Any other dual chart analysis</li>\n</ul>\n\n<p>Args:\n    first_subject: The first astrological subject\n    second_subject: The second astrological subject to compare with the first</p>\n\n<p>Kwargs:\n    active_points: Optional list of celestial points to include in calculations.\n                  If None, uses common points between both subjects.\n    active_aspects: Optional list of aspect types with their orb settings.\n                   If None, uses default aspect configuration.</p>\n\n<p>Returns:\n    DualChartAspectsModel: Complete model containing all calculated aspects data,\n                          including both comprehensive and filtered relevant aspects.</p>\n\n<p>Example:</p>\n\n<blockquote>\n  <blockquote>\n    <blockquote>\n      <p>john = AstrologicalSubjectFactory.from_birth_data(\"John\", 1990, 1, 1, 12, 0, \"London\", \"GB\")\n      jane = AstrologicalSubjectFactory.from_birth_data(\"Jane\", 1992, 6, 15, 14, 30, \"Paris\", \"FR\")\n      synastry = AspectsFactory.dual_chart_aspects(john, jane)\n      print(f\"Found {len(synastry.relevant_aspects)} relevant aspects\")</p>\n    </blockquote>\n  </blockquote>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">first_subject</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">CompositeSubjectModel</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">PlanetReturnModel</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">second_subject</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">CompositeSubjectModel</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">PlanetReturnModel</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">active_points</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Sun&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Moon&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mercury&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Venus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mars&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Jupiter&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Saturn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Uranus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Neptune&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pluto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Chiron&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Earth&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pholus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ceres&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pallas&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Juno&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vesta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Eris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Sedna&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Haumea&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Makemake&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ixion&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Orcus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Quaoar&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Regulus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Spica&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fortunae&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Spiritus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Amoris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fidei&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Anti_Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ascendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Medium_Coeli&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Descendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Imum_Coeli&#39;</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">active_aspects</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">ActiveAspect</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">DualChartAspectsModel</span>:</span></span>", "funcdef": "def"}, "kerykeion.AspectsFactory.natal_aspects": {"fullname": "kerykeion.AspectsFactory.natal_aspects", "modulename": "kerykeion", "qualname": "AspectsFactory.natal_aspects", "kind": "function", "doc": "<p>Legacy method - use single_chart_aspects() instead.</p>\n\n<p>\u26a0\ufe0f  DEPRECATION WARNING \u26a0\ufe0f\nThis method is deprecated. Use AspectsFactory.single_chart_aspects() instead.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">subject</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">CompositeSubjectModel</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">PlanetReturnModel</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">active_points</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Sun&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Moon&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mercury&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Venus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mars&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Jupiter&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Saturn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Uranus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Neptune&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pluto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Chiron&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Earth&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pholus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ceres&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pallas&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Juno&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vesta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Eris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Sedna&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Haumea&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Makemake&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ixion&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Orcus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Quaoar&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Regulus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Spica&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fortunae&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Spiritus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Amoris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fidei&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Anti_Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ascendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Medium_Coeli&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Descendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Imum_Coeli&#39;</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">active_aspects</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">ActiveAspect</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">SingleChartAspectsModel</span>:</span></span>", "funcdef": "def"}, "kerykeion.AspectsFactory.synastry_aspects": {"fullname": "kerykeion.AspectsFactory.synastry_aspects", "modulename": "kerykeion", "qualname": "AspectsFactory.synastry_aspects", "kind": "function", "doc": "<p>Legacy method - use dual_chart_aspects() instead.</p>\n\n<p>\u26a0\ufe0f  DEPRECATION WARNING \u26a0\ufe0f\nThis method is deprecated. Use AspectsFactory.dual_chart_aspects() instead.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">first_subject</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">CompositeSubjectModel</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">PlanetReturnModel</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">second_subject</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">CompositeSubjectModel</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">PlanetReturnModel</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">active_points</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Sun&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Moon&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mercury&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Venus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mars&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Jupiter&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Saturn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Uranus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Neptune&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pluto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Chiron&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Earth&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pholus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ceres&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pallas&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Juno&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vesta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Eris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Sedna&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Haumea&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Makemake&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ixion&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Orcus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Quaoar&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Regulus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Spica&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fortunae&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Spiritus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Amoris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fidei&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Anti_Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ascendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Medium_Coeli&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Descendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Imum_Coeli&#39;</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">active_aspects</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">ActiveAspect</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">DualChartAspectsModel</span>:</span></span>", "funcdef": "def"}, "kerykeion.AstrologicalSubjectFactory": {"fullname": "kerykeion.AstrologicalSubjectFactory", "modulename": "kerykeion", "qualname": "AstrologicalSubjectFactory", "kind": "class", "doc": "<p>Factory class for creating comprehensive astrological subjects.</p>\n\n<p>This factory creates AstrologicalSubjectModel instances with complete astrological\ninformation including planetary positions, house cusps, aspects, lunar phases, and\nvarious specialized astrological points. It provides multiple class methods for\ndifferent initialization scenarios and supports both online and offline calculation modes.</p>\n\n<p>The factory handles complex astrological calculations using the Swiss Ephemeris library,\nsupports multiple coordinate systems and house systems, and can automatically fetch\nlocation data from online sources.</p>\n\n<p>Supported Astrological Points:\n    - Traditional Planets: Sun through Pluto\n    - Lunar Nodes: Mean and True North/South Nodes\n    - Lilith Points: Mean and True Black Moon\n    - Asteroids: Ceres, Pallas, Juno, Vesta\n    - Centaurs: Chiron, Pholus\n    - Trans-Neptunian Objects: Eris, Sedna, Haumea, Makemake, Ixion, Orcus, Quaoar\n    - Fixed Stars: Regulus, Spica (extensible)\n    - Arabic Parts: Pars Fortunae, Pars Spiritus, Pars Amoris, Pars Fidei\n    - Special Points: Vertex, Anti-Vertex, Earth (for heliocentric charts)\n    - House Cusps: All 12 houses with configurable house systems\n    - Angles: Ascendant, Medium Coeli, Descendant, Imum Coeli</p>\n\n<p>Supported Features:\n    - Multiple zodiac systems (Tropical/Sidereal with various ayanamshas)\n    - Multiple house systems (Placidus, Koch, Equal, Whole Sign, etc.)\n    - Multiple coordinate perspectives (Geocentric, Heliocentric, Topocentric)\n    - Automatic timezone and coordinate resolution via GeoNames API\n    - Lunar phase calculations\n    - Day/night chart detection for Arabic parts\n    - Performance optimization through selective point calculation\n    - Comprehensive error handling and validation</p>\n\n<p>Class Methods:\n    from_birth_data: Create subject from standard birth data (most flexible)\n    from_iso_utc_time: Create subject from ISO UTC timestamp\n    from_current_time: Create subject for current moment</p>\n\n<p>Example:</p>\n\n<blockquote>\n  <blockquote>\n    <blockquote>\n      <h1 id=\"create-natal-chart\">Create natal chart</h1>\n      \n      <p>subject = AstrologicalSubjectFactory.from_birth_data(\n          ...     name=\"John Doe\",\n          ...     year=1990, month=6, day=15,\n          ...     hour=14, minute=30,\n          ...     city=\"Rome\", nation=\"IT\",\n          ...     online=True\n          ... )\n      print(f\"Sun: {subject.sun.sign} {subject.sun.abs_pos}\u00b0\")\n      print(f\"Active points: {len(subject.active_points)}\")</p>\n\n<pre><code>&gt;&gt;&gt; # Create chart for current time\n&gt;&gt;&gt; now_subject = AstrologicalSubjectFactory.from_current_time(\n...     name=\"Current Moment\",\n...     city=\"London\", nation=\"GB\"\n... )\n</code></pre>\n      \n      <p>Thread Safety:\n          This factory is not thread-safe due to its use of the Swiss Ephemeris library\n          which maintains global state. Use separate instances in multi-threaded applications\n          or implement appropriate locking mechanisms.</p>\n    </blockquote>\n  </blockquote>\n</blockquote>\n"}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"fullname": "kerykeion.AstrologicalSubjectFactory.from_birth_data", "modulename": "kerykeion", "qualname": "AstrologicalSubjectFactory.from_birth_data", "kind": "function", "doc": "<p>Create an astrological subject from standard birth or event data.</p>\n\n<p>This is the most flexible and commonly used factory method. It creates a complete\nastrological subject with planetary positions, house cusps, and specialized points\nfor a specific date, time, and location. Supports both online location resolution\nand offline calculation modes.</p>\n\n<p>Args:\n    name (str, optional): Name or identifier for the subject. Defaults to \"Now\".\n    year (int, optional): Year of birth/event. Defaults to current year.\n    month (int, optional): Month of birth/event (1-12). Defaults to current month.\n    day (int, optional): Day of birth/event (1-31). Defaults to current day.\n    hour (int, optional): Hour of birth/event (0-23). Defaults to current hour.\n    minute (int, optional): Minute of birth/event (0-59). Defaults to current minute.\n    seconds (int, optional): Seconds of birth/event (0-59). Defaults to 0.\n    city (str, optional): City name for location lookup. Used with online=True.\n        Defaults to None (Greenwich if not specified).\n    nation (str, optional): ISO country code (e.g., 'US', 'GB', 'IT'). Used with\n        online=True. Defaults to None ('GB' if not specified).\n    lng (float, optional): Longitude in decimal degrees. East is positive, West\n        is negative. If not provided and online=True, fetched from GeoNames.\n    lat (float, optional): Latitude in decimal degrees. North is positive, South\n        is negative. If not provided and online=True, fetched from GeoNames.\n    tz_str (str, optional): IANA timezone identifier (e.g., 'Europe/London').\n        If not provided and online=True, fetched from GeoNames.\n    geonames_username (str, optional): Username for GeoNames API. Required for\n        online location lookup. Get one free at geonames.org.\n    online (bool, optional): Whether to fetch location data online. If False,\n        lng, lat, and tz_str must be provided. Defaults to True.\n    zodiac_type (ZodiacType, optional): Zodiac system - 'Tropic' or 'Sidereal'.\n        Defaults to 'Tropic'.\n    sidereal_mode (SiderealMode, optional): Sidereal calculation mode (e.g.,\n        'FAGAN_BRADLEY', 'LAHIRI'). Only used with zodiac_type='Sidereal'.\n    houses_system_identifier (HousesSystemIdentifier, optional): House system\n        for cusp calculations (e.g., 'P'=Placidus, 'K'=Koch, 'E'=Equal).\n        Defaults to 'P' (Placidus).\n    perspective_type (PerspectiveType, optional): Calculation perspective:\n        - 'Apparent Geocentric': Standard geocentric with light-time correction\n        - 'True Geocentric': Geometric geocentric positions\n        - 'Heliocentric': Sun-centered coordinates\n        - 'Topocentric': Earth surface perspective (requires altitude)\n        Defaults to 'Apparent Geocentric'.\n    cache_expire_after_days (int, optional): Days to cache GeoNames data locally.\n        Defaults to 30.\n    is_dst (bool, optional): Daylight Saving Time flag for ambiguous times.\n        If None, pytz attempts automatic detection. Set explicitly for\n        times during DST transitions.\n    altitude (float, optional): Altitude above sea level in meters. Used for\n        topocentric calculations and atmospheric corrections. Defaults to None\n        (sea level assumed).\n    active_points (List[AstrologicalPoint], optional): List of astrological\n        points to calculate. Omitting points can improve performance for\n        specialized applications. Defaults to DEFAULT_ACTIVE_POINTS.\n    calculate_lunar_phase (bool, optional): Whether to calculate lunar phase.\n        Requires Sun and Moon in active_points. Defaults to True.</p>\n\n<p>Returns:\n    AstrologicalSubjectModel: Complete astrological subject with calculated\n        positions, houses, and metadata. Access planetary positions via\n        attributes like .sun, .moon, .mercury, etc.</p>\n\n<p>Raises:\n    KerykeionException:\n        - If offline mode is used without required location data\n        - If invalid zodiac/sidereal mode combinations are specified\n        - If GeoNames data is missing or invalid\n        - If timezone localization fails (ambiguous DST times)</p>\n\n<p>Examples:</p>\n\n<blockquote>\n  <blockquote>\n    <blockquote>\n      <h1 id=\"basic-natal-chart-with-online-location-lookup\">Basic natal chart with online location lookup</h1>\n      \n      <p>chart = AstrologicalSubjectFactory.from_birth_data(\n          ...     name=\"Jane Doe\",\n          ...     year=1985, month=3, day=21,\n          ...     hour=15, minute=30,\n          ...     city=\"Paris\", nation=\"FR\",\n          ...     geonames_username=\"your_username\"\n          ... )</p>\n\n<pre><code>&gt;&gt;&gt; # Offline calculation with manual coordinates\n&gt;&gt;&gt; chart = AstrologicalSubjectFactory.from_birth_data(\n...     name=\"John Smith\",\n...     year=1990, month=12, day=25,\n...     hour=0, minute=0,\n...     lng=-74.006, lat=40.7128, tz_str=\"America/New_York\",\n...     online=False\n... )\n\n&gt;&gt;&gt; # Sidereal chart with specific points\n&gt;&gt;&gt; chart = AstrologicalSubjectFactory.from_birth_data(\n...     name=\"Vedic Chart\",\n...     year=2000, month=6, day=15, hour=12,\n...     city=\"Mumbai\", nation=\"IN\",\n...     zodiac_type=\"Sidereal\",\n...     sidereal_mode=\"LAHIRI\",\n...     active_points=[\"Sun\", \"Moon\", \"Mercury\", \"Venus\", \"Mars\",\n...                   \"Jupiter\", \"Saturn\", \"Ascendant\"]\n... )\n</code></pre>\n      \n      <p>Note:\n          - For high-precision calculations, consider providing seconds parameter\n          - Use topocentric perspective for observer-specific calculations\n          - Some Arabic parts automatically activate required base points\n          - The method handles polar regions by adjusting extreme latitudes\n          - Time zones are handled with full DST awareness via pytz</p>\n    </blockquote>\n  </blockquote>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;Now&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">year</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">2025</span>,</span><span class=\"param\">\t<span class=\"n\">month</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8</span>,</span><span class=\"param\">\t<span class=\"n\">day</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">19</span>,</span><span class=\"param\">\t<span class=\"n\">hour</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">14</span>,</span><span class=\"param\">\t<span class=\"n\">minute</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">39</span>,</span><span class=\"param\">\t<span class=\"n\">city</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">nation</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lng</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lat</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">tz_str</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">geonames_username</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">online</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">zodiac_type</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Tropic&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Sidereal&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;Tropic&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">sidereal_mode</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;FAGAN_BRADLEY&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;LAHIRI&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;DELUCE&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;RAMAN&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;USHASHASHI&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;KRISHNAMURTI&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;DJWHAL_KHUL&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;YUKTESHWAR&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;JN_BHASIN&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_KUGLER1&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_KUGLER2&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_KUGLER3&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_HUBER&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_ETPSC&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ALDEBARAN_15TAU&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;HIPPARCHOS&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;SASSANIAN&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;J2000&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;J1900&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;B1950&#39;</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">houses_system_identifier</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;A&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;B&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;C&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;D&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;F&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;H&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;I&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;i&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;K&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;L&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;M&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;N&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;O&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;P&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Q&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;R&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;S&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;T&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;U&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;V&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;W&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;X&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Y&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;P&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">perspective_type</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Apparent Geocentric&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Heliocentric&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Topocentric&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True Geocentric&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;Apparent Geocentric&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">cache_expire_after_days</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">30</span>,</span><span class=\"param\">\t<span class=\"n\">is_dst</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">altitude</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">active_points</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Sun&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Moon&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mercury&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Venus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mars&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Jupiter&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Saturn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Uranus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Neptune&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pluto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Chiron&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Earth&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pholus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ceres&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pallas&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Juno&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vesta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Eris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Sedna&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Haumea&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Makemake&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ixion&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Orcus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Quaoar&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Regulus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Spica&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fortunae&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Spiritus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Amoris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fidei&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Anti_Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ascendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Medium_Coeli&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Descendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Imum_Coeli&#39;</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"p\">[</span><span class=\"s1\">&#39;Sun&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Moon&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mercury&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Venus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mars&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Jupiter&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Saturn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Uranus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Neptune&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pluto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Chiron&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ascendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Medium_Coeli&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Descendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Imum_Coeli&#39;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">calculate_lunar_phase</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">seconds</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span>:</span></span>", "funcdef": "def"}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"fullname": "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time", "modulename": "kerykeion", "qualname": "AstrologicalSubjectFactory.from_iso_utc_time", "kind": "function", "doc": "<p>Create an astrological subject from an ISO formatted UTC timestamp.</p>\n\n<p>This method is ideal for creating astrological subjects from standardized\ntime formats, such as those stored in databases or received from APIs.\nIt automatically handles timezone conversion from UTC to the specified\nlocal timezone.</p>\n\n<p>Args:\n    name (str): Name or identifier for the subject.\n    iso_utc_time (str): ISO 8601 formatted UTC timestamp. Supported formats:\n        - \"2023-06-15T14:30:00Z\" (with Z suffix)\n        - \"2023-06-15T14:30:00+00:00\" (with UTC offset)\n        - \"2023-06-15T14:30:00.123Z\" (with milliseconds)\n    city (str, optional): City name for location. Defaults to \"Greenwich\".\n    nation (str, optional): ISO country code. Defaults to \"GB\".\n    tz_str (str, optional): IANA timezone identifier for result conversion.\n        The ISO time is assumed to be in UTC and will be converted to this\n        timezone. Defaults to \"Etc/GMT\".\n    online (bool, optional): Whether to fetch coordinates online. If True,\n        coordinates are fetched via GeoNames API. Defaults to True.\n    lng (float, optional): Longitude in decimal degrees. Used when online=False\n        or as fallback. Defaults to 0.0 (Greenwich).\n    lat (float, optional): Latitude in decimal degrees. Used when online=False\n        or as fallback. Defaults to 51.5074 (Greenwich).\n    geonames_username (str, optional): GeoNames API username. Required when\n        online=True. Defaults to DEFAULT_GEONAMES_USERNAME.\n    zodiac_type (ZodiacType, optional): Zodiac system. Defaults to 'Tropic'.\n    sidereal_mode (SiderealMode, optional): Sidereal mode when zodiac_type\n        is 'Sidereal'. Defaults to None.\n    houses_system_identifier (HousesSystemIdentifier, optional): House system.\n        Defaults to 'P' (Placidus).\n    perspective_type (PerspectiveType, optional): Calculation perspective.\n        Defaults to 'Apparent Geocentric'.\n    altitude (float, optional): Altitude in meters for topocentric calculations.\n        Defaults to None (sea level).\n    active_points (List[AstrologicalPoint], optional): Points to calculate.\n        Defaults to DEFAULT_ACTIVE_POINTS.\n    calculate_lunar_phase (bool, optional): Whether to calculate lunar phase.\n        Defaults to True.</p>\n\n<p>Returns:\n    AstrologicalSubjectModel: Astrological subject with positions calculated\n        for the specified UTC time converted to local timezone.</p>\n\n<p>Raises:\n    ValueError: If the ISO timestamp format is invalid or cannot be parsed.\n    KerykeionException: If location data cannot be fetched or is invalid.</p>\n\n<p>Examples:</p>\n\n<blockquote>\n  <blockquote>\n    <blockquote>\n      <h1 id=\"from-api-timestamp-with-online-location-lookup\">From API timestamp with online location lookup</h1>\n      \n      <p>subject = AstrologicalSubjectFactory.from_iso_utc_time(\n          ...     name=\"Event Chart\",\n          ...     iso_utc_time=\"2023-12-25T12:00:00Z\",\n          ...     city=\"Tokyo\", nation=\"JP\",\n          ...     tz_str=\"Asia/Tokyo\",\n          ...     geonames_username=\"your_username\"\n          ... )</p>\n\n<pre><code>&gt;&gt;&gt; # From database timestamp with manual coordinates\n&gt;&gt;&gt; subject = AstrologicalSubjectFactory.from_iso_utc_time(\n...     name=\"Historical Event\",\n...     iso_utc_time=\"1969-07-20T20:17:00Z\",\n...     lng=-95.0969, lat=37.4419,  # Houston\n...     tz_str=\"America/Chicago\",\n...     online=False\n... )\n</code></pre>\n      \n      <p>Note:\n          - The method assumes the input timestamp is in UTC\n          - Local time conversion respects DST rules for the target timezone\n          - Milliseconds in the timestamp are supported but truncated to seconds\n          - When online=True, the city/nation parameters override lng/lat</p>\n    </blockquote>\n  </blockquote>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">iso_utc_time</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">city</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;Greenwich&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">nation</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;GB&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">tz_str</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;Etc/GMT&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">online</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">lng</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.0</span>,</span><span class=\"param\">\t<span class=\"n\">lat</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">51.5074</span>,</span><span class=\"param\">\t<span class=\"n\">geonames_username</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;century.boy&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">zodiac_type</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Tropic&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Sidereal&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;Tropic&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">sidereal_mode</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;FAGAN_BRADLEY&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;LAHIRI&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;DELUCE&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;RAMAN&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;USHASHASHI&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;KRISHNAMURTI&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;DJWHAL_KHUL&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;YUKTESHWAR&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;JN_BHASIN&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_KUGLER1&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_KUGLER2&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_KUGLER3&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_HUBER&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_ETPSC&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ALDEBARAN_15TAU&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;HIPPARCHOS&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;SASSANIAN&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;J2000&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;J1900&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;B1950&#39;</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">houses_system_identifier</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;A&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;B&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;C&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;D&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;F&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;H&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;I&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;i&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;K&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;L&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;M&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;N&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;O&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;P&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Q&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;R&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;S&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;T&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;U&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;V&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;W&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;X&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Y&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;P&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">perspective_type</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Apparent Geocentric&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Heliocentric&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Topocentric&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True Geocentric&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;Apparent Geocentric&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">altitude</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">active_points</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Sun&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Moon&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mercury&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Venus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mars&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Jupiter&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Saturn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Uranus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Neptune&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pluto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Chiron&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Earth&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pholus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ceres&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pallas&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Juno&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vesta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Eris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Sedna&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Haumea&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Makemake&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ixion&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Orcus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Quaoar&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Regulus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Spica&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fortunae&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Spiritus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Amoris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fidei&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Anti_Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ascendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Medium_Coeli&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Descendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Imum_Coeli&#39;</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"p\">[</span><span class=\"s1\">&#39;Sun&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Moon&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mercury&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Venus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mars&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Jupiter&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Saturn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Uranus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Neptune&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pluto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Chiron&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ascendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Medium_Coeli&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Descendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Imum_Coeli&#39;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">calculate_lunar_phase</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span>:</span></span>", "funcdef": "def"}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"fullname": "kerykeion.AstrologicalSubjectFactory.from_current_time", "modulename": "kerykeion", "qualname": "AstrologicalSubjectFactory.from_current_time", "kind": "function", "doc": "<p>Create an astrological subject for the current moment in time.</p>\n\n<p>This convenience method creates a \"now\" chart, capturing the current\nastrological conditions at the moment of execution. Useful for horary\nastrology, electional astrology, or real-time astrological monitoring.</p>\n\n<p>Args:\n    name (str, optional): Name for the current moment chart.\n        Defaults to \"Now\".\n    city (str, optional): City name for location lookup. If not provided\n        and online=True, defaults to Greenwich.\n    nation (str, optional): ISO country code. If not provided and\n        online=True, defaults to 'GB'.\n    lng (float, optional): Longitude in decimal degrees. If not provided\n        and online=True, fetched from GeoNames API.\n    lat (float, optional): Latitude in decimal degrees. If not provided\n        and online=True, fetched from GeoNames API.\n    tz_str (str, optional): IANA timezone identifier. If not provided\n        and online=True, fetched from GeoNames API.\n    geonames_username (str, optional): GeoNames API username for location\n        lookup. Required when online=True and location is not fully specified.\n    online (bool, optional): Whether to fetch location data online.\n        Defaults to True.\n    zodiac_type (ZodiacType, optional): Zodiac system to use.\n        Defaults to 'Tropic'.\n    sidereal_mode (SiderealMode, optional): Sidereal calculation mode.\n        Only used when zodiac_type is 'Sidereal'. Defaults to None.\n    houses_system_identifier (HousesSystemIdentifier, optional): House\n        system for calculations. Defaults to 'P' (Placidus).\n    perspective_type (PerspectiveType, optional): Calculation perspective.\n        Defaults to 'Apparent Geocentric'.\n    active_points (List[AstrologicalPoint], optional): Astrological points\n        to calculate. Defaults to DEFAULT_ACTIVE_POINTS.\n    calculate_lunar_phase (bool, optional): Whether to calculate lunar phase.\n        Defaults to True.</p>\n\n<p>Returns:\n    AstrologicalSubjectModel: Astrological subject representing current\n        astrological conditions at the specified or default location.</p>\n\n<p>Raises:\n    KerykeionException: If online location lookup fails or if offline mode\n        is used without sufficient location data.</p>\n\n<p>Examples:</p>\n\n<blockquote>\n  <blockquote>\n    <blockquote>\n      <h1 id=\"current-moment-for-your-location\">Current moment for your location</h1>\n      \n      <p>now_chart = AstrologicalSubjectFactory.from_current_time(\n          ...     name=\"Current Transits\",\n          ...     city=\"New York\", nation=\"US\",\n          ...     geonames_username=\"your_username\"\n          ... )</p>\n\n<pre><code>&gt;&gt;&gt; # Horary chart with specific coordinates\n&gt;&gt;&gt; horary = AstrologicalSubjectFactory.from_current_time(\n...     name=\"Horary Question\",\n...     lng=-0.1278, lat=51.5074,  # London\n...     tz_str=\"Europe/London\",\n...     online=False\n... )\n\n&gt;&gt;&gt; # Current sidereal positions\n&gt;&gt;&gt; sidereal_now = AstrologicalSubjectFactory.from_current_time(\n...     name=\"Sidereal Now\",\n...     city=\"Mumbai\", nation=\"IN\",\n...     zodiac_type=\"Sidereal\",\n...     sidereal_mode=\"LAHIRI\"\n... )\n</code></pre>\n      \n      <p>Note:\n          - The exact time is captured at method execution, including seconds\n          - For horary astrology, consider the moment of understanding the question\n          - System clock accuracy affects precision; ensure accurate system time\n          - Time zone detection is automatic when using online location lookup</p>\n    </blockquote>\n  </blockquote>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;Now&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">city</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">nation</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lng</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lat</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">tz_str</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">geonames_username</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">online</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">zodiac_type</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Tropic&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Sidereal&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;Tropic&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">sidereal_mode</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;FAGAN_BRADLEY&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;LAHIRI&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;DELUCE&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;RAMAN&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;USHASHASHI&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;KRISHNAMURTI&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;DJWHAL_KHUL&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;YUKTESHWAR&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;JN_BHASIN&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_KUGLER1&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_KUGLER2&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_KUGLER3&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_HUBER&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_ETPSC&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ALDEBARAN_15TAU&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;HIPPARCHOS&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;SASSANIAN&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;J2000&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;J1900&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;B1950&#39;</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">houses_system_identifier</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;A&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;B&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;C&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;D&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;F&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;H&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;I&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;i&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;K&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;L&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;M&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;N&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;O&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;P&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Q&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;R&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;S&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;T&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;U&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;V&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;W&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;X&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Y&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;P&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">perspective_type</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Apparent Geocentric&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Heliocentric&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Topocentric&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True Geocentric&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;Apparent Geocentric&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">active_points</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Sun&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Moon&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mercury&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Venus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mars&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Jupiter&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Saturn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Uranus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Neptune&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pluto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Chiron&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Earth&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pholus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ceres&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pallas&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Juno&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vesta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Eris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Sedna&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Haumea&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Makemake&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ixion&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Orcus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Quaoar&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Regulus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Spica&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fortunae&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Spiritus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Amoris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fidei&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Anti_Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ascendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Medium_Coeli&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Descendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Imum_Coeli&#39;</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"p\">[</span><span class=\"s1\">&#39;Sun&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Moon&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mercury&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Venus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mars&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Jupiter&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Saturn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Uranus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Neptune&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pluto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Chiron&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ascendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Medium_Coeli&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Descendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Imum_Coeli&#39;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">calculate_lunar_phase</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span>:</span></span>", "funcdef": "def"}, "kerykeion.ChartDrawer": {"fullname": "kerykeion.ChartDrawer", "modulename": "kerykeion", "qualname": "ChartDrawer", "kind": "class", "doc": "<p>ChartDrawer generates astrological chart visualizations as SVG files.</p>\n\n<p>This class supports creating full chart SVGs, wheel-only SVGs, and aspect-grid-only SVGs\nfor various chart types including Natal, ExternalNatal, Transit, Synastry, and Composite.\nCharts are rendered using XML templates and drawing utilities, with customizable themes,\nlanguage, active points, and aspects.\nThe rendered SVGs can be saved to a specified output directory or, by default, to the user's home directory.</p>\n\n<p>NOTE:\n    The generated SVG files are optimized for web use, opening in browsers. If you want to\n    use them in other applications, you might need to adjust the SVG settings or styles.</p>\n\n<p>Args:\n    first_obj (AstrologicalSubject | AstrologicalSubjectModel | CompositeSubjectModel):\n        The primary astrological subject for the chart.\n    chart_type (ChartType, optional):\n        The type of chart to generate ('Natal', 'ExternalNatal', 'Transit', 'Synastry', 'Composite').\n        Defaults to 'Natal'.\n    second_obj (AstrologicalSubject | AstrologicalSubjectModel, optional):\n        The secondary subject for Transit or Synastry charts. Not required for Natal or Composite.\n    new_output_directory (str | Path, optional):\n        Directory to write generated SVG files. Defaults to the user's home directory.\n    new_settings_file (Path | dict | KerykeionSettingsModel, optional):\n        Path or settings object to override default chart configuration (colors, fonts, aspects).\n    theme (KerykeionChartTheme, optional):\n        CSS theme for the chart. If None, no default styles are applied. Defaults to 'classic'.\n    double_chart_aspect_grid_type (Literal['list', 'table'], optional):\n        Specifies rendering style for double-chart aspect grids. Defaults to 'list'.\n    chart_language (KerykeionChartLanguage, optional):\n        Language code for chart labels. Defaults to 'EN'.\n    active_points (list[AstrologicalPoint], optional):\n        List of celestial points and angles to include. Defaults to DEFAULT_ACTIVE_POINTS.\n        Example:\n        [\"Sun\", \"Moon\", \"Mercury\", \"Venus\"]</p>\n\n<pre><code>active_aspects (list[ActiveAspect], optional):\n    List of aspects (name and orb) to calculate. Defaults to DEFAULT_ACTIVE_ASPECTS.\n    Example:\n    [\n        {\"name\": \"conjunction\", \"orb\": 10},\n        {\"name\": \"opposition\", \"orb\": 10},\n        {\"name\": \"trine\", \"orb\": 8},\n        {\"name\": \"sextile\", \"orb\": 6},\n        {\"name\": \"square\", \"orb\": 5},\n        {\"name\": \"quintile\", \"orb\": 1},\n    ]\n</code></pre>\n\n<p>Public Methods:\n    makeTemplate(minify=False, remove_css_variables=False) -> str:\n        Render the full chart SVG as a string without writing to disk. Use <code>minify=True</code>\n        to remove whitespace and quotes, and <code>remove_css_variables=True</code> to embed CSS vars.</p>\n\n<pre><code>makeSVG(minify=False, remove_css_variables=False) -&gt; None:\n    Generate and write the full chart SVG file to the output directory.\n    Filenames follow the pattern:\n    '{subject.name} - {chart_type} Chart.svg'.\n\nmakeWheelOnlyTemplate(minify=False, remove_css_variables=False) -&gt; str:\n    Render only the chart wheel (no aspect grid) as an SVG string.\n\nmakeWheelOnlySVG(minify=False, remove_css_variables=False) -&gt; None:\n    Generate and write the wheel-only SVG file:\n    '{subject.name} - {chart_type} Chart - Wheel Only.svg'.\n\nmakeAspectGridOnlyTemplate(minify=False, remove_css_variables=False) -&gt; str:\n    Render only the aspect grid as an SVG string.\n\nmakeAspectGridOnlySVG(minify=False, remove_css_variables=False) -&gt; None:\n    Generate and write the aspect-grid-only SVG file:\n    '{subject.name} - {chart_type} Chart - Aspect Grid Only.svg'.\n</code></pre>\n"}, "kerykeion.ChartDrawer.__init__": {"fullname": "kerykeion.ChartDrawer.__init__", "modulename": "kerykeion", "qualname": "ChartDrawer.__init__", "kind": "function", "doc": "<p>Initialize the chart generator with subject data and configuration options.</p>\n\n<p>Args:\n    first_obj (AstrologicalSubjectModel, or CompositeSubjectModel):\n        Primary astrological subject instance.\n    chart_type (ChartType, optional):\n        Type of chart to generate (e.g., 'Natal', 'Transit').\n    second_obj (AstrologicalSubject, optional):\n        Secondary subject for Transit or Synastry charts.\n    new_output_directory (str or Path, optional):\n        Base directory to save generated SVG files.\n    new_settings_file (Path, dict, or KerykeionSettingsModel, optional):\n        Custom settings source for chart colors, fonts, and aspects.\n    theme (KerykeionChartTheme or None, optional):\n        CSS theme to apply; None for default styling.\n    double_chart_aspect_grid_type (Literal['list','table'], optional):\n        Layout style for double-chart aspect grids ('list' or 'table').\n    chart_language (KerykeionChartLanguage, optional):\n        Language code for chart labels (e.g., 'EN', 'IT').\n    active_points (List[AstrologicalPoint], optional):\n        Celestial points to include in the chart visualization.\n    active_aspects (List[ActiveAspect], optional):\n        Aspects to calculate, each defined by name and orb.\n    transparent_background (bool, optional):\n        Whether to use a transparent background instead of the theme color. Defaults to False.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">first_obj</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">CompositeSubjectModel</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">PlanetReturnModel</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">chart_type</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Natal&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ExternalNatal&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Synastry&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Transit&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Composite&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Return&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;SingleWheelReturn&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;Natal&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">second_obj</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">PlanetReturnModel</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">new_output_directory</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">new_settings_file</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">_local</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">settings_models</span><span class=\"o\">.</span><span class=\"n\">KerykeionSettingsModel</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">theme</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;light&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dark&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dark-high-contrast&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;classic&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;strawberry&#39;</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;classic&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">double_chart_aspect_grid_type</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;list&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;table&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;list&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">chart_language</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;EN&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;FR&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;PT&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;IT&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;CN&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ES&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;RU&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;TR&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;DE&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;HI&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;EN&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">active_points</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Sun&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Moon&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mercury&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Venus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mars&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Jupiter&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Saturn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Uranus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Neptune&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pluto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Chiron&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Earth&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pholus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ceres&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pallas&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Juno&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vesta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Eris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Sedna&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Haumea&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Makemake&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ixion&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Orcus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Quaoar&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Regulus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Spica&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fortunae&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Spiritus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Amoris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fidei&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Anti_Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ascendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Medium_Coeli&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Descendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Imum_Coeli&#39;</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">active_aspects</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">ActiveAspect</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">[{</span><span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;conjunction&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;orb&#39;</span><span class=\"p\">:</span> <span class=\"mi\">10</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;opposition&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;orb&#39;</span><span class=\"p\">:</span> <span class=\"mi\">10</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;trine&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;orb&#39;</span><span class=\"p\">:</span> <span class=\"mi\">8</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;sextile&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;orb&#39;</span><span class=\"p\">:</span> <span class=\"mi\">6</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;square&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;orb&#39;</span><span class=\"p\">:</span> <span class=\"mi\">5</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;quintile&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;orb&#39;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">}]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">transparent_background</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">colors_settings</span><span class=\"p\">:</span> <span class=\"nb\">dict</span> <span class=\"o\">=</span> <span class=\"p\">{</span><span class=\"s1\">&#39;paper_0&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-paper-0)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;paper_1&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-paper-1)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_bg_0&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-bg-0)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_bg_1&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-bg-1)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_bg_2&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-bg-2)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_bg_3&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-bg-3)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_bg_4&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-bg-4)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_bg_5&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-bg-5)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_bg_6&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-bg-6)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_bg_7&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-bg-7)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_bg_8&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-bg-8)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_bg_9&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-bg-9)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_bg_10&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-bg-10)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_bg_11&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-bg-11)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_icon_0&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-icon-0)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_icon_1&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-icon-1)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_icon_2&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-icon-2)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_icon_3&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-icon-3)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_icon_4&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-icon-4)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_icon_5&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-icon-5)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_icon_6&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-icon-6)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_icon_7&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-icon-7)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_icon_8&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-icon-8)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_icon_9&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-icon-9)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_icon_10&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-icon-10)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_icon_11&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-icon-11)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_radix_ring_0&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-radix-ring-0)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_radix_ring_1&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-radix-ring-1)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_radix_ring_2&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-radix-ring-2)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_transit_ring_0&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-transit-ring-0)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_transit_ring_1&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-transit-ring-1)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_transit_ring_2&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-transit-ring-2)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zodiac_transit_ring_3&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-zodiac-transit-ring-3)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;houses_radix_line&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-houses-radix-line)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;houses_transit_line&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-houses-transit-line)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;lunar_phase_0&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-lunar-phase-0)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;lunar_phase_1&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-lunar-phase-1)&#39;</span><span class=\"p\">}</span>,</span><span class=\"param\">\t<span class=\"n\">celestial_points_settings</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">[{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Sun&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-sun)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">40</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Sun&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Moon&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-moon)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">40</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Moon&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Mercury&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-mercury)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">15</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Mercury&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">3</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Venus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-venus)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">15</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Venus&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">4</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Mars&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-mars)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">15</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Mars&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">5</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Jupiter&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-jupiter)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Jupiter&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">6</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Saturn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-saturn)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Saturn&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">7</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Uranus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-uranus)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Uranus&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">8</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Neptune&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-neptune)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Neptune&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">9</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Pluto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-pluto)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Pluto&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Mean_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-mean-node)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Mean_Node&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">11</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;True_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-true-node)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;True_Node&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">12</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Chiron&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-chiron)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Chiron&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">13</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Ascendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-first-house)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">40</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Asc&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">14</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Medium_Coeli&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-tenth-house)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">20</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Mc&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">15</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Descendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-seventh-house)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Dsc&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">16</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Imum_Coeli&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-fourth-house)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Ic&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">17</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Mean_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-mean-lilith)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Mean_Lilith&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">18</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Mean_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-mean-node)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Mean_South_Node&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">19</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;True_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-true-node)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;True_South_Node&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">20</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;True_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-mean-lilith)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;True_Lilith&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">21</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Earth&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-earth)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Earth&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">22</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Pholus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-pholus)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Pholus&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">23</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Ceres&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-ceres)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Ceres&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">24</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Pallas&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-pallas)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Pallas&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">25</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Juno&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-juno)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Juno&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">26</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Vesta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-vesta)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Vesta&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">27</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Eris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-eris)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Eris&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">28</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Sedna&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-sedna)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Sedna&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">29</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Haumea&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-haumea)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Haumea&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Makemake&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-makemake)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Makemake&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">31</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Ixion&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-ixion)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Ixion&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">32</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Orcus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-orcus)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Orcus&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">33</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Quaoar&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-quaoar)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Quaoar&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">34</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Regulus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-regulus)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Regulus&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">35</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Spica&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-spica)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Spica&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">36</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Pars_Fortunae&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-pars-fortunae)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">5</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Fortune&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">37</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Pars_Spiritus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-pars-spiritus)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Spirit&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">38</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Pars_Amoris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-pars-amoris)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Love&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">39</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Pars_Fidei&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-pars-fidei)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Faith&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">40</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-vertex)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Vertex&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;id&#39;</span><span class=\"p\">:</span> <span class=\"mi\">41</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Anti_Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-anti-vertex)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;element_points&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Anti_Vertex&#39;</span><span class=\"p\">}]</span>,</span><span class=\"param\">\t<span class=\"n\">aspects_settings</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">[{</span><span class=\"s1\">&#39;degree&#39;</span><span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;conjunction&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;is_major&#39;</span><span class=\"p\">:</span> <span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-conjunction)&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;degree&#39;</span><span class=\"p\">:</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;semi-sextile&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;is_major&#39;</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-semi-sextile)&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;degree&#39;</span><span class=\"p\">:</span> <span class=\"mi\">45</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;semi-square&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;is_major&#39;</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-semi-square)&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;degree&#39;</span><span class=\"p\">:</span> <span class=\"mi\">60</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;sextile&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;is_major&#39;</span><span class=\"p\">:</span> <span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-sextile)&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;degree&#39;</span><span class=\"p\">:</span> <span class=\"mi\">72</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;quintile&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;is_major&#39;</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-quintile)&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;degree&#39;</span><span class=\"p\">:</span> <span class=\"mi\">90</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;square&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;is_major&#39;</span><span class=\"p\">:</span> <span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-square)&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;degree&#39;</span><span class=\"p\">:</span> <span class=\"mi\">120</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;trine&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;is_major&#39;</span><span class=\"p\">:</span> <span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-trine)&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;degree&#39;</span><span class=\"p\">:</span> <span class=\"mi\">135</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;sesquiquadrate&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;is_major&#39;</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-sesquiquadrate)&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;degree&#39;</span><span class=\"p\">:</span> <span class=\"mi\">144</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;biquintile&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;is_major&#39;</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-biquintile)&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;degree&#39;</span><span class=\"p\">:</span> <span class=\"mi\">150</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;quincunx&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;is_major&#39;</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-quincunx)&#39;</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;degree&#39;</span><span class=\"p\">:</span> <span class=\"mi\">180</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;opposition&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;is_major&#39;</span><span class=\"p\">:</span> <span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;var(--kerykeion-chart-color-opposition)&#39;</span><span class=\"p\">}]</span></span>)</span>"}, "kerykeion.ChartDrawer.first_obj": {"fullname": "kerykeion.ChartDrawer.first_obj", "modulename": "kerykeion", "qualname": "ChartDrawer.first_obj", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Union[kerykeion.schemas.kr_models.AstrologicalSubjectModel, kerykeion.schemas.kr_models.CompositeSubjectModel, kerykeion.schemas.kr_models.PlanetReturnModel]"}, "kerykeion.ChartDrawer.second_obj": {"fullname": "kerykeion.ChartDrawer.second_obj", "modulename": "kerykeion", "qualname": "ChartDrawer.second_obj", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Union[kerykeion.schemas.kr_models.AstrologicalSubjectModel, kerykeion.schemas.kr_models.PlanetReturnModel, NoneType]"}, "kerykeion.ChartDrawer.chart_type": {"fullname": "kerykeion.ChartDrawer.chart_type", "modulename": "kerykeion", "qualname": "ChartDrawer.chart_type", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;Natal&#x27;, &#x27;ExternalNatal&#x27;, &#x27;Synastry&#x27;, &#x27;Transit&#x27;, &#x27;Composite&#x27;, &#x27;Return&#x27;, &#x27;SingleWheelReturn&#x27;]"}, "kerykeion.ChartDrawer.new_output_directory": {"fullname": "kerykeion.ChartDrawer.new_output_directory", "modulename": "kerykeion", "qualname": "ChartDrawer.new_output_directory", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[pathlib._local.Path]"}, "kerykeion.ChartDrawer.new_settings_file": {"fullname": "kerykeion.ChartDrawer.new_settings_file", "modulename": "kerykeion", "qualname": "ChartDrawer.new_settings_file", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Union[pathlib._local.Path, NoneType, kerykeion.schemas.settings_models.KerykeionSettingsModel, dict]"}, "kerykeion.ChartDrawer.output_directory": {"fullname": "kerykeion.ChartDrawer.output_directory", "modulename": "kerykeion", "qualname": "ChartDrawer.output_directory", "kind": "variable", "doc": "<p></p>\n", "annotation": ": pathlib._local.Path"}, "kerykeion.ChartDrawer.theme": {"fullname": "kerykeion.ChartDrawer.theme", "modulename": "kerykeion", "qualname": "ChartDrawer.theme", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[Literal[&#x27;light&#x27;, &#x27;dark&#x27;, &#x27;dark-high-contrast&#x27;, &#x27;classic&#x27;, &#x27;strawberry&#x27;]]"}, "kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"fullname": "kerykeion.ChartDrawer.double_chart_aspect_grid_type", "modulename": "kerykeion", "qualname": "ChartDrawer.double_chart_aspect_grid_type", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;list&#x27;, &#x27;table&#x27;]"}, "kerykeion.ChartDrawer.chart_language": {"fullname": "kerykeion.ChartDrawer.chart_language", "modulename": "kerykeion", "qualname": "ChartDrawer.chart_language", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;EN&#x27;, &#x27;FR&#x27;, &#x27;PT&#x27;, &#x27;IT&#x27;, &#x27;CN&#x27;, &#x27;ES&#x27;, &#x27;RU&#x27;, &#x27;TR&#x27;, &#x27;DE&#x27;, &#x27;HI&#x27;]"}, "kerykeion.ChartDrawer.active_points": {"fullname": "kerykeion.ChartDrawer.active_points", "modulename": "kerykeion", "qualname": "ChartDrawer.active_points", "kind": "variable", "doc": "<p></p>\n", "annotation": ": List[Literal[&#x27;Sun&#x27;, &#x27;Moon&#x27;, &#x27;Mercury&#x27;, &#x27;Venus&#x27;, &#x27;Mars&#x27;, &#x27;Jupiter&#x27;, &#x27;Saturn&#x27;, &#x27;Uranus&#x27;, &#x27;Neptune&#x27;, &#x27;Pluto&#x27;, &#x27;Mean_Node&#x27;, &#x27;True_Node&#x27;, &#x27;Mean_South_Node&#x27;, &#x27;True_South_Node&#x27;, &#x27;Chiron&#x27;, &#x27;Mean_Lilith&#x27;, &#x27;True_Lilith&#x27;, &#x27;Earth&#x27;, &#x27;Pholus&#x27;, &#x27;Ceres&#x27;, &#x27;Pallas&#x27;, &#x27;Juno&#x27;, &#x27;Vesta&#x27;, &#x27;Eris&#x27;, &#x27;Sedna&#x27;, &#x27;Haumea&#x27;, &#x27;Makemake&#x27;, &#x27;Ixion&#x27;, &#x27;Orcus&#x27;, &#x27;Quaoar&#x27;, &#x27;Regulus&#x27;, &#x27;Spica&#x27;, &#x27;Pars_Fortunae&#x27;, &#x27;Pars_Spiritus&#x27;, &#x27;Pars_Amoris&#x27;, &#x27;Pars_Fidei&#x27;, &#x27;Vertex&#x27;, &#x27;Anti_Vertex&#x27;, &#x27;Ascendant&#x27;, &#x27;Medium_Coeli&#x27;, &#x27;Descendant&#x27;, &#x27;Imum_Coeli&#x27;]]"}, "kerykeion.ChartDrawer.active_aspects": {"fullname": "kerykeion.ChartDrawer.active_aspects", "modulename": "kerykeion", "qualname": "ChartDrawer.active_aspects", "kind": "variable", "doc": "<p></p>\n", "annotation": ": List[kerykeion.schemas.kr_models.ActiveAspect]"}, "kerykeion.ChartDrawer.transparent_background": {"fullname": "kerykeion.ChartDrawer.transparent_background", "modulename": "kerykeion", "qualname": "ChartDrawer.transparent_background", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool"}, "kerykeion.ChartDrawer.fire": {"fullname": "kerykeion.ChartDrawer.fire", "modulename": "kerykeion", "qualname": "ChartDrawer.fire", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float"}, "kerykeion.ChartDrawer.earth": {"fullname": "kerykeion.ChartDrawer.earth", "modulename": "kerykeion", "qualname": "ChartDrawer.earth", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float"}, "kerykeion.ChartDrawer.air": {"fullname": "kerykeion.ChartDrawer.air", "modulename": "kerykeion", "qualname": "ChartDrawer.air", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float"}, "kerykeion.ChartDrawer.water": {"fullname": "kerykeion.ChartDrawer.water", "modulename": "kerykeion", "qualname": "ChartDrawer.water", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float"}, "kerykeion.ChartDrawer.first_circle_radius": {"fullname": "kerykeion.ChartDrawer.first_circle_radius", "modulename": "kerykeion", "qualname": "ChartDrawer.first_circle_radius", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float"}, "kerykeion.ChartDrawer.second_circle_radius": {"fullname": "kerykeion.ChartDrawer.second_circle_radius", "modulename": "kerykeion", "qualname": "ChartDrawer.second_circle_radius", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float"}, "kerykeion.ChartDrawer.third_circle_radius": {"fullname": "kerykeion.ChartDrawer.third_circle_radius", "modulename": "kerykeion", "qualname": "ChartDrawer.third_circle_radius", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float"}, "kerykeion.ChartDrawer.width": {"fullname": "kerykeion.ChartDrawer.width", "modulename": "kerykeion", "qualname": "ChartDrawer.width", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Union[float, int]"}, "kerykeion.ChartDrawer.language_settings": {"fullname": "kerykeion.ChartDrawer.language_settings", "modulename": "kerykeion", "qualname": "ChartDrawer.language_settings", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict"}, "kerykeion.ChartDrawer.chart_colors_settings": {"fullname": "kerykeion.ChartDrawer.chart_colors_settings", "modulename": "kerykeion", "qualname": "ChartDrawer.chart_colors_settings", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict"}, "kerykeion.ChartDrawer.planets_settings": {"fullname": "kerykeion.ChartDrawer.planets_settings", "modulename": "kerykeion", "qualname": "ChartDrawer.planets_settings", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict"}, "kerykeion.ChartDrawer.aspects_settings": {"fullname": "kerykeion.ChartDrawer.aspects_settings", "modulename": "kerykeion", "qualname": "ChartDrawer.aspects_settings", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict"}, "kerykeion.ChartDrawer.available_planets_setting": {"fullname": "kerykeion.ChartDrawer.available_planets_setting", "modulename": "kerykeion", "qualname": "ChartDrawer.available_planets_setting", "kind": "variable", "doc": "<p></p>\n", "annotation": ": List[kerykeion.schemas.settings_models.KerykeionSettingsCelestialPointModel]"}, "kerykeion.ChartDrawer.height": {"fullname": "kerykeion.ChartDrawer.height", "modulename": "kerykeion", "qualname": "ChartDrawer.height", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float"}, "kerykeion.ChartDrawer.location": {"fullname": "kerykeion.ChartDrawer.location", "modulename": "kerykeion", "qualname": "ChartDrawer.location", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "kerykeion.ChartDrawer.geolat": {"fullname": "kerykeion.ChartDrawer.geolat", "modulename": "kerykeion", "qualname": "ChartDrawer.geolat", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float"}, "kerykeion.ChartDrawer.geolon": {"fullname": "kerykeion.ChartDrawer.geolon", "modulename": "kerykeion", "qualname": "ChartDrawer.geolon", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float"}, "kerykeion.ChartDrawer.template": {"fullname": "kerykeion.ChartDrawer.template", "modulename": "kerykeion", "qualname": "ChartDrawer.template", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "kerykeion.ChartDrawer.main_radius": {"fullname": "kerykeion.ChartDrawer.main_radius", "modulename": "kerykeion", "qualname": "ChartDrawer.main_radius", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.ChartDrawer.available_kerykeion_celestial_points": {"fullname": "kerykeion.ChartDrawer.available_kerykeion_celestial_points", "modulename": "kerykeion", "qualname": "ChartDrawer.available_kerykeion_celestial_points", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.ChartDrawer.cardinal": {"fullname": "kerykeion.ChartDrawer.cardinal", "modulename": "kerykeion", "qualname": "ChartDrawer.cardinal", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.ChartDrawer.fixed": {"fullname": "kerykeion.ChartDrawer.fixed", "modulename": "kerykeion", "qualname": "ChartDrawer.fixed", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.ChartDrawer.mutable": {"fullname": "kerykeion.ChartDrawer.mutable", "modulename": "kerykeion", "qualname": "ChartDrawer.mutable", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.ChartDrawer.set_up_theme": {"fullname": "kerykeion.ChartDrawer.set_up_theme", "modulename": "kerykeion", "qualname": "ChartDrawer.set_up_theme", "kind": "function", "doc": "<p>Load and apply a CSS theme for the chart visualization.</p>\n\n<p>Args:\n    theme (KerykeionChartTheme or None): Name of the theme to apply. If None, no CSS is applied.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">theme</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;light&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dark&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dark-high-contrast&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;classic&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;strawberry&#39;</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "kerykeion.ChartDrawer.set_output_directory": {"fullname": "kerykeion.ChartDrawer.set_output_directory", "modulename": "kerykeion", "qualname": "ChartDrawer.set_output_directory", "kind": "function", "doc": "<p>Set the directory where generated SVG files will be saved.</p>\n\n<p>Args:\n    dir_path (Path): Target directory for SVG output.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dir_path</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">_local</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "kerykeion.ChartDrawer.parse_json_settings": {"fullname": "kerykeion.ChartDrawer.parse_json_settings", "modulename": "kerykeion", "qualname": "ChartDrawer.parse_json_settings", "kind": "function", "doc": "<p>Load and parse chart configuration settings.</p>\n\n<p>Args:\n    settings_file_or_dict (Path, dict, or KerykeionSettingsModel):\n        Source for custom chart settings.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">settings_file_or_dict</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">_local</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">settings_models</span><span class=\"o\">.</span><span class=\"n\">KerykeionSettingsModel</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "kerykeion.ChartDrawer.makeTemplate": {"fullname": "kerykeion.ChartDrawer.makeTemplate", "modulename": "kerykeion", "qualname": "ChartDrawer.makeTemplate", "kind": "function", "doc": "<p>Render the full chart SVG as a string.</p>\n\n<p>Reads the XML template, substitutes variables, and optionally inlines CSS\nvariables and minifies the output.</p>\n\n<p>Args:\n    minify (bool): Remove whitespace and quotes for compactness.\n    remove_css_variables (bool): Embed CSS variable definitions.</p>\n\n<p>Returns:\n    str: SVG markup as a string.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">minify</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>, </span><span class=\"param\"><span class=\"n\">remove_css_variables</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "kerykeion.ChartDrawer.makeSVG": {"fullname": "kerykeion.ChartDrawer.makeSVG", "modulename": "kerykeion", "qualname": "ChartDrawer.makeSVG", "kind": "function", "doc": "<p>Generate and save the full chart SVG to disk.</p>\n\n<p>Calls makeTemplate to render the SVG, then writes a file named\n\"{subject.name} - {chart_type} Chart.svg\" in the output directory.</p>\n\n<p>Args:\n    minify (bool): Pass-through to makeTemplate for compact output.\n    remove_css_variables (bool): Pass-through to makeTemplate to embed CSS variables.</p>\n\n<p>Returns:\n    None</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">minify</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>, </span><span class=\"param\"><span class=\"n\">remove_css_variables</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"fullname": "kerykeion.ChartDrawer.makeWheelOnlyTemplate", "modulename": "kerykeion", "qualname": "ChartDrawer.makeWheelOnlyTemplate", "kind": "function", "doc": "<p>Render the wheel-only chart SVG as a string.</p>\n\n<p>Reads the wheel-only XML template, substitutes chart data, and applies optional\nCSS inlining and minification.</p>\n\n<p>Args:\n    minify (bool): Remove whitespace and quotes for compactness.\n    remove_css_variables (bool): Embed CSS variable definitions.</p>\n\n<p>Returns:\n    str: SVG markup for the chart wheel only.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">minify</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>, </span><span class=\"param\"><span class=\"n\">remove_css_variables</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"fullname": "kerykeion.ChartDrawer.makeWheelOnlySVG", "modulename": "kerykeion", "qualname": "ChartDrawer.makeWheelOnlySVG", "kind": "function", "doc": "<p>Generate and save wheel-only chart SVG to disk.</p>\n\n<p>Calls makeWheelOnlyTemplate and writes a file named\n\"{subject.name} - {chart_type} Chart - Wheel Only.svg\" in the output directory.</p>\n\n<p>Args:\n    minify (bool): Pass-through to makeWheelOnlyTemplate for compact output.\n    remove_css_variables (bool): Pass-through to makeWheelOnlyTemplate to embed CSS variables.</p>\n\n<p>Returns:\n    None</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">minify</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>, </span><span class=\"param\"><span class=\"n\">remove_css_variables</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"fullname": "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate", "modulename": "kerykeion", "qualname": "ChartDrawer.makeAspectGridOnlyTemplate", "kind": "function", "doc": "<p>Render the aspect-grid-only chart SVG as a string.</p>\n\n<p>Reads the aspect-grid XML template, generates the aspect grid based on chart type,\nand applies optional CSS inlining and minification.</p>\n\n<p>Args:\n    minify (bool): Remove whitespace and quotes for compactness.\n    remove_css_variables (bool): Embed CSS variable definitions.</p>\n\n<p>Returns:\n    str: SVG markup for the aspect grid only.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">minify</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>, </span><span class=\"param\"><span class=\"n\">remove_css_variables</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"fullname": "kerykeion.ChartDrawer.makeAspectGridOnlySVG", "modulename": "kerykeion", "qualname": "ChartDrawer.makeAspectGridOnlySVG", "kind": "function", "doc": "<p>Generate and save aspect-grid-only chart SVG to disk.</p>\n\n<p>Calls makeAspectGridOnlyTemplate and writes a file named\n\"{subject.name} - {chart_type} Chart - Aspect Grid Only.svg\" in the output directory.</p>\n\n<p>Args:\n    minify (bool): Pass-through to makeAspectGridOnlyTemplate for compact output.\n    remove_css_variables (bool): Pass-through to makeAspectGridOnlyTemplate to embed CSS variables.</p>\n\n<p>Returns:\n    None</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">minify</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>, </span><span class=\"param\"><span class=\"n\">remove_css_variables</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "kerykeion.CompositeSubjectFactory": {"fullname": "kerykeion.CompositeSubjectFactory", "modulename": "kerykeion", "qualname": "CompositeSubjectFactory", "kind": "class", "doc": "<p>Factory class to create composite astrological charts from two astrological subjects.</p>\n\n<p>A composite chart represents the relationship between two people by calculating the midpoint\nbetween corresponding planetary positions and house cusps. This creates a single chart\nthat symbolizes the energy of the relationship itself.</p>\n\n<p>Currently supports the midpoint method for composite chart calculation, where:</p>\n\n<ul>\n<li>Planetary positions are calculated as the circular mean of corresponding planets</li>\n<li>House cusps are calculated as the circular mean of corresponding houses</li>\n<li>Houses are reordered to maintain consistency with the original house system</li>\n<li>Only common active points between both subjects are included</li>\n</ul>\n\n<p>The resulting composite chart maintains the zodiac type, sidereal mode, houses system,\nand perspective type of the input subjects (which must be identical between subjects).</p>\n\n<p>Attributes:\n    model (CompositeSubjectModel | None): The generated composite subject model\n    first_subject (AstrologicalSubjectModel): First astrological subject\n    second_subject (AstrologicalSubjectModel): Second astrological subject\n    name (str): Name of the composite chart\n    composite_chart_type (CompositeChartType): Type of composite chart (currently \"Midpoint\")\n    zodiac_type (ZodiacType): Zodiac system used (Tropical or Sidereal)\n    sidereal_mode (SiderealMode | None): Sidereal calculation mode if applicable\n    houses_system_identifier (HousesSystemIdentifier): House system identifier\n    houses_system_name (str): Human-readable house system name\n    perspective_type (PerspectiveType): Astrological perspective type\n    houses_names_list (list[Houses]): List of house names\n    active_points (list[AstrologicalPoint]): Common active planetary points</p>\n\n<p>Example:</p>\n\n<blockquote>\n  <blockquote>\n    <blockquote>\n      <p>first_person = AstrologicalSubjectFactory.from_birth_data(\n          ...     \"John\", 1990, 1, 1, 12, 0, \"New York\", \"US\"\n          ... )\n      second_person = AstrologicalSubjectFactory.from_birth_data(\n          ...     \"Jane\", 1992, 6, 15, 14, 30, \"Los Angeles\", \"US\"\n          ... )\n      composite = CompositeSubjectFactory(first_person, second_person)\n      composite_model = composite.get_midpoint_composite_subject_model()</p>\n    </blockquote>\n  </blockquote>\n</blockquote>\n\n<p>Raises:\n    KerykeionException: When subjects have incompatible settings (different zodiac types,\n                       sidereal modes, house systems, or perspective types)</p>\n"}, "kerykeion.CompositeSubjectFactory.__init__": {"fullname": "kerykeion.CompositeSubjectFactory.__init__", "modulename": "kerykeion", "qualname": "CompositeSubjectFactory.__init__", "kind": "function", "doc": "<p>Initialize the composite subject factory with two astrological subjects.</p>\n\n<p>Validates that both subjects have compatible settings and extracts common\nactive points for composite chart calculation.</p>\n\n<p>Args:\n    first_subject (AstrologicalSubjectModel): First astrological subject for the composite\n    second_subject (AstrologicalSubjectModel): Second astrological subject for the composite\n    chart_name (str | None, optional): Custom name for the composite chart.\n                                     If None, generates name from subject names.\n                                     Defaults to None.</p>\n\n<p>Raises:\n    KerykeionException: If subjects have different zodiac types, sidereal modes,\n                      house systems, house system names, or perspective types.</p>\n\n<p>Note:\n    Both subjects must have identical astrological calculation settings to ensure\n    meaningful composite chart calculations.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">first_subject</span><span class=\"p\">:</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span>,</span><span class=\"param\">\t<span class=\"n\">second_subject</span><span class=\"p\">:</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span>,</span><span class=\"param\">\t<span class=\"n\">chart_name</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "kerykeion.CompositeSubjectFactory.model": {"fullname": "kerykeion.CompositeSubjectFactory.model", "modulename": "kerykeion", "qualname": "CompositeSubjectFactory.model", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[kerykeion.schemas.kr_models.CompositeSubjectModel]"}, "kerykeion.CompositeSubjectFactory.first_subject": {"fullname": "kerykeion.CompositeSubjectFactory.first_subject", "modulename": "kerykeion", "qualname": "CompositeSubjectFactory.first_subject", "kind": "variable", "doc": "<p></p>\n", "annotation": ": kerykeion.schemas.kr_models.AstrologicalSubjectModel"}, "kerykeion.CompositeSubjectFactory.second_subject": {"fullname": "kerykeion.CompositeSubjectFactory.second_subject", "modulename": "kerykeion", "qualname": "CompositeSubjectFactory.second_subject", "kind": "variable", "doc": "<p></p>\n", "annotation": ": kerykeion.schemas.kr_models.AstrologicalSubjectModel"}, "kerykeion.CompositeSubjectFactory.name": {"fullname": "kerykeion.CompositeSubjectFactory.name", "modulename": "kerykeion", "qualname": "CompositeSubjectFactory.name", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "kerykeion.CompositeSubjectFactory.composite_chart_type": {"fullname": "kerykeion.CompositeSubjectFactory.composite_chart_type", "modulename": "kerykeion", "qualname": "CompositeSubjectFactory.composite_chart_type", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;Midpoint&#x27;]"}, "kerykeion.CompositeSubjectFactory.zodiac_type": {"fullname": "kerykeion.CompositeSubjectFactory.zodiac_type", "modulename": "kerykeion", "qualname": "CompositeSubjectFactory.zodiac_type", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;Tropic&#x27;, &#x27;Sidereal&#x27;]"}, "kerykeion.CompositeSubjectFactory.sidereal_mode": {"fullname": "kerykeion.CompositeSubjectFactory.sidereal_mode", "modulename": "kerykeion", "qualname": "CompositeSubjectFactory.sidereal_mode", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[Literal[&#x27;FAGAN_BRADLEY&#x27;, &#x27;LAHIRI&#x27;, &#x27;DELUCE&#x27;, &#x27;RAMAN&#x27;, &#x27;USHASHASHI&#x27;, &#x27;KRISHNAMURTI&#x27;, &#x27;DJWHAL_KHUL&#x27;, &#x27;YUKTESHWAR&#x27;, &#x27;JN_BHASIN&#x27;, &#x27;BABYL_KUGLER1&#x27;, &#x27;BABYL_KUGLER2&#x27;, &#x27;BABYL_KUGLER3&#x27;, &#x27;BABYL_HUBER&#x27;, &#x27;BABYL_ETPSC&#x27;, &#x27;ALDEBARAN_15TAU&#x27;, &#x27;HIPPARCHOS&#x27;, &#x27;SASSANIAN&#x27;, &#x27;J2000&#x27;, &#x27;J1900&#x27;, &#x27;B1950&#x27;]]"}, "kerykeion.CompositeSubjectFactory.houses_system_identifier": {"fullname": "kerykeion.CompositeSubjectFactory.houses_system_identifier", "modulename": "kerykeion", "qualname": "CompositeSubjectFactory.houses_system_identifier", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;A&#x27;, &#x27;B&#x27;, &#x27;C&#x27;, &#x27;D&#x27;, &#x27;F&#x27;, &#x27;H&#x27;, &#x27;I&#x27;, &#x27;i&#x27;, &#x27;K&#x27;, &#x27;L&#x27;, &#x27;M&#x27;, &#x27;N&#x27;, &#x27;O&#x27;, &#x27;P&#x27;, &#x27;Q&#x27;, &#x27;R&#x27;, &#x27;S&#x27;, &#x27;T&#x27;, &#x27;U&#x27;, &#x27;V&#x27;, &#x27;W&#x27;, &#x27;X&#x27;, &#x27;Y&#x27;]"}, "kerykeion.CompositeSubjectFactory.houses_system_name": {"fullname": "kerykeion.CompositeSubjectFactory.houses_system_name", "modulename": "kerykeion", "qualname": "CompositeSubjectFactory.houses_system_name", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "kerykeion.CompositeSubjectFactory.perspective_type": {"fullname": "kerykeion.CompositeSubjectFactory.perspective_type", "modulename": "kerykeion", "qualname": "CompositeSubjectFactory.perspective_type", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;Apparent Geocentric&#x27;, &#x27;Heliocentric&#x27;, &#x27;Topocentric&#x27;, &#x27;True Geocentric&#x27;]"}, "kerykeion.CompositeSubjectFactory.houses_names_list": {"fullname": "kerykeion.CompositeSubjectFactory.houses_names_list", "modulename": "kerykeion", "qualname": "CompositeSubjectFactory.houses_names_list", "kind": "variable", "doc": "<p></p>\n", "annotation": ": list[typing.Literal[&#x27;First_House&#x27;, &#x27;Second_House&#x27;, &#x27;Third_House&#x27;, &#x27;Fourth_House&#x27;, &#x27;Fifth_House&#x27;, &#x27;Sixth_House&#x27;, &#x27;Seventh_House&#x27;, &#x27;Eighth_House&#x27;, &#x27;Ninth_House&#x27;, &#x27;Tenth_House&#x27;, &#x27;Eleventh_House&#x27;, &#x27;Twelfth_House&#x27;]]"}, "kerykeion.CompositeSubjectFactory.active_points": {"fullname": "kerykeion.CompositeSubjectFactory.active_points", "modulename": "kerykeion", "qualname": "CompositeSubjectFactory.active_points", "kind": "variable", "doc": "<p></p>\n", "annotation": ": list[typing.Literal[&#x27;Sun&#x27;, &#x27;Moon&#x27;, &#x27;Mercury&#x27;, &#x27;Venus&#x27;, &#x27;Mars&#x27;, &#x27;Jupiter&#x27;, &#x27;Saturn&#x27;, &#x27;Uranus&#x27;, &#x27;Neptune&#x27;, &#x27;Pluto&#x27;, &#x27;Mean_Node&#x27;, &#x27;True_Node&#x27;, &#x27;Mean_South_Node&#x27;, &#x27;True_South_Node&#x27;, &#x27;Chiron&#x27;, &#x27;Mean_Lilith&#x27;, &#x27;True_Lilith&#x27;, &#x27;Earth&#x27;, &#x27;Pholus&#x27;, &#x27;Ceres&#x27;, &#x27;Pallas&#x27;, &#x27;Juno&#x27;, &#x27;Vesta&#x27;, &#x27;Eris&#x27;, &#x27;Sedna&#x27;, &#x27;Haumea&#x27;, &#x27;Makemake&#x27;, &#x27;Ixion&#x27;, &#x27;Orcus&#x27;, &#x27;Quaoar&#x27;, &#x27;Regulus&#x27;, &#x27;Spica&#x27;, &#x27;Pars_Fortunae&#x27;, &#x27;Pars_Spiritus&#x27;, &#x27;Pars_Amoris&#x27;, &#x27;Pars_Fidei&#x27;, &#x27;Vertex&#x27;, &#x27;Anti_Vertex&#x27;, &#x27;Ascendant&#x27;, &#x27;Medium_Coeli&#x27;, &#x27;Descendant&#x27;, &#x27;Imum_Coeli&#x27;]]"}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"fullname": "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model", "modulename": "kerykeion", "qualname": "CompositeSubjectFactory.get_midpoint_composite_subject_model", "kind": "function", "doc": "<p>Generate the complete composite chart model using the midpoint technique.</p>\n\n<p>This is the main public method for creating a composite chart. It orchestrates\nthe calculation of all composite positions and creates a complete CompositeSubjectModel\ncontaining all necessary astrological data for the relationship chart.</p>\n\n<p>The process includes:</p>\n\n<ol>\n<li>Calculating midpoint positions for all planets and house cusps</li>\n<li>Computing the composite lunar phase</li>\n<li>Assembling all data into a comprehensive model</li>\n</ol>\n\n<p>Returns:\n    CompositeSubjectModel: Complete composite chart data model containing:\n        - All calculated planetary positions and their house placements\n        - House cusp positions maintaining proper house system order\n        - Lunar phase information for the composite chart\n        - All metadata from the original subjects (names, chart type, etc.)</p>\n\n<p>Example:</p>\n\n<blockquote>\n  <blockquote>\n    <blockquote>\n      <p>composite = CompositeSubjectFactory(person1, person2, \"Our Relationship\")\n      model = composite.get_midpoint_composite_subject_model()\n      print(f\"Composite Sun at {model.sun.abs_pos}\u00b0 in House {model.sun.house}\")</p>\n    </blockquote>\n  </blockquote>\n</blockquote>\n\n<p>Note:\n    This method performs all calculations internally and returns a complete,\n    ready-to-use composite chart model suitable for analysis or chart drawing.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "kerykeion.EphemerisDataFactory": {"fullname": "kerykeion.EphemerisDataFactory", "modulename": "kerykeion", "qualname": "EphemerisDataFactory", "kind": "class", "doc": "<p>A factory class for generating ephemeris data over a specified date range.</p>\n\n<p>This class calculates astrological ephemeris data (planetary positions and house cusps)\nfor a sequence of dates, allowing for detailed astronomical calculations across time periods.\nIt supports different time intervals (days, hours, or minutes) and various astrological\ncalculation systems.</p>\n\n<p>The factory creates data points at regular intervals between start and end dates,\nwith built-in safeguards to prevent excessive computational loads through configurable\nmaximum limits.</p>\n\n<p>Args:\n    start_datetime (datetime): The starting date and time for ephemeris calculations.\n    end_datetime (datetime): The ending date and time for ephemeris calculations.\n    step_type (Literal[\"days\", \"hours\", \"minutes\"], optional): The time interval unit\n        for data points. Defaults to \"days\".\n    step (int, optional): The number of units to advance for each data point.\n        For example, step=2 with step_type=\"days\" creates data points every 2 days.\n        Defaults to 1.\n    lat (float, optional): Geographic latitude in decimal degrees for calculations.\n        Positive values for North, negative for South. Defaults to 51.4769 (Greenwich).\n    lng (float, optional): Geographic longitude in decimal degrees for calculations.\n        Positive values for East, negative for West. Defaults to 0.0005 (Greenwich).\n    tz_str (str, optional): Timezone identifier (e.g., \"Europe/London\", \"America/New_York\").\n        Defaults to \"Etc/UTC\".\n    is_dst (bool, optional): Whether daylight saving time is active for the location.\n        Only relevant for certain timezone calculations. Defaults to False.\n    zodiac_type (ZodiacType, optional): The zodiac system to use (tropical or sidereal).\n        Defaults to DEFAULT_ZODIAC_TYPE.\n    sidereal_mode (Union[SiderealMode, None], optional): The sidereal calculation mode\n        if using sidereal zodiac. Only applies when zodiac_type is sidereal.\n        Defaults to None.\n    houses_system_identifier (HousesSystemIdentifier, optional): The house system\n        for astrological house calculations (e.g., Placidus, Koch, Equal).\n        Defaults to DEFAULT_HOUSES_SYSTEM_IDENTIFIER.\n    perspective_type (PerspectiveType, optional): The calculation perspective\n        (geocentric, heliocentric, etc.). Defaults to DEFAULT_PERSPECTIVE_TYPE.\n    max_days (Union[int, None], optional): Maximum number of daily data points allowed.\n        Set to None to disable this safety check. Defaults to 730 (2 years).\n    max_hours (Union[int, None], optional): Maximum number of hourly data points allowed.\n        Set to None to disable this safety check. Defaults to 8760 (1 year).\n    max_minutes (Union[int, None], optional): Maximum number of minute-interval data points.\n        Set to None to disable this safety check. Defaults to 525600 (1 year).</p>\n\n<p>Raises:\n    ValueError: If step_type is not one of \"days\", \"hours\", or \"minutes\".\n    ValueError: If the calculated number of data points exceeds the respective maximum limit.\n    ValueError: If no valid dates are generated from the input parameters.</p>\n\n<p>Examples:\n    Create daily ephemeris data for a month:</p>\n\n<pre><code>&gt;&gt;&gt; from datetime import datetime\n&gt;&gt;&gt; start = datetime(2024, 1, 1)\n&gt;&gt;&gt; end = datetime(2024, 1, 31)\n&gt;&gt;&gt; factory = EphemerisDataFactory(start, end)\n&gt;&gt;&gt; data = factory.get_ephemeris_data()\n\nCreate hourly data for a specific location:\n\n&gt;&gt;&gt; factory = EphemerisDataFactory(\n...     start, end,\n...     step_type=\"hours\",\n...     lat=40.7128,  # New York\n...     lng=-74.0060,\n...     tz_str=\"America/New_York\"\n... )\n&gt;&gt;&gt; subjects = factory.get_ephemeris_data_as_astrological_subjects()\n</code></pre>\n\n<p>Note:\n    Large date ranges with small step intervals can generate thousands of data points,\n    which may require significant computation time and memory. The factory includes\n    warnings for calculations exceeding 1000 data points and enforces maximum limits\n    to prevent system overload.</p>\n"}, "kerykeion.EphemerisDataFactory.__init__": {"fullname": "kerykeion.EphemerisDataFactory.__init__", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start_datetime</span><span class=\"p\">:</span> <span class=\"n\">datetime</span><span class=\"o\">.</span><span class=\"n\">datetime</span>,</span><span class=\"param\">\t<span class=\"n\">end_datetime</span><span class=\"p\">:</span> <span class=\"n\">datetime</span><span class=\"o\">.</span><span class=\"n\">datetime</span>,</span><span class=\"param\">\t<span class=\"n\">step_type</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;days&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;hours&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;minutes&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;days&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">step</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">lat</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">51.4769</span>,</span><span class=\"param\">\t<span class=\"n\">lng</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.0005</span>,</span><span class=\"param\">\t<span class=\"n\">tz_str</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;Etc/UTC&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">is_dst</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">zodiac_type</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Tropic&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Sidereal&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;Tropic&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">sidereal_mode</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;FAGAN_BRADLEY&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;LAHIRI&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;DELUCE&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;RAMAN&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;USHASHASHI&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;KRISHNAMURTI&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;DJWHAL_KHUL&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;YUKTESHWAR&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;JN_BHASIN&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_KUGLER1&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_KUGLER2&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_KUGLER3&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_HUBER&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;BABYL_ETPSC&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ALDEBARAN_15TAU&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;HIPPARCHOS&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;SASSANIAN&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;J2000&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;J1900&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;B1950&#39;</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">houses_system_identifier</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;A&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;B&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;C&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;D&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;F&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;H&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;I&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;i&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;K&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;L&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;M&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;N&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;O&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;P&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Q&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;R&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;S&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;T&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;U&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;V&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;W&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;X&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Y&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;P&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">perspective_type</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Apparent Geocentric&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Heliocentric&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Topocentric&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True Geocentric&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;Apparent Geocentric&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">max_days</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"mi\">730</span>,</span><span class=\"param\">\t<span class=\"n\">max_hours</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"mi\">8760</span>,</span><span class=\"param\">\t<span class=\"n\">max_minutes</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"mi\">525600</span></span>)</span>"}, "kerykeion.EphemerisDataFactory.start_datetime": {"fullname": "kerykeion.EphemerisDataFactory.start_datetime", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.start_datetime", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.EphemerisDataFactory.end_datetime": {"fullname": "kerykeion.EphemerisDataFactory.end_datetime", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.end_datetime", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.EphemerisDataFactory.step_type": {"fullname": "kerykeion.EphemerisDataFactory.step_type", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.step_type", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.EphemerisDataFactory.step": {"fullname": "kerykeion.EphemerisDataFactory.step", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.step", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.EphemerisDataFactory.lat": {"fullname": "kerykeion.EphemerisDataFactory.lat", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.lat", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.EphemerisDataFactory.lng": {"fullname": "kerykeion.EphemerisDataFactory.lng", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.lng", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.EphemerisDataFactory.tz_str": {"fullname": "kerykeion.EphemerisDataFactory.tz_str", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.tz_str", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.EphemerisDataFactory.is_dst": {"fullname": "kerykeion.EphemerisDataFactory.is_dst", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.is_dst", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.EphemerisDataFactory.zodiac_type": {"fullname": "kerykeion.EphemerisDataFactory.zodiac_type", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.zodiac_type", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.EphemerisDataFactory.sidereal_mode": {"fullname": "kerykeion.EphemerisDataFactory.sidereal_mode", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.sidereal_mode", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.EphemerisDataFactory.houses_system_identifier": {"fullname": "kerykeion.EphemerisDataFactory.houses_system_identifier", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.houses_system_identifier", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.EphemerisDataFactory.perspective_type": {"fullname": "kerykeion.EphemerisDataFactory.perspective_type", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.perspective_type", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.EphemerisDataFactory.max_days": {"fullname": "kerykeion.EphemerisDataFactory.max_days", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.max_days", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.EphemerisDataFactory.max_hours": {"fullname": "kerykeion.EphemerisDataFactory.max_hours", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.max_hours", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.EphemerisDataFactory.max_minutes": {"fullname": "kerykeion.EphemerisDataFactory.max_minutes", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.max_minutes", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.EphemerisDataFactory.dates_list": {"fullname": "kerykeion.EphemerisDataFactory.dates_list", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.dates_list", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"fullname": "kerykeion.EphemerisDataFactory.get_ephemeris_data", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.get_ephemeris_data", "kind": "function", "doc": "<p>Generate ephemeris data for the specified date range.</p>\n\n<p>This method creates a comprehensive dataset containing planetary positions and\nastrological house cusps for each date in the configured time series. The data\nis structured for easy consumption by astrological applications and analysis tools.</p>\n\n<p>The returned data includes all available astrological points (planets, asteroids,\nlunar nodes, etc.) as configured by the perspective type, along with complete\nhouse cusp information for each calculated moment.</p>\n\n<p>Args:\n    as_model (bool, optional): If True, returns data as validated model instances\n        (EphemerisDictModel objects) which provide type safety and validation.\n        If False, returns raw dictionary data for maximum flexibility.\n        Defaults to False.</p>\n\n<p>Returns:\n    list: A list of ephemeris data points, where each element represents one\n        calculated moment in time. The structure depends on the as_model parameter:</p>\n\n<pre><code>    If as_model=False (default):\n        List of dictionaries with keys:\n        - \"date\" (str): ISO format datetime string (e.g., \"2020-01-01T00:00:00\")\n        - \"planets\" (list): List of dictionaries, each containing planetary data\n          with keys like 'name', 'abs_pos', 'lon', 'lat', 'dist', 'speed', etc.\n        - \"houses\" (list): List of dictionaries containing house cusp data\n          with keys like 'name', 'abs_pos', 'lon', etc.\n\n    If as_model=True:\n        List of EphemerisDictModel instances providing the same data\n        with type validation and structured access.\n</code></pre>\n\n<p>Examples:\n    Basic usage with dictionary output:</p>\n\n<pre><code>&gt;&gt;&gt; factory = EphemerisDataFactory(start_date, end_date)\n&gt;&gt;&gt; data = factory.get_ephemeris_data()\n&gt;&gt;&gt; print(f\"Sun position: {data[0]['planets'][0]['abs_pos']}\")\n&gt;&gt;&gt; print(f\"First house cusp: {data[0]['houses'][0]['abs_pos']}\")\n\nUsing model instances for type safety:\n\n&gt;&gt;&gt; data_models = factory.get_ephemeris_data(as_model=True)\n&gt;&gt;&gt; first_point = data_models[0]\n&gt;&gt;&gt; print(f\"Date: {first_point.date}\")\n&gt;&gt;&gt; print(f\"Number of planets: {len(first_point.planets)}\")\n</code></pre>\n\n<p>Note:\n    - The calculation time is proportional to the number of data points\n    - For large datasets (&gt;1000 points), consider using the method in batches\n    - Planet order and availability depend on the configured perspective type\n    - House system affects the house cusp calculations\n    - All positions are in the configured zodiac system (tropical/sidereal)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">as_model</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span>:</span></span>", "funcdef": "def"}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"fullname": "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects", "modulename": "kerykeion", "qualname": "EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects", "kind": "function", "doc": "<p>Generate ephemeris data as complete AstrologicalSubject instances.</p>\n\n<p>This method creates fully-featured AstrologicalSubject objects for each date in the\nconfigured time series, providing access to all astrological calculation methods\nand properties. Unlike the dictionary-based approach of get_ephemeris_data(),\nthis method returns objects with the complete Kerykeion API available.</p>\n\n<p>Each AstrologicalSubject instance represents a complete astrological chart for\nthe specified moment, location, and calculation settings. This allows direct\naccess to methods like get_sun(), get_all_points(), draw_chart(), calculate\naspects, and all other astrological analysis features.</p>\n\n<p>Args:\n    as_model (bool, optional): If True, returns AstrologicalSubjectModel instances\n        (Pydantic model versions) which provide serialization and validation features.\n        If False, returns raw AstrologicalSubject instances with full method access.\n        Defaults to False.</p>\n\n<p>Returns:\n    List[AstrologicalSubjectModel]: A list of AstrologicalSubject or\n        AstrologicalSubjectModel instances (depending on as_model parameter).\n        Each element represents one calculated moment in time with full\n        astrological chart data and methods available.</p>\n\n<pre><code>    Each subject contains:\n    - All planetary and astrological point positions\n    - Complete house system calculations\n    - Chart drawing capabilities\n    - Aspect calculation methods\n    - Access to all Kerykeion astrological features\n</code></pre>\n\n<p>Examples:\n    Basic usage for accessing individual chart features:</p>\n\n<pre><code>&gt;&gt;&gt; factory = EphemerisDataFactory(start_date, end_date)\n&gt;&gt;&gt; subjects = factory.get_ephemeris_data_as_astrological_subjects()\n&gt;&gt;&gt;\n&gt;&gt;&gt; # Access specific planetary data\n&gt;&gt;&gt; sun_data = subjects[0].get_sun()\n&gt;&gt;&gt; moon_data = subjects[0].get_moon()\n&gt;&gt;&gt;\n&gt;&gt;&gt; # Get all astrological points\n&gt;&gt;&gt; all_points = subjects[0].get_all_points()\n&gt;&gt;&gt;\n&gt;&gt;&gt; # Generate chart visualization\n&gt;&gt;&gt; chart_svg = subjects[0].draw_chart()\n\nUsing model instances for serialization:\n\n&gt;&gt;&gt; subjects_models = factory.get_ephemeris_data_as_astrological_subjects(as_model=True)\n&gt;&gt;&gt; # Model instances can be easily serialized to JSON\n&gt;&gt;&gt; json_data = subjects_models[0].model_dump_json()\n\nBatch processing for analysis:\n\n&gt;&gt;&gt; subjects = factory.get_ephemeris_data_as_astrological_subjects()\n&gt;&gt;&gt; sun_positions = [subj.sun['abs_pos'] for subj in subjects if subj.sun]\n&gt;&gt;&gt; # Analyze sun position changes over time\n</code></pre>\n\n<p>Use Cases:\n    - Time-series astrological analysis\n    - Planetary motion tracking\n    - Aspect pattern analysis over time\n    - Chart animation data generation\n    - Astrological research and statistics\n    - Progressive chart calculations</p>\n\n<p>Performance Notes:\n    - More computationally intensive than get_ephemeris_data()\n    - Each subject performs full astrological calculations\n    - Memory usage scales with the number of data points\n    - Consider processing in batches for very large date ranges\n    - Ideal for comprehensive analysis requiring full chart features</p>\n\n<p>See Also:\n    get_ephemeris_data(): For lightweight dictionary-based ephemeris data\n    AstrologicalSubject: For details on available methods and properties</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">as_model</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "kerykeion.HouseComparisonFactory": {"fullname": "kerykeion.HouseComparisonFactory", "modulename": "kerykeion", "qualname": "HouseComparisonFactory", "kind": "class", "doc": "<p>Factory for creating house comparison analyses between two astrological subjects.</p>\n\n<p>Analyzes placement of astrological points from one subject within the house system\nof another subject, performing bidirectional analysis for synastry studies and\nsubject comparisons. Supports both natal subjects and planetary return subjects.</p>\n\n<p>Attributes:\n    first_subject: First astrological subject (natal or return subject)\n    second_subject: Second astrological subject (natal or return subject)\n    active_points: List of astrological points to include in analysis</p>\n\n<p>Example:</p>\n\n<blockquote>\n  <blockquote>\n    <blockquote>\n      <p>natal_chart = AstrologicalSubjectFactory.from_birth_data(\n          ...     \"Person A\", 1990, 5, 15, 10, 30, \"Rome\", \"IT\"\n          ... )\n      partner_chart = AstrologicalSubjectFactory.from_birth_data(\n          ...     \"Person B\", 1992, 8, 23, 14, 45, \"Milan\", \"IT\"\n          ... )\n      factory = HouseComparisonFactory(natal_chart, partner_chart)\n      comparison = factory.get_house_comparison()</p>\n    </blockquote>\n  </blockquote>\n</blockquote>\n"}, "kerykeion.HouseComparisonFactory.__init__": {"fullname": "kerykeion.HouseComparisonFactory.__init__", "modulename": "kerykeion", "qualname": "HouseComparisonFactory.__init__", "kind": "function", "doc": "<p>Initialize the house comparison factory.</p>\n\n<p>Args:\n    first_subject: First astrological subject for comparison\n    second_subject: Second astrological subject for comparison\n    active_points: List of astrological points to include in analysis.\n                  Defaults to standard active points.</p>\n\n<p>Note:\n    Both subjects must have valid house system data for accurate analysis.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">first_subject</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">PlanetReturnModel</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">second_subject</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">PlanetReturnModel</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">active_points</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Sun&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Moon&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mercury&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Venus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mars&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Jupiter&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Saturn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Uranus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Neptune&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pluto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Chiron&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Earth&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pholus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ceres&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pallas&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Juno&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vesta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Eris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Sedna&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Haumea&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Makemake&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ixion&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Orcus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Quaoar&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Regulus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Spica&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fortunae&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Spiritus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Amoris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fidei&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Anti_Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ascendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Medium_Coeli&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Descendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Imum_Coeli&#39;</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"p\">[</span><span class=\"s1\">&#39;Sun&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Moon&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mercury&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Venus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mars&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Jupiter&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Saturn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Uranus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Neptune&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pluto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Chiron&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ascendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Medium_Coeli&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Descendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Imum_Coeli&#39;</span><span class=\"p\">]</span></span>)</span>"}, "kerykeion.HouseComparisonFactory.first_subject": {"fullname": "kerykeion.HouseComparisonFactory.first_subject", "modulename": "kerykeion", "qualname": "HouseComparisonFactory.first_subject", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.HouseComparisonFactory.second_subject": {"fullname": "kerykeion.HouseComparisonFactory.second_subject", "modulename": "kerykeion", "qualname": "HouseComparisonFactory.second_subject", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.HouseComparisonFactory.active_points": {"fullname": "kerykeion.HouseComparisonFactory.active_points", "modulename": "kerykeion", "qualname": "HouseComparisonFactory.active_points", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"fullname": "kerykeion.HouseComparisonFactory.get_house_comparison", "modulename": "kerykeion", "qualname": "HouseComparisonFactory.get_house_comparison", "kind": "function", "doc": "<p>Generate bidirectional house comparison analysis between the two subjects.</p>\n\n<p>Calculates where each active astrological point from one subject falls within\nthe house system of the other subject, and vice versa.</p>\n\n<p>Returns:\n    HouseComparisonModel: Model containing:\n        - first_subject_name: Name of the first subject\n        - second_subject_name: Name of the second subject\n        - first_points_in_second_houses: First subject's points in second subject's houses\n        - second_points_in_first_houses: Second subject's points in first subject's houses</p>\n\n<p>Note:\n    Analysis scope is determined by the active_points list. Only specified\n    points will be included in the results.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">house_comparison</span><span class=\"o\">.</span><span class=\"n\">house_comparison_models</span><span class=\"o\">.</span><span class=\"n\">HouseComparisonModel</span>:</span></span>", "funcdef": "def"}, "kerykeion.HouseComparisonModel": {"fullname": "kerykeion.HouseComparisonModel", "modulename": "kerykeion", "qualname": "HouseComparisonModel", "kind": "class", "doc": "<p>Bidirectional house comparison analysis between two astrological subjects.</p>\n\n<p>Contains results of how astrological points from each subject interact with\nthe house system of the other subject.</p>\n\n<p>Attributes:\n    first_subject_name: Name of the first subject\n    second_subject_name: Name of the second subject\n    first_points_in_second_houses: First subject's points in second subject's houses\n    second_points_in_first_houses: Second subject's points in first subject's houses</p>\n", "bases": "kerykeion.schemas.kr_models.SubscriptableBaseModel"}, "kerykeion.HouseComparisonModel.first_subject_name": {"fullname": "kerykeion.HouseComparisonModel.first_subject_name", "modulename": "kerykeion", "qualname": "HouseComparisonModel.first_subject_name", "kind": "variable", "doc": "<p>Name of the first subject</p>\n", "annotation": ": str"}, "kerykeion.HouseComparisonModel.second_subject_name": {"fullname": "kerykeion.HouseComparisonModel.second_subject_name", "modulename": "kerykeion", "qualname": "HouseComparisonModel.second_subject_name", "kind": "variable", "doc": "<p>Name of the second subject</p>\n", "annotation": ": str"}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"fullname": "kerykeion.HouseComparisonModel.first_points_in_second_houses", "modulename": "kerykeion", "qualname": "HouseComparisonModel.first_points_in_second_houses", "kind": "variable", "doc": "<p>First subject's points positioned in second subject's houses</p>\n", "annotation": ": list[kerykeion.house_comparison.house_comparison_models.PointInHouseModel]"}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"fullname": "kerykeion.HouseComparisonModel.second_points_in_first_houses", "modulename": "kerykeion", "qualname": "HouseComparisonModel.second_points_in_first_houses", "kind": "variable", "doc": "<p>Second subject's points positioned in first subject's houses</p>\n", "annotation": ": list[kerykeion.house_comparison.house_comparison_models.PointInHouseModel]"}, "kerykeion.HouseComparisonModel.model_config": {"fullname": "kerykeion.HouseComparisonModel.model_config", "modulename": "kerykeion", "qualname": "HouseComparisonModel.model_config", "kind": "variable", "doc": "<p>Configuration for the model, should be a dictionary conforming to [<code>ConfigDict</code>][pydantic.config.ConfigDict].</p>\n", "annotation": ": ClassVar[pydantic.config.ConfigDict]", "default_value": "{}"}, "kerykeion.PlanetaryReturnFactory": {"fullname": "kerykeion.PlanetaryReturnFactory", "modulename": "kerykeion", "qualname": "PlanetaryReturnFactory", "kind": "class", "doc": "<p>A factory class for calculating and generating planetary return charts.</p>\n\n<p>This class specializes in computing precise planetary return moments using the Swiss\nEphemeris library and creating complete astrological charts for those calculated times.\nIt supports both Solar Returns (annual) and Lunar Returns (monthly), providing\ncomprehensive astrological analysis capabilities for timing and forecasting applications.</p>\n\n<p>Planetary returns are fundamental concepts in predictive astrology:</p>\n\n<ul>\n<li>Solar Returns: Occur when the Sun returns to its exact natal position (~365.25 days)</li>\n<li>Lunar Returns: Occur when the Moon returns to its exact natal position (~27-29 days)</li>\n</ul>\n\n<p>The factory handles complex astronomical calculations automatically, including:</p>\n\n<ul>\n<li>Precise celestial mechanics computations</li>\n<li>Timezone conversions and UTC coordination</li>\n<li>Location-based calculations for return chart casting</li>\n<li>Integration with online geocoding services</li>\n<li>Complete chart generation with all astrological points</li>\n</ul>\n\n<p>Args:\n    subject (AstrologicalSubjectModel): The natal astrological subject for whom\n        returns are calculated. Must contain complete birth data including\n        planetary positions at birth.\n    city (Optional[str]): City name for return chart location. Required when\n        using online mode for location data retrieval.\n    nation (Optional[str]): Nation/country code for return chart location.\n        Required when using online mode (e.g., \"US\", \"GB\", \"FR\").\n    lng (Optional[Union[int, float]]): Geographic longitude in decimal degrees\n        for return chart location. Positive values for East, negative for West.\n        Required when using offline mode.\n    lat (Optional[Union[int, float]]): Geographic latitude in decimal degrees\n        for return chart location. Positive values for North, negative for South.\n        Required when using offline mode.\n    tz_str (Optional[str]): Timezone identifier for return chart location\n        (e.g., \"America/New_York\", \"Europe/London\", \"Asia/Tokyo\").\n        Required when using offline mode.\n    online (bool, optional): Whether to fetch location data online via Geonames\n        service. When True, requires city, nation, and geonames_username.\n        When False, requires lng, lat, and tz_str. Defaults to True.\n    geonames_username (Optional[str]): Username for Geonames API access.\n        Required when online=True and coordinates are not provided.\n        Register at <a href=\"http://www.geonames.org/login\">http://www.geonames.org/login</a> for free account.\n    cache_expire_after_days (int, optional): Number of days to cache Geonames\n        location data before refreshing. Defaults to system setting.\n    altitude (Optional[Union[float, int]]): Elevation above sea level in meters\n        for the return chart location. Reserved for future astronomical\n        calculations. Defaults to None.</p>\n\n<p>Raises:\n    KerykeionException: If required location parameters are missing for the\n        chosen mode (online/offline).\n    KerykeionException: If Geonames API fails to retrieve location data.\n    KerykeionException: If online mode is used without proper API credentials.</p>\n\n<p>Attributes:\n    subject (AstrologicalSubjectModel): The natal subject for calculations.\n    city (Optional[str]): Return chart city name.\n    nation (Optional[str]): Return chart nation code.\n    lng (float): Return chart longitude coordinate.\n    lat (float): Return chart latitude coordinate.\n    tz_str (str): Return chart timezone identifier.\n    online (bool): Location data retrieval mode.\n    city_data (Optional[dict]): Cached location data from Geonames.</p>\n\n<p>Examples:\n    Online mode with automatic location lookup:</p>\n\n<pre><code>&gt;&gt;&gt; subject = AstrologicalSubjectFactory.from_birth_data(\n...     name=\"Alice\", year=1985, month=3, day=21,\n...     hour=14, minute=30, lat=51.5074, lng=-0.1278,\n...     tz_str=\"Europe/London\"\n... )\n&gt;&gt;&gt; factory = PlanetaryReturnFactory(\n...     subject,\n...     city=\"London\",\n...     nation=\"GB\",\n...     online=True,\n...     geonames_username=\"your_username\"\n... )\n\nOffline mode with manual coordinates:\n\n&gt;&gt;&gt; factory = PlanetaryReturnFactory(\n...     subject,\n...     lng=-74.0060,\n...     lat=40.7128,\n...     tz_str=\"America/New_York\",\n...     online=False\n... )\n\nDifferent location for return chart:\n\n&gt;&gt;&gt; # Calculate return as if living in a different city\n&gt;&gt;&gt; factory = PlanetaryReturnFactory(\n...     natal_subject,  # Born in London\n...     city=\"Paris\",   # But living in Paris\n...     nation=\"FR\",\n...     online=True\n... )\n</code></pre>\n\n<p>Use Cases:\n    - Annual Solar Return charts for yearly forecasting\n    - Monthly Lunar Return charts for timing analysis\n    - Relocation returns for different geographic locations\n    - Research into planetary cycle effects\n    - Astrological consultation and chart analysis\n    - Educational demonstrations of celestial mechanics</p>\n\n<p>Note:\n    Return calculations use the exact degree and minute of natal planetary\n    positions. The resulting charts are cast for the precise moment when\n    the transiting planet reaches this position, which may not align with\n    calendar dates (especially for Solar Returns, which can occur on\n    different dates depending on leap years and location).</p>\n"}, "kerykeion.PlanetaryReturnFactory.__init__": {"fullname": "kerykeion.PlanetaryReturnFactory.__init__", "modulename": "kerykeion", "qualname": "PlanetaryReturnFactory.__init__", "kind": "function", "doc": "<p>Initialize a PlanetaryReturnFactory instance with location and configuration settings.</p>\n\n<p>This constructor sets up the factory with all necessary parameters for calculating\nplanetary returns at a specified location. It supports both online mode (with\nautomatic geocoding via Geonames) and offline mode (with manual coordinates).</p>\n\n<p>The factory validates input parameters based on the chosen mode and automatically\nretrieves missing location data when operating online. All location parameters\nare stored and used for casting return charts at the exact calculated moments.</p>\n\n<p>Args:\n    subject (AstrologicalSubjectModel): The natal astrological subject containing\n        birth data and planetary positions. This subject's natal planetary\n        positions serve as reference points for calculating returns.\n    city (Optional[str]): City name for the return chart location. Must be a\n        recognizable city name for Geonames geocoding when using online mode.\n        Examples: \"New York\", \"London\", \"Tokyo\", \"Paris\".\n    nation (Optional[str]): Country or nation code for the return chart location.\n        Use ISO country codes for best results (e.g., \"US\", \"GB\", \"JP\", \"FR\").\n        Required when online=True.\n    lng (Optional[Union[int, float]]): Geographic longitude coordinate in decimal\n        degrees for return chart location. Range: -180.0 to +180.0.\n        Positive values represent East longitude, negative values West longitude.\n        Required when online=False.\n    lat (Optional[Union[int, float]]): Geographic latitude coordinate in decimal\n        degrees for return chart location. Range: -90.0 to +90.0.\n        Positive values represent North latitude, negative values South latitude.\n        Required when online=False.\n    tz_str (Optional[str]): Timezone identifier string for return chart location.\n        Must be a valid timezone from the IANA Time Zone Database\n        (e.g., \"America/New_York\", \"Europe/London\", \"Asia/Tokyo\").\n        Required when online=False.\n    online (bool, optional): Location data retrieval mode. When True, uses\n        Geonames web service to automatically fetch coordinates and timezone\n        from city/nation parameters. When False, uses manually provided\n        coordinates and timezone. Defaults to True.\n    geonames_username (Optional[str]): Username for Geonames API access.\n        Required when online=True and coordinates are not manually provided.\n        Free accounts available at <a href=\"http://www.geonames.org/login\">http://www.geonames.org/login</a>.\n        If None and required, uses default username with warning.\n    cache_expire_after_days (int, optional): Number of days to cache Geonames\n        location data locally before requiring refresh. Helps reduce API\n        calls and improve performance for repeated calculations.\n        Defaults to system configuration value.\n    altitude (Optional[Union[float, int]]): Elevation above sea level in meters\n        for the return chart location. Currently reserved for future use in\n        advanced astronomical calculations. Defaults to None.</p>\n\n<p>Raises:\n    KerykeionException: If city is not provided when online=True.\n    KerykeionException: If nation is not provided when online=True.\n    KerykeionException: If coordinates (lat/lng) are not provided when online=False.\n    KerykeionException: If timezone (tz_str) is not provided when online=False.\n    KerykeionException: If Geonames API fails to retrieve valid location data.\n    KerykeionException: If required parameters are missing for the chosen mode.</p>\n\n<p>Examples:\n    Initialize with online geocoding:</p>\n\n<pre><code>&gt;&gt;&gt; factory = PlanetaryReturnFactory(\n...     subject,\n...     city=\"San Francisco\",\n...     nation=\"US\",\n...     online=True,\n...     geonames_username=\"your_username\"\n... )\n\nInitialize with manual coordinates:\n\n&gt;&gt;&gt; factory = PlanetaryReturnFactory(\n...     subject,\n...     lng=-122.4194,\n...     lat=37.7749,\n...     tz_str=\"America/Los_Angeles\",\n...     online=False\n... )\n\nInitialize with mixed parameters (coordinates override online lookup):\n\n&gt;&gt;&gt; factory = PlanetaryReturnFactory(\n...     subject,\n...     city=\"Custom Location\",\n...     lng=-74.0060,\n...     lat=40.7128,\n...     tz_str=\"America/New_York\",\n...     online=False\n... )\n</code></pre>\n\n<p>Note:\n    - When both online and manual coordinates are provided, offline mode takes precedence\n    - Geonames cache helps reduce API calls for frequently used locations\n    - Timezone accuracy is crucial for precise return calculations\n    - Location parameters affect house cusps and angular positions in return charts</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">subject</span><span class=\"p\">:</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span>,</span><span class=\"param\">\t<span class=\"n\">city</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">nation</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lng</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lat</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">tz_str</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">online</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">geonames_username</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">cache_expire_after_days</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">30</span>,</span><span class=\"param\">\t<span class=\"n\">altitude</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "kerykeion.PlanetaryReturnFactory.subject": {"fullname": "kerykeion.PlanetaryReturnFactory.subject", "modulename": "kerykeion", "qualname": "PlanetaryReturnFactory.subject", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.PlanetaryReturnFactory.online": {"fullname": "kerykeion.PlanetaryReturnFactory.online", "modulename": "kerykeion", "qualname": "PlanetaryReturnFactory.online", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.PlanetaryReturnFactory.cache_expire_after_days": {"fullname": "kerykeion.PlanetaryReturnFactory.cache_expire_after_days", "modulename": "kerykeion", "qualname": "PlanetaryReturnFactory.cache_expire_after_days", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.PlanetaryReturnFactory.altitude": {"fullname": "kerykeion.PlanetaryReturnFactory.altitude", "modulename": "kerykeion", "qualname": "PlanetaryReturnFactory.altitude", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"fullname": "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time", "modulename": "kerykeion", "qualname": "PlanetaryReturnFactory.next_return_from_iso_formatted_time", "kind": "function", "doc": "<p>Calculate the next planetary return occurring after a specified ISO-formatted datetime.</p>\n\n<p>This method computes the exact moment when the specified planet (Sun or Moon) returns\nto its natal position, starting the search from the provided datetime. It uses precise\nSwiss Ephemeris calculations to determine the exact return moment and generates a\ncomplete astrological chart for that calculated time.</p>\n\n<p>The calculation process:</p>\n\n<ol>\n<li>Converts the ISO datetime to Julian Day format for astronomical calculations</li>\n<li>Uses Swiss Ephemeris functions (solcross_ut/mooncross_ut) to find the exact\nreturn moment when the planet reaches its natal degree and minute</li>\n<li>Creates a complete AstrologicalSubject instance for the calculated return time</li>\n<li>Returns a comprehensive PlanetReturnModel with all chart data</li>\n</ol>\n\n<p>Args:\n    iso_formatted_time (str): Starting datetime in ISO format for the search.\n        Must be a valid ISO 8601 datetime string (e.g., \"2024-01-15T10:30:00\"\n        or \"2024-01-15T10:30:00+00:00\"). The method will find the next return\n        occurring after this moment.\n    return_type (ReturnType): Type of planetary return to calculate.\n        Must be either \"Solar\" for Sun returns or \"Lunar\" for Moon returns.\n        This determines which planet's return cycle to compute.</p>\n\n<p>Returns:\n    PlanetReturnModel: A comprehensive Pydantic model containing complete\n        astrological chart data for the calculated return moment, including:\n        - Exact return datetime (UTC and local timezone)\n        - All planetary positions at the return moment\n        - House cusps and angles for the return location\n        - Complete astrological subject data with all calculated points\n        - Return type identifier and subject name\n        - Julian Day Number for the return moment</p>\n\n<p>Raises:\n    KerykeionException: If return_type is not \"Solar\" or \"Lunar\".\n    ValueError: If iso_formatted_time is not a valid ISO datetime format.\n    SwissEphException: If Swiss Ephemeris calculations fail due to invalid\n        date ranges or astronomical calculation errors.</p>\n\n<p>Examples:\n    Calculate next Solar Return after a specific date:</p>\n\n<pre><code>&gt;&gt;&gt; factory = PlanetaryReturnFactory(subject, ...)\n&gt;&gt;&gt; solar_return = factory.next_return_from_iso_formatted_time(\n...     \"2024-06-15T12:00:00\",\n...     \"Solar\"\n... )\n&gt;&gt;&gt; print(f\"Solar Return: {solar_return.iso_formatted_local_datetime}\")\n&gt;&gt;&gt; print(f\"Sun position: {solar_return.sun.abs_pos}\u00b0\")\n\nCalculate next Lunar Return with timezone:\n\n&gt;&gt;&gt; lunar_return = factory.next_return_from_iso_formatted_time(\n...     \"2024-01-01T00:00:00+00:00\",\n...     \"Lunar\"\n... )\n&gt;&gt;&gt; print(f\"Moon return in {lunar_return.tz_str}\")\n&gt;&gt;&gt; print(f\"Return occurs: {lunar_return.iso_formatted_local_datetime}\")\n\nAccess complete chart data from return:\n\n&gt;&gt;&gt; return_chart = factory.next_return_from_iso_formatted_time(\n...     datetime.now().isoformat(),\n...     \"Solar\"\n... )\n&gt;&gt;&gt; # Access all planetary positions\n&gt;&gt;&gt; for planet in return_chart.planets_list:\n...     print(f\"{planet.name}: {planet.abs_pos}\u00b0 in {planet.sign}\")\n&gt;&gt;&gt; # Access house cusps\n&gt;&gt;&gt; for house in return_chart.houses_list:\n...     print(f\"House {house.number}: {house.abs_pos}\u00b0\")\n</code></pre>\n\n<p>Technical Notes:\n    - Solar returns typically occur within 1-2 days of the natal birthday\n    - Lunar returns occur approximately every 27.3 days (sidereal month)\n    - Return moments are calculated to the second for maximum precision\n    - The method accounts for leap years and varying orbital speeds\n    - Return charts use the factory's configured location, not the natal location</p>\n\n<p>Use Cases:\n    - Annual birthday return chart calculations\n    - Monthly lunar return timing for astrological consultation\n    - Research into planetary cycle patterns and timing\n    - Forecasting and predictive astrology applications\n    - Educational demonstrations of astronomical cycles</p>\n\n<p>See Also:\n    next_return_from_year(): Simplified interface for yearly calculations\n    next_return_from_month_and_year(): Monthly calculation interface</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">iso_formatted_time</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">return_type</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Lunar&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Solar&#39;</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">PlanetReturnModel</span>:</span></span>", "funcdef": "def"}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"fullname": "kerykeion.PlanetaryReturnFactory.next_return_from_year", "modulename": "kerykeion", "qualname": "PlanetaryReturnFactory.next_return_from_year", "kind": "function", "doc": "<p>Calculate the planetary return occurring within a specified year.</p>\n\n<p>This is a convenience method that finds the first planetary return (Solar or Lunar)\nthat occurs in the given calendar year. It automatically searches from January 1st\nof the specified year and returns the first return found, making it ideal for\nannual forecasting and birthday return calculations.</p>\n\n<p>For Solar Returns, this typically finds the return closest to the natal birthday\nwithin that year. For Lunar Returns, it finds the first lunar return occurring\nin January of the specified year.</p>\n\n<p>The method internally uses next_return_from_iso_formatted_time() with a starting\npoint of January 1st at midnight UTC for the specified year.</p>\n\n<p>Args:\n    year (int): The calendar year to search for the return. Must be a valid\n        year (typically between 1800-2200 for reliable ephemeris data).\n        Examples: 2024, 2025, 1990, 2050.\n    return_type (ReturnType): The type of planetary return to calculate.\n        Must be either \"Solar\" for Sun returns or \"Lunar\" for Moon returns.</p>\n\n<p>Returns:\n    PlanetReturnModel: A comprehensive model containing the return chart data\n        for the first return found in the specified year. Includes:\n        - Exact return datetime in both UTC and local timezone\n        - Complete planetary positions at the return moment\n        - House cusps calculated for the factory's configured location\n        - All astrological chart features and calculated points\n        - Return type and subject identification</p>\n\n<p>Raises:\n    KerykeionException: If return_type is not \"Solar\" or \"Lunar\".\n    ValueError: If year is outside the valid range for ephemeris calculations.\n    SwissEphException: If astronomical calculations fail for the given year.</p>\n\n<p>Examples:\n    Calculate Solar Return for 2024:</p>\n\n<pre><code>&gt;&gt;&gt; factory = PlanetaryReturnFactory(subject, ...)\n&gt;&gt;&gt; solar_return_2024 = factory.next_return_from_year(2024, \"Solar\")\n&gt;&gt;&gt; print(f\"2024 Solar Return: {solar_return_2024.iso_formatted_local_datetime}\")\n&gt;&gt;&gt; print(f\"Birthday location: {solar_return_2024.city}, {solar_return_2024.nation}\")\n\nCalculate first Lunar Return of 2025:\n\n&gt;&gt;&gt; lunar_return = factory.next_return_from_year(2025, \"Lunar\")\n&gt;&gt;&gt; print(f\"First 2025 Lunar Return: {lunar_return.iso_formatted_local_datetime}\")\n\nCompare multiple years:\n\n&gt;&gt;&gt; for year in [2023, 2024, 2025]:\n...     solar_return = factory.next_return_from_year(year, \"Solar\")\n...     print(f\"{year}: {solar_return.iso_formatted_local_datetime}\")\n</code></pre>\n\n<p>Practical Applications:\n    - Annual Solar Return chart casting for birthday forecasting\n    - Comparative analysis of return charts across multiple years\n    - Research into planetary return timing patterns\n    - Automated birthday return calculations for consultation\n    - Educational demonstrations of annual astrological cycles</p>\n\n<p>Technical Notes:\n    - Solar returns in a given year occur near but not exactly on the birthday\n    - The exact date can vary by 1-2 days due to leap years and orbital mechanics\n    - Lunar returns occur approximately every 27.3 days throughout the year\n    - This method finds the chronologically first return in the year\n    - Return moment precision is calculated to the second</p>\n\n<p>Use Cases:\n    - Birthday return chart interpretation\n    - Annual astrological forecasting\n    - Timing analysis for major life events\n    - Comparative return chart studies\n    - Astrological consultation preparation</p>\n\n<p>See Also:\n    next_return_from_month_and_year(): For more specific monthly searches\n    next_return_from_iso_formatted_time(): For custom starting dates</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">year</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">return_type</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Lunar&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Solar&#39;</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">PlanetReturnModel</span>:</span></span>", "funcdef": "def"}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"fullname": "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year", "modulename": "kerykeion", "qualname": "PlanetaryReturnFactory.next_return_from_month_and_year", "kind": "function", "doc": "<p>Calculate the first planetary return occurring in or after a specified month and year.</p>\n\n<p>This method provides precise timing control for planetary return calculations by\nsearching from the first day of a specific month and year. It's particularly\nuseful for finding Lunar Returns in specific months or for Solar Return timing\nwhen you need to focus on a particular time period within a year.</p>\n\n<p>The method searches from the first moment (00:00:00 UTC) of the specified month\nand year, finding the next return that occurs from that point forward. This is\nespecially valuable for Lunar Return work, where multiple returns occur per year\nand you need to isolate specific monthly periods.</p>\n\n<p>Args:\n    year (int): The calendar year to search within. Must be a valid year\n        within the ephemeris data range (typically 1800-2200).\n        Examples: 2024, 2025, 1990.\n    month (int): The month to start the search from. Must be between 1 and 12,\n        where 1=January, 2=February, ..., 12=December.\n    return_type (ReturnType): The type of planetary return to calculate.\n        Must be either \"Solar\" for Sun returns or \"Lunar\" for Moon returns.</p>\n\n<p>Returns:\n    PlanetReturnModel: Comprehensive return chart data for the first return\n        found on or after the first day of the specified month and year.\n        Contains complete astrological chart information including:\n        - Precise return datetime in UTC and local timezone\n        - All planetary positions at the return moment\n        - House cusps for the factory's configured location\n        - Complete astrological subject data with all calculated features\n        - Return type identifier and naming information</p>\n\n<p>Raises:\n    KerykeionException: If month is not between 1 and 12.\n    KerykeionException: If return_type is not \"Solar\" or \"Lunar\".\n    ValueError: If year is outside valid ephemeris calculation range.\n    SwissEphException: If astronomical calculations fail.</p>\n\n<p>Examples:\n    Find Solar Return in birth month:</p>\n\n<pre><code>&gt;&gt;&gt; factory = PlanetaryReturnFactory(subject, ...)\n&gt;&gt;&gt; # Subject born in June, find 2024 Solar Return in June\n&gt;&gt;&gt; solar_return = factory.next_return_from_month_and_year(\n...     2024, 6, \"Solar\"\n... )\n&gt;&gt;&gt; print(f\"Solar Return: {solar_return.iso_formatted_local_datetime}\")\n\nFind specific Lunar Return:\n\n&gt;&gt;&gt; # Find first Lunar Return in March 2024\n&gt;&gt;&gt; lunar_return = factory.next_return_from_month_and_year(\n...     2024, 3, \"Lunar\"\n... )\n&gt;&gt;&gt; print(f\"March 2024 Lunar Return: {lunar_return.iso_formatted_local_datetime}\")\n\nMonthly Lunar Return tracking:\n\n&gt;&gt;&gt; lunar_returns_2024 = []\n&gt;&gt;&gt; for month in range(1, 13):\n...     lunar_return = factory.next_return_from_month_and_year(\n...         2024, month, \"Lunar\"\n...     )\n...     lunar_returns_2024.append(lunar_return)\n...     print(f\"Month {month}: {lunar_return.iso_formatted_local_datetime}\")\n\nSeasonal analysis:\n\n&gt;&gt;&gt; # Spring Solar Return (if birthday is in spring)\n&gt;&gt;&gt; spring_return = factory.next_return_from_month_and_year(\n...     2024, 3, \"Solar\"\n... )\n&gt;&gt;&gt; # Compare with autumn energy\n&gt;&gt;&gt; autumn_lunar = factory.next_return_from_month_and_year(\n...     2024, 9, \"Lunar\"\n... )\n</code></pre>\n\n<p>Practical Applications:\n    - Monthly Lunar Return consultation scheduling\n    - Seasonal astrological analysis and timing\n    - Comparative study of returns across different months\n    - Precise timing for astrological interventions\n    - Educational demonstrations of monthly astrological cycles\n    - Research into seasonal patterns in planetary returns</p>\n\n<p>Technical Notes:\n    - Search begins at 00:00:00 UTC on the 1st day of the specified month\n    - For Solar Returns, may find the return in a subsequent month if\n      the birthday falls late in the specified month of the previous year\n    - Lunar Returns typically occur within the specified month due to\n      their ~27-day cycle\n    - Month validation prevents common input errors\n    - All calculations maintain second-level precision</p>\n\n<p>Timing Considerations:\n    - Solar Returns: Usually occur within 1-2 days of the natal birthday\n    - Lunar Returns: Occur approximately every 27.3 days\n    - The method finds the chronologically first return from the start date\n    - Timezone differences can affect which calendar day the return occurs</p>\n\n<p>Use Cases:\n    - Monthly return chart consultations\n    - Timing specific astrological work or rituals\n    - Research into monthly astrological patterns\n    - Educational calendar planning for astrological courses\n    - Comparative return chart analysis</p>\n\n<p>See Also:\n    next_return_from_year(): For annual return calculations\n    next_return_from_iso_formatted_time(): For custom date searches</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">year</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">month</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">return_type</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Lunar&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Solar&#39;</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">PlanetReturnModel</span>:</span></span>", "funcdef": "def"}, "kerykeion.PlanetReturnModel": {"fullname": "kerykeion.PlanetReturnModel", "modulename": "kerykeion", "qualname": "PlanetReturnModel", "kind": "class", "doc": "<p>Pydantic Model for Planet Return</p>\n", "bases": "kerykeion.schemas.kr_models.AstrologicalBaseModel"}, "kerykeion.PlanetReturnModel.return_type": {"fullname": "kerykeion.PlanetReturnModel.return_type", "modulename": "kerykeion", "qualname": "PlanetReturnModel.return_type", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;Lunar&#x27;, &#x27;Solar&#x27;]"}, "kerykeion.PlanetReturnModel.model_config": {"fullname": "kerykeion.PlanetReturnModel.model_config", "modulename": "kerykeion", "qualname": "PlanetReturnModel.model_config", "kind": "variable", "doc": "<p>Configuration for the model, should be a dictionary conforming to [<code>ConfigDict</code>][pydantic.config.ConfigDict].</p>\n", "annotation": ": ClassVar[pydantic.config.ConfigDict]", "default_value": "{}"}, "kerykeion.RelationshipScoreFactory": {"fullname": "kerykeion.RelationshipScoreFactory", "modulename": "kerykeion", "qualname": "RelationshipScoreFactory", "kind": "class", "doc": "<p>Calculates relationship scores between two subjects using the Ciro Discepolo method.</p>\n\n<p>The scoring system evaluates synastry aspects between planetary positions to generate\nnumerical compatibility scores with categorical descriptions.</p>\n\n<p>Score Ranges:\n    - 0-5: Minimal relationship\n    - 5-10: Medium relationship\n    - 10-15: Important relationship\n    - 15-20: Very important relationship\n    - 20-30: Exceptional relationship\n    - 30+: Rare exceptional relationship</p>\n\n<p>Args:\n    first_subject (AstrologicalSubjectModel): First astrological subject\n    second_subject (AstrologicalSubjectModel): Second astrological subject\n    use_only_major_aspects (bool, optional): Filter to major aspects only. Defaults to True.</p>\n\n<p>Reference:\n    <a href=\"http://www.cirodiscepolo.it/Articoli/Discepoloele.htm\">http://www.cirodiscepolo.it/Articoli/Discepoloele.htm</a></p>\n"}, "kerykeion.RelationshipScoreFactory.__init__": {"fullname": "kerykeion.RelationshipScoreFactory.__init__", "modulename": "kerykeion", "qualname": "RelationshipScoreFactory.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">first_subject</span><span class=\"p\">:</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span>,</span><span class=\"param\">\t<span class=\"n\">second_subject</span><span class=\"p\">:</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span>,</span><span class=\"param\">\t<span class=\"n\">use_only_major_aspects</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span>)</span>"}, "kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"fullname": "kerykeion.RelationshipScoreFactory.SCORE_MAPPING", "modulename": "kerykeion", "qualname": "RelationshipScoreFactory.SCORE_MAPPING", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;Minimal&#x27;, 5), (&#x27;Medium&#x27;, 10), (&#x27;Important&#x27;, 15), (&#x27;Very Important&#x27;, 20), (&#x27;Exceptional&#x27;, 30), (&#x27;Rare Exceptional&#x27;, inf)]"}, "kerykeion.RelationshipScoreFactory.MAJOR_ASPECTS": {"fullname": "kerykeion.RelationshipScoreFactory.MAJOR_ASPECTS", "modulename": "kerykeion", "qualname": "RelationshipScoreFactory.MAJOR_ASPECTS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;square&#x27;, &#x27;trine&#x27;, &#x27;opposition&#x27;, &#x27;conjunction&#x27;, &#x27;sextile&#x27;}"}, "kerykeion.RelationshipScoreFactory.use_only_major_aspects": {"fullname": "kerykeion.RelationshipScoreFactory.use_only_major_aspects", "modulename": "kerykeion", "qualname": "RelationshipScoreFactory.use_only_major_aspects", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.RelationshipScoreFactory.first_subject": {"fullname": "kerykeion.RelationshipScoreFactory.first_subject", "modulename": "kerykeion", "qualname": "RelationshipScoreFactory.first_subject", "kind": "variable", "doc": "<p></p>\n", "annotation": ": kerykeion.schemas.kr_models.AstrologicalSubjectModel"}, "kerykeion.RelationshipScoreFactory.second_subject": {"fullname": "kerykeion.RelationshipScoreFactory.second_subject", "modulename": "kerykeion", "qualname": "RelationshipScoreFactory.second_subject", "kind": "variable", "doc": "<p></p>\n", "annotation": ": kerykeion.schemas.kr_models.AstrologicalSubjectModel"}, "kerykeion.RelationshipScoreFactory.score_value": {"fullname": "kerykeion.RelationshipScoreFactory.score_value", "modulename": "kerykeion", "qualname": "RelationshipScoreFactory.score_value", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.RelationshipScoreFactory.relationship_score_description": {"fullname": "kerykeion.RelationshipScoreFactory.relationship_score_description", "modulename": "kerykeion", "qualname": "RelationshipScoreFactory.relationship_score_description", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;Minimal&#x27;, &#x27;Medium&#x27;, &#x27;Important&#x27;, &#x27;Very Important&#x27;, &#x27;Exceptional&#x27;, &#x27;Rare Exceptional&#x27;]"}, "kerykeion.RelationshipScoreFactory.is_destiny_sign": {"fullname": "kerykeion.RelationshipScoreFactory.is_destiny_sign", "modulename": "kerykeion", "qualname": "RelationshipScoreFactory.is_destiny_sign", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.RelationshipScoreFactory.relationship_score_aspects": {"fullname": "kerykeion.RelationshipScoreFactory.relationship_score_aspects", "modulename": "kerykeion", "qualname": "RelationshipScoreFactory.relationship_score_aspects", "kind": "variable", "doc": "<p></p>\n", "annotation": ": list[kerykeion.schemas.kr_models.RelationshipScoreAspectModel]"}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"fullname": "kerykeion.RelationshipScoreFactory.get_relationship_score", "modulename": "kerykeion", "qualname": "RelationshipScoreFactory.get_relationship_score", "kind": "function", "doc": "<p>Calculates the complete relationship score using all evaluation methods.</p>\n\n<p>Returns:\n    RelationshipScoreModel: Score object containing numerical value, description,\n        destiny sign status, contributing aspects, and subject data.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "kerykeion.ReportGenerator": {"fullname": "kerykeion.ReportGenerator", "modulename": "kerykeion", "qualname": "ReportGenerator", "kind": "class", "doc": "<p>Create a report for a Kerykeion instance.</p>\n"}, "kerykeion.ReportGenerator.__init__": {"fullname": "kerykeion.ReportGenerator.__init__", "modulename": "kerykeion", "qualname": "ReportGenerator.__init__", "kind": "function", "doc": "<p>Initialize a new ReportGenerator instance.</p>\n\n<p>Args:\n    instance: The astrological subject model to create a report for.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">instance</span><span class=\"p\">:</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span></span>)</span>"}, "kerykeion.ReportGenerator.report_title": {"fullname": "kerykeion.ReportGenerator.report_title", "modulename": "kerykeion", "qualname": "ReportGenerator.report_title", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "kerykeion.ReportGenerator.data_table": {"fullname": "kerykeion.ReportGenerator.data_table", "modulename": "kerykeion", "qualname": "ReportGenerator.data_table", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "kerykeion.ReportGenerator.planets_table": {"fullname": "kerykeion.ReportGenerator.planets_table", "modulename": "kerykeion", "qualname": "ReportGenerator.planets_table", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "kerykeion.ReportGenerator.houses_table": {"fullname": "kerykeion.ReportGenerator.houses_table", "modulename": "kerykeion", "qualname": "ReportGenerator.houses_table", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "kerykeion.ReportGenerator.instance": {"fullname": "kerykeion.ReportGenerator.instance", "modulename": "kerykeion", "qualname": "ReportGenerator.instance", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.ReportGenerator.get_report_title": {"fullname": "kerykeion.ReportGenerator.get_report_title", "modulename": "kerykeion", "qualname": "ReportGenerator.get_report_title", "kind": "function", "doc": "<p>Generate the report title based on the subject's name.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "kerykeion.ReportGenerator.get_data_table": {"fullname": "kerykeion.ReportGenerator.get_data_table", "modulename": "kerykeion", "qualname": "ReportGenerator.get_data_table", "kind": "function", "doc": "<p>Creates the data table of the report.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "kerykeion.ReportGenerator.get_planets_table": {"fullname": "kerykeion.ReportGenerator.get_planets_table", "modulename": "kerykeion", "qualname": "ReportGenerator.get_planets_table", "kind": "function", "doc": "<p>Creates the planets table.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "kerykeion.ReportGenerator.get_houses_table": {"fullname": "kerykeion.ReportGenerator.get_houses_table", "modulename": "kerykeion", "qualname": "ReportGenerator.get_houses_table", "kind": "function", "doc": "<p>Creates the houses table.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "kerykeion.ReportGenerator.get_full_report": {"fullname": "kerykeion.ReportGenerator.get_full_report", "modulename": "kerykeion", "qualname": "ReportGenerator.get_full_report", "kind": "function", "doc": "<p>Returns the full report.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "kerykeion.ReportGenerator.print_report": {"fullname": "kerykeion.ReportGenerator.print_report", "modulename": "kerykeion", "qualname": "ReportGenerator.print_report", "kind": "function", "doc": "<p>Print the report.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "kerykeion.KerykeionSettingsModel": {"fullname": "kerykeion.KerykeionSettingsModel", "modulename": "kerykeion", "qualname": "KerykeionSettingsModel", "kind": "class", "doc": "<p>This class is used to define the global settings for the Kerykeion.</p>\n", "bases": "kerykeion.schemas.kr_models.SubscriptableBaseModel"}, "kerykeion.KerykeionSettingsModel.language_settings": {"fullname": "kerykeion.KerykeionSettingsModel.language_settings", "modulename": "kerykeion", "qualname": "KerykeionSettingsModel.language_settings", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict[str, kerykeion.schemas.settings_models.KerykeionLanguageModel]"}, "kerykeion.KerykeionSettingsModel.model_config": {"fullname": "kerykeion.KerykeionSettingsModel.model_config", "modulename": "kerykeion", "qualname": "KerykeionSettingsModel.model_config", "kind": "variable", "doc": "<p>Configuration for the model, should be a dictionary conforming to [<code>ConfigDict</code>][pydantic.config.ConfigDict].</p>\n", "annotation": ": ClassVar[pydantic.config.ConfigDict]", "default_value": "{}"}, "kerykeion.get_settings": {"fullname": "kerykeion.get_settings", "modulename": "kerykeion", "qualname": "get_settings", "kind": "function", "doc": "<p>This function is used to get the settings dict from the settings file.\nIf no settings file is passed as argument, or the file is not found, it will fallback to:</p>\n\n<ul>\n<li>The system wide config file, located in ~/.config/kerykeion/kr.config.json</li>\n<li>The default config file, located in the package folder</li>\n</ul>\n\n<p>Args:\n    new_settings_file (Union[Path, None], optional): The path of the settings file. Defaults to None.</p>\n\n<p>Returns:\n    Dict: The settings dict</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">new_settings_file</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">_local</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">settings_models</span><span class=\"o\">.</span><span class=\"n\">KerykeionSettingsModel</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">settings_models</span><span class=\"o\">.</span><span class=\"n\">KerykeionSettingsModel</span>:</span></span>", "funcdef": "def"}, "kerykeion.TransitsTimeRangeFactory": {"fullname": "kerykeion.TransitsTimeRangeFactory", "modulename": "kerykeion", "qualname": "TransitsTimeRangeFactory", "kind": "class", "doc": "<p>Factory class for calculating astrological transits over time periods.</p>\n\n<p>This class analyzes the angular relationships (aspects) between transiting\ncelestial bodies and natal chart positions across multiple time points,\ngenerating structured transit data for astrological analysis.</p>\n\n<p>The factory compares ephemeris data points (representing planetary positions\nat different moments) with a natal chart to identify when specific geometric\nconfigurations occur between transiting and natal celestial bodies.</p>\n\n<p>Args:\n    natal_chart (AstrologicalSubjectModel): The natal chart used as the reference\n        point for transit calculations. All transiting positions are compared\n        against this chart's planetary positions.\n    ephemeris_data_points (List[AstrologicalSubjectModel]): A list of astrological\n        subject models representing different moments in time, typically generated\n        by EphemerisDataFactory. Each point contains planetary positions for\n        a specific date/time.\n    active_points (List[AstrologicalPoint], optional): List of celestial bodies\n        to include in aspect calculations (e.g., Sun, Moon, planets, asteroids).\n        Defaults to DEFAULT_ACTIVE_POINTS.\n    active_aspects (List[ActiveAspect], optional): List of aspect types to\n        calculate (e.g., conjunction, opposition, trine, square, sextile).\n        Defaults to DEFAULT_ACTIVE_ASPECTS.\n    settings_file (Union[Path, KerykeionSettingsModel, dict, None], optional):\n        Configuration settings for calculations. Can be a file path, settings\n        model, dictionary, or None for defaults. Defaults to None.</p>\n\n<p>Attributes:\n    natal_chart: The reference natal chart for transit calculations.\n    ephemeris_data_points: Time-series planetary position data.\n    active_points: Celestial bodies included in calculations.\n    active_aspects: Aspect types considered for analysis.\n    settings_file: Configuration settings for the calculations.</p>\n\n<p>Examples:\n    Basic transit calculation:</p>\n\n<pre><code>&gt;&gt;&gt; natal_chart = AstrologicalSubjectFactory.from_birth_data(...)\n&gt;&gt;&gt; ephemeris_data = ephemeris_factory.get_ephemeris_data_as_astrological_subjects()\n&gt;&gt;&gt; factory = TransitsTimeRangeFactory(natal_chart, ephemeris_data)\n&gt;&gt;&gt; transits = factory.get_transit_moments()\n\nCustom configuration:\n\n&gt;&gt;&gt; from kerykeion.schemas import AstrologicalPoint, ActiveAspect\n&gt;&gt;&gt; custom_points = [\"Sun\", \"Moon\"]\n&gt;&gt;&gt; custom_aspects = [ActiveAspect.CONJUNCTION, ActiveAspect.OPPOSITION]\n&gt;&gt;&gt; factory = TransitsTimeRangeFactory(\n...     natal_chart, ephemeris_data,\n...     active_points=custom_points,\n...     active_aspects=custom_aspects\n... )\n</code></pre>\n\n<p>Note:\n    - Calculation time scales with the number of ephemeris data points\n    - More active points and aspects increase computational requirements\n    - The natal chart's coordinate system should match the ephemeris data</p>\n"}, "kerykeion.TransitsTimeRangeFactory.__init__": {"fullname": "kerykeion.TransitsTimeRangeFactory.__init__", "modulename": "kerykeion", "qualname": "TransitsTimeRangeFactory.__init__", "kind": "function", "doc": "<p>Initialize the TransitsTimeRangeFactory with calculation parameters.</p>\n\n<p>Sets up the factory with all necessary data and configuration for calculating\ntransits across the specified time period. The natal chart serves as the\nreference point, while ephemeris data points provide the transiting positions\nfor comparison.</p>\n\n<p>Args:\n    natal_chart (AstrologicalSubjectModel): Reference natal chart containing\n        the baseline planetary positions for transit calculations.\n    ephemeris_data_points (List[AstrologicalSubjectModel]): Time-ordered list\n        of planetary positions representing different moments in time.\n        Typically generated by EphemerisDataFactory.\n    active_points (List[AstrologicalPoint], optional): Celestial bodies to\n        include in aspect calculations. Determines which planets/points are\n        analyzed for aspects. Defaults to DEFAULT_ACTIVE_POINTS.\n    active_aspects (List[ActiveAspect], optional): Types of angular relationships\n        to calculate between natal and transiting positions. Defaults to\n        DEFAULT_ACTIVE_ASPECTS.\n    settings_file (Union[Path, KerykeionSettingsModel, dict, None], optional):\n        Configuration settings for orb tolerances, calculation methods, and\n        other parameters. Defaults to None (uses system defaults).</p>\n\n<p>Note:\n    - All ephemeris data points should use the same coordinate system as the natal chart\n    - The order of ephemeris_data_points determines the chronological sequence\n    - Settings affect orb tolerances and calculation precision</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">natal_chart</span><span class=\"p\">:</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span>,</span><span class=\"param\">\t<span class=\"n\">ephemeris_data_points</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">AstrologicalSubjectModel</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">active_points</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;Sun&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Moon&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mercury&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Venus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mars&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Jupiter&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Saturn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Uranus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Neptune&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pluto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Chiron&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Earth&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pholus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ceres&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pallas&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Juno&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vesta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Eris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Sedna&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Haumea&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Makemake&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ixion&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Orcus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Quaoar&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Regulus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Spica&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fortunae&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Spiritus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Amoris&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pars_Fidei&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Anti_Vertex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ascendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Medium_Coeli&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Descendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Imum_Coeli&#39;</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"p\">[</span><span class=\"s1\">&#39;Sun&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Moon&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mercury&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Venus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mars&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Jupiter&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Saturn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Uranus&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Neptune&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Pluto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;True_South_Node&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Chiron&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Mean_Lilith&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Ascendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Medium_Coeli&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Descendant&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;Imum_Coeli&#39;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">active_aspects</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">ActiveAspect</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">[{</span><span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;conjunction&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;orb&#39;</span><span class=\"p\">:</span> <span class=\"mi\">10</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;opposition&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;orb&#39;</span><span class=\"p\">:</span> <span class=\"mi\">10</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;trine&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;orb&#39;</span><span class=\"p\">:</span> <span class=\"mi\">8</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;sextile&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;orb&#39;</span><span class=\"p\">:</span> <span class=\"mi\">6</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;square&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;orb&#39;</span><span class=\"p\">:</span> <span class=\"mi\">5</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;name&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;quintile&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;orb&#39;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">}]</span>,</span><span class=\"param\">\t<span class=\"n\">settings_file</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">_local</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">,</span> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">settings_models</span><span class=\"o\">.</span><span class=\"n\">KerykeionSettingsModel</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "kerykeion.TransitsTimeRangeFactory.natal_chart": {"fullname": "kerykeion.TransitsTimeRangeFactory.natal_chart", "modulename": "kerykeion", "qualname": "TransitsTimeRangeFactory.natal_chart", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.TransitsTimeRangeFactory.ephemeris_data_points": {"fullname": "kerykeion.TransitsTimeRangeFactory.ephemeris_data_points", "modulename": "kerykeion", "qualname": "TransitsTimeRangeFactory.ephemeris_data_points", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.TransitsTimeRangeFactory.active_points": {"fullname": "kerykeion.TransitsTimeRangeFactory.active_points", "modulename": "kerykeion", "qualname": "TransitsTimeRangeFactory.active_points", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.TransitsTimeRangeFactory.active_aspects": {"fullname": "kerykeion.TransitsTimeRangeFactory.active_aspects", "modulename": "kerykeion", "qualname": "TransitsTimeRangeFactory.active_aspects", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.TransitsTimeRangeFactory.settings_file": {"fullname": "kerykeion.TransitsTimeRangeFactory.settings_file", "modulename": "kerykeion", "qualname": "TransitsTimeRangeFactory.settings_file", "kind": "variable", "doc": "<p></p>\n"}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"fullname": "kerykeion.TransitsTimeRangeFactory.get_transit_moments", "modulename": "kerykeion", "qualname": "TransitsTimeRangeFactory.get_transit_moments", "kind": "function", "doc": "<p>Calculate and generate transit data for all configured time points.</p>\n\n<p>This method processes each ephemeris data point to identify angular relationships\n(aspects) between transiting celestial bodies and natal chart positions. It\ncreates a comprehensive model containing all transit moments with their\ncorresponding aspects and timestamps.</p>\n\n<p>The calculation process:</p>\n\n<ol>\n<li>Iterates through each ephemeris data point chronologically</li>\n<li>Compares transiting planetary positions with natal chart positions</li>\n<li>Identifies aspects that fall within the configured orb tolerances</li>\n<li>Creates timestamped transit moment records</li>\n<li>Compiles all data into a structured model for analysis</li>\n</ol>\n\n<p>Returns:\n    TransitsTimeRangeModel: A comprehensive model containing:\n        - dates (List[str]): ISO-formatted datetime strings for all data points\n        - subject (AstrologicalSubjectModel): The natal chart used as reference\n        - transits (List[TransitMomentModel]): Chronological list of transit moments,\n          each containing:\n          * date (str): ISO-formatted timestamp for the transit moment\n          * aspects (List[RelevantAspect]): All aspects formed at this moment\n            between transiting and natal positions</p>\n\n<p>Examples:\n    Basic usage:</p>\n\n<pre><code>&gt;&gt;&gt; factory = TransitsTimeRangeFactory(natal_chart, ephemeris_data)\n&gt;&gt;&gt; results = factory.get_transit_moments()\n&gt;&gt;&gt;\n&gt;&gt;&gt; # Access specific data\n&gt;&gt;&gt; all_dates = results.dates\n&gt;&gt;&gt; first_transit = results.transits[0]\n&gt;&gt;&gt; aspects_at_first_moment = first_transit.aspects\n\nProcessing results:\n\n&gt;&gt;&gt; results = factory.get_transit_moments()\n&gt;&gt;&gt; for transit_moment in results.transits:\n...     print(f\"Date: {transit_moment.date}\")\n...     for aspect in transit_moment.aspects:\n...         print(f\"  {aspect.p1_name} {aspect.aspect} {aspect.p2_name}\")\n</code></pre>\n\n<p>Performance Notes:\n    - Calculation time is proportional to: number of time points \u00d7 active points \u00d7 active aspects\n    - Large datasets may require significant processing time\n    - Memory usage scales with the number of aspects found\n    - Consider filtering active_points and active_aspects for better performance</p>\n\n<p>See Also:\n    TransitMomentModel: Individual transit moment structure\n    TransitsTimeRangeModel: Complete transit dataset structure\n    AspectsFactory: Underlying aspect calculation engine</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">kerykeion</span><span class=\"o\">.</span><span class=\"n\">schemas</span><span class=\"o\">.</span><span class=\"n\">kr_models</span><span class=\"o\">.</span><span class=\"n\">TransitsTimeRangeModel</span>:</span></span>", "funcdef": "def"}}, "docInfo": {"kerykeion": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7538}, "kerykeion.AspectsFactory": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 218}, "kerykeion.AspectsFactory.single_chart_aspects": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 615, "bases": 0, "doc": 147}, "kerykeion.AspectsFactory.dual_chart_aspects": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 694, "bases": 0, "doc": 199}, "kerykeion.AspectsFactory.natal_aspects": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 615, "bases": 0, "doc": 27}, "kerykeion.AspectsFactory.synastry_aspects": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 694, "bases": 0, "doc": 27}, "kerykeion.AstrologicalSubjectFactory": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 384}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 1658, "bases": 0, "doc": 757}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"qualname": 5, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 1483, "bases": 0, "doc": 496}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 1474, "bases": 0, "doc": 456}, "kerykeion.ChartDrawer": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 534}, "kerykeion.ChartDrawer.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 7213, "bases": 0, "doc": 181}, "kerykeion.ChartDrawer.first_obj": {"qualname": 3, "fullname": 4, "annotation": 16, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.second_obj": {"qualname": 3, "fullname": 4, "annotation": 12, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.chart_type": {"qualname": 3, "fullname": 4, "annotation": 24, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.new_output_directory": {"qualname": 4, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.new_settings_file": {"qualname": 4, "fullname": 5, "annotation": 11, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.output_directory": {"qualname": 3, "fullname": 4, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.theme": {"qualname": 2, "fullname": 3, "annotation": 20, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"qualname": 6, "fullname": 7, "annotation": 9, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.chart_language": {"qualname": 3, "fullname": 4, "annotation": 33, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.active_points": {"qualname": 3, "fullname": 4, "annotation": 144, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.active_aspects": {"qualname": 3, "fullname": 4, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.transparent_background": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.fire": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.earth": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.air": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.water": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.first_circle_radius": {"qualname": 4, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.second_circle_radius": {"qualname": 4, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.third_circle_radius": {"qualname": 4, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.width": {"qualname": 2, "fullname": 3, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.language_settings": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.chart_colors_settings": {"qualname": 4, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.planets_settings": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.aspects_settings": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.available_planets_setting": {"qualname": 4, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.height": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.location": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.geolat": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.geolon": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.template": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.main_radius": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.available_kerykeion_celestial_points": {"qualname": 5, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.cardinal": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.fixed": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.mutable": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ChartDrawer.set_up_theme": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 89, "bases": 0, "doc": 34}, "kerykeion.ChartDrawer.set_output_directory": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 26}, "kerykeion.ChartDrawer.parse_json_settings": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 80, "bases": 0, "doc": 27}, "kerykeion.ChartDrawer.makeTemplate": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 43, "bases": 0, "doc": 61}, "kerykeion.ChartDrawer.makeSVG": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 40, "bases": 0, "doc": 67}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 40, "bases": 0, "doc": 65}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 40, "bases": 0, "doc": 65}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 40, "bases": 0, "doc": 71}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 40, "bases": 0, "doc": 67}, "kerykeion.CompositeSubjectFactory": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 335}, "kerykeion.CompositeSubjectFactory.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 85, "bases": 0, "doc": 117}, "kerykeion.CompositeSubjectFactory.model": {"qualname": 2, "fullname": 3, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.CompositeSubjectFactory.first_subject": {"qualname": 3, "fullname": 4, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.CompositeSubjectFactory.second_subject": {"qualname": 3, "fullname": 4, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.CompositeSubjectFactory.name": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.CompositeSubjectFactory.composite_chart_type": {"qualname": 4, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.CompositeSubjectFactory.zodiac_type": {"qualname": 3, "fullname": 4, "annotation": 9, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.CompositeSubjectFactory.sidereal_mode": {"qualname": 3, "fullname": 4, "annotation": 72, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.CompositeSubjectFactory.houses_system_identifier": {"qualname": 4, "fullname": 5, "annotation": 72, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.CompositeSubjectFactory.houses_system_name": {"qualname": 4, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.CompositeSubjectFactory.perspective_type": {"qualname": 3, "fullname": 4, "annotation": 17, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.CompositeSubjectFactory.houses_names_list": {"qualname": 4, "fullname": 5, "annotation": 52, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.CompositeSubjectFactory.active_points": {"qualname": 3, "fullname": 4, "annotation": 145, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"qualname": 6, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 200}, "kerykeion.EphemerisDataFactory": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 585}, "kerykeion.EphemerisDataFactory.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 859, "bases": 0, "doc": 3}, "kerykeion.EphemerisDataFactory.start_datetime": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.EphemerisDataFactory.end_datetime": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.EphemerisDataFactory.step_type": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.EphemerisDataFactory.step": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.EphemerisDataFactory.lat": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.EphemerisDataFactory.lng": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.EphemerisDataFactory.tz_str": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.EphemerisDataFactory.is_dst": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.EphemerisDataFactory.zodiac_type": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.EphemerisDataFactory.sidereal_mode": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.EphemerisDataFactory.houses_system_identifier": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.EphemerisDataFactory.perspective_type": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.EphemerisDataFactory.max_days": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.EphemerisDataFactory.max_hours": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.EphemerisDataFactory.max_minutes": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.EphemerisDataFactory.dates_list": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 388}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"qualname": 7, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 56, "bases": 0, "doc": 474}, "kerykeion.HouseComparisonFactory": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 138}, "kerykeion.HouseComparisonFactory.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 763, "bases": 0, "doc": 56}, "kerykeion.HouseComparisonFactory.first_subject": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.HouseComparisonFactory.second_subject": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.HouseComparisonFactory.active_points": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 108}, "kerykeion.HouseComparisonModel": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 79}, "kerykeion.HouseComparisonModel.first_subject_name": {"qualname": 4, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "kerykeion.HouseComparisonModel.second_subject_name": {"qualname": 4, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"qualname": 6, "fullname": 7, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"qualname": 6, "fullname": 7, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "kerykeion.HouseComparisonModel.model_config": {"qualname": 3, "fullname": 4, "annotation": 4, "default_value": 1, "signature": 0, "bases": 0, "doc": 18}, "kerykeion.PlanetaryReturnFactory": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 715}, "kerykeion.PlanetaryReturnFactory.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 282, "bases": 0, "doc": 594}, "kerykeion.PlanetaryReturnFactory.subject": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.PlanetaryReturnFactory.online": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.PlanetaryReturnFactory.cache_expire_after_days": {"qualname": 5, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.PlanetaryReturnFactory.altitude": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"qualname": 7, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 76, "bases": 0, "doc": 612}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"qualname": 5, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 74, "bases": 0, "doc": 550}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"qualname": 7, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 85, "bases": 0, "doc": 714}, "kerykeion.PlanetReturnModel": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 7}, "kerykeion.PlanetReturnModel.return_type": {"qualname": 3, "fullname": 4, "annotation": 9, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.PlanetReturnModel.model_config": {"qualname": 3, "fullname": 4, "annotation": 4, "default_value": 1, "signature": 0, "bases": 0, "doc": 18}, "kerykeion.RelationshipScoreFactory": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 105}, "kerykeion.RelationshipScoreFactory.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 81, "bases": 0, "doc": 3}, "kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 28, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.RelationshipScoreFactory.MAJOR_ASPECTS": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 17, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.RelationshipScoreFactory.use_only_major_aspects": {"qualname": 5, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.RelationshipScoreFactory.first_subject": {"qualname": 3, "fullname": 4, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.RelationshipScoreFactory.second_subject": {"qualname": 3, "fullname": 4, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.RelationshipScoreFactory.score_value": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.RelationshipScoreFactory.relationship_score_description": {"qualname": 4, "fullname": 5, "annotation": 23, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.RelationshipScoreFactory.is_destiny_sign": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.RelationshipScoreFactory.relationship_score_aspects": {"qualname": 4, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 31}, "kerykeion.ReportGenerator": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "kerykeion.ReportGenerator.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 22}, "kerykeion.ReportGenerator.report_title": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ReportGenerator.data_table": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ReportGenerator.planets_table": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ReportGenerator.houses_table": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ReportGenerator.instance": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.ReportGenerator.get_report_title": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 13}, "kerykeion.ReportGenerator.get_data_table": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 10}, "kerykeion.ReportGenerator.get_planets_table": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 7}, "kerykeion.ReportGenerator.get_houses_table": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 7}, "kerykeion.ReportGenerator.get_full_report": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 7}, "kerykeion.ReportGenerator.print_report": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 6}, "kerykeion.KerykeionSettingsModel": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 15}, "kerykeion.KerykeionSettingsModel.language_settings": {"qualname": 3, "fullname": 4, "annotation": 7, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.KerykeionSettingsModel.model_config": {"qualname": 3, "fullname": 4, "annotation": 4, "default_value": 1, "signature": 0, "bases": 0, "doc": 18}, "kerykeion.get_settings": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 96, "bases": 0, "doc": 88}, "kerykeion.TransitsTimeRangeFactory": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 378}, "kerykeion.TransitsTimeRangeFactory.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 1032, "bases": 0, "doc": 190}, "kerykeion.TransitsTimeRangeFactory.natal_chart": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.TransitsTimeRangeFactory.ephemeris_data_points": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.TransitsTimeRangeFactory.active_points": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.TransitsTimeRangeFactory.active_aspects": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.TransitsTimeRangeFactory.settings_file": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 339}}, "length": 152, "save": true}, "index": {"qualname": {"root": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 8, "a": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.ChartDrawer.active_aspects": {"tf": 1}, "kerykeion.ChartDrawer.aspects_settings": {"tf": 1}, "kerykeion.RelationshipScoreFactory.MAJOR_ASPECTS": {"tf": 1}, "kerykeion.RelationshipScoreFactory.use_only_major_aspects": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_aspects": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.active_aspects": {"tf": 1}}, "df": 10, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}}, "df": 5}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}}, "df": 4}}}}}}}}}}}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.ChartDrawer.active_aspects": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}, "kerykeion.HouseComparisonFactory.active_points": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.active_points": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.active_aspects": {"tf": 1}}, "df": 6}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.ChartDrawer.air": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.available_planets_setting": {"tf": 1}, "kerykeion.ChartDrawer.available_kerykeion_celestial_points": {"tf": 1}}, "df": 2}}}}}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.PlanetaryReturnFactory.cache_expire_after_days": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory.altitude": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}, "kerykeion.EphemerisDataFactory.sidereal_mode": {"tf": 1}}, "df": 2}}}}}}, "g": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.RelationshipScoreFactory.is_destiny_sign": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_system_name": {"tf": 1}, "kerykeion.EphemerisDataFactory.houses_system_identifier": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.ChartDrawer.second_obj": {"tf": 1}, "kerykeion.ChartDrawer.second_circle_radius": {"tf": 1}, "kerykeion.CompositeSubjectFactory.second_subject": {"tf": 1}, "kerykeion.HouseComparisonFactory.second_subject": {"tf": 1}, "kerykeion.HouseComparisonModel.second_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}, "kerykeion.RelationshipScoreFactory.second_subject": {"tf": 1}}, "df": 8}}}}, "t": {"docs": {"kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.ChartDrawer.available_planets_setting": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.ChartDrawer.new_settings_file": {"tf": 1}, "kerykeion.ChartDrawer.language_settings": {"tf": 1}, "kerykeion.ChartDrawer.chart_colors_settings": {"tf": 1}, "kerykeion.ChartDrawer.planets_settings": {"tf": 1}, "kerykeion.ChartDrawer.aspects_settings": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.KerykeionSettingsModel.language_settings": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.settings_file": {"tf": 1}}, "df": 9}}}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.CompositeSubjectFactory.first_subject": {"tf": 1}, "kerykeion.CompositeSubjectFactory.second_subject": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.HouseComparisonFactory.first_subject": {"tf": 1}, "kerykeion.HouseComparisonFactory.second_subject": {"tf": 1}, "kerykeion.HouseComparisonModel.first_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.second_subject_name": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.first_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.second_subject": {"tf": 1}}, "df": 10, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.EphemerisDataFactory.start_datetime": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {"kerykeion.EphemerisDataFactory.step_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.step": {"tf": 1}}, "df": 2}}, "r": {"docs": {"kerykeion.EphemerisDataFactory.tz_str": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1}, "kerykeion.RelationshipScoreFactory.score_value": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_aspects": {"tf": 1}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}}, "df": 5}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.ChartDrawer.chart_type": {"tf": 1}, "kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 1}, "kerykeion.ChartDrawer.chart_language": {"tf": 1}, "kerykeion.ChartDrawer.chart_colors_settings": {"tf": 1}, "kerykeion.CompositeSubjectFactory.composite_chart_type": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.natal_chart": {"tf": 1}}, "df": 8}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.first_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.second_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.third_circle_radius": {"tf": 1}}, "df": 3}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.chart_colors_settings": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.CompositeSubjectFactory.composite_chart_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory.model": {"tf": 1}, "kerykeion.CompositeSubjectFactory.first_subject": {"tf": 1}, "kerykeion.CompositeSubjectFactory.second_subject": {"tf": 1}, "kerykeion.CompositeSubjectFactory.name": {"tf": 1}, "kerykeion.CompositeSubjectFactory.composite_chart_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.zodiac_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_system_name": {"tf": 1}, "kerykeion.CompositeSubjectFactory.perspective_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}}, "df": 15}}}}}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.available_kerykeion_celestial_points": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.cardinal": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory.cache_expire_after_days": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.ReportGenerator.data_table": {"tf": 1}, "kerykeion.ReportGenerator.get_data_table": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.ephemeris_data_points": {"tf": 1}}, "df": 6}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.EphemerisDataFactory.start_datetime": {"tf": 1}, "kerykeion.EphemerisDataFactory.end_datetime": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {"kerykeion.EphemerisDataFactory.dates_list": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.max_days": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.cache_expire_after_days": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.ChartDrawer.new_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.output_directory": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}}, "df": 3}}}}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.EphemerisDataFactory.is_dst": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.RelationshipScoreFactory.is_destiny_sign": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.natal_chart": {"tf": 1}}, "df": 2}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.CompositeSubjectFactory.name": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_system_name": {"tf": 1}, "kerykeion.HouseComparisonModel.first_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.second_subject_name": {"tf": 1}}, "df": 4, "s": {"docs": {"kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "w": {"docs": {"kerykeion.ChartDrawer.new_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.new_settings_file": {"tf": 1}}, "df": 2}, "x": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 3}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 6}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.first_obj": {"tf": 1}, "kerykeion.ChartDrawer.first_circle_radius": {"tf": 1}, "kerykeion.CompositeSubjectFactory.first_subject": {"tf": 1}, "kerykeion.HouseComparisonFactory.first_subject": {"tf": 1}, "kerykeion.HouseComparisonModel.first_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}, "kerykeion.RelationshipScoreFactory.first_subject": {"tf": 1}}, "df": 8}}, "e": {"docs": {"kerykeion.ChartDrawer.fire": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.new_settings_file": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.settings_file": {"tf": 1}}, "df": 2}}, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.ChartDrawer.fixed": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ReportGenerator.get_full_report": {"tf": 1}}, "df": 1}}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.ChartDrawer.transparent_background": {"tf": 1}}, "df": 1}}}}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.is_dst": {"tf": 1}, "kerykeion.RelationshipScoreFactory.is_destiny_sign": {"tf": 1}}, "df": 2, "o": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 2}}, "n": {"docs": {"kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 8}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ReportGenerator.instance": {"tf": 1}}, "df": 1}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}, "kerykeion.EphemerisDataFactory.houses_system_identifier": {"tf": 1}}, "df": 2}}}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}, "p": {"docs": {"kerykeion.ChartDrawer.set_up_theme": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.RelationshipScoreFactory.use_only_major_aspects": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 3}}, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ReportGenerator.report_title": {"tf": 1}, "kerykeion.ReportGenerator.get_report_title": {"tf": 1}}, "df": 2}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.chart_type": {"tf": 1}, "kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.composite_chart_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.zodiac_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.perspective_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.step_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.zodiac_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.perspective_type": {"tf": 1}, "kerykeion.PlanetReturnModel.return_type": {"tf": 1}}, "df": 9}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.theme": {"tf": 1}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.ChartDrawer.third_circle_radius": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.transparent_background": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.natal_chart": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.ephemeris_data_points": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.active_points": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.active_aspects": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.settings_file": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 8}}}}}}}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.template": {"tf": 1}}, "df": 1}}}}}}}, "z": {"docs": {"kerykeion.EphemerisDataFactory.tz_str": {"tf": 1}}, "df": 1}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ReportGenerator.data_table": {"tf": 1}, "kerykeion.ReportGenerator.planets_table": {"tf": 1}, "kerykeion.ReportGenerator.houses_table": {"tf": 1}, "kerykeion.ReportGenerator.get_data_table": {"tf": 1}, "kerykeion.ReportGenerator.get_planets_table": {"tf": 1}, "kerykeion.ReportGenerator.get_houses_table": {"tf": 1}}, "df": 6}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.available_kerykeion_celestial_points": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.first_obj": {"tf": 1}, "kerykeion.ChartDrawer.second_obj": {"tf": 1}, "kerykeion.ChartDrawer.chart_type": {"tf": 1}, "kerykeion.ChartDrawer.new_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.new_settings_file": {"tf": 1}, "kerykeion.ChartDrawer.output_directory": {"tf": 1}, "kerykeion.ChartDrawer.theme": {"tf": 1}, "kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 1}, "kerykeion.ChartDrawer.chart_language": {"tf": 1}, "kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.ChartDrawer.active_aspects": {"tf": 1}, "kerykeion.ChartDrawer.transparent_background": {"tf": 1}, "kerykeion.ChartDrawer.fire": {"tf": 1}, "kerykeion.ChartDrawer.earth": {"tf": 1}, "kerykeion.ChartDrawer.air": {"tf": 1}, "kerykeion.ChartDrawer.water": {"tf": 1}, "kerykeion.ChartDrawer.first_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.second_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.third_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.width": {"tf": 1}, "kerykeion.ChartDrawer.language_settings": {"tf": 1}, "kerykeion.ChartDrawer.chart_colors_settings": {"tf": 1}, "kerykeion.ChartDrawer.planets_settings": {"tf": 1}, "kerykeion.ChartDrawer.aspects_settings": {"tf": 1}, "kerykeion.ChartDrawer.available_planets_setting": {"tf": 1}, "kerykeion.ChartDrawer.height": {"tf": 1}, "kerykeion.ChartDrawer.location": {"tf": 1}, "kerykeion.ChartDrawer.geolat": {"tf": 1}, "kerykeion.ChartDrawer.geolon": {"tf": 1}, "kerykeion.ChartDrawer.template": {"tf": 1}, "kerykeion.ChartDrawer.main_radius": {"tf": 1}, "kerykeion.ChartDrawer.available_kerykeion_celestial_points": {"tf": 1}, "kerykeion.ChartDrawer.cardinal": {"tf": 1}, "kerykeion.ChartDrawer.fixed": {"tf": 1}, "kerykeion.ChartDrawer.mutable": {"tf": 1}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}}, "df": 46}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.KerykeionSettingsModel": {"tf": 1}, "kerykeion.KerykeionSettingsModel.language_settings": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {"kerykeion.ChartDrawer.first_obj": {"tf": 1}, "kerykeion.ChartDrawer.second_obj": {"tf": 1}}, "df": 2}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.new_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.output_directory": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}}, "df": 3}}}}}, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory.online": {"tf": 1}}, "df": 1}}}, "y": {"docs": {"kerykeion.RelationshipScoreFactory.use_only_major_aspects": {"tf": 1}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.geolat": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.geolon": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}, "kerykeion.ReportGenerator.get_report_title": {"tf": 1}, "kerykeion.ReportGenerator.get_data_table": {"tf": 1}, "kerykeion.ReportGenerator.get_planets_table": {"tf": 1}, "kerykeion.ReportGenerator.get_houses_table": {"tf": 1}, "kerykeion.ReportGenerator.get_full_report": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 12}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.chart_language": {"tf": 1}, "kerykeion.ChartDrawer.language_settings": {"tf": 1}, "kerykeion.KerykeionSettingsModel.language_settings": {"tf": 1}}, "df": 3}}}}}}, "t": {"docs": {"kerykeion.EphemerisDataFactory.lat": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.location": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}, "kerykeion.EphemerisDataFactory.dates_list": {"tf": 1}}, "df": 2}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.EphemerisDataFactory.lng": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.ChartDrawer.available_kerykeion_celestial_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}, "kerykeion.HouseComparisonFactory.active_points": {"tf": 1}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.ephemeris_data_points": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.active_points": {"tf": 1}}, "df": 8}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.planets_settings": {"tf": 1}, "kerykeion.ChartDrawer.available_planets_setting": {"tf": 1}, "kerykeion.ReportGenerator.planets_table": {"tf": 1}, "kerykeion.ReportGenerator.get_planets_table": {"tf": 1}}, "df": 4}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.subject": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.online": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.cache_expire_after_days": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.altitude": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 9}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.PlanetReturnModel": {"tf": 1}, "kerykeion.PlanetReturnModel.return_type": {"tf": 1}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.CompositeSubjectFactory.perspective_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.perspective_type": {"tf": 1}}, "df": 2}}}}}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ReportGenerator.print_report": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.ChartDrawer.earth": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.ephemeris_data_points": {"tf": 1}}, "df": 3, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory.start_datetime": {"tf": 1}, "kerykeion.EphemerisDataFactory.end_datetime": {"tf": 1}, "kerykeion.EphemerisDataFactory.step_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.step": {"tf": 1}, "kerykeion.EphemerisDataFactory.lat": {"tf": 1}, "kerykeion.EphemerisDataFactory.lng": {"tf": 1}, "kerykeion.EphemerisDataFactory.tz_str": {"tf": 1}, "kerykeion.EphemerisDataFactory.is_dst": {"tf": 1}, "kerykeion.EphemerisDataFactory.zodiac_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.sidereal_mode": {"tf": 1}, "kerykeion.EphemerisDataFactory.houses_system_identifier": {"tf": 1}, "kerykeion.EphemerisDataFactory.perspective_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.max_days": {"tf": 1}, "kerykeion.EphemerisDataFactory.max_hours": {"tf": 1}, "kerykeion.EphemerisDataFactory.max_minutes": {"tf": 1}, "kerykeion.EphemerisDataFactory.dates_list": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 20}}}}}}}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.EphemerisDataFactory.end_datetime": {"tf": 1}}, "df": 1}}, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory.cache_expire_after_days": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.ChartDrawer.water": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.ChartDrawer.width": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.first_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.second_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.third_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.main_radius": {"tf": 1}}, "df": 4}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.PlanetReturnModel.return_type": {"tf": 1}}, "df": 4}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {"kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_aspects": {"tf": 1}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}}, "df": 3, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.RelationshipScoreFactory": {"tf": 1}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1}, "kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1}, "kerykeion.RelationshipScoreFactory.MAJOR_ASPECTS": {"tf": 1}, "kerykeion.RelationshipScoreFactory.use_only_major_aspects": {"tf": 1}, "kerykeion.RelationshipScoreFactory.first_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.second_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.score_value": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 1}, "kerykeion.RelationshipScoreFactory.is_destiny_sign": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_aspects": {"tf": 1}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}}, "df": 12}}}}}}}}}}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ReportGenerator": {"tf": 1}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.ReportGenerator.report_title": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator.data_table": {"tf": 1}, "kerykeion.ReportGenerator.planets_table": {"tf": 1}, "kerykeion.ReportGenerator.houses_table": {"tf": 1}, "kerykeion.ReportGenerator.instance": {"tf": 1}, "kerykeion.ReportGenerator.get_report_title": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator.get_data_table": {"tf": 1}, "kerykeion.ReportGenerator.get_planets_table": {"tf": 1}, "kerykeion.ReportGenerator.get_houses_table": {"tf": 1}, "kerykeion.ReportGenerator.get_full_report": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator.print_report": {"tf": 1.4142135623730951}}, "df": 13}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.height": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_system_name": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}, "kerykeion.EphemerisDataFactory.houses_system_identifier": {"tf": 1}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}, "kerykeion.ReportGenerator.houses_table": {"tf": 1}, "kerykeion.ReportGenerator.get_houses_table": {"tf": 1}}, "df": 8}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory.first_subject": {"tf": 1}, "kerykeion.HouseComparisonFactory.second_subject": {"tf": 1}, "kerykeion.HouseComparisonFactory.active_points": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}}, "df": 6}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.HouseComparisonModel": {"tf": 1}, "kerykeion.HouseComparisonModel.first_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.second_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.model_config": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.max_hours": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.main_radius": {"tf": 1}}, "df": 1}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.makeTemplate": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.ChartDrawer.makeSVG": {"tf": 1}}, "df": 1}}}, "w": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}, "x": {"docs": {"kerykeion.EphemerisDataFactory.max_days": {"tf": 1}, "kerykeion.EphemerisDataFactory.max_hours": {"tf": 1}, "kerykeion.EphemerisDataFactory.max_minutes": {"tf": 1}}, "df": 3}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1}}, "df": 1}}}}}, "j": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.RelationshipScoreFactory.MAJOR_ASPECTS": {"tf": 1}, "kerykeion.RelationshipScoreFactory.use_only_major_aspects": {"tf": 1}}, "df": 2}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.mutable": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}, "kerykeion.EphemerisDataFactory.sidereal_mode": {"tf": 1}}, "df": 2, "l": {"docs": {"kerykeion.CompositeSubjectFactory.model": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}}, "df": 5}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.max_minutes": {"tf": 1}}, "df": 1}}}}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}}, "df": 1}}}}, "z": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.CompositeSubjectFactory.zodiac_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.zodiac_type": {"tf": 1}}, "df": 2}}}}}}, "y": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 2}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.RelationshipScoreFactory.score_value": {"tf": 1}}, "df": 1}}}}}}}, "fullname": {"root": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 8, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.first_obj": {"tf": 1}, "kerykeion.ChartDrawer.second_obj": {"tf": 1}, "kerykeion.ChartDrawer.chart_type": {"tf": 1}, "kerykeion.ChartDrawer.new_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.new_settings_file": {"tf": 1}, "kerykeion.ChartDrawer.output_directory": {"tf": 1}, "kerykeion.ChartDrawer.theme": {"tf": 1}, "kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 1}, "kerykeion.ChartDrawer.chart_language": {"tf": 1}, "kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.ChartDrawer.active_aspects": {"tf": 1}, "kerykeion.ChartDrawer.transparent_background": {"tf": 1}, "kerykeion.ChartDrawer.fire": {"tf": 1}, "kerykeion.ChartDrawer.earth": {"tf": 1}, "kerykeion.ChartDrawer.air": {"tf": 1}, "kerykeion.ChartDrawer.water": {"tf": 1}, "kerykeion.ChartDrawer.first_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.second_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.third_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.width": {"tf": 1}, "kerykeion.ChartDrawer.language_settings": {"tf": 1}, "kerykeion.ChartDrawer.chart_colors_settings": {"tf": 1}, "kerykeion.ChartDrawer.planets_settings": {"tf": 1}, "kerykeion.ChartDrawer.aspects_settings": {"tf": 1}, "kerykeion.ChartDrawer.available_planets_setting": {"tf": 1}, "kerykeion.ChartDrawer.height": {"tf": 1}, "kerykeion.ChartDrawer.location": {"tf": 1}, "kerykeion.ChartDrawer.geolat": {"tf": 1}, "kerykeion.ChartDrawer.geolon": {"tf": 1}, "kerykeion.ChartDrawer.template": {"tf": 1}, "kerykeion.ChartDrawer.main_radius": {"tf": 1}, "kerykeion.ChartDrawer.available_kerykeion_celestial_points": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.cardinal": {"tf": 1}, "kerykeion.ChartDrawer.fixed": {"tf": 1}, "kerykeion.ChartDrawer.mutable": {"tf": 1}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory.model": {"tf": 1}, "kerykeion.CompositeSubjectFactory.first_subject": {"tf": 1}, "kerykeion.CompositeSubjectFactory.second_subject": {"tf": 1}, "kerykeion.CompositeSubjectFactory.name": {"tf": 1}, "kerykeion.CompositeSubjectFactory.composite_chart_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.zodiac_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_system_name": {"tf": 1}, "kerykeion.CompositeSubjectFactory.perspective_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory.start_datetime": {"tf": 1}, "kerykeion.EphemerisDataFactory.end_datetime": {"tf": 1}, "kerykeion.EphemerisDataFactory.step_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.step": {"tf": 1}, "kerykeion.EphemerisDataFactory.lat": {"tf": 1}, "kerykeion.EphemerisDataFactory.lng": {"tf": 1}, "kerykeion.EphemerisDataFactory.tz_str": {"tf": 1}, "kerykeion.EphemerisDataFactory.is_dst": {"tf": 1}, "kerykeion.EphemerisDataFactory.zodiac_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.sidereal_mode": {"tf": 1}, "kerykeion.EphemerisDataFactory.houses_system_identifier": {"tf": 1}, "kerykeion.EphemerisDataFactory.perspective_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.max_days": {"tf": 1}, "kerykeion.EphemerisDataFactory.max_hours": {"tf": 1}, "kerykeion.EphemerisDataFactory.max_minutes": {"tf": 1}, "kerykeion.EphemerisDataFactory.dates_list": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory.first_subject": {"tf": 1}, "kerykeion.HouseComparisonFactory.second_subject": {"tf": 1}, "kerykeion.HouseComparisonFactory.active_points": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.HouseComparisonModel": {"tf": 1}, "kerykeion.HouseComparisonModel.first_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.second_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.subject": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.online": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.cache_expire_after_days": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.altitude": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.PlanetReturnModel": {"tf": 1}, "kerykeion.PlanetReturnModel.return_type": {"tf": 1}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1}, "kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1}, "kerykeion.RelationshipScoreFactory.MAJOR_ASPECTS": {"tf": 1}, "kerykeion.RelationshipScoreFactory.use_only_major_aspects": {"tf": 1}, "kerykeion.RelationshipScoreFactory.first_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.second_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.score_value": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 1}, "kerykeion.RelationshipScoreFactory.is_destiny_sign": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_aspects": {"tf": 1}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}, "kerykeion.ReportGenerator": {"tf": 1}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.ReportGenerator.report_title": {"tf": 1}, "kerykeion.ReportGenerator.data_table": {"tf": 1}, "kerykeion.ReportGenerator.planets_table": {"tf": 1}, "kerykeion.ReportGenerator.houses_table": {"tf": 1}, "kerykeion.ReportGenerator.instance": {"tf": 1}, "kerykeion.ReportGenerator.get_report_title": {"tf": 1}, "kerykeion.ReportGenerator.get_data_table": {"tf": 1}, "kerykeion.ReportGenerator.get_planets_table": {"tf": 1}, "kerykeion.ReportGenerator.get_houses_table": {"tf": 1}, "kerykeion.ReportGenerator.get_full_report": {"tf": 1}, "kerykeion.ReportGenerator.print_report": {"tf": 1}, "kerykeion.KerykeionSettingsModel": {"tf": 1}, "kerykeion.KerykeionSettingsModel.language_settings": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.natal_chart": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.ephemeris_data_points": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.active_points": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.active_aspects": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.settings_file": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 152, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.first_obj": {"tf": 1}, "kerykeion.ChartDrawer.second_obj": {"tf": 1}, "kerykeion.ChartDrawer.chart_type": {"tf": 1}, "kerykeion.ChartDrawer.new_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.new_settings_file": {"tf": 1}, "kerykeion.ChartDrawer.output_directory": {"tf": 1}, "kerykeion.ChartDrawer.theme": {"tf": 1}, "kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 1}, "kerykeion.ChartDrawer.chart_language": {"tf": 1}, "kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.ChartDrawer.active_aspects": {"tf": 1}, "kerykeion.ChartDrawer.transparent_background": {"tf": 1}, "kerykeion.ChartDrawer.fire": {"tf": 1}, "kerykeion.ChartDrawer.earth": {"tf": 1}, "kerykeion.ChartDrawer.air": {"tf": 1}, "kerykeion.ChartDrawer.water": {"tf": 1}, "kerykeion.ChartDrawer.first_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.second_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.third_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.width": {"tf": 1}, "kerykeion.ChartDrawer.language_settings": {"tf": 1}, "kerykeion.ChartDrawer.chart_colors_settings": {"tf": 1}, "kerykeion.ChartDrawer.planets_settings": {"tf": 1}, "kerykeion.ChartDrawer.aspects_settings": {"tf": 1}, "kerykeion.ChartDrawer.available_planets_setting": {"tf": 1}, "kerykeion.ChartDrawer.height": {"tf": 1}, "kerykeion.ChartDrawer.location": {"tf": 1}, "kerykeion.ChartDrawer.geolat": {"tf": 1}, "kerykeion.ChartDrawer.geolon": {"tf": 1}, "kerykeion.ChartDrawer.template": {"tf": 1}, "kerykeion.ChartDrawer.main_radius": {"tf": 1}, "kerykeion.ChartDrawer.available_kerykeion_celestial_points": {"tf": 1}, "kerykeion.ChartDrawer.cardinal": {"tf": 1}, "kerykeion.ChartDrawer.fixed": {"tf": 1}, "kerykeion.ChartDrawer.mutable": {"tf": 1}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}}, "df": 46}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.KerykeionSettingsModel": {"tf": 1}, "kerykeion.KerykeionSettingsModel.language_settings": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.ChartDrawer.active_aspects": {"tf": 1}, "kerykeion.ChartDrawer.aspects_settings": {"tf": 1}, "kerykeion.RelationshipScoreFactory.MAJOR_ASPECTS": {"tf": 1}, "kerykeion.RelationshipScoreFactory.use_only_major_aspects": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_aspects": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.active_aspects": {"tf": 1}}, "df": 10, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}}, "df": 5}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}}, "df": 4}}}}}}}}}}}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.ChartDrawer.active_aspects": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}, "kerykeion.HouseComparisonFactory.active_points": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.active_points": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.active_aspects": {"tf": 1}}, "df": 6}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.ChartDrawer.air": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.available_planets_setting": {"tf": 1}, "kerykeion.ChartDrawer.available_kerykeion_celestial_points": {"tf": 1}}, "df": 2}}}}}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.PlanetaryReturnFactory.cache_expire_after_days": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory.altitude": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}, "kerykeion.EphemerisDataFactory.sidereal_mode": {"tf": 1}}, "df": 2}}}}}}, "g": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.RelationshipScoreFactory.is_destiny_sign": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_system_name": {"tf": 1}, "kerykeion.EphemerisDataFactory.houses_system_identifier": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.ChartDrawer.second_obj": {"tf": 1}, "kerykeion.ChartDrawer.second_circle_radius": {"tf": 1}, "kerykeion.CompositeSubjectFactory.second_subject": {"tf": 1}, "kerykeion.HouseComparisonFactory.second_subject": {"tf": 1}, "kerykeion.HouseComparisonModel.second_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}, "kerykeion.RelationshipScoreFactory.second_subject": {"tf": 1}}, "df": 8}}}}, "t": {"docs": {"kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.ChartDrawer.available_planets_setting": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.ChartDrawer.new_settings_file": {"tf": 1}, "kerykeion.ChartDrawer.language_settings": {"tf": 1}, "kerykeion.ChartDrawer.chart_colors_settings": {"tf": 1}, "kerykeion.ChartDrawer.planets_settings": {"tf": 1}, "kerykeion.ChartDrawer.aspects_settings": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.KerykeionSettingsModel.language_settings": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.settings_file": {"tf": 1}}, "df": 9}}}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.CompositeSubjectFactory.first_subject": {"tf": 1}, "kerykeion.CompositeSubjectFactory.second_subject": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.HouseComparisonFactory.first_subject": {"tf": 1}, "kerykeion.HouseComparisonFactory.second_subject": {"tf": 1}, "kerykeion.HouseComparisonModel.first_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.second_subject_name": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.first_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.second_subject": {"tf": 1}}, "df": 10, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.EphemerisDataFactory.start_datetime": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {"kerykeion.EphemerisDataFactory.step_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.step": {"tf": 1}}, "df": 2}}, "r": {"docs": {"kerykeion.EphemerisDataFactory.tz_str": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1}, "kerykeion.RelationshipScoreFactory.score_value": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_aspects": {"tf": 1}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}}, "df": 5}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.ChartDrawer.chart_type": {"tf": 1}, "kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 1}, "kerykeion.ChartDrawer.chart_language": {"tf": 1}, "kerykeion.ChartDrawer.chart_colors_settings": {"tf": 1}, "kerykeion.CompositeSubjectFactory.composite_chart_type": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.natal_chart": {"tf": 1}}, "df": 8}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.first_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.second_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.third_circle_radius": {"tf": 1}}, "df": 3}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.chart_colors_settings": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.CompositeSubjectFactory.composite_chart_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory.model": {"tf": 1}, "kerykeion.CompositeSubjectFactory.first_subject": {"tf": 1}, "kerykeion.CompositeSubjectFactory.second_subject": {"tf": 1}, "kerykeion.CompositeSubjectFactory.name": {"tf": 1}, "kerykeion.CompositeSubjectFactory.composite_chart_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.zodiac_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_system_name": {"tf": 1}, "kerykeion.CompositeSubjectFactory.perspective_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}}, "df": 15}}}}}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.available_kerykeion_celestial_points": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.cardinal": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory.cache_expire_after_days": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.ReportGenerator.data_table": {"tf": 1}, "kerykeion.ReportGenerator.get_data_table": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.ephemeris_data_points": {"tf": 1}}, "df": 6}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.EphemerisDataFactory.start_datetime": {"tf": 1}, "kerykeion.EphemerisDataFactory.end_datetime": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {"kerykeion.EphemerisDataFactory.dates_list": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.max_days": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.cache_expire_after_days": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.ChartDrawer.new_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.output_directory": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}}, "df": 3}}}}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.EphemerisDataFactory.is_dst": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.RelationshipScoreFactory.is_destiny_sign": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.natal_chart": {"tf": 1}}, "df": 2}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.CompositeSubjectFactory.name": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_system_name": {"tf": 1}, "kerykeion.HouseComparisonModel.first_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.second_subject_name": {"tf": 1}}, "df": 4, "s": {"docs": {"kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "w": {"docs": {"kerykeion.ChartDrawer.new_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.new_settings_file": {"tf": 1}}, "df": 2}, "x": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 3}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 6}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.first_obj": {"tf": 1}, "kerykeion.ChartDrawer.first_circle_radius": {"tf": 1}, "kerykeion.CompositeSubjectFactory.first_subject": {"tf": 1}, "kerykeion.HouseComparisonFactory.first_subject": {"tf": 1}, "kerykeion.HouseComparisonModel.first_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}, "kerykeion.RelationshipScoreFactory.first_subject": {"tf": 1}}, "df": 8}}, "e": {"docs": {"kerykeion.ChartDrawer.fire": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.new_settings_file": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.settings_file": {"tf": 1}}, "df": 2}}, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.ChartDrawer.fixed": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ReportGenerator.get_full_report": {"tf": 1}}, "df": 1}}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.ChartDrawer.transparent_background": {"tf": 1}}, "df": 1}}}}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.is_dst": {"tf": 1}, "kerykeion.RelationshipScoreFactory.is_destiny_sign": {"tf": 1}}, "df": 2, "o": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 2}}, "n": {"docs": {"kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 8}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ReportGenerator.instance": {"tf": 1}}, "df": 1}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}, "kerykeion.EphemerisDataFactory.houses_system_identifier": {"tf": 1}}, "df": 2}}}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}, "p": {"docs": {"kerykeion.ChartDrawer.set_up_theme": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.RelationshipScoreFactory.use_only_major_aspects": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 3}}, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ReportGenerator.report_title": {"tf": 1}, "kerykeion.ReportGenerator.get_report_title": {"tf": 1}}, "df": 2}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.chart_type": {"tf": 1}, "kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.composite_chart_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.zodiac_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.perspective_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.step_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.zodiac_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.perspective_type": {"tf": 1}, "kerykeion.PlanetReturnModel.return_type": {"tf": 1}}, "df": 9}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.theme": {"tf": 1}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.ChartDrawer.third_circle_radius": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.transparent_background": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.natal_chart": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.ephemeris_data_points": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.active_points": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.active_aspects": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.settings_file": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 8}}}}}}}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.template": {"tf": 1}}, "df": 1}}}}}}}, "z": {"docs": {"kerykeion.EphemerisDataFactory.tz_str": {"tf": 1}}, "df": 1}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ReportGenerator.data_table": {"tf": 1}, "kerykeion.ReportGenerator.planets_table": {"tf": 1}, "kerykeion.ReportGenerator.houses_table": {"tf": 1}, "kerykeion.ReportGenerator.get_data_table": {"tf": 1}, "kerykeion.ReportGenerator.get_planets_table": {"tf": 1}, "kerykeion.ReportGenerator.get_houses_table": {"tf": 1}}, "df": 6}}}}}, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {"kerykeion.ChartDrawer.first_obj": {"tf": 1}, "kerykeion.ChartDrawer.second_obj": {"tf": 1}}, "df": 2}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.new_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.output_directory": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}}, "df": 3}}}}}, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory.online": {"tf": 1}}, "df": 1}}}, "y": {"docs": {"kerykeion.RelationshipScoreFactory.use_only_major_aspects": {"tf": 1}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.geolat": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.geolon": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}, "kerykeion.ReportGenerator.get_report_title": {"tf": 1}, "kerykeion.ReportGenerator.get_data_table": {"tf": 1}, "kerykeion.ReportGenerator.get_planets_table": {"tf": 1}, "kerykeion.ReportGenerator.get_houses_table": {"tf": 1}, "kerykeion.ReportGenerator.get_full_report": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 12}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.chart_language": {"tf": 1}, "kerykeion.ChartDrawer.language_settings": {"tf": 1}, "kerykeion.KerykeionSettingsModel.language_settings": {"tf": 1}}, "df": 3}}}}}}, "t": {"docs": {"kerykeion.EphemerisDataFactory.lat": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.location": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}, "kerykeion.EphemerisDataFactory.dates_list": {"tf": 1}}, "df": 2}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.EphemerisDataFactory.lng": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.ChartDrawer.available_kerykeion_celestial_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}, "kerykeion.HouseComparisonFactory.active_points": {"tf": 1}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.ephemeris_data_points": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.active_points": {"tf": 1}}, "df": 8}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.planets_settings": {"tf": 1}, "kerykeion.ChartDrawer.available_planets_setting": {"tf": 1}, "kerykeion.ReportGenerator.planets_table": {"tf": 1}, "kerykeion.ReportGenerator.get_planets_table": {"tf": 1}}, "df": 4}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.subject": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.online": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.cache_expire_after_days": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.altitude": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 9}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.PlanetReturnModel": {"tf": 1}, "kerykeion.PlanetReturnModel.return_type": {"tf": 1}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.CompositeSubjectFactory.perspective_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.perspective_type": {"tf": 1}}, "df": 2}}}}}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ReportGenerator.print_report": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.ChartDrawer.earth": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.ephemeris_data_points": {"tf": 1}}, "df": 3, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory.start_datetime": {"tf": 1}, "kerykeion.EphemerisDataFactory.end_datetime": {"tf": 1}, "kerykeion.EphemerisDataFactory.step_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.step": {"tf": 1}, "kerykeion.EphemerisDataFactory.lat": {"tf": 1}, "kerykeion.EphemerisDataFactory.lng": {"tf": 1}, "kerykeion.EphemerisDataFactory.tz_str": {"tf": 1}, "kerykeion.EphemerisDataFactory.is_dst": {"tf": 1}, "kerykeion.EphemerisDataFactory.zodiac_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.sidereal_mode": {"tf": 1}, "kerykeion.EphemerisDataFactory.houses_system_identifier": {"tf": 1}, "kerykeion.EphemerisDataFactory.perspective_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.max_days": {"tf": 1}, "kerykeion.EphemerisDataFactory.max_hours": {"tf": 1}, "kerykeion.EphemerisDataFactory.max_minutes": {"tf": 1}, "kerykeion.EphemerisDataFactory.dates_list": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 20}}}}}}}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.EphemerisDataFactory.end_datetime": {"tf": 1}}, "df": 1}}, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory.cache_expire_after_days": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.ChartDrawer.water": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.ChartDrawer.width": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.first_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.second_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.third_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.main_radius": {"tf": 1}}, "df": 4}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.PlanetReturnModel.return_type": {"tf": 1}}, "df": 4}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {"kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_aspects": {"tf": 1}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}}, "df": 3, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.RelationshipScoreFactory": {"tf": 1}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1}, "kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1}, "kerykeion.RelationshipScoreFactory.MAJOR_ASPECTS": {"tf": 1}, "kerykeion.RelationshipScoreFactory.use_only_major_aspects": {"tf": 1}, "kerykeion.RelationshipScoreFactory.first_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.second_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.score_value": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 1}, "kerykeion.RelationshipScoreFactory.is_destiny_sign": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_aspects": {"tf": 1}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}}, "df": 12}}}}}}}}}}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ReportGenerator": {"tf": 1}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.ReportGenerator.report_title": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator.data_table": {"tf": 1}, "kerykeion.ReportGenerator.planets_table": {"tf": 1}, "kerykeion.ReportGenerator.houses_table": {"tf": 1}, "kerykeion.ReportGenerator.instance": {"tf": 1}, "kerykeion.ReportGenerator.get_report_title": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator.get_data_table": {"tf": 1}, "kerykeion.ReportGenerator.get_planets_table": {"tf": 1}, "kerykeion.ReportGenerator.get_houses_table": {"tf": 1}, "kerykeion.ReportGenerator.get_full_report": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator.print_report": {"tf": 1.4142135623730951}}, "df": 13}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.height": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_system_name": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}, "kerykeion.EphemerisDataFactory.houses_system_identifier": {"tf": 1}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}, "kerykeion.ReportGenerator.houses_table": {"tf": 1}, "kerykeion.ReportGenerator.get_houses_table": {"tf": 1}}, "df": 8}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory.first_subject": {"tf": 1}, "kerykeion.HouseComparisonFactory.second_subject": {"tf": 1}, "kerykeion.HouseComparisonFactory.active_points": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}}, "df": 6}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.HouseComparisonModel": {"tf": 1}, "kerykeion.HouseComparisonModel.first_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.second_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.model_config": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.max_hours": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.main_radius": {"tf": 1}}, "df": 1}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.makeTemplate": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.ChartDrawer.makeSVG": {"tf": 1}}, "df": 1}}}, "w": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}, "x": {"docs": {"kerykeion.EphemerisDataFactory.max_days": {"tf": 1}, "kerykeion.EphemerisDataFactory.max_hours": {"tf": 1}, "kerykeion.EphemerisDataFactory.max_minutes": {"tf": 1}}, "df": 3}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1}}, "df": 1}}}}}, "j": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.RelationshipScoreFactory.MAJOR_ASPECTS": {"tf": 1}, "kerykeion.RelationshipScoreFactory.use_only_major_aspects": {"tf": 1}}, "df": 2}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.mutable": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}, "kerykeion.EphemerisDataFactory.sidereal_mode": {"tf": 1}}, "df": 2, "l": {"docs": {"kerykeion.CompositeSubjectFactory.model": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}}, "df": 5}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.max_minutes": {"tf": 1}}, "df": 1}}}}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}}, "df": 1}}}}, "z": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.CompositeSubjectFactory.zodiac_type": {"tf": 1}, "kerykeion.EphemerisDataFactory.zodiac_type": {"tf": 1}}, "df": 2}}}}}}, "y": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 2}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.RelationshipScoreFactory.score_value": {"tf": 1}}, "df": 1}}}}}}}, "annotation": {"root": {"1": {"5": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}}}}, "docs": {}, "df": 0}, "docs": {"kerykeion.ChartDrawer.first_obj": {"tf": 1}, "kerykeion.ChartDrawer.second_obj": {"tf": 1}, "kerykeion.ChartDrawer.chart_type": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.new_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.new_settings_file": {"tf": 1}, "kerykeion.ChartDrawer.output_directory": {"tf": 1}, "kerykeion.ChartDrawer.theme": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.chart_language": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.active_points": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.active_aspects": {"tf": 1}, "kerykeion.ChartDrawer.transparent_background": {"tf": 1}, "kerykeion.ChartDrawer.fire": {"tf": 1}, "kerykeion.ChartDrawer.earth": {"tf": 1}, "kerykeion.ChartDrawer.air": {"tf": 1}, "kerykeion.ChartDrawer.water": {"tf": 1}, "kerykeion.ChartDrawer.first_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.second_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.third_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.width": {"tf": 1}, "kerykeion.ChartDrawer.language_settings": {"tf": 1}, "kerykeion.ChartDrawer.chart_colors_settings": {"tf": 1}, "kerykeion.ChartDrawer.planets_settings": {"tf": 1}, "kerykeion.ChartDrawer.aspects_settings": {"tf": 1}, "kerykeion.ChartDrawer.available_planets_setting": {"tf": 1}, "kerykeion.ChartDrawer.height": {"tf": 1}, "kerykeion.ChartDrawer.location": {"tf": 1}, "kerykeion.ChartDrawer.geolat": {"tf": 1}, "kerykeion.ChartDrawer.geolon": {"tf": 1}, "kerykeion.ChartDrawer.template": {"tf": 1}, "kerykeion.CompositeSubjectFactory.model": {"tf": 1}, "kerykeion.CompositeSubjectFactory.first_subject": {"tf": 1}, "kerykeion.CompositeSubjectFactory.second_subject": {"tf": 1}, "kerykeion.CompositeSubjectFactory.name": {"tf": 1}, "kerykeion.CompositeSubjectFactory.composite_chart_type": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.zodiac_type": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.houses_system_name": {"tf": 1}, "kerykeion.CompositeSubjectFactory.perspective_type": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonModel.first_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.second_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetReturnModel.return_type": {"tf": 1.4142135623730951}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.RelationshipScoreFactory.first_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.second_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 1.4142135623730951}, "kerykeion.RelationshipScoreFactory.relationship_score_aspects": {"tf": 1}, "kerykeion.ReportGenerator.report_title": {"tf": 1}, "kerykeion.ReportGenerator.data_table": {"tf": 1}, "kerykeion.ReportGenerator.planets_table": {"tf": 1}, "kerykeion.ReportGenerator.houses_table": {"tf": 1}, "kerykeion.KerykeionSettingsModel.language_settings": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}}, "df": 59, "u": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.first_obj": {"tf": 1}, "kerykeion.ChartDrawer.second_obj": {"tf": 1}}, "df": 2}}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"kerykeion.ChartDrawer.new_settings_file": {"tf": 1}}, "df": 1}}}}}}}, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.width": {"tf": 1}}, "df": 1}}}}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}}}}}}}}}}, "s": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.first_obj": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.second_obj": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.new_settings_file": {"tf": 1}, "kerykeion.ChartDrawer.active_aspects": {"tf": 1}, "kerykeion.ChartDrawer.available_planets_setting": {"tf": 1}, "kerykeion.CompositeSubjectFactory.model": {"tf": 1}, "kerykeion.CompositeSubjectFactory.first_subject": {"tf": 1}, "kerykeion.CompositeSubjectFactory.second_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.first_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.second_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_aspects": {"tf": 1}, "kerykeion.KerykeionSettingsModel.language_settings": {"tf": 1}}, "df": 12}}}}}}, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.ChartDrawer.chart_type": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.chart_type": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.CompositeSubjectFactory.zodiac_type": {"tf": 1}}, "df": 1}}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.new_settings_file": {"tf": 1}, "kerykeion.ChartDrawer.available_planets_setting": {"tf": 1}, "kerykeion.KerykeionSettingsModel.language_settings": {"tf": 1}}, "df": 3}}}}}}, "d": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.ChartDrawer.location": {"tf": 1}, "kerykeion.ChartDrawer.template": {"tf": 1}, "kerykeion.CompositeSubjectFactory.name": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_system_name": {"tf": 1}, "kerykeion.HouseComparisonModel.first_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.second_subject_name": {"tf": 1}, "kerykeion.ReportGenerator.report_title": {"tf": 1}, "kerykeion.ReportGenerator.data_table": {"tf": 1}, "kerykeion.ReportGenerator.planets_table": {"tf": 1}, "kerykeion.ReportGenerator.houses_table": {"tf": 1}}, "df": 10, "a": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.ChartDrawer.theme": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1.4142135623730951}}, "df": 2}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.PlanetReturnModel.return_type": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}}}}}, "k": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "r": {"docs": {"kerykeion.ChartDrawer.first_obj": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.second_obj": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.active_aspects": {"tf": 1}, "kerykeion.CompositeSubjectFactory.model": {"tf": 1}, "kerykeion.CompositeSubjectFactory.first_subject": {"tf": 1}, "kerykeion.CompositeSubjectFactory.second_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.first_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.second_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_aspects": {"tf": 1}}, "df": 9, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.first_obj": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.second_obj": {"tf": 1}, "kerykeion.ChartDrawer.new_settings_file": {"tf": 1}, "kerykeion.CompositeSubjectFactory.first_subject": {"tf": 1}, "kerykeion.CompositeSubjectFactory.second_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.first_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.second_subject": {"tf": 1}, "kerykeion.KerykeionSettingsModel.language_settings": {"tf": 1}}, "df": 8, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.new_settings_file": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.available_planets_setting": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.KerykeionSettingsModel.language_settings": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}, "h": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"1": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}, "2": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}, "3": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}}}}}, "m": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.first_obj": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.second_obj": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.new_settings_file": {"tf": 1}, "kerykeion.ChartDrawer.active_aspects": {"tf": 1}, "kerykeion.ChartDrawer.available_planets_setting": {"tf": 1}, "kerykeion.CompositeSubjectFactory.model": {"tf": 1}, "kerykeion.CompositeSubjectFactory.first_subject": {"tf": 1}, "kerykeion.CompositeSubjectFactory.second_subject": {"tf": 1}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}, "kerykeion.RelationshipScoreFactory.first_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.second_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_aspects": {"tf": 1}, "kerykeion.KerykeionSettingsModel.language_settings": {"tf": 1}}, "df": 14}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1.7320508075688772}}, "df": 2}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 1}}, "df": 3}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.CompositeSubjectFactory.composite_chart_type": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.first_obj": {"tf": 1}, "kerykeion.ChartDrawer.second_obj": {"tf": 1}, "kerykeion.CompositeSubjectFactory.first_subject": {"tf": 1}, "kerykeion.CompositeSubjectFactory.second_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.first_subject": {"tf": 1}, "kerykeion.RelationshipScoreFactory.second_subject": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.active_aspects": {"tf": 1}}, "df": 1}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.CompositeSubjectFactory.perspective_type": {"tf": 1}}, "df": 1}}}}}}}}, "c": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.chart_type": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.first_obj": {"tf": 1}, "kerykeion.CompositeSubjectFactory.model": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.theme": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}}, "df": 3, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}}, "df": 3}}}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1.4142135623730951}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.ChartDrawer.theme": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}}, "n": {"docs": {"kerykeion.ChartDrawer.chart_language": {"tf": 1}}, "df": 1}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}}, "p": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.first_obj": {"tf": 1}, "kerykeion.ChartDrawer.second_obj": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.ChartDrawer.new_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.new_settings_file": {"tf": 1}, "kerykeion.ChartDrawer.output_directory": {"tf": 1}}, "df": 3, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"kerykeion.ChartDrawer.output_directory": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 2}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 2}}, "df": 2}}}, "t": {"docs": {"kerykeion.ChartDrawer.chart_language": {"tf": 1}}, "df": 1}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}, "n": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.second_obj": {"tf": 1}, "kerykeion.ChartDrawer.new_settings_file": {"tf": 1}}, "df": 2}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 2}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 2}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.chart_type": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.chart_type": {"tf": 1}, "kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 1}, "kerykeion.ChartDrawer.chart_language": {"tf": 1}, "kerykeion.CompositeSubjectFactory.composite_chart_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.zodiac_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}, "kerykeion.CompositeSubjectFactory.perspective_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}, "kerykeion.PlanetReturnModel.return_type": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 1}}, "df": 11}}}}}, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.theme": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 1}}, "df": 1, "[": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}}, "df": 1}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.active_aspects": {"tf": 1}, "kerykeion.ChartDrawer.available_planets_setting": {"tf": 1}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}, "kerykeion.RelationshipScoreFactory.relationship_score_aspects": {"tf": 1}}, "df": 5}}}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.new_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.new_settings_file": {"tf": 1}, "kerykeion.ChartDrawer.output_directory": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.PlanetReturnModel.return_type": {"tf": 1}}, "df": 1}}}}}, "x": {"2": {"7": {"docs": {"kerykeion.ChartDrawer.chart_type": {"tf": 3.7416573867739413}, "kerykeion.ChartDrawer.theme": {"tf": 3.1622776601683795}, "kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 2}, "kerykeion.ChartDrawer.chart_language": {"tf": 4.47213595499958}, "kerykeion.ChartDrawer.active_points": {"tf": 9.16515138991168}, "kerykeion.CompositeSubjectFactory.composite_chart_type": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.zodiac_type": {"tf": 2}, "kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 6.324555320336759}, "kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 6.782329983125268}, "kerykeion.CompositeSubjectFactory.perspective_type": {"tf": 2.8284271247461903}, "kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 4.898979485566356}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 9.16515138991168}, "kerykeion.PlanetReturnModel.return_type": {"tf": 2}, "kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 3.4641016151377544}}, "df": 14}, "docs": {}, "df": 0}, "docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.chart_type": {"tf": 1}}, "df": 1}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}, "n": {"docs": {"kerykeion.ChartDrawer.chart_language": {"tf": 1}}, "df": 1}, "s": {"docs": {"kerykeion.ChartDrawer.chart_language": {"tf": 1}}, "df": 1}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "r": {"docs": {"kerykeion.ChartDrawer.chart_language": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.chart_type": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.perspective_type": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1.7320508075688772}}, "df": 3}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.CompositeSubjectFactory.zodiac_type": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.CompositeSubjectFactory.perspective_type": {"tf": 1}}, "df": 1}}}}}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.chart_type": {"tf": 1}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.RelationshipScoreFactory.relationship_score_aspects": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}}}, "u": {"docs": {"kerykeion.ChartDrawer.chart_language": {"tf": 1}}, "df": 1}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"kerykeion.ChartDrawer.new_output_directory": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.theme": {"tf": 1}, "kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 2}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.CompositeSubjectFactory.model": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}}, "d": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.new_settings_file": {"tf": 1}, "kerykeion.ChartDrawer.language_settings": {"tf": 1}, "kerykeion.ChartDrawer.chart_colors_settings": {"tf": 1}, "kerykeion.ChartDrawer.planets_settings": {"tf": 1}, "kerykeion.ChartDrawer.aspects_settings": {"tf": 1}}, "df": 5, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.KerykeionSettingsModel.language_settings": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {"kerykeion.ChartDrawer.theme": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {"kerykeion.ChartDrawer.chart_language": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}}}}}, "j": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "i": {"docs": {"kerykeion.ChartDrawer.chart_language": {"tf": 1}}, "df": 1, "g": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.ChartDrawer.theme": {"tf": 1}}, "df": 1}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.CompositeSubjectFactory.perspective_type": {"tf": 1}}, "df": 1}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 3.4641016151377544}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1.4142135623730951}}, "df": 3}}}}}, "f": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "r": {"docs": {"kerykeion.ChartDrawer.chart_language": {"tf": 1}}, "df": 1}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}}, "df": 1}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.fire": {"tf": 1}, "kerykeion.ChartDrawer.earth": {"tf": 1}, "kerykeion.ChartDrawer.air": {"tf": 1}, "kerykeion.ChartDrawer.water": {"tf": 1}, "kerykeion.ChartDrawer.first_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.second_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.third_circle_radius": {"tf": 1}, "kerykeion.ChartDrawer.height": {"tf": 1}, "kerykeion.ChartDrawer.geolat": {"tf": 1}, "kerykeion.ChartDrawer.geolon": {"tf": 1}}, "df": 10}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1.4142135623730951}}, "df": 1, "t": {"docs": {"kerykeion.ChartDrawer.chart_language": {"tf": 1}}, "df": 1}, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.width": {"tf": 1}}, "df": 1}}}, "v": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1.4142135623730951}}, "df": 2}}}, "y": {"docs": {"kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 1}}, "df": 1}}}}, "j": {"1": {"9": {"0": {"0": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "2": {"0": {"0": {"0": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}, "n": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}}, "q": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.ChartDrawer.active_points": {"tf": 1}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1}}, "df": 2}}}}}}, "b": {"1": {"9": {"5": {"0": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.transparent_background": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 2.23606797749979}}, "df": 1}}}}}, "y": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1}}, "df": 1}}}}}}}}}}, "w": {"docs": {"kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1}}, "df": 1}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.CompositeSubjectFactory.perspective_type": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}, "default_value": {"root": {"1": {"0": {"docs": {"kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1}}, "df": 1}, "5": {"docs": {"kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "2": {"0": {"docs": {"kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "3": {"0": {"docs": {"kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "5": {"docs": {"kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1}}, "df": 1}, "docs": {"kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1.4142135623730951}, "kerykeion.RelationshipScoreFactory.MAJOR_ASPECTS": {"tf": 1.4142135623730951}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}}, "df": 5, "x": {"2": {"7": {"docs": {"kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 3.4641016151377544}, "kerykeion.RelationshipScoreFactory.MAJOR_ASPECTS": {"tf": 3.1622776601683795}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "f": {"docs": {"kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1}}, "df": 1}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.RelationshipScoreFactory.MAJOR_ASPECTS": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.RelationshipScoreFactory.MAJOR_ASPECTS": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.RelationshipScoreFactory.MAJOR_ASPECTS": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.RelationshipScoreFactory.MAJOR_ASPECTS": {"tf": 1}}, "df": 1}}}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.RelationshipScoreFactory.MAJOR_ASPECTS": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "signature": {"root": {"0": {"0": {"0": {"5": {"docs": {"kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 6.557438524302}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}, "1": {"0": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 3.4641016151377544}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 2}, "1": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2.23606797749979}}, "df": 1}, "2": {"0": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "3": {"5": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "4": {"4": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 2}, "5": {"0": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2}}, "df": 1, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}}, "6": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "7": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "8": {"0": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "9": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 2}, "docs": {"kerykeion.ChartDrawer.__init__": {"tf": 3.7416573867739413}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 3}, "2": {"0": {"2": {"5": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}}, "df": 1}, "1": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "2": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "3": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "4": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "5": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "6": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "7": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "8": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "9": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "docs": {"kerykeion.ChartDrawer.__init__": {"tf": 3}}, "df": 1}, "3": {"0": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 3}, "1": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "2": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "3": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "4": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "5": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "6": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "7": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "8": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "9": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 9.16515138991168}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 9.16515138991168}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 9.16515138991168}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 9.16515138991168}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 15.066519173319364}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 15.231546211727817}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 15.033296378372908}, "kerykeion.ChartDrawer.__init__": {"tf": 33.60059523282288}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 3.1622776601683795}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 10.677078252031311}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 10.954451150103322}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 12.489995996796797}}, "df": 15}, "docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2.6457513110645907}}, "df": 1}, "4": {"0": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2}}, "df": 1}, "1": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "5": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "7": {"6": {"9": {"docs": {"kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2.23606797749979}}, "df": 1}, "5": {"0": {"7": {"4": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "1": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 2}, "2": {"5": {"6": {"0": {"0": {"docs": {"kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2.6457513110645907}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 2}, "6": {"0": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2.449489742783178}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 2}, "7": {"2": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "3": {"0": {"docs": {"kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2.23606797749979}}, "df": 1}, "8": {"7": {"6": {"0": {"docs": {"kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2.449489742783178}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 3}, "9": {"0": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2.23606797749979}}, "df": 1}, "docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 20.8806130178211}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 22.271057451320086}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 20.8806130178211}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 22.271057451320086}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 34.52535300326414}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 32.2490309931942}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 32.264531609803356}, "kerykeion.ChartDrawer.__init__": {"tf": 68.40321629865075}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 8.12403840463596}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 5.385164807134504}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 7.937253933193772}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 5.830951894845301}, "kerykeion.ChartDrawer.makeSVG": {"tf": 5.656854249492381}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 5.656854249492381}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 5.656854249492381}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 5.656854249492381}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 5.656854249492381}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 8.12403840463596}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 3.1622776601683795}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 24.839484696748443}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 5.0990195135927845}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 6.708203932499369}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 23.043437243605826}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 5}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 15.198684153570664}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 7.54983443527075}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 7.54983443527075}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 8.12403840463596}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 7.810249675906654}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 3.1622776601683795}, "kerykeion.ReportGenerator.__init__": {"tf": 4.898979485566356}, "kerykeion.ReportGenerator.get_report_title": {"tf": 3.4641016151377544}, "kerykeion.ReportGenerator.get_data_table": {"tf": 3.4641016151377544}, "kerykeion.ReportGenerator.get_planets_table": {"tf": 3.4641016151377544}, "kerykeion.ReportGenerator.get_houses_table": {"tf": 3.4641016151377544}, "kerykeion.ReportGenerator.get_full_report": {"tf": 3.4641016151377544}, "kerykeion.ReportGenerator.print_report": {"tf": 3.4641016151377544}, "kerykeion.get_settings": {"tf": 8.717797887081348}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 27}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 4.898979485566356}}, "df": 40, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1.4142135623730951}}, "df": 8}}}}}, "n": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 2.23606797749979}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 2.8284271247461903}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 2.23606797749979}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 2.8284271247461903}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2.6457513110645907}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.get_settings": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 21}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.__init__": {"tf": 2.449489742783178}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.7320508075688772}}, "df": 10}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 3}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1}}, "df": 6, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2.23606797749979}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1.4142135623730951}, "kerykeion.get_settings": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 4}}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2.23606797749979}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 2}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2}}, "df": 1}}, "s": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {"kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}, "kerykeion.ReportGenerator.get_report_title": {"tf": 1}, "kerykeion.ReportGenerator.get_data_table": {"tf": 1}, "kerykeion.ReportGenerator.get_planets_table": {"tf": 1}, "kerykeion.ReportGenerator.get_houses_table": {"tf": 1}, "kerykeion.ReportGenerator.get_full_report": {"tf": 1}, "kerykeion.ReportGenerator.print_report": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 24}}}, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}, "w": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.449489742783178}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2.6457513110645907}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.449489742783178}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.ReportGenerator.get_full_report": {"tf": 1}}, "df": 10, "a": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}}, "df": 2}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {"kerykeion.EphemerisDataFactory.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2.23606797749979}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 2}}}}}}, "u": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.RelationshipScoreFactory.__init__": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 4}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}}}}}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}}, "k": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 2.23606797749979}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 2.8284271247461903}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 2.23606797749979}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 2.8284271247461903}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 9.848857801796104}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.get_settings": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 22, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.get_settings": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 4}}}}}}}}}}}}}}}}}}}}}, "r": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 2.23606797749979}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 2.8284271247461903}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 2.23606797749979}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 2.8284271247461903}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2.449489742783178}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 19, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}}}}}}}}}, "h": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"1": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}, "2": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}, "3": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}, "docs": {}, "df": 0}}}}}}, "m": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "l": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 2, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 2.23606797749979}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 2.8284271247461903}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 2.23606797749979}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 2.8284271247461903}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2.6457513110645907}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.get_settings": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 22}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2}, "kerykeion.ChartDrawer.__init__": {"tf": 3.605551275463989}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 2}}, "df": 10}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}}}}, "j": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 3.3166247903554}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1}}, "df": 2}}}, "x": {"docs": {"kerykeion.EphemerisDataFactory.__init__": {"tf": 1.7320508075688772}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.EphemerisDataFactory.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}}, "df": 6}}}}}, "c": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}, "a": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 15}}}}}}}}}}}}}}}}}}}}}}, "c": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10}}}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 7}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 6}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 3}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 2}}, "df": 10}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}}, "df": 2}}}}}, "j": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 2}}}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 11.958260743101398}}, "df": 1, "s": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 9.643650760992955}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 3}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}}, "df": 3}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 4}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 2}}}, "l": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}}, "df": 3}}}}}}}}, "n": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}}, "df": 6}}}, "p": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1.4142135623730951}}, "df": 4, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 9}}}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10}}}}, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 6.6332495807108}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}}, "df": 4}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 2}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 2}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 2}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2}, "kerykeion.ChartDrawer.__init__": {"tf": 3.4641016151377544}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 2}}, "df": 10}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 5, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 5}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}}}}}}}}, "t": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}, "o": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 3}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.6457513110645907}, "kerykeion.ChartDrawer.__init__": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2}}, "df": 12}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 2}}}}}}}}}, "r": {"docs": {"kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}, "b": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2.449489742783178}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 2.449489742783178}}, "df": 2}}, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 4}}}, "y": {"docs": {"kerykeion.RelationshipScoreFactory.__init__": {"tf": 1}}, "df": 1}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}}, "df": 1}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2.449489742783178}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.7320508075688772}}, "df": 12}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.23606797749979}, "kerykeion.ChartDrawer.__init__": {"tf": 2.23606797749979}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 2.23606797749979}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 15}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.__init__": {"tf": 2.8284271247461903}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.7320508075688772}}, "df": 10}}}}, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}}, "df": 2}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 5}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 5}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 6.48074069840786}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 7}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 5}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 2.8284271247461903}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 9.486832980505138}}, "df": 1, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}}, "df": 6}}}}}}}}}, "j": {"1": {"9": {"0": {"0": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "2": {"0": {"0": {"0": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}, "n": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}, "n": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10}}}}}, "w": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.get_settings": {"tf": 1}}, "df": 2}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 2}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 2}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 2}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.449489742783178}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2.449489742783178}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.449489742783178}, "kerykeion.ChartDrawer.__init__": {"tf": 4}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 2.449489742783178}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 2.449489742783178}}, "df": 10}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 3}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.6457513110645907}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2.6457513110645907}, "kerykeion.ReportGenerator.get_report_title": {"tf": 1}, "kerykeion.ReportGenerator.get_data_table": {"tf": 1}, "kerykeion.ReportGenerator.get_planets_table": {"tf": 1}, "kerykeion.ReportGenerator.get_houses_table": {"tf": 1}, "kerykeion.ReportGenerator.print_report": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 21, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 5}}}}}}, "w": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}}, "df": 2}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 7.681145747868608}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 2.449489742783178}}, "df": 6}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 4}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "r": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.8284271247461903}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2.8284271247461903}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.8284271247461903}, "kerykeion.ChartDrawer.__init__": {"tf": 4}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 2.23606797749979}}, "df": 13}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1.4142135623730951}}, "df": 4}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 3.3166247903554}}, "df": 1, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 2}}}}, "z": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 5}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 8}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.HouseComparisonFactory.__init__": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}}}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 2}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}, "c": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 1}}}}}}, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "n": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}}, "df": 1, "d": {"docs": {"kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 1}}, "s": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 6.48074069840786}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 1}}}}}}}}}, "h": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.EphemerisDataFactory.__init__": {"tf": 1.4142135623730951}}, "df": 1}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 5}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}}, "i": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}}}}}}, "g": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}}}}}}}}}}, "i": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1.4142135623730951}}, "df": 4, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}}, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.6457513110645907}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}}, "df": 5}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ReportGenerator.__init__": {"tf": 1}}, "df": 1}}}}}}}, "d": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 6.48074069840786}}, "df": 1, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}}}}}}}, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 3.3166247903554}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 3, "o": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 2}}, "t": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "c": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 4.898979485566356}}, "df": 1}}}}, "q": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 2}}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "x": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "r": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 4}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}}, "df": 6}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2.8284271247461903}}, "df": 1}}}}, "u": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 3.7416573867739413}}, "df": 1}}}}, "f": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 10}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1}}, "df": 6}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 4}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.7320508075688772}}, "df": 5}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2.6457513110645907}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 10}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}, "d": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10}}}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 3.3166247903554}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 3}}, "r": {"docs": {}, "df": 0, "k": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1.4142135623730951}}, "df": 2}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.EphemerisDataFactory.__init__": {"tf": 2.449489742783178}}, "df": 1}}}}}, "a": {"docs": {"kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 1}}}, "j": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 2}, "c": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.ChartDrawer.set_output_directory": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 2}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1.4142135623730951}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 4}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}}}, "y": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 3}}}, "u": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 4}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1.7320508075688772}}, "df": 4}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}, "b": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}, "b": {"1": {"9": {"5": {"0": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1}}, "df": 15}}, "y": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.23606797749979}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 2.23606797749979}}, "df": 4}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}}}}}}, "g": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 4.898979485566356}}, "df": 1}, "i": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}, "z": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 7.874007874011811}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 5}}}}}}, "w": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}, "x": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1}}, "df": 4}}}, "bases": {"root": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.HouseComparisonModel": {"tf": 1}, "kerykeion.PlanetReturnModel": {"tf": 1}, "kerykeion.KerykeionSettingsModel": {"tf": 1}}, "df": 3}}}}}}}}, "r": {"docs": {"kerykeion.HouseComparisonModel": {"tf": 1}, "kerykeion.PlanetReturnModel": {"tf": 1}, "kerykeion.KerykeionSettingsModel": {"tf": 1}}, "df": 3}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.HouseComparisonModel": {"tf": 1}, "kerykeion.PlanetReturnModel": {"tf": 1}, "kerykeion.KerykeionSettingsModel": {"tf": 1}}, "df": 3}}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.HouseComparisonModel": {"tf": 1}, "kerykeion.KerykeionSettingsModel": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.HouseComparisonModel": {"tf": 1}, "kerykeion.PlanetReturnModel": {"tf": 1}, "kerykeion.KerykeionSettingsModel": {"tf": 1}}, "df": 3}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.PlanetReturnModel": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}, "doc": {"root": {"0": {"0": {"0": {"5": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "6": {"0": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 3}, "docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0, ":": {"0": {"0": {"docs": {}, "df": 0, ":": {"0": {"0": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "1": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.7320508075688772}}, "df": 2, "t": {"0": {"0": {"docs": {}, "df": 0, ":": {"0": {"0": {"docs": {}, "df": 0, ":": {"0": {"0": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}}, "df": 1, "+": {"0": {"0": {"docs": {}, "df": 0, ":": {"0": {"0": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "3": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}, "6": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 3}, "7": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 2}, "9": {"6": {"9": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0, "t": {"0": {"5": {"docs": {}, "df": 0, ":": {"0": {"0": {"docs": {}, "df": 0, ":": {"0": {"0": {"docs": {}, "df": 0, "z": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {"kerykeion": {"tf": 4}, "kerykeion.AspectsFactory": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.449489742783178}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2}, "kerykeion.RelationshipScoreFactory": {"tf": 1}}, "df": 13}, "1": {"0": {"0": {"0": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "docs": {"kerykeion": {"tf": 4.47213595499958}, "kerykeion.ChartDrawer": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1.4142135623730951}}, "df": 4}, "1": {"8": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}, "2": {"0": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "2": {"docs": {"kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 1}, "3": {"docs": {}, "df": 0, "z": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}, "7": {"8": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "docs": {"kerykeion": {"tf": 1}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.7320508075688772}}, "df": 8}, "3": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 2}, "4": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 6}, "5": {"docs": {"kerykeion": {"tf": 2.8284271247461903}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1.4142135623730951}}, "df": 8, "t": {"1": {"0": {"docs": {}, "df": 0, ":": {"3": {"0": {"docs": {}, "df": 0, ":": {"0": {"0": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 1, "+": {"0": {"0": {"docs": {}, "df": 0, ":": {"0": {"0": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "2": {"docs": {}, "df": 0, ":": {"0": {"0": {"docs": {}, "df": 0, ":": {"0": {"0": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "4": {"docs": {}, "df": 0, ":": {"3": {"0": {"docs": {}, "df": 0, ":": {"0": {"0": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1, "z": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}, "+": {"0": {"0": {"docs": {}, "df": 0, ":": {"0": {"0": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "6": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}, "8": {"0": {"0": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 2}, "docs": {"kerykeion": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}}, "df": 2}, "docs": {"kerykeion": {"tf": 4.69041575982343}}, "df": 1, ":": {"3": {"0": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "9": {"4": {"0": {"docs": {"kerykeion": {"tf": 4.123105625617661}}, "df": 1}, "2": {"docs": {"kerykeion": {"tf": 2}}, "df": 1}, "docs": {}, "df": 0}, "6": {"3": {"docs": {"kerykeion": {"tf": 2.6457513110645907}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}}, "df": 3}, "9": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}, "docs": {"kerykeion": {"tf": 1}}, "df": 1}, "7": {"5": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "8": {"5": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "9": {"0": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 9}, "1": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "2": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}}, "df": 4}, "docs": {}, "df": 0}, "docs": {"kerykeion": {"tf": 2.23606797749979}}, "df": 1}, "docs": {"kerykeion.AspectsFactory": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2.23606797749979}}, "df": 9, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 2}}}, "2": {"0": {"0": {"0": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "2": {"0": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}}, "df": 1}, "3": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 2}, "4": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 3}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 3.3166247903554}}, "df": 4}, "5": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 3}, "docs": {}, "df": 0}, "5": {"0": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.RelationshipScoreFactory": {"tf": 1.4142135623730951}}, "df": 2, "t": {"2": {"0": {"docs": {}, "df": 0, ":": {"1": {"7": {"docs": {}, "df": 0, ":": {"0": {"0": {"docs": {}, "df": 0, "z": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "1": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 3}, "2": {"0": {"0": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "docs": {"kerykeion": {"tf": 2}}, "df": 1}, "3": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}}, "df": 3}, "5": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 3, "t": {"1": {"2": {"docs": {}, "df": 0, ":": {"0": {"0": {"docs": {}, "df": 0, ":": {"0": {"0": {"docs": {}, "df": 0, "z": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "6": {"7": {"8": {"9": {"1": {"9": {"9": {"4": {"7": {"4": {"3": {"9": {"9": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "4": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"kerykeion": {"tf": 1}}, "df": 1}, "7": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}}, "df": 5}, "9": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 2}, "docs": {"kerykeion": {"tf": 2.23606797749979}, "kerykeion.EphemerisDataFactory": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}}, "df": 5}, "3": {"0": {"docs": {"kerykeion": {"tf": 4.58257569495584}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1.4142135623730951}}, "df": 9}, "1": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 3}, "4": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "5": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "6": {"5": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "7": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 3}, "9": {"docs": {"kerykeion": {"tf": 2}}, "df": 1}, "docs": {"kerykeion": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.7320508075688772}}, "df": 6}, "4": {"0": {"0": {"0": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {}, "df": 0}, "docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 4}, "1": {"9": {"4": {"docs": {"kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "4": {"1": {"9": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "5": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}}, "df": 2}, "7": {"6": {"9": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"kerykeion": {"tf": 1.7320508075688772}}, "df": 1}, "5": {"0": {"7": {"4": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 3}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "1": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 4}, "2": {"5": {"6": {"0": {"0": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}, "3": {"docs": {"kerykeion": {"tf": 1.7320508075688772}}, "df": 1}, "5": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}, "6": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}, "7": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "8": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}, "9": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1.4142135623730951}}, "df": 3}, "6": {"0": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "6": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "9": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "docs": {"kerykeion": {"tf": 3.605551275463989}, "kerykeion.AspectsFactory": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 9}, "7": {"1": {"2": {"8": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 4}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "2": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}, "3": {"0": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "4": {"6": {"7": {"6": {"6": {"2": {"4": {"1": {"7": {"6": {"7": {"9": {"9": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 4}, "7": {"4": {"9": {"docs": {"kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}, "8": {"6": {"0": {"1": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 3}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "7": {"6": {"0": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}}, "df": 3}, "9": {"0": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}}, "df": 2}, "5": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}, "6": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "8": {"3": {"3": {"docs": {"kerykeion": {"tf": 1.7320508075688772}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"kerykeion": {"tf": 4.898979485566356}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 4, "/": {"1": {"0": {"docs": {}, "df": 0, "/": {"1": {"9": {"4": {"0": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {"kerykeion": {"tf": 68.42514157822401}, "kerykeion.AspectsFactory": {"tf": 6.164414002968976}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 6.4031242374328485}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 6.6332495807108}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 2.8284271247461903}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 2.8284271247461903}, "kerykeion.AstrologicalSubjectFactory": {"tf": 6.708203932499369}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 8.54400374531753}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 7.745966692414834}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 7.681145747868608}, "kerykeion.ChartDrawer": {"tf": 8.246211251235321}, "kerykeion.ChartDrawer.__init__": {"tf": 4.242640687119285}, "kerykeion.ChartDrawer.first_obj": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.second_obj": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.chart_type": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.new_output_directory": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.new_settings_file": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.output_directory": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.theme": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.double_chart_aspect_grid_type": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.chart_language": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.active_points": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.active_aspects": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.transparent_background": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.fire": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.earth": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.air": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.water": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.first_circle_radius": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.second_circle_radius": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.third_circle_radius": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.width": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.language_settings": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.chart_colors_settings": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.planets_settings": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.aspects_settings": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.available_planets_setting": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.height": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.location": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.geolat": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.geolon": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.template": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.main_radius": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.available_kerykeion_celestial_points": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.cardinal": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.fixed": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.mutable": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 2.6457513110645907}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 2.6457513110645907}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 2.6457513110645907}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 3.7416573867739413}, "kerykeion.ChartDrawer.makeSVG": {"tf": 3.605551275463989}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 3.7416573867739413}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 3.605551275463989}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 3.7416573867739413}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 3.605551275463989}, "kerykeion.CompositeSubjectFactory": {"tf": 7.681145747868608}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 4.358898943540674}, "kerykeion.CompositeSubjectFactory.model": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.first_subject": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.second_subject": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.name": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.composite_chart_type": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.zodiac_type": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.sidereal_mode": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.houses_system_identifier": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.houses_system_name": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.perspective_type": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.houses_names_list": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.active_points": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 6.4031242374328485}, "kerykeion.EphemerisDataFactory": {"tf": 6.557438524302}, "kerykeion.EphemerisDataFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.start_datetime": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.end_datetime": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.step_type": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.step": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.lat": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.lng": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.tz_str": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.is_dst": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.zodiac_type": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.sidereal_mode": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.houses_system_identifier": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.perspective_type": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.max_days": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.max_hours": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.max_minutes": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.dates_list": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 6.244997998398398}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 6.557438524302}, "kerykeion.HouseComparisonFactory": {"tf": 5}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 3}, "kerykeion.HouseComparisonFactory.first_subject": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory.second_subject": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory.active_points": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 3.3166247903554}, "kerykeion.HouseComparisonModel": {"tf": 2.8284271247461903}, "kerykeion.HouseComparisonModel.first_subject_name": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonModel.second_subject_name": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonModel.model_config": {"tf": 2}, "kerykeion.PlanetaryReturnFactory": {"tf": 8.888194417315589}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 6.164414002968976}, "kerykeion.PlanetaryReturnFactory.subject": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.online": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.cache_expire_after_days": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.altitude": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 6.928203230275509}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 6.324555320336759}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 6.782329983125268}, "kerykeion.PlanetReturnModel": {"tf": 1.4142135623730951}, "kerykeion.PlanetReturnModel.return_type": {"tf": 1.7320508075688772}, "kerykeion.PlanetReturnModel.model_config": {"tf": 2}, "kerykeion.RelationshipScoreFactory": {"tf": 4.242640687119285}, "kerykeion.RelationshipScoreFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.RelationshipScoreFactory.SCORE_MAPPING": {"tf": 1.7320508075688772}, "kerykeion.RelationshipScoreFactory.MAJOR_ASPECTS": {"tf": 1.7320508075688772}, "kerykeion.RelationshipScoreFactory.use_only_major_aspects": {"tf": 1.7320508075688772}, "kerykeion.RelationshipScoreFactory.first_subject": {"tf": 1.7320508075688772}, "kerykeion.RelationshipScoreFactory.second_subject": {"tf": 1.7320508075688772}, "kerykeion.RelationshipScoreFactory.score_value": {"tf": 1.7320508075688772}, "kerykeion.RelationshipScoreFactory.relationship_score_description": {"tf": 1.7320508075688772}, "kerykeion.RelationshipScoreFactory.is_destiny_sign": {"tf": 1.7320508075688772}, "kerykeion.RelationshipScoreFactory.relationship_score_aspects": {"tf": 1.7320508075688772}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 2.449489742783178}, "kerykeion.ReportGenerator": {"tf": 1.7320508075688772}, "kerykeion.ReportGenerator.__init__": {"tf": 2.449489742783178}, "kerykeion.ReportGenerator.report_title": {"tf": 1.7320508075688772}, "kerykeion.ReportGenerator.data_table": {"tf": 1.7320508075688772}, "kerykeion.ReportGenerator.planets_table": {"tf": 1.7320508075688772}, "kerykeion.ReportGenerator.houses_table": {"tf": 1.7320508075688772}, "kerykeion.ReportGenerator.instance": {"tf": 1.7320508075688772}, "kerykeion.ReportGenerator.get_report_title": {"tf": 1.7320508075688772}, "kerykeion.ReportGenerator.get_data_table": {"tf": 1.7320508075688772}, "kerykeion.ReportGenerator.get_planets_table": {"tf": 1.7320508075688772}, "kerykeion.ReportGenerator.get_houses_table": {"tf": 1.7320508075688772}, "kerykeion.ReportGenerator.get_full_report": {"tf": 1.7320508075688772}, "kerykeion.ReportGenerator.print_report": {"tf": 1.7320508075688772}, "kerykeion.KerykeionSettingsModel": {"tf": 1.7320508075688772}, "kerykeion.KerykeionSettingsModel.language_settings": {"tf": 1.7320508075688772}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 2}, "kerykeion.get_settings": {"tf": 4.123105625617661}, "kerykeion.TransitsTimeRangeFactory": {"tf": 5.656854249492381}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 4}, "kerykeion.TransitsTimeRangeFactory.natal_chart": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.ephemeris_data_points": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.active_points": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.active_aspects": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.settings_file": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 6.782329983125268}}, "df": 152, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 3.4641016151377544}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory": {"tf": 2}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}, "kerykeion.KerykeionSettingsModel": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 25}, "r": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {"kerykeion": {"tf": 8.06225774829855}, "kerykeion.AspectsFactory": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 3.1622776601683795}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.8284271247461903}, "kerykeion.ChartDrawer": {"tf": 4.242640687119285}, "kerykeion.ChartDrawer.__init__": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 2}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 3.605551275463989}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 2}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 3}, "kerykeion.EphemerisDataFactory": {"tf": 3.7416573867739413}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 3.7416573867739413}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 2.23606797749979}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 2.6457513110645907}, "kerykeion.HouseComparisonModel": {"tf": 2}, "kerykeion.HouseComparisonModel.first_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.second_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 3.4641016151377544}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 3.1622776601683795}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 4.795831523312719}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 5.196152422706632}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 5.291502622129181}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1.4142135623730951}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.ReportGenerator.get_report_title": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator.get_data_table": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator.get_planets_table": {"tf": 1}, "kerykeion.ReportGenerator.get_houses_table": {"tf": 1}, "kerykeion.ReportGenerator.get_full_report": {"tf": 1}, "kerykeion.ReportGenerator.print_report": {"tf": 1}, "kerykeion.KerykeionSettingsModel": {"tf": 1.4142135623730951}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}, "kerykeion.get_settings": {"tf": 3}, "kerykeion.TransitsTimeRangeFactory": {"tf": 3}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 3.3166247903554}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 2.23606797749979}}, "df": 52, "m": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}}, "df": 1, "e": {"docs": {"kerykeion": {"tf": 3.1622776601683795}, "kerykeion.ChartDrawer": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1.7320508075688772}}, "df": 4, "s": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.ChartDrawer": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 5}}, "n": {"docs": {"kerykeion.ChartDrawer.makeSVG": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 7}, "n": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AspectsFactory": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 6, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 2}}}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 2}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 1}}}}}}}}, "r": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 3.1622776601683795}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 2.23606797749979}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 3.7416573867739413}}, "df": 7, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 6, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.TransitsTimeRangeFactory": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 3}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}}}, "[": {"0": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.7320508075688772}}, "df": 4}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}}}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 2}}}}}}, "y": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "u": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 4.242640687119285}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.8284271247461903}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.8284271247461903}, "kerykeion.ChartDrawer": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2.6457513110645907}, "kerykeion.RelationshipScoreFactory": {"tf": 1}}, "df": 11}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 3}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}}, "df": 3, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 3, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}, "o": {"docs": {"kerykeion": {"tf": 6}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 4.58257569495584}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 4.69041575982343}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 3.7416573867739413}, "kerykeion.ChartDrawer": {"tf": 4.47213595499958}, "kerykeion.ChartDrawer.__init__": {"tf": 2.6457513110645907}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 2.23606797749979}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 2}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 2}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 4.795831523312719}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 2.23606797749979}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 2.8284271247461903}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2.8284271247461903}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2.8284271247461903}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2.449489742783178}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1.7320508075688772}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.KerykeionSettingsModel": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}, "kerykeion.get_settings": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory": {"tf": 2.449489742783178}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 2.23606797749979}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 37, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 2}}}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 3}}}}}}}}}, "k": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "o": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 3}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.8284271247461903}, "kerykeion.EphemerisDataFactory": {"tf": 2.6457513110645907}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2.6457513110645907}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 2.23606797749979}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 2}}, "df": 15, "z": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2.449489742783178}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}}, "df": 11}}}}, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2.6457513110645907}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 3, "s": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2.449489742783178}}, "df": 4}}}}, "p": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ReportGenerator.get_report_title": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator.get_data_table": {"tf": 1}, "kerykeion.ReportGenerator.get_planets_table": {"tf": 1}, "kerykeion.ReportGenerator.get_houses_table": {"tf": 1}}, "df": 6}}}, "u": {"docs": {"kerykeion": {"tf": 2}}, "df": 1}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}}, "df": 2}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 1}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 3.3166247903554}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2}, "kerykeion.ChartDrawer": {"tf": 2.449489742783178}, "kerykeion.ChartDrawer.__init__": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 2.6457513110645907}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 3}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2}}, "df": 19, "s": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 8}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 5}}}}}}}}, "z": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 8}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "o": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AspectsFactory": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.HouseComparisonModel": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1}}, "df": 9}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}}, "df": 3, "s": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 3}}}}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "i": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion": {"tf": 3.872983346207417}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.8284271247461903}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2.449489742783178}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.23606797749979}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 2}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2.23606797749979}, "kerykeion.KerykeionSettingsModel": {"tf": 1}, "kerykeion.get_settings": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 20, "o": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 3.1622776601683795}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 3.4641016151377544}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 11, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {"kerykeion": {"tf": 3.605551275463989}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 16, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}}, "df": 3, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"kerykeion.CompositeSubjectFactory": {"tf": 1}}, "df": 1}}}}, "/": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.RelationshipScoreFactory": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {"kerykeion": {"tf": 3.872983346207417}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2.6457513110645907}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2}, "kerykeion.ChartDrawer": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 2}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 2}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 2.23606797749979}, "kerykeion.HouseComparisonModel": {"tf": 2}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 2.8284271247461903}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2.6457513110645907}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 3.4641016151377544}, "kerykeion.get_settings": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 31, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 9, "d": {"docs": {"kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 3}, "s": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 4}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 9}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.CompositeSubjectFactory": {"tf": 1}}, "df": 1}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.6457513110645907}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}}, "df": 6, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}}, "df": 2}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 2}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1.7320508075688772}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.HouseComparisonModel": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 1}}}}}}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 7}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 4}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.ReportGenerator": {"tf": 1}, "kerykeion.ReportGenerator.__init__": {"tf": 1.4142135623730951}}, "df": 7, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 2.449489742783178}}, "df": 4}}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 6}}}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}}, "df": 5}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"kerykeion.ChartDrawer.makeTemplate": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}}, "df": 2}}}}}}, "v": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 3}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 2}}}}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 5}}}}, "f": {"docs": {"kerykeion": {"tf": 3.3166247903554}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 3.3166247903554}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.6457513110645907}, "kerykeion.ChartDrawer": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory": {"tf": 2}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 2}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2.6457513110645907}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2.449489742783178}, "kerykeion.get_settings": {"tf": 1}}, "df": 18}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 4.58257569495584}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 3, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.RelationshipScoreFactory": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 3}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 2}}}, "c": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}}, "df": 1}, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 9}, "s": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {"kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 2}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 4}}}}, "p": {"1": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 2}, "2": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 2}, "docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}}, "df": 3, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "y": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 2}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.HouseComparisonFactory": {"tf": 1.4142135623730951}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 4, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2.6457513110645907}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 5}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 5}}, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 2}}, "df": 1, "e": {"docs": {"kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}}, "df": 1, "d": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 2}}, "df": 1}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1.4142135623730951}}, "df": 4, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.get_settings": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.ChartDrawer": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 6}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 2, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}}, "df": 3}}}}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.get_settings": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 3.1622776601683795}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1}}}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 4, "s": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 4}, "d": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2.6457513110645907}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 5}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 5}}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.4142135623730951}}, "df": 2}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 2}}}}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 3}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.7320508075688772}, "kerykeion.ReportGenerator.print_report": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 11}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 6}}}, "e": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.7320508075688772}}, "df": 4}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 2}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 2}}}}}}}}, "y": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"3": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "docs": {"kerykeion": {"tf": 1.7320508075688772}}, "df": 1}}}, "z": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}}, "df": 1}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetReturnModel": {"tf": 1}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}}, "df": 6}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2.6457513110645907}, "kerykeion.PlanetReturnModel": {"tf": 1}}, "df": 4, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2.23606797749979}, "kerykeion.RelationshipScoreFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 20, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}}}, "s": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.ReportGenerator.get_planets_table": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 9, "/": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 1}}}}}}}}, "/": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 3}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 6}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.HouseComparisonFactory": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 2.23606797749979}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 2}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.7320508075688772}}, "df": 6, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 6, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 2}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 2.23606797749979}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 2}}, "df": 19}, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}}, "df": 2}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}}, "df": 4}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 11, "s": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory": {"tf": 2.449489742783178}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 3}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer": {"tf": 2}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 3}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 2}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 2.23606797749979}, "kerykeion.HouseComparisonFactory": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 2.449489742783178}, "kerykeion.HouseComparisonModel": {"tf": 2.23606797749979}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 3.4641016151377544}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 2.449489742783178}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 2.23606797749979}}, "df": 27}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory": {"tf": 2}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}}, "df": 8, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 2}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 5}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "n": {"1": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}}, "df": 1}, "2": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}}, "df": 1}, "docs": {"kerykeion.CompositeSubjectFactory": {"tf": 2}, "kerykeion.HouseComparisonFactory": {"tf": 1.4142135623730951}}, "df": 2}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 5}}}}, "s": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.HouseComparisonFactory": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 2, "s": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 3}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.CompositeSubjectFactory": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "p": {"3": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "t": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "t": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}}, "df": 2}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1.4142135623730951}}, "df": 5, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {"kerykeion": {"tf": 4.242640687119285}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.6457513110645907}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 2.6457513110645907}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 2.8284271247461903}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 2.6457513110645907}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonModel": {"tf": 2}, "kerykeion.HouseComparisonModel.first_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.second_subject_name": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2.6457513110645907}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 3}, "kerykeion.ReportGenerator.get_data_table": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.7320508075688772}}, "df": 31, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}}, "df": 5}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.7320508075688772}, "kerykeion.ReportGenerator.get_report_title": {"tf": 1}}, "df": 10, "l": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion": {"tf": 3.3166247903554}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 2.8284271247461903}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1.4142135623730951}}, "df": 12}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 3.3166247903554}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2.8284271247461903}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 3.3166247903554}, "kerykeion.PlanetaryReturnFactory": {"tf": 3.4641016151377544}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 4.358898943540674}}, "df": 7, "/": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "e": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}}, "df": 7}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 2}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}}, "df": 2}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 4.795831523312719}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 3.7416573867739413}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 3.7416573867739413}, "kerykeion.ChartDrawer": {"tf": 3}, "kerykeion.ChartDrawer.__init__": {"tf": 3.1622776601683795}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 3.605551275463989}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.RelationshipScoreFactory": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.7320508075688772}}, "df": 18, "l": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.ChartDrawer.makeTemplate": {"tf": 1}}, "df": 1}}, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2}}, "df": 2}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}}, "df": 2}}}, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 2.6457513110645907}, "kerykeion.ChartDrawer": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}}, "df": 9}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 2}}}}}, "r": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}}, "df": 1}}, "r": {"docs": {"kerykeion": {"tf": 2.6457513110645907}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2.449489742783178}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer": {"tf": 2.23606797749979}, "kerykeion.ChartDrawer.__init__": {"tf": 2.449489742783178}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2.449489742783178}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 22, "b": {"docs": {"kerykeion": {"tf": 2.23606797749979}, "kerykeion.AspectsFactory": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 2.6457513110645907}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 8, "i": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}}, "df": 1}}}}}}}}}}, "g": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1, "/": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 2}}}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}}, "df": 2}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 1}}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {"kerykeion.ChartDrawer": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}}, "df": 2, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}}, "df": 2, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.4142135623730951}}, "df": 4}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {"kerykeion": {"tf": 2.449489742783178}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}}, "df": 3}}}}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.HouseComparisonModel": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 8}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 4, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 3}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 5, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 3}}}}, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}}, "df": 3}}}}}}, "k": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 6.4031242374328485}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator": {"tf": 1}, "kerykeion.KerykeionSettingsModel": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 5, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 5.744562646538029}, "kerykeion.ChartDrawer": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}}, "df": 3}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}}, "df": 10}}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}, "p": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}, "e": {"docs": {}, "df": 0, "p": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}, "y": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.7320508075688772}}, "df": 1}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 3}}}}, "c": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "m": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 3.3166247903554}, "kerykeion.AspectsFactory": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory": {"tf": 3.4641016151377544}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 2.449489742783178}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 3.3166247903554}}, "df": 8, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}}, "df": 3}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.CompositeSubjectFactory": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1}}, "df": 3}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}}, "df": 2}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.HouseComparisonFactory": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.HouseComparisonModel": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 5, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AspectsFactory": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory": {"tf": 1}}, "df": 4}}}}}, "e": {"docs": {"kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 3, "s": {"docs": {"kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 2}, "d": {"docs": {"kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}}, "df": 2}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}}, "df": 3, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}}, "df": 3}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 2}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 2}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 12}}, "x": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 11}}}}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1}}}}}, "/": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 5, "l": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 6, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.CompositeSubjectFactory": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.PlanetaryReturnFactory.__init__": {"tf": null}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 4, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}}, "df": 2}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.7320508075688772}}, "df": 11}}}, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonModel": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 4}}}}}, "j": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.4142135623730951}}, "df": 3}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}, "kerykeion.get_settings": {"tf": 1.7320508075688772}}, "df": 5, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "d": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 2}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 7}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 10, "s": {"docs": {"kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 1}}}}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 2}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.HouseComparisonModel.model_config": {"tf": 1.4142135623730951}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1.4142135623730951}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1.4142135623730951}}, "df": 3}}}}, "/": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.get_settings": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}}, "df": 3}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}}, "df": 1, "s": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}}, "df": 1}}, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 2}}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 2, "s": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 2}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 8, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 5, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2.8284271247461903}}, "df": 5}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1}}}}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}}, "df": 4}}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.CompositeSubjectFactory": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 9.16515138991168}, "kerykeion.AspectsFactory": {"tf": 3.3166247903554}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 2.6457513110645907}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.449489742783178}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2}, "kerykeion.ChartDrawer": {"tf": 4.58257569495584}, "kerykeion.ChartDrawer.__init__": {"tf": 3}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory": {"tf": 2.6457513110645907}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 2}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 2.8284271247461903}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 3.3166247903554}, "kerykeion.HouseComparisonFactory": {"tf": 2}, "kerykeion.PlanetaryReturnFactory": {"tf": 3.872983346207417}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2.8284271247461903}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory": {"tf": 3.3166247903554}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 2}}, "df": 33, "s": {"docs": {"kerykeion": {"tf": 3.1622776601683795}, "kerykeion.AspectsFactory": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 12, "\u2014": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 2}}}}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 2.23606797749979}}, "df": 1, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory": {"tf": 1.7320508075688772}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 3}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 3.605551275463989}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 12, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.7320508075688772}}, "df": 16, "s": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 2.8284271247461903}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory": {"tf": 2.449489742783178}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 20}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 7}}}, "e": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 14, "d": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 15}, "s": {"docs": {"kerykeion.AspectsFactory": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}}, "df": 7}}}}}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}}, "df": 4}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.7320508075688772}}, "df": 3}}}}}}, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "p": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 2}}}}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.7320508075688772}}, "df": 3, "d": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 5}}, "t": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 3}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.RelationshipScoreFactory": {"tf": 1}}, "df": 1}}}}}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"kerykeion": {"tf": 2.449489742783178}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 2.23606797749979}}, "df": 8, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1.7320508075688772}}, "df": 1}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}}, "df": 1}}}}}}}}}, "p": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 2}}, "df": 3, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 10}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 3.1622776601683795}}, "df": 3, "l": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 2}}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 2.23606797749979}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.KerykeionSettingsModel": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.4142135623730951}}, "df": 9, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 3}, "kerykeion.ChartDrawer": {"tf": 3}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1.4142135623730951}}, "df": 10}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "y": {"docs": {"kerykeion": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2}, "kerykeion.PlanetaryReturnFactory": {"tf": 3}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 8, "/": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 2}}}}}}}}, "e": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "o": {"docs": {"kerykeion.RelationshipScoreFactory": {"tf": 1}}, "df": 1, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {"kerykeion.RelationshipScoreFactory": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 8}}}, "e": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator": {"tf": 1}, "kerykeion.ReportGenerator.__init__": {"tf": 1}}, "df": 11, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.ReportGenerator.get_data_table": {"tf": 1}, "kerykeion.ReportGenerator.get_planets_table": {"tf": 1}, "kerykeion.ReportGenerator.get_houses_table": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 13}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1}}}}}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 7}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 3, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 3}}}}}}, "g": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.4142135623730951}}, "df": 9, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.7320508075688772}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 2.23606797749979}, "kerykeion.ChartDrawer": {"tf": 2.449489742783178}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 2}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1.4142135623730951}}, "df": 5, "s": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 2.8284271247461903}, "kerykeion.ChartDrawer": {"tf": 2}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1}, "kerykeion.ReportGenerator.get_report_title": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 14, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 5}, "d": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.ChartDrawer": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 8}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 4}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 3}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 3}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory": {"tf": 3}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 3.1622776601683795}}, "df": 7}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 6}}}}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.7320508075688772}}, "df": 2}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 2}}}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}}, "df": 3}}}}}}}}, "t": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 3.4641016151377544}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 11}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "b": {"docs": {"kerykeion": {"tf": 4.47213595499958}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 9}, "t": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory": {"tf": 2.449489742783178}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 3.4641016151377544}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2.449489742783178}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 3.4641016151377544}, "kerykeion.ChartDrawer": {"tf": 2.23606797749979}, "kerykeion.EphemerisDataFactory": {"tf": 4.58257569495584}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 5}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 7.3484692283495345}, "kerykeion.PlanetaryReturnFactory": {"tf": 3.872983346207417}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 3}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 6}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 4.58257569495584}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 6.244997998398398}, "kerykeion.TransitsTimeRangeFactory": {"tf": 4.898979485566356}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 5.196152422706632}}, "df": 16}, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.KerykeionSettingsModel": {"tf": 1}}, "df": 2}}}}}}, "b": {"docs": {"kerykeion.HouseComparisonFactory": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1, "/": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 6}}, "e": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 3, "d": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.ReportGenerator.get_report_title": {"tf": 1}}, "df": 7}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion": {"tf": 8.246211251235321}, "kerykeion.AspectsFactory": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 12, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}, "/": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.449489742783178}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2.6457513110645907}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.7320508075688772}}, "df": 3}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.HouseComparisonModel": {"tf": 1}}, "df": 3}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion": {"tf": 2.23606797749979}}, "df": 1}}}, "d": {"docs": {"kerykeion": {"tf": 1.7320508075688772}}, "df": 1, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "e": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.7320508075688772}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 18, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory": {"tf": 2}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.HouseComparisonModel": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}, "kerykeion.RelationshipScoreFactory": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 14}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 2}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 2}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}}}, "y": {"docs": {"kerykeion": {"tf": 2.449489742783178}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 11}, "u": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 4}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AspectsFactory": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 12}}, "o": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1}}, "df": 16}}, "r": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 2}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.TransitsTimeRangeFactory": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 3}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 4}}, "b": {"docs": {"kerykeion": {"tf": 2.23606797749979}}, "df": 1, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 3}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 2.23606797749979}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 5.291502622129181}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 2}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 2.8284271247461903}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 16, "s": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}}, "df": 1}, "[": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 8}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 4}}}}}}}}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.CompositeSubjectFactory": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 2, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1}}}}}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 3}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "m": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 5}}}}, "n": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}}, "df": 1, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.7320508075688772}}, "df": 7}}}}}}, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 6}}}}, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}}, "df": 2}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.6457513110645907}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 3}, "kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 4.123105625617661}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 3.872983346207417}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 12, "s": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.get_settings": {"tf": 1.4142135623730951}}, "df": 1}}}, "l": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2}}, "df": 4, "l": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}}}}}}}, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}}, "df": 2, "s": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.7320508075688772}}, "df": 8, "e": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.7320508075688772}}, "df": 7, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}}}}, "/": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 2.23606797749979}, "kerykeion.ChartDrawer": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 2}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}}, "df": 3}}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 4}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion": {"tf": 2.6457513110645907}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 3}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 3.3166247903554}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 4.69041575982343}}, "df": 11}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}}, "df": 5, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 4.242640687119285}}, "df": 1}}}}, "o": {"docs": {"kerykeion": {"tf": 1.7320508075688772}}, "df": 1}, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}}, "df": 2}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 5}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 3}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.7320508075688772}}, "df": 7, "/": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {"kerykeion": {"tf": 2.23606797749979}, "kerykeion.ChartDrawer": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 2}, "kerykeion.HouseComparisonModel": {"tf": 2}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator.get_report_title": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.4142135623730951}}, "df": 12, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}, "t": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 2.23606797749979}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}}, "df": 4, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.4142135623730951}}, "df": 3}}}}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}}, "df": 4, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.8284271247461903}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 3}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.6457513110645907}, "kerykeion.ChartDrawer": {"tf": 2}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 17, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 2, "d": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 4}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 8, "s": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}}, "df": 1}}}}}}, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 3, "s": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer": {"tf": 1.4142135623730951}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 2.6457513110645907}}, "df": 1}}, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 2}}}, "y": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 5.830951894845301}, "kerykeion.ChartDrawer": {"tf": 3.605551275463989}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 11, "s": {"docs": {"kerykeion.ChartDrawer": {"tf": 2}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion": {"tf": 4.123105625617661}, "kerykeion.AspectsFactory": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1}}, "df": 7}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.23606797749979}, "kerykeion.CompositeSubjectFactory": {"tf": 2.6457513110645907}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 2.23606797749979}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.HouseComparisonModel": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 20, "s": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory": {"tf": 2.23606797749979}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 5}}}}}, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.CompositeSubjectFactory": {"tf": 1}}, "df": 1}}}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 4, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.7320508075688772}}, "df": 3, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.7320508075688772}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 3}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 2}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 2.449489742783178}, "kerykeion.HouseComparisonModel": {"tf": 2.449489742783178}, "kerykeion.HouseComparisonModel.second_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1.4142135623730951}}, "df": 17, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}}, "df": 3}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 2}}}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {"kerykeion": {"tf": 2.449489742783178}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1.7320508075688772}}, "df": 4, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion": {"tf": 2.23606797749979}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.KerykeionSettingsModel": {"tf": 1}, "kerykeion.get_settings": {"tf": 2.449489742783178}, "kerykeion.TransitsTimeRangeFactory": {"tf": 2.23606797749979}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.7320508075688772}}, "df": 15}}}}}, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 2}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "d": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 3}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 3, "s": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {"kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 6}, "d": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 2}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 2}}}}}}}, "o": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}}, "df": 3, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion": {"tf": 2.8284271247461903}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 5}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 3.1622776601683795}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 4}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 3.605551275463989}}, "df": 4}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 2.23606797749979}}, "df": 1, "s": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 10}, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 2.449489742783178}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}}, "df": 3}}}}}}}, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}}, "df": 2}}}}}}}, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}}}}}, "j": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.7320508075688772}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 3.4641016151377544}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory": {"tf": 2.8284271247461903}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer": {"tf": 2.23606797749979}, "kerykeion.ChartDrawer.__init__": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 2.449489742783178}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 2.449489742783178}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory": {"tf": 3}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 2}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 3.1622776601683795}, "kerykeion.HouseComparisonModel": {"tf": 3.1622776601683795}, "kerykeion.HouseComparisonModel.first_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.second_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 2.8284271247461903}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.7320508075688772}, "kerykeion.RelationshipScoreFactory": {"tf": 2}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.ReportGenerator.get_report_title": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 36, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 2.23606797749979}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 2}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 2.8284271247461903}, "kerykeion.HouseComparisonFactory": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.HouseComparisonModel": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 15, "[": {"0": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 2}}, "df": 1}, "docs": {}, "df": 0}}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {"kerykeion": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 2.6457513110645907}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.4142135623730951}}, "df": 12}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 2.6457513110645907}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.6457513110645907}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.8284271247461903}, "kerykeion.CompositeSubjectFactory": {"tf": 2.23606797749979}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 8, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}}, "df": 4}}}}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 1}}}}}}}}, "g": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 2.6457513110645907}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}}, "df": 4, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 2}}}}}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion": {"tf": 2.6457513110645907}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 2.449489742783178}, "kerykeion.AspectsFactory": {"tf": 2.449489742783178}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 2}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory": {"tf": 1}}, "df": 5, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion": {"tf": 1.7320508075688772}}, "df": 1}, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2.23606797749979}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 9}, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2.449489742783178}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 13}, "s": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}}, "df": 4}, "s": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}}, "df": 5, "d": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}}, "df": 3}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 2}}}}, "g": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "f": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}}, "df": 3}}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 1}}}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 2}}, "n": {"docs": {"kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 1}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 6}}}}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.7320508075688772}}, "df": 4, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1, "p": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.RelationshipScoreFactory": {"tf": 1}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"kerykeion.RelationshipScoreFactory": {"tf": 1.4142135623730951}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.RelationshipScoreFactory": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 3}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 1}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 3}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {"kerykeion": {"tf": 4.898979485566356}, "kerykeion.AspectsFactory": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 2}, "kerykeion.EphemerisDataFactory": {"tf": 2.23606797749979}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2.8284271247461903}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2.449489742783178}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.ReportGenerator": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator.__init__": {"tf": 1.4142135623730951}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.7320508075688772}}, "df": 32, "n": {"docs": {"kerykeion": {"tf": 3}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1.4142135623730951}}, "df": 5, "d": {"docs": {"kerykeion": {"tf": 4.795831523312719}, "kerykeion.AspectsFactory": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 3}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 3.3166247903554}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.449489742783178}, "kerykeion.ChartDrawer": {"tf": 3.3166247903554}, "kerykeion.ChartDrawer.__init__": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 2}, "kerykeion.EphemerisDataFactory": {"tf": 2.6457513110645907}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 2.23606797749979}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 2.8284271247461903}, "kerykeion.HouseComparisonFactory": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 3.3166247903554}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 3.4641016151377544}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 3}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2.6457513110645907}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 3.872983346207417}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 2.23606797749979}}, "df": 34}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion": {"tf": 1.7320508075688772}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 3}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 6}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 3}}}}, "y": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}}, "df": 3}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 2.23606797749979}, "kerykeion.HouseComparisonFactory": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonModel": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 15}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.HouseComparisonFactory": {"tf": 1}}, "df": 1}}}, "z": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 2}, "d": {"docs": {"kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.HouseComparisonFactory": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 4}}}}}, "s": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer": {"tf": 2}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 2.6457513110645907}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 2.6457513110645907}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 16, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 4, "@": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"kerykeion": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 2.8284271247461903}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.449489742783178}, "kerykeion.ChartDrawer": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 2.23606797749979}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 2}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 2}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 3.605551275463989}, "kerykeion.HouseComparisonFactory": {"tf": 2.23606797749979}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.HouseComparisonModel": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2.8284271247461903}, "kerykeion.RelationshipScoreFactory": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 2}}, "df": 27, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 5, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion": {"tf": 7.14142842854285}, "kerykeion.AspectsFactory": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 12}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 15}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 6}}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 3}}}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 3.1622776601683795}, "kerykeion.AspectsFactory": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer": {"tf": 2.6457513110645907}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 2}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 2.449489742783178}}, "df": 12, "s": {"docs": {"kerykeion": {"tf": 4.58257569495584}, "kerykeion.AspectsFactory": {"tf": 3.3166247903554}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 3.1622776601683795}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 2.8284271247461903}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 2.23606797749979}, "kerykeion.ChartDrawer.__init__": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1.7320508075688772}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 2.8284271247461903}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 3.3166247903554}}, "df": 15, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.AspectsFactory": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.natal_aspects": {"tf": 1}, "kerykeion.AspectsFactory.synastry_aspects": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 7}}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}}}, "c": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 3}}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 2}, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "o": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 3}}}}}}}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 6}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}, "g": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 4}}}}}}, "l": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 2.6457513110645907}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 2.8284271247461903}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.7320508075688772}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 2.449489742783178}}, "df": 17, "o": {"docs": {}, "df": 0, "w": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}}, "df": 1}}, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1}}, "g": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 2}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}}}, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 3}}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 9}}}}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.CompositeSubjectFactory": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 4}, "d": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}}, "df": 2}}}, "y": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1.4142135623730951}}, "df": 3}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}}, "df": 4}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2}}, "df": 8, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 7, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 2}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 6}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 2.23606797749979}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer": {"tf": 2.23606797749979}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 3}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 2}}, "df": 18, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.TransitsTimeRangeFactory": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 2, "s": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "r": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}, "y": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}}}}}}, "m": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "p": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 2}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "o": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 2}}}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"kerykeion": {"tf": 1.7320508075688772}}, "df": 1, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 5, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 7}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.get_settings": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {"kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 31}}, "i": {"docs": {"kerykeion": {"tf": 2}}, "df": 1}, "e": {"docs": {"kerykeion": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory": {"tf": 2}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 12}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 2}}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 3}}}, "s": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 2}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.7320508075688772}}, "df": 6}}, "v": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 4}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}}, "df": 1}}}}}}}}}}}, "t": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.7320508075688772}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 12, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1}, "kerykeion.HouseComparisonModel": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 6}}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}, "d": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 1, "d": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 2}}}}}}, "j": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}}}}}}, "g": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.TransitsTimeRangeFactory": {"tf": 1}}, "df": 1}}}}}}, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}}, "df": 1}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}}, "df": 5}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 3, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}}, "df": 2}}}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}}}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "p": {"docs": {"kerykeion": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}}, "df": 2}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 4}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 3.1622776601683795}}, "df": 1}}, "x": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 6.324555320336759}, "kerykeion.AstrologicalSubjectFactory": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 2.6457513110645907}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 2.449489742783178}, "kerykeion.EphemerisDataFactory": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 2.449489742783178}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonModel": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 19, "s": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 2.449489742783178}, "kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 2}, "kerykeion.HouseComparisonModel": {"tf": 2}, "kerykeion.HouseComparisonModel.first_points_in_second_houses": {"tf": 1}, "kerykeion.HouseComparisonModel.second_points_in_first_houses": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.ReportGenerator.get_houses_table": {"tf": 1}}, "df": 14, "s": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.HouseComparisonFactory": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 4, "s": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 2.23606797749979}}, "df": 1}, "l": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1.4142135623730951}}, "df": 2}}, "w": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonModel": {"tf": 1}}, "df": 2}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.23606797749979}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}}, "df": 4}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 4}, "d": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}}}}}}, ":": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "w": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.RelationshipScoreFactory": {"tf": 1}}, "df": 3}}}}}}}}, "m": {"docs": {"kerykeion.RelationshipScoreFactory": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.CompositeSubjectFactory": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "o": {"docs": {"kerykeion.ChartDrawer": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}}, "df": 4, "t": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.449489742783178}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}, "kerykeion.get_settings": {"tf": 1}}, "df": 12, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 14, "s": {"docs": {"kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 5}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 4}}, "df": 1, "s": {"docs": {"kerykeion": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}}, "df": 3}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 5, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 2}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory": {"tf": 2.8284271247461903}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.get_settings": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1.4142135623730951}}, "df": 18}}, "w": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 4}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 3}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2.8284271247461903}}, "df": 4}}, "w": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.__init__": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.EphemerisDataFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}}, "df": 9}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}}, "df": 3, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}, "s": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}}, "df": 4}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 1}}, "df": 3}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion": {"tf": 2.8284271247461903}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 2.449489742783178}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2.23606797749979}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.449489742783178}, "kerykeion.ChartDrawer": {"tf": 3.1622776601683795}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 2}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.get_house_comparison": {"tf": 2}, "kerykeion.HouseComparisonModel": {"tf": 2}, "kerykeion.HouseComparisonModel.first_subject_name": {"tf": 1}, "kerykeion.HouseComparisonModel.second_subject_name": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.ReportGenerator.get_report_title": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 23, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}}, "df": 4}, "d": {"docs": {"kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}}, "df": 3}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1.7320508075688772}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1.7320508075688772}, "kerykeion.PlanetaryReturnFactory": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}}, "df": 8, "/": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 2}, "kerykeion.ChartDrawer.__init__": {"tf": 1}, "kerykeion.HouseComparisonFactory": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 3.3166247903554}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 2.23606797749979}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 2.23606797749979}}, "df": 17}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.EphemerisDataFactory": {"tf": 2.23606797749979}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1.4142135623730951}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.TransitsTimeRangeFactory": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 8}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.RelationshipScoreFactory": {"tf": 1}, "kerykeion.RelationshipScoreFactory.get_relationship_score": {"tf": 1}}, "df": 2}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 1.4142135623730951}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2.449489742783178}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.7320508075688772}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 10, "o": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion": {"tf": 4.795831523312719}, "kerykeion.AspectsFactory": {"tf": 2.23606797749979}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1.7320508075688772}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.AstrologicalSubjectFactory": {"tf": 2.449489742783178}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 3.4641016151377544}, "kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 2.6457513110645907}, "kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 2.8284271247461903}, "kerykeion.ChartDrawer": {"tf": 2.8284271247461903}, "kerykeion.ChartDrawer.__init__": {"tf": 2.23606797749979}, "kerykeion.ChartDrawer.set_up_theme": {"tf": 1}, "kerykeion.ChartDrawer.set_output_directory": {"tf": 1}, "kerykeion.ChartDrawer.parse_json_settings": {"tf": 1}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.ChartDrawer.makeWheelOnlyTemplate": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeWheelOnlySVG": {"tf": 1}, "kerykeion.ChartDrawer.makeAspectGridOnlyTemplate": {"tf": 1.4142135623730951}, "kerykeion.ChartDrawer.makeAspectGridOnlySVG": {"tf": 1}, "kerykeion.CompositeSubjectFactory": {"tf": 1}, "kerykeion.CompositeSubjectFactory.__init__": {"tf": 2}, "kerykeion.CompositeSubjectFactory.get_midpoint_composite_subject_model": {"tf": 2.23606797749979}, "kerykeion.EphemerisDataFactory": {"tf": 4.47213595499958}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 2.6457513110645907}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 3.1622776601683795}, "kerykeion.HouseComparisonFactory": {"tf": 1.4142135623730951}, "kerykeion.HouseComparisonFactory.__init__": {"tf": 1.7320508075688772}, "kerykeion.HouseComparisonModel.model_config": {"tf": 1}, "kerykeion.PlanetaryReturnFactory": {"tf": 5.196152422706632}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 4.123105625617661}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 3.872983346207417}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 4.358898943540674}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 3.7416573867739413}, "kerykeion.PlanetReturnModel": {"tf": 1}, "kerykeion.PlanetReturnModel.model_config": {"tf": 1}, "kerykeion.ReportGenerator": {"tf": 1}, "kerykeion.ReportGenerator.__init__": {"tf": 1}, "kerykeion.KerykeionSettingsModel": {"tf": 1}, "kerykeion.KerykeionSettingsModel.model_config": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory": {"tf": 3}, "kerykeion.TransitsTimeRangeFactory.__init__": {"tf": 2.23606797749979}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 2.6457513110645907}}, "df": 42, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.AstrologicalSubjectFactory": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.7320508075688772}}, "df": 3, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 2.8284271247461903}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2.23606797749979}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1.4142135623730951}}, "df": 5}}}, "s": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_iso_utc_time": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.7320508075688772}}, "df": 3}}}}}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.AspectsFactory.single_chart_aspects": {"tf": 1}, "kerykeion.AspectsFactory.dual_chart_aspects": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}, "kerykeion.get_settings": {"tf": 1}, "kerykeion.TransitsTimeRangeFactory.get_transit_moments": {"tf": 1}}, "df": 7}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion": {"tf": 1.4142135623730951}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion.get_settings": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.ChartDrawer": {"tf": 1}, "kerykeion.ChartDrawer.__init__": {"tf": 1}}, "df": 2}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion": {"tf": 2}, "kerykeion.AstrologicalSubjectFactory.from_birth_data": {"tf": 1}, "kerykeion.ChartDrawer": {"tf": 1.7320508075688772}, "kerykeion.ChartDrawer.makeTemplate": {"tf": 1}, "kerykeion.ChartDrawer.makeSVG": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 2}, "kerykeion.ReportGenerator.get_full_report": {"tf": 1}}, "df": 7, "y": {"docs": {"kerykeion.AstrologicalSubjectFactory.from_current_time": {"tf": 1}, "kerykeion.EphemerisDataFactory.get_ephemeris_data_as_astrological_subjects": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"kerykeion": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"kerykeion.get_settings": {"tf": 1}}, "df": 1, "s": {"docs": {"kerykeion": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1}}, "df": 2}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"kerykeion.AspectsFactory": {"tf": 1}}, "df": 1}}}}}}}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"kerykeion.PlanetaryReturnFactory": {"tf": 1}, "kerykeion.PlanetaryReturnFactory.__init__": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"kerykeion": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_iso_formatted_time": {"tf": 1.4142135623730951}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 2.23606797749979}}, "df": 3, "s": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_year": {"tf": 2}, "kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"kerykeion.PlanetaryReturnFactory.next_return_from_month_and_year": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "s": 