# 🎉 V4.16: Astrological Charts Enhanced! 🌟

## ✨ Themed Astrological Charts

You can now customize the look and feel of your astrological charts with themes! I've added four unique themes to choose from:

- **Classic** (default)
- **Dark**
- **Dark High Contrast**
- **Light**

### How to Use Themes

Here's a quick example of how you can apply the "Dark" theme:

```python
dark_theme_subject = AstrologicalSubject("John Lennon - Dark Theme", 1940, 10, 9, 18, 30, "Liverpool", "GB")
dark_theme_natal_chart = KerykeionChartSVG(dark_theme_subject, theme="dark")
dark_theme_natal_chart.makeSVG()
```

You can also choose not to set any theme, which makes it easier to override the default CSS variables. For more details, check out the [documentation](https://www.kerykeion.net/docs//theming).

## 🌐 Minimalist Charts & Aspect Table

- **Wheel-Only Charts**: I've added an option to generate a minimalist chart that only includes the wheel, stripping away any extra details.

- **Separate Aspect Table SVG**: Now, you can extract the aspect table as a separate SVG file, giving you more flexibility in your analysis and presentations.

For further information, see the [details](https://www.kerykeion.net/docs//whee-and-grid-only).

## 🔄 Synastry & Transit Chart Enhancements

- **Aspect Table Grid View**: You can now display aspects in a grid format, providing a clearer and more organized view compared to the traditional list format.

More details on these updates can be found [here](https://www.kerykeion.net/docs//synastry-chart).

---

I hope these new features make your astrological charting experience even more powerful and enjoyable. Happy charting! ✨
