# Version 4.22.0

## New Feature: Explicit Calculation of Ascendant/Descendant and MC/IC Axes

### Overview
This update introduces explicit calculations for the Ascendant (AC), Descendant (DC), Midheaven (MC), and Imum Coeli (IC) axes. These enhancements are crucial for whole-sign house systems, where axes typically do not align with house cusps (H1/H7 and H4/H10). 

#### More details about whole-sign house systems:
  - House 1 begins at 0° of the sign where AC falls and extends to 30°.
  - House 7 (DC) follows symmetrically on the opposite side.
  - AC is **not** necessarily at the cusp of House 1, nor is DC at the cusp of House 7.
  - Houses are sequentially numbered following the zodiac signs.
  - MC may appear in Houses 9, 10, or 11, and is not necessarily aligned with 0° of House 10. IC follows accordingly in Houses 3, 4, or 5.
  - Planetary aspects to these axes must be explicitly calculated rather than inferred from house cusps.

### Code Changes
- **Astrological Subject Calculations:**
  - AC, DC, MC, and IC are now explicitly calculated using the Swiss Ephemeris library.
  - These axes are treated similarly to planetary positions.
  - New "axial_cusps_names_list" parameter in `astrological_subject.py`. It contains the names of the axes for easy reference.
- **Configuration Updates:**
  - New explicit settings for AC, DC, MC, and IC in `kerykeion/settings/kr.config.json`.
- **Utilities Adjustments:**
  - The `check_if_between` method has been replaced with `is_point_between`.
  - The new function correctly handles cases where house systems like Placidus or Campanus position AC at the cusp of House 1.
- **Data Model Changes:**
  - Axes have been integrated into `kerykeion/kr_types/kr_literals.py` and `kerykeion/kr_types/kr_models.py`.

This update lays the groundwork for more accurate house system calculations and aspect handling in Kerykeion. Further refinements and testing, especially in chart generation, are encouraged. Contributions and feedback are welcome!

Many thanks to @fkostadinov for implementing most of these changes in PR #138 🙏
