## Release Note: Composite Charts Feature

This feature allows users to create composite charts, which are astrological charts that combine the data of two individuals to form a single chart. This is particularly useful for analyzing relationships and compatibility.

### Key Features:
- **Composite Subjects**: Create composite subjects by combining the astrological data of two individuals.
- **Composite Charts**: Generate composite charts by combining the astrological data of two individuals.

### Supported Methods:
- **Midpoint Method**: Currently, the only available method for creating composite charts is the midpoint method. In this method, the composite houses and planets are calculated based on the midpoint of the corresponding points of the two subjects.
The house are then reordered to match the original house system of the first subject.

### Example Usage:
Here is an example of how to create a composite chart using the new feature:

```python
if __name__ == "__main__":
    from kerykeion.astrological_subject import AstrologicalSubject
    from kerykeion.composite_subject_factory import CompositeSubjectFactory
    from kerykeion.charts.kerykeion_chart_svg import KerykeionChartSVG

    # Create astrological subjects
    first = AstrologicalSubject("John Lennon", 1940, 10, 9, 18, 30, "Liverpool", "GB")
    second = AstrologicalSubject("Paul McCartney", 1942, 6, 18, 15, 30, "Liverpool", "GB")

    # Generate composite chart data
    composite_chart = CompositeSubjectFactory(first, second)
    print(composite_chart.get_midpoint_composite_subject_model().model_dump_json(indent=4))

    # Create and save the composite chart as an SVG
    angelina = AstrologicalSubject("Angelina Jolie", 1975, 6, 4, 9, 9, "Los Angeles", "US", lng=-118.15, lat=34.03, tz_str="America/Los_Angeles")
    brad = AstrologicalSubject("Brad Pitt", 1963, 12, 18, 6, 31, "Shawnee", "US", lng=-96.56, lat=35.20, tz_str="America/Chicago")

    composite_subject_factory = CompositeSubjectFactory(angelina, brad)
    composite_subject_model = composite_subject_factory.get_midpoint_composite_subject_model()
    composite_chart = KerykeionChartSVG(composite_subject_model, "Composite")
    composite_chart.makeSVG()
```

With this new feature, you can now explore the dynamics of relationships through composite charts, providing deeper insights into compatibility and shared potentials.
