# 🌟 Kerykeion v5.0.0-beta – Modern Astrology Library
 **Kerykeion v5.0 beta** is here!

## 🎯 What's New

### Modern Architecture
- **Factory-based API**: `AstrologicalSubjectFactory`, `ChartDataFactory`, `ChartDrawer`
- **Pydantic 2 models**: Fully typed, serializable data in `kerykeion.schemas`
- **Backward compatible**: Legacy classes available via `kerykeion.backword` with deprecation warnings

### Enhanced Features
- **Unified AspectsFactory** for natal and synastry aspects
- **PlanetaryReturnFactory** for solar/lunar returns
- **TransitsTimeRangeFactory** for transit analysis
- **Text Reports** (NEW!): Auto-generated reports for 7 chart types

### Better Rendering
- 5 updated SVG themes with minification support
- Separate wheel/aspect grid exports
- Refreshed visual assets

## 🚀 Quick Start

```python
from kerykeion import AstrologicalSubjectFactory, ChartDataFactory, ChartDrawer
from kerykeion.reports import Report

# Create subject and chart
subject = AstrologicalSubjectFactory.from_birth_data(
    "Ada Lovelace", 1815, 12, 10, 4, 20, "London", "GB"
)
chart = ChartDataFactory.create_natal_chart_data(subject)

# Export SVG
ChartDrawer(chart, theme="classic").save_svg("output", "chart")

# Generate text report
Report(chart).print_report()
```

## ⚠️ Breaking Changes

- **Lunar nodes renamed**: `Mean_Node` → `Mean_North_Lunar_Node`
- Legacy classes removed (available via `backword` module)
- `kr_types` replaced by `kerykeion.schemas`

## 📦 Installation

```bash
pip install kerykeion==5.0.0b1
```

## 🧪 Help Us Test

We need feedback on:
- New factory API
- Text reports module
- Migration from v4
- New SVG themes

**Report issues**: [GitHub](https://github.com/g-battaglia/kerykeion/issues)

**Full documentation**: `site-docs/` | **Examples**: `examples/`

---

**Thank you for helping us test v5.0!** This beta is production-ready and sets the foundation for advanced modules (web APIs, automation, AI integration) powered by a modern, data-first core.
