# Asterix specifications

# This file is generated, DO NOT EDIT!
# For more details, see:
#     - https://github.com/zoranbosnjak/asterix-specs

from asterix.base import *

asterix_specs_ref = "git:24c25cfe2968365c53db276222925b2279a9bcb8"
asterix_specs_date = "2024-11-07T10:16:51+01:00"
code_generator_version = "0.4.0"

# Asterix types

class Content_0(ContentRaw):
    cv_arg: TypeAlias = int

class RuleContent_0(RuleContentContextFree):
    cv_arg: TypeAlias = Content_0.cv_arg
    cv_content: TypeAlias = Content_0

    @property
    def content(self) -> Content_0:
        return self._get_content() # type: ignore

class Variation_164(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_164.cv_arg") -> "Variation_164":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_158(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_164.cv_arg
    cv_variation: TypeAlias = Variation_164

    @classmethod
    def create(cls, arg : "RuleVariation_158.cv_arg") -> "RuleVariation_158":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_164:
        return self.arg # type: ignore

class NonSpare_1644(NonSpare):
    cv_arg: TypeAlias = RuleVariation_158.cv_arg
    cv_name = "SAC"
    cv_title = "System Area Code"
    cv_rule: TypeAlias = RuleVariation_158

    @classmethod
    def create(cls, arg : "NonSpare_1644.cv_arg") -> "NonSpare_1644":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_158:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_164:
        return self.rule.variation

class Item_851(Item):
    cv_arg: TypeAlias = NonSpare_1644.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1644

    @classmethod
    def create(cls, arg : "Item_851.cv_arg") -> "Item_851":
        return cls._create(arg) # type: ignore

class NonSpare_1699(NonSpare):
    cv_arg: TypeAlias = RuleVariation_158.cv_arg
    cv_name = "SIC"
    cv_title = "System Identification Code"
    cv_rule: TypeAlias = RuleVariation_158

    @classmethod
    def create(cls, arg : "NonSpare_1699.cv_arg") -> "NonSpare_1699":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_158:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_164:
        return self.rule.variation

class Item_882(Item):
    cv_arg: TypeAlias = NonSpare_1699.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1699

    @classmethod
    def create(cls, arg : "Item_882.cv_arg") -> "Item_882":
        return cls._create(arg) # type: ignore

class Variation_1187(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_158.cv_arg, Tuple[Literal["SAC"], RuleVariation_158.cv_arg]], Union[RuleVariation_158.cv_arg, Tuple[Literal["SIC"], RuleVariation_158.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1187.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_851, 8), (Item_882, 8)]
    cv_items_dict = {"SAC": RuleVariation_158, "SIC": RuleVariation_158}

    @overload
    @classmethod
    def spec(cls, key : Literal["SAC"]) -> RuleVariation_158:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SIC"]) -> RuleVariation_158:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["SAC"], Literal["SIC"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["SAC"]) -> RuleVariation_158:
        ...
    @overload
    def get_item(self, key : Literal["SIC"]) -> RuleVariation_158:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1187.cv_arg") -> 'Variation_1187':
        return cls._create(arg) # type: ignore

class RuleVariation_1135(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1187.cv_arg
    cv_variation: TypeAlias = Variation_1187

    @classmethod
    def create(cls, arg : "RuleVariation_1135.cv_arg") -> "RuleVariation_1135":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1187:
        return self.arg # type: ignore

class NonSpare_35(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1135.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1135

    @classmethod
    def create(cls, arg : "NonSpare_35.cv_arg") -> "NonSpare_35":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1135:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1187:
        return self.rule.variation

class UapItem_35(UapItem):
    cv_non_spare: TypeAlias = NonSpare_35

class Content_426(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Plot", 1: "Track"}

class RuleContent_426(RuleContentContextFree):
    cv_arg: TypeAlias = Content_426.cv_arg
    cv_content: TypeAlias = Content_426

    @property
    def content(self) -> Content_426:
        return self._get_content() # type: ignore

class Variation_71(Element):
    cv_arg: TypeAlias = RuleContent_426.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_426

    @classmethod
    def create(cls, arg: "Variation_71.cv_arg") -> "Variation_71":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_426:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_426:
        return self.rule.content

class RuleVariation_71(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_71.cv_arg
    cv_variation: TypeAlias = Variation_71

    @classmethod
    def create(cls, arg : "RuleVariation_71.cv_arg") -> "RuleVariation_71":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_71:
        return self.arg # type: ignore

class Content_18(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Actual plot or track", 1: "Simulated plot or track"}

class RuleContent_18(RuleContentContextFree):
    cv_arg: TypeAlias = Content_18.cv_arg
    cv_content: TypeAlias = Content_18

    @property
    def content(self) -> Content_18:
        return self._get_content() # type: ignore

class Variation_401(Element):
    cv_arg: TypeAlias = RuleContent_18.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_18

    @classmethod
    def create(cls, arg: "Variation_401.cv_arg") -> "Variation_401":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_18:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_18:
        return self.rule.content

class RuleVariation_390(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_401.cv_arg
    cv_variation: TypeAlias = Variation_401

    @classmethod
    def create(cls, arg : "RuleVariation_390.cv_arg") -> "RuleVariation_390":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_401:
        return self.arg # type: ignore

class Content_346(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No detection", 1: "Sole primary detection", 2: "Sole secondary detection", 3: "Combined primary and secondary detection"}

class RuleContent_346(RuleContentContextFree):
    cv_arg: TypeAlias = Content_346.cv_arg
    cv_content: TypeAlias = Content_346

    @property
    def content(self) -> Content_346:
        return self._get_content() # type: ignore

class Variation_590(Element):
    cv_arg: TypeAlias = RuleContent_346.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 2
    cv_rule = RuleContent_346

    @classmethod
    def create(cls, arg: "Variation_590.cv_arg") -> "Variation_590":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_346:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_346:
        return self.rule.content

class RuleVariation_579(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_590.cv_arg
    cv_variation: TypeAlias = Variation_590

    @classmethod
    def create(cls, arg : "RuleVariation_579.cv_arg") -> "RuleVariation_579":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_590:
        return self.arg # type: ignore

class Content_482(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Target report from antenna 1", 1: "Target report from antenna 2"}

class RuleContent_482(RuleContentContextFree):
    cv_arg: TypeAlias = Content_482.cv_arg
    cv_content: TypeAlias = Content_482

    @property
    def content(self) -> Content_482:
        return self._get_content() # type: ignore

class Variation_751(Element):
    cv_arg: TypeAlias = RuleContent_482.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_482

    @classmethod
    def create(cls, arg: "Variation_751.cv_arg") -> "Variation_751":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_482:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_482:
        return self.rule.content

class RuleVariation_740(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_751.cv_arg
    cv_variation: TypeAlias = Variation_751

    @classmethod
    def create(cls, arg : "RuleVariation_740.cv_arg") -> "RuleVariation_740":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_751:
        return self.arg # type: ignore

class Content_151(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Special Position Identification"}

class RuleContent_151(RuleContentContextFree):
    cv_arg: TypeAlias = Content_151.cv_arg
    cv_content: TypeAlias = Content_151

    @property
    def content(self) -> Content_151:
        return self._get_content() # type: ignore

class Variation_835(Element):
    cv_arg: TypeAlias = RuleContent_151.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_151

    @classmethod
    def create(cls, arg: "Variation_835.cv_arg") -> "Variation_835":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_151:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_151:
        return self.rule.content

class RuleVariation_805(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_835.cv_arg
    cv_variation: TypeAlias = Variation_835

    @classmethod
    def create(cls, arg : "RuleVariation_805.cv_arg") -> "RuleVariation_805":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_835:
        return self.arg # type: ignore

class Content_139(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Plot or track from a fixed transponder"}

class RuleContent_139(RuleContentContextFree):
    cv_arg: TypeAlias = Content_139.cv_arg
    cv_content: TypeAlias = Content_139

    @property
    def content(self) -> Content_139:
        return self._get_content() # type: ignore

class Variation_914(Element):
    cv_arg: TypeAlias = RuleContent_139.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_139

    @classmethod
    def create(cls, arg: "Variation_914.cv_arg") -> "Variation_914":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_139:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_139:
        return self.rule.content

class RuleVariation_884(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_914.cv_arg
    cv_variation: TypeAlias = Variation_914

    @classmethod
    def create(cls, arg : "RuleVariation_884.cv_arg") -> "RuleVariation_884":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_914:
        return self.arg # type: ignore

class Content_155(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Test target indicator"}

class RuleContent_155(RuleContentContextFree):
    cv_arg: TypeAlias = Content_155.cv_arg
    cv_content: TypeAlias = Content_155

    @property
    def content(self) -> Content_155:
        return self._get_content() # type: ignore

class Variation_35(Element):
    cv_arg: TypeAlias = RuleContent_155.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_155

    @classmethod
    def create(cls, arg: "Variation_35.cv_arg") -> "Variation_35":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_155:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_155:
        return self.rule.content

class RuleVariation_35(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_35.cv_arg
    cv_variation: TypeAlias = Variation_35

    @classmethod
    def create(cls, arg : "RuleVariation_35.cv_arg") -> "RuleVariation_35":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_35:
        return self.arg # type: ignore

class Content_158(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Unlawful interference (code 7500)", 2: "Radio-communication failure (code 7600)", 3: "Emergency (code 7700)"}

class RuleContent_158(RuleContentContextFree):
    cv_arg: TypeAlias = Content_158.cv_arg
    cv_content: TypeAlias = Content_158

    @property
    def content(self) -> Content_158:
        return self._get_content() # type: ignore

class Variation_465(Element):
    cv_arg: TypeAlias = RuleContent_158.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 2
    cv_rule = RuleContent_158

    @classmethod
    def create(cls, arg: "Variation_465.cv_arg") -> "Variation_465":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_158:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_158:
        return self.rule.content

class RuleVariation_454(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_465.cv_arg
    cv_variation: TypeAlias = Variation_465

    @classmethod
    def create(cls, arg : "RuleVariation_454.cv_arg") -> "RuleVariation_454":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_465:
        return self.arg # type: ignore

class Content_116(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Military emergency"}

class RuleContent_116(RuleContentContextFree):
    cv_arg: TypeAlias = Content_116.cv_arg
    cv_content: TypeAlias = Content_116

    @property
    def content(self) -> Content_116:
        return self._get_content() # type: ignore

class Variation_624(Element):
    cv_arg: TypeAlias = RuleContent_116.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_116

    @classmethod
    def create(cls, arg: "Variation_624.cv_arg") -> "Variation_624":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_116:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_116:
        return self.rule.content

class RuleVariation_613(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_624.cv_arg
    cv_variation: TypeAlias = Variation_624

    @classmethod
    def create(cls, arg : "RuleVariation_613.cv_arg") -> "RuleVariation_613":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_624:
        return self.arg # type: ignore

class Content_117(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Military identification"}

class RuleContent_117(RuleContentContextFree):
    cv_arg: TypeAlias = Content_117.cv_arg
    cv_content: TypeAlias = Content_117

    @property
    def content(self) -> Content_117:
        return self._get_content() # type: ignore

class Variation_705(Element):
    cv_arg: TypeAlias = RuleContent_117.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_117

    @classmethod
    def create(cls, arg: "Variation_705.cv_arg") -> "Variation_705":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_117:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_117:
        return self.rule.content

class RuleVariation_694(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_705.cv_arg
    cv_variation: TypeAlias = Variation_705

    @classmethod
    def create(cls, arg : "RuleVariation_694.cv_arg") -> "RuleVariation_694":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_705:
        return self.arg # type: ignore

class NonSpare_1946(NonSpare):
    cv_arg: TypeAlias = RuleVariation_71.cv_arg
    cv_name = "TYP"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_71

    @classmethod
    def create(cls, arg : "NonSpare_1946.cv_arg") -> "NonSpare_1946":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_71:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_71:
        return self.rule.variation

class Item_1066(Item):
    cv_arg: TypeAlias = NonSpare_1946.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1946

    @classmethod
    def create(cls, arg : "Item_1066.cv_arg") -> "Item_1066":
        return cls._create(arg) # type: ignore

class NonSpare_1714(NonSpare):
    cv_arg: TypeAlias = RuleVariation_390.cv_arg
    cv_name = "SIM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_390

    @classmethod
    def create(cls, arg : "NonSpare_1714.cv_arg") -> "NonSpare_1714":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_390:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_401:
        return self.rule.variation

class Item_895(Item):
    cv_arg: TypeAlias = NonSpare_1714.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1714

    @classmethod
    def create(cls, arg : "Item_895.cv_arg") -> "Item_895":
        return cls._create(arg) # type: ignore

class NonSpare_1756(NonSpare):
    cv_arg: TypeAlias = RuleVariation_579.cv_arg
    cv_name = "SSRPSR"
    cv_title = "Radar Detection in Last Antenna Scan"
    cv_rule: TypeAlias = RuleVariation_579

    @classmethod
    def create(cls, arg : "NonSpare_1756.cv_arg") -> "NonSpare_1756":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_579:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_590:
        return self.rule.variation

class Item_927(Item):
    cv_arg: TypeAlias = NonSpare_1756.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1756

    @classmethod
    def create(cls, arg : "Item_927.cv_arg") -> "Item_927":
        return cls._create(arg) # type: ignore

class NonSpare_606(NonSpare):
    cv_arg: TypeAlias = RuleVariation_740.cv_arg
    cv_name = "ANT"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_740

    @classmethod
    def create(cls, arg : "NonSpare_606.cv_arg") -> "NonSpare_606":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_740:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_751:
        return self.rule.variation

class Item_74(Item):
    cv_arg: TypeAlias = NonSpare_606.cv_arg
    cv_non_spare: TypeAlias = NonSpare_606

    @classmethod
    def create(cls, arg : "Item_74.cv_arg") -> "Item_74":
        return cls._create(arg) # type: ignore

class NonSpare_1729(NonSpare):
    cv_arg: TypeAlias = RuleVariation_805.cv_arg
    cv_name = "SPI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_805

    @classmethod
    def create(cls, arg : "NonSpare_1729.cv_arg") -> "NonSpare_1729":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_805:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_835:
        return self.rule.variation

class Item_908(Item):
    cv_arg: TypeAlias = NonSpare_1729.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1729

    @classmethod
    def create(cls, arg : "Item_908.cv_arg") -> "Item_908":
        return cls._create(arg) # type: ignore

class NonSpare_1528(NonSpare):
    cv_arg: TypeAlias = RuleVariation_884.cv_arg
    cv_name = "RAB"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_884

    @classmethod
    def create(cls, arg : "NonSpare_1528.cv_arg") -> "NonSpare_1528":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_884:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_914:
        return self.rule.variation

class Item_764(Item):
    cv_arg: TypeAlias = NonSpare_1528.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1528

    @classmethod
    def create(cls, arg : "Item_764.cv_arg") -> "Item_764":
        return cls._create(arg) # type: ignore

class NonSpare_1922(NonSpare):
    cv_arg: TypeAlias = RuleVariation_35.cv_arg
    cv_name = "TST"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_35

    @classmethod
    def create(cls, arg : "NonSpare_1922.cv_arg") -> "NonSpare_1922":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_35:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_35:
        return self.rule.variation

class Item_1045(Item):
    cv_arg: TypeAlias = NonSpare_1922.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1922

    @classmethod
    def create(cls, arg : "Item_1045.cv_arg") -> "Item_1045":
        return cls._create(arg) # type: ignore

class NonSpare_894(NonSpare):
    cv_arg: TypeAlias = RuleVariation_454.cv_arg
    cv_name = "DS1DS2"
    cv_title = "Radar Detection in Last Antenna Scan"
    cv_rule: TypeAlias = RuleVariation_454

    @classmethod
    def create(cls, arg : "NonSpare_894.cv_arg") -> "NonSpare_894":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_454:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_465:
        return self.rule.variation

class Item_273(Item):
    cv_arg: TypeAlias = NonSpare_894.cv_arg
    cv_non_spare: TypeAlias = NonSpare_894

    @classmethod
    def create(cls, arg : "Item_273.cv_arg") -> "Item_273":
        return cls._create(arg) # type: ignore

class NonSpare_1256(NonSpare):
    cv_arg: TypeAlias = RuleVariation_613.cv_arg
    cv_name = "ME"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_613

    @classmethod
    def create(cls, arg : "NonSpare_1256.cv_arg") -> "NonSpare_1256":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_613:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_624:
        return self.rule.variation

class Item_540(Item):
    cv_arg: TypeAlias = NonSpare_1256.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1256

    @classmethod
    def create(cls, arg : "Item_540.cv_arg") -> "Item_540":
        return cls._create(arg) # type: ignore

class NonSpare_1274(NonSpare):
    cv_arg: TypeAlias = RuleVariation_694.cv_arg
    cv_name = "MI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_694

    @classmethod
    def create(cls, arg : "NonSpare_1274.cv_arg") -> "NonSpare_1274":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_694:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_705:
        return self.rule.variation

class Item_547(Item):
    cv_arg: TypeAlias = NonSpare_1274.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1274

    @classmethod
    def create(cls, arg : "Item_547.cv_arg") -> "Item_547":
        return cls._create(arg) # type: ignore

class Item_24(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 5
    cv_bit_size = 2

class Variation_1380(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_71.cv_arg, Tuple[Literal["TYP"], RuleVariation_71.cv_arg]], Union[RuleVariation_390.cv_arg, Tuple[Literal["SIM"], RuleVariation_390.cv_arg]], Union[RuleVariation_579.cv_arg, Tuple[Literal["SSRPSR"], RuleVariation_579.cv_arg]], Union[RuleVariation_740.cv_arg, Tuple[Literal["ANT"], RuleVariation_740.cv_arg]], Union[RuleVariation_805.cv_arg, Tuple[Literal["SPI"], RuleVariation_805.cv_arg]], Union[RuleVariation_884.cv_arg, Tuple[Literal["RAB"], RuleVariation_884.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_35.cv_arg, Tuple[Literal["TST"], RuleVariation_35.cv_arg]], Union[RuleVariation_454.cv_arg, Tuple[Literal["DS1DS2"], RuleVariation_454.cv_arg]], Union[RuleVariation_613.cv_arg, Tuple[Literal["ME"], RuleVariation_613.cv_arg]], Union[RuleVariation_694.cv_arg, Tuple[Literal["MI"], RuleVariation_694.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1380.cv_arg_group_1"],
        Tuple["Variation_1380.cv_arg_group_1", "Variation_1380.cv_arg_group_2"],
    ]
    cv_items_list = [[(Item_1066, 1), (Item_895, 1), (Item_927, 2), (Item_74, 1), (Item_908, 1), (Item_764, 1), None], [(Item_1045, 1), (Item_273, 2), (Item_540, 1), (Item_547, 1), (Item_24, 2), None]]

    @classmethod
    def create(cls, arg: "Variation_1380.cv_arg") -> 'Variation_1380':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["TYP"]) -> RuleVariation_71:
        ...
    @overload
    def get_item(self, key : Literal["SIM"]) -> RuleVariation_390:
        ...
    @overload
    def get_item(self, key : Literal["SSRPSR"]) -> RuleVariation_579:
        ...
    @overload
    def get_item(self, key : Literal["ANT"]) -> RuleVariation_740:
        ...
    @overload
    def get_item(self, key : Literal["SPI"]) -> RuleVariation_805:
        ...
    @overload
    def get_item(self, key : Literal["RAB"]) -> RuleVariation_884:
        ...
    @overload
    def get_item(self, key : Literal["TST"]) -> Optional[RuleVariation_35]:
        ...
    @overload
    def get_item(self, key : Literal["DS1DS2"]) -> Optional[RuleVariation_454]:
        ...
    @overload
    def get_item(self, key : Literal["ME"]) -> Optional[RuleVariation_613]:
        ...
    @overload
    def get_item(self, key : Literal["MI"]) -> Optional[RuleVariation_694]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1302(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1380.cv_arg
    cv_variation: TypeAlias = Variation_1380

    @classmethod
    def create(cls, arg : "RuleVariation_1302.cv_arg") -> "RuleVariation_1302":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1380:
        return self.arg # type: ignore

class NonSpare_86(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1302.cv_arg
    cv_name = "020"
    cv_title = "Target Report Descriptor"
    cv_rule: TypeAlias = RuleVariation_1302

    @classmethod
    def create(cls, arg : "NonSpare_86.cv_arg") -> "NonSpare_86":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1302:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1380:
        return self.rule.variation

class UapItem_86(UapItem):
    cv_non_spare: TypeAlias = NonSpare_86

class Content_765(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 7.8125e-3
    cv_unit = "NM"

    def as_quantity(self, cv_unit : Optional[Literal["NM"]] = None) -> float:
        return self._as_quantity()

class RuleContent_764(RuleContentContextFree):
    cv_arg: TypeAlias = Content_765.cv_arg
    cv_content: TypeAlias = Content_765

    @property
    def content(self) -> Content_765:
        return self._get_content() # type: ignore

class Variation_330(Element):
    cv_arg: TypeAlias = RuleContent_764.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_764

    @classmethod
    def create(cls, arg: "Variation_330.cv_arg") -> "Variation_330":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_764:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_765:
        return self.rule.content

class RuleVariation_323(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_330.cv_arg
    cv_variation: TypeAlias = Variation_330

    @classmethod
    def create(cls, arg : "RuleVariation_323.cv_arg") -> "RuleVariation_323":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_330:
        return self.arg # type: ignore

class NonSpare_1578(NonSpare):
    cv_arg: TypeAlias = RuleVariation_323.cv_arg
    cv_name = "RHO"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_323

    @classmethod
    def create(cls, arg : "NonSpare_1578.cv_arg") -> "NonSpare_1578":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_323:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_330:
        return self.rule.variation

class Item_809(Item):
    cv_arg: TypeAlias = NonSpare_1578.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1578

    @classmethod
    def create(cls, arg : "Item_809.cv_arg") -> "Item_809":
        return cls._create(arg) # type: ignore

class Content_790(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 5.4931640625e-3
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_789(RuleContentContextFree):
    cv_arg: TypeAlias = Content_790.cv_arg
    cv_content: TypeAlias = Content_790

    @property
    def content(self) -> Content_790:
        return self._get_content() # type: ignore

class Variation_341(Element):
    cv_arg: TypeAlias = RuleContent_789.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_789

    @classmethod
    def create(cls, arg: "Variation_341.cv_arg") -> "Variation_341":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_789:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_790:
        return self.rule.content

class RuleVariation_334(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_341.cv_arg
    cv_variation: TypeAlias = Variation_341

    @classmethod
    def create(cls, arg : "RuleVariation_334.cv_arg") -> "RuleVariation_334":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_341:
        return self.arg # type: ignore

class NonSpare_1844(NonSpare):
    cv_arg: TypeAlias = RuleVariation_334.cv_arg
    cv_name = "THETA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_334

    @classmethod
    def create(cls, arg : "NonSpare_1844.cv_arg") -> "NonSpare_1844":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_334:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_341:
        return self.rule.variation

class Item_988(Item):
    cv_arg: TypeAlias = NonSpare_1844.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1844

    @classmethod
    def create(cls, arg : "Item_988.cv_arg") -> "Item_988":
        return cls._create(arg) # type: ignore

class Variation_1173(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_323.cv_arg, Tuple[Literal["RHO"], RuleVariation_323.cv_arg]], Union[RuleVariation_334.cv_arg, Tuple[Literal["THETA"], RuleVariation_334.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1173.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_809, 16), (Item_988, 16)]
    cv_items_dict = {"RHO": RuleVariation_323, "THETA": RuleVariation_334}

    @overload
    @classmethod
    def spec(cls, key : Literal["RHO"]) -> RuleVariation_323:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["THETA"]) -> RuleVariation_334:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["RHO"], Literal["THETA"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["RHO"]) -> RuleVariation_323:
        ...
    @overload
    def get_item(self, key : Literal["THETA"]) -> RuleVariation_334:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1173.cv_arg") -> 'Variation_1173':
        return cls._create(arg) # type: ignore

class RuleVariation_1124(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1173.cv_arg
    cv_variation: TypeAlias = Variation_1173

    @classmethod
    def create(cls, arg : "RuleVariation_1124.cv_arg") -> "RuleVariation_1124":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1173:
        return self.arg # type: ignore

class NonSpare_136(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1124.cv_arg
    cv_name = "040"
    cv_title = "Measured Position in Polar Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1124

    @classmethod
    def create(cls, arg : "NonSpare_136.cv_arg") -> "NonSpare_136":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1124:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1173:
        return self.rule.variation

class UapItem_136(UapItem):
    cv_non_spare: TypeAlias = NonSpare_136

class Content_56(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Code validated", 1: "Code not validated"}

class RuleContent_56(RuleContentContextFree):
    cv_arg: TypeAlias = Content_56.cv_arg
    cv_content: TypeAlias = Content_56

    @property
    def content(self) -> Content_56:
        return self._get_content() # type: ignore

class Variation_15(Element):
    cv_arg: TypeAlias = RuleContent_56.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_56

    @classmethod
    def create(cls, arg: "Variation_15.cv_arg") -> "Variation_15":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_56:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_56:
        return self.rule.content

class RuleVariation_15(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_15.cv_arg
    cv_variation: TypeAlias = Variation_15

    @classmethod
    def create(cls, arg : "RuleVariation_15.cv_arg") -> "RuleVariation_15":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_15:
        return self.arg # type: ignore

class NonSpare_1979(NonSpare):
    cv_arg: TypeAlias = RuleVariation_15.cv_arg
    cv_name = "V"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_15

    @classmethod
    def create(cls, arg : "NonSpare_1979.cv_arg") -> "NonSpare_1979":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_15:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_15:
        return self.rule.variation

class Item_1097(Item):
    cv_arg: TypeAlias = NonSpare_1979.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1979

    @classmethod
    def create(cls, arg : "Item_1097.cv_arg") -> "Item_1097":
        return cls._create(arg) # type: ignore

class Content_97(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Garbled code"}

class RuleContent_97(RuleContentContextFree):
    cv_arg: TypeAlias = Content_97.cv_arg
    cv_content: TypeAlias = Content_97

    @property
    def content(self) -> Content_97:
        return self._get_content() # type: ignore

class Variation_405(Element):
    cv_arg: TypeAlias = RuleContent_97.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_97

    @classmethod
    def create(cls, arg: "Variation_405.cv_arg") -> "Variation_405":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_97:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_97:
        return self.rule.content

class RuleVariation_394(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_405.cv_arg
    cv_variation: TypeAlias = Variation_405

    @classmethod
    def create(cls, arg : "RuleVariation_394.cv_arg") -> "RuleVariation_394":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_405:
        return self.arg # type: ignore

class NonSpare_1001(NonSpare):
    cv_arg: TypeAlias = RuleVariation_394.cv_arg
    cv_name = "G"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_394

    @classmethod
    def create(cls, arg : "NonSpare_1001.cv_arg") -> "NonSpare_1001":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_394:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_405:
        return self.rule.variation

class Item_353(Item):
    cv_arg: TypeAlias = NonSpare_1001.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1001

    @classmethod
    def create(cls, arg : "Item_353.cv_arg") -> "Item_353":
        return cls._create(arg) # type: ignore

class Content_290(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Mode-3/A code derived from the reply of the transponder", 1: "Smoothed Mode-3/A code as provided by a local tracker"}

class RuleContent_290(RuleContentContextFree):
    cv_arg: TypeAlias = Content_290.cv_arg
    cv_content: TypeAlias = Content_290

    @property
    def content(self) -> Content_290:
        return self._get_content() # type: ignore

class Variation_552(Element):
    cv_arg: TypeAlias = RuleContent_290.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_290

    @classmethod
    def create(cls, arg: "Variation_552.cv_arg") -> "Variation_552":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_290:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_290:
        return self.rule.content

class RuleVariation_541(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_552.cv_arg
    cv_variation: TypeAlias = Variation_552

    @classmethod
    def create(cls, arg : "RuleVariation_541.cv_arg") -> "RuleVariation_541":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_552:
        return self.arg # type: ignore

class NonSpare_1135(NonSpare):
    cv_arg: TypeAlias = RuleVariation_541.cv_arg
    cv_name = "L"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_541

    @classmethod
    def create(cls, arg : "NonSpare_1135.cv_arg") -> "NonSpare_1135":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_541:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_552:
        return self.rule.variation

class Item_453(Item):
    cv_arg: TypeAlias = NonSpare_1135.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1135

    @classmethod
    def create(cls, arg : "Item_453.cv_arg") -> "Item_453":
        return cls._create(arg) # type: ignore

class Item_16(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 3
    cv_bit_size = 1

class Content_608(ContentString):
    cv_arg: TypeAlias = Union[int, str]
    cv_string_type: TypeAlias = StringOctal

class RuleContent_608(RuleContentContextFree):
    cv_arg: TypeAlias = Content_608.cv_arg
    cv_content: TypeAlias = Content_608

    @property
    def content(self) -> Content_608:
        return self._get_content() # type: ignore

class Variation_806(Element):
    cv_arg: TypeAlias = RuleContent_608.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 12
    cv_rule = RuleContent_608

    @classmethod
    def create(cls, arg: "Variation_806.cv_arg") -> "Variation_806":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_608:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_608:
        return self.rule.content

class RuleVariation_776(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_806.cv_arg
    cv_variation: TypeAlias = Variation_806

    @classmethod
    def create(cls, arg : "RuleVariation_776.cv_arg") -> "RuleVariation_776":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_806:
        return self.arg # type: ignore

class NonSpare_1300(NonSpare):
    cv_arg: TypeAlias = RuleVariation_776.cv_arg
    cv_name = "MODE3A"
    cv_title = "Mode-3/A Reply in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_776

    @classmethod
    def create(cls, arg : "NonSpare_1300.cv_arg") -> "NonSpare_1300":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_776:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_806:
        return self.rule.variation

class Item_572(Item):
    cv_arg: TypeAlias = NonSpare_1300.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1300

    @classmethod
    def create(cls, arg : "Item_572.cv_arg") -> "Item_572":
        return cls._create(arg) # type: ignore

class Variation_1260(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_15.cv_arg, Tuple[Literal["V"], RuleVariation_15.cv_arg]], Union[RuleVariation_394.cv_arg, Tuple[Literal["G"], RuleVariation_394.cv_arg]], Union[RuleVariation_541.cv_arg, Tuple[Literal["L"], RuleVariation_541.cv_arg]], int, Union[RuleVariation_776.cv_arg, Tuple[Literal["MODE3A"], RuleVariation_776.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1260.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_1097, 1), (Item_353, 1), (Item_453, 1), (Item_16, 1), (Item_572, 12)]
    cv_items_dict = {"V": RuleVariation_15, "G": RuleVariation_394, "L": RuleVariation_541, "MODE3A": RuleVariation_776}

    @overload
    @classmethod
    def spec(cls, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> RuleVariation_394:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["L"]) -> RuleVariation_541:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MODE3A"]) -> RuleVariation_776:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["V"], Literal["G"], Literal["L"], Literal["MODE3A"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> RuleVariation_394:
        ...
    @overload
    def get_item(self, key : Literal["L"]) -> RuleVariation_541:
        ...
    @overload
    def get_item(self, key : Literal["MODE3A"]) -> RuleVariation_776:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1260.cv_arg") -> 'Variation_1260':
        return cls._create(arg) # type: ignore

class RuleVariation_1189(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1260.cv_arg
    cv_variation: TypeAlias = Variation_1260

    @classmethod
    def create(cls, arg : "RuleVariation_1189.cv_arg") -> "RuleVariation_1189":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1260:
        return self.arg # type: ignore

class NonSpare_209(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1189.cv_arg
    cv_name = "070"
    cv_title = "Mode-3/A Code in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_1189

    @classmethod
    def create(cls, arg : "NonSpare_209.cv_arg") -> "NonSpare_209":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1189:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1260:
        return self.rule.variation

class UapItem_209(UapItem):
    cv_non_spare: TypeAlias = NonSpare_209

class Content_650(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["FL"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.25
    cv_unit = "FL"

    def as_quantity(self, cv_unit : Optional[Literal["FL"]] = None) -> float:
        return self._as_quantity()

class RuleContent_650(RuleContentContextFree):
    cv_arg: TypeAlias = Content_650.cv_arg
    cv_content: TypeAlias = Content_650

    @property
    def content(self) -> Content_650:
        return self._get_content() # type: ignore

class Variation_606(Element):
    cv_arg: TypeAlias = RuleContent_650.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 14
    cv_rule = RuleContent_650

    @classmethod
    def create(cls, arg: "Variation_606.cv_arg") -> "Variation_606":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_650:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_650:
        return self.rule.content

class RuleVariation_595(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_606.cv_arg
    cv_variation: TypeAlias = Variation_606

    @classmethod
    def create(cls, arg : "RuleVariation_595.cv_arg") -> "RuleVariation_595":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_606:
        return self.arg # type: ignore

class NonSpare_1061(NonSpare):
    cv_arg: TypeAlias = RuleVariation_595.cv_arg
    cv_name = "HGT"
    cv_title = "Mode-C HEIGHT"
    cv_rule: TypeAlias = RuleVariation_595

    @classmethod
    def create(cls, arg : "NonSpare_1061.cv_arg") -> "NonSpare_1061":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_595:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_606:
        return self.rule.variation

class Item_393(Item):
    cv_arg: TypeAlias = NonSpare_1061.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1061

    @classmethod
    def create(cls, arg : "Item_393.cv_arg") -> "Item_393":
        return cls._create(arg) # type: ignore

class Variation_1252(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_15.cv_arg, Tuple[Literal["V"], RuleVariation_15.cv_arg]], Union[RuleVariation_394.cv_arg, Tuple[Literal["G"], RuleVariation_394.cv_arg]], Union[RuleVariation_595.cv_arg, Tuple[Literal["HGT"], RuleVariation_595.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1252.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_1097, 1), (Item_353, 1), (Item_393, 14)]
    cv_items_dict = {"V": RuleVariation_15, "G": RuleVariation_394, "HGT": RuleVariation_595}

    @overload
    @classmethod
    def spec(cls, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> RuleVariation_394:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["HGT"]) -> RuleVariation_595:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["V"], Literal["G"], Literal["HGT"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> RuleVariation_394:
        ...
    @overload
    def get_item(self, key : Literal["HGT"]) -> RuleVariation_595:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1252.cv_arg") -> 'Variation_1252':
        return cls._create(arg) # type: ignore

class RuleVariation_1181(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1252.cv_arg
    cv_variation: TypeAlias = Variation_1252

    @classmethod
    def create(cls, arg : "RuleVariation_1181.cv_arg") -> "RuleVariation_1181":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1252:
        return self.arg # type: ignore

class NonSpare_249(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1181.cv_arg
    cv_name = "090"
    cv_title = "Mode-C Code in Binary Representation"
    cv_rule: TypeAlias = RuleVariation_1181

    @classmethod
    def create(cls, arg : "NonSpare_249.cv_arg") -> "NonSpare_249":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1181:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1252:
        return self.rule.variation

class UapItem_249(UapItem):
    cv_non_spare: TypeAlias = NonSpare_249

class Variation_149(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 7
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_149.cv_arg") -> "Variation_149":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class Variation_1446(Repetitive):
    cv_arg: TypeAlias = List[Variation_149.cv_arg]
    cv_rep_bytes = None
    cv_variation: TypeAlias = Variation_149

    @classmethod
    def create(cls, arg: "Variation_1446.cv_arg") -> 'Variation_1446':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_149]:
        return self._get_list() # type: ignore

class RuleVariation_1368(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1446.cv_arg
    cv_variation: TypeAlias = Variation_1446

    @classmethod
    def create(cls, arg : "RuleVariation_1368.cv_arg") -> "RuleVariation_1368":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1446:
        return self.arg # type: ignore

class NonSpare_307(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1368.cv_arg
    cv_name = "130"
    cv_title = "Radar Plot Characteristics"
    cv_rule: TypeAlias = RuleVariation_1368

    @classmethod
    def create(cls, arg : "NonSpare_307.cv_arg") -> "NonSpare_307":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1368:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1446:
        return self.rule.variation

class UapItem_307(UapItem):
    cv_non_spare: TypeAlias = NonSpare_307

class Content_767(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["s"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 7.8125e-3
    cv_unit = "s"

    def as_quantity(self, cv_unit : Optional[Literal["s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_766(RuleContentContextFree):
    cv_arg: TypeAlias = Content_767.cv_arg
    cv_content: TypeAlias = Content_767

    @property
    def content(self) -> Content_767:
        return self._get_content() # type: ignore

class Variation_332(Element):
    cv_arg: TypeAlias = RuleContent_766.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_766

    @classmethod
    def create(cls, arg: "Variation_332.cv_arg") -> "Variation_332":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_766:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_767:
        return self.rule.content

class RuleVariation_325(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_332.cv_arg
    cv_variation: TypeAlias = Variation_332

    @classmethod
    def create(cls, arg : "RuleVariation_325.cv_arg") -> "RuleVariation_325":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_332:
        return self.arg # type: ignore

class NonSpare_332(NonSpare):
    cv_arg: TypeAlias = RuleVariation_325.cv_arg
    cv_name = "141"
    cv_title = "Truncated Time of Day"
    cv_rule: TypeAlias = RuleVariation_325

    @classmethod
    def create(cls, arg : "NonSpare_332.cv_arg") -> "NonSpare_332":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_325:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_332:
        return self.rule.variation

class UapItem_332(UapItem):
    cv_non_spare: TypeAlias = NonSpare_332

class Content_284(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Mode-2 code as derived from the reply of the transponder", 1: "Smoothed Mode-2 code as provided by a local tracker"}

class RuleContent_284(RuleContentContextFree):
    cv_arg: TypeAlias = Content_284.cv_arg
    cv_content: TypeAlias = Content_284

    @property
    def content(self) -> Content_284:
        return self._get_content() # type: ignore

class Variation_546(Element):
    cv_arg: TypeAlias = RuleContent_284.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_284

    @classmethod
    def create(cls, arg: "Variation_546.cv_arg") -> "Variation_546":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_284:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_284:
        return self.rule.content

class RuleVariation_535(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_546.cv_arg
    cv_variation: TypeAlias = Variation_546

    @classmethod
    def create(cls, arg : "RuleVariation_535.cv_arg") -> "RuleVariation_535":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_546:
        return self.arg # type: ignore

class NonSpare_1129(NonSpare):
    cv_arg: TypeAlias = RuleVariation_535.cv_arg
    cv_name = "L"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_535

    @classmethod
    def create(cls, arg : "NonSpare_1129.cv_arg") -> "NonSpare_1129":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_535:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_546:
        return self.rule.variation

class Item_447(Item):
    cv_arg: TypeAlias = NonSpare_1129.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1129

    @classmethod
    def create(cls, arg : "Item_447.cv_arg") -> "Item_447":
        return cls._create(arg) # type: ignore

class NonSpare_1294(NonSpare):
    cv_arg: TypeAlias = RuleVariation_776.cv_arg
    cv_name = "MODE2"
    cv_title = "Mode-2 Code in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_776

    @classmethod
    def create(cls, arg : "NonSpare_1294.cv_arg") -> "NonSpare_1294":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_776:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_806:
        return self.rule.variation

class Item_566(Item):
    cv_arg: TypeAlias = NonSpare_1294.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1294

    @classmethod
    def create(cls, arg : "Item_566.cv_arg") -> "Item_566":
        return cls._create(arg) # type: ignore

class Variation_1255(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_15.cv_arg, Tuple[Literal["V"], RuleVariation_15.cv_arg]], Union[RuleVariation_394.cv_arg, Tuple[Literal["G"], RuleVariation_394.cv_arg]], Union[RuleVariation_535.cv_arg, Tuple[Literal["L"], RuleVariation_535.cv_arg]], int, Union[RuleVariation_776.cv_arg, Tuple[Literal["MODE2"], RuleVariation_776.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1255.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_1097, 1), (Item_353, 1), (Item_447, 1), (Item_16, 1), (Item_566, 12)]
    cv_items_dict = {"V": RuleVariation_15, "G": RuleVariation_394, "L": RuleVariation_535, "MODE2": RuleVariation_776}

    @overload
    @classmethod
    def spec(cls, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> RuleVariation_394:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["L"]) -> RuleVariation_535:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MODE2"]) -> RuleVariation_776:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["V"], Literal["G"], Literal["L"], Literal["MODE2"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> RuleVariation_394:
        ...
    @overload
    def get_item(self, key : Literal["L"]) -> RuleVariation_535:
        ...
    @overload
    def get_item(self, key : Literal["MODE2"]) -> RuleVariation_776:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1255.cv_arg") -> 'Variation_1255':
        return cls._create(arg) # type: ignore

class RuleVariation_1184(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1255.cv_arg
    cv_variation: TypeAlias = Variation_1255

    @classmethod
    def create(cls, arg : "RuleVariation_1184.cv_arg") -> "RuleVariation_1184":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1255:
        return self.arg # type: ignore

class NonSpare_171(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1184.cv_arg
    cv_name = "050"
    cv_title = "Mode-2 Code in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_1184

    @classmethod
    def create(cls, arg : "NonSpare_171.cv_arg") -> "NonSpare_171":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1184:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1255:
        return self.rule.variation

class UapItem_171(UapItem):
    cv_non_spare: TypeAlias = NonSpare_171

class Content_678(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM/s"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 3.90625e-3
    cv_unit = "NM/s"

    def as_quantity(self, cv_unit : Optional[Literal["NM/s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_678(RuleContentContextFree):
    cv_arg: TypeAlias = Content_678.cv_arg
    cv_content: TypeAlias = Content_678

    @property
    def content(self) -> Content_678:
        return self._get_content() # type: ignore

class Variation_216(Element):
    cv_arg: TypeAlias = RuleContent_678.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_678

    @classmethod
    def create(cls, arg: "Variation_216.cv_arg") -> "Variation_216":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_678:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_678:
        return self.rule.content

class RuleVariation_209(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_216.cv_arg
    cv_variation: TypeAlias = Variation_216

    @classmethod
    def create(cls, arg : "RuleVariation_209.cv_arg") -> "RuleVariation_209":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_216:
        return self.arg # type: ignore

class NonSpare_295(NonSpare):
    cv_arg: TypeAlias = RuleVariation_209.cv_arg
    cv_name = "120"
    cv_title = "Measured Radial Doppler Speed"
    cv_rule: TypeAlias = RuleVariation_209

    @classmethod
    def create(cls, arg : "NonSpare_295.cv_arg") -> "NonSpare_295":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_209:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_216:
        return self.rule.variation

class UapItem_295(UapItem):
    cv_non_spare: TypeAlias = NonSpare_295

class Content_622(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["dBm"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 1.0
    cv_unit = "dBm"

    def as_quantity(self, cv_unit : Optional[Literal["dBm"]] = None) -> float:
        return self._as_quantity()

class RuleContent_622(RuleContentContextFree):
    cv_arg: TypeAlias = Content_622.cv_arg
    cv_content: TypeAlias = Content_622

    @property
    def content(self) -> Content_622:
        return self._get_content() # type: ignore

class Variation_206(Element):
    cv_arg: TypeAlias = RuleContent_622.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_622

    @classmethod
    def create(cls, arg: "Variation_206.cv_arg") -> "Variation_206":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_622:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_622:
        return self.rule.content

class RuleVariation_199(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_206.cv_arg
    cv_variation: TypeAlias = Variation_206

    @classmethod
    def create(cls, arg : "RuleVariation_199.cv_arg") -> "RuleVariation_199":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_206:
        return self.arg # type: ignore

class NonSpare_311(NonSpare):
    cv_arg: TypeAlias = RuleVariation_199.cv_arg
    cv_name = "131"
    cv_title = "Received Power"
    cv_rule: TypeAlias = RuleVariation_199

    @classmethod
    def create(cls, arg : "NonSpare_311.cv_arg") -> "NonSpare_311":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_199:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_206:
        return self.rule.variation

class UapItem_311(UapItem):
    cv_non_spare: TypeAlias = NonSpare_311

class Item_3(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 0
    cv_bit_size = 4

class Content_226(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse A4", 1: "Low quality pulse A4"}

class RuleContent_226(RuleContentContextFree):
    cv_arg: TypeAlias = Content_226.cv_arg
    cv_content: TypeAlias = Content_226

    @property
    def content(self) -> Content_226:
        return self._get_content() # type: ignore

class Variation_723(Element):
    cv_arg: TypeAlias = RuleContent_226.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_226

    @classmethod
    def create(cls, arg: "Variation_723.cv_arg") -> "Variation_723":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_226:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_226:
        return self.rule.content

class RuleVariation_712(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_723.cv_arg
    cv_variation: TypeAlias = Variation_723

    @classmethod
    def create(cls, arg : "RuleVariation_712.cv_arg") -> "RuleVariation_712":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_723:
        return self.arg # type: ignore

class NonSpare_1486(NonSpare):
    cv_arg: TypeAlias = RuleVariation_712.cv_arg
    cv_name = "QA4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_712

    @classmethod
    def create(cls, arg : "NonSpare_1486.cv_arg") -> "NonSpare_1486":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_712:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_723:
        return self.rule.variation

class Item_725(Item):
    cv_arg: TypeAlias = NonSpare_1486.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1486

    @classmethod
    def create(cls, arg : "Item_725.cv_arg") -> "Item_725":
        return cls._create(arg) # type: ignore

class Content_225(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse A2", 1: "Low quality pulse A2"}

class RuleContent_225(RuleContentContextFree):
    cv_arg: TypeAlias = Content_225.cv_arg
    cv_content: TypeAlias = Content_225

    @property
    def content(self) -> Content_225:
        return self._get_content() # type: ignore

class Variation_850(Element):
    cv_arg: TypeAlias = RuleContent_225.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_225

    @classmethod
    def create(cls, arg: "Variation_850.cv_arg") -> "Variation_850":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_225:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_225:
        return self.rule.content

class RuleVariation_820(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_850.cv_arg
    cv_variation: TypeAlias = Variation_850

    @classmethod
    def create(cls, arg : "RuleVariation_820.cv_arg") -> "RuleVariation_820":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_850:
        return self.arg # type: ignore

class NonSpare_1481(NonSpare):
    cv_arg: TypeAlias = RuleVariation_820.cv_arg
    cv_name = "QA2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_820

    @classmethod
    def create(cls, arg : "NonSpare_1481.cv_arg") -> "NonSpare_1481":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_820:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_850:
        return self.rule.variation

class Item_720(Item):
    cv_arg: TypeAlias = NonSpare_1481.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1481

    @classmethod
    def create(cls, arg : "Item_720.cv_arg") -> "Item_720":
        return cls._create(arg) # type: ignore

class Content_224(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse A1", 1: "Low quality pulse A1"}

class RuleContent_224(RuleContentContextFree):
    cv_arg: TypeAlias = Content_224.cv_arg
    cv_content: TypeAlias = Content_224

    @property
    def content(self) -> Content_224:
        return self._get_content() # type: ignore

class Variation_926(Element):
    cv_arg: TypeAlias = RuleContent_224.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_224

    @classmethod
    def create(cls, arg: "Variation_926.cv_arg") -> "Variation_926":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_224:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_224:
        return self.rule.content

class RuleVariation_896(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_926.cv_arg
    cv_variation: TypeAlias = Variation_926

    @classmethod
    def create(cls, arg : "RuleVariation_896.cv_arg") -> "RuleVariation_896":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_926:
        return self.arg # type: ignore

class NonSpare_1478(NonSpare):
    cv_arg: TypeAlias = RuleVariation_896.cv_arg
    cv_name = "QA1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_896

    @classmethod
    def create(cls, arg : "NonSpare_1478.cv_arg") -> "NonSpare_1478":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_896:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_926:
        return self.rule.variation

class Item_717(Item):
    cv_arg: TypeAlias = NonSpare_1478.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1478

    @classmethod
    def create(cls, arg : "Item_717.cv_arg") -> "Item_717":
        return cls._create(arg) # type: ignore

class Content_229(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse B4", 1: "Low quality pulse B4"}

class RuleContent_229(RuleContentContextFree):
    cv_arg: TypeAlias = Content_229.cv_arg
    cv_content: TypeAlias = Content_229

    @property
    def content(self) -> Content_229:
        return self._get_content() # type: ignore

class Variation_975(Element):
    cv_arg: TypeAlias = RuleContent_229.cv_arg
    cv_bit_offset8 = 7
    cv_bit_size = 1
    cv_rule = RuleContent_229

    @classmethod
    def create(cls, arg: "Variation_975.cv_arg") -> "Variation_975":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_229:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_229:
        return self.rule.content

class RuleVariation_945(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_975.cv_arg
    cv_variation: TypeAlias = Variation_975

    @classmethod
    def create(cls, arg : "RuleVariation_945.cv_arg") -> "RuleVariation_945":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_975:
        return self.arg # type: ignore

class NonSpare_1497(NonSpare):
    cv_arg: TypeAlias = RuleVariation_945.cv_arg
    cv_name = "QB4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_945

    @classmethod
    def create(cls, arg : "NonSpare_1497.cv_arg") -> "NonSpare_1497":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_945:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_975:
        return self.rule.variation

class Item_736(Item):
    cv_arg: TypeAlias = NonSpare_1497.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1497

    @classmethod
    def create(cls, arg : "Item_736.cv_arg") -> "Item_736":
        return cls._create(arg) # type: ignore

class Content_228(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse B2", 1: "Low quality pulse B2"}

class RuleContent_228(RuleContentContextFree):
    cv_arg: TypeAlias = Content_228.cv_arg
    cv_content: TypeAlias = Content_228

    @property
    def content(self) -> Content_228:
        return self._get_content() # type: ignore

class Variation_45(Element):
    cv_arg: TypeAlias = RuleContent_228.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_228

    @classmethod
    def create(cls, arg: "Variation_45.cv_arg") -> "Variation_45":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_228:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_228:
        return self.rule.content

class RuleVariation_45(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_45.cv_arg
    cv_variation: TypeAlias = Variation_45

    @classmethod
    def create(cls, arg : "RuleVariation_45.cv_arg") -> "RuleVariation_45":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_45:
        return self.arg # type: ignore

class NonSpare_1492(NonSpare):
    cv_arg: TypeAlias = RuleVariation_45.cv_arg
    cv_name = "QB2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_45

    @classmethod
    def create(cls, arg : "NonSpare_1492.cv_arg") -> "NonSpare_1492":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_45:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_45:
        return self.rule.variation

class Item_731(Item):
    cv_arg: TypeAlias = NonSpare_1492.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1492

    @classmethod
    def create(cls, arg : "Item_731.cv_arg") -> "Item_731":
        return cls._create(arg) # type: ignore

class Content_227(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse B1", 1: "Low quality pulse B1"}

class RuleContent_227(RuleContentContextFree):
    cv_arg: TypeAlias = Content_227.cv_arg
    cv_content: TypeAlias = Content_227

    @property
    def content(self) -> Content_227:
        return self._get_content() # type: ignore

class Variation_430(Element):
    cv_arg: TypeAlias = RuleContent_227.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_227

    @classmethod
    def create(cls, arg: "Variation_430.cv_arg") -> "Variation_430":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_227:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_227:
        return self.rule.content

class RuleVariation_419(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_430.cv_arg
    cv_variation: TypeAlias = Variation_430

    @classmethod
    def create(cls, arg : "RuleVariation_419.cv_arg") -> "RuleVariation_419":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_430:
        return self.arg # type: ignore

class NonSpare_1488(NonSpare):
    cv_arg: TypeAlias = RuleVariation_419.cv_arg
    cv_name = "QB1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_419

    @classmethod
    def create(cls, arg : "NonSpare_1488.cv_arg") -> "NonSpare_1488":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_419:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_430:
        return self.rule.variation

class Item_727(Item):
    cv_arg: TypeAlias = NonSpare_1488.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1488

    @classmethod
    def create(cls, arg : "Item_727.cv_arg") -> "Item_727":
        return cls._create(arg) # type: ignore

class Content_232(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse C4", 1: "Low quality pulse C4"}

class RuleContent_232(RuleContentContextFree):
    cv_arg: TypeAlias = Content_232.cv_arg
    cv_content: TypeAlias = Content_232

    @property
    def content(self) -> Content_232:
        return self._get_content() # type: ignore

class Variation_535(Element):
    cv_arg: TypeAlias = RuleContent_232.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_232

    @classmethod
    def create(cls, arg: "Variation_535.cv_arg") -> "Variation_535":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_232:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_232:
        return self.rule.content

class RuleVariation_524(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_535.cv_arg
    cv_variation: TypeAlias = Variation_535

    @classmethod
    def create(cls, arg : "RuleVariation_524.cv_arg") -> "RuleVariation_524":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_535:
        return self.arg # type: ignore

class NonSpare_1505(NonSpare):
    cv_arg: TypeAlias = RuleVariation_524.cv_arg
    cv_name = "QC4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_524

    @classmethod
    def create(cls, arg : "NonSpare_1505.cv_arg") -> "NonSpare_1505":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_524:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_535:
        return self.rule.variation

class Item_744(Item):
    cv_arg: TypeAlias = NonSpare_1505.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1505

    @classmethod
    def create(cls, arg : "Item_744.cv_arg") -> "Item_744":
        return cls._create(arg) # type: ignore

class Content_231(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse C2", 1: "Low quality pulse C2"}

class RuleContent_231(RuleContentContextFree):
    cv_arg: TypeAlias = Content_231.cv_arg
    cv_content: TypeAlias = Content_231

    @property
    def content(self) -> Content_231:
        return self._get_content() # type: ignore

class Variation_639(Element):
    cv_arg: TypeAlias = RuleContent_231.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_231

    @classmethod
    def create(cls, arg: "Variation_639.cv_arg") -> "Variation_639":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_231:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_231:
        return self.rule.content

class RuleVariation_628(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_639.cv_arg
    cv_variation: TypeAlias = Variation_639

    @classmethod
    def create(cls, arg : "RuleVariation_628.cv_arg") -> "RuleVariation_628":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_639:
        return self.arg # type: ignore

class NonSpare_1501(NonSpare):
    cv_arg: TypeAlias = RuleVariation_628.cv_arg
    cv_name = "QC2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_628

    @classmethod
    def create(cls, arg : "NonSpare_1501.cv_arg") -> "NonSpare_1501":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_628:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_639:
        return self.rule.variation

class Item_740(Item):
    cv_arg: TypeAlias = NonSpare_1501.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1501

    @classmethod
    def create(cls, arg : "Item_740.cv_arg") -> "Item_740":
        return cls._create(arg) # type: ignore

class Content_230(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse C1", 1: "Low quality pulse C1"}

class RuleContent_230(RuleContentContextFree):
    cv_arg: TypeAlias = Content_230.cv_arg
    cv_content: TypeAlias = Content_230

    @property
    def content(self) -> Content_230:
        return self._get_content() # type: ignore

class Variation_725(Element):
    cv_arg: TypeAlias = RuleContent_230.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_230

    @classmethod
    def create(cls, arg: "Variation_725.cv_arg") -> "Variation_725":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_230:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_230:
        return self.rule.content

class RuleVariation_714(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_725.cv_arg
    cv_variation: TypeAlias = Variation_725

    @classmethod
    def create(cls, arg : "RuleVariation_714.cv_arg") -> "RuleVariation_714":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_725:
        return self.arg # type: ignore

class NonSpare_1499(NonSpare):
    cv_arg: TypeAlias = RuleVariation_714.cv_arg
    cv_name = "QC1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_714

    @classmethod
    def create(cls, arg : "NonSpare_1499.cv_arg") -> "NonSpare_1499":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_714:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_725:
        return self.rule.variation

class Item_738(Item):
    cv_arg: TypeAlias = NonSpare_1499.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1499

    @classmethod
    def create(cls, arg : "Item_738.cv_arg") -> "Item_738":
        return cls._create(arg) # type: ignore

class Content_235(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse D4", 1: "Low quality pulse D4"}

class RuleContent_235(RuleContentContextFree):
    cv_arg: TypeAlias = Content_235.cv_arg
    cv_content: TypeAlias = Content_235

    @property
    def content(self) -> Content_235:
        return self._get_content() # type: ignore

class Variation_853(Element):
    cv_arg: TypeAlias = RuleContent_235.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_235

    @classmethod
    def create(cls, arg: "Variation_853.cv_arg") -> "Variation_853":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_235:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_235:
        return self.rule.content

class RuleVariation_823(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_853.cv_arg
    cv_variation: TypeAlias = Variation_853

    @classmethod
    def create(cls, arg : "RuleVariation_823.cv_arg") -> "RuleVariation_823":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_853:
        return self.arg # type: ignore

class NonSpare_1513(NonSpare):
    cv_arg: TypeAlias = RuleVariation_823.cv_arg
    cv_name = "QD4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_823

    @classmethod
    def create(cls, arg : "NonSpare_1513.cv_arg") -> "NonSpare_1513":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_823:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_853:
        return self.rule.variation

class Item_752(Item):
    cv_arg: TypeAlias = NonSpare_1513.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1513

    @classmethod
    def create(cls, arg : "Item_752.cv_arg") -> "Item_752":
        return cls._create(arg) # type: ignore

class Content_234(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse D2", 1: "Low quality pulse D2"}

class RuleContent_234(RuleContentContextFree):
    cv_arg: TypeAlias = Content_234.cv_arg
    cv_content: TypeAlias = Content_234

    @property
    def content(self) -> Content_234:
        return self._get_content() # type: ignore

class Variation_930(Element):
    cv_arg: TypeAlias = RuleContent_234.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_234

    @classmethod
    def create(cls, arg: "Variation_930.cv_arg") -> "Variation_930":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_234:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_234:
        return self.rule.content

class RuleVariation_900(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_930.cv_arg
    cv_variation: TypeAlias = Variation_930

    @classmethod
    def create(cls, arg : "RuleVariation_900.cv_arg") -> "RuleVariation_900":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_930:
        return self.arg # type: ignore

class NonSpare_1511(NonSpare):
    cv_arg: TypeAlias = RuleVariation_900.cv_arg
    cv_name = "QD2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_900

    @classmethod
    def create(cls, arg : "NonSpare_1511.cv_arg") -> "NonSpare_1511":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_900:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_930:
        return self.rule.variation

class Item_750(Item):
    cv_arg: TypeAlias = NonSpare_1511.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1511

    @classmethod
    def create(cls, arg : "Item_750.cv_arg") -> "Item_750":
        return cls._create(arg) # type: ignore

class Content_233(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse D1", 1: "Low quality pulse D1"}

class RuleContent_233(RuleContentContextFree):
    cv_arg: TypeAlias = Content_233.cv_arg
    cv_content: TypeAlias = Content_233

    @property
    def content(self) -> Content_233:
        return self._get_content() # type: ignore

class Variation_976(Element):
    cv_arg: TypeAlias = RuleContent_233.cv_arg
    cv_bit_offset8 = 7
    cv_bit_size = 1
    cv_rule = RuleContent_233

    @classmethod
    def create(cls, arg: "Variation_976.cv_arg") -> "Variation_976":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_233:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_233:
        return self.rule.content

class RuleVariation_946(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_976.cv_arg
    cv_variation: TypeAlias = Variation_976

    @classmethod
    def create(cls, arg : "RuleVariation_946.cv_arg") -> "RuleVariation_946":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_976:
        return self.arg # type: ignore

class NonSpare_1508(NonSpare):
    cv_arg: TypeAlias = RuleVariation_946.cv_arg
    cv_name = "QD1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_946

    @classmethod
    def create(cls, arg : "NonSpare_1508.cv_arg") -> "NonSpare_1508":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_946:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_976:
        return self.rule.variation

class Item_747(Item):
    cv_arg: TypeAlias = NonSpare_1508.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1508

    @classmethod
    def create(cls, arg : "Item_747.cv_arg") -> "Item_747":
        return cls._create(arg) # type: ignore

class Variation_1029(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_712.cv_arg, Tuple[Literal["QA4"], RuleVariation_712.cv_arg]], Union[RuleVariation_820.cv_arg, Tuple[Literal["QA2"], RuleVariation_820.cv_arg]], Union[RuleVariation_896.cv_arg, Tuple[Literal["QA1"], RuleVariation_896.cv_arg]], Union[RuleVariation_945.cv_arg, Tuple[Literal["QB4"], RuleVariation_945.cv_arg]], Union[RuleVariation_45.cv_arg, Tuple[Literal["QB2"], RuleVariation_45.cv_arg]], Union[RuleVariation_419.cv_arg, Tuple[Literal["QB1"], RuleVariation_419.cv_arg]], Union[RuleVariation_524.cv_arg, Tuple[Literal["QC4"], RuleVariation_524.cv_arg]], Union[RuleVariation_628.cv_arg, Tuple[Literal["QC2"], RuleVariation_628.cv_arg]], Union[RuleVariation_714.cv_arg, Tuple[Literal["QC1"], RuleVariation_714.cv_arg]], Union[RuleVariation_823.cv_arg, Tuple[Literal["QD4"], RuleVariation_823.cv_arg]], Union[RuleVariation_900.cv_arg, Tuple[Literal["QD2"], RuleVariation_900.cv_arg]], Union[RuleVariation_946.cv_arg, Tuple[Literal["QD1"], RuleVariation_946.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1029.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_3, 4), (Item_725, 1), (Item_720, 1), (Item_717, 1), (Item_736, 1), (Item_731, 1), (Item_727, 1), (Item_744, 1), (Item_740, 1), (Item_738, 1), (Item_752, 1), (Item_750, 1), (Item_747, 1)]
    cv_items_dict = {"QA4": RuleVariation_712, "QA2": RuleVariation_820, "QA1": RuleVariation_896, "QB4": RuleVariation_945, "QB2": RuleVariation_45, "QB1": RuleVariation_419, "QC4": RuleVariation_524, "QC2": RuleVariation_628, "QC1": RuleVariation_714, "QD4": RuleVariation_823, "QD2": RuleVariation_900, "QD1": RuleVariation_946}

    @overload
    @classmethod
    def spec(cls, key : Literal["QA4"]) -> RuleVariation_712:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QA2"]) -> RuleVariation_820:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QA1"]) -> RuleVariation_896:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QB4"]) -> RuleVariation_945:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QB2"]) -> RuleVariation_45:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QB1"]) -> RuleVariation_419:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QC4"]) -> RuleVariation_524:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QC2"]) -> RuleVariation_628:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QC1"]) -> RuleVariation_714:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QD4"]) -> RuleVariation_823:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QD2"]) -> RuleVariation_900:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QD1"]) -> RuleVariation_946:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["QA4"], Literal["QA2"], Literal["QA1"], Literal["QB4"], Literal["QB2"], Literal["QB1"], Literal["QC4"], Literal["QC2"], Literal["QC1"], Literal["QD4"], Literal["QD2"], Literal["QD1"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["QA4"]) -> RuleVariation_712:
        ...
    @overload
    def get_item(self, key : Literal["QA2"]) -> RuleVariation_820:
        ...
    @overload
    def get_item(self, key : Literal["QA1"]) -> RuleVariation_896:
        ...
    @overload
    def get_item(self, key : Literal["QB4"]) -> RuleVariation_945:
        ...
    @overload
    def get_item(self, key : Literal["QB2"]) -> RuleVariation_45:
        ...
    @overload
    def get_item(self, key : Literal["QB1"]) -> RuleVariation_419:
        ...
    @overload
    def get_item(self, key : Literal["QC4"]) -> RuleVariation_524:
        ...
    @overload
    def get_item(self, key : Literal["QC2"]) -> RuleVariation_628:
        ...
    @overload
    def get_item(self, key : Literal["QC1"]) -> RuleVariation_714:
        ...
    @overload
    def get_item(self, key : Literal["QD4"]) -> RuleVariation_823:
        ...
    @overload
    def get_item(self, key : Literal["QD2"]) -> RuleVariation_900:
        ...
    @overload
    def get_item(self, key : Literal["QD1"]) -> RuleVariation_946:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1029.cv_arg") -> 'Variation_1029':
        return cls._create(arg) # type: ignore

class RuleVariation_997(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1029.cv_arg
    cv_variation: TypeAlias = Variation_1029

    @classmethod
    def create(cls, arg : "RuleVariation_997.cv_arg") -> "RuleVariation_997":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1029:
        return self.arg # type: ignore

class NonSpare_229(NonSpare):
    cv_arg: TypeAlias = RuleVariation_997.cv_arg
    cv_name = "080"
    cv_title = "Mode-3/A Code Confidence Indicator"
    cv_rule: TypeAlias = RuleVariation_997

    @classmethod
    def create(cls, arg : "NonSpare_229.cv_arg") -> "NonSpare_229":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_997:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1029:
        return self.rule.variation

class UapItem_229(UapItem):
    cv_non_spare: TypeAlias = NonSpare_229

class Item_12(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 2
    cv_bit_size = 2

class Variation_805(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 12
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_805.cv_arg") -> "Variation_805":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_775(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_805.cv_arg
    cv_variation: TypeAlias = Variation_805

    @classmethod
    def create(cls, arg : "RuleVariation_775.cv_arg") -> "RuleVariation_775":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_805:
        return self.arg # type: ignore

class NonSpare_1301(NonSpare):
    cv_arg: TypeAlias = RuleVariation_775.cv_arg
    cv_name = "MODEC"
    cv_title = "Mode-C Reply in Gray Notation"
    cv_rule: TypeAlias = RuleVariation_775

    @classmethod
    def create(cls, arg : "NonSpare_1301.cv_arg") -> "NonSpare_1301":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_775:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_805:
        return self.rule.variation

class Item_573(Item):
    cv_arg: TypeAlias = NonSpare_1301.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1301

    @classmethod
    def create(cls, arg : "Item_573.cv_arg") -> "Item_573":
        return cls._create(arg) # type: ignore

class Variation_849(Element):
    cv_arg: TypeAlias = RuleContent_224.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_224

    @classmethod
    def create(cls, arg: "Variation_849.cv_arg") -> "Variation_849":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_224:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_224:
        return self.rule.content

class RuleVariation_819(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_849.cv_arg
    cv_variation: TypeAlias = Variation_849

    @classmethod
    def create(cls, arg : "RuleVariation_819.cv_arg") -> "RuleVariation_819":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_849:
        return self.arg # type: ignore

class NonSpare_1477(NonSpare):
    cv_arg: TypeAlias = RuleVariation_819.cv_arg
    cv_name = "QA1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_819

    @classmethod
    def create(cls, arg : "NonSpare_1477.cv_arg") -> "NonSpare_1477":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_819:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_849:
        return self.rule.variation

class Item_716(Item):
    cv_arg: TypeAlias = NonSpare_1477.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1477

    @classmethod
    def create(cls, arg : "Item_716.cv_arg") -> "Item_716":
        return cls._create(arg) # type: ignore

class Variation_929(Element):
    cv_arg: TypeAlias = RuleContent_231.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_231

    @classmethod
    def create(cls, arg: "Variation_929.cv_arg") -> "Variation_929":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_231:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_231:
        return self.rule.content

class RuleVariation_899(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_929.cv_arg
    cv_variation: TypeAlias = Variation_929

    @classmethod
    def create(cls, arg : "RuleVariation_899.cv_arg") -> "RuleVariation_899":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_929:
        return self.arg # type: ignore

class NonSpare_1502(NonSpare):
    cv_arg: TypeAlias = RuleVariation_899.cv_arg
    cv_name = "QC2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_899

    @classmethod
    def create(cls, arg : "NonSpare_1502.cv_arg") -> "NonSpare_1502":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_899:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_929:
        return self.rule.variation

class Item_741(Item):
    cv_arg: TypeAlias = NonSpare_1502.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1502

    @classmethod
    def create(cls, arg : "Item_741.cv_arg") -> "Item_741":
        return cls._create(arg) # type: ignore

class Variation_973(Element):
    cv_arg: TypeAlias = RuleContent_225.cv_arg
    cv_bit_offset8 = 7
    cv_bit_size = 1
    cv_rule = RuleContent_225

    @classmethod
    def create(cls, arg: "Variation_973.cv_arg") -> "Variation_973":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_225:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_225:
        return self.rule.content

class RuleVariation_943(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_973.cv_arg
    cv_variation: TypeAlias = Variation_973

    @classmethod
    def create(cls, arg : "RuleVariation_943.cv_arg") -> "RuleVariation_943":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_973:
        return self.arg # type: ignore

class NonSpare_1482(NonSpare):
    cv_arg: TypeAlias = RuleVariation_943.cv_arg
    cv_name = "QA2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_943

    @classmethod
    def create(cls, arg : "NonSpare_1482.cv_arg") -> "NonSpare_1482":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_943:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_973:
        return self.rule.variation

class Item_721(Item):
    cv_arg: TypeAlias = NonSpare_1482.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1482

    @classmethod
    def create(cls, arg : "Item_721.cv_arg") -> "Item_721":
        return cls._create(arg) # type: ignore

class Variation_46(Element):
    cv_arg: TypeAlias = RuleContent_232.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_232

    @classmethod
    def create(cls, arg: "Variation_46.cv_arg") -> "Variation_46":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_232:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_232:
        return self.rule.content

class RuleVariation_46(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_46.cv_arg
    cv_variation: TypeAlias = Variation_46

    @classmethod
    def create(cls, arg : "RuleVariation_46.cv_arg") -> "RuleVariation_46":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_46:
        return self.arg # type: ignore

class NonSpare_1504(NonSpare):
    cv_arg: TypeAlias = RuleVariation_46.cv_arg
    cv_name = "QC4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_46

    @classmethod
    def create(cls, arg : "NonSpare_1504.cv_arg") -> "NonSpare_1504":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_46:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_46:
        return self.rule.variation

class Item_743(Item):
    cv_arg: TypeAlias = NonSpare_1504.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1504

    @classmethod
    def create(cls, arg : "Item_743.cv_arg") -> "Item_743":
        return cls._create(arg) # type: ignore

class Variation_429(Element):
    cv_arg: TypeAlias = RuleContent_226.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_226

    @classmethod
    def create(cls, arg: "Variation_429.cv_arg") -> "Variation_429":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_226:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_226:
        return self.rule.content

class RuleVariation_418(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_429.cv_arg
    cv_variation: TypeAlias = Variation_429

    @classmethod
    def create(cls, arg : "RuleVariation_418.cv_arg") -> "RuleVariation_418":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_429:
        return self.arg # type: ignore

class NonSpare_1484(NonSpare):
    cv_arg: TypeAlias = RuleVariation_418.cv_arg
    cv_name = "QA4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_418

    @classmethod
    def create(cls, arg : "NonSpare_1484.cv_arg") -> "NonSpare_1484":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_418:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_429:
        return self.rule.variation

class Item_723(Item):
    cv_arg: TypeAlias = NonSpare_1484.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1484

    @classmethod
    def create(cls, arg : "Item_723.cv_arg") -> "Item_723":
        return cls._create(arg) # type: ignore

class Variation_534(Element):
    cv_arg: TypeAlias = RuleContent_227.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_227

    @classmethod
    def create(cls, arg: "Variation_534.cv_arg") -> "Variation_534":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_227:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_227:
        return self.rule.content

class RuleVariation_523(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_534.cv_arg
    cv_variation: TypeAlias = Variation_534

    @classmethod
    def create(cls, arg : "RuleVariation_523.cv_arg") -> "RuleVariation_523":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_534:
        return self.arg # type: ignore

class NonSpare_1489(NonSpare):
    cv_arg: TypeAlias = RuleVariation_523.cv_arg
    cv_name = "QB1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_523

    @classmethod
    def create(cls, arg : "NonSpare_1489.cv_arg") -> "NonSpare_1489":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_523:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_534:
        return self.rule.variation

class Item_728(Item):
    cv_arg: TypeAlias = NonSpare_1489.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1489

    @classmethod
    def create(cls, arg : "Item_728.cv_arg") -> "Item_728":
        return cls._create(arg) # type: ignore

class Variation_640(Element):
    cv_arg: TypeAlias = RuleContent_233.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_233

    @classmethod
    def create(cls, arg: "Variation_640.cv_arg") -> "Variation_640":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_233:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_233:
        return self.rule.content

class RuleVariation_629(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_640.cv_arg
    cv_variation: TypeAlias = Variation_640

    @classmethod
    def create(cls, arg : "RuleVariation_629.cv_arg") -> "RuleVariation_629":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_640:
        return self.arg # type: ignore

class NonSpare_1507(NonSpare):
    cv_arg: TypeAlias = RuleVariation_629.cv_arg
    cv_name = "QD1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_629

    @classmethod
    def create(cls, arg : "NonSpare_1507.cv_arg") -> "NonSpare_1507":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_629:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_640:
        return self.rule.variation

class Item_746(Item):
    cv_arg: TypeAlias = NonSpare_1507.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1507

    @classmethod
    def create(cls, arg : "Item_746.cv_arg") -> "Item_746":
        return cls._create(arg) # type: ignore

class Variation_724(Element):
    cv_arg: TypeAlias = RuleContent_228.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_228

    @classmethod
    def create(cls, arg: "Variation_724.cv_arg") -> "Variation_724":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_228:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_228:
        return self.rule.content

class RuleVariation_713(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_724.cv_arg
    cv_variation: TypeAlias = Variation_724

    @classmethod
    def create(cls, arg : "RuleVariation_713.cv_arg") -> "RuleVariation_713":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_724:
        return self.arg # type: ignore

class NonSpare_1493(NonSpare):
    cv_arg: TypeAlias = RuleVariation_713.cv_arg
    cv_name = "QB2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_713

    @classmethod
    def create(cls, arg : "NonSpare_1493.cv_arg") -> "NonSpare_1493":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_713:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_724:
        return self.rule.variation

class Item_732(Item):
    cv_arg: TypeAlias = NonSpare_1493.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1493

    @classmethod
    def create(cls, arg : "Item_732.cv_arg") -> "Item_732":
        return cls._create(arg) # type: ignore

class Variation_852(Element):
    cv_arg: TypeAlias = RuleContent_234.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_234

    @classmethod
    def create(cls, arg: "Variation_852.cv_arg") -> "Variation_852":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_234:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_234:
        return self.rule.content

class RuleVariation_822(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_852.cv_arg
    cv_variation: TypeAlias = Variation_852

    @classmethod
    def create(cls, arg : "RuleVariation_822.cv_arg") -> "RuleVariation_822":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_852:
        return self.arg # type: ignore

class NonSpare_1510(NonSpare):
    cv_arg: TypeAlias = RuleVariation_822.cv_arg
    cv_name = "QD2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_822

    @classmethod
    def create(cls, arg : "NonSpare_1510.cv_arg") -> "NonSpare_1510":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_822:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_852:
        return self.rule.variation

class Item_749(Item):
    cv_arg: TypeAlias = NonSpare_1510.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1510

    @classmethod
    def create(cls, arg : "Item_749.cv_arg") -> "Item_749":
        return cls._create(arg) # type: ignore

class Variation_928(Element):
    cv_arg: TypeAlias = RuleContent_229.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_229

    @classmethod
    def create(cls, arg: "Variation_928.cv_arg") -> "Variation_928":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_229:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_229:
        return self.rule.content

class RuleVariation_898(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_928.cv_arg
    cv_variation: TypeAlias = Variation_928

    @classmethod
    def create(cls, arg : "RuleVariation_898.cv_arg") -> "RuleVariation_898":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_928:
        return self.arg # type: ignore

class NonSpare_1496(NonSpare):
    cv_arg: TypeAlias = RuleVariation_898.cv_arg
    cv_name = "QB4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_898

    @classmethod
    def create(cls, arg : "NonSpare_1496.cv_arg") -> "NonSpare_1496":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_898:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_928:
        return self.rule.variation

class Item_735(Item):
    cv_arg: TypeAlias = NonSpare_1496.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1496

    @classmethod
    def create(cls, arg : "Item_735.cv_arg") -> "Item_735":
        return cls._create(arg) # type: ignore

class Variation_977(Element):
    cv_arg: TypeAlias = RuleContent_235.cv_arg
    cv_bit_offset8 = 7
    cv_bit_size = 1
    cv_rule = RuleContent_235

    @classmethod
    def create(cls, arg: "Variation_977.cv_arg") -> "Variation_977":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_235:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_235:
        return self.rule.content

class RuleVariation_947(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_977.cv_arg
    cv_variation: TypeAlias = Variation_977

    @classmethod
    def create(cls, arg : "RuleVariation_947.cv_arg") -> "RuleVariation_947":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_977:
        return self.arg # type: ignore

class NonSpare_1514(NonSpare):
    cv_arg: TypeAlias = RuleVariation_947.cv_arg
    cv_name = "QD4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_947

    @classmethod
    def create(cls, arg : "NonSpare_1514.cv_arg") -> "NonSpare_1514":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_947:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_977:
        return self.rule.variation

class Item_753(Item):
    cv_arg: TypeAlias = NonSpare_1514.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1514

    @classmethod
    def create(cls, arg : "Item_753.cv_arg") -> "Item_753":
        return cls._create(arg) # type: ignore

class Variation_1247(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_15.cv_arg, Tuple[Literal["V"], RuleVariation_15.cv_arg]], Union[RuleVariation_394.cv_arg, Tuple[Literal["G"], RuleVariation_394.cv_arg]], int, Union[RuleVariation_775.cv_arg, Tuple[Literal["MODEC"], RuleVariation_775.cv_arg]], int, Union[RuleVariation_714.cv_arg, Tuple[Literal["QC1"], RuleVariation_714.cv_arg]], Union[RuleVariation_819.cv_arg, Tuple[Literal["QA1"], RuleVariation_819.cv_arg]], Union[RuleVariation_899.cv_arg, Tuple[Literal["QC2"], RuleVariation_899.cv_arg]], Union[RuleVariation_943.cv_arg, Tuple[Literal["QA2"], RuleVariation_943.cv_arg]], Union[RuleVariation_46.cv_arg, Tuple[Literal["QC4"], RuleVariation_46.cv_arg]], Union[RuleVariation_418.cv_arg, Tuple[Literal["QA4"], RuleVariation_418.cv_arg]], Union[RuleVariation_523.cv_arg, Tuple[Literal["QB1"], RuleVariation_523.cv_arg]], Union[RuleVariation_629.cv_arg, Tuple[Literal["QD1"], RuleVariation_629.cv_arg]], Union[RuleVariation_713.cv_arg, Tuple[Literal["QB2"], RuleVariation_713.cv_arg]], Union[RuleVariation_822.cv_arg, Tuple[Literal["QD2"], RuleVariation_822.cv_arg]], Union[RuleVariation_898.cv_arg, Tuple[Literal["QB4"], RuleVariation_898.cv_arg]], Union[RuleVariation_947.cv_arg, Tuple[Literal["QD4"], RuleVariation_947.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1247.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1097, 1), (Item_353, 1), (Item_12, 2), (Item_573, 12), (Item_3, 4), (Item_738, 1), (Item_716, 1), (Item_741, 1), (Item_721, 1), (Item_743, 1), (Item_723, 1), (Item_728, 1), (Item_746, 1), (Item_732, 1), (Item_749, 1), (Item_735, 1), (Item_753, 1)]
    cv_items_dict = {"V": RuleVariation_15, "G": RuleVariation_394, "MODEC": RuleVariation_775, "QC1": RuleVariation_714, "QA1": RuleVariation_819, "QC2": RuleVariation_899, "QA2": RuleVariation_943, "QC4": RuleVariation_46, "QA4": RuleVariation_418, "QB1": RuleVariation_523, "QD1": RuleVariation_629, "QB2": RuleVariation_713, "QD2": RuleVariation_822, "QB4": RuleVariation_898, "QD4": RuleVariation_947}

    @overload
    @classmethod
    def spec(cls, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> RuleVariation_394:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MODEC"]) -> RuleVariation_775:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QC1"]) -> RuleVariation_714:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QA1"]) -> RuleVariation_819:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QC2"]) -> RuleVariation_899:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QA2"]) -> RuleVariation_943:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QC4"]) -> RuleVariation_46:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QA4"]) -> RuleVariation_418:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QB1"]) -> RuleVariation_523:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QD1"]) -> RuleVariation_629:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QB2"]) -> RuleVariation_713:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QD2"]) -> RuleVariation_822:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QB4"]) -> RuleVariation_898:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QD4"]) -> RuleVariation_947:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["V"], Literal["G"], Literal["MODEC"], Literal["QC1"], Literal["QA1"], Literal["QC2"], Literal["QA2"], Literal["QC4"], Literal["QA4"], Literal["QB1"], Literal["QD1"], Literal["QB2"], Literal["QD2"], Literal["QB4"], Literal["QD4"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> RuleVariation_394:
        ...
    @overload
    def get_item(self, key : Literal["MODEC"]) -> RuleVariation_775:
        ...
    @overload
    def get_item(self, key : Literal["QC1"]) -> RuleVariation_714:
        ...
    @overload
    def get_item(self, key : Literal["QA1"]) -> RuleVariation_819:
        ...
    @overload
    def get_item(self, key : Literal["QC2"]) -> RuleVariation_899:
        ...
    @overload
    def get_item(self, key : Literal["QA2"]) -> RuleVariation_943:
        ...
    @overload
    def get_item(self, key : Literal["QC4"]) -> RuleVariation_46:
        ...
    @overload
    def get_item(self, key : Literal["QA4"]) -> RuleVariation_418:
        ...
    @overload
    def get_item(self, key : Literal["QB1"]) -> RuleVariation_523:
        ...
    @overload
    def get_item(self, key : Literal["QD1"]) -> RuleVariation_629:
        ...
    @overload
    def get_item(self, key : Literal["QB2"]) -> RuleVariation_713:
        ...
    @overload
    def get_item(self, key : Literal["QD2"]) -> RuleVariation_822:
        ...
    @overload
    def get_item(self, key : Literal["QB4"]) -> RuleVariation_898:
        ...
    @overload
    def get_item(self, key : Literal["QD4"]) -> RuleVariation_947:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1247.cv_arg") -> 'Variation_1247':
        return cls._create(arg) # type: ignore

class RuleVariation_1176(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1247.cv_arg
    cv_variation: TypeAlias = Variation_1247

    @classmethod
    def create(cls, arg : "RuleVariation_1176.cv_arg") -> "RuleVariation_1176":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1247:
        return self.arg # type: ignore

class NonSpare_270(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1176.cv_arg
    cv_name = "100"
    cv_title = "Mode-C Code and Code Confidence Indicator"
    cv_rule: TypeAlias = RuleVariation_1176

    @classmethod
    def create(cls, arg : "NonSpare_270.cv_arg") -> "NonSpare_270":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1176:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1247:
        return self.rule.variation

class UapItem_270(UapItem):
    cv_non_spare: TypeAlias = NonSpare_270

class NonSpare_186(NonSpare):
    cv_arg: TypeAlias = RuleVariation_997.cv_arg
    cv_name = "060"
    cv_title = "Mode-2 Code Confidence Indicator"
    cv_rule: TypeAlias = RuleVariation_997

    @classmethod
    def create(cls, arg : "NonSpare_186.cv_arg") -> "NonSpare_186":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_997:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1029:
        return self.rule.variation

class UapItem_186(UapItem):
    cv_non_spare: TypeAlias = NonSpare_186

class Content_375(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No warning nor error condition", 1: "Garbled reply", 2: "Reflection", 3: "Sidelobe reply", 4: "Split plot", 5: "Second time around reply", 6: "Angels", 7: "Terrestrial vehicles", 64: "Possible wrong code in Mode-3/A", 65: "Possible wrong altitude information, transmitted when the Code C credibility check fails together with the Mode-C code in binary notation", 66: "Possible phantom MSSR plot", 80: "Fixed PSR plot", 81: "Slow PSR plot", 82: "Low quality PSR plot"}

class RuleContent_375(RuleContentContextFree):
    cv_arg: TypeAlias = Content_375.cv_arg
    cv_content: TypeAlias = Content_375

    @property
    def content(self) -> Content_375:
        return self._get_content() # type: ignore

class Variation_151(Element):
    cv_arg: TypeAlias = RuleContent_375.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 7
    cv_rule = RuleContent_375

    @classmethod
    def create(cls, arg: "Variation_151.cv_arg") -> "Variation_151":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_375:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_375:
        return self.rule.content

class Variation_1447(Repetitive):
    cv_arg: TypeAlias = List[Variation_151.cv_arg]
    cv_rep_bytes = None
    cv_variation: TypeAlias = Variation_151

    @classmethod
    def create(cls, arg: "Variation_1447.cv_arg") -> 'Variation_1447':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_151]:
        return self._get_list() # type: ignore

class RuleVariation_1369(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1447.cv_arg
    cv_variation: TypeAlias = Variation_1447

    @classmethod
    def create(cls, arg : "RuleVariation_1369.cv_arg") -> "RuleVariation_1369":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1447:
        return self.arg # type: ignore

class NonSpare_115(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1369.cv_arg
    cv_name = "030"
    cv_title = "Warning/Error Conditions"
    cv_rule: TypeAlias = RuleVariation_1369

    @classmethod
    def create(cls, arg : "NonSpare_115.cv_arg") -> "NonSpare_115":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1369:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1447:
        return self.rule.variation

class UapItem_115(UapItem):
    cv_non_spare: TypeAlias = NonSpare_115

class Content_166(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "X-pulse received in Mode-3/A reply"}

class RuleContent_166(RuleContentContextFree):
    cv_arg: TypeAlias = Content_166.cv_arg
    cv_content: TypeAlias = Content_166

    @property
    def content(self) -> Content_166:
        return self._get_content() # type: ignore

class Variation_36(Element):
    cv_arg: TypeAlias = RuleContent_166.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_166

    @classmethod
    def create(cls, arg: "Variation_36.cv_arg") -> "Variation_36":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_166:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_166:
        return self.rule.content

class RuleVariation_36(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_36.cv_arg
    cv_variation: TypeAlias = Variation_36

    @classmethod
    def create(cls, arg : "RuleVariation_36.cv_arg") -> "RuleVariation_36":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_36:
        return self.arg # type: ignore

class NonSpare_2101(NonSpare):
    cv_arg: TypeAlias = RuleVariation_36.cv_arg
    cv_name = "XA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_36

    @classmethod
    def create(cls, arg : "NonSpare_2101.cv_arg") -> "NonSpare_2101":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_36:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_36:
        return self.rule.variation

class Item_1208(Item):
    cv_arg: TypeAlias = NonSpare_2101.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2101

    @classmethod
    def create(cls, arg : "Item_1208.cv_arg") -> "Item_1208":
        return cls._create(arg) # type: ignore

class Item_7(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 1
    cv_bit_size = 1

class Content_167(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "X-pulse received in Mode-C reply"}

class RuleContent_167(RuleContentContextFree):
    cv_arg: TypeAlias = Content_167.cv_arg
    cv_content: TypeAlias = Content_167

    @property
    def content(self) -> Content_167:
        return self._get_content() # type: ignore

class Variation_522(Element):
    cv_arg: TypeAlias = RuleContent_167.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_167

    @classmethod
    def create(cls, arg: "Variation_522.cv_arg") -> "Variation_522":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_167:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_167:
        return self.rule.content

class RuleVariation_511(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_522.cv_arg
    cv_variation: TypeAlias = Variation_522

    @classmethod
    def create(cls, arg : "RuleVariation_511.cv_arg") -> "RuleVariation_511":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_522:
        return self.arg # type: ignore

class NonSpare_2102(NonSpare):
    cv_arg: TypeAlias = RuleVariation_511.cv_arg
    cv_name = "XC"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_511

    @classmethod
    def create(cls, arg : "NonSpare_2102.cv_arg") -> "NonSpare_2102":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_511:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_522:
        return self.rule.variation

class Item_1209(Item):
    cv_arg: TypeAlias = NonSpare_2102.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2102

    @classmethod
    def create(cls, arg : "Item_1209.cv_arg") -> "Item_1209":
        return cls._create(arg) # type: ignore

class Item_17(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 3
    cv_bit_size = 2

class Content_165(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "X-pulse received in Mode-2 reply"}

class RuleContent_165(RuleContentContextFree):
    cv_arg: TypeAlias = Content_165.cv_arg
    cv_content: TypeAlias = Content_165

    @property
    def content(self) -> Content_165:
        return self._get_content() # type: ignore

class Variation_839(Element):
    cv_arg: TypeAlias = RuleContent_165.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_165

    @classmethod
    def create(cls, arg: "Variation_839.cv_arg") -> "Variation_839":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_165:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_165:
        return self.rule.content

class RuleVariation_809(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_839.cv_arg
    cv_variation: TypeAlias = Variation_839

    @classmethod
    def create(cls, arg : "RuleVariation_809.cv_arg") -> "RuleVariation_809":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_839:
        return self.arg # type: ignore

class NonSpare_2095(NonSpare):
    cv_arg: TypeAlias = RuleVariation_809.cv_arg
    cv_name = "X2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_809

    @classmethod
    def create(cls, arg : "NonSpare_2095.cv_arg") -> "NonSpare_2095":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_809:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_839:
        return self.rule.variation

class Item_1202(Item):
    cv_arg: TypeAlias = NonSpare_2095.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2095

    @classmethod
    def create(cls, arg : "Item_1202.cv_arg") -> "Item_1202":
        return cls._create(arg) # type: ignore

class Item_27(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 6
    cv_bit_size = 2

class Variation_1314(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_36.cv_arg, Tuple[Literal["XA"], RuleVariation_36.cv_arg]], int, Union[RuleVariation_511.cv_arg, Tuple[Literal["XC"], RuleVariation_511.cv_arg]], int, Union[RuleVariation_809.cv_arg, Tuple[Literal["X2"], RuleVariation_809.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1314.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_1208, 1), (Item_7, 1), (Item_1209, 1), (Item_17, 2), (Item_1202, 1), (Item_27, 2)]
    cv_items_dict = {"XA": RuleVariation_36, "XC": RuleVariation_511, "X2": RuleVariation_809}

    @overload
    @classmethod
    def spec(cls, key : Literal["XA"]) -> RuleVariation_36:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["XC"]) -> RuleVariation_511:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["X2"]) -> RuleVariation_809:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["XA"], Literal["XC"], Literal["X2"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["XA"]) -> RuleVariation_36:
        ...
    @overload
    def get_item(self, key : Literal["XC"]) -> RuleVariation_511:
        ...
    @overload
    def get_item(self, key : Literal["X2"]) -> RuleVariation_809:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1314.cv_arg") -> 'Variation_1314':
        return cls._create(arg) # type: ignore

class RuleVariation_1238(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1314.cv_arg
    cv_variation: TypeAlias = Variation_1314

    @classmethod
    def create(cls, arg : "RuleVariation_1238.cv_arg") -> "RuleVariation_1238":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1314:
        return self.arg # type: ignore

class NonSpare_341(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1238.cv_arg
    cv_name = "150"
    cv_title = "Presence of X-Pulse"
    cv_rule: TypeAlias = RuleVariation_1238

    @classmethod
    def create(cls, arg : "NonSpare_341.cv_arg") -> "NonSpare_341":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1238:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1314:
        return self.rule.variation

class UapItem_341(UapItem):
    cv_non_spare: TypeAlias = NonSpare_341

class UapItem_544(UapItemSpare):
    pass

class Variation_1456(Explicit):
    cv_arg: TypeAlias = bytes
    cv_explicit_type: TypeAlias = SpecialPurpose

    @classmethod
    def create(cls, arg: "Variation_1456.cv_arg") -> 'Variation_1456':
        return cls._create(arg) # type: ignore

class RuleVariation_1378(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1456.cv_arg
    cv_variation: TypeAlias = Variation_1456

    @classmethod
    def create(cls, arg : "RuleVariation_1378.cv_arg") -> "RuleVariation_1378":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1456:
        return self.arg # type: ignore

class NonSpare_1721(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1378.cv_arg
    cv_name = "SP"
    cv_title = "Special Purpose Field"
    cv_rule: TypeAlias = RuleVariation_1378

    @classmethod
    def create(cls, arg : "NonSpare_1721.cv_arg") -> "NonSpare_1721":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1378:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1456:
        return self.rule.variation

class UapItem_543(UapItem):
    cv_non_spare: TypeAlias = NonSpare_1721

class UapItem_545(UapItemRFS):
    pass

class Record_17(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_35.cv_arg,
        "020": NonSpare_86.cv_arg,
        "040": NonSpare_136.cv_arg,
        "070": NonSpare_209.cv_arg,
        "090": NonSpare_249.cv_arg,
        "130": NonSpare_307.cv_arg,
        "141": NonSpare_332.cv_arg,
        "050": NonSpare_171.cv_arg,
        "120": NonSpare_295.cv_arg,
        "131": NonSpare_311.cv_arg,
        "080": NonSpare_229.cv_arg,
        "100": NonSpare_270.cv_arg,
        "060": NonSpare_186.cv_arg,
        "030": NonSpare_115.cv_arg,
        "150": NonSpare_341.cv_arg,
        "SP": NonSpare_1721.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_35.cv_arg],
        Tuple[Literal["020"], NonSpare_86.cv_arg],
        Tuple[Literal["040"], NonSpare_136.cv_arg],
        Tuple[Literal["070"], NonSpare_209.cv_arg],
        Tuple[Literal["090"], NonSpare_249.cv_arg],
        Tuple[Literal["130"], NonSpare_307.cv_arg],
        Tuple[Literal["141"], NonSpare_332.cv_arg],
        Tuple[Literal["050"], NonSpare_171.cv_arg],
        Tuple[Literal["120"], NonSpare_295.cv_arg],
        Tuple[Literal["131"], NonSpare_311.cv_arg],
        Tuple[Literal["080"], NonSpare_229.cv_arg],
        Tuple[Literal["100"], NonSpare_270.cv_arg],
        Tuple[Literal["060"], NonSpare_186.cv_arg],
        Tuple[Literal["030"], NonSpare_115.cv_arg],
        Tuple[Literal["150"], NonSpare_341.cv_arg],
        Tuple[Literal["SP"], NonSpare_1721.cv_arg],
    ]
    cv_fspec_max_bytes = 3
    cv_items_list = [UapItem_35, UapItem_86, UapItem_136, UapItem_209, UapItem_249, UapItem_307, UapItem_332, UapItem_171, UapItem_295, UapItem_311, UapItem_229, UapItem_270, UapItem_186, UapItem_115, UapItem_341, UapItem_544, UapItem_544, UapItem_544, UapItem_544, UapItem_543, UapItem_545]
    cv_items_dict = {"010": NonSpare_35, "020": NonSpare_86, "040": NonSpare_136, "070": NonSpare_209, "090": NonSpare_249, "130": NonSpare_307, "141": NonSpare_332, "050": NonSpare_171, "120": NonSpare_295, "131": NonSpare_311, "080": NonSpare_229, "100": NonSpare_270, "060": NonSpare_186, "030": NonSpare_115, "150": NonSpare_341, "SP": NonSpare_1721}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_35:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_86:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> NonSpare_136:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> NonSpare_209:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> NonSpare_249:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["130"]) -> NonSpare_307:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["141"]) -> NonSpare_332:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> NonSpare_171:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> NonSpare_295:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["131"]) -> NonSpare_311:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> NonSpare_229:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_270:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_186:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> NonSpare_115:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["150"]) -> NonSpare_341:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1721:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["020"], Literal["040"], Literal["070"], Literal["090"], Literal["130"], Literal["141"], Literal["050"], Literal["120"], Literal["131"], Literal["080"], Literal["100"], Literal["060"], Literal["030"], Literal["150"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_35]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_86]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_136]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_209]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_249]:
        ...
    @overload
    def get_item(self, key : Literal["130"]) -> Optional[NonSpare_307]:
        ...
    @overload
    def get_item(self, key : Literal["141"]) -> Optional[NonSpare_332]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_171]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_295]:
        ...
    @overload
    def get_item(self, key : Literal["131"]) -> Optional[NonSpare_311]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_229]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_270]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_186]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_115]:
        ...
    @overload
    def get_item(self, key : Literal["150"]) -> Optional[NonSpare_341]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1721]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_35.cv_arg) -> 'Record_17':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_86.cv_arg) -> 'Record_17':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_136.cv_arg) -> 'Record_17':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_209.cv_arg) -> 'Record_17':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_249.cv_arg) -> 'Record_17':
        ...
    @overload
    def set_item(self, key : Literal["130"], val : NonSpare_307.cv_arg) -> 'Record_17':
        ...
    @overload
    def set_item(self, key : Literal["141"], val : NonSpare_332.cv_arg) -> 'Record_17':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_171.cv_arg) -> 'Record_17':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_295.cv_arg) -> 'Record_17':
        ...
    @overload
    def set_item(self, key : Literal["131"], val : NonSpare_311.cv_arg) -> 'Record_17':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_229.cv_arg) -> 'Record_17':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_270.cv_arg) -> 'Record_17':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_186.cv_arg) -> 'Record_17':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_115.cv_arg) -> 'Record_17':
        ...
    @overload
    def set_item(self, key : Literal["150"], val : NonSpare_341.cv_arg) -> 'Record_17':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1721.cv_arg) -> 'Record_17':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_17':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_17':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_17':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_17':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_17':
        ...
    @overload
    def del_item(self, key : Literal["130"]) -> 'Record_17':
        ...
    @overload
    def del_item(self, key : Literal["141"]) -> 'Record_17':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_17':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_17':
        ...
    @overload
    def del_item(self, key : Literal["131"]) -> 'Record_17':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_17':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_17':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_17':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_17':
        ...
    @overload
    def del_item(self, key : Literal["150"]) -> 'Record_17':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_17':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_35]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_86]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["040"]) -> List[NonSpare_136]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["070"]) -> List[NonSpare_209]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_249]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["130"]) -> List[NonSpare_307]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["141"]) -> List[NonSpare_332]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_171]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["120"]) -> List[NonSpare_295]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["131"]) -> List[NonSpare_311]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["080"]) -> List[NonSpare_229]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_270]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["060"]) -> List[NonSpare_186]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["030"]) -> List[NonSpare_115]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["150"]) -> List[NonSpare_341]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1721]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_17.cv_arg", rfs : Optional[List["Record_17.cv_union"]] = None) -> 'Record_17':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_17", Bits]]:
        return cls._parse(bs) # type: ignore

class Variation_251(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_251.cv_arg") -> "Variation_251":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_244(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_251.cv_arg
    cv_variation: TypeAlias = Variation_251

    @classmethod
    def create(cls, arg : "RuleVariation_244.cv_arg") -> "RuleVariation_244":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_251:
        return self.arg # type: ignore

class NonSpare_361(NonSpare):
    cv_arg: TypeAlias = RuleVariation_244.cv_arg
    cv_name = "161"
    cv_title = "Track Plot Number"
    cv_rule: TypeAlias = RuleVariation_244

    @classmethod
    def create(cls, arg : "NonSpare_361.cv_arg") -> "NonSpare_361":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_244:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_251:
        return self.rule.variation

class UapItem_361(UapItem):
    cv_non_spare: TypeAlias = NonSpare_361

class Content_671(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 1.5625e-2
    cv_unit = "NM"

    def as_quantity(self, cv_unit : Optional[Literal["NM"]] = None) -> float:
        return self._as_quantity()

class RuleContent_671(RuleContentContextFree):
    cv_arg: TypeAlias = Content_671.cv_arg
    cv_content: TypeAlias = Content_671

    @property
    def content(self) -> Content_671:
        return self._get_content() # type: ignore

class Variation_282(Element):
    cv_arg: TypeAlias = RuleContent_671.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_671

    @classmethod
    def create(cls, arg: "Variation_282.cv_arg") -> "Variation_282":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_671:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_671:
        return self.rule.content

class RuleVariation_275(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_282.cv_arg
    cv_variation: TypeAlias = Variation_282

    @classmethod
    def create(cls, arg : "RuleVariation_275.cv_arg") -> "RuleVariation_275":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_282:
        return self.arg # type: ignore

class NonSpare_2087(NonSpare):
    cv_arg: TypeAlias = RuleVariation_275.cv_arg
    cv_name = "X"
    cv_title = "X-Component"
    cv_rule: TypeAlias = RuleVariation_275

    @classmethod
    def create(cls, arg : "NonSpare_2087.cv_arg") -> "NonSpare_2087":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_275:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_282:
        return self.rule.variation

class Item_1194(Item):
    cv_arg: TypeAlias = NonSpare_2087.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2087

    @classmethod
    def create(cls, arg : "Item_1194.cv_arg") -> "Item_1194":
        return cls._create(arg) # type: ignore

class NonSpare_2141(NonSpare):
    cv_arg: TypeAlias = RuleVariation_275.cv_arg
    cv_name = "Y"
    cv_title = "Y-Component"
    cv_rule: TypeAlias = RuleVariation_275

    @classmethod
    def create(cls, arg : "NonSpare_2141.cv_arg") -> "NonSpare_2141":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_275:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_282:
        return self.rule.variation

class Item_1245(Item):
    cv_arg: TypeAlias = NonSpare_2141.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2141

    @classmethod
    def create(cls, arg : "Item_1245.cv_arg") -> "Item_1245":
        return cls._create(arg) # type: ignore

class Variation_1307(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_275.cv_arg, Tuple[Literal["X"], RuleVariation_275.cv_arg]], Union[RuleVariation_275.cv_arg, Tuple[Literal["Y"], RuleVariation_275.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1307.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1194, 16), (Item_1245, 16)]
    cv_items_dict = {"X": RuleVariation_275, "Y": RuleVariation_275}

    @overload
    @classmethod
    def spec(cls, key : Literal["X"]) -> RuleVariation_275:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y"]) -> RuleVariation_275:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X"], Literal["Y"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X"]) -> RuleVariation_275:
        ...
    @overload
    def get_item(self, key : Literal["Y"]) -> RuleVariation_275:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1307.cv_arg") -> 'Variation_1307':
        return cls._create(arg) # type: ignore

class RuleVariation_1234(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1307.cv_arg
    cv_variation: TypeAlias = Variation_1307

    @classmethod
    def create(cls, arg : "RuleVariation_1234.cv_arg") -> "RuleVariation_1234":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1307:
        return self.arg # type: ignore

class NonSpare_157(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1234.cv_arg
    cv_name = "042"
    cv_title = "Calculated Position in Cartesian Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1234

    @classmethod
    def create(cls, arg : "NonSpare_157.cv_arg") -> "NonSpare_157":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1234:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1307:
        return self.rule.variation

class UapItem_157(UapItem):
    cv_non_spare: TypeAlias = NonSpare_157

class Content_775(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM/s"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 6.103515625e-5
    cv_unit = "NM/s"

    def as_quantity(self, cv_unit : Optional[Literal["NM/s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_774(RuleContentContextFree):
    cv_arg: TypeAlias = Content_775.cv_arg
    cv_content: TypeAlias = Content_775

    @property
    def content(self) -> Content_775:
        return self._get_content() # type: ignore

class Variation_336(Element):
    cv_arg: TypeAlias = RuleContent_774.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_774

    @classmethod
    def create(cls, arg: "Variation_336.cv_arg") -> "Variation_336":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_774:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_775:
        return self.rule.content

class RuleVariation_329(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_336.cv_arg
    cv_variation: TypeAlias = Variation_336

    @classmethod
    def create(cls, arg : "RuleVariation_329.cv_arg") -> "RuleVariation_329":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_336:
        return self.arg # type: ignore

class NonSpare_1033(NonSpare):
    cv_arg: TypeAlias = RuleVariation_329.cv_arg
    cv_name = "GSP"
    cv_title = "Calculated Groundspeed"
    cv_rule: TypeAlias = RuleVariation_329

    @classmethod
    def create(cls, arg : "NonSpare_1033.cv_arg") -> "NonSpare_1033":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_329:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_336:
        return self.rule.variation

class Item_373(Item):
    cv_arg: TypeAlias = NonSpare_1033.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1033

    @classmethod
    def create(cls, arg : "Item_373.cv_arg") -> "Item_373":
        return cls._create(arg) # type: ignore

class NonSpare_1053(NonSpare):
    cv_arg: TypeAlias = RuleVariation_334.cv_arg
    cv_name = "HDG"
    cv_title = "Calculated Heading"
    cv_rule: TypeAlias = RuleVariation_334

    @classmethod
    def create(cls, arg : "NonSpare_1053.cv_arg") -> "NonSpare_1053":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_334:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_341:
        return self.rule.variation

class Item_387(Item):
    cv_arg: TypeAlias = NonSpare_1053.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1053

    @classmethod
    def create(cls, arg : "Item_387.cv_arg") -> "Item_387":
        return cls._create(arg) # type: ignore

class Variation_1109(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_329.cv_arg, Tuple[Literal["GSP"], RuleVariation_329.cv_arg]], Union[RuleVariation_334.cv_arg, Tuple[Literal["HDG"], RuleVariation_334.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1109.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_373, 16), (Item_387, 16)]
    cv_items_dict = {"GSP": RuleVariation_329, "HDG": RuleVariation_334}

    @overload
    @classmethod
    def spec(cls, key : Literal["GSP"]) -> RuleVariation_329:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["HDG"]) -> RuleVariation_334:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["GSP"], Literal["HDG"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["GSP"]) -> RuleVariation_329:
        ...
    @overload
    def get_item(self, key : Literal["HDG"]) -> RuleVariation_334:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1109.cv_arg") -> 'Variation_1109':
        return cls._create(arg) # type: ignore

class RuleVariation_1067(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1109.cv_arg
    cv_variation: TypeAlias = Variation_1109

    @classmethod
    def create(cls, arg : "RuleVariation_1067.cv_arg") -> "RuleVariation_1067":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1109:
        return self.arg # type: ignore

class NonSpare_384(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1067.cv_arg
    cv_name = "200"
    cv_title = "Calculated Track Velocity in Polar Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1067

    @classmethod
    def create(cls, arg : "NonSpare_384.cv_arg") -> "NonSpare_384":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1067:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1109:
        return self.rule.variation

class UapItem_384(UapItem):
    cv_non_spare: TypeAlias = NonSpare_384

class Content_61(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Confirmed Track", 1: "Track in initialisation phase"}

class RuleContent_61(RuleContentContextFree):
    cv_arg: TypeAlias = Content_61.cv_arg
    cv_content: TypeAlias = Content_61

    @property
    def content(self) -> Content_61:
        return self._get_content() # type: ignore

class Variation_17(Element):
    cv_arg: TypeAlias = RuleContent_61.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_61

    @classmethod
    def create(cls, arg: "Variation_17.cv_arg") -> "Variation_17":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_61:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_61:
        return self.rule.content

class RuleVariation_17(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_17.cv_arg
    cv_variation: TypeAlias = Variation_17

    @classmethod
    def create(cls, arg : "RuleVariation_17.cv_arg") -> "RuleVariation_17":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_17:
        return self.arg # type: ignore

class Content_429(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Primary track", 1: "SSR/Combined track"}

class RuleContent_429(RuleContentContextFree):
    cv_arg: TypeAlias = Content_429.cv_arg
    cv_content: TypeAlias = Content_429

    @property
    def content(self) -> Content_429:
        return self._get_content() # type: ignore

class Variation_447(Element):
    cv_arg: TypeAlias = RuleContent_429.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_429

    @classmethod
    def create(cls, arg: "Variation_447.cv_arg") -> "Variation_447":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_429:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_429:
        return self.rule.content

class RuleVariation_436(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_447.cv_arg
    cv_variation: TypeAlias = Variation_447

    @classmethod
    def create(cls, arg : "RuleVariation_436.cv_arg") -> "RuleVariation_436":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_447:
        return self.arg # type: ignore

class Content_84(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Aircraft manoeuvring"}

class RuleContent_84(RuleContentContextFree):
    cv_arg: TypeAlias = Content_84.cv_arg
    cv_content: TypeAlias = Content_84

    @property
    def content(self) -> Content_84:
        return self._get_content() # type: ignore

class Variation_512(Element):
    cv_arg: TypeAlias = RuleContent_84.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_84

    @classmethod
    def create(cls, arg: "Variation_512.cv_arg") -> "Variation_512":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_84:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_84:
        return self.rule.content

class RuleVariation_501(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_512.cv_arg
    cv_variation: TypeAlias = Variation_512

    @classmethod
    def create(cls, arg : "RuleVariation_501.cv_arg") -> "RuleVariation_501":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_512:
        return self.arg # type: ignore

class Content_94(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Doubtful plot to track association"}

class RuleContent_94(RuleContentContextFree):
    cv_arg: TypeAlias = Content_94.cv_arg
    cv_content: TypeAlias = Content_94

    @property
    def content(self) -> Content_94:
        return self._get_content() # type: ignore

class Variation_618(Element):
    cv_arg: TypeAlias = RuleContent_94.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_94

    @classmethod
    def create(cls, arg: "Variation_618.cv_arg") -> "Variation_618":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_94:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_94:
        return self.rule.content

class RuleVariation_607(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_618.cv_arg
    cv_variation: TypeAlias = Variation_618

    @classmethod
    def create(cls, arg : "RuleVariation_607.cv_arg") -> "RuleVariation_607":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_618:
        return self.arg # type: ignore

class Content_431(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "RDP Chain 1", 1: "RDP Chain 2"}

class RuleContent_431(RuleContentContextFree):
    cv_arg: TypeAlias = Content_431.cv_arg
    cv_content: TypeAlias = Content_431

    @property
    def content(self) -> Content_431:
        return self._get_content() # type: ignore

class Variation_743(Element):
    cv_arg: TypeAlias = RuleContent_431.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_431

    @classmethod
    def create(cls, arg: "Variation_743.cv_arg") -> "Variation_743":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_431:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_431:
        return self.rule.content

class RuleVariation_732(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_743.cv_arg
    cv_variation: TypeAlias = Variation_743

    @classmethod
    def create(cls, arg : "RuleVariation_732.cv_arg") -> "RuleVariation_732":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_743:
        return self.arg # type: ignore

class Content_99(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Ghost track"}

class RuleContent_99(RuleContentContextFree):
    cv_arg: TypeAlias = Content_99.cv_arg
    cv_content: TypeAlias = Content_99

    @property
    def content(self) -> Content_99:
        return self._get_content() # type: ignore

class Variation_909(Element):
    cv_arg: TypeAlias = RuleContent_99.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_99

    @classmethod
    def create(cls, arg: "Variation_909.cv_arg") -> "Variation_909":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_99:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_99:
        return self.rule.content

class RuleVariation_879(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_909.cv_arg
    cv_variation: TypeAlias = Variation_909

    @classmethod
    def create(cls, arg : "RuleVariation_879.cv_arg") -> "RuleVariation_879":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_909:
        return self.arg # type: ignore

class Content_112(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Last report for a track"}

class RuleContent_112(RuleContentContextFree):
    cv_arg: TypeAlias = Content_112.cv_arg
    cv_content: TypeAlias = Content_112

    @property
    def content(self) -> Content_112:
        return self._get_content() # type: ignore

class Variation_31(Element):
    cv_arg: TypeAlias = RuleContent_112.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_112

    @classmethod
    def create(cls, arg: "Variation_31.cv_arg") -> "Variation_31":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_112:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_112:
        return self.rule.content

class RuleVariation_31(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_31.cv_arg
    cv_variation: TypeAlias = Variation_31

    @classmethod
    def create(cls, arg : "RuleVariation_31.cv_arg") -> "RuleVariation_31":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_31:
        return self.arg # type: ignore

class NonSpare_784(NonSpare):
    cv_arg: TypeAlias = RuleVariation_17.cv_arg
    cv_name = "CON"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_17

    @classmethod
    def create(cls, arg : "NonSpare_784.cv_arg") -> "NonSpare_784":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_17:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_17:
        return self.rule.variation

class Item_189(Item):
    cv_arg: TypeAlias = NonSpare_784.cv_arg
    cv_non_spare: TypeAlias = NonSpare_784

    @classmethod
    def create(cls, arg : "Item_189.cv_arg") -> "Item_189":
        return cls._create(arg) # type: ignore

class NonSpare_1533(NonSpare):
    cv_arg: TypeAlias = RuleVariation_436.cv_arg
    cv_name = "RAD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_436

    @classmethod
    def create(cls, arg : "NonSpare_1533.cv_arg") -> "NonSpare_1533":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_436:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_447:
        return self.rule.variation

class Item_769(Item):
    cv_arg: TypeAlias = NonSpare_1533.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1533

    @classmethod
    def create(cls, arg : "Item_769.cv_arg") -> "Item_769":
        return cls._create(arg) # type: ignore

class NonSpare_1220(NonSpare):
    cv_arg: TypeAlias = RuleVariation_501.cv_arg
    cv_name = "MAN"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_501

    @classmethod
    def create(cls, arg : "NonSpare_1220.cv_arg") -> "NonSpare_1220":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_501:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_512:
        return self.rule.variation

class Item_525(Item):
    cv_arg: TypeAlias = NonSpare_1220.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1220

    @classmethod
    def create(cls, arg : "Item_525.cv_arg") -> "Item_525":
        return cls._create(arg) # type: ignore

class NonSpare_886(NonSpare):
    cv_arg: TypeAlias = RuleVariation_607.cv_arg
    cv_name = "DOU"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_607

    @classmethod
    def create(cls, arg : "NonSpare_886.cv_arg") -> "NonSpare_886":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_607:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_618:
        return self.rule.variation

class Item_267(Item):
    cv_arg: TypeAlias = NonSpare_886.cv_arg
    cv_non_spare: TypeAlias = NonSpare_886

    @classmethod
    def create(cls, arg : "Item_267.cv_arg") -> "Item_267":
        return cls._create(arg) # type: ignore

class NonSpare_1549(NonSpare):
    cv_arg: TypeAlias = RuleVariation_732.cv_arg
    cv_name = "RDPC"
    cv_title = "Radar Data Processing Chain"
    cv_rule: TypeAlias = RuleVariation_732

    @classmethod
    def create(cls, arg : "NonSpare_1549.cv_arg") -> "NonSpare_1549":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_732:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_743:
        return self.rule.variation

class Item_783(Item):
    cv_arg: TypeAlias = NonSpare_1549.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1549

    @classmethod
    def create(cls, arg : "Item_783.cv_arg") -> "Item_783":
        return cls._create(arg) # type: ignore

class Item_23(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 5
    cv_bit_size = 1

class NonSpare_1028(NonSpare):
    cv_arg: TypeAlias = RuleVariation_879.cv_arg
    cv_name = "GHO"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_879

    @classmethod
    def create(cls, arg : "NonSpare_1028.cv_arg") -> "NonSpare_1028":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_879:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_909:
        return self.rule.variation

class Item_369(Item):
    cv_arg: TypeAlias = NonSpare_1028.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1028

    @classmethod
    def create(cls, arg : "Item_369.cv_arg") -> "Item_369":
        return cls._create(arg) # type: ignore

class NonSpare_1903(NonSpare):
    cv_arg: TypeAlias = RuleVariation_31.cv_arg
    cv_name = "TRE"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_31

    @classmethod
    def create(cls, arg : "NonSpare_1903.cv_arg") -> "NonSpare_1903":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_31:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_31:
        return self.rule.variation

class Item_1030(Item):
    cv_arg: TypeAlias = NonSpare_1903.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1903

    @classmethod
    def create(cls, arg : "Item_1030.cv_arg") -> "Item_1030":
        return cls._create(arg) # type: ignore

class Item_9(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 1
    cv_bit_size = 6

class Variation_1348(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_17.cv_arg, Tuple[Literal["CON"], RuleVariation_17.cv_arg]], Union[RuleVariation_436.cv_arg, Tuple[Literal["RAD"], RuleVariation_436.cv_arg]], Union[RuleVariation_501.cv_arg, Tuple[Literal["MAN"], RuleVariation_501.cv_arg]], Union[RuleVariation_607.cv_arg, Tuple[Literal["DOU"], RuleVariation_607.cv_arg]], Union[RuleVariation_732.cv_arg, Tuple[Literal["RDPC"], RuleVariation_732.cv_arg]], int, Union[RuleVariation_879.cv_arg, Tuple[Literal["GHO"], RuleVariation_879.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_31.cv_arg, Tuple[Literal["TRE"], RuleVariation_31.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1348.cv_arg_group_1"],
        Tuple["Variation_1348.cv_arg_group_1", "Variation_1348.cv_arg_group_2"],
    ]
    cv_items_list = [[(Item_189, 1), (Item_769, 1), (Item_525, 1), (Item_267, 1), (Item_783, 1), (Item_23, 1), (Item_369, 1), None], [(Item_1030, 1), (Item_9, 6), None]]

    @classmethod
    def create(cls, arg: "Variation_1348.cv_arg") -> 'Variation_1348':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["CON"]) -> RuleVariation_17:
        ...
    @overload
    def get_item(self, key : Literal["RAD"]) -> RuleVariation_436:
        ...
    @overload
    def get_item(self, key : Literal["MAN"]) -> RuleVariation_501:
        ...
    @overload
    def get_item(self, key : Literal["DOU"]) -> RuleVariation_607:
        ...
    @overload
    def get_item(self, key : Literal["RDPC"]) -> RuleVariation_732:
        ...
    @overload
    def get_item(self, key : Literal["GHO"]) -> RuleVariation_879:
        ...
    @overload
    def get_item(self, key : Literal["TRE"]) -> Optional[RuleVariation_31]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1270(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1348.cv_arg
    cv_variation: TypeAlias = Variation_1348

    @classmethod
    def create(cls, arg : "RuleVariation_1270.cv_arg") -> "RuleVariation_1270":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1348:
        return self.arg # type: ignore

class NonSpare_373(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1270.cv_arg
    cv_name = "170"
    cv_title = "Track Status"
    cv_rule: TypeAlias = RuleVariation_1270

    @classmethod
    def create(cls, arg : "NonSpare_373.cv_arg") -> "NonSpare_373":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1270:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1348:
        return self.rule.variation

class UapItem_373(UapItem):
    cv_non_spare: TypeAlias = NonSpare_373

class NonSpare_412(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1368.cv_arg
    cv_name = "210"
    cv_title = "Track Quality"
    cv_rule: TypeAlias = RuleVariation_1368

    @classmethod
    def create(cls, arg : "NonSpare_412.cv_arg") -> "NonSpare_412":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1368:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1446:
        return self.rule.variation

class UapItem_412(UapItem):
    cv_non_spare: TypeAlias = NonSpare_412

class Record_18(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_35.cv_arg,
        "020": NonSpare_86.cv_arg,
        "161": NonSpare_361.cv_arg,
        "040": NonSpare_136.cv_arg,
        "042": NonSpare_157.cv_arg,
        "200": NonSpare_384.cv_arg,
        "070": NonSpare_209.cv_arg,
        "090": NonSpare_249.cv_arg,
        "141": NonSpare_332.cv_arg,
        "130": NonSpare_307.cv_arg,
        "131": NonSpare_311.cv_arg,
        "120": NonSpare_295.cv_arg,
        "170": NonSpare_373.cv_arg,
        "210": NonSpare_412.cv_arg,
        "050": NonSpare_171.cv_arg,
        "080": NonSpare_229.cv_arg,
        "100": NonSpare_270.cv_arg,
        "060": NonSpare_186.cv_arg,
        "030": NonSpare_115.cv_arg,
        "SP": NonSpare_1721.cv_arg,
        "150": NonSpare_341.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_35.cv_arg],
        Tuple[Literal["020"], NonSpare_86.cv_arg],
        Tuple[Literal["161"], NonSpare_361.cv_arg],
        Tuple[Literal["040"], NonSpare_136.cv_arg],
        Tuple[Literal["042"], NonSpare_157.cv_arg],
        Tuple[Literal["200"], NonSpare_384.cv_arg],
        Tuple[Literal["070"], NonSpare_209.cv_arg],
        Tuple[Literal["090"], NonSpare_249.cv_arg],
        Tuple[Literal["141"], NonSpare_332.cv_arg],
        Tuple[Literal["130"], NonSpare_307.cv_arg],
        Tuple[Literal["131"], NonSpare_311.cv_arg],
        Tuple[Literal["120"], NonSpare_295.cv_arg],
        Tuple[Literal["170"], NonSpare_373.cv_arg],
        Tuple[Literal["210"], NonSpare_412.cv_arg],
        Tuple[Literal["050"], NonSpare_171.cv_arg],
        Tuple[Literal["080"], NonSpare_229.cv_arg],
        Tuple[Literal["100"], NonSpare_270.cv_arg],
        Tuple[Literal["060"], NonSpare_186.cv_arg],
        Tuple[Literal["030"], NonSpare_115.cv_arg],
        Tuple[Literal["SP"], NonSpare_1721.cv_arg],
        Tuple[Literal["150"], NonSpare_341.cv_arg],
    ]
    cv_fspec_max_bytes = 4
    cv_items_list = [UapItem_35, UapItem_86, UapItem_361, UapItem_136, UapItem_157, UapItem_384, UapItem_209, UapItem_249, UapItem_332, UapItem_307, UapItem_311, UapItem_295, UapItem_373, UapItem_412, UapItem_171, UapItem_229, UapItem_270, UapItem_186, UapItem_115, UapItem_543, UapItem_545, UapItem_341]
    cv_items_dict = {"010": NonSpare_35, "020": NonSpare_86, "161": NonSpare_361, "040": NonSpare_136, "042": NonSpare_157, "200": NonSpare_384, "070": NonSpare_209, "090": NonSpare_249, "141": NonSpare_332, "130": NonSpare_307, "131": NonSpare_311, "120": NonSpare_295, "170": NonSpare_373, "210": NonSpare_412, "050": NonSpare_171, "080": NonSpare_229, "100": NonSpare_270, "060": NonSpare_186, "030": NonSpare_115, "SP": NonSpare_1721, "150": NonSpare_341}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_35:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_86:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["161"]) -> NonSpare_361:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> NonSpare_136:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["042"]) -> NonSpare_157:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["200"]) -> NonSpare_384:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> NonSpare_209:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> NonSpare_249:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["141"]) -> NonSpare_332:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["130"]) -> NonSpare_307:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["131"]) -> NonSpare_311:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> NonSpare_295:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["170"]) -> NonSpare_373:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["210"]) -> NonSpare_412:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> NonSpare_171:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> NonSpare_229:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_270:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_186:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> NonSpare_115:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1721:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["150"]) -> NonSpare_341:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["020"], Literal["161"], Literal["040"], Literal["042"], Literal["200"], Literal["070"], Literal["090"], Literal["141"], Literal["130"], Literal["131"], Literal["120"], Literal["170"], Literal["210"], Literal["050"], Literal["080"], Literal["100"], Literal["060"], Literal["030"], Literal["SP"], Literal["150"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_35]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_86]:
        ...
    @overload
    def get_item(self, key : Literal["161"]) -> Optional[NonSpare_361]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_136]:
        ...
    @overload
    def get_item(self, key : Literal["042"]) -> Optional[NonSpare_157]:
        ...
    @overload
    def get_item(self, key : Literal["200"]) -> Optional[NonSpare_384]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_209]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_249]:
        ...
    @overload
    def get_item(self, key : Literal["141"]) -> Optional[NonSpare_332]:
        ...
    @overload
    def get_item(self, key : Literal["130"]) -> Optional[NonSpare_307]:
        ...
    @overload
    def get_item(self, key : Literal["131"]) -> Optional[NonSpare_311]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_295]:
        ...
    @overload
    def get_item(self, key : Literal["170"]) -> Optional[NonSpare_373]:
        ...
    @overload
    def get_item(self, key : Literal["210"]) -> Optional[NonSpare_412]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_171]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_229]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_270]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_186]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_115]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1721]:
        ...
    @overload
    def get_item(self, key : Literal["150"]) -> Optional[NonSpare_341]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_35.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_86.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["161"], val : NonSpare_361.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_136.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["042"], val : NonSpare_157.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["200"], val : NonSpare_384.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_209.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_249.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["141"], val : NonSpare_332.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["130"], val : NonSpare_307.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["131"], val : NonSpare_311.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_295.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["170"], val : NonSpare_373.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["210"], val : NonSpare_412.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_171.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_229.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_270.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_186.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_115.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1721.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["150"], val : NonSpare_341.cv_arg) -> 'Record_18':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["161"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["042"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["200"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["141"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["130"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["131"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["170"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["210"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["150"]) -> 'Record_18':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_35]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_86]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["161"]) -> List[NonSpare_361]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["040"]) -> List[NonSpare_136]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["042"]) -> List[NonSpare_157]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["200"]) -> List[NonSpare_384]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["070"]) -> List[NonSpare_209]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_249]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["141"]) -> List[NonSpare_332]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["130"]) -> List[NonSpare_307]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["131"]) -> List[NonSpare_311]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["120"]) -> List[NonSpare_295]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["170"]) -> List[NonSpare_373]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["210"]) -> List[NonSpare_412]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_171]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["080"]) -> List[NonSpare_229]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_270]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["060"]) -> List[NonSpare_186]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["030"]) -> List[NonSpare_115]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1721]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["150"]) -> List[NonSpare_341]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_18.cv_arg", rfs : Optional[List["Record_18.cv_union"]] = None) -> 'Record_18':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_18", Bits]]:
        return cls._parse(bs) # type: ignore

class Uap_47(UapMultiple):
    cv_arg: TypeAlias = Union[Record_17, Record_18]
    cv_uaps = {"plot": Record_17, "track": Record_18}
    cv_selector = (["020", "TYP"], {0: "plot", 1: "track"})

    @overload
    @classmethod
    def spec(cls, key : Literal["plot"]) -> Record_17:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["track"]) -> Record_18:
        ...
    @classmethod
    def spec(cls, key : Any) -> Any:
        return cls._spec(key)

    @overload
    @classmethod
    def parse(cls, uap : Literal["plot"], bs : Bits) -> Union[ValueError, List[Record_17]]:
        ...
    @overload
    @classmethod
    def parse(cls, uap : Literal["track"], bs : Bits) -> Union[ValueError, List[Record_18]]:
        ...
    @classmethod
    def parse(cls, uap : str, bs : Bits) -> Any:
        return cls._parse(uap, bs)

    @classmethod
    def parse_any_uap(cls, bs : Bits) -> "List[List[Uap_47.cv_arg]]":
        return cls._parse_any_uap(bs)

class Asterix_0(AstCat):
    cv_category = 1
    cv_edition = (1, 2)
    cv_uap: TypeAlias = Uap_47

    @classmethod
    def create(cls, records : List[Uap_47.cv_arg]) -> "Asterix_0":
        return cls._create(records) # type: ignore

class NonSpare_36(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1135.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1135

    @classmethod
    def create(cls, arg : "NonSpare_36.cv_arg") -> "NonSpare_36":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1135:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1187:
        return self.rule.variation

class UapItem_36(UapItem):
    cv_non_spare: TypeAlias = NonSpare_36

class Record_24(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_36.cv_arg,
        "020": NonSpare_86.cv_arg,
        "040": NonSpare_136.cv_arg,
        "070": NonSpare_209.cv_arg,
        "090": NonSpare_249.cv_arg,
        "130": NonSpare_307.cv_arg,
        "141": NonSpare_332.cv_arg,
        "050": NonSpare_171.cv_arg,
        "120": NonSpare_295.cv_arg,
        "131": NonSpare_311.cv_arg,
        "080": NonSpare_229.cv_arg,
        "100": NonSpare_270.cv_arg,
        "060": NonSpare_186.cv_arg,
        "030": NonSpare_115.cv_arg,
        "150": NonSpare_341.cv_arg,
        "SP": NonSpare_1721.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_36.cv_arg],
        Tuple[Literal["020"], NonSpare_86.cv_arg],
        Tuple[Literal["040"], NonSpare_136.cv_arg],
        Tuple[Literal["070"], NonSpare_209.cv_arg],
        Tuple[Literal["090"], NonSpare_249.cv_arg],
        Tuple[Literal["130"], NonSpare_307.cv_arg],
        Tuple[Literal["141"], NonSpare_332.cv_arg],
        Tuple[Literal["050"], NonSpare_171.cv_arg],
        Tuple[Literal["120"], NonSpare_295.cv_arg],
        Tuple[Literal["131"], NonSpare_311.cv_arg],
        Tuple[Literal["080"], NonSpare_229.cv_arg],
        Tuple[Literal["100"], NonSpare_270.cv_arg],
        Tuple[Literal["060"], NonSpare_186.cv_arg],
        Tuple[Literal["030"], NonSpare_115.cv_arg],
        Tuple[Literal["150"], NonSpare_341.cv_arg],
        Tuple[Literal["SP"], NonSpare_1721.cv_arg],
    ]
    cv_fspec_max_bytes = 3
    cv_items_list = [UapItem_36, UapItem_86, UapItem_136, UapItem_209, UapItem_249, UapItem_307, UapItem_332, UapItem_171, UapItem_295, UapItem_311, UapItem_229, UapItem_270, UapItem_186, UapItem_115, UapItem_341, UapItem_544, UapItem_544, UapItem_544, UapItem_544, UapItem_543, UapItem_545]
    cv_items_dict = {"010": NonSpare_36, "020": NonSpare_86, "040": NonSpare_136, "070": NonSpare_209, "090": NonSpare_249, "130": NonSpare_307, "141": NonSpare_332, "050": NonSpare_171, "120": NonSpare_295, "131": NonSpare_311, "080": NonSpare_229, "100": NonSpare_270, "060": NonSpare_186, "030": NonSpare_115, "150": NonSpare_341, "SP": NonSpare_1721}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_36:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_86:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> NonSpare_136:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> NonSpare_209:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> NonSpare_249:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["130"]) -> NonSpare_307:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["141"]) -> NonSpare_332:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> NonSpare_171:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> NonSpare_295:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["131"]) -> NonSpare_311:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> NonSpare_229:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_270:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_186:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> NonSpare_115:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["150"]) -> NonSpare_341:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1721:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["020"], Literal["040"], Literal["070"], Literal["090"], Literal["130"], Literal["141"], Literal["050"], Literal["120"], Literal["131"], Literal["080"], Literal["100"], Literal["060"], Literal["030"], Literal["150"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_36]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_86]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_136]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_209]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_249]:
        ...
    @overload
    def get_item(self, key : Literal["130"]) -> Optional[NonSpare_307]:
        ...
    @overload
    def get_item(self, key : Literal["141"]) -> Optional[NonSpare_332]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_171]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_295]:
        ...
    @overload
    def get_item(self, key : Literal["131"]) -> Optional[NonSpare_311]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_229]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_270]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_186]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_115]:
        ...
    @overload
    def get_item(self, key : Literal["150"]) -> Optional[NonSpare_341]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1721]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_36.cv_arg) -> 'Record_24':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_86.cv_arg) -> 'Record_24':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_136.cv_arg) -> 'Record_24':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_209.cv_arg) -> 'Record_24':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_249.cv_arg) -> 'Record_24':
        ...
    @overload
    def set_item(self, key : Literal["130"], val : NonSpare_307.cv_arg) -> 'Record_24':
        ...
    @overload
    def set_item(self, key : Literal["141"], val : NonSpare_332.cv_arg) -> 'Record_24':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_171.cv_arg) -> 'Record_24':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_295.cv_arg) -> 'Record_24':
        ...
    @overload
    def set_item(self, key : Literal["131"], val : NonSpare_311.cv_arg) -> 'Record_24':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_229.cv_arg) -> 'Record_24':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_270.cv_arg) -> 'Record_24':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_186.cv_arg) -> 'Record_24':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_115.cv_arg) -> 'Record_24':
        ...
    @overload
    def set_item(self, key : Literal["150"], val : NonSpare_341.cv_arg) -> 'Record_24':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1721.cv_arg) -> 'Record_24':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_24':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_24':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_24':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_24':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_24':
        ...
    @overload
    def del_item(self, key : Literal["130"]) -> 'Record_24':
        ...
    @overload
    def del_item(self, key : Literal["141"]) -> 'Record_24':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_24':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_24':
        ...
    @overload
    def del_item(self, key : Literal["131"]) -> 'Record_24':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_24':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_24':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_24':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_24':
        ...
    @overload
    def del_item(self, key : Literal["150"]) -> 'Record_24':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_24':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_36]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_86]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["040"]) -> List[NonSpare_136]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["070"]) -> List[NonSpare_209]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_249]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["130"]) -> List[NonSpare_307]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["141"]) -> List[NonSpare_332]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_171]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["120"]) -> List[NonSpare_295]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["131"]) -> List[NonSpare_311]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["080"]) -> List[NonSpare_229]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_270]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["060"]) -> List[NonSpare_186]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["030"]) -> List[NonSpare_115]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["150"]) -> List[NonSpare_341]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1721]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_24.cv_arg", rfs : Optional[List["Record_24.cv_union"]] = None) -> 'Record_24':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_24", Bits]]:
        return cls._parse(bs) # type: ignore

class Record_25(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_36.cv_arg,
        "020": NonSpare_86.cv_arg,
        "161": NonSpare_361.cv_arg,
        "040": NonSpare_136.cv_arg,
        "042": NonSpare_157.cv_arg,
        "200": NonSpare_384.cv_arg,
        "070": NonSpare_209.cv_arg,
        "090": NonSpare_249.cv_arg,
        "141": NonSpare_332.cv_arg,
        "130": NonSpare_307.cv_arg,
        "131": NonSpare_311.cv_arg,
        "120": NonSpare_295.cv_arg,
        "170": NonSpare_373.cv_arg,
        "210": NonSpare_412.cv_arg,
        "050": NonSpare_171.cv_arg,
        "080": NonSpare_229.cv_arg,
        "100": NonSpare_270.cv_arg,
        "060": NonSpare_186.cv_arg,
        "030": NonSpare_115.cv_arg,
        "SP": NonSpare_1721.cv_arg,
        "150": NonSpare_341.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_36.cv_arg],
        Tuple[Literal["020"], NonSpare_86.cv_arg],
        Tuple[Literal["161"], NonSpare_361.cv_arg],
        Tuple[Literal["040"], NonSpare_136.cv_arg],
        Tuple[Literal["042"], NonSpare_157.cv_arg],
        Tuple[Literal["200"], NonSpare_384.cv_arg],
        Tuple[Literal["070"], NonSpare_209.cv_arg],
        Tuple[Literal["090"], NonSpare_249.cv_arg],
        Tuple[Literal["141"], NonSpare_332.cv_arg],
        Tuple[Literal["130"], NonSpare_307.cv_arg],
        Tuple[Literal["131"], NonSpare_311.cv_arg],
        Tuple[Literal["120"], NonSpare_295.cv_arg],
        Tuple[Literal["170"], NonSpare_373.cv_arg],
        Tuple[Literal["210"], NonSpare_412.cv_arg],
        Tuple[Literal["050"], NonSpare_171.cv_arg],
        Tuple[Literal["080"], NonSpare_229.cv_arg],
        Tuple[Literal["100"], NonSpare_270.cv_arg],
        Tuple[Literal["060"], NonSpare_186.cv_arg],
        Tuple[Literal["030"], NonSpare_115.cv_arg],
        Tuple[Literal["SP"], NonSpare_1721.cv_arg],
        Tuple[Literal["150"], NonSpare_341.cv_arg],
    ]
    cv_fspec_max_bytes = 4
    cv_items_list = [UapItem_36, UapItem_86, UapItem_361, UapItem_136, UapItem_157, UapItem_384, UapItem_209, UapItem_249, UapItem_332, UapItem_307, UapItem_311, UapItem_295, UapItem_373, UapItem_412, UapItem_171, UapItem_229, UapItem_270, UapItem_186, UapItem_115, UapItem_543, UapItem_545, UapItem_341]
    cv_items_dict = {"010": NonSpare_36, "020": NonSpare_86, "161": NonSpare_361, "040": NonSpare_136, "042": NonSpare_157, "200": NonSpare_384, "070": NonSpare_209, "090": NonSpare_249, "141": NonSpare_332, "130": NonSpare_307, "131": NonSpare_311, "120": NonSpare_295, "170": NonSpare_373, "210": NonSpare_412, "050": NonSpare_171, "080": NonSpare_229, "100": NonSpare_270, "060": NonSpare_186, "030": NonSpare_115, "SP": NonSpare_1721, "150": NonSpare_341}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_36:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_86:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["161"]) -> NonSpare_361:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> NonSpare_136:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["042"]) -> NonSpare_157:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["200"]) -> NonSpare_384:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> NonSpare_209:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> NonSpare_249:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["141"]) -> NonSpare_332:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["130"]) -> NonSpare_307:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["131"]) -> NonSpare_311:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> NonSpare_295:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["170"]) -> NonSpare_373:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["210"]) -> NonSpare_412:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> NonSpare_171:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> NonSpare_229:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_270:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_186:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> NonSpare_115:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1721:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["150"]) -> NonSpare_341:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["020"], Literal["161"], Literal["040"], Literal["042"], Literal["200"], Literal["070"], Literal["090"], Literal["141"], Literal["130"], Literal["131"], Literal["120"], Literal["170"], Literal["210"], Literal["050"], Literal["080"], Literal["100"], Literal["060"], Literal["030"], Literal["SP"], Literal["150"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_36]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_86]:
        ...
    @overload
    def get_item(self, key : Literal["161"]) -> Optional[NonSpare_361]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_136]:
        ...
    @overload
    def get_item(self, key : Literal["042"]) -> Optional[NonSpare_157]:
        ...
    @overload
    def get_item(self, key : Literal["200"]) -> Optional[NonSpare_384]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_209]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_249]:
        ...
    @overload
    def get_item(self, key : Literal["141"]) -> Optional[NonSpare_332]:
        ...
    @overload
    def get_item(self, key : Literal["130"]) -> Optional[NonSpare_307]:
        ...
    @overload
    def get_item(self, key : Literal["131"]) -> Optional[NonSpare_311]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_295]:
        ...
    @overload
    def get_item(self, key : Literal["170"]) -> Optional[NonSpare_373]:
        ...
    @overload
    def get_item(self, key : Literal["210"]) -> Optional[NonSpare_412]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_171]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_229]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_270]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_186]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_115]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1721]:
        ...
    @overload
    def get_item(self, key : Literal["150"]) -> Optional[NonSpare_341]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_36.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_86.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["161"], val : NonSpare_361.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_136.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["042"], val : NonSpare_157.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["200"], val : NonSpare_384.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_209.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_249.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["141"], val : NonSpare_332.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["130"], val : NonSpare_307.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["131"], val : NonSpare_311.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_295.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["170"], val : NonSpare_373.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["210"], val : NonSpare_412.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_171.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_229.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_270.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_186.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_115.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1721.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["150"], val : NonSpare_341.cv_arg) -> 'Record_25':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["161"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["042"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["200"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["141"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["130"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["131"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["170"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["210"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["150"]) -> 'Record_25':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_36]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_86]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["161"]) -> List[NonSpare_361]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["040"]) -> List[NonSpare_136]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["042"]) -> List[NonSpare_157]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["200"]) -> List[NonSpare_384]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["070"]) -> List[NonSpare_209]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_249]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["141"]) -> List[NonSpare_332]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["130"]) -> List[NonSpare_307]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["131"]) -> List[NonSpare_311]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["120"]) -> List[NonSpare_295]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["170"]) -> List[NonSpare_373]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["210"]) -> List[NonSpare_412]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_171]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["080"]) -> List[NonSpare_229]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_270]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["060"]) -> List[NonSpare_186]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["030"]) -> List[NonSpare_115]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1721]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["150"]) -> List[NonSpare_341]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_25.cv_arg", rfs : Optional[List["Record_25.cv_union"]] = None) -> 'Record_25':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_25", Bits]]:
        return cls._parse(bs) # type: ignore

class Uap_48(UapMultiple):
    cv_arg: TypeAlias = Union[Record_24, Record_25]
    cv_uaps = {"plot": Record_24, "track": Record_25}
    cv_selector = (["020", "TYP"], {0: "plot", 1: "track"})

    @overload
    @classmethod
    def spec(cls, key : Literal["plot"]) -> Record_24:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["track"]) -> Record_25:
        ...
    @classmethod
    def spec(cls, key : Any) -> Any:
        return cls._spec(key)

    @overload
    @classmethod
    def parse(cls, uap : Literal["plot"], bs : Bits) -> Union[ValueError, List[Record_24]]:
        ...
    @overload
    @classmethod
    def parse(cls, uap : Literal["track"], bs : Bits) -> Union[ValueError, List[Record_25]]:
        ...
    @classmethod
    def parse(cls, uap : str, bs : Bits) -> Any:
        return cls._parse(uap, bs)

    @classmethod
    def parse_any_uap(cls, bs : Bits) -> "List[List[Uap_48.cv_arg]]":
        return cls._parse_any_uap(bs)

class Asterix_1(AstCat):
    cv_category = 1
    cv_edition = (1, 3)
    cv_uap: TypeAlias = Uap_48

    @classmethod
    def create(cls, records : List[Uap_48.cv_arg]) -> "Asterix_1":
        return cls._create(records) # type: ignore

class Asterix_2(AstCat):
    cv_category = 1
    cv_edition = (1, 4)
    cv_uap: TypeAlias = Uap_48

    @classmethod
    def create(cls, records : List[Uap_48.cv_arg]) -> "Asterix_2":
        return cls._create(records) # type: ignore

class NonSpare_46(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1135.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1135

    @classmethod
    def create(cls, arg : "NonSpare_46.cv_arg") -> "NonSpare_46":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1135:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1187:
        return self.rule.variation

class UapItem_46(UapItem):
    cv_non_spare: TypeAlias = NonSpare_46

class Content_587(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "North marker message", 2: "Sector crossing message", 3: "South marker message", 8: "Activation of blind zone filtering", 9: "Stop of blind zone filtering"}

class RuleContent_587(RuleContentContextFree):
    cv_arg: TypeAlias = Content_587.cv_arg
    cv_content: TypeAlias = Content_587

    @property
    def content(self) -> Content_587:
        return self._get_content() # type: ignore

class Variation_188(Element):
    cv_arg: TypeAlias = RuleContent_587.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_587

    @classmethod
    def create(cls, arg: "Variation_188.cv_arg") -> "Variation_188":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_587:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_587:
        return self.rule.content

class RuleVariation_181(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_188.cv_arg
    cv_variation: TypeAlias = Variation_188

    @classmethod
    def create(cls, arg : "RuleVariation_181.cv_arg") -> "RuleVariation_181":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_188:
        return self.arg # type: ignore

class NonSpare_6(NonSpare):
    cv_arg: TypeAlias = RuleVariation_181.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_181

    @classmethod
    def create(cls, arg : "NonSpare_6.cv_arg") -> "NonSpare_6":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_181:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_188:
        return self.rule.variation

class UapItem_6(UapItem):
    cv_non_spare: TypeAlias = NonSpare_6

class Content_787(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 1.40625
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_786(RuleContentContextFree):
    cv_arg: TypeAlias = Content_787.cv_arg
    cv_content: TypeAlias = Content_787

    @property
    def content(self) -> Content_787:
        return self._get_content() # type: ignore

class Variation_241(Element):
    cv_arg: TypeAlias = RuleContent_786.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_786

    @classmethod
    def create(cls, arg: "Variation_241.cv_arg") -> "Variation_241":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_786:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_787:
        return self.rule.content

class RuleVariation_234(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_241.cv_arg
    cv_variation: TypeAlias = Variation_241

    @classmethod
    def create(cls, arg : "RuleVariation_234.cv_arg") -> "RuleVariation_234":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_241:
        return self.arg # type: ignore

class NonSpare_80(NonSpare):
    cv_arg: TypeAlias = RuleVariation_234.cv_arg
    cv_name = "020"
    cv_title = "Sector Number"
    cv_rule: TypeAlias = RuleVariation_234

    @classmethod
    def create(cls, arg : "NonSpare_80.cv_arg") -> "NonSpare_80":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_234:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_241:
        return self.rule.variation

class UapItem_80(UapItem):
    cv_non_spare: TypeAlias = NonSpare_80

class Variation_368(Element):
    cv_arg: TypeAlias = RuleContent_766.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_rule = RuleContent_766

    @classmethod
    def create(cls, arg: "Variation_368.cv_arg") -> "Variation_368":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_766:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_767:
        return self.rule.content

class RuleVariation_361(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_368.cv_arg
    cv_variation: TypeAlias = Variation_368

    @classmethod
    def create(cls, arg : "RuleVariation_361.cv_arg") -> "RuleVariation_361":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_368:
        return self.arg # type: ignore

class NonSpare_107(NonSpare):
    cv_arg: TypeAlias = RuleVariation_361.cv_arg
    cv_name = "030"
    cv_title = "Time of Day"
    cv_rule: TypeAlias = RuleVariation_361

    @classmethod
    def create(cls, arg : "NonSpare_107.cv_arg") -> "NonSpare_107":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_361:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_368:
        return self.rule.variation

class UapItem_107(UapItem):
    cv_non_spare: TypeAlias = NonSpare_107

class NonSpare_150(NonSpare):
    cv_arg: TypeAlias = RuleVariation_325.cv_arg
    cv_name = "041"
    cv_title = "Antenna Rotation Speed"
    cv_rule: TypeAlias = RuleVariation_325

    @classmethod
    def create(cls, arg : "NonSpare_150.cv_arg") -> "NonSpare_150":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_325:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_332:
        return self.rule.variation

class UapItem_150(UapItem):
    cv_non_spare: TypeAlias = NonSpare_150

class NonSpare_177(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1368.cv_arg
    cv_name = "050"
    cv_title = "Station Configuration Status"
    cv_rule: TypeAlias = RuleVariation_1368

    @classmethod
    def create(cls, arg : "NonSpare_177.cv_arg") -> "NonSpare_177":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1368:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1446:
        return self.rule.variation

class UapItem_177(UapItem):
    cv_non_spare: TypeAlias = NonSpare_177

class NonSpare_194(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1368.cv_arg
    cv_name = "060"
    cv_title = "Station Processing Mode"
    cv_rule: TypeAlias = RuleVariation_1368

    @classmethod
    def create(cls, arg : "NonSpare_194.cv_arg") -> "NonSpare_194":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1368:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1446:
        return self.rule.variation

class UapItem_194(UapItem):
    cv_non_spare: TypeAlias = NonSpare_194

class Content_69(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Counter for antenna 1", 1: "Counter for antenna 2"}

class RuleContent_69(RuleContentContextFree):
    cv_arg: TypeAlias = Content_69.cv_arg
    cv_content: TypeAlias = Content_69

    @property
    def content(self) -> Content_69:
        return self._get_content() # type: ignore

class Variation_21(Element):
    cv_arg: TypeAlias = RuleContent_69.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_69

    @classmethod
    def create(cls, arg: "Variation_21.cv_arg") -> "Variation_21":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_69:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_69:
        return self.rule.content

class RuleVariation_21(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_21.cv_arg
    cv_variation: TypeAlias = Variation_21

    @classmethod
    def create(cls, arg : "RuleVariation_21.cv_arg") -> "RuleVariation_21":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_21:
        return self.arg # type: ignore

class NonSpare_543(NonSpare):
    cv_arg: TypeAlias = RuleVariation_21.cv_arg
    cv_name = "A"
    cv_title = "Aerial Identification"
    cv_rule: TypeAlias = RuleVariation_21

    @classmethod
    def create(cls, arg : "NonSpare_543.cv_arg") -> "NonSpare_543":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_21:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_21:
        return self.rule.variation

class Item_33(Item):
    cv_arg: TypeAlias = NonSpare_543.cv_arg
    cv_non_spare: TypeAlias = NonSpare_543

    @classmethod
    def create(cls, arg : "Item_33.cv_arg") -> "Item_33":
        return cls._create(arg) # type: ignore

class Content_592(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Sole primary plots", 2: "Sole SSR plots", 3: "Combined plots"}

class RuleContent_592(RuleContentContextFree):
    cv_arg: TypeAlias = Content_592.cv_arg
    cv_content: TypeAlias = Content_592

    @property
    def content(self) -> Content_592:
        return self._get_content() # type: ignore

class Variation_488(Element):
    cv_arg: TypeAlias = RuleContent_592.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 5
    cv_rule = RuleContent_592

    @classmethod
    def create(cls, arg: "Variation_488.cv_arg") -> "Variation_488":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_592:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_592:
        return self.rule.content

class RuleVariation_477(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_488.cv_arg
    cv_variation: TypeAlias = Variation_488

    @classmethod
    def create(cls, arg : "RuleVariation_477.cv_arg") -> "RuleVariation_477":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_488:
        return self.arg # type: ignore

class NonSpare_1105(NonSpare):
    cv_arg: TypeAlias = RuleVariation_477.cv_arg
    cv_name = "IDENT"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_477

    @classmethod
    def create(cls, arg : "NonSpare_1105.cv_arg") -> "NonSpare_1105":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_477:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_488:
        return self.rule.variation

class Item_428(Item):
    cv_arg: TypeAlias = NonSpare_1105.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1105

    @classmethod
    def create(cls, arg : "Item_428.cv_arg") -> "Item_428":
        return cls._create(arg) # type: ignore

class Content_610(ContentInteger):
    cv_arg: TypeAlias = int
    cv_signedness: TypeAlias = Unsigned

class RuleContent_610(RuleContentContextFree):
    cv_arg: TypeAlias = Content_610.cv_arg
    cv_content: TypeAlias = Content_610

    @property
    def content(self) -> Content_610:
        return self._get_content() # type: ignore

class Variation_964(Element):
    cv_arg: TypeAlias = RuleContent_610.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 10
    cv_rule = RuleContent_610

    @classmethod
    def create(cls, arg: "Variation_964.cv_arg") -> "Variation_964":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_610:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_610:
        return self.rule.content

class RuleVariation_934(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_964.cv_arg
    cv_variation: TypeAlias = Variation_964

    @classmethod
    def create(cls, arg : "RuleVariation_934.cv_arg") -> "RuleVariation_934":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_964:
        return self.arg # type: ignore

class NonSpare_794(NonSpare):
    cv_arg: TypeAlias = RuleVariation_934.cv_arg
    cv_name = "COUNTER"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_934

    @classmethod
    def create(cls, arg : "NonSpare_794.cv_arg") -> "NonSpare_794":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_934:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_964:
        return self.rule.variation

class Item_199(Item):
    cv_arg: TypeAlias = NonSpare_794.cv_arg
    cv_non_spare: TypeAlias = NonSpare_794

    @classmethod
    def create(cls, arg : "Item_199.cv_arg") -> "Item_199":
        return cls._create(arg) # type: ignore

class Variation_1041(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_21.cv_arg, Tuple[Literal["A"], RuleVariation_21.cv_arg]], Union[RuleVariation_477.cv_arg, Tuple[Literal["IDENT"], RuleVariation_477.cv_arg]], Union[RuleVariation_934.cv_arg, Tuple[Literal["COUNTER"], RuleVariation_934.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1041.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_33, 1), (Item_428, 5), (Item_199, 10)]
    cv_items_dict = {"A": RuleVariation_21, "IDENT": RuleVariation_477, "COUNTER": RuleVariation_934}

    @overload
    @classmethod
    def spec(cls, key : Literal["A"]) -> RuleVariation_21:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["IDENT"]) -> RuleVariation_477:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["COUNTER"]) -> RuleVariation_934:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["A"], Literal["IDENT"], Literal["COUNTER"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["A"]) -> RuleVariation_21:
        ...
    @overload
    def get_item(self, key : Literal["IDENT"]) -> RuleVariation_477:
        ...
    @overload
    def get_item(self, key : Literal["COUNTER"]) -> RuleVariation_934:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1041.cv_arg") -> 'Variation_1041':
        return cls._create(arg) # type: ignore

class Variation_1401(Repetitive):
    cv_arg: TypeAlias = List[Variation_1041.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1041

    @classmethod
    def create(cls, arg: "Variation_1401.cv_arg") -> 'Variation_1401':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1041]:
        return self._get_list() # type: ignore

class RuleVariation_1323(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1401.cv_arg
    cv_variation: TypeAlias = Variation_1401

    @classmethod
    def create(cls, arg : "RuleVariation_1323.cv_arg") -> "RuleVariation_1323":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1401:
        return self.arg # type: ignore

class NonSpare_212(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1323.cv_arg
    cv_name = "070"
    cv_title = "Plot Count Values"
    cv_rule: TypeAlias = RuleVariation_1323

    @classmethod
    def create(cls, arg : "NonSpare_212.cv_arg") -> "NonSpare_212":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1323:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1401:
        return self.rule.variation

class UapItem_212(UapItem):
    cv_non_spare: TypeAlias = NonSpare_212

class Content_764(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 7.8125e-3
    cv_unit = "NM"

    def as_quantity(self, cv_unit : Optional[Literal["NM"]] = None) -> float:
        return self._as_quantity()

class RuleContent_763(RuleContentContextFree):
    cv_arg: TypeAlias = Content_764.cv_arg
    cv_content: TypeAlias = Content_764

    @property
    def content(self) -> Content_764:
        return self._get_content() # type: ignore

class Variation_329(Element):
    cv_arg: TypeAlias = RuleContent_763.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_763

    @classmethod
    def create(cls, arg: "Variation_329.cv_arg") -> "Variation_329":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_763:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_764:
        return self.rule.content

class RuleVariation_322(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_329.cv_arg
    cv_variation: TypeAlias = Variation_329

    @classmethod
    def create(cls, arg : "RuleVariation_322.cv_arg") -> "RuleVariation_322":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_329:
        return self.arg # type: ignore

class NonSpare_1603(NonSpare):
    cv_arg: TypeAlias = RuleVariation_322.cv_arg
    cv_name = "RS"
    cv_title = "Rho Start"
    cv_rule: TypeAlias = RuleVariation_322

    @classmethod
    def create(cls, arg : "NonSpare_1603.cv_arg") -> "NonSpare_1603":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_322:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_329:
        return self.rule.variation

class Item_827(Item):
    cv_arg: TypeAlias = NonSpare_1603.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1603

    @classmethod
    def create(cls, arg : "Item_827.cv_arg") -> "Item_827":
        return cls._create(arg) # type: ignore

class NonSpare_1558(NonSpare):
    cv_arg: TypeAlias = RuleVariation_322.cv_arg
    cv_name = "RE"
    cv_title = "Rho End"
    cv_rule: TypeAlias = RuleVariation_322

    @classmethod
    def create(cls, arg : "NonSpare_1558.cv_arg") -> "NonSpare_1558":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_322:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_329:
        return self.rule.variation

class Item_789(Item):
    cv_arg: TypeAlias = NonSpare_1558.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1558

    @classmethod
    def create(cls, arg : "Item_789.cv_arg") -> "Item_789":
        return cls._create(arg) # type: ignore

class NonSpare_1915(NonSpare):
    cv_arg: TypeAlias = RuleVariation_334.cv_arg
    cv_name = "TS"
    cv_title = "Theta Start"
    cv_rule: TypeAlias = RuleVariation_334

    @classmethod
    def create(cls, arg : "NonSpare_1915.cv_arg") -> "NonSpare_1915":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_334:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_341:
        return self.rule.variation

class Item_1038(Item):
    cv_arg: TypeAlias = NonSpare_1915.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1915

    @classmethod
    def create(cls, arg : "Item_1038.cv_arg") -> "Item_1038":
        return cls._create(arg) # type: ignore

class NonSpare_1841(NonSpare):
    cv_arg: TypeAlias = RuleVariation_334.cv_arg
    cv_name = "TE"
    cv_title = "Theta End"
    cv_rule: TypeAlias = RuleVariation_334

    @classmethod
    def create(cls, arg : "NonSpare_1841.cv_arg") -> "NonSpare_1841":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_334:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_341:
        return self.rule.variation

class Item_986(Item):
    cv_arg: TypeAlias = NonSpare_1841.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1841

    @classmethod
    def create(cls, arg : "Item_986.cv_arg") -> "Item_986":
        return cls._create(arg) # type: ignore

class Variation_1180(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_322.cv_arg, Tuple[Literal["RS"], RuleVariation_322.cv_arg]], Union[RuleVariation_322.cv_arg, Tuple[Literal["RE"], RuleVariation_322.cv_arg]], Union[RuleVariation_334.cv_arg, Tuple[Literal["TS"], RuleVariation_334.cv_arg]], Union[RuleVariation_334.cv_arg, Tuple[Literal["TE"], RuleVariation_334.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1180.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 64
    cv_items_list = [(Item_827, 16), (Item_789, 16), (Item_1038, 16), (Item_986, 16)]
    cv_items_dict = {"RS": RuleVariation_322, "RE": RuleVariation_322, "TS": RuleVariation_334, "TE": RuleVariation_334}

    @overload
    @classmethod
    def spec(cls, key : Literal["RS"]) -> RuleVariation_322:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["RE"]) -> RuleVariation_322:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TS"]) -> RuleVariation_334:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TE"]) -> RuleVariation_334:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["RS"], Literal["RE"], Literal["TS"], Literal["TE"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["RS"]) -> RuleVariation_322:
        ...
    @overload
    def get_item(self, key : Literal["RE"]) -> RuleVariation_322:
        ...
    @overload
    def get_item(self, key : Literal["TS"]) -> RuleVariation_334:
        ...
    @overload
    def get_item(self, key : Literal["TE"]) -> RuleVariation_334:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1180.cv_arg") -> 'Variation_1180':
        return cls._create(arg) # type: ignore

class RuleVariation_1130(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1180.cv_arg
    cv_variation: TypeAlias = Variation_1180

    @classmethod
    def create(cls, arg : "RuleVariation_1130.cv_arg") -> "RuleVariation_1130":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1180:
        return self.arg # type: ignore

class NonSpare_265(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1130.cv_arg
    cv_name = "100"
    cv_title = "Dynamic Window Type 1"
    cv_rule: TypeAlias = RuleVariation_1130

    @classmethod
    def create(cls, arg : "NonSpare_265.cv_arg") -> "NonSpare_265":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1130:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1180:
        return self.rule.variation

class UapItem_265(UapItem):
    cv_non_spare: TypeAlias = NonSpare_265

class Content_674(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 7.8125e-3
    cv_unit = "NM"

    def as_quantity(self, cv_unit : Optional[Literal["NM"]] = None) -> float:
        return self._as_quantity()

class RuleContent_674(RuleContentContextFree):
    cv_arg: TypeAlias = Content_674.cv_arg
    cv_content: TypeAlias = Content_674

    @property
    def content(self) -> Content_674:
        return self._get_content() # type: ignore

class Variation_213(Element):
    cv_arg: TypeAlias = RuleContent_674.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_674

    @classmethod
    def create(cls, arg: "Variation_213.cv_arg") -> "Variation_213":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_674:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_674:
        return self.rule.content

class RuleVariation_206(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_213.cv_arg
    cv_variation: TypeAlias = Variation_213

    @classmethod
    def create(cls, arg : "RuleVariation_206.cv_arg") -> "RuleVariation_206":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_213:
        return self.arg # type: ignore

class NonSpare_1554(NonSpare):
    cv_arg: TypeAlias = RuleVariation_206.cv_arg
    cv_name = "RE"
    cv_title = "Range Error"
    cv_rule: TypeAlias = RuleVariation_206

    @classmethod
    def create(cls, arg : "NonSpare_1554.cv_arg") -> "NonSpare_1554":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_206:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_213:
        return self.rule.variation

class Item_786(Item):
    cv_arg: TypeAlias = NonSpare_1554.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1554

    @classmethod
    def create(cls, arg : "Item_786.cv_arg") -> "Item_786":
        return cls._create(arg) # type: ignore

class Content_705(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 2.197265625e-2
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_705(RuleContentContextFree):
    cv_arg: TypeAlias = Content_705.cv_arg
    cv_content: TypeAlias = Content_705

    @property
    def content(self) -> Content_705:
        return self._get_content() # type: ignore

class Variation_218(Element):
    cv_arg: TypeAlias = RuleContent_705.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_705

    @classmethod
    def create(cls, arg: "Variation_218.cv_arg") -> "Variation_218":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_705:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_705:
        return self.rule.content

class RuleVariation_211(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_218.cv_arg
    cv_variation: TypeAlias = Variation_218

    @classmethod
    def create(cls, arg : "RuleVariation_211.cv_arg") -> "RuleVariation_211":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_218:
        return self.arg # type: ignore

class NonSpare_574(NonSpare):
    cv_arg: TypeAlias = RuleVariation_211.cv_arg
    cv_name = "AE"
    cv_title = "Azimuth Error"
    cv_rule: TypeAlias = RuleVariation_211

    @classmethod
    def create(cls, arg : "NonSpare_574.cv_arg") -> "NonSpare_574":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_211:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_218:
        return self.rule.variation

class Item_49(Item):
    cv_arg: TypeAlias = NonSpare_574.cv_arg
    cv_non_spare: TypeAlias = NonSpare_574

    @classmethod
    def create(cls, arg : "Item_49.cv_arg") -> "Item_49":
        return cls._create(arg) # type: ignore

class Variation_1166(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_206.cv_arg, Tuple[Literal["RE"], RuleVariation_206.cv_arg]], Union[RuleVariation_211.cv_arg, Tuple[Literal["AE"], RuleVariation_211.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1166.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_786, 8), (Item_49, 8)]
    cv_items_dict = {"RE": RuleVariation_206, "AE": RuleVariation_211}

    @overload
    @classmethod
    def spec(cls, key : Literal["RE"]) -> RuleVariation_206:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AE"]) -> RuleVariation_211:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["RE"], Literal["AE"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["RE"]) -> RuleVariation_206:
        ...
    @overload
    def get_item(self, key : Literal["AE"]) -> RuleVariation_211:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1166.cv_arg") -> 'Variation_1166':
        return cls._create(arg) # type: ignore

class RuleVariation_1117(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1166.cv_arg
    cv_variation: TypeAlias = Variation_1166

    @classmethod
    def create(cls, arg : "RuleVariation_1117.cv_arg") -> "RuleVariation_1117":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1166:
        return self.arg # type: ignore

class NonSpare_240(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1117.cv_arg
    cv_name = "090"
    cv_title = "Collimation Error"
    cv_rule: TypeAlias = RuleVariation_1117

    @classmethod
    def create(cls, arg : "NonSpare_240.cv_arg") -> "NonSpare_240":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1117:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1166:
        return self.rule.variation

class UapItem_240(UapItem):
    cv_non_spare: TypeAlias = NonSpare_240

class NonSpare_238(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1368.cv_arg
    cv_name = "080"
    cv_title = "Warning/Error Conditions"
    cv_rule: TypeAlias = RuleVariation_1368

    @classmethod
    def create(cls, arg : "NonSpare_238.cv_arg") -> "NonSpare_238":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1368:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1446:
        return self.rule.variation

class UapItem_238(UapItem):
    cv_non_spare: TypeAlias = NonSpare_238

class Record_45(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_46.cv_arg,
        "000": NonSpare_6.cv_arg,
        "020": NonSpare_80.cv_arg,
        "030": NonSpare_107.cv_arg,
        "041": NonSpare_150.cv_arg,
        "050": NonSpare_177.cv_arg,
        "060": NonSpare_194.cv_arg,
        "070": NonSpare_212.cv_arg,
        "100": NonSpare_265.cv_arg,
        "090": NonSpare_240.cv_arg,
        "080": NonSpare_238.cv_arg,
        "SP": NonSpare_1721.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_46.cv_arg],
        Tuple[Literal["000"], NonSpare_6.cv_arg],
        Tuple[Literal["020"], NonSpare_80.cv_arg],
        Tuple[Literal["030"], NonSpare_107.cv_arg],
        Tuple[Literal["041"], NonSpare_150.cv_arg],
        Tuple[Literal["050"], NonSpare_177.cv_arg],
        Tuple[Literal["060"], NonSpare_194.cv_arg],
        Tuple[Literal["070"], NonSpare_212.cv_arg],
        Tuple[Literal["100"], NonSpare_265.cv_arg],
        Tuple[Literal["090"], NonSpare_240.cv_arg],
        Tuple[Literal["080"], NonSpare_238.cv_arg],
        Tuple[Literal["SP"], NonSpare_1721.cv_arg],
    ]
    cv_fspec_max_bytes = 2
    cv_items_list = [UapItem_46, UapItem_6, UapItem_80, UapItem_107, UapItem_150, UapItem_177, UapItem_194, UapItem_212, UapItem_265, UapItem_240, UapItem_238, UapItem_544, UapItem_543, UapItem_545]
    cv_items_dict = {"010": NonSpare_46, "000": NonSpare_6, "020": NonSpare_80, "030": NonSpare_107, "041": NonSpare_150, "050": NonSpare_177, "060": NonSpare_194, "070": NonSpare_212, "100": NonSpare_265, "090": NonSpare_240, "080": NonSpare_238, "SP": NonSpare_1721}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_46:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> NonSpare_6:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_80:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> NonSpare_107:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["041"]) -> NonSpare_150:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> NonSpare_177:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_194:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> NonSpare_212:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_265:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> NonSpare_240:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> NonSpare_238:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1721:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["020"], Literal["030"], Literal["041"], Literal["050"], Literal["060"], Literal["070"], Literal["100"], Literal["090"], Literal["080"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_46]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_6]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_80]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_107]:
        ...
    @overload
    def get_item(self, key : Literal["041"]) -> Optional[NonSpare_150]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_177]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_194]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_212]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_265]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_240]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_238]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1721]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_46.cv_arg) -> 'Record_45':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_6.cv_arg) -> 'Record_45':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_80.cv_arg) -> 'Record_45':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_107.cv_arg) -> 'Record_45':
        ...
    @overload
    def set_item(self, key : Literal["041"], val : NonSpare_150.cv_arg) -> 'Record_45':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_177.cv_arg) -> 'Record_45':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_194.cv_arg) -> 'Record_45':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_212.cv_arg) -> 'Record_45':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_265.cv_arg) -> 'Record_45':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_240.cv_arg) -> 'Record_45':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_238.cv_arg) -> 'Record_45':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1721.cv_arg) -> 'Record_45':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_45':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_45':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_45':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_45':
        ...
    @overload
    def del_item(self, key : Literal["041"]) -> 'Record_45':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_45':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_45':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_45':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_45':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_45':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_45':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_45':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_46]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["000"]) -> List[NonSpare_6]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_80]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["030"]) -> List[NonSpare_107]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["041"]) -> List[NonSpare_150]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_177]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["060"]) -> List[NonSpare_194]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["070"]) -> List[NonSpare_212]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_265]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_240]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["080"]) -> List[NonSpare_238]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1721]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_45.cv_arg", rfs : Optional[List["Record_45.cv_union"]] = None) -> 'Record_45':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_45", Bits]]:
        return cls._parse(bs) # type: ignore

class Uap_41(UapSingle):
    cv_arg: TypeAlias = Record_45
    cv_record: TypeAlias = Record_45

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_45]]:
        return cls._parse(bs)

class Asterix_3(AstCat):
    cv_category = 2
    cv_edition = (1, 0)
    cv_uap: TypeAlias = Uap_41
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_41.cv_arg]) -> "Asterix_3":
        return cls._create(records) # type: ignore

class NonSpare_37(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1135.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1135

    @classmethod
    def create(cls, arg : "NonSpare_37.cv_arg") -> "NonSpare_37":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1135:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1187:
        return self.rule.variation

class UapItem_37(UapItem):
    cv_non_spare: TypeAlias = NonSpare_37

class Record_26(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_37.cv_arg,
        "000": NonSpare_6.cv_arg,
        "020": NonSpare_80.cv_arg,
        "030": NonSpare_107.cv_arg,
        "041": NonSpare_150.cv_arg,
        "050": NonSpare_177.cv_arg,
        "060": NonSpare_194.cv_arg,
        "070": NonSpare_212.cv_arg,
        "100": NonSpare_265.cv_arg,
        "090": NonSpare_240.cv_arg,
        "080": NonSpare_238.cv_arg,
        "SP": NonSpare_1721.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_37.cv_arg],
        Tuple[Literal["000"], NonSpare_6.cv_arg],
        Tuple[Literal["020"], NonSpare_80.cv_arg],
        Tuple[Literal["030"], NonSpare_107.cv_arg],
        Tuple[Literal["041"], NonSpare_150.cv_arg],
        Tuple[Literal["050"], NonSpare_177.cv_arg],
        Tuple[Literal["060"], NonSpare_194.cv_arg],
        Tuple[Literal["070"], NonSpare_212.cv_arg],
        Tuple[Literal["100"], NonSpare_265.cv_arg],
        Tuple[Literal["090"], NonSpare_240.cv_arg],
        Tuple[Literal["080"], NonSpare_238.cv_arg],
        Tuple[Literal["SP"], NonSpare_1721.cv_arg],
    ]
    cv_fspec_max_bytes = 2
    cv_items_list = [UapItem_37, UapItem_6, UapItem_80, UapItem_107, UapItem_150, UapItem_177, UapItem_194, UapItem_212, UapItem_265, UapItem_240, UapItem_238, UapItem_544, UapItem_543, UapItem_545]
    cv_items_dict = {"010": NonSpare_37, "000": NonSpare_6, "020": NonSpare_80, "030": NonSpare_107, "041": NonSpare_150, "050": NonSpare_177, "060": NonSpare_194, "070": NonSpare_212, "100": NonSpare_265, "090": NonSpare_240, "080": NonSpare_238, "SP": NonSpare_1721}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_37:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> NonSpare_6:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_80:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> NonSpare_107:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["041"]) -> NonSpare_150:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> NonSpare_177:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_194:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> NonSpare_212:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_265:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> NonSpare_240:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> NonSpare_238:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1721:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["020"], Literal["030"], Literal["041"], Literal["050"], Literal["060"], Literal["070"], Literal["100"], Literal["090"], Literal["080"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_37]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_6]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_80]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_107]:
        ...
    @overload
    def get_item(self, key : Literal["041"]) -> Optional[NonSpare_150]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_177]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_194]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_212]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_265]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_240]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_238]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1721]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_37.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_6.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_80.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_107.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["041"], val : NonSpare_150.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_177.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_194.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_212.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_265.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_240.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_238.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1721.cv_arg) -> 'Record_26':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["041"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_26':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_37]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["000"]) -> List[NonSpare_6]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_80]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["030"]) -> List[NonSpare_107]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["041"]) -> List[NonSpare_150]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_177]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["060"]) -> List[NonSpare_194]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["070"]) -> List[NonSpare_212]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_265]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_240]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["080"]) -> List[NonSpare_238]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1721]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_26.cv_arg", rfs : Optional[List["Record_26.cv_union"]] = None) -> 'Record_26':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_26", Bits]]:
        return cls._parse(bs) # type: ignore

class Uap_22(UapSingle):
    cv_arg: TypeAlias = Record_26
    cv_record: TypeAlias = Record_26

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_26]]:
        return cls._parse(bs)

class Asterix_4(AstCat):
    cv_category = 2
    cv_edition = (1, 1)
    cv_uap: TypeAlias = Uap_22
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_22.cv_arg]) -> "Asterix_4":
        return cls._create(records) # type: ignore

class Asterix_5(AstCat):
    cv_category = 2
    cv_edition = (1, 2)
    cv_uap: TypeAlias = Uap_22
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_22.cv_arg]) -> "Asterix_5":
        return cls._create(records) # type: ignore

class NonSpare_33(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1135.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1135

    @classmethod
    def create(cls, arg : "NonSpare_33.cv_arg") -> "NonSpare_33":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1135:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1187:
        return self.rule.variation

class UapItem_33(UapItem):
    cv_non_spare: TypeAlias = NonSpare_33

class Content_573(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Alive Message (AM)", 2: "Route Adherence Monitor Longitudinal Deviation (RAMLD)", 3: "Route Adherence Monitor Heading Deviation (RAMHD)", 4: "Minimum Safe Altitude Warning (MSAW)", 5: "Area Proximity Warning (APW)", 6: "Clearance Level Adherence Monitor (CLAM)", 7: "Short Term Conflict Alert (STCA)", 8: "Approach Path Monitor (APM)", 9: "RIMCAS Arrival / Landing Monitor (ALM)", 10: "RIMCAS Arrival / Departure Wrong Runway Alert (WRA)", 11: "RIMCAS Arrival / Departure Opposite Traffic Alert (OTA)", 12: "RIMCAS Departure Monitor (RDM)", 13: "RIMCAS Runway / Taxiway Crossing Monitor (RCM)", 14: "RIMCAS Taxiway Separation Monitor (TSM)", 15: "RIMCAS Unauthorized Taxiway Movement Monitor(UTMM)", 16: "RIMCAS Stop Bar Overrun Alert (SBOA)", 17: "End Of Conflict (EOC)", 18: "ACAS Resolution Advisory (ACASRA)", 19: "Near Term Conflict Alert (NTCA)", 20: "Downlinked Barometric Pressure Setting Monitor (DBPSM)", 21: "Speed Adherence Monitor (SAM)", 22: "Outside Controlled Airspace Tool (OCAT)", 23: "Vertical Conflict Detection (VCD)", 24: "Vertical Rate Adherence Monitor (VRAM)", 25: "Cleared Heading Adherence Monitor (CHAM)", 26: "Downlinked Selected Altitude Monitor (DSAM)", 27: "Holding Adherence Monitor (HAM)", 28: "Vertical Path Monitor (VPM)", 29: "RIMCAS Taxiway Traffic Alert (TTA)", 30: "RIMCAS Arrival/Departure Close Runway Alert (CRA)", 31: "RIMCAS Arrival/Departure Aircraft Separation Monitor (ASM)", 32: "RIMCAS ILS Area Violation Monitor (IAVM)", 33: "Final Target Distance Indicator (FTD)", 34: "Initial Target Distance Indicator (ITD)", 35: "Wake Vortex Indicator Infringement Alert (IIA)", 36: "Sequence Warning (SQW)", 37: "Catch Up Warning (CUW)", 38: "Conflicting ATC Clearances (CATC)", 39: "No ATC Clearance (NOCLR)", 40: "Aircraft Not Moving despite ATC Clearance (NOMOV)", 41: "Aircraft leaving/entering the aerodrome area without proper handover (NOH)", 42: "Wrong Runway or Taxiway Type (WRTY)", 43: "Stand Occupied (STOCC)", 44: "Ongoing Alert (ONGOING)", 97: "Lost Track Warning (LTW)", 98: "Holding Volume Infringement (HVI)", 99: "Airspace Infringement Warning (AIW)"}

class RuleContent_573(RuleContentContextFree):
    cv_arg: TypeAlias = Content_573.cv_arg
    cv_content: TypeAlias = Content_573

    @property
    def content(self) -> Content_573:
        return self._get_content() # type: ignore

class Variation_178(Element):
    cv_arg: TypeAlias = RuleContent_573.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_573

    @classmethod
    def create(cls, arg: "Variation_178.cv_arg") -> "Variation_178":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_573:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_573:
        return self.rule.content

class RuleVariation_171(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_178.cv_arg
    cv_variation: TypeAlias = Variation_178

    @classmethod
    def create(cls, arg : "RuleVariation_171.cv_arg") -> "RuleVariation_171":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_178:
        return self.arg # type: ignore

class NonSpare_2(NonSpare):
    cv_arg: TypeAlias = RuleVariation_171.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_171

    @classmethod
    def create(cls, arg : "NonSpare_2.cv_arg") -> "NonSpare_2":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_171:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_178:
        return self.rule.variation

class UapItem_2(UapItem):
    cv_non_spare: TypeAlias = NonSpare_2

class Variation_1421(Repetitive):
    cv_arg: TypeAlias = List[Variation_1187.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1187

    @classmethod
    def create(cls, arg: "Variation_1421.cv_arg") -> 'Variation_1421':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1187]:
        return self._get_list() # type: ignore

class RuleVariation_1343(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1421.cv_arg
    cv_variation: TypeAlias = Variation_1421

    @classmethod
    def create(cls, arg : "RuleVariation_1343.cv_arg") -> "RuleVariation_1343":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1421:
        return self.arg # type: ignore

class NonSpare_57(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1343.cv_arg
    cv_name = "015"
    cv_title = "SDPS Identifier"
    cv_rule: TypeAlias = RuleVariation_1343

    @classmethod
    def create(cls, arg : "NonSpare_57.cv_arg") -> "NonSpare_57":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1343:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1421:
        return self.rule.variation

class UapItem_57(UapItem):
    cv_non_spare: TypeAlias = NonSpare_57

class NonSpare_92(NonSpare):
    cv_arg: TypeAlias = RuleVariation_361.cv_arg
    cv_name = "020"
    cv_title = "Time of Message"
    cv_rule: TypeAlias = RuleVariation_361

    @classmethod
    def create(cls, arg : "NonSpare_92.cv_arg") -> "NonSpare_92":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_361:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_368:
        return self.rule.variation

class UapItem_92(UapItem):
    cv_non_spare: TypeAlias = NonSpare_92

class NonSpare_134(NonSpare):
    cv_arg: TypeAlias = RuleVariation_244.cv_arg
    cv_name = "040"
    cv_title = "Alert Identifier"
    cv_rule: TypeAlias = RuleVariation_244

    @classmethod
    def create(cls, arg : "NonSpare_134.cv_arg") -> "NonSpare_134":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_244:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_251:
        return self.rule.variation

class UapItem_134(UapItem):
    cv_non_spare: TypeAlias = NonSpare_134

class Variation_771(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_771.cv_arg") -> "Variation_771":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_760(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_771.cv_arg
    cv_variation: TypeAlias = Variation_771

    @classmethod
    def create(cls, arg : "RuleVariation_760.cv_arg") -> "RuleVariation_760":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_771:
        return self.arg # type: ignore

class NonSpare_1772(NonSpare):
    cv_arg: TypeAlias = RuleVariation_760.cv_arg
    cv_name = "STAT"
    cv_title = "Status of the Alert"
    cv_rule: TypeAlias = RuleVariation_760

    @classmethod
    def create(cls, arg : "NonSpare_1772.cv_arg") -> "NonSpare_1772":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_760:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_771:
        return self.rule.variation

class Item_939(Item):
    cv_arg: TypeAlias = NonSpare_1772.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1772

    @classmethod
    def create(cls, arg : "Item_939.cv_arg") -> "Item_939":
        return cls._create(arg) # type: ignore

class Item_29(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 7
    cv_bit_size = 1

class Variation_1030(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_760.cv_arg, Tuple[Literal["STAT"], RuleVariation_760.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1030.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_3, 4), (Item_939, 3), (Item_29, 1)]
    cv_items_dict = {"STAT": RuleVariation_760}

    @classmethod
    def spec(cls, key : Literal["STAT"]) -> RuleVariation_760:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["STAT"]) -> RuleVariation_760:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1030.cv_arg") -> 'Variation_1030':
        return cls._create(arg) # type: ignore

class RuleVariation_998(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1030.cv_arg
    cv_variation: TypeAlias = Variation_1030

    @classmethod
    def create(cls, arg : "RuleVariation_998.cv_arg") -> "RuleVariation_998":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1030:
        return self.arg # type: ignore

class NonSpare_161(NonSpare):
    cv_arg: TypeAlias = RuleVariation_998.cv_arg
    cv_name = "045"
    cv_title = "Alert Status"
    cv_rule: TypeAlias = RuleVariation_998

    @classmethod
    def create(cls, arg : "NonSpare_161.cv_arg") -> "NonSpare_161":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_998:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1030:
        return self.rule.variation

class UapItem_161(UapItem):
    cv_non_spare: TypeAlias = NonSpare_161

class Content_114(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "MRVA function"}

class RuleContent_114(RuleContentContextFree):
    cv_arg: TypeAlias = Content_114.cv_arg
    cv_content: TypeAlias = Content_114

    @property
    def content(self) -> Content_114:
        return self._get_content() # type: ignore

class Variation_32(Element):
    cv_arg: TypeAlias = RuleContent_114.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_114

    @classmethod
    def create(cls, arg: "Variation_32.cv_arg") -> "Variation_32":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_114:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_114:
        return self.rule.content

class RuleVariation_32(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_32.cv_arg
    cv_variation: TypeAlias = Variation_32

    @classmethod
    def create(cls, arg : "RuleVariation_32.cv_arg") -> "RuleVariation_32":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_32:
        return self.arg # type: ignore

class Content_141(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "RAMLD function"}

class RuleContent_141(RuleContentContextFree):
    cv_arg: TypeAlias = Content_141.cv_arg
    cv_content: TypeAlias = Content_141

    @property
    def content(self) -> Content_141:
        return self._get_content() # type: ignore

class Variation_414(Element):
    cv_arg: TypeAlias = RuleContent_141.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_141

    @classmethod
    def create(cls, arg: "Variation_414.cv_arg") -> "Variation_414":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_141:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_141:
        return self.rule.content

class RuleVariation_403(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_414.cv_arg
    cv_variation: TypeAlias = Variation_414

    @classmethod
    def create(cls, arg : "RuleVariation_403.cv_arg") -> "RuleVariation_403":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_414:
        return self.arg # type: ignore

class Content_140(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "RAMHD function"}

class RuleContent_140(RuleContentContextFree):
    cv_arg: TypeAlias = Content_140.cv_arg
    cv_content: TypeAlias = Content_140

    @property
    def content(self) -> Content_140:
        return self._get_content() # type: ignore

class Variation_521(Element):
    cv_arg: TypeAlias = RuleContent_140.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_140

    @classmethod
    def create(cls, arg: "Variation_521.cv_arg") -> "Variation_521":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_140:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_140:
        return self.rule.content

class RuleVariation_510(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_521.cv_arg
    cv_variation: TypeAlias = Variation_521

    @classmethod
    def create(cls, arg : "RuleVariation_510.cv_arg") -> "RuleVariation_510":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_521:
        return self.arg # type: ignore

class Content_115(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "MSAW function"}

class RuleContent_115(RuleContentContextFree):
    cv_arg: TypeAlias = Content_115.cv_arg
    cv_content: TypeAlias = Content_115

    @property
    def content(self) -> Content_115:
        return self._get_content() # type: ignore

class Variation_623(Element):
    cv_arg: TypeAlias = RuleContent_115.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_115

    @classmethod
    def create(cls, arg: "Variation_623.cv_arg") -> "Variation_623":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_115:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_115:
        return self.rule.content

class RuleVariation_612(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_623.cv_arg
    cv_variation: TypeAlias = Variation_623

    @classmethod
    def create(cls, arg : "RuleVariation_612.cv_arg") -> "RuleVariation_612":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_623:
        return self.arg # type: ignore

class Content_82(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "APW function"}

class RuleContent_82(RuleContentContextFree):
    cv_arg: TypeAlias = Content_82.cv_arg
    cv_content: TypeAlias = Content_82

    @property
    def content(self) -> Content_82:
        return self._get_content() # type: ignore

class Variation_702(Element):
    cv_arg: TypeAlias = RuleContent_82.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_82

    @classmethod
    def create(cls, arg: "Variation_702.cv_arg") -> "Variation_702":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_82:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_82:
        return self.rule.content

class RuleVariation_691(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_702.cv_arg
    cv_variation: TypeAlias = Variation_702

    @classmethod
    def create(cls, arg : "RuleVariation_691.cv_arg") -> "RuleVariation_691":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_702:
        return self.arg # type: ignore

class Content_87(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "CLAM function"}

class RuleContent_87(RuleContentContextFree):
    cv_arg: TypeAlias = Content_87.cv_arg
    cv_content: TypeAlias = Content_87

    @property
    def content(self) -> Content_87:
        return self._get_content() # type: ignore

class Variation_827(Element):
    cv_arg: TypeAlias = RuleContent_87.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_87

    @classmethod
    def create(cls, arg: "Variation_827.cv_arg") -> "Variation_827":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_87:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_87:
        return self.rule.content

class RuleVariation_797(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_827.cv_arg
    cv_variation: TypeAlias = Variation_827

    @classmethod
    def create(cls, arg : "RuleVariation_797.cv_arg") -> "RuleVariation_797":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_827:
        return self.arg # type: ignore

class Content_149(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "STCA function"}

class RuleContent_149(RuleContentContextFree):
    cv_arg: TypeAlias = Content_149.cv_arg
    cv_content: TypeAlias = Content_149

    @property
    def content(self) -> Content_149:
        return self._get_content() # type: ignore

class Variation_916(Element):
    cv_arg: TypeAlias = RuleContent_149.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_149

    @classmethod
    def create(cls, arg: "Variation_916.cv_arg") -> "Variation_916":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_149:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_149:
        return self.rule.content

class RuleVariation_886(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_916.cv_arg
    cv_variation: TypeAlias = Variation_916

    @classmethod
    def create(cls, arg : "RuleVariation_886.cv_arg") -> "RuleVariation_886":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_916:
        return self.arg # type: ignore

class Content_81(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "APM function"}

class RuleContent_81(RuleContentContextFree):
    cv_arg: TypeAlias = Content_81.cv_arg
    cv_content: TypeAlias = Content_81

    @property
    def content(self) -> Content_81:
        return self._get_content() # type: ignore

class Variation_24(Element):
    cv_arg: TypeAlias = RuleContent_81.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_81

    @classmethod
    def create(cls, arg: "Variation_24.cv_arg") -> "Variation_24":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_81:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_81:
        return self.rule.content

class RuleVariation_24(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_24.cv_arg
    cv_variation: TypeAlias = Variation_24

    @classmethod
    def create(cls, arg : "RuleVariation_24.cv_arg") -> "RuleVariation_24":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_24:
        return self.arg # type: ignore

class Content_142(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "RIMCA function"}

class RuleContent_142(RuleContentContextFree):
    cv_arg: TypeAlias = Content_142.cv_arg
    cv_content: TypeAlias = Content_142

    @property
    def content(self) -> Content_142:
        return self._get_content() # type: ignore

class Variation_415(Element):
    cv_arg: TypeAlias = RuleContent_142.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_142

    @classmethod
    def create(cls, arg: "Variation_415.cv_arg") -> "Variation_415":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_142:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_142:
        return self.rule.content

class RuleVariation_404(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_415.cv_arg
    cv_variation: TypeAlias = Variation_415

    @classmethod
    def create(cls, arg : "RuleVariation_404.cv_arg") -> "RuleVariation_404":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_415:
        return self.arg # type: ignore

class Content_79(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "ACAS RA function"}

class RuleContent_79(RuleContentContextFree):
    cv_arg: TypeAlias = Content_79.cv_arg
    cv_content: TypeAlias = Content_79

    @property
    def content(self) -> Content_79:
        return self._get_content() # type: ignore

class Variation_511(Element):
    cv_arg: TypeAlias = RuleContent_79.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_79

    @classmethod
    def create(cls, arg: "Variation_511.cv_arg") -> "Variation_511":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_79:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_79:
        return self.rule.content

class RuleVariation_500(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_511.cv_arg
    cv_variation: TypeAlias = Variation_511

    @classmethod
    def create(cls, arg : "RuleVariation_500.cv_arg") -> "RuleVariation_500":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_511:
        return self.arg # type: ignore

class Content_132(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "NTCA function"}

class RuleContent_132(RuleContentContextFree):
    cv_arg: TypeAlias = Content_132.cv_arg
    cv_content: TypeAlias = Content_132

    @property
    def content(self) -> Content_132:
        return self._get_content() # type: ignore

class Variation_628(Element):
    cv_arg: TypeAlias = RuleContent_132.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_132

    @classmethod
    def create(cls, arg: "Variation_628.cv_arg") -> "Variation_628":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_132:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_132:
        return self.rule.content

class RuleVariation_617(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_628.cv_arg
    cv_variation: TypeAlias = Variation_628

    @classmethod
    def create(cls, arg : "RuleVariation_617.cv_arg") -> "RuleVariation_617":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_628:
        return self.arg # type: ignore

class Content_152(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "System degraded"}

class RuleContent_152(RuleContentContextFree):
    cv_arg: TypeAlias = Content_152.cv_arg
    cv_content: TypeAlias = Content_152

    @property
    def content(self) -> Content_152:
        return self._get_content() # type: ignore

class Variation_708(Element):
    cv_arg: TypeAlias = RuleContent_152.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_152

    @classmethod
    def create(cls, arg: "Variation_708.cv_arg") -> "Variation_708":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_152:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_152:
        return self.rule.content

class RuleVariation_697(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_708.cv_arg
    cv_variation: TypeAlias = Variation_708

    @classmethod
    def create(cls, arg : "RuleVariation_697.cv_arg") -> "RuleVariation_697":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_708:
        return self.arg # type: ignore

class Content_135(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Overflow error"}

class RuleContent_135(RuleContentContextFree):
    cv_arg: TypeAlias = Content_135.cv_arg
    cv_content: TypeAlias = Content_135

    @property
    def content(self) -> Content_135:
        return self._get_content() # type: ignore

class Variation_831(Element):
    cv_arg: TypeAlias = RuleContent_135.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_135

    @classmethod
    def create(cls, arg: "Variation_831.cv_arg") -> "Variation_831":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_135:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_135:
        return self.rule.content

class RuleVariation_801(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_831.cv_arg
    cv_variation: TypeAlias = Variation_831

    @classmethod
    def create(cls, arg : "RuleVariation_801.cv_arg") -> "RuleVariation_801":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_831:
        return self.arg # type: ignore

class Content_137(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Overload error"}

class RuleContent_137(RuleContentContextFree):
    cv_arg: TypeAlias = Content_137.cv_arg
    cv_content: TypeAlias = Content_137

    @property
    def content(self) -> Content_137:
        return self._get_content() # type: ignore

class Variation_913(Element):
    cv_arg: TypeAlias = RuleContent_137.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_137

    @classmethod
    def create(cls, arg: "Variation_913.cv_arg") -> "Variation_913":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_137:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_137:
        return self.rule.content

class RuleVariation_883(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_913.cv_arg
    cv_variation: TypeAlias = Variation_913

    @classmethod
    def create(cls, arg : "RuleVariation_883.cv_arg") -> "RuleVariation_883":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_913:
        return self.arg # type: ignore

class Content_80(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "AIW function"}

class RuleContent_80(RuleContentContextFree):
    cv_arg: TypeAlias = Content_80.cv_arg
    cv_content: TypeAlias = Content_80

    @property
    def content(self) -> Content_80:
        return self._get_content() # type: ignore

class Variation_23(Element):
    cv_arg: TypeAlias = RuleContent_80.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_80

    @classmethod
    def create(cls, arg: "Variation_23.cv_arg") -> "Variation_23":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_80:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_80:
        return self.rule.content

class RuleVariation_23(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_23.cv_arg
    cv_variation: TypeAlias = Variation_23

    @classmethod
    def create(cls, arg : "RuleVariation_23.cv_arg") -> "RuleVariation_23":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_23:
        return self.arg # type: ignore

class Content_138(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "PAIW function"}

class RuleContent_138(RuleContentContextFree):
    cv_arg: TypeAlias = Content_138.cv_arg
    cv_content: TypeAlias = Content_138

    @property
    def content(self) -> Content_138:
        return self._get_content() # type: ignore

class Variation_413(Element):
    cv_arg: TypeAlias = RuleContent_138.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_138

    @classmethod
    def create(cls, arg: "Variation_413.cv_arg") -> "Variation_413":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_138:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_138:
        return self.rule.content

class RuleVariation_402(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_413.cv_arg
    cv_variation: TypeAlias = Variation_413

    @classmethod
    def create(cls, arg : "RuleVariation_402.cv_arg") -> "RuleVariation_402":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_413:
        return self.arg # type: ignore

class Content_133(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "OCAT function"}

class RuleContent_133(RuleContentContextFree):
    cv_arg: TypeAlias = Content_133.cv_arg
    cv_content: TypeAlias = Content_133

    @property
    def content(self) -> Content_133:
        return self._get_content() # type: ignore

class Variation_519(Element):
    cv_arg: TypeAlias = RuleContent_133.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_133

    @classmethod
    def create(cls, arg: "Variation_519.cv_arg") -> "Variation_519":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_133:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_133:
        return self.rule.content

class RuleVariation_508(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_519.cv_arg
    cv_variation: TypeAlias = Variation_519

    @classmethod
    def create(cls, arg : "RuleVariation_508.cv_arg") -> "RuleVariation_508":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_519:
        return self.arg # type: ignore

class Content_147(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "SAM function"}

class RuleContent_147(RuleContentContextFree):
    cv_arg: TypeAlias = Content_147.cv_arg
    cv_content: TypeAlias = Content_147

    @property
    def content(self) -> Content_147:
        return self._get_content() # type: ignore

class Variation_629(Element):
    cv_arg: TypeAlias = RuleContent_147.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_147

    @classmethod
    def create(cls, arg: "Variation_629.cv_arg") -> "Variation_629":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_147:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_147:
        return self.rule.content

class RuleVariation_618(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_629.cv_arg
    cv_variation: TypeAlias = Variation_629

    @classmethod
    def create(cls, arg : "RuleVariation_618.cv_arg") -> "RuleVariation_618":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_629:
        return self.arg # type: ignore

class Content_159(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "VCD function"}

class RuleContent_159(RuleContentContextFree):
    cv_arg: TypeAlias = Content_159.cv_arg
    cv_content: TypeAlias = Content_159

    @property
    def content(self) -> Content_159:
        return self._get_content() # type: ignore

class Variation_709(Element):
    cv_arg: TypeAlias = RuleContent_159.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_159

    @classmethod
    def create(cls, arg: "Variation_709.cv_arg") -> "Variation_709":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_159:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_159:
        return self.rule.content

class RuleVariation_698(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_709.cv_arg
    cv_variation: TypeAlias = Variation_709

    @classmethod
    def create(cls, arg : "RuleVariation_698.cv_arg") -> "RuleVariation_698":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_709:
        return self.arg # type: ignore

class Content_86(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "CHAM function"}

class RuleContent_86(RuleContentContextFree):
    cv_arg: TypeAlias = Content_86.cv_arg
    cv_content: TypeAlias = Content_86

    @property
    def content(self) -> Content_86:
        return self._get_content() # type: ignore

class Variation_826(Element):
    cv_arg: TypeAlias = RuleContent_86.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_86

    @classmethod
    def create(cls, arg: "Variation_826.cv_arg") -> "Variation_826":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_86:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_86:
        return self.rule.content

class RuleVariation_796(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_826.cv_arg
    cv_variation: TypeAlias = Variation_826

    @classmethod
    def create(cls, arg : "RuleVariation_796.cv_arg") -> "RuleVariation_796":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_826:
        return self.arg # type: ignore

class Content_93(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "DSAM function"}

class RuleContent_93(RuleContentContextFree):
    cv_arg: TypeAlias = Content_93.cv_arg
    cv_content: TypeAlias = Content_93

    @property
    def content(self) -> Content_93:
        return self._get_content() # type: ignore

class Variation_907(Element):
    cv_arg: TypeAlias = RuleContent_93.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_93

    @classmethod
    def create(cls, arg: "Variation_907.cv_arg") -> "Variation_907":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_93:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_93:
        return self.rule.content

class RuleVariation_877(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_907.cv_arg
    cv_variation: TypeAlias = Variation_907

    @classmethod
    def create(cls, arg : "RuleVariation_877.cv_arg") -> "RuleVariation_877":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_907:
        return self.arg # type: ignore

class Content_90(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "DBPSM ARR sub-function"}

class RuleContent_90(RuleContentContextFree):
    cv_arg: TypeAlias = Content_90.cv_arg
    cv_content: TypeAlias = Content_90

    @property
    def content(self) -> Content_90:
        return self._get_content() # type: ignore

class Variation_27(Element):
    cv_arg: TypeAlias = RuleContent_90.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_90

    @classmethod
    def create(cls, arg: "Variation_27.cv_arg") -> "Variation_27":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_90:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_90:
        return self.rule.content

class RuleVariation_27(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_27.cv_arg
    cv_variation: TypeAlias = Variation_27

    @classmethod
    def create(cls, arg : "RuleVariation_27.cv_arg") -> "RuleVariation_27":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_27:
        return self.arg # type: ignore

class Content_91(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "DBPSM DEP sub-function"}

class RuleContent_91(RuleContentContextFree):
    cv_arg: TypeAlias = Content_91.cv_arg
    cv_content: TypeAlias = Content_91

    @property
    def content(self) -> Content_91:
        return self._get_content() # type: ignore

class Variation_404(Element):
    cv_arg: TypeAlias = RuleContent_91.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_91

    @classmethod
    def create(cls, arg: "Variation_404.cv_arg") -> "Variation_404":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_91:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_91:
        return self.rule.content

class RuleVariation_393(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_404.cv_arg
    cv_variation: TypeAlias = Variation_404

    @classmethod
    def create(cls, arg : "RuleVariation_393.cv_arg") -> "RuleVariation_393":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_404:
        return self.arg # type: ignore

class Content_92(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "DBPSM TL sub-function"}

class RuleContent_92(RuleContentContextFree):
    cv_arg: TypeAlias = Content_92.cv_arg
    cv_content: TypeAlias = Content_92

    @property
    def content(self) -> Content_92:
        return self._get_content() # type: ignore

class Variation_513(Element):
    cv_arg: TypeAlias = RuleContent_92.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_92

    @classmethod
    def create(cls, arg: "Variation_513.cv_arg") -> "Variation_513":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_92:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_92:
        return self.rule.content

class RuleVariation_502(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_513.cv_arg
    cv_variation: TypeAlias = Variation_513

    @classmethod
    def create(cls, arg : "RuleVariation_502.cv_arg") -> "RuleVariation_502":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_513:
        return self.arg # type: ignore

class Content_161(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "VRAM CRM sub-function"}

class RuleContent_161(RuleContentContextFree):
    cv_arg: TypeAlias = Content_161.cv_arg
    cv_content: TypeAlias = Content_161

    @property
    def content(self) -> Content_161:
        return self._get_content() # type: ignore

class Variation_631(Element):
    cv_arg: TypeAlias = RuleContent_161.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_161

    @classmethod
    def create(cls, arg: "Variation_631.cv_arg") -> "Variation_631":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_161:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_161:
        return self.rule.content

class RuleVariation_620(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_631.cv_arg
    cv_variation: TypeAlias = Variation_631

    @classmethod
    def create(cls, arg : "RuleVariation_620.cv_arg") -> "RuleVariation_620":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_631:
        return self.arg # type: ignore

class Content_163(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "VRAM VTM sub-function"}

class RuleContent_163(RuleContentContextFree):
    cv_arg: TypeAlias = Content_163.cv_arg
    cv_content: TypeAlias = Content_163

    @property
    def content(self) -> Content_163:
        return self._get_content() # type: ignore

class Variation_711(Element):
    cv_arg: TypeAlias = RuleContent_163.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_163

    @classmethod
    def create(cls, arg: "Variation_711.cv_arg") -> "Variation_711":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_163:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_163:
        return self.rule.content

class RuleVariation_700(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_711.cv_arg
    cv_variation: TypeAlias = Variation_711

    @classmethod
    def create(cls, arg : "RuleVariation_700.cv_arg") -> "RuleVariation_700":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_711:
        return self.arg # type: ignore

class Content_162(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "VRAM VRM sub-function"}

class RuleContent_162(RuleContentContextFree):
    cv_arg: TypeAlias = Content_162.cv_arg
    cv_content: TypeAlias = Content_162

    @property
    def content(self) -> Content_162:
        return self._get_content() # type: ignore

class Variation_838(Element):
    cv_arg: TypeAlias = RuleContent_162.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_162

    @classmethod
    def create(cls, arg: "Variation_838.cv_arg") -> "Variation_838":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_162:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_162:
        return self.rule.content

class RuleVariation_808(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_838.cv_arg
    cv_variation: TypeAlias = Variation_838

    @classmethod
    def create(cls, arg : "RuleVariation_808.cv_arg") -> "RuleVariation_808":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_838:
        return self.arg # type: ignore

class Content_101(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "HAM HD sub-function"}

class RuleContent_101(RuleContentContextFree):
    cv_arg: TypeAlias = Content_101.cv_arg
    cv_content: TypeAlias = Content_101

    @property
    def content(self) -> Content_101:
        return self._get_content() # type: ignore

class Variation_910(Element):
    cv_arg: TypeAlias = RuleContent_101.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_101

    @classmethod
    def create(cls, arg: "Variation_910.cv_arg") -> "Variation_910":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_101:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_101:
        return self.rule.content

class RuleVariation_880(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_910.cv_arg
    cv_variation: TypeAlias = Variation_910

    @classmethod
    def create(cls, arg : "RuleVariation_880.cv_arg") -> "RuleVariation_880":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_910:
        return self.arg # type: ignore

class Content_102(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "HAM RD sub-function"}

class RuleContent_102(RuleContentContextFree):
    cv_arg: TypeAlias = Content_102.cv_arg
    cv_content: TypeAlias = Content_102

    @property
    def content(self) -> Content_102:
        return self._get_content() # type: ignore

class Variation_29(Element):
    cv_arg: TypeAlias = RuleContent_102.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_102

    @classmethod
    def create(cls, arg: "Variation_29.cv_arg") -> "Variation_29":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_102:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_102:
        return self.rule.content

class RuleVariation_29(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_29.cv_arg
    cv_variation: TypeAlias = Variation_29

    @classmethod
    def create(cls, arg : "RuleVariation_29.cv_arg") -> "RuleVariation_29":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_29:
        return self.arg # type: ignore

class Content_103(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "HAM VD sub-function"}

class RuleContent_103(RuleContentContextFree):
    cv_arg: TypeAlias = Content_103.cv_arg
    cv_content: TypeAlias = Content_103

    @property
    def content(self) -> Content_103:
        return self._get_content() # type: ignore

class Variation_407(Element):
    cv_arg: TypeAlias = RuleContent_103.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_103

    @classmethod
    def create(cls, arg: "Variation_407.cv_arg") -> "Variation_407":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_103:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_103:
        return self.rule.content

class RuleVariation_396(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_407.cv_arg
    cv_variation: TypeAlias = Variation_407

    @classmethod
    def create(cls, arg : "RuleVariation_396.cv_arg") -> "RuleVariation_396":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_407:
        return self.arg # type: ignore

class Content_104(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "HVI function"}

class RuleContent_104(RuleContentContextFree):
    cv_arg: TypeAlias = Content_104.cv_arg
    cv_content: TypeAlias = Content_104

    @property
    def content(self) -> Content_104:
        return self._get_content() # type: ignore

class Variation_515(Element):
    cv_arg: TypeAlias = RuleContent_104.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_104

    @classmethod
    def create(cls, arg: "Variation_515.cv_arg") -> "Variation_515":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_104:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_104:
        return self.rule.content

class RuleVariation_504(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_515.cv_arg
    cv_variation: TypeAlias = Variation_515

    @classmethod
    def create(cls, arg : "RuleVariation_504.cv_arg") -> "RuleVariation_504":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_515:
        return self.arg # type: ignore

class Content_111(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "LTW function"}

class RuleContent_111(RuleContentContextFree):
    cv_arg: TypeAlias = Content_111.cv_arg
    cv_content: TypeAlias = Content_111

    @property
    def content(self) -> Content_111:
        return self._get_content() # type: ignore

class Variation_622(Element):
    cv_arg: TypeAlias = RuleContent_111.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_111

    @classmethod
    def create(cls, arg: "Variation_622.cv_arg") -> "Variation_622":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_111:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_111:
        return self.rule.content

class RuleVariation_611(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_622.cv_arg
    cv_variation: TypeAlias = Variation_622

    @classmethod
    def create(cls, arg : "RuleVariation_611.cv_arg") -> "RuleVariation_611":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_622:
        return self.arg # type: ignore

class Content_160(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "VPM function"}

class RuleContent_160(RuleContentContextFree):
    cv_arg: TypeAlias = Content_160.cv_arg
    cv_content: TypeAlias = Content_160

    @property
    def content(self) -> Content_160:
        return self._get_content() # type: ignore

class Variation_710(Element):
    cv_arg: TypeAlias = RuleContent_160.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_160

    @classmethod
    def create(cls, arg: "Variation_710.cv_arg") -> "Variation_710":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_160:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_160:
        return self.rule.content

class RuleVariation_699(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_710.cv_arg
    cv_variation: TypeAlias = Variation_710

    @classmethod
    def create(cls, arg : "RuleVariation_699.cv_arg") -> "RuleVariation_699":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_710:
        return self.arg # type: ignore

class Content_153(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "TTA function"}

class RuleContent_153(RuleContentContextFree):
    cv_arg: TypeAlias = Content_153.cv_arg
    cv_content: TypeAlias = Content_153

    @property
    def content(self) -> Content_153:
        return self._get_content() # type: ignore

class Variation_836(Element):
    cv_arg: TypeAlias = RuleContent_153.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_153

    @classmethod
    def create(cls, arg: "Variation_836.cv_arg") -> "Variation_836":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_153:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_153:
        return self.rule.content

class RuleVariation_806(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_836.cv_arg
    cv_variation: TypeAlias = Variation_836

    @classmethod
    def create(cls, arg : "RuleVariation_806.cv_arg") -> "RuleVariation_806":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_836:
        return self.arg # type: ignore

class Content_88(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "CRA function"}

class RuleContent_88(RuleContentContextFree):
    cv_arg: TypeAlias = Content_88.cv_arg
    cv_content: TypeAlias = Content_88

    @property
    def content(self) -> Content_88:
        return self._get_content() # type: ignore

class Variation_905(Element):
    cv_arg: TypeAlias = RuleContent_88.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_88

    @classmethod
    def create(cls, arg: "Variation_905.cv_arg") -> "Variation_905":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_88:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_88:
        return self.rule.content

class RuleVariation_875(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_905.cv_arg
    cv_variation: TypeAlias = Variation_905

    @classmethod
    def create(cls, arg : "RuleVariation_875.cv_arg") -> "RuleVariation_875":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_905:
        return self.arg # type: ignore

class Content_83(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "ASM sub-function"}

class RuleContent_83(RuleContentContextFree):
    cv_arg: TypeAlias = Content_83.cv_arg
    cv_content: TypeAlias = Content_83

    @property
    def content(self) -> Content_83:
        return self._get_content() # type: ignore

class Variation_25(Element):
    cv_arg: TypeAlias = RuleContent_83.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_83

    @classmethod
    def create(cls, arg: "Variation_25.cv_arg") -> "Variation_25":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_83:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_83:
        return self.rule.content

class RuleVariation_25(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_25.cv_arg
    cv_variation: TypeAlias = Variation_25

    @classmethod
    def create(cls, arg : "RuleVariation_25.cv_arg") -> "RuleVariation_25":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_25:
        return self.arg # type: ignore

class Content_106(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "IAVM sub-function"}

class RuleContent_106(RuleContentContextFree):
    cv_arg: TypeAlias = Content_106.cv_arg
    cv_content: TypeAlias = Content_106

    @property
    def content(self) -> Content_106:
        return self._get_content() # type: ignore

class Variation_408(Element):
    cv_arg: TypeAlias = RuleContent_106.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_106

    @classmethod
    def create(cls, arg: "Variation_408.cv_arg") -> "Variation_408":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_106:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_106:
        return self.rule.content

class RuleVariation_397(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_408.cv_arg
    cv_variation: TypeAlias = Variation_408

    @classmethod
    def create(cls, arg : "RuleVariation_397.cv_arg") -> "RuleVariation_397":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_408:
        return self.arg # type: ignore

class Content_96(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "FTD Function"}

class RuleContent_96(RuleContentContextFree):
    cv_arg: TypeAlias = Content_96.cv_arg
    cv_content: TypeAlias = Content_96

    @property
    def content(self) -> Content_96:
        return self._get_content() # type: ignore

class Variation_514(Element):
    cv_arg: TypeAlias = RuleContent_96.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_96

    @classmethod
    def create(cls, arg: "Variation_514.cv_arg") -> "Variation_514":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_96:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_96:
        return self.rule.content

class RuleVariation_503(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_514.cv_arg
    cv_variation: TypeAlias = Variation_514

    @classmethod
    def create(cls, arg : "RuleVariation_503.cv_arg") -> "RuleVariation_503":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_514:
        return self.arg # type: ignore

class Content_108(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "ITD function"}

class RuleContent_108(RuleContentContextFree):
    cv_arg: TypeAlias = Content_108.cv_arg
    cv_content: TypeAlias = Content_108

    @property
    def content(self) -> Content_108:
        return self._get_content() # type: ignore

class Variation_620(Element):
    cv_arg: TypeAlias = RuleContent_108.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_108

    @classmethod
    def create(cls, arg: "Variation_620.cv_arg") -> "Variation_620":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_108:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_108:
        return self.rule.content

class RuleVariation_609(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_620.cv_arg
    cv_variation: TypeAlias = Variation_620

    @classmethod
    def create(cls, arg : "RuleVariation_609.cv_arg") -> "RuleVariation_609":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_620:
        return self.arg # type: ignore

class Content_107(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "IIA function"}

class RuleContent_107(RuleContentContextFree):
    cv_arg: TypeAlias = Content_107.cv_arg
    cv_content: TypeAlias = Content_107

    @property
    def content(self) -> Content_107:
        return self._get_content() # type: ignore

class Variation_704(Element):
    cv_arg: TypeAlias = RuleContent_107.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_107

    @classmethod
    def create(cls, arg: "Variation_704.cv_arg") -> "Variation_704":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_107:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_107:
        return self.rule.content

class RuleVariation_693(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_704.cv_arg
    cv_variation: TypeAlias = Variation_704

    @classmethod
    def create(cls, arg : "RuleVariation_693.cv_arg") -> "RuleVariation_693":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_704:
        return self.arg # type: ignore

class Content_148(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "SQW function"}

class RuleContent_148(RuleContentContextFree):
    cv_arg: TypeAlias = Content_148.cv_arg
    cv_content: TypeAlias = Content_148

    @property
    def content(self) -> Content_148:
        return self._get_content() # type: ignore

class Variation_833(Element):
    cv_arg: TypeAlias = RuleContent_148.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_148

    @classmethod
    def create(cls, arg: "Variation_833.cv_arg") -> "Variation_833":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_148:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_148:
        return self.rule.content

class RuleVariation_803(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_833.cv_arg
    cv_variation: TypeAlias = Variation_833

    @classmethod
    def create(cls, arg : "RuleVariation_803.cv_arg") -> "RuleVariation_803":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_833:
        return self.arg # type: ignore

class Content_89(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "CUW function"}

class RuleContent_89(RuleContentContextFree):
    cv_arg: TypeAlias = Content_89.cv_arg
    cv_content: TypeAlias = Content_89

    @property
    def content(self) -> Content_89:
        return self._get_content() # type: ignore

class Variation_906(Element):
    cv_arg: TypeAlias = RuleContent_89.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_89

    @classmethod
    def create(cls, arg: "Variation_906.cv_arg") -> "Variation_906":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_89:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_89:
        return self.rule.content

class RuleVariation_876(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_906.cv_arg
    cv_variation: TypeAlias = Variation_906

    @classmethod
    def create(cls, arg : "RuleVariation_876.cv_arg") -> "RuleVariation_876":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_906:
        return self.arg # type: ignore

class Content_85(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "CATC function"}

class RuleContent_85(RuleContentContextFree):
    cv_arg: TypeAlias = Content_85.cv_arg
    cv_content: TypeAlias = Content_85

    @property
    def content(self) -> Content_85:
        return self._get_content() # type: ignore

class Variation_26(Element):
    cv_arg: TypeAlias = RuleContent_85.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_85

    @classmethod
    def create(cls, arg: "Variation_26.cv_arg") -> "Variation_26":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_85:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_85:
        return self.rule.content

class RuleVariation_26(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_26.cv_arg
    cv_variation: TypeAlias = Variation_26

    @classmethod
    def create(cls, arg : "RuleVariation_26.cv_arg") -> "RuleVariation_26":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_26:
        return self.arg # type: ignore

class Content_129(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "NOCLR sub-function"}

class RuleContent_129(RuleContentContextFree):
    cv_arg: TypeAlias = Content_129.cv_arg
    cv_content: TypeAlias = Content_129

    @property
    def content(self) -> Content_129:
        return self._get_content() # type: ignore

class Variation_412(Element):
    cv_arg: TypeAlias = RuleContent_129.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_129

    @classmethod
    def create(cls, arg: "Variation_412.cv_arg") -> "Variation_412":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_129:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_129:
        return self.rule.content

class RuleVariation_401(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_412.cv_arg
    cv_variation: TypeAlias = Variation_412

    @classmethod
    def create(cls, arg : "RuleVariation_401.cv_arg") -> "RuleVariation_401":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_412:
        return self.arg # type: ignore

class Content_131(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "NOMOV Function"}

class RuleContent_131(RuleContentContextFree):
    cv_arg: TypeAlias = Content_131.cv_arg
    cv_content: TypeAlias = Content_131

    @property
    def content(self) -> Content_131:
        return self._get_content() # type: ignore

class Variation_518(Element):
    cv_arg: TypeAlias = RuleContent_131.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_131

    @classmethod
    def create(cls, arg: "Variation_518.cv_arg") -> "Variation_518":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_131:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_131:
        return self.rule.content

class RuleVariation_507(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_518.cv_arg
    cv_variation: TypeAlias = Variation_518

    @classmethod
    def create(cls, arg : "RuleVariation_507.cv_arg") -> "RuleVariation_507":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_518:
        return self.arg # type: ignore

class Content_130(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "NOH function"}

class RuleContent_130(RuleContentContextFree):
    cv_arg: TypeAlias = Content_130.cv_arg
    cv_content: TypeAlias = Content_130

    @property
    def content(self) -> Content_130:
        return self._get_content() # type: ignore

class Variation_627(Element):
    cv_arg: TypeAlias = RuleContent_130.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_130

    @classmethod
    def create(cls, arg: "Variation_627.cv_arg") -> "Variation_627":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_130:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_130:
        return self.rule.content

class RuleVariation_616(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_627.cv_arg
    cv_variation: TypeAlias = Variation_627

    @classmethod
    def create(cls, arg : "RuleVariation_616.cv_arg") -> "RuleVariation_616":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_627:
        return self.arg # type: ignore

class Content_164(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "WRTY function"}

class RuleContent_164(RuleContentContextFree):
    cv_arg: TypeAlias = Content_164.cv_arg
    cv_content: TypeAlias = Content_164

    @property
    def content(self) -> Content_164:
        return self._get_content() # type: ignore

class Variation_712(Element):
    cv_arg: TypeAlias = RuleContent_164.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_164

    @classmethod
    def create(cls, arg: "Variation_712.cv_arg") -> "Variation_712":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_164:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_164:
        return self.rule.content

class RuleVariation_701(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_712.cv_arg
    cv_variation: TypeAlias = Variation_712

    @classmethod
    def create(cls, arg : "RuleVariation_701.cv_arg") -> "RuleVariation_701":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_712:
        return self.arg # type: ignore

class Content_150(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "STOCC function"}

class RuleContent_150(RuleContentContextFree):
    cv_arg: TypeAlias = Content_150.cv_arg
    cv_content: TypeAlias = Content_150

    @property
    def content(self) -> Content_150:
        return self._get_content() # type: ignore

class Variation_834(Element):
    cv_arg: TypeAlias = RuleContent_150.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_150

    @classmethod
    def create(cls, arg: "Variation_834.cv_arg") -> "Variation_834":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_150:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_150:
        return self.rule.content

class RuleVariation_804(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_834.cv_arg
    cv_variation: TypeAlias = Variation_834

    @classmethod
    def create(cls, arg : "RuleVariation_804.cv_arg") -> "RuleVariation_804":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_834:
        return self.arg # type: ignore

class Content_134(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "ONGOING function"}

class RuleContent_134(RuleContentContextFree):
    cv_arg: TypeAlias = Content_134.cv_arg
    cv_content: TypeAlias = Content_134

    @property
    def content(self) -> Content_134:
        return self._get_content() # type: ignore

class Variation_912(Element):
    cv_arg: TypeAlias = RuleContent_134.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_134

    @classmethod
    def create(cls, arg: "Variation_912.cv_arg") -> "Variation_912":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_134:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_134:
        return self.rule.content

class RuleVariation_882(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_912.cv_arg
    cv_variation: TypeAlias = Variation_912

    @classmethod
    def create(cls, arg : "RuleVariation_882.cv_arg") -> "RuleVariation_882":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_912:
        return self.arg # type: ignore

class NonSpare_1309(NonSpare):
    cv_arg: TypeAlias = RuleVariation_32.cv_arg
    cv_name = "MRVA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_32

    @classmethod
    def create(cls, arg : "NonSpare_1309.cv_arg") -> "NonSpare_1309":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_32:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_32:
        return self.rule.variation

class Item_581(Item):
    cv_arg: TypeAlias = NonSpare_1309.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1309

    @classmethod
    def create(cls, arg : "Item_581.cv_arg") -> "Item_581":
        return cls._create(arg) # type: ignore

class NonSpare_1536(NonSpare):
    cv_arg: TypeAlias = RuleVariation_403.cv_arg
    cv_name = "RAMLD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_403

    @classmethod
    def create(cls, arg : "NonSpare_1536.cv_arg") -> "NonSpare_1536":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_403:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_414:
        return self.rule.variation

class Item_772(Item):
    cv_arg: TypeAlias = NonSpare_1536.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1536

    @classmethod
    def create(cls, arg : "Item_772.cv_arg") -> "Item_772":
        return cls._create(arg) # type: ignore

class NonSpare_1535(NonSpare):
    cv_arg: TypeAlias = RuleVariation_510.cv_arg
    cv_name = "RAMHD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_510

    @classmethod
    def create(cls, arg : "NonSpare_1535.cv_arg") -> "NonSpare_1535":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_510:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_521:
        return self.rule.variation

class Item_771(Item):
    cv_arg: TypeAlias = NonSpare_1535.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1535

    @classmethod
    def create(cls, arg : "Item_771.cv_arg") -> "Item_771":
        return cls._create(arg) # type: ignore

class NonSpare_1314(NonSpare):
    cv_arg: TypeAlias = RuleVariation_612.cv_arg
    cv_name = "MSAW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_612

    @classmethod
    def create(cls, arg : "NonSpare_1314.cv_arg") -> "NonSpare_1314":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_612:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_623:
        return self.rule.variation

class Item_584(Item):
    cv_arg: TypeAlias = NonSpare_1314.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1314

    @classmethod
    def create(cls, arg : "Item_584.cv_arg") -> "Item_584":
        return cls._create(arg) # type: ignore

class NonSpare_614(NonSpare):
    cv_arg: TypeAlias = RuleVariation_691.cv_arg
    cv_name = "APW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_691

    @classmethod
    def create(cls, arg : "NonSpare_614.cv_arg") -> "NonSpare_614":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_691:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_702:
        return self.rule.variation

class Item_78(Item):
    cv_arg: TypeAlias = NonSpare_614.cv_arg
    cv_non_spare: TypeAlias = NonSpare_614

    @classmethod
    def create(cls, arg : "Item_78.cv_arg") -> "Item_78":
        return cls._create(arg) # type: ignore

class NonSpare_736(NonSpare):
    cv_arg: TypeAlias = RuleVariation_797.cv_arg
    cv_name = "CLAM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_797

    @classmethod
    def create(cls, arg : "NonSpare_736.cv_arg") -> "NonSpare_736":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_797:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_827:
        return self.rule.variation

class Item_161(Item):
    cv_arg: TypeAlias = NonSpare_736.cv_arg
    cv_non_spare: TypeAlias = NonSpare_736

    @classmethod
    def create(cls, arg : "Item_161.cv_arg") -> "Item_161":
        return cls._create(arg) # type: ignore

class NonSpare_1776(NonSpare):
    cv_arg: TypeAlias = RuleVariation_886.cv_arg
    cv_name = "STCA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_886

    @classmethod
    def create(cls, arg : "NonSpare_1776.cv_arg") -> "NonSpare_1776":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_886:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_916:
        return self.rule.variation

class Item_943(Item):
    cv_arg: TypeAlias = NonSpare_1776.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1776

    @classmethod
    def create(cls, arg : "Item_943.cv_arg") -> "Item_943":
        return cls._create(arg) # type: ignore

class NonSpare_613(NonSpare):
    cv_arg: TypeAlias = RuleVariation_24.cv_arg
    cv_name = "APM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_24

    @classmethod
    def create(cls, arg : "NonSpare_613.cv_arg") -> "NonSpare_613":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_24:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_24:
        return self.rule.variation

class Item_77(Item):
    cv_arg: TypeAlias = NonSpare_613.cv_arg
    cv_non_spare: TypeAlias = NonSpare_613

    @classmethod
    def create(cls, arg : "Item_77.cv_arg") -> "Item_77":
        return cls._create(arg) # type: ignore

class NonSpare_1586(NonSpare):
    cv_arg: TypeAlias = RuleVariation_404.cv_arg
    cv_name = "RIMCA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_404

    @classmethod
    def create(cls, arg : "NonSpare_1586.cv_arg") -> "NonSpare_1586":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_404:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_415:
        return self.rule.variation

class Item_817(Item):
    cv_arg: TypeAlias = NonSpare_1586.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1586

    @classmethod
    def create(cls, arg : "Item_817.cv_arg") -> "Item_817":
        return cls._create(arg) # type: ignore

class NonSpare_555(NonSpare):
    cv_arg: TypeAlias = RuleVariation_500.cv_arg
    cv_name = "ACASRA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_500

    @classmethod
    def create(cls, arg : "NonSpare_555.cv_arg") -> "NonSpare_555":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_500:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_511:
        return self.rule.variation

class Item_40(Item):
    cv_arg: TypeAlias = NonSpare_555.cv_arg
    cv_non_spare: TypeAlias = NonSpare_555

    @classmethod
    def create(cls, arg : "Item_40.cv_arg") -> "Item_40":
        return cls._create(arg) # type: ignore

class NonSpare_1371(NonSpare):
    cv_arg: TypeAlias = RuleVariation_617.cv_arg
    cv_name = "NTCA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_617

    @classmethod
    def create(cls, arg : "NonSpare_1371.cv_arg") -> "NonSpare_1371":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_617:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_628:
        return self.rule.variation

class Item_636(Item):
    cv_arg: TypeAlias = NonSpare_1371.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1371

    @classmethod
    def create(cls, arg : "Item_636.cv_arg") -> "Item_636":
        return cls._create(arg) # type: ignore

class NonSpare_875(NonSpare):
    cv_arg: TypeAlias = RuleVariation_697.cv_arg
    cv_name = "DG"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_697

    @classmethod
    def create(cls, arg : "NonSpare_875.cv_arg") -> "NonSpare_875":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_697:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_708:
        return self.rule.variation

class Item_258(Item):
    cv_arg: TypeAlias = NonSpare_875.cv_arg
    cv_non_spare: TypeAlias = NonSpare_875

    @classmethod
    def create(cls, arg : "Item_258.cv_arg") -> "Item_258":
        return cls._create(arg) # type: ignore

class NonSpare_1385(NonSpare):
    cv_arg: TypeAlias = RuleVariation_801.cv_arg
    cv_name = "OF"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_801

    @classmethod
    def create(cls, arg : "NonSpare_1385.cv_arg") -> "NonSpare_1385":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_801:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_831:
        return self.rule.variation

class Item_650(Item):
    cv_arg: TypeAlias = NonSpare_1385.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1385

    @classmethod
    def create(cls, arg : "Item_650.cv_arg") -> "Item_650":
        return cls._create(arg) # type: ignore

class NonSpare_1386(NonSpare):
    cv_arg: TypeAlias = RuleVariation_883.cv_arg
    cv_name = "OL"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_883

    @classmethod
    def create(cls, arg : "NonSpare_1386.cv_arg") -> "NonSpare_1386":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_883:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_913:
        return self.rule.variation

class Item_651(Item):
    cv_arg: TypeAlias = NonSpare_1386.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1386

    @classmethod
    def create(cls, arg : "Item_651.cv_arg") -> "Item_651":
        return cls._create(arg) # type: ignore

class NonSpare_584(NonSpare):
    cv_arg: TypeAlias = RuleVariation_23.cv_arg
    cv_name = "AIW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_23

    @classmethod
    def create(cls, arg : "NonSpare_584.cv_arg") -> "NonSpare_584":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_23:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_23:
        return self.rule.variation

class Item_56(Item):
    cv_arg: TypeAlias = NonSpare_584.cv_arg
    cv_non_spare: TypeAlias = NonSpare_584

    @classmethod
    def create(cls, arg : "Item_56.cv_arg") -> "Item_56":
        return cls._create(arg) # type: ignore

class NonSpare_1410(NonSpare):
    cv_arg: TypeAlias = RuleVariation_402.cv_arg
    cv_name = "PAIW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_402

    @classmethod
    def create(cls, arg : "NonSpare_1410.cv_arg") -> "NonSpare_1410":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_402:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_413:
        return self.rule.variation

class Item_673(Item):
    cv_arg: TypeAlias = NonSpare_1410.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1410

    @classmethod
    def create(cls, arg : "Item_673.cv_arg") -> "Item_673":
        return cls._create(arg) # type: ignore

class NonSpare_1379(NonSpare):
    cv_arg: TypeAlias = RuleVariation_508.cv_arg
    cv_name = "OCAT"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_508

    @classmethod
    def create(cls, arg : "NonSpare_1379.cv_arg") -> "NonSpare_1379":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_508:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_519:
        return self.rule.variation

class Item_644(Item):
    cv_arg: TypeAlias = NonSpare_1379.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1379

    @classmethod
    def create(cls, arg : "Item_644.cv_arg") -> "Item_644":
        return cls._create(arg) # type: ignore

class NonSpare_1650(NonSpare):
    cv_arg: TypeAlias = RuleVariation_618.cv_arg
    cv_name = "SAM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_618

    @classmethod
    def create(cls, arg : "NonSpare_1650.cv_arg") -> "NonSpare_1650":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_618:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_629:
        return self.rule.variation

class Item_854(Item):
    cv_arg: TypeAlias = NonSpare_1650.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1650

    @classmethod
    def create(cls, arg : "Item_854.cv_arg") -> "Item_854":
        return cls._create(arg) # type: ignore

class NonSpare_2016(NonSpare):
    cv_arg: TypeAlias = RuleVariation_698.cv_arg
    cv_name = "VCD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_698

    @classmethod
    def create(cls, arg : "NonSpare_2016.cv_arg") -> "NonSpare_2016":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_698:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_709:
        return self.rule.variation

class Item_1132(Item):
    cv_arg: TypeAlias = NonSpare_2016.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2016

    @classmethod
    def create(cls, arg : "Item_1132.cv_arg") -> "Item_1132":
        return cls._create(arg) # type: ignore

class NonSpare_726(NonSpare):
    cv_arg: TypeAlias = RuleVariation_796.cv_arg
    cv_name = "CHAM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_796

    @classmethod
    def create(cls, arg : "NonSpare_726.cv_arg") -> "NonSpare_726":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_796:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_826:
        return self.rule.variation

class Item_154(Item):
    cv_arg: TypeAlias = NonSpare_726.cv_arg
    cv_non_spare: TypeAlias = NonSpare_726

    @classmethod
    def create(cls, arg : "Item_154.cv_arg") -> "Item_154":
        return cls._create(arg) # type: ignore

class NonSpare_895(NonSpare):
    cv_arg: TypeAlias = RuleVariation_877.cv_arg
    cv_name = "DSAM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_877

    @classmethod
    def create(cls, arg : "NonSpare_895.cv_arg") -> "NonSpare_895":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_877:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_907:
        return self.rule.variation

class Item_274(Item):
    cv_arg: TypeAlias = NonSpare_895.cv_arg
    cv_non_spare: TypeAlias = NonSpare_895

    @classmethod
    def create(cls, arg : "Item_274.cv_arg") -> "Item_274":
        return cls._create(arg) # type: ignore

class NonSpare_857(NonSpare):
    cv_arg: TypeAlias = RuleVariation_27.cv_arg
    cv_name = "DBPSMARR"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_27

    @classmethod
    def create(cls, arg : "NonSpare_857.cv_arg") -> "NonSpare_857":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_27:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_27:
        return self.rule.variation

class Item_241(Item):
    cv_arg: TypeAlias = NonSpare_857.cv_arg
    cv_non_spare: TypeAlias = NonSpare_857

    @classmethod
    def create(cls, arg : "Item_241.cv_arg") -> "Item_241":
        return cls._create(arg) # type: ignore

class NonSpare_859(NonSpare):
    cv_arg: TypeAlias = RuleVariation_393.cv_arg
    cv_name = "DBPSMDEP"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_393

    @classmethod
    def create(cls, arg : "NonSpare_859.cv_arg") -> "NonSpare_859":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_393:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_404:
        return self.rule.variation

class Item_243(Item):
    cv_arg: TypeAlias = NonSpare_859.cv_arg
    cv_non_spare: TypeAlias = NonSpare_859

    @classmethod
    def create(cls, arg : "Item_243.cv_arg") -> "Item_243":
        return cls._create(arg) # type: ignore

class NonSpare_861(NonSpare):
    cv_arg: TypeAlias = RuleVariation_502.cv_arg
    cv_name = "DBPSMTL"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_502

    @classmethod
    def create(cls, arg : "NonSpare_861.cv_arg") -> "NonSpare_861":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_502:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_513:
        return self.rule.variation

class Item_245(Item):
    cv_arg: TypeAlias = NonSpare_861.cv_arg
    cv_non_spare: TypeAlias = NonSpare_861

    @classmethod
    def create(cls, arg : "Item_245.cv_arg") -> "Item_245":
        return cls._create(arg) # type: ignore

class NonSpare_2028(NonSpare):
    cv_arg: TypeAlias = RuleVariation_620.cv_arg
    cv_name = "VRAMCRM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_620

    @classmethod
    def create(cls, arg : "NonSpare_2028.cv_arg") -> "NonSpare_2028":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_620:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_631:
        return self.rule.variation

class Item_1143(Item):
    cv_arg: TypeAlias = NonSpare_2028.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2028

    @classmethod
    def create(cls, arg : "Item_1143.cv_arg") -> "Item_1143":
        return cls._create(arg) # type: ignore

class NonSpare_2031(NonSpare):
    cv_arg: TypeAlias = RuleVariation_700.cv_arg
    cv_name = "VRAMVTM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_700

    @classmethod
    def create(cls, arg : "NonSpare_2031.cv_arg") -> "NonSpare_2031":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_700:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_711:
        return self.rule.variation

class Item_1146(Item):
    cv_arg: TypeAlias = NonSpare_2031.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2031

    @classmethod
    def create(cls, arg : "Item_1146.cv_arg") -> "Item_1146":
        return cls._create(arg) # type: ignore

class NonSpare_2030(NonSpare):
    cv_arg: TypeAlias = RuleVariation_808.cv_arg
    cv_name = "VRAMVRM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_808

    @classmethod
    def create(cls, arg : "NonSpare_2030.cv_arg") -> "NonSpare_2030":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_808:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_838:
        return self.rule.variation

class Item_1145(Item):
    cv_arg: TypeAlias = NonSpare_2030.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2030

    @classmethod
    def create(cls, arg : "Item_1145.cv_arg") -> "Item_1145":
        return cls._create(arg) # type: ignore

class NonSpare_1046(NonSpare):
    cv_arg: TypeAlias = RuleVariation_880.cv_arg
    cv_name = "HAMHD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_880

    @classmethod
    def create(cls, arg : "NonSpare_1046.cv_arg") -> "NonSpare_1046":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_880:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_910:
        return self.rule.variation

class Item_380(Item):
    cv_arg: TypeAlias = NonSpare_1046.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1046

    @classmethod
    def create(cls, arg : "Item_380.cv_arg") -> "Item_380":
        return cls._create(arg) # type: ignore

class NonSpare_1048(NonSpare):
    cv_arg: TypeAlias = RuleVariation_29.cv_arg
    cv_name = "HAMRD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_29

    @classmethod
    def create(cls, arg : "NonSpare_1048.cv_arg") -> "NonSpare_1048":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_29:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_29:
        return self.rule.variation

class Item_382(Item):
    cv_arg: TypeAlias = NonSpare_1048.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1048

    @classmethod
    def create(cls, arg : "Item_382.cv_arg") -> "Item_382":
        return cls._create(arg) # type: ignore

class NonSpare_1050(NonSpare):
    cv_arg: TypeAlias = RuleVariation_396.cv_arg
    cv_name = "HAMVD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_396

    @classmethod
    def create(cls, arg : "NonSpare_1050.cv_arg") -> "NonSpare_1050":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_396:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_407:
        return self.rule.variation

class Item_384(Item):
    cv_arg: TypeAlias = NonSpare_1050.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1050

    @classmethod
    def create(cls, arg : "Item_384.cv_arg") -> "Item_384":
        return cls._create(arg) # type: ignore

class NonSpare_1077(NonSpare):
    cv_arg: TypeAlias = RuleVariation_504.cv_arg
    cv_name = "HVI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_504

    @classmethod
    def create(cls, arg : "NonSpare_1077.cv_arg") -> "NonSpare_1077":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_504:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_515:
        return self.rule.variation

class Item_405(Item):
    cv_arg: TypeAlias = NonSpare_1077.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1077

    @classmethod
    def create(cls, arg : "Item_405.cv_arg") -> "Item_405":
        return cls._create(arg) # type: ignore

class NonSpare_1193(NonSpare):
    cv_arg: TypeAlias = RuleVariation_611.cv_arg
    cv_name = "LTW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_611

    @classmethod
    def create(cls, arg : "NonSpare_1193.cv_arg") -> "NonSpare_1193":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_611:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_622:
        return self.rule.variation

class Item_507(Item):
    cv_arg: TypeAlias = NonSpare_1193.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1193

    @classmethod
    def create(cls, arg : "Item_507.cv_arg") -> "Item_507":
        return cls._create(arg) # type: ignore

class NonSpare_2026(NonSpare):
    cv_arg: TypeAlias = RuleVariation_699.cv_arg
    cv_name = "VPM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_699

    @classmethod
    def create(cls, arg : "NonSpare_2026.cv_arg") -> "NonSpare_2026":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_699:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_710:
        return self.rule.variation

class Item_1141(Item):
    cv_arg: TypeAlias = NonSpare_2026.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2026

    @classmethod
    def create(cls, arg : "Item_1141.cv_arg") -> "Item_1141":
        return cls._create(arg) # type: ignore

class NonSpare_1935(NonSpare):
    cv_arg: TypeAlias = RuleVariation_806.cv_arg
    cv_name = "TTA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_806

    @classmethod
    def create(cls, arg : "NonSpare_1935.cv_arg") -> "NonSpare_1935":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_806:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_836:
        return self.rule.variation

class Item_1056(Item):
    cv_arg: TypeAlias = NonSpare_1935.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1935

    @classmethod
    def create(cls, arg : "Item_1056.cv_arg") -> "Item_1056":
        return cls._create(arg) # type: ignore

class NonSpare_820(NonSpare):
    cv_arg: TypeAlias = RuleVariation_875.cv_arg
    cv_name = "CRA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_875

    @classmethod
    def create(cls, arg : "NonSpare_820.cv_arg") -> "NonSpare_820":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_875:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_905:
        return self.rule.variation

class Item_212(Item):
    cv_arg: TypeAlias = NonSpare_820.cv_arg
    cv_non_spare: TypeAlias = NonSpare_820

    @classmethod
    def create(cls, arg : "Item_212.cv_arg") -> "Item_212":
        return cls._create(arg) # type: ignore

class NonSpare_632(NonSpare):
    cv_arg: TypeAlias = RuleVariation_25.cv_arg
    cv_name = "ASM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_25

    @classmethod
    def create(cls, arg : "NonSpare_632.cv_arg") -> "NonSpare_632":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_25:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_25:
        return self.rule.variation

class Item_86(Item):
    cv_arg: TypeAlias = NonSpare_632.cv_arg
    cv_non_spare: TypeAlias = NonSpare_632

    @classmethod
    def create(cls, arg : "Item_86.cv_arg") -> "Item_86":
        return cls._create(arg) # type: ignore

class NonSpare_1097(NonSpare):
    cv_arg: TypeAlias = RuleVariation_397.cv_arg
    cv_name = "IAVM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_397

    @classmethod
    def create(cls, arg : "NonSpare_1097.cv_arg") -> "NonSpare_1097":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_397:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_408:
        return self.rule.variation

class Item_421(Item):
    cv_arg: TypeAlias = NonSpare_1097.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1097

    @classmethod
    def create(cls, arg : "Item_421.cv_arg") -> "Item_421":
        return cls._create(arg) # type: ignore

class NonSpare_997(NonSpare):
    cv_arg: TypeAlias = RuleVariation_503.cv_arg
    cv_name = "FTD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_503

    @classmethod
    def create(cls, arg : "NonSpare_997.cv_arg") -> "NonSpare_997":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_503:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_514:
        return self.rule.variation

class Item_349(Item):
    cv_arg: TypeAlias = NonSpare_997.cv_arg
    cv_non_spare: TypeAlias = NonSpare_997

    @classmethod
    def create(cls, arg : "Item_349.cv_arg") -> "Item_349":
        return cls._create(arg) # type: ignore

class NonSpare_1121(NonSpare):
    cv_arg: TypeAlias = RuleVariation_609.cv_arg
    cv_name = "ITD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_609

    @classmethod
    def create(cls, arg : "NonSpare_1121.cv_arg") -> "NonSpare_1121":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_609:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_620:
        return self.rule.variation

class Item_439(Item):
    cv_arg: TypeAlias = NonSpare_1121.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1121

    @classmethod
    def create(cls, arg : "Item_439.cv_arg") -> "Item_439":
        return cls._create(arg) # type: ignore

class NonSpare_1112(NonSpare):
    cv_arg: TypeAlias = RuleVariation_693.cv_arg
    cv_name = "IIA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_693

    @classmethod
    def create(cls, arg : "NonSpare_1112.cv_arg") -> "NonSpare_1112":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_693:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_704:
        return self.rule.variation

class Item_432(Item):
    cv_arg: TypeAlias = NonSpare_1112.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1112

    @classmethod
    def create(cls, arg : "Item_432.cv_arg") -> "Item_432":
        return cls._create(arg) # type: ignore

class NonSpare_1733(NonSpare):
    cv_arg: TypeAlias = RuleVariation_803.cv_arg
    cv_name = "SQW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_803

    @classmethod
    def create(cls, arg : "NonSpare_1733.cv_arg") -> "NonSpare_1733":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_803:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_833:
        return self.rule.variation

class Item_912(Item):
    cv_arg: TypeAlias = NonSpare_1733.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1733

    @classmethod
    def create(cls, arg : "Item_912.cv_arg") -> "Item_912":
        return cls._create(arg) # type: ignore

class NonSpare_843(NonSpare):
    cv_arg: TypeAlias = RuleVariation_876.cv_arg
    cv_name = "CUW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_876

    @classmethod
    def create(cls, arg : "NonSpare_843.cv_arg") -> "NonSpare_843":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_876:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_906:
        return self.rule.variation

class Item_230(Item):
    cv_arg: TypeAlias = NonSpare_843.cv_arg
    cv_non_spare: TypeAlias = NonSpare_843

    @classmethod
    def create(cls, arg : "Item_230.cv_arg") -> "Item_230":
        return cls._create(arg) # type: ignore

class NonSpare_701(NonSpare):
    cv_arg: TypeAlias = RuleVariation_26.cv_arg
    cv_name = "CATC"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_26

    @classmethod
    def create(cls, arg : "NonSpare_701.cv_arg") -> "NonSpare_701":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_26:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_26:
        return self.rule.variation

class Item_136(Item):
    cv_arg: TypeAlias = NonSpare_701.cv_arg
    cv_non_spare: TypeAlias = NonSpare_701

    @classmethod
    def create(cls, arg : "Item_136.cv_arg") -> "Item_136":
        return cls._create(arg) # type: ignore

class NonSpare_1353(NonSpare):
    cv_arg: TypeAlias = RuleVariation_401.cv_arg
    cv_name = "NOCLR"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_401

    @classmethod
    def create(cls, arg : "NonSpare_1353.cv_arg") -> "NonSpare_1353":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_401:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_412:
        return self.rule.variation

class Item_619(Item):
    cv_arg: TypeAlias = NonSpare_1353.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1353

    @classmethod
    def create(cls, arg : "Item_619.cv_arg") -> "Item_619":
        return cls._create(arg) # type: ignore

class NonSpare_1366(NonSpare):
    cv_arg: TypeAlias = RuleVariation_507.cv_arg
    cv_name = "NOMOV"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_507

    @classmethod
    def create(cls, arg : "NonSpare_1366.cv_arg") -> "NonSpare_1366":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_507:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_518:
        return self.rule.variation

class Item_632(Item):
    cv_arg: TypeAlias = NonSpare_1366.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1366

    @classmethod
    def create(cls, arg : "Item_632.cv_arg") -> "Item_632":
        return cls._create(arg) # type: ignore

class NonSpare_1361(NonSpare):
    cv_arg: TypeAlias = RuleVariation_616.cv_arg
    cv_name = "NOH"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_616

    @classmethod
    def create(cls, arg : "NonSpare_1361.cv_arg") -> "NonSpare_1361":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_616:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_627:
        return self.rule.variation

class Item_627(Item):
    cv_arg: TypeAlias = NonSpare_1361.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1361

    @classmethod
    def create(cls, arg : "Item_627.cv_arg") -> "Item_627":
        return cls._create(arg) # type: ignore

class NonSpare_2052(NonSpare):
    cv_arg: TypeAlias = RuleVariation_701.cv_arg
    cv_name = "WRTY"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_701

    @classmethod
    def create(cls, arg : "NonSpare_2052.cv_arg") -> "NonSpare_2052":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_701:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_712:
        return self.rule.variation

class Item_1162(Item):
    cv_arg: TypeAlias = NonSpare_2052.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2052

    @classmethod
    def create(cls, arg : "Item_1162.cv_arg") -> "Item_1162":
        return cls._create(arg) # type: ignore

class NonSpare_1783(NonSpare):
    cv_arg: TypeAlias = RuleVariation_804.cv_arg
    cv_name = "STOCC"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_804

    @classmethod
    def create(cls, arg : "NonSpare_1783.cv_arg") -> "NonSpare_1783":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_804:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_834:
        return self.rule.variation

class Item_949(Item):
    cv_arg: TypeAlias = NonSpare_1783.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1783

    @classmethod
    def create(cls, arg : "Item_949.cv_arg") -> "Item_949":
        return cls._create(arg) # type: ignore

class NonSpare_1388(NonSpare):
    cv_arg: TypeAlias = RuleVariation_882.cv_arg
    cv_name = "ONGOING"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_882

    @classmethod
    def create(cls, arg : "NonSpare_1388.cv_arg") -> "NonSpare_1388":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_882:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_912:
        return self.rule.variation

class Item_653(Item):
    cv_arg: TypeAlias = NonSpare_1388.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1388

    @classmethod
    def create(cls, arg : "Item_653.cv_arg") -> "Item_653":
        return cls._create(arg) # type: ignore

class Variation_1364(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_32.cv_arg, Tuple[Literal["MRVA"], RuleVariation_32.cv_arg]], Union[RuleVariation_403.cv_arg, Tuple[Literal["RAMLD"], RuleVariation_403.cv_arg]], Union[RuleVariation_510.cv_arg, Tuple[Literal["RAMHD"], RuleVariation_510.cv_arg]], Union[RuleVariation_612.cv_arg, Tuple[Literal["MSAW"], RuleVariation_612.cv_arg]], Union[RuleVariation_691.cv_arg, Tuple[Literal["APW"], RuleVariation_691.cv_arg]], Union[RuleVariation_797.cv_arg, Tuple[Literal["CLAM"], RuleVariation_797.cv_arg]], Union[RuleVariation_886.cv_arg, Tuple[Literal["STCA"], RuleVariation_886.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_24.cv_arg, Tuple[Literal["APM"], RuleVariation_24.cv_arg]], Union[RuleVariation_404.cv_arg, Tuple[Literal["RIMCA"], RuleVariation_404.cv_arg]], Union[RuleVariation_500.cv_arg, Tuple[Literal["ACASRA"], RuleVariation_500.cv_arg]], Union[RuleVariation_617.cv_arg, Tuple[Literal["NTCA"], RuleVariation_617.cv_arg]], Union[RuleVariation_697.cv_arg, Tuple[Literal["DG"], RuleVariation_697.cv_arg]], Union[RuleVariation_801.cv_arg, Tuple[Literal["OF"], RuleVariation_801.cv_arg]], Union[RuleVariation_883.cv_arg, Tuple[Literal["OL"], RuleVariation_883.cv_arg]], None]]
    cv_arg_group_3: TypeAlias = Union[int, Tuple[Union[RuleVariation_23.cv_arg, Tuple[Literal["AIW"], RuleVariation_23.cv_arg]], Union[RuleVariation_402.cv_arg, Tuple[Literal["PAIW"], RuleVariation_402.cv_arg]], Union[RuleVariation_508.cv_arg, Tuple[Literal["OCAT"], RuleVariation_508.cv_arg]], Union[RuleVariation_618.cv_arg, Tuple[Literal["SAM"], RuleVariation_618.cv_arg]], Union[RuleVariation_698.cv_arg, Tuple[Literal["VCD"], RuleVariation_698.cv_arg]], Union[RuleVariation_796.cv_arg, Tuple[Literal["CHAM"], RuleVariation_796.cv_arg]], Union[RuleVariation_877.cv_arg, Tuple[Literal["DSAM"], RuleVariation_877.cv_arg]], None]]
    cv_arg_group_4: TypeAlias = Union[int, Tuple[Union[RuleVariation_27.cv_arg, Tuple[Literal["DBPSMARR"], RuleVariation_27.cv_arg]], Union[RuleVariation_393.cv_arg, Tuple[Literal["DBPSMDEP"], RuleVariation_393.cv_arg]], Union[RuleVariation_502.cv_arg, Tuple[Literal["DBPSMTL"], RuleVariation_502.cv_arg]], Union[RuleVariation_620.cv_arg, Tuple[Literal["VRAMCRM"], RuleVariation_620.cv_arg]], Union[RuleVariation_700.cv_arg, Tuple[Literal["VRAMVTM"], RuleVariation_700.cv_arg]], Union[RuleVariation_808.cv_arg, Tuple[Literal["VRAMVRM"], RuleVariation_808.cv_arg]], Union[RuleVariation_880.cv_arg, Tuple[Literal["HAMHD"], RuleVariation_880.cv_arg]], None]]
    cv_arg_group_5: TypeAlias = Union[int, Tuple[Union[RuleVariation_29.cv_arg, Tuple[Literal["HAMRD"], RuleVariation_29.cv_arg]], Union[RuleVariation_396.cv_arg, Tuple[Literal["HAMVD"], RuleVariation_396.cv_arg]], Union[RuleVariation_504.cv_arg, Tuple[Literal["HVI"], RuleVariation_504.cv_arg]], Union[RuleVariation_611.cv_arg, Tuple[Literal["LTW"], RuleVariation_611.cv_arg]], Union[RuleVariation_699.cv_arg, Tuple[Literal["VPM"], RuleVariation_699.cv_arg]], Union[RuleVariation_806.cv_arg, Tuple[Literal["TTA"], RuleVariation_806.cv_arg]], Union[RuleVariation_875.cv_arg, Tuple[Literal["CRA"], RuleVariation_875.cv_arg]], None]]
    cv_arg_group_6: TypeAlias = Union[int, Tuple[Union[RuleVariation_25.cv_arg, Tuple[Literal["ASM"], RuleVariation_25.cv_arg]], Union[RuleVariation_397.cv_arg, Tuple[Literal["IAVM"], RuleVariation_397.cv_arg]], Union[RuleVariation_503.cv_arg, Tuple[Literal["FTD"], RuleVariation_503.cv_arg]], Union[RuleVariation_609.cv_arg, Tuple[Literal["ITD"], RuleVariation_609.cv_arg]], Union[RuleVariation_693.cv_arg, Tuple[Literal["IIA"], RuleVariation_693.cv_arg]], Union[RuleVariation_803.cv_arg, Tuple[Literal["SQW"], RuleVariation_803.cv_arg]], Union[RuleVariation_876.cv_arg, Tuple[Literal["CUW"], RuleVariation_876.cv_arg]], None]]
    cv_arg_group_7: TypeAlias = Union[int, Tuple[Union[RuleVariation_26.cv_arg, Tuple[Literal["CATC"], RuleVariation_26.cv_arg]], Union[RuleVariation_401.cv_arg, Tuple[Literal["NOCLR"], RuleVariation_401.cv_arg]], Union[RuleVariation_507.cv_arg, Tuple[Literal["NOMOV"], RuleVariation_507.cv_arg]], Union[RuleVariation_616.cv_arg, Tuple[Literal["NOH"], RuleVariation_616.cv_arg]], Union[RuleVariation_701.cv_arg, Tuple[Literal["WRTY"], RuleVariation_701.cv_arg]], Union[RuleVariation_804.cv_arg, Tuple[Literal["STOCC"], RuleVariation_804.cv_arg]], Union[RuleVariation_882.cv_arg, Tuple[Literal["ONGOING"], RuleVariation_882.cv_arg]], None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1364.cv_arg_group_1"],
        Tuple["Variation_1364.cv_arg_group_1", "Variation_1364.cv_arg_group_2"],
        Tuple["Variation_1364.cv_arg_group_1", "Variation_1364.cv_arg_group_2", "Variation_1364.cv_arg_group_3"],
        Tuple["Variation_1364.cv_arg_group_1", "Variation_1364.cv_arg_group_2", "Variation_1364.cv_arg_group_3", "Variation_1364.cv_arg_group_4"],
        Tuple["Variation_1364.cv_arg_group_1", "Variation_1364.cv_arg_group_2", "Variation_1364.cv_arg_group_3", "Variation_1364.cv_arg_group_4", "Variation_1364.cv_arg_group_5"],
        Tuple["Variation_1364.cv_arg_group_1", "Variation_1364.cv_arg_group_2", "Variation_1364.cv_arg_group_3", "Variation_1364.cv_arg_group_4", "Variation_1364.cv_arg_group_5", "Variation_1364.cv_arg_group_6"],
        Tuple["Variation_1364.cv_arg_group_1", "Variation_1364.cv_arg_group_2", "Variation_1364.cv_arg_group_3", "Variation_1364.cv_arg_group_4", "Variation_1364.cv_arg_group_5", "Variation_1364.cv_arg_group_6", "Variation_1364.cv_arg_group_7"],
    ]
    cv_items_list = [[(Item_581, 1), (Item_772, 1), (Item_771, 1), (Item_584, 1), (Item_78, 1), (Item_161, 1), (Item_943, 1), None], [(Item_77, 1), (Item_817, 1), (Item_40, 1), (Item_636, 1), (Item_258, 1), (Item_650, 1), (Item_651, 1), None], [(Item_56, 1), (Item_673, 1), (Item_644, 1), (Item_854, 1), (Item_1132, 1), (Item_154, 1), (Item_274, 1), None], [(Item_241, 1), (Item_243, 1), (Item_245, 1), (Item_1143, 1), (Item_1146, 1), (Item_1145, 1), (Item_380, 1), None], [(Item_382, 1), (Item_384, 1), (Item_405, 1), (Item_507, 1), (Item_1141, 1), (Item_1056, 1), (Item_212, 1), None], [(Item_86, 1), (Item_421, 1), (Item_349, 1), (Item_439, 1), (Item_432, 1), (Item_912, 1), (Item_230, 1), None], [(Item_136, 1), (Item_619, 1), (Item_632, 1), (Item_627, 1), (Item_1162, 1), (Item_949, 1), (Item_653, 1), None]]

    @classmethod
    def create(cls, arg: "Variation_1364.cv_arg") -> 'Variation_1364':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["MRVA"]) -> RuleVariation_32:
        ...
    @overload
    def get_item(self, key : Literal["RAMLD"]) -> RuleVariation_403:
        ...
    @overload
    def get_item(self, key : Literal["RAMHD"]) -> RuleVariation_510:
        ...
    @overload
    def get_item(self, key : Literal["MSAW"]) -> RuleVariation_612:
        ...
    @overload
    def get_item(self, key : Literal["APW"]) -> RuleVariation_691:
        ...
    @overload
    def get_item(self, key : Literal["CLAM"]) -> RuleVariation_797:
        ...
    @overload
    def get_item(self, key : Literal["STCA"]) -> RuleVariation_886:
        ...
    @overload
    def get_item(self, key : Literal["APM"]) -> Optional[RuleVariation_24]:
        ...
    @overload
    def get_item(self, key : Literal["RIMCA"]) -> Optional[RuleVariation_404]:
        ...
    @overload
    def get_item(self, key : Literal["ACASRA"]) -> Optional[RuleVariation_500]:
        ...
    @overload
    def get_item(self, key : Literal["NTCA"]) -> Optional[RuleVariation_617]:
        ...
    @overload
    def get_item(self, key : Literal["DG"]) -> Optional[RuleVariation_697]:
        ...
    @overload
    def get_item(self, key : Literal["OF"]) -> Optional[RuleVariation_801]:
        ...
    @overload
    def get_item(self, key : Literal["OL"]) -> Optional[RuleVariation_883]:
        ...
    @overload
    def get_item(self, key : Literal["AIW"]) -> Optional[RuleVariation_23]:
        ...
    @overload
    def get_item(self, key : Literal["PAIW"]) -> Optional[RuleVariation_402]:
        ...
    @overload
    def get_item(self, key : Literal["OCAT"]) -> Optional[RuleVariation_508]:
        ...
    @overload
    def get_item(self, key : Literal["SAM"]) -> Optional[RuleVariation_618]:
        ...
    @overload
    def get_item(self, key : Literal["VCD"]) -> Optional[RuleVariation_698]:
        ...
    @overload
    def get_item(self, key : Literal["CHAM"]) -> Optional[RuleVariation_796]:
        ...
    @overload
    def get_item(self, key : Literal["DSAM"]) -> Optional[RuleVariation_877]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMARR"]) -> Optional[RuleVariation_27]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMDEP"]) -> Optional[RuleVariation_393]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMTL"]) -> Optional[RuleVariation_502]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMCRM"]) -> Optional[RuleVariation_620]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMVTM"]) -> Optional[RuleVariation_700]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMVRM"]) -> Optional[RuleVariation_808]:
        ...
    @overload
    def get_item(self, key : Literal["HAMHD"]) -> Optional[RuleVariation_880]:
        ...
    @overload
    def get_item(self, key : Literal["HAMRD"]) -> Optional[RuleVariation_29]:
        ...
    @overload
    def get_item(self, key : Literal["HAMVD"]) -> Optional[RuleVariation_396]:
        ...
    @overload
    def get_item(self, key : Literal["HVI"]) -> Optional[RuleVariation_504]:
        ...
    @overload
    def get_item(self, key : Literal["LTW"]) -> Optional[RuleVariation_611]:
        ...
    @overload
    def get_item(self, key : Literal["VPM"]) -> Optional[RuleVariation_699]:
        ...
    @overload
    def get_item(self, key : Literal["TTA"]) -> Optional[RuleVariation_806]:
        ...
    @overload
    def get_item(self, key : Literal["CRA"]) -> Optional[RuleVariation_875]:
        ...
    @overload
    def get_item(self, key : Literal["ASM"]) -> Optional[RuleVariation_25]:
        ...
    @overload
    def get_item(self, key : Literal["IAVM"]) -> Optional[RuleVariation_397]:
        ...
    @overload
    def get_item(self, key : Literal["FTD"]) -> Optional[RuleVariation_503]:
        ...
    @overload
    def get_item(self, key : Literal["ITD"]) -> Optional[RuleVariation_609]:
        ...
    @overload
    def get_item(self, key : Literal["IIA"]) -> Optional[RuleVariation_693]:
        ...
    @overload
    def get_item(self, key : Literal["SQW"]) -> Optional[RuleVariation_803]:
        ...
    @overload
    def get_item(self, key : Literal["CUW"]) -> Optional[RuleVariation_876]:
        ...
    @overload
    def get_item(self, key : Literal["CATC"]) -> Optional[RuleVariation_26]:
        ...
    @overload
    def get_item(self, key : Literal["NOCLR"]) -> Optional[RuleVariation_401]:
        ...
    @overload
    def get_item(self, key : Literal["NOMOV"]) -> Optional[RuleVariation_507]:
        ...
    @overload
    def get_item(self, key : Literal["NOH"]) -> Optional[RuleVariation_616]:
        ...
    @overload
    def get_item(self, key : Literal["WRTY"]) -> Optional[RuleVariation_701]:
        ...
    @overload
    def get_item(self, key : Literal["STOCC"]) -> Optional[RuleVariation_804]:
        ...
    @overload
    def get_item(self, key : Literal["ONGOING"]) -> Optional[RuleVariation_882]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1286(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1364.cv_arg
    cv_variation: TypeAlias = Variation_1364

    @classmethod
    def create(cls, arg : "RuleVariation_1286.cv_arg") -> "RuleVariation_1286":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1364:
        return self.arg # type: ignore

class NonSpare_192(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1286.cv_arg
    cv_name = "060"
    cv_title = "Safety Net Function and System Status"
    cv_rule: TypeAlias = RuleVariation_1286

    @classmethod
    def create(cls, arg : "NonSpare_192.cv_arg") -> "NonSpare_192":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1286:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1364:
        return self.rule.variation

class UapItem_192(UapItem):
    cv_non_spare: TypeAlias = NonSpare_192

class NonSpare_112(NonSpare):
    cv_arg: TypeAlias = RuleVariation_244.cv_arg
    cv_name = "030"
    cv_title = "Track Number 1"
    cv_rule: TypeAlias = RuleVariation_244

    @classmethod
    def create(cls, arg : "NonSpare_112.cv_arg") -> "NonSpare_112":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_244:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_251:
        return self.rule.variation

class UapItem_112(UapItem):
    cv_non_spare: TypeAlias = NonSpare_112

class Content_606(ContentString):
    cv_arg: TypeAlias = Union[int, str]
    cv_string_type: TypeAlias = StringAscii

class RuleContent_606(RuleContentContextFree):
    cv_arg: TypeAlias = Content_606.cv_arg
    cv_content: TypeAlias = Content_606

    @property
    def content(self) -> Content_606:
        return self._get_content() # type: ignore

class Variation_391(Element):
    cv_arg: TypeAlias = RuleContent_606.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 56
    cv_rule = RuleContent_606

    @classmethod
    def create(cls, arg: "Variation_391.cv_arg") -> "Variation_391":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_606:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_606:
        return self.rule.content

class RuleVariation_383(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_391.cv_arg
    cv_variation: TypeAlias = Variation_391

    @classmethod
    def create(cls, arg : "RuleVariation_383.cv_arg") -> "RuleVariation_383":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_391:
        return self.arg # type: ignore

class NonSpare_581(NonSpare):
    cv_arg: TypeAlias = RuleVariation_383.cv_arg
    cv_name = "AI1"
    cv_title = "Aircraft Identifier (in 7 Characters) of Aircraft 1 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_383

    @classmethod
    def create(cls, arg : "NonSpare_581.cv_arg") -> "NonSpare_581":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_391:
        return self.rule.variation

class NonSpare_1298(NonSpare):
    cv_arg: TypeAlias = RuleVariation_776.cv_arg
    cv_name = "MODE3A"
    cv_title = "Mode-3/A Code (Converted Into Octal Representation) of Aircraft 1 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_776

    @classmethod
    def create(cls, arg : "NonSpare_1298.cv_arg") -> "NonSpare_1298":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_776:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_806:
        return self.rule.variation

class Item_570(Item):
    cv_arg: TypeAlias = NonSpare_1298.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1298

    @classmethod
    def create(cls, arg : "Item_570.cv_arg") -> "Item_570":
        return cls._create(arg) # type: ignore

class Variation_1024(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_776.cv_arg, Tuple[Literal["MODE3A"], RuleVariation_776.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1024.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_3, 4), (Item_570, 12)]
    cv_items_dict = {"MODE3A": RuleVariation_776}

    @classmethod
    def spec(cls, key : Literal["MODE3A"]) -> RuleVariation_776:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["MODE3A"]) -> RuleVariation_776:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1024.cv_arg") -> 'Variation_1024':
        return cls._create(arg) # type: ignore

class RuleVariation_993(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1024.cv_arg
    cv_variation: TypeAlias = Variation_1024

    @classmethod
    def create(cls, arg : "RuleVariation_993.cv_arg") -> "RuleVariation_993":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1024:
        return self.arg # type: ignore

class NonSpare_1205(NonSpare):
    cv_arg: TypeAlias = RuleVariation_993.cv_arg
    cv_name = "M31"
    cv_title = "Mode 3/A Code Aircraft 1"
    cv_rule: TypeAlias = RuleVariation_993

    @classmethod
    def create(cls, arg : "NonSpare_1205.cv_arg") -> "NonSpare_1205":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_993:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1024:
        return self.rule.variation

class Content_696(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 5.364418029785156e-6
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_696(RuleContentContextFree):
    cv_arg: TypeAlias = Content_696.cv_arg
    cv_content: TypeAlias = Content_696

    @property
    def content(self) -> Content_696:
        return self._get_content() # type: ignore

class Variation_376(Element):
    cv_arg: TypeAlias = RuleContent_696.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_rule = RuleContent_696

    @classmethod
    def create(cls, arg: "Variation_376.cv_arg") -> "Variation_376":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_696:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_696:
        return self.rule.content

class RuleVariation_369(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_376.cv_arg
    cv_variation: TypeAlias = Variation_376

    @classmethod
    def create(cls, arg : "RuleVariation_369.cv_arg") -> "RuleVariation_369":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_376:
        return self.arg # type: ignore

class NonSpare_1141(NonSpare):
    cv_arg: TypeAlias = RuleVariation_369.cv_arg
    cv_name = "LAT"
    cv_title = "In WGS-84 in Two’s Complement"
    cv_rule: TypeAlias = RuleVariation_369

    @classmethod
    def create(cls, arg : "NonSpare_1141.cv_arg") -> "NonSpare_1141":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_369:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_376:
        return self.rule.variation

class Item_459(Item):
    cv_arg: TypeAlias = NonSpare_1141.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1141

    @classmethod
    def create(cls, arg : "Item_459.cv_arg") -> "Item_459":
        return cls._create(arg) # type: ignore

class Content_695(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 5.364418029785156e-6
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_695(RuleContentContextFree):
    cv_arg: TypeAlias = Content_695.cv_arg
    cv_content: TypeAlias = Content_695

    @property
    def content(self) -> Content_695:
        return self._get_content() # type: ignore

class Variation_375(Element):
    cv_arg: TypeAlias = RuleContent_695.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_rule = RuleContent_695

    @classmethod
    def create(cls, arg: "Variation_375.cv_arg") -> "Variation_375":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_695:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_695:
        return self.rule.content

class RuleVariation_368(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_375.cv_arg
    cv_variation: TypeAlias = Variation_375

    @classmethod
    def create(cls, arg : "RuleVariation_368.cv_arg") -> "RuleVariation_368":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_375:
        return self.arg # type: ignore

class NonSpare_1169(NonSpare):
    cv_arg: TypeAlias = RuleVariation_368.cv_arg
    cv_name = "LON"
    cv_title = "In WGS-84 in Two’s Complement"
    cv_rule: TypeAlias = RuleVariation_368

    @classmethod
    def create(cls, arg : "NonSpare_1169.cv_arg") -> "NonSpare_1169":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_368:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_375:
        return self.rule.variation

class Item_485(Item):
    cv_arg: TypeAlias = NonSpare_1169.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1169

    @classmethod
    def create(cls, arg : "Item_485.cv_arg") -> "Item_485":
        return cls._create(arg) # type: ignore

class Content_631(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["ft"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 25.0
    cv_unit = "ft"

    def as_quantity(self, cv_unit : Optional[Literal["ft"]] = None) -> float:
        return self._as_quantity()

class RuleContent_631(RuleContentContextFree):
    cv_arg: TypeAlias = Content_631.cv_arg
    cv_content: TypeAlias = Content_631

    @property
    def content(self) -> Content_631:
        return self._get_content() # type: ignore

class Variation_261(Element):
    cv_arg: TypeAlias = RuleContent_631.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_631

    @classmethod
    def create(cls, arg: "Variation_261.cv_arg") -> "Variation_261":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_631:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_631:
        return self.rule.content

class RuleVariation_254(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_261.cv_arg
    cv_variation: TypeAlias = Variation_261

    @classmethod
    def create(cls, arg : "RuleVariation_254.cv_arg") -> "RuleVariation_254":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_261:
        return self.arg # type: ignore

class NonSpare_591(NonSpare):
    cv_arg: TypeAlias = RuleVariation_254.cv_arg
    cv_name = "ALT"
    cv_title = "Altitude of Predicted Conflict"
    cv_rule: TypeAlias = RuleVariation_254

    @classmethod
    def create(cls, arg : "NonSpare_591.cv_arg") -> "NonSpare_591":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_254:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_261:
        return self.rule.variation

class Item_63(Item):
    cv_arg: TypeAlias = NonSpare_591.cv_arg
    cv_non_spare: TypeAlias = NonSpare_591

    @classmethod
    def create(cls, arg : "Item_63.cv_arg") -> "Item_63":
        return cls._create(arg) # type: ignore

class Variation_1121(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_369.cv_arg, Tuple[Literal["LAT"], RuleVariation_369.cv_arg]], Union[RuleVariation_368.cv_arg, Tuple[Literal["LON"], RuleVariation_368.cv_arg]], Union[RuleVariation_254.cv_arg, Tuple[Literal["ALT"], RuleVariation_254.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1121.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 80
    cv_items_list = [(Item_459, 32), (Item_485, 32), (Item_63, 16)]
    cv_items_dict = {"LAT": RuleVariation_369, "LON": RuleVariation_368, "ALT": RuleVariation_254}

    @overload
    @classmethod
    def spec(cls, key : Literal["LAT"]) -> RuleVariation_369:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["LON"]) -> RuleVariation_368:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ALT"]) -> RuleVariation_254:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["LAT"], Literal["LON"], Literal["ALT"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["LAT"]) -> RuleVariation_369:
        ...
    @overload
    def get_item(self, key : Literal["LON"]) -> RuleVariation_368:
        ...
    @overload
    def get_item(self, key : Literal["ALT"]) -> RuleVariation_254:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1121.cv_arg") -> 'Variation_1121':
        return cls._create(arg) # type: ignore

class RuleVariation_1077(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1121.cv_arg
    cv_variation: TypeAlias = Variation_1121

    @classmethod
    def create(cls, arg : "RuleVariation_1077.cv_arg") -> "RuleVariation_1077":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1121:
        return self.arg # type: ignore

class NonSpare_816(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1077.cv_arg
    cv_name = "CPW"
    cv_title = "Predicted Conflict Position Target 1 in WGS-84 Coordinates"
    cv_rule: TypeAlias = RuleVariation_1077

    @classmethod
    def create(cls, arg : "NonSpare_816.cv_arg") -> "NonSpare_816":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1077:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1121:
        return self.rule.variation

class Content_636(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.5
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_636(RuleContentContextFree):
    cv_arg: TypeAlias = Content_636.cv_arg
    cv_content: TypeAlias = Content_636

    @property
    def content(self) -> Content_636:
        return self._get_content() # type: ignore

class Variation_350(Element):
    cv_arg: TypeAlias = RuleContent_636.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_rule = RuleContent_636

    @classmethod
    def create(cls, arg: "Variation_350.cv_arg") -> "Variation_350":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_636:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_636:
        return self.rule.content

class RuleVariation_343(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_350.cv_arg
    cv_variation: TypeAlias = Variation_350

    @classmethod
    def create(cls, arg : "RuleVariation_343.cv_arg") -> "RuleVariation_343":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_350:
        return self.arg # type: ignore

class NonSpare_2081(NonSpare):
    cv_arg: TypeAlias = RuleVariation_343.cv_arg
    cv_name = "X"
    cv_title = "Starting X-position of the Conflict"
    cv_rule: TypeAlias = RuleVariation_343

    @classmethod
    def create(cls, arg : "NonSpare_2081.cv_arg") -> "NonSpare_2081":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_343:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_350:
        return self.rule.variation

class Item_1188(Item):
    cv_arg: TypeAlias = NonSpare_2081.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2081

    @classmethod
    def create(cls, arg : "Item_1188.cv_arg") -> "Item_1188":
        return cls._create(arg) # type: ignore

class NonSpare_2134(NonSpare):
    cv_arg: TypeAlias = RuleVariation_343.cv_arg
    cv_name = "Y"
    cv_title = "Starting Y-position of the Conflict"
    cv_rule: TypeAlias = RuleVariation_343

    @classmethod
    def create(cls, arg : "NonSpare_2134.cv_arg") -> "NonSpare_2134":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_343:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_350:
        return self.rule.variation

class Item_1238(Item):
    cv_arg: TypeAlias = NonSpare_2134.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2134

    @classmethod
    def create(cls, arg : "Item_1238.cv_arg") -> "Item_1238":
        return cls._create(arg) # type: ignore

class NonSpare_2152(NonSpare):
    cv_arg: TypeAlias = RuleVariation_254.cv_arg
    cv_name = "Z"
    cv_title = "Starting Z-position of the Conflict"
    cv_rule: TypeAlias = RuleVariation_254

    @classmethod
    def create(cls, arg : "NonSpare_2152.cv_arg") -> "NonSpare_2152":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_254:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_261:
        return self.rule.variation

class Item_1256(Item):
    cv_arg: TypeAlias = NonSpare_2152.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2152

    @classmethod
    def create(cls, arg : "Item_1256.cv_arg") -> "Item_1256":
        return cls._create(arg) # type: ignore

class Variation_1301(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_343.cv_arg, Tuple[Literal["X"], RuleVariation_343.cv_arg]], Union[RuleVariation_343.cv_arg, Tuple[Literal["Y"], RuleVariation_343.cv_arg]], Union[RuleVariation_254.cv_arg, Tuple[Literal["Z"], RuleVariation_254.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1301.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 64
    cv_items_list = [(Item_1188, 24), (Item_1238, 24), (Item_1256, 16)]
    cv_items_dict = {"X": RuleVariation_343, "Y": RuleVariation_343, "Z": RuleVariation_254}

    @overload
    @classmethod
    def spec(cls, key : Literal["X"]) -> RuleVariation_343:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y"]) -> RuleVariation_343:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Z"]) -> RuleVariation_254:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X"], Literal["Y"], Literal["Z"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X"]) -> RuleVariation_343:
        ...
    @overload
    def get_item(self, key : Literal["Y"]) -> RuleVariation_343:
        ...
    @overload
    def get_item(self, key : Literal["Z"]) -> RuleVariation_254:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1301.cv_arg") -> 'Variation_1301':
        return cls._create(arg) # type: ignore

class RuleVariation_1230(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1301.cv_arg
    cv_variation: TypeAlias = Variation_1301

    @classmethod
    def create(cls, arg : "RuleVariation_1230.cv_arg") -> "RuleVariation_1230":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1301:
        return self.arg # type: ignore

class NonSpare_811(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1230.cv_arg
    cv_name = "CPC"
    cv_title = "Predicted Conflict Position for the Aircraft 1 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_1230

    @classmethod
    def create(cls, arg : "NonSpare_811.cv_arg") -> "NonSpare_811":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1230:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1301:
        return self.rule.variation

class NonSpare_1933(NonSpare):
    cv_arg: TypeAlias = RuleVariation_361.cv_arg
    cv_name = "TT1"
    cv_title = "Time to Runway Threshold for First Approaching Aircraft in a RIMCA"
    cv_rule: TypeAlias = RuleVariation_361

    @classmethod
    def create(cls, arg : "NonSpare_1933.cv_arg") -> "NonSpare_1933":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_361:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_368:
        return self.rule.variation

class Content_729(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 0.5
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_729(RuleContentContextFree):
    cv_arg: TypeAlias = Content_729.cv_arg
    cv_content: TypeAlias = Content_729

    @property
    def content(self) -> Content_729:
        return self._get_content() # type: ignore

class Variation_309(Element):
    cv_arg: TypeAlias = RuleContent_729.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_729

    @classmethod
    def create(cls, arg: "Variation_309.cv_arg") -> "Variation_309":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_729:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_729:
        return self.rule.content

class RuleVariation_302(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_309.cv_arg
    cv_variation: TypeAlias = Variation_309

    @classmethod
    def create(cls, arg : "RuleVariation_302.cv_arg") -> "RuleVariation_302":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_309:
        return self.arg # type: ignore

class NonSpare_897(NonSpare):
    cv_arg: TypeAlias = RuleVariation_302.cv_arg
    cv_name = "DT1"
    cv_title = "Distance to Runway Threshold for Aircraft 1 Involved in a RIMCA"
    cv_rule: TypeAlias = RuleVariation_302

    @classmethod
    def create(cls, arg : "NonSpare_897.cv_arg") -> "NonSpare_897":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_302:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_309:
        return self.rule.variation

class Content_546(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Unknown", 1: "General Air Traffic", 2: "Operational Air Traffic", 3: "Not applicable"}

class RuleContent_546(RuleContentContextFree):
    cv_arg: TypeAlias = Content_546.cv_arg
    cv_content: TypeAlias = Content_546

    @property
    def content(self) -> Content_546:
        return self._get_content() # type: ignore

class Variation_115(Element):
    cv_arg: TypeAlias = RuleContent_546.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 2
    cv_rule = RuleContent_546

    @classmethod
    def create(cls, arg: "Variation_115.cv_arg") -> "Variation_115":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_546:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_546:
        return self.rule.content

class RuleVariation_115(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_115.cv_arg
    cv_variation: TypeAlias = Variation_115

    @classmethod
    def create(cls, arg : "RuleVariation_115.cv_arg") -> "RuleVariation_115":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_115:
        return self.arg # type: ignore

class Content_244(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Instrument Flight Rules", 1: "Visual Flight rules", 2: "Not applicable", 3: "Controlled Visual Flight Rules"}

class RuleContent_244(RuleContentContextFree):
    cv_arg: TypeAlias = Content_244.cv_arg
    cv_content: TypeAlias = Content_244

    @property
    def content(self) -> Content_244:
        return self._get_content() # type: ignore

class Variation_589(Element):
    cv_arg: TypeAlias = RuleContent_244.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 2
    cv_rule = RuleContent_244

    @classmethod
    def create(cls, arg: "Variation_589.cv_arg") -> "Variation_589":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_244:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_244:
        return self.rule.content

class RuleVariation_578(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_589.cv_arg
    cv_variation: TypeAlias = Variation_589

    @classmethod
    def create(cls, arg : "RuleVariation_578.cv_arg") -> "RuleVariation_578":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_589:
        return self.arg # type: ignore

class Content_539(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Unknown", 1: "Approved", 2: "Exempt", 3: "Not Approved"}

class RuleContent_539(RuleContentContextFree):
    cv_arg: TypeAlias = Content_539.cv_arg
    cv_content: TypeAlias = Content_539

    @property
    def content(self) -> Content_539:
        return self._get_content() # type: ignore

class Variation_766(Element):
    cv_arg: TypeAlias = RuleContent_539.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 2
    cv_rule = RuleContent_539

    @classmethod
    def create(cls, arg: "Variation_766.cv_arg") -> "Variation_766":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_539:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_539:
        return self.rule.content

class RuleVariation_755(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_766.cv_arg
    cv_variation: TypeAlias = Variation_766

    @classmethod
    def create(cls, arg : "RuleVariation_755.cv_arg") -> "RuleVariation_755":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_766:
        return self.arg # type: ignore

class Content_381(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Normal Priority Flight", 1: "High Priority Flight"}

class RuleContent_381(RuleContentContextFree):
    cv_arg: TypeAlias = Content_381.cv_arg
    cv_content: TypeAlias = Content_381

    @property
    def content(self) -> Content_381:
        return self._get_content() # type: ignore

class Variation_939(Element):
    cv_arg: TypeAlias = RuleContent_381.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_381

    @classmethod
    def create(cls, arg: "Variation_939.cv_arg") -> "Variation_939":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_381:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_381:
        return self.rule.content

class RuleVariation_909(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_939.cv_arg
    cv_variation: TypeAlias = Variation_939

    @classmethod
    def create(cls, arg : "RuleVariation_909.cv_arg") -> "RuleVariation_909":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_939:
        return self.arg # type: ignore

class Content_261(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Maintaining", 1: "Climbing", 2: "Descending", 3: "Invalid"}

class RuleContent_261(RuleContentContextFree):
    cv_arg: TypeAlias = Content_261.cv_arg
    cv_content: TypeAlias = Content_261

    @property
    def content(self) -> Content_261:
        return self._get_content() # type: ignore

class Variation_103(Element):
    cv_arg: TypeAlias = RuleContent_261.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 2
    cv_rule = RuleContent_261

    @classmethod
    def create(cls, arg: "Variation_103.cv_arg") -> "Variation_103":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_261:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_261:
        return self.rule.content

class RuleVariation_103(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_103.cv_arg
    cv_variation: TypeAlias = Variation_103

    @classmethod
    def create(cls, arg : "RuleVariation_103.cv_arg") -> "RuleVariation_103":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_103:
        return self.arg # type: ignore

class Content_376(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Non primary target", 1: "Primary target"}

class RuleContent_376(RuleContentContextFree):
    cv_arg: TypeAlias = Content_376.cv_arg
    cv_content: TypeAlias = Content_376

    @property
    def content(self) -> Content_376:
        return self._get_content() # type: ignore

class Variation_562(Element):
    cv_arg: TypeAlias = RuleContent_376.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_376

    @classmethod
    def create(cls, arg: "Variation_562.cv_arg") -> "Variation_562":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_376:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_376:
        return self.rule.content

class RuleVariation_551(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_562.cv_arg
    cv_variation: TypeAlias = Variation_562

    @classmethod
    def create(cls, arg : "RuleVariation_551.cv_arg") -> "RuleVariation_551":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_562:
        return self.arg # type: ignore

class Content_100(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Ground Vehicle"}

class RuleContent_100(RuleContentContextFree):
    cv_arg: TypeAlias = Content_100.cv_arg
    cv_content: TypeAlias = Content_100

    @property
    def content(self) -> Content_100:
        return self._get_content() # type: ignore

class Variation_619(Element):
    cv_arg: TypeAlias = RuleContent_100.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_100

    @classmethod
    def create(cls, arg: "Variation_619.cv_arg") -> "Variation_619":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_100:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_100:
        return self.rule.content

class RuleVariation_608(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_619.cv_arg
    cv_variation: TypeAlias = Variation_619

    @classmethod
    def create(cls, arg : "RuleVariation_608.cv_arg") -> "RuleVariation_608":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_619:
        return self.arg # type: ignore

class NonSpare_1018(NonSpare):
    cv_arg: TypeAlias = RuleVariation_115.cv_arg
    cv_name = "GATOAT"
    cv_title = "Identification of Conflict Categories Definition Table"
    cv_rule: TypeAlias = RuleVariation_115

    @classmethod
    def create(cls, arg : "NonSpare_1018.cv_arg") -> "NonSpare_1018":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_115:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_115:
        return self.rule.variation

class Item_362(Item):
    cv_arg: TypeAlias = NonSpare_1018.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1018

    @classmethod
    def create(cls, arg : "Item_362.cv_arg") -> "Item_362":
        return cls._create(arg) # type: ignore

class NonSpare_987(NonSpare):
    cv_arg: TypeAlias = RuleVariation_578.cv_arg
    cv_name = "FR1FR2"
    cv_title = "Flight Rules"
    cv_rule: TypeAlias = RuleVariation_578

    @classmethod
    def create(cls, arg : "NonSpare_987.cv_arg") -> "NonSpare_987":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_578:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_589:
        return self.rule.variation

class Item_342(Item):
    cv_arg: TypeAlias = NonSpare_987.cv_arg
    cv_non_spare: TypeAlias = NonSpare_987

    @classmethod
    def create(cls, arg : "Item_342.cv_arg") -> "Item_342":
        return cls._create(arg) # type: ignore

class NonSpare_1627(NonSpare):
    cv_arg: TypeAlias = RuleVariation_755.cv_arg
    cv_name = "RVSM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_755

    @classmethod
    def create(cls, arg : "NonSpare_1627.cv_arg") -> "NonSpare_1627":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_755:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_766:
        return self.rule.variation

class Item_838(Item):
    cv_arg: TypeAlias = NonSpare_1627.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1627

    @classmethod
    def create(cls, arg : "Item_838.cv_arg") -> "Item_838":
        return cls._create(arg) # type: ignore

class NonSpare_1069(NonSpare):
    cv_arg: TypeAlias = RuleVariation_909.cv_arg
    cv_name = "HPR"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_909

    @classmethod
    def create(cls, arg : "NonSpare_1069.cv_arg") -> "NonSpare_1069":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_909:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_939:
        return self.rule.variation

class Item_399(Item):
    cv_arg: TypeAlias = NonSpare_1069.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1069

    @classmethod
    def create(cls, arg : "Item_399.cv_arg") -> "Item_399":
        return cls._create(arg) # type: ignore

class NonSpare_709(NonSpare):
    cv_arg: TypeAlias = RuleVariation_103.cv_arg
    cv_name = "CDM"
    cv_title = "Climbing/Descending Mode"
    cv_rule: TypeAlias = RuleVariation_103

    @classmethod
    def create(cls, arg : "NonSpare_709.cv_arg") -> "NonSpare_709":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_103:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_103:
        return self.rule.variation

class Item_141(Item):
    cv_arg: TypeAlias = NonSpare_709.cv_arg
    cv_non_spare: TypeAlias = NonSpare_709

    @classmethod
    def create(cls, arg : "Item_141.cv_arg") -> "Item_141":
        return cls._create(arg) # type: ignore

class NonSpare_1454(NonSpare):
    cv_arg: TypeAlias = RuleVariation_551.cv_arg
    cv_name = "PRI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_551

    @classmethod
    def create(cls, arg : "NonSpare_1454.cv_arg") -> "NonSpare_1454":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_551:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_562:
        return self.rule.variation

class Item_703(Item):
    cv_arg: TypeAlias = NonSpare_1454.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1454

    @classmethod
    def create(cls, arg : "Item_703.cv_arg") -> "Item_703":
        return cls._create(arg) # type: ignore

class NonSpare_1038(NonSpare):
    cv_arg: TypeAlias = RuleVariation_608.cv_arg
    cv_name = "GV"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_608

    @classmethod
    def create(cls, arg : "NonSpare_1038.cv_arg") -> "NonSpare_1038":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_608:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_619:
        return self.rule.variation

class Item_377(Item):
    cv_arg: TypeAlias = NonSpare_1038.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1038

    @classmethod
    def create(cls, arg : "Item_377.cv_arg") -> "Item_377":
        return cls._create(arg) # type: ignore

class Item_21(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 4
    cv_bit_size = 3

class Variation_1355(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_115.cv_arg, Tuple[Literal["GATOAT"], RuleVariation_115.cv_arg]], Union[RuleVariation_578.cv_arg, Tuple[Literal["FR1FR2"], RuleVariation_578.cv_arg]], Union[RuleVariation_755.cv_arg, Tuple[Literal["RVSM"], RuleVariation_755.cv_arg]], Union[RuleVariation_909.cv_arg, Tuple[Literal["HPR"], RuleVariation_909.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_103.cv_arg, Tuple[Literal["CDM"], RuleVariation_103.cv_arg]], Union[RuleVariation_551.cv_arg, Tuple[Literal["PRI"], RuleVariation_551.cv_arg]], Union[RuleVariation_608.cv_arg, Tuple[Literal["GV"], RuleVariation_608.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1355.cv_arg_group_1"],
        Tuple["Variation_1355.cv_arg_group_1", "Variation_1355.cv_arg_group_2"],
    ]
    cv_items_list = [[(Item_362, 2), (Item_342, 2), (Item_838, 2), (Item_399, 1), None], [(Item_141, 2), (Item_703, 1), (Item_377, 1), (Item_21, 3), None]]

    @classmethod
    def create(cls, arg: "Variation_1355.cv_arg") -> 'Variation_1355':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["GATOAT"]) -> RuleVariation_115:
        ...
    @overload
    def get_item(self, key : Literal["FR1FR2"]) -> RuleVariation_578:
        ...
    @overload
    def get_item(self, key : Literal["RVSM"]) -> RuleVariation_755:
        ...
    @overload
    def get_item(self, key : Literal["HPR"]) -> RuleVariation_909:
        ...
    @overload
    def get_item(self, key : Literal["CDM"]) -> Optional[RuleVariation_103]:
        ...
    @overload
    def get_item(self, key : Literal["PRI"]) -> Optional[RuleVariation_551]:
        ...
    @overload
    def get_item(self, key : Literal["GV"]) -> Optional[RuleVariation_608]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1277(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1355.cv_arg
    cv_variation: TypeAlias = Variation_1355

    @classmethod
    def create(cls, arg : "RuleVariation_1277.cv_arg") -> "RuleVariation_1277":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1355:
        return self.arg # type: ignore

class NonSpare_553(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1277.cv_arg
    cv_name = "AC1"
    cv_title = "Characteristics of Aircraft 1 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_1277

    @classmethod
    def create(cls, arg : "NonSpare_553.cv_arg") -> "NonSpare_553":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1277:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1355:
        return self.rule.variation

class Variation_388(Element):
    cv_arg: TypeAlias = RuleContent_606.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 48
    cv_rule = RuleContent_606

    @classmethod
    def create(cls, arg: "Variation_388.cv_arg") -> "Variation_388":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_606:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_606:
        return self.rule.content

class RuleVariation_380(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_388.cv_arg
    cv_variation: TypeAlias = Variation_388

    @classmethod
    def create(cls, arg : "RuleVariation_380.cv_arg") -> "RuleVariation_380":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_388:
        return self.arg # type: ignore

class NonSpare_1312(NonSpare):
    cv_arg: TypeAlias = RuleVariation_380.cv_arg
    cv_name = "MS1"
    cv_title = "Aircraft Identification Downloaded from Aircraft 1 Involved in the Conflict If Equipped with a Mode-S Transponder"
    cv_rule: TypeAlias = RuleVariation_380

    @classmethod
    def create(cls, arg : "NonSpare_1312.cv_arg") -> "NonSpare_1312":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_380:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_388:
        return self.rule.variation

class Item_4(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 0
    cv_bit_size = 5

class Content_707(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal[""]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 1.0
    cv_unit = ""

    def as_quantity(self, cv_unit : Optional[Literal[""]] = None) -> float:
        return self._as_quantity()

class RuleContent_707(RuleContentContextFree):
    cv_arg: TypeAlias = Content_707.cv_arg
    cv_content: TypeAlias = Content_707

    @property
    def content(self) -> Content_707:
        return self._get_content() # type: ignore

class Variation_895(Element):
    cv_arg: TypeAlias = RuleContent_707.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 27
    cv_rule = RuleContent_707

    @classmethod
    def create(cls, arg: "Variation_895.cv_arg") -> "Variation_895":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_707:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_707:
        return self.rule.content

class RuleVariation_865(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_895.cv_arg
    cv_variation: TypeAlias = Variation_895

    @classmethod
    def create(cls, arg : "RuleVariation_865.cv_arg") -> "RuleVariation_865":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_895:
        return self.arg # type: ignore

class NonSpare_1342(NonSpare):
    cv_arg: TypeAlias = RuleVariation_865.cv_arg
    cv_name = "NBR"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_865

    @classmethod
    def create(cls, arg : "NonSpare_1342.cv_arg") -> "NonSpare_1342":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_865:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_895:
        return self.rule.variation

class Item_608(Item):
    cv_arg: TypeAlias = NonSpare_1342.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1342

    @classmethod
    def create(cls, arg : "Item_608.cv_arg") -> "Item_608":
        return cls._create(arg) # type: ignore

class Variation_1035(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_865.cv_arg, Tuple[Literal["NBR"], RuleVariation_865.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1035.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_4, 5), (Item_608, 27)]
    cv_items_dict = {"NBR": RuleVariation_865}

    @classmethod
    def spec(cls, key : Literal["NBR"]) -> RuleVariation_865:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["NBR"]) -> RuleVariation_865:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1035.cv_arg") -> 'Variation_1035':
        return cls._create(arg) # type: ignore

class RuleVariation_1003(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1035.cv_arg
    cv_variation: TypeAlias = Variation_1035

    @classmethod
    def create(cls, arg : "RuleVariation_1003.cv_arg") -> "RuleVariation_1003":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1035:
        return self.arg # type: ignore

class NonSpare_978(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1003.cv_arg
    cv_name = "FP1"
    cv_title = "Number of the Flight Plan Correlated to Aircraft 1 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_1003

    @classmethod
    def create(cls, arg : "NonSpare_978.cv_arg") -> "NonSpare_978":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1003:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1035:
        return self.rule.variation

class Content_749(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["FL"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 0.25
    cv_unit = "FL"

    def as_quantity(self, cv_unit : Optional[Literal["FL"]] = None) -> float:
        return self._as_quantity()

class RuleContent_748(RuleContentContextFree):
    cv_arg: TypeAlias = Content_749.cv_arg
    cv_content: TypeAlias = Content_749

    @property
    def content(self) -> Content_749:
        return self._get_content() # type: ignore

class Variation_319(Element):
    cv_arg: TypeAlias = RuleContent_748.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_748

    @classmethod
    def create(cls, arg: "Variation_319.cv_arg") -> "Variation_319":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_748:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_749:
        return self.rule.content

class RuleVariation_312(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_319.cv_arg
    cv_variation: TypeAlias = Variation_319

    @classmethod
    def create(cls, arg : "RuleVariation_312.cv_arg") -> "RuleVariation_312":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_319:
        return self.arg # type: ignore

class NonSpare_718(NonSpare):
    cv_arg: TypeAlias = RuleVariation_312.cv_arg
    cv_name = "CF1"
    cv_title = "Cleared Flight Level for Aircraft 1 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_312

    @classmethod
    def create(cls, arg : "NonSpare_718.cv_arg") -> "NonSpare_718":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_312:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_319:
        return self.rule.variation

class Variation_1461(Compound):
    cv_arg = TypedDict('cv_arg', {
        "AI1": NonSpare_581.cv_arg,
        "M31": NonSpare_1205.cv_arg,
        "CPW": NonSpare_816.cv_arg,
        "CPC": NonSpare_811.cv_arg,
        "TT1": NonSpare_1933.cv_arg,
        "DT1": NonSpare_897.cv_arg,
        "AC1": NonSpare_553.cv_arg,
        "MS1": NonSpare_1312.cv_arg,
        "FP1": NonSpare_978.cv_arg,
        "CF1": NonSpare_718.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 2
    cv_items_list = [NonSpare_581, NonSpare_1205, NonSpare_816, NonSpare_811, NonSpare_1933, NonSpare_897, NonSpare_553, NonSpare_1312, NonSpare_978, NonSpare_718]
    cv_items_dict = {"AI1": NonSpare_581, "M31": NonSpare_1205, "CPW": NonSpare_816, "CPC": NonSpare_811, "TT1": NonSpare_1933, "DT1": NonSpare_897, "AC1": NonSpare_553, "MS1": NonSpare_1312, "FP1": NonSpare_978, "CF1": NonSpare_718}

    @overload
    @classmethod
    def spec(cls, key : Literal["AI1"]) -> NonSpare_581:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["M31"]) -> NonSpare_1205:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPW"]) -> NonSpare_816:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPC"]) -> NonSpare_811:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TT1"]) -> NonSpare_1933:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["DT1"]) -> NonSpare_897:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AC1"]) -> NonSpare_553:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MS1"]) -> NonSpare_1312:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["FP1"]) -> NonSpare_978:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CF1"]) -> NonSpare_718:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["AI1"], Literal["M31"], Literal["CPW"], Literal["CPC"], Literal["TT1"], Literal["DT1"], Literal["AC1"], Literal["MS1"], Literal["FP1"], Literal["CF1"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["AI1"]) -> Optional[NonSpare_581]:
        ...
    @overload
    def get_item(self, key : Literal["M31"]) -> Optional[NonSpare_1205]:
        ...
    @overload
    def get_item(self, key : Literal["CPW"]) -> Optional[NonSpare_816]:
        ...
    @overload
    def get_item(self, key : Literal["CPC"]) -> Optional[NonSpare_811]:
        ...
    @overload
    def get_item(self, key : Literal["TT1"]) -> Optional[NonSpare_1933]:
        ...
    @overload
    def get_item(self, key : Literal["DT1"]) -> Optional[NonSpare_897]:
        ...
    @overload
    def get_item(self, key : Literal["AC1"]) -> Optional[NonSpare_553]:
        ...
    @overload
    def get_item(self, key : Literal["MS1"]) -> Optional[NonSpare_1312]:
        ...
    @overload
    def get_item(self, key : Literal["FP1"]) -> Optional[NonSpare_978]:
        ...
    @overload
    def get_item(self, key : Literal["CF1"]) -> Optional[NonSpare_718]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["AI1"], val : NonSpare_581.cv_arg) -> "Variation_1461":
        ...
    @overload
    def set_item(self, key : Literal["M31"], val : NonSpare_1205.cv_arg) -> "Variation_1461":
        ...
    @overload
    def set_item(self, key : Literal["CPW"], val : NonSpare_816.cv_arg) -> "Variation_1461":
        ...
    @overload
    def set_item(self, key : Literal["CPC"], val : NonSpare_811.cv_arg) -> "Variation_1461":
        ...
    @overload
    def set_item(self, key : Literal["TT1"], val : NonSpare_1933.cv_arg) -> "Variation_1461":
        ...
    @overload
    def set_item(self, key : Literal["DT1"], val : NonSpare_897.cv_arg) -> "Variation_1461":
        ...
    @overload
    def set_item(self, key : Literal["AC1"], val : NonSpare_553.cv_arg) -> "Variation_1461":
        ...
    @overload
    def set_item(self, key : Literal["MS1"], val : NonSpare_1312.cv_arg) -> "Variation_1461":
        ...
    @overload
    def set_item(self, key : Literal["FP1"], val : NonSpare_978.cv_arg) -> "Variation_1461":
        ...
    @overload
    def set_item(self, key : Literal["CF1"], val : NonSpare_718.cv_arg) -> "Variation_1461":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["AI1"]) -> "Variation_1461":
        ...
    @overload
    def del_item(self, key : Literal["M31"]) -> "Variation_1461":
        ...
    @overload
    def del_item(self, key : Literal["CPW"]) -> "Variation_1461":
        ...
    @overload
    def del_item(self, key : Literal["CPC"]) -> "Variation_1461":
        ...
    @overload
    def del_item(self, key : Literal["TT1"]) -> "Variation_1461":
        ...
    @overload
    def del_item(self, key : Literal["DT1"]) -> "Variation_1461":
        ...
    @overload
    def del_item(self, key : Literal["AC1"]) -> "Variation_1461":
        ...
    @overload
    def del_item(self, key : Literal["MS1"]) -> "Variation_1461":
        ...
    @overload
    def del_item(self, key : Literal["FP1"]) -> "Variation_1461":
        ...
    @overload
    def del_item(self, key : Literal["CF1"]) -> "Variation_1461":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1461.cv_arg") -> 'Variation_1461':
        return cls._create(arg) # type: ignore

class RuleVariation_1383(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1461.cv_arg
    cv_variation: TypeAlias = Variation_1461

    @classmethod
    def create(cls, arg : "RuleVariation_1383.cv_arg") -> "RuleVariation_1383":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1461:
        return self.arg # type: ignore

class NonSpare_365(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1383.cv_arg
    cv_name = "170"
    cv_title = "Aircraft Identification and Characteristics 1"
    cv_rule: TypeAlias = RuleVariation_1383

    @classmethod
    def create(cls, arg : "NonSpare_365.cv_arg") -> "NonSpare_365":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1461:
        return self.rule.variation

class UapItem_365(UapItem):
    cv_non_spare: TypeAlias = NonSpare_365

class Content_66(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Conflict not predicted to occur in military airspace", 1: "Conflict predicted to occur in military airspace"}

class RuleContent_66(RuleContentContextFree):
    cv_arg: TypeAlias = Content_66.cv_arg
    cv_content: TypeAlias = Content_66

    @property
    def content(self) -> Content_66:
        return self._get_content() # type: ignore

class Variation_20(Element):
    cv_arg: TypeAlias = RuleContent_66.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_66

    @classmethod
    def create(cls, arg: "Variation_20.cv_arg") -> "Variation_20":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_66:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_66:
        return self.rule.content

class RuleVariation_20(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_20.cv_arg
    cv_variation: TypeAlias = Variation_20

    @classmethod
    def create(cls, arg : "RuleVariation_20.cv_arg") -> "RuleVariation_20":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_20:
        return self.arg # type: ignore

class Content_65(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Conflict not predicted to occur in civil airspace", 1: "Conflict predicted to occur in civil airspace"}

class RuleContent_65(RuleContentContextFree):
    cv_arg: TypeAlias = Content_65.cv_arg
    cv_content: TypeAlias = Content_65

    @property
    def content(self) -> Content_65:
        return self._get_content() # type: ignore

class Variation_402(Element):
    cv_arg: TypeAlias = RuleContent_65.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_65

    @classmethod
    def create(cls, arg: "Variation_402.cv_arg") -> "Variation_402":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_65:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_65:
        return self.rule.content

class RuleVariation_391(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_402.cv_arg
    cv_variation: TypeAlias = Variation_402

    @classmethod
    def create(cls, arg : "RuleVariation_391.cv_arg") -> "RuleVariation_391":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_402:
        return self.arg # type: ignore

class Content_25(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Aircraft are not fast diverging laterally at current time", 1: "Aircraft are fast diverging laterally at current time"}

class RuleContent_25(RuleContentContextFree):
    cv_arg: TypeAlias = Content_25.cv_arg
    cv_content: TypeAlias = Content_25

    @property
    def content(self) -> Content_25:
        return self._get_content() # type: ignore

class Variation_506(Element):
    cv_arg: TypeAlias = RuleContent_25.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_25

    @classmethod
    def create(cls, arg: "Variation_506.cv_arg") -> "Variation_506":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_25:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_25:
        return self.rule.content

class RuleVariation_495(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_506.cv_arg
    cv_variation: TypeAlias = Variation_506

    @classmethod
    def create(cls, arg : "RuleVariation_495.cv_arg") -> "RuleVariation_495":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_506:
        return self.arg # type: ignore

class Content_26(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Aircraft are not fast diverging vertically at current time", 1: "Aircraft are fast diverging vertically at current time"}

class RuleContent_26(RuleContentContextFree):
    cv_arg: TypeAlias = Content_26.cv_arg
    cv_content: TypeAlias = Content_26

    @property
    def content(self) -> Content_26:
        return self._get_content() # type: ignore

class Variation_613(Element):
    cv_arg: TypeAlias = RuleContent_26.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_26

    @classmethod
    def create(cls, arg: "Variation_613.cv_arg") -> "Variation_613":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_26:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_26:
        return self.rule.content

class RuleVariation_602(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_613.cv_arg
    cv_variation: TypeAlias = Variation_613

    @classmethod
    def create(cls, arg : "RuleVariation_602.cv_arg") -> "RuleVariation_602":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_613:
        return self.arg # type: ignore

class Content_268(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Minor separation infringement", 1: "Major separation infringement"}

class RuleContent_268(RuleContentContextFree):
    cv_arg: TypeAlias = Content_268.cv_arg
    cv_content: TypeAlias = Content_268

    @property
    def content(self) -> Content_268:
        return self._get_content() # type: ignore

class Variation_729(Element):
    cv_arg: TypeAlias = RuleContent_268.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_268

    @classmethod
    def create(cls, arg: "Variation_729.cv_arg") -> "Variation_729":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_268:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_268:
        return self.rule.content

class RuleVariation_718(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_729.cv_arg
    cv_variation: TypeAlias = Variation_729

    @classmethod
    def create(cls, arg : "RuleVariation_718.cv_arg") -> "RuleVariation_718":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_729:
        return self.arg # type: ignore

class Content_28(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Aircraft have not crossed at starting time of conflict", 1: "Aircraft have crossed at starting time of conflict"}

class RuleContent_28(RuleContentContextFree):
    cv_arg: TypeAlias = Content_28.cv_arg
    cv_content: TypeAlias = Content_28

    @property
    def content(self) -> Content_28:
        return self._get_content() # type: ignore

class Variation_818(Element):
    cv_arg: TypeAlias = RuleContent_28.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_28

    @classmethod
    def create(cls, arg: "Variation_818.cv_arg") -> "Variation_818":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_28:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_28:
        return self.rule.content

class RuleVariation_788(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_818.cv_arg
    cv_variation: TypeAlias = Variation_818

    @classmethod
    def create(cls, arg : "RuleVariation_788.cv_arg") -> "RuleVariation_788":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_818:
        return self.arg # type: ignore

class Content_24(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Aircraft are not diverging at starting time of conflict", 1: "Aircraft are diverging at starting time of conflict"}

class RuleContent_24(RuleContentContextFree):
    cv_arg: TypeAlias = Content_24.cv_arg
    cv_content: TypeAlias = Content_24

    @property
    def content(self) -> Content_24:
        return self._get_content() # type: ignore

class Variation_899(Element):
    cv_arg: TypeAlias = RuleContent_24.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_24

    @classmethod
    def create(cls, arg: "Variation_899.cv_arg") -> "Variation_899":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_24:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_24:
        return self.rule.content

class RuleVariation_869(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_899.cv_arg
    cv_variation: TypeAlias = Variation_899

    @classmethod
    def create(cls, arg : "RuleVariation_869.cv_arg") -> "RuleVariation_869":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_899:
        return self.arg # type: ignore

class Content_145(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Runway/Runway Crossing"}

class RuleContent_145(RuleContentContextFree):
    cv_arg: TypeAlias = Content_145.cv_arg
    cv_content: TypeAlias = Content_145

    @property
    def content(self) -> Content_145:
        return self._get_content() # type: ignore

class Variation_34(Element):
    cv_arg: TypeAlias = RuleContent_145.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_145

    @classmethod
    def create(cls, arg: "Variation_34.cv_arg") -> "Variation_34":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_145:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_145:
        return self.rule.content

class RuleVariation_34(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_34.cv_arg
    cv_variation: TypeAlias = Variation_34

    @classmethod
    def create(cls, arg : "RuleVariation_34.cv_arg") -> "RuleVariation_34":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_34:
        return self.arg # type: ignore

class Content_146(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Runway/Taxiway Crossing"}

class RuleContent_146(RuleContentContextFree):
    cv_arg: TypeAlias = Content_146.cv_arg
    cv_content: TypeAlias = Content_146

    @property
    def content(self) -> Content_146:
        return self._get_content() # type: ignore

class Variation_416(Element):
    cv_arg: TypeAlias = RuleContent_146.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_146

    @classmethod
    def create(cls, arg: "Variation_416.cv_arg") -> "Variation_416":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_146:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_146:
        return self.rule.content

class RuleVariation_405(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_416.cv_arg
    cv_variation: TypeAlias = Variation_416

    @classmethod
    def create(cls, arg : "RuleVariation_405.cv_arg") -> "RuleVariation_405":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_416:
        return self.arg # type: ignore

class Content_127(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 4 (MSAW) indicates MRVA"}

class RuleContent_127(RuleContentContextFree):
    cv_arg: TypeAlias = Content_127.cv_arg
    cv_content: TypeAlias = Content_127

    @property
    def content(self) -> Content_127:
        return self._get_content() # type: ignore

class Variation_517(Element):
    cv_arg: TypeAlias = RuleContent_127.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_127

    @classmethod
    def create(cls, arg: "Variation_517.cv_arg") -> "Variation_517":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_127:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_127:
        return self.rule.content

class RuleVariation_506(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_517.cv_arg
    cv_variation: TypeAlias = Variation_517

    @classmethod
    def create(cls, arg : "RuleVariation_506.cv_arg") -> "RuleVariation_506":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_517:
        return self.arg # type: ignore

class Content_121(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 25 (VRAM) indicates CRM"}

class RuleContent_121(RuleContentContextFree):
    cv_arg: TypeAlias = Content_121.cv_arg
    cv_content: TypeAlias = Content_121

    @property
    def content(self) -> Content_121:
        return self._get_content() # type: ignore

class Variation_626(Element):
    cv_arg: TypeAlias = RuleContent_121.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_121

    @classmethod
    def create(cls, arg: "Variation_626.cv_arg") -> "Variation_626":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_121:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_121:
        return self.rule.content

class RuleVariation_615(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_626.cv_arg
    cv_variation: TypeAlias = Variation_626

    @classmethod
    def create(cls, arg : "RuleVariation_615.cv_arg") -> "RuleVariation_615":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_626:
        return self.arg # type: ignore

class Content_122(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 25 (VRAM) indicates VRM"}

class RuleContent_122(RuleContentContextFree):
    cv_arg: TypeAlias = Content_122.cv_arg
    cv_content: TypeAlias = Content_122

    @property
    def content(self) -> Content_122:
        return self._get_content() # type: ignore

class Variation_707(Element):
    cv_arg: TypeAlias = RuleContent_122.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_122

    @classmethod
    def create(cls, arg: "Variation_707.cv_arg") -> "Variation_707":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_122:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_122:
        return self.rule.content

class RuleVariation_696(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_707.cv_arg
    cv_variation: TypeAlias = Variation_707

    @classmethod
    def create(cls, arg : "RuleVariation_696.cv_arg") -> "RuleVariation_696":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_707:
        return self.arg # type: ignore

class Content_123(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 25 (VRAM) indicates VTM"}

class RuleContent_123(RuleContentContextFree):
    cv_arg: TypeAlias = Content_123.cv_arg
    cv_content: TypeAlias = Content_123

    @property
    def content(self) -> Content_123:
        return self._get_content() # type: ignore

class Variation_829(Element):
    cv_arg: TypeAlias = RuleContent_123.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_123

    @classmethod
    def create(cls, arg: "Variation_829.cv_arg") -> "Variation_829":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_123:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_123:
        return self.rule.content

class RuleVariation_799(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_829.cv_arg
    cv_variation: TypeAlias = Variation_829

    @classmethod
    def create(cls, arg : "RuleVariation_799.cv_arg") -> "RuleVariation_799":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_829:
        return self.arg # type: ignore

class Content_124(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 29 (HAM) indicates HD"}

class RuleContent_124(RuleContentContextFree):
    cv_arg: TypeAlias = Content_124.cv_arg
    cv_content: TypeAlias = Content_124

    @property
    def content(self) -> Content_124:
        return self._get_content() # type: ignore

class Variation_911(Element):
    cv_arg: TypeAlias = RuleContent_124.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_124

    @classmethod
    def create(cls, arg: "Variation_911.cv_arg") -> "Variation_911":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_124:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_124:
        return self.rule.content

class RuleVariation_881(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_911.cv_arg
    cv_variation: TypeAlias = Variation_911

    @classmethod
    def create(cls, arg : "RuleVariation_881.cv_arg") -> "RuleVariation_881":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_911:
        return self.arg # type: ignore

class Content_125(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 29 (HAM) indicates RD"}

class RuleContent_125(RuleContentContextFree):
    cv_arg: TypeAlias = Content_125.cv_arg
    cv_content: TypeAlias = Content_125

    @property
    def content(self) -> Content_125:
        return self._get_content() # type: ignore

class Variation_33(Element):
    cv_arg: TypeAlias = RuleContent_125.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_125

    @classmethod
    def create(cls, arg: "Variation_33.cv_arg") -> "Variation_33":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_125:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_125:
        return self.rule.content

class RuleVariation_33(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_33.cv_arg
    cv_variation: TypeAlias = Variation_33

    @classmethod
    def create(cls, arg : "RuleVariation_33.cv_arg") -> "RuleVariation_33":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_33:
        return self.arg # type: ignore

class Content_126(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 29 (HAM) indicates VD"}

class RuleContent_126(RuleContentContextFree):
    cv_arg: TypeAlias = Content_126.cv_arg
    cv_content: TypeAlias = Content_126

    @property
    def content(self) -> Content_126:
        return self._get_content() # type: ignore

class Variation_411(Element):
    cv_arg: TypeAlias = RuleContent_126.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_126

    @classmethod
    def create(cls, arg: "Variation_411.cv_arg") -> "Variation_411":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_126:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_126:
        return self.rule.content

class RuleVariation_400(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_411.cv_arg
    cv_variation: TypeAlias = Variation_411

    @classmethod
    def create(cls, arg : "RuleVariation_400.cv_arg") -> "RuleVariation_400":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_411:
        return self.arg # type: ignore

class Content_118(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 20 (DBPSM) indicates ARR"}

class RuleContent_118(RuleContentContextFree):
    cv_arg: TypeAlias = Content_118.cv_arg
    cv_content: TypeAlias = Content_118

    @property
    def content(self) -> Content_118:
        return self._get_content() # type: ignore

class Variation_516(Element):
    cv_arg: TypeAlias = RuleContent_118.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_118

    @classmethod
    def create(cls, arg: "Variation_516.cv_arg") -> "Variation_516":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_118:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_118:
        return self.rule.content

class RuleVariation_505(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_516.cv_arg
    cv_variation: TypeAlias = Variation_516

    @classmethod
    def create(cls, arg : "RuleVariation_505.cv_arg") -> "RuleVariation_505":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_516:
        return self.arg # type: ignore

class Content_119(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 20 (DBPSM) indicates DEP"}

class RuleContent_119(RuleContentContextFree):
    cv_arg: TypeAlias = Content_119.cv_arg
    cv_content: TypeAlias = Content_119

    @property
    def content(self) -> Content_119:
        return self._get_content() # type: ignore

class Variation_625(Element):
    cv_arg: TypeAlias = RuleContent_119.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_119

    @classmethod
    def create(cls, arg: "Variation_625.cv_arg") -> "Variation_625":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_119:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_119:
        return self.rule.content

class RuleVariation_614(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_625.cv_arg
    cv_variation: TypeAlias = Variation_625

    @classmethod
    def create(cls, arg : "RuleVariation_614.cv_arg") -> "RuleVariation_614":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_625:
        return self.arg # type: ignore

class Content_120(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 20 (DBPSM) indicates above TL"}

class RuleContent_120(RuleContentContextFree):
    cv_arg: TypeAlias = Content_120.cv_arg
    cv_content: TypeAlias = Content_120

    @property
    def content(self) -> Content_120:
        return self._get_content() # type: ignore

class Variation_706(Element):
    cv_arg: TypeAlias = RuleContent_120.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_120

    @classmethod
    def create(cls, arg: "Variation_706.cv_arg") -> "Variation_706":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_120:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_120:
        return self.rule.content

class RuleVariation_695(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_706.cv_arg
    cv_variation: TypeAlias = Variation_706

    @classmethod
    def create(cls, arg : "RuleVariation_695.cv_arg") -> "RuleVariation_695":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_706:
        return self.arg # type: ignore

class Content_128(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 99 (AIW) indicates pAIW Alert"}

class RuleContent_128(RuleContentContextFree):
    cv_arg: TypeAlias = Content_128.cv_arg
    cv_content: TypeAlias = Content_128

    @property
    def content(self) -> Content_128:
        return self._get_content() # type: ignore

class Variation_830(Element):
    cv_arg: TypeAlias = RuleContent_128.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_128

    @classmethod
    def create(cls, arg: "Variation_830.cv_arg") -> "Variation_830":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_128:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_128:
        return self.rule.content

class RuleVariation_800(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_830.cv_arg
    cv_variation: TypeAlias = Variation_830

    @classmethod
    def create(cls, arg : "RuleVariation_800.cv_arg") -> "RuleVariation_800":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_830:
        return self.arg # type: ignore

class NonSpare_1221(NonSpare):
    cv_arg: TypeAlias = RuleVariation_20.cv_arg
    cv_name = "MAS"
    cv_title = "Conflict Location in Military Airspace"
    cv_rule: TypeAlias = RuleVariation_20

    @classmethod
    def create(cls, arg : "NonSpare_1221.cv_arg") -> "NonSpare_1221":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_20:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_20:
        return self.rule.variation

class Item_526(Item):
    cv_arg: TypeAlias = NonSpare_1221.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1221

    @classmethod
    def create(cls, arg : "Item_526.cv_arg") -> "Item_526":
        return cls._create(arg) # type: ignore

class NonSpare_699(NonSpare):
    cv_arg: TypeAlias = RuleVariation_391.cv_arg
    cv_name = "CAS"
    cv_title = "Conflict Location in Civil Airspace"
    cv_rule: TypeAlias = RuleVariation_391

    @classmethod
    def create(cls, arg : "NonSpare_699.cv_arg") -> "NonSpare_699":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_391:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_402:
        return self.rule.variation

class Item_134(Item):
    cv_arg: TypeAlias = NonSpare_699.cv_arg
    cv_non_spare: TypeAlias = NonSpare_699

    @classmethod
    def create(cls, arg : "Item_134.cv_arg") -> "Item_134":
        return cls._create(arg) # type: ignore

class NonSpare_968(NonSpare):
    cv_arg: TypeAlias = RuleVariation_495.cv_arg
    cv_name = "FLD"
    cv_title = "Fast Lateral Divergence"
    cv_rule: TypeAlias = RuleVariation_495

    @classmethod
    def create(cls, arg : "NonSpare_968.cv_arg") -> "NonSpare_968":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_495:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_506:
        return self.rule.variation

class Item_330(Item):
    cv_arg: TypeAlias = NonSpare_968.cv_arg
    cv_non_spare: TypeAlias = NonSpare_968

    @classmethod
    def create(cls, arg : "Item_330.cv_arg") -> "Item_330":
        return cls._create(arg) # type: ignore

class NonSpare_1000(NonSpare):
    cv_arg: TypeAlias = RuleVariation_602.cv_arg
    cv_name = "FVD"
    cv_title = "Fast Vertical Divergence"
    cv_rule: TypeAlias = RuleVariation_602

    @classmethod
    def create(cls, arg : "NonSpare_1000.cv_arg") -> "NonSpare_1000":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_602:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_613:
        return self.rule.variation

class Item_352(Item):
    cv_arg: TypeAlias = NonSpare_1000.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1000

    @classmethod
    def create(cls, arg : "Item_352.cv_arg") -> "Item_352":
        return cls._create(arg) # type: ignore

class NonSpare_1964(NonSpare):
    cv_arg: TypeAlias = RuleVariation_718.cv_arg
    cv_name = "TYPE"
    cv_title = "Type of Separation Infringement"
    cv_rule: TypeAlias = RuleVariation_718

    @classmethod
    def create(cls, arg : "NonSpare_1964.cv_arg") -> "NonSpare_1964":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_718:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_729:
        return self.rule.variation

class Item_1083(Item):
    cv_arg: TypeAlias = NonSpare_1964.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1964

    @classmethod
    def create(cls, arg : "Item_1083.cv_arg") -> "Item_1083":
        return cls._create(arg) # type: ignore

class NonSpare_821(NonSpare):
    cv_arg: TypeAlias = RuleVariation_788.cv_arg
    cv_name = "CROSS"
    cv_title = "Crossing Test"
    cv_rule: TypeAlias = RuleVariation_788

    @classmethod
    def create(cls, arg : "NonSpare_821.cv_arg") -> "NonSpare_821":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_788:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_818:
        return self.rule.variation

class Item_213(Item):
    cv_arg: TypeAlias = NonSpare_821.cv_arg
    cv_non_spare: TypeAlias = NonSpare_821

    @classmethod
    def create(cls, arg : "Item_213.cv_arg") -> "Item_213":
        return cls._create(arg) # type: ignore

class NonSpare_878(NonSpare):
    cv_arg: TypeAlias = RuleVariation_869.cv_arg
    cv_name = "DIV"
    cv_title = "Divergence Test"
    cv_rule: TypeAlias = RuleVariation_869

    @classmethod
    def create(cls, arg : "NonSpare_878.cv_arg") -> "NonSpare_878":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_869:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_899:
        return self.rule.variation

class Item_261(Item):
    cv_arg: TypeAlias = NonSpare_878.cv_arg
    cv_non_spare: TypeAlias = NonSpare_878

    @classmethod
    def create(cls, arg : "Item_261.cv_arg") -> "Item_261":
        return cls._create(arg) # type: ignore

class NonSpare_1600(NonSpare):
    cv_arg: TypeAlias = RuleVariation_34.cv_arg
    cv_name = "RRC"
    cv_title = "Runway/Runway Crossing in RIMCAS"
    cv_rule: TypeAlias = RuleVariation_34

    @classmethod
    def create(cls, arg : "NonSpare_1600.cv_arg") -> "NonSpare_1600":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_34:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_34:
        return self.rule.variation

class Item_824(Item):
    cv_arg: TypeAlias = NonSpare_1600.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1600

    @classmethod
    def create(cls, arg : "Item_824.cv_arg") -> "Item_824":
        return cls._create(arg) # type: ignore

class NonSpare_1622(NonSpare):
    cv_arg: TypeAlias = RuleVariation_405.cv_arg
    cv_name = "RTC"
    cv_title = "Runway/Taxiway Crossing in RIMCAS"
    cv_rule: TypeAlias = RuleVariation_405

    @classmethod
    def create(cls, arg : "NonSpare_1622.cv_arg") -> "NonSpare_1622":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_405:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_416:
        return self.rule.variation

class Item_834(Item):
    cv_arg: TypeAlias = NonSpare_1622.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1622

    @classmethod
    def create(cls, arg : "Item_834.cv_arg") -> "Item_834":
        return cls._create(arg) # type: ignore

class NonSpare_1310(NonSpare):
    cv_arg: TypeAlias = RuleVariation_506.cv_arg
    cv_name = "MRVA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_506

    @classmethod
    def create(cls, arg : "NonSpare_1310.cv_arg") -> "NonSpare_1310":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_506:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_517:
        return self.rule.variation

class Item_582(Item):
    cv_arg: TypeAlias = NonSpare_1310.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1310

    @classmethod
    def create(cls, arg : "Item_582.cv_arg") -> "Item_582":
        return cls._create(arg) # type: ignore

class NonSpare_2027(NonSpare):
    cv_arg: TypeAlias = RuleVariation_615.cv_arg
    cv_name = "VRAMCRM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_615

    @classmethod
    def create(cls, arg : "NonSpare_2027.cv_arg") -> "NonSpare_2027":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_615:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_626:
        return self.rule.variation

class Item_1142(Item):
    cv_arg: TypeAlias = NonSpare_2027.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2027

    @classmethod
    def create(cls, arg : "Item_1142.cv_arg") -> "Item_1142":
        return cls._create(arg) # type: ignore

class NonSpare_2029(NonSpare):
    cv_arg: TypeAlias = RuleVariation_696.cv_arg
    cv_name = "VRAMVRM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_696

    @classmethod
    def create(cls, arg : "NonSpare_2029.cv_arg") -> "NonSpare_2029":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_696:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_707:
        return self.rule.variation

class Item_1144(Item):
    cv_arg: TypeAlias = NonSpare_2029.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2029

    @classmethod
    def create(cls, arg : "Item_1144.cv_arg") -> "Item_1144":
        return cls._create(arg) # type: ignore

class NonSpare_2032(NonSpare):
    cv_arg: TypeAlias = RuleVariation_799.cv_arg
    cv_name = "VRAMVTM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_799

    @classmethod
    def create(cls, arg : "NonSpare_2032.cv_arg") -> "NonSpare_2032":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_799:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_829:
        return self.rule.variation

class Item_1147(Item):
    cv_arg: TypeAlias = NonSpare_2032.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2032

    @classmethod
    def create(cls, arg : "Item_1147.cv_arg") -> "Item_1147":
        return cls._create(arg) # type: ignore

class NonSpare_1047(NonSpare):
    cv_arg: TypeAlias = RuleVariation_881.cv_arg
    cv_name = "HAMHD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_881

    @classmethod
    def create(cls, arg : "NonSpare_1047.cv_arg") -> "NonSpare_1047":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_881:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_911:
        return self.rule.variation

class Item_381(Item):
    cv_arg: TypeAlias = NonSpare_1047.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1047

    @classmethod
    def create(cls, arg : "Item_381.cv_arg") -> "Item_381":
        return cls._create(arg) # type: ignore

class NonSpare_1049(NonSpare):
    cv_arg: TypeAlias = RuleVariation_33.cv_arg
    cv_name = "HAMRD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_33

    @classmethod
    def create(cls, arg : "NonSpare_1049.cv_arg") -> "NonSpare_1049":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_33:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_33:
        return self.rule.variation

class Item_383(Item):
    cv_arg: TypeAlias = NonSpare_1049.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1049

    @classmethod
    def create(cls, arg : "Item_383.cv_arg") -> "Item_383":
        return cls._create(arg) # type: ignore

class NonSpare_1051(NonSpare):
    cv_arg: TypeAlias = RuleVariation_400.cv_arg
    cv_name = "HAMVD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_400

    @classmethod
    def create(cls, arg : "NonSpare_1051.cv_arg") -> "NonSpare_1051":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_400:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_411:
        return self.rule.variation

class Item_385(Item):
    cv_arg: TypeAlias = NonSpare_1051.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1051

    @classmethod
    def create(cls, arg : "Item_385.cv_arg") -> "Item_385":
        return cls._create(arg) # type: ignore

class NonSpare_858(NonSpare):
    cv_arg: TypeAlias = RuleVariation_505.cv_arg
    cv_name = "DBPSMARR"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_505

    @classmethod
    def create(cls, arg : "NonSpare_858.cv_arg") -> "NonSpare_858":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_505:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_516:
        return self.rule.variation

class Item_242(Item):
    cv_arg: TypeAlias = NonSpare_858.cv_arg
    cv_non_spare: TypeAlias = NonSpare_858

    @classmethod
    def create(cls, arg : "Item_242.cv_arg") -> "Item_242":
        return cls._create(arg) # type: ignore

class NonSpare_860(NonSpare):
    cv_arg: TypeAlias = RuleVariation_614.cv_arg
    cv_name = "DBPSMDEP"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_614

    @classmethod
    def create(cls, arg : "NonSpare_860.cv_arg") -> "NonSpare_860":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_614:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_625:
        return self.rule.variation

class Item_244(Item):
    cv_arg: TypeAlias = NonSpare_860.cv_arg
    cv_non_spare: TypeAlias = NonSpare_860

    @classmethod
    def create(cls, arg : "Item_244.cv_arg") -> "Item_244":
        return cls._create(arg) # type: ignore

class NonSpare_862(NonSpare):
    cv_arg: TypeAlias = RuleVariation_695.cv_arg
    cv_name = "DBPSMTL"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_695

    @classmethod
    def create(cls, arg : "NonSpare_862.cv_arg") -> "NonSpare_862":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_695:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_706:
        return self.rule.variation

class Item_246(Item):
    cv_arg: TypeAlias = NonSpare_862.cv_arg
    cv_non_spare: TypeAlias = NonSpare_862

    @classmethod
    def create(cls, arg : "Item_246.cv_arg") -> "Item_246":
        return cls._create(arg) # type: ignore

class NonSpare_585(NonSpare):
    cv_arg: TypeAlias = RuleVariation_800.cv_arg
    cv_name = "AIW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_800

    @classmethod
    def create(cls, arg : "NonSpare_585.cv_arg") -> "NonSpare_585":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_800:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_830:
        return self.rule.variation

class Item_57(Item):
    cv_arg: TypeAlias = NonSpare_585.cv_arg
    cv_non_spare: TypeAlias = NonSpare_585

    @classmethod
    def create(cls, arg : "Item_57.cv_arg") -> "Item_57":
        return cls._create(arg) # type: ignore

class Item_26(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 6
    cv_bit_size = 1

class Variation_1357(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_20.cv_arg, Tuple[Literal["MAS"], RuleVariation_20.cv_arg]], Union[RuleVariation_391.cv_arg, Tuple[Literal["CAS"], RuleVariation_391.cv_arg]], Union[RuleVariation_495.cv_arg, Tuple[Literal["FLD"], RuleVariation_495.cv_arg]], Union[RuleVariation_602.cv_arg, Tuple[Literal["FVD"], RuleVariation_602.cv_arg]], Union[RuleVariation_718.cv_arg, Tuple[Literal["TYPE"], RuleVariation_718.cv_arg]], Union[RuleVariation_788.cv_arg, Tuple[Literal["CROSS"], RuleVariation_788.cv_arg]], Union[RuleVariation_869.cv_arg, Tuple[Literal["DIV"], RuleVariation_869.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_34.cv_arg, Tuple[Literal["RRC"], RuleVariation_34.cv_arg]], Union[RuleVariation_405.cv_arg, Tuple[Literal["RTC"], RuleVariation_405.cv_arg]], Union[RuleVariation_506.cv_arg, Tuple[Literal["MRVA"], RuleVariation_506.cv_arg]], Union[RuleVariation_615.cv_arg, Tuple[Literal["VRAMCRM"], RuleVariation_615.cv_arg]], Union[RuleVariation_696.cv_arg, Tuple[Literal["VRAMVRM"], RuleVariation_696.cv_arg]], Union[RuleVariation_799.cv_arg, Tuple[Literal["VRAMVTM"], RuleVariation_799.cv_arg]], Union[RuleVariation_881.cv_arg, Tuple[Literal["HAMHD"], RuleVariation_881.cv_arg]], None]]
    cv_arg_group_3: TypeAlias = Union[int, Tuple[Union[RuleVariation_33.cv_arg, Tuple[Literal["HAMRD"], RuleVariation_33.cv_arg]], Union[RuleVariation_400.cv_arg, Tuple[Literal["HAMVD"], RuleVariation_400.cv_arg]], Union[RuleVariation_505.cv_arg, Tuple[Literal["DBPSMARR"], RuleVariation_505.cv_arg]], Union[RuleVariation_614.cv_arg, Tuple[Literal["DBPSMDEP"], RuleVariation_614.cv_arg]], Union[RuleVariation_695.cv_arg, Tuple[Literal["DBPSMTL"], RuleVariation_695.cv_arg]], Union[RuleVariation_800.cv_arg, Tuple[Literal["AIW"], RuleVariation_800.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1357.cv_arg_group_1"],
        Tuple["Variation_1357.cv_arg_group_1", "Variation_1357.cv_arg_group_2"],
        Tuple["Variation_1357.cv_arg_group_1", "Variation_1357.cv_arg_group_2", "Variation_1357.cv_arg_group_3"],
    ]
    cv_items_list = [[(Item_526, 1), (Item_134, 1), (Item_330, 1), (Item_352, 1), (Item_1083, 1), (Item_213, 1), (Item_261, 1), None], [(Item_824, 1), (Item_834, 1), (Item_582, 1), (Item_1142, 1), (Item_1144, 1), (Item_1147, 1), (Item_381, 1), None], [(Item_383, 1), (Item_385, 1), (Item_242, 1), (Item_244, 1), (Item_246, 1), (Item_57, 1), (Item_26, 1), None]]

    @classmethod
    def create(cls, arg: "Variation_1357.cv_arg") -> 'Variation_1357':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["MAS"]) -> RuleVariation_20:
        ...
    @overload
    def get_item(self, key : Literal["CAS"]) -> RuleVariation_391:
        ...
    @overload
    def get_item(self, key : Literal["FLD"]) -> RuleVariation_495:
        ...
    @overload
    def get_item(self, key : Literal["FVD"]) -> RuleVariation_602:
        ...
    @overload
    def get_item(self, key : Literal["TYPE"]) -> RuleVariation_718:
        ...
    @overload
    def get_item(self, key : Literal["CROSS"]) -> RuleVariation_788:
        ...
    @overload
    def get_item(self, key : Literal["DIV"]) -> RuleVariation_869:
        ...
    @overload
    def get_item(self, key : Literal["RRC"]) -> Optional[RuleVariation_34]:
        ...
    @overload
    def get_item(self, key : Literal["RTC"]) -> Optional[RuleVariation_405]:
        ...
    @overload
    def get_item(self, key : Literal["MRVA"]) -> Optional[RuleVariation_506]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMCRM"]) -> Optional[RuleVariation_615]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMVRM"]) -> Optional[RuleVariation_696]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMVTM"]) -> Optional[RuleVariation_799]:
        ...
    @overload
    def get_item(self, key : Literal["HAMHD"]) -> Optional[RuleVariation_881]:
        ...
    @overload
    def get_item(self, key : Literal["HAMRD"]) -> Optional[RuleVariation_33]:
        ...
    @overload
    def get_item(self, key : Literal["HAMVD"]) -> Optional[RuleVariation_400]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMARR"]) -> Optional[RuleVariation_505]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMDEP"]) -> Optional[RuleVariation_614]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMTL"]) -> Optional[RuleVariation_695]:
        ...
    @overload
    def get_item(self, key : Literal["AIW"]) -> Optional[RuleVariation_800]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1279(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1357.cv_arg
    cv_variation: TypeAlias = Variation_1357

    @classmethod
    def create(cls, arg : "RuleVariation_1279.cv_arg") -> "RuleVariation_1279":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1357:
        return self.arg # type: ignore

class NonSpare_739(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1279.cv_arg
    cv_name = "CN"
    cv_title = "Conflict Nature"
    cv_rule: TypeAlias = RuleVariation_1279

    @classmethod
    def create(cls, arg : "NonSpare_739.cv_arg") -> "NonSpare_739":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1279:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1357:
        return self.rule.variation

class Variation_131(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 4
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_131.cv_arg") -> "Variation_131":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_131(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_131.cv_arg
    cv_variation: TypeAlias = Variation_131

    @classmethod
    def create(cls, arg : "RuleVariation_131.cv_arg") -> "RuleVariation_131":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_131:
        return self.arg # type: ignore

class NonSpare_1851(NonSpare):
    cv_arg: TypeAlias = RuleVariation_131.cv_arg
    cv_name = "TID"
    cv_title = "Identification of Conflict Categories Definition Table"
    cv_rule: TypeAlias = RuleVariation_131

    @classmethod
    def create(cls, arg : "NonSpare_1851.cv_arg") -> "NonSpare_1851":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_131:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_131:
        return self.rule.variation

class Item_993(Item):
    cv_arg: TypeAlias = NonSpare_1851.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1851

    @classmethod
    def create(cls, arg : "Item_993.cv_arg") -> "Item_993":
        return cls._create(arg) # type: ignore

class Content_11(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "APW Low Severity", 1: "APW Medium Severity", 2: "APW High Severity"}

class RuleContent_11(RuleContentContextFree):
    cv_arg: TypeAlias = Content_11.cv_arg
    cv_content: TypeAlias = Content_11

    @property
    def content(self) -> Content_11:
        return self._get_content() # type: ignore

class Variation_774(Element):
    cv_arg: TypeAlias = RuleContent_11.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_11

    @classmethod
    def create(cls, arg: "Variation_774.cv_arg") -> "Variation_774":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_11:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_11:
        return self.rule.content

class Content_581(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Major seperation infringement and not (crossed and diverging)", 2: "Minor seperation infringement and not (crossed and diverging)", 3: "Major seperation infringement and (crossed and diverging)", 4: "Minor seperation infringement and (crossed and diverging)"}

class RuleContent_581(RuleContentContextFree):
    cv_arg: TypeAlias = Content_581.cv_arg
    cv_content: TypeAlias = Content_581

    @property
    def content(self) -> Content_581:
        return self._get_content() # type: ignore

class Variation_795(Element):
    cv_arg: TypeAlias = RuleContent_581.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_581

    @classmethod
    def create(cls, arg: "Variation_795.cv_arg") -> "Variation_795":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_581:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_581:
        return self.rule.content

class Content_211(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Filter not set", 1: "Filter set"}

class RuleContent_211(RuleContentContextFree):
    cv_arg: TypeAlias = Content_211.cv_arg
    cv_content: TypeAlias = Content_211

    @property
    def content(self) -> Content_211:
        return self._get_content() # type: ignore

class Variation_721(Element):
    cv_arg: TypeAlias = RuleContent_211.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_211

    @classmethod
    def create(cls, arg: "Variation_721.cv_arg") -> "Variation_721":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_211:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_211:
        return self.rule.content

class RuleVariation_710(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_721.cv_arg
    cv_variation: TypeAlias = Variation_721

    @classmethod
    def create(cls, arg : "RuleVariation_710.cv_arg") -> "RuleVariation_710":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_721:
        return self.arg # type: ignore

class NonSpare_1188(NonSpare):
    cv_arg: TypeAlias = RuleVariation_710.cv_arg
    cv_name = "LPF"
    cv_title = "Linear Prediction Filter"
    cv_rule: TypeAlias = RuleVariation_710

    @classmethod
    def create(cls, arg : "NonSpare_1188.cv_arg") -> "NonSpare_1188":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_710:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_721:
        return self.rule.variation

class Item_502(Item):
    cv_arg: TypeAlias = NonSpare_1188.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1188

    @classmethod
    def create(cls, arg : "Item_502.cv_arg") -> "Item_502":
        return cls._create(arg) # type: ignore

class Variation_848(Element):
    cv_arg: TypeAlias = RuleContent_211.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_211

    @classmethod
    def create(cls, arg: "Variation_848.cv_arg") -> "Variation_848":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_211:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_211:
        return self.rule.content

class RuleVariation_818(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_848.cv_arg
    cv_variation: TypeAlias = Variation_848

    @classmethod
    def create(cls, arg : "RuleVariation_818.cv_arg") -> "RuleVariation_818":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_848:
        return self.arg # type: ignore

class NonSpare_812(NonSpare):
    cv_arg: TypeAlias = RuleVariation_818.cv_arg
    cv_name = "CPF"
    cv_title = "Current Proximity Filter"
    cv_rule: TypeAlias = RuleVariation_818

    @classmethod
    def create(cls, arg : "NonSpare_812.cv_arg") -> "NonSpare_812":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_818:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_848:
        return self.rule.variation

class Item_207(Item):
    cv_arg: TypeAlias = NonSpare_812.cv_arg
    cv_non_spare: TypeAlias = NonSpare_812

    @classmethod
    def create(cls, arg : "Item_207.cv_arg") -> "Item_207":
        return cls._create(arg) # type: ignore

class Variation_924(Element):
    cv_arg: TypeAlias = RuleContent_211.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_211

    @classmethod
    def create(cls, arg: "Variation_924.cv_arg") -> "Variation_924":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_211:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_211:
        return self.rule.content

class RuleVariation_894(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_924.cv_arg
    cv_variation: TypeAlias = Variation_924

    @classmethod
    def create(cls, arg : "RuleVariation_894.cv_arg") -> "RuleVariation_894":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_924:
        return self.arg # type: ignore

class NonSpare_1270(NonSpare):
    cv_arg: TypeAlias = RuleVariation_894.cv_arg
    cv_name = "MHF"
    cv_title = "Manoeuvre Hazard Filter"
    cv_rule: TypeAlias = RuleVariation_894

    @classmethod
    def create(cls, arg : "NonSpare_1270.cv_arg") -> "NonSpare_1270":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_894:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_924:
        return self.rule.variation

class Item_546(Item):
    cv_arg: TypeAlias = NonSpare_1270.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1270

    @classmethod
    def create(cls, arg : "Item_546.cv_arg") -> "Item_546":
        return cls._create(arg) # type: ignore

class Variation_1330(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_710.cv_arg, Tuple[Literal["LPF"], RuleVariation_710.cv_arg]], Union[RuleVariation_818.cv_arg, Tuple[Literal["CPF"], RuleVariation_818.cv_arg]], Union[RuleVariation_894.cv_arg, Tuple[Literal["MHF"], RuleVariation_894.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1330.cv_arg_group"]
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_items_list = [(Item_502, 1), (Item_207, 1), (Item_546, 1)]
    cv_items_dict = {"LPF": RuleVariation_710, "CPF": RuleVariation_818, "MHF": RuleVariation_894}

    @overload
    @classmethod
    def spec(cls, key : Literal["LPF"]) -> RuleVariation_710:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPF"]) -> RuleVariation_818:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MHF"]) -> RuleVariation_894:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["LPF"], Literal["CPF"], Literal["MHF"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["LPF"]) -> RuleVariation_710:
        ...
    @overload
    def get_item(self, key : Literal["CPF"]) -> RuleVariation_818:
        ...
    @overload
    def get_item(self, key : Literal["MHF"]) -> RuleVariation_894:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1330.cv_arg") -> 'Variation_1330':
        return cls._create(arg) # type: ignore

class Content_456(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Stage One Alert", 1: "Stage Two Alert"}

class RuleContent_456(RuleContentContextFree):
    cv_arg: TypeAlias = Content_456.cv_arg
    cv_content: TypeAlias = Content_456

    @property
    def content(self) -> Content_456:
        return self._get_content() # type: ignore

class Variation_748(Element):
    cv_arg: TypeAlias = RuleContent_456.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_456

    @classmethod
    def create(cls, arg: "Variation_748.cv_arg") -> "Variation_748":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_456:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_456:
        return self.rule.content

class RuleVariation_737(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_748.cv_arg
    cv_variation: TypeAlias = Variation_748

    @classmethod
    def create(cls, arg : "RuleVariation_737.cv_arg") -> "RuleVariation_737":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_748:
        return self.arg # type: ignore

class NonSpare_1539(NonSpare):
    cv_arg: TypeAlias = RuleVariation_737.cv_arg
    cv_name = "RAS"
    cv_title = "RIMCAS Alert Stage"
    cv_rule: TypeAlias = RuleVariation_737

    @classmethod
    def create(cls, arg : "NonSpare_1539.cv_arg") -> "NonSpare_1539":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_737:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_748:
        return self.rule.variation

class Item_773(Item):
    cv_arg: TypeAlias = NonSpare_1539.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1539

    @classmethod
    def create(cls, arg : "Item_773.cv_arg") -> "Item_773":
        return cls._create(arg) # type: ignore

class Variation_1331(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_737.cv_arg, Tuple[Literal["RAS"], RuleVariation_737.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1331.cv_arg_group"]
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_items_list = [(Item_773, 1), (Item_24, 2)]
    cv_items_dict = {"RAS": RuleVariation_737}

    @classmethod
    def spec(cls, key : Literal["RAS"]) -> RuleVariation_737:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["RAS"]) -> RuleVariation_737:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1331.cv_arg") -> 'Variation_1331':
        return cls._create(arg) # type: ignore

class Content_4(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "2 aircraft, same taxiway, opposite direction", 1: "Aircraft entering wrong direction", 2: "Aircraft entering wrong taxiway", 3: "Speed violation"}

class RuleContent_4(RuleContentContextFree):
    cv_arg: TypeAlias = Content_4.cv_arg
    cv_content: TypeAlias = Content_4

    @property
    def content(self) -> Content_4:
        return self._get_content() # type: ignore

class Variation_773(Element):
    cv_arg: TypeAlias = RuleContent_4.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_4

    @classmethod
    def create(cls, arg: "Variation_773.cv_arg") -> "Variation_773":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_4:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_4:
        return self.rule.content

class Content_555(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "VRM Slow Climb", 1: "VRM Slow Descent"}

class RuleContent_555(RuleContentContextFree):
    cv_arg: TypeAlias = Content_555.cv_arg
    cv_content: TypeAlias = Content_555

    @property
    def content(self) -> Content_555:
        return self._get_content() # type: ignore

class Variation_792(Element):
    cv_arg: TypeAlias = RuleContent_555.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_555

    @classmethod
    def create(cls, arg: "Variation_792.cv_arg") -> "Variation_792":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_555:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_555:
        return self.rule.content

class Content_556(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "VTM Fast Climb", 1: "VTM Fast Descent"}

class RuleContent_556(RuleContentContextFree):
    cv_arg: TypeAlias = Content_556.cv_arg
    cv_content: TypeAlias = Content_556

    @property
    def content(self) -> Content_556:
        return self._get_content() # type: ignore

class Variation_793(Element):
    cv_arg: TypeAlias = RuleContent_556.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_556

    @classmethod
    def create(cls, arg: "Variation_793.cv_arg") -> "Variation_793":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_556:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_556:
        return self.rule.content

class Content_561(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Vertical manoeuvre deviation prior to reaching its expected level", 1: "Vertical manoeuvre deviation past its expected level"}

class RuleContent_561(RuleContentContextFree):
    cv_arg: TypeAlias = Content_561.cv_arg
    cv_content: TypeAlias = Content_561

    @property
    def content(self) -> Content_561:
        return self._get_content() # type: ignore

class Variation_794(Element):
    cv_arg: TypeAlias = RuleContent_561.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_561

    @classmethod
    def create(cls, arg: "Variation_794.cv_arg") -> "Variation_794":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_561:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_561:
        return self.rule.content

class Content_455(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Slow Descent", 1: "Fast Descent", 2: "Slow Climb", 3: "Fast Climb"}

class RuleContent_455(RuleContentContextFree):
    cv_arg: TypeAlias = Content_455.cv_arg
    cv_content: TypeAlias = Content_455

    @property
    def content(self) -> Content_455:
        return self._get_content() # type: ignore

class Variation_787(Element):
    cv_arg: TypeAlias = RuleContent_455.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_455

    @classmethod
    def create(cls, arg: "Variation_787.cv_arg") -> "Variation_787":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_455:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_455:
        return self.rule.content

class Content_12(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Above", 1: "Below"}

class RuleContent_12(RuleContentContextFree):
    cv_arg: TypeAlias = Content_12.cv_arg
    cv_content: TypeAlias = Content_12

    @property
    def content(self) -> Content_12:
        return self._get_content() # type: ignore

class Variation_775(Element):
    cv_arg: TypeAlias = RuleContent_12.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_12

    @classmethod
    def create(cls, arg: "Variation_775.cv_arg") -> "Variation_775":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_12:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_12:
        return self.rule.content

class Content_475(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Table - Single RWY Operation", 1: "MRS - Single RWY Operation", 2: "ROT - Single RWY Operation", 3: "GAP - Single RWY Operation", 4: "Table - Parallel RWY Operation", 5: "MRS - Parallel RWY Operation", 6: "ROT - Parallel RWY Operation", 7: "GAP - Parallel RWY Operation"}

class RuleContent_475(RuleContentContextFree):
    cv_arg: TypeAlias = Content_475.cv_arg
    cv_content: TypeAlias = Content_475

    @property
    def content(self) -> Content_475:
        return self._get_content() # type: ignore

class Variation_788(Element):
    cv_arg: TypeAlias = RuleContent_475.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_475

    @classmethod
    def create(cls, arg: "Variation_788.cv_arg") -> "Variation_788":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_475:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_475:
        return self.rule.content

class Content_207(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "End of Alert", 1: "Planned Alert", 2: "Alert on TABLE Indicator", 3: "Alert on MRS Indicator", 4: "Alert on ROT Indicator", 5: "Alert on GAP Indicator"}

class RuleContent_207(RuleContentContextFree):
    cv_arg: TypeAlias = Content_207.cv_arg
    cv_content: TypeAlias = Content_207

    @property
    def content(self) -> Content_207:
        return self._get_content() # type: ignore

class Variation_779(Element):
    cv_arg: TypeAlias = RuleContent_207.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_207

    @classmethod
    def create(cls, arg: "Variation_779.cv_arg") -> "Variation_779":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_207:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_207:
        return self.rule.content

class Content_255(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Line-Up vs. Line-Up", 1: "Line-Up vs. Cross or Enter", 2: "Line-Up vs. Take-Off", 3: "Line-Up vs. Landing"}

class RuleContent_255(RuleContentContextFree):
    cv_arg: TypeAlias = Content_255.cv_arg
    cv_content: TypeAlias = Content_255

    @property
    def content(self) -> Content_255:
        return self._get_content() # type: ignore

class Variation_781(Element):
    cv_arg: TypeAlias = RuleContent_255.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_255

    @classmethod
    def create(cls, arg: "Variation_781.cv_arg") -> "Variation_781":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_255:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_255:
        return self.rule.content

class Content_70(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Cross or Enter  vs. Line-Up", 1: "Cross or Enter  vs. Cross or Enter", 2: "Cross or Enter  vs. Take-Off", 3: "Cross or Enter  vs. Landing"}

class RuleContent_70(RuleContentContextFree):
    cv_arg: TypeAlias = Content_70.cv_arg
    cv_content: TypeAlias = Content_70

    @property
    def content(self) -> Content_70:
        return self._get_content() # type: ignore

class Variation_778(Element):
    cv_arg: TypeAlias = RuleContent_70.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_70

    @classmethod
    def create(cls, arg: "Variation_778.cv_arg") -> "Variation_778":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_70:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_70:
        return self.rule.content

class Content_476(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Take-Off vs. Line-Up", 1: "Take-Off vs. Cross or Enter", 2: "Take-Off vs. Take-Off", 3: "Take-Off vs. Landing"}

class RuleContent_476(RuleContentContextFree):
    cv_arg: TypeAlias = Content_476.cv_arg
    cv_content: TypeAlias = Content_476

    @property
    def content(self) -> Content_476:
        return self._get_content() # type: ignore

class Variation_789(Element):
    cv_arg: TypeAlias = RuleContent_476.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_476

    @classmethod
    def create(cls, arg: "Variation_789.cv_arg") -> "Variation_789":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_476:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_476:
        return self.rule.content

class Content_252(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Landing vs. Line-Up", 1: "Landing vs. Cross or Enter", 2: "Landing vs. Take-Off", 3: "Landing vs. Landing"}

class RuleContent_252(RuleContentContextFree):
    cv_arg: TypeAlias = Content_252.cv_arg
    cv_content: TypeAlias = Content_252

    @property
    def content(self) -> Content_252:
        return self._get_content() # type: ignore

class Variation_780(Element):
    cv_arg: TypeAlias = RuleContent_252.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_252

    @classmethod
    def create(cls, arg: "Variation_780.cv_arg") -> "Variation_780":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_252:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_252:
        return self.rule.content

class Content_430(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Push-Back vs. Push-Back", 1: "Push-Back vs. Taxi"}

class RuleContent_430(RuleContentContextFree):
    cv_arg: TypeAlias = Content_430.cv_arg
    cv_content: TypeAlias = Content_430

    @property
    def content(self) -> Content_430:
        return self._get_content() # type: ignore

class Variation_786(Element):
    cv_arg: TypeAlias = RuleContent_430.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_430

    @classmethod
    def create(cls, arg: "Variation_786.cv_arg") -> "Variation_786":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_430:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_430:
        return self.rule.content

class Content_483(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Taxi vs. Push-Back", 1: "TAxi vs. Taxi"}

class RuleContent_483(RuleContentContextFree):
    cv_arg: TypeAlias = Content_483.cv_arg
    cv_content: TypeAlias = Content_483

    @property
    def content(self) -> Content_483:
        return self._get_content() # type: ignore

class Variation_790(Element):
    cv_arg: TypeAlias = RuleContent_483.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_483

    @classmethod
    def create(cls, arg: "Variation_790.cv_arg") -> "Variation_790":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_483:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_483:
        return self.rule.content

class Content_312(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No Push-Back Clearance", 1: "No Taxi Clearance", 2: "No Line-Up Clearance", 3: "No Crossing Clearance", 4: "No Enter Clearance", 5: "No Take-Off Clearance", 6: "Landing Clearance"}

class RuleContent_312(RuleContentContextFree):
    cv_arg: TypeAlias = Content_312.cv_arg
    cv_content: TypeAlias = Content_312

    @property
    def content(self) -> Content_312:
        return self._get_content() # type: ignore

class Variation_782(Element):
    cv_arg: TypeAlias = RuleContent_312.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_312

    @classmethod
    def create(cls, arg: "Variation_782.cv_arg") -> "Variation_782":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_312:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_312:
        return self.rule.content

class Content_21(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "After Push-Back Clearance", 1: "After Taxi Clearance", 2: "After Line-Up Clearance", 3: "After Crossing Clearance", 4: "After Enter Clearance", 5: "After Take-Off Clearance", 6: "Stationary on Runway", 7: "Stationary on Taxiway"}

class RuleContent_21(RuleContentContextFree):
    cv_arg: TypeAlias = Content_21.cv_arg
    cv_content: TypeAlias = Content_21

    @property
    def content(self) -> Content_21:
        return self._get_content() # type: ignore

class Variation_777(Element):
    cv_arg: TypeAlias = RuleContent_21.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_21

    @classmethod
    def create(cls, arg: "Variation_777.cv_arg") -> "Variation_777":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_21:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_21:
        return self.rule.content

class Content_341(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No contact (receiving ATSU)", 1: "No transfer (leaving ATSU)"}

class RuleContent_341(RuleContentContextFree):
    cv_arg: TypeAlias = Content_341.cv_arg
    cv_content: TypeAlias = Content_341

    @property
    def content(self) -> Content_341:
        return self._get_content() # type: ignore

class Variation_783(Element):
    cv_arg: TypeAlias = RuleContent_341.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_341

    @classmethod
    def create(cls, arg: "Variation_783.cv_arg") -> "Variation_783":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_341:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_341:
        return self.rule.content

class RuleVariation_1434(RuleVariationDependent):
    cv_arg: TypeAlias = Union[
        Variation_771.cv_arg,
        Variation_774.cv_arg,
        Variation_795.cv_arg,
        Variation_1330.cv_arg,
        Variation_1331.cv_arg,
        Variation_1331.cv_arg,
        Variation_1331.cv_arg,
        Variation_1331.cv_arg,
        Variation_1331.cv_arg,
        Variation_1331.cv_arg,
        Variation_1331.cv_arg,
        Variation_1331.cv_arg,
        Variation_773.cv_arg,
        Variation_792.cv_arg,
        Variation_793.cv_arg,
        Variation_794.cv_arg,
        Variation_787.cv_arg,
        Variation_775.cv_arg,
        Variation_788.cv_arg,
        Variation_788.cv_arg,
        Variation_779.cv_arg,
        Variation_781.cv_arg,
        Variation_778.cv_arg,
        Variation_789.cv_arg,
        Variation_780.cv_arg,
        Variation_786.cv_arg,
        Variation_790.cv_arg,
        Variation_782.cv_arg,
        Variation_777.cv_arg,
        Variation_783.cv_arg,
    ]
    cv_depends_on = [["000"], ["120", "CC", "TID"]]
    cv_default_variation: TypeAlias = Variation_771
    cv_cases = [
        ([5, 1], Variation_774),
        ([7, 0], Variation_795),
        ([7, 1], Variation_1330),
        ([9, 2], Variation_1331),
        ([10, 2], Variation_1331),
        ([11, 2], Variation_1331),
        ([12, 2], Variation_1331),
        ([13, 2], Variation_1331),
        ([14, 2], Variation_1331),
        ([15, 2], Variation_1331),
        ([16, 2], Variation_1331),
        ([15, 1], Variation_773),
        ([24, 1], Variation_792),
        ([24, 2], Variation_793),
        ([26, 1], Variation_794),
        ([27, 1], Variation_787),
        ([27, 2], Variation_775),
        ([33, 1], Variation_788),
        ([34, 1], Variation_788),
        ([35, 1], Variation_779),
        ([38, 0], Variation_781),
        ([38, 1], Variation_778),
        ([38, 2], Variation_789),
        ([38, 3], Variation_780),
        ([38, 4], Variation_786),
        ([38, 5], Variation_790),
        ([39, 1], Variation_782),
        ([40, 1], Variation_777),
        ([41, 1], Variation_783),
    ]

    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[5], Literal[1]]) -> Variation_774:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[7], Literal[0]]) -> Variation_795:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[7], Literal[1]]) -> Variation_1330:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[9], Literal[2]]) -> Variation_1331:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[10], Literal[2]]) -> Variation_1331:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[11], Literal[2]]) -> Variation_1331:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[12], Literal[2]]) -> Variation_1331:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[13], Literal[2]]) -> Variation_1331:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[14], Literal[2]]) -> Variation_1331:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[15], Literal[2]]) -> Variation_1331:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[16], Literal[2]]) -> Variation_1331:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[15], Literal[1]]) -> Variation_773:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[24], Literal[1]]) -> Variation_792:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[24], Literal[2]]) -> Variation_793:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[26], Literal[1]]) -> Variation_794:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[27], Literal[1]]) -> Variation_787:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[27], Literal[2]]) -> Variation_775:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[33], Literal[1]]) -> Variation_788:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[34], Literal[1]]) -> Variation_788:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[35], Literal[1]]) -> Variation_779:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[0]]) -> Variation_781:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[1]]) -> Variation_778:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[2]]) -> Variation_789:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[3]]) -> Variation_780:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[4]]) -> Variation_786:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[5]]) -> Variation_790:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[39], Literal[1]]) -> Variation_782:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[40], Literal[1]]) -> Variation_777:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[41], Literal[1]]) -> Variation_783:
        ...

    @classmethod
    def variation(cls, key : Any) -> Any:
        return cls._variation(key)

    @classmethod
    def create(cls, arg : "RuleVariation_1434.cv_arg") -> "RuleVariation_1434":
        return cls._create(arg) # type: ignore

class NonSpare_810(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1434.cv_arg
    cv_name = "CPC"
    cv_title = "Conflict Properties Class"
    cv_rule: TypeAlias = RuleVariation_1434

    @classmethod
    def create(cls, arg : "NonSpare_810.cv_arg") -> "NonSpare_810":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1434:
        return self.arg # type: ignore

class Item_206(Item):
    cv_arg: TypeAlias = NonSpare_810.cv_arg
    cv_non_spare: TypeAlias = NonSpare_810

    @classmethod
    def create(cls, arg : "Item_206.cv_arg") -> "Item_206":
        return cls._create(arg) # type: ignore

class Content_251(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "LOW", 1: "HIGH"}

class RuleContent_251(RuleContentContextFree):
    cv_arg: TypeAlias = Content_251.cv_arg
    cv_content: TypeAlias = Content_251

    @property
    def content(self) -> Content_251:
        return self._get_content() # type: ignore

class Variation_979(Element):
    cv_arg: TypeAlias = RuleContent_251.cv_arg
    cv_bit_offset8 = 7
    cv_bit_size = 1
    cv_rule = RuleContent_251

    @classmethod
    def create(cls, arg: "Variation_979.cv_arg") -> "Variation_979":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_251:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_251:
        return self.rule.content

class RuleVariation_949(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_979.cv_arg
    cv_variation: TypeAlias = Variation_979

    @classmethod
    def create(cls, arg : "RuleVariation_949.cv_arg") -> "RuleVariation_949":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_979:
        return self.arg # type: ignore

class NonSpare_826(NonSpare):
    cv_arg: TypeAlias = RuleVariation_949.cv_arg
    cv_name = "CS"
    cv_title = "Conflict Severity"
    cv_rule: TypeAlias = RuleVariation_949

    @classmethod
    def create(cls, arg : "NonSpare_826.cv_arg") -> "NonSpare_826":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_949:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_979:
        return self.rule.variation

class Item_217(Item):
    cv_arg: TypeAlias = NonSpare_826.cv_arg
    cv_non_spare: TypeAlias = NonSpare_826

    @classmethod
    def create(cls, arg : "Item_217.cv_arg") -> "Item_217":
        return cls._create(arg) # type: ignore

class Variation_1219(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_131.cv_arg, Tuple[Literal["TID"], RuleVariation_131.cv_arg]], Union[RuleVariation_1434.cv_arg, Tuple[Literal["CPC"], RuleVariation_1434.cv_arg]], Union[RuleVariation_949.cv_arg, Tuple[Literal["CS"], RuleVariation_949.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1219.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_993, 4), (Item_206, 3), (Item_217, 1)]
    cv_items_dict = {"TID": RuleVariation_131, "CPC": RuleVariation_1434, "CS": RuleVariation_949}

    @overload
    @classmethod
    def spec(cls, key : Literal["TID"]) -> RuleVariation_131:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPC"]) -> RuleVariation_1434:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CS"]) -> RuleVariation_949:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["TID"], Literal["CPC"], Literal["CS"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["TID"]) -> RuleVariation_131:
        ...
    @overload
    def get_item(self, key : Literal["CPC"]) -> RuleVariation_1434:
        ...
    @overload
    def get_item(self, key : Literal["CS"]) -> RuleVariation_949:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1219.cv_arg") -> 'Variation_1219':
        return cls._create(arg) # type: ignore

class RuleVariation_1159(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1219.cv_arg
    cv_variation: TypeAlias = Variation_1219

    @classmethod
    def create(cls, arg : "RuleVariation_1159.cv_arg") -> "RuleVariation_1159":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1219:
        return self.arg # type: ignore

class NonSpare_704(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1159.cv_arg
    cv_name = "CC"
    cv_title = "Conflict Classification"
    cv_rule: TypeAlias = RuleVariation_1159

    @classmethod
    def create(cls, arg : "NonSpare_704.cv_arg") -> "NonSpare_704":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1219:
        return self.rule.variation

class Content_728(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["%"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 0.5
    cv_unit = "%"

    def as_quantity(self, cv_unit : Optional[Literal["%"]] = None) -> float:
        return self._as_quantity()

class RuleContent_728(RuleContentContextFree):
    cv_arg: TypeAlias = Content_728.cv_arg
    cv_content: TypeAlias = Content_728

    @property
    def content(self) -> Content_728:
        return self._get_content() # type: ignore

class Variation_224(Element):
    cv_arg: TypeAlias = RuleContent_728.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_728

    @classmethod
    def create(cls, arg: "Variation_224.cv_arg") -> "Variation_224":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_728:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_728:
        return self.rule.content

class RuleVariation_217(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_224.cv_arg
    cv_variation: TypeAlias = Variation_224

    @classmethod
    def create(cls, arg : "RuleVariation_217.cv_arg") -> "RuleVariation_217":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_224:
        return self.arg # type: ignore

class NonSpare_808(NonSpare):
    cv_arg: TypeAlias = RuleVariation_217.cv_arg
    cv_name = "CP"
    cv_title = "Conflict Probability"
    cv_rule: TypeAlias = RuleVariation_217

    @classmethod
    def create(cls, arg : "NonSpare_808.cv_arg") -> "NonSpare_808":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_217:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_224:
        return self.rule.variation

class NonSpare_706(NonSpare):
    cv_arg: TypeAlias = RuleVariation_361.cv_arg
    cv_name = "CD"
    cv_title = "Conflict Duration"
    cv_rule: TypeAlias = RuleVariation_361

    @classmethod
    def create(cls, arg : "NonSpare_706.cv_arg") -> "NonSpare_706":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_361:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_368:
        return self.rule.variation

class Variation_1471(Compound):
    cv_arg = TypedDict('cv_arg', {
        "CN": NonSpare_739.cv_arg,
        "CC": NonSpare_704.cv_arg,
        "CP": NonSpare_808.cv_arg,
        "CD": NonSpare_706.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 1
    cv_items_list = [NonSpare_739, NonSpare_704, NonSpare_808, NonSpare_706]
    cv_items_dict = {"CN": NonSpare_739, "CC": NonSpare_704, "CP": NonSpare_808, "CD": NonSpare_706}

    @overload
    @classmethod
    def spec(cls, key : Literal["CN"]) -> NonSpare_739:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CC"]) -> NonSpare_704:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CP"]) -> NonSpare_808:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CD"]) -> NonSpare_706:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["CN"], Literal["CC"], Literal["CP"], Literal["CD"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["CN"]) -> Optional[NonSpare_739]:
        ...
    @overload
    def get_item(self, key : Literal["CC"]) -> Optional[NonSpare_704]:
        ...
    @overload
    def get_item(self, key : Literal["CP"]) -> Optional[NonSpare_808]:
        ...
    @overload
    def get_item(self, key : Literal["CD"]) -> Optional[NonSpare_706]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["CN"], val : NonSpare_739.cv_arg) -> "Variation_1471":
        ...
    @overload
    def set_item(self, key : Literal["CC"], val : NonSpare_704.cv_arg) -> "Variation_1471":
        ...
    @overload
    def set_item(self, key : Literal["CP"], val : NonSpare_808.cv_arg) -> "Variation_1471":
        ...
    @overload
    def set_item(self, key : Literal["CD"], val : NonSpare_706.cv_arg) -> "Variation_1471":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["CN"]) -> "Variation_1471":
        ...
    @overload
    def del_item(self, key : Literal["CC"]) -> "Variation_1471":
        ...
    @overload
    def del_item(self, key : Literal["CP"]) -> "Variation_1471":
        ...
    @overload
    def del_item(self, key : Literal["CD"]) -> "Variation_1471":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1471.cv_arg") -> 'Variation_1471':
        return cls._create(arg) # type: ignore

class RuleVariation_1393(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1471.cv_arg
    cv_variation: TypeAlias = Variation_1471

    @classmethod
    def create(cls, arg : "RuleVariation_1393.cv_arg") -> "RuleVariation_1393":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1471:
        return self.arg # type: ignore

class NonSpare_293(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1393.cv_arg
    cv_name = "120"
    cv_title = "Conflict Characteristics"
    cv_rule: TypeAlias = RuleVariation_1393

    @classmethod
    def create(cls, arg : "NonSpare_293.cv_arg") -> "NonSpare_293":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1393:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1471:
        return self.rule.variation

class UapItem_293(UapItem):
    cv_non_spare: TypeAlias = NonSpare_293

class NonSpare_1824(NonSpare):
    cv_arg: TypeAlias = RuleVariation_361.cv_arg
    cv_name = "TC"
    cv_title = "Time to Conflict"
    cv_rule: TypeAlias = RuleVariation_361

    @classmethod
    def create(cls, arg : "NonSpare_1824.cv_arg") -> "NonSpare_1824":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_361:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_368:
        return self.rule.variation

class NonSpare_1828(NonSpare):
    cv_arg: TypeAlias = RuleVariation_361.cv_arg
    cv_name = "TCA"
    cv_title = "Time to Closest Approach"
    cv_rule: TypeAlias = RuleVariation_361

    @classmethod
    def create(cls, arg : "NonSpare_1828.cv_arg") -> "NonSpare_1828":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_361:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_368:
        return self.rule.variation

class Variation_364(Element):
    cv_arg: TypeAlias = RuleContent_729.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_rule = RuleContent_729

    @classmethod
    def create(cls, arg: "Variation_364.cv_arg") -> "Variation_364":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_729:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_729:
        return self.rule.content

class RuleVariation_357(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_364.cv_arg
    cv_variation: TypeAlias = Variation_364

    @classmethod
    def create(cls, arg : "RuleVariation_357.cv_arg") -> "RuleVariation_357":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_364:
        return self.arg # type: ignore

class NonSpare_731(NonSpare):
    cv_arg: TypeAlias = RuleVariation_357.cv_arg
    cv_name = "CHS"
    cv_title = "Current Horizontal Separation"
    cv_rule: TypeAlias = RuleVariation_357

    @classmethod
    def create(cls, arg : "NonSpare_731.cv_arg") -> "NonSpare_731":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_357:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_364:
        return self.rule.variation

class NonSpare_1273(NonSpare):
    cv_arg: TypeAlias = RuleVariation_302.cv_arg
    cv_name = "MHS"
    cv_title = "Estimated Minimum Horizontal Separation"
    cv_rule: TypeAlias = RuleVariation_302

    @classmethod
    def create(cls, arg : "NonSpare_1273.cv_arg") -> "NonSpare_1273":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_302:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_309:
        return self.rule.variation

class Content_726(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["ft"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 25.0
    cv_unit = "ft"

    def as_quantity(self, cv_unit : Optional[Literal["ft"]] = None) -> float:
        return self._as_quantity()

class RuleContent_726(RuleContentContextFree):
    cv_arg: TypeAlias = Content_726.cv_arg
    cv_content: TypeAlias = Content_726

    @property
    def content(self) -> Content_726:
        return self._get_content() # type: ignore

class Variation_308(Element):
    cv_arg: TypeAlias = RuleContent_726.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_726

    @classmethod
    def create(cls, arg: "Variation_308.cv_arg") -> "Variation_308":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_726:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_726:
        return self.rule.content

class RuleVariation_301(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_308.cv_arg
    cv_variation: TypeAlias = Variation_308

    @classmethod
    def create(cls, arg : "RuleVariation_301.cv_arg") -> "RuleVariation_301":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_308:
        return self.arg # type: ignore

class NonSpare_845(NonSpare):
    cv_arg: TypeAlias = RuleVariation_301.cv_arg
    cv_name = "CVS"
    cv_title = "Current Vertical Separation"
    cv_rule: TypeAlias = RuleVariation_301

    @classmethod
    def create(cls, arg : "NonSpare_845.cv_arg") -> "NonSpare_845":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_301:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_308:
        return self.rule.variation

class NonSpare_1331(NonSpare):
    cv_arg: TypeAlias = RuleVariation_301.cv_arg
    cv_name = "MVS"
    cv_title = "Estimated Minimum Vertical Separation"
    cv_rule: TypeAlias = RuleVariation_301

    @classmethod
    def create(cls, arg : "NonSpare_1331.cv_arg") -> "NonSpare_1331":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_301:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_308:
        return self.rule.variation

class Variation_1506(Compound):
    cv_arg = TypedDict('cv_arg', {
        "TC": NonSpare_1824.cv_arg,
        "TCA": NonSpare_1828.cv_arg,
        "CHS": NonSpare_731.cv_arg,
        "MHS": NonSpare_1273.cv_arg,
        "CVS": NonSpare_845.cv_arg,
        "MVS": NonSpare_1331.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 1
    cv_items_list = [NonSpare_1824, NonSpare_1828, NonSpare_731, NonSpare_1273, NonSpare_845, NonSpare_1331]
    cv_items_dict = {"TC": NonSpare_1824, "TCA": NonSpare_1828, "CHS": NonSpare_731, "MHS": NonSpare_1273, "CVS": NonSpare_845, "MVS": NonSpare_1331}

    @overload
    @classmethod
    def spec(cls, key : Literal["TC"]) -> NonSpare_1824:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TCA"]) -> NonSpare_1828:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CHS"]) -> NonSpare_731:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MHS"]) -> NonSpare_1273:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CVS"]) -> NonSpare_845:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MVS"]) -> NonSpare_1331:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["TC"], Literal["TCA"], Literal["CHS"], Literal["MHS"], Literal["CVS"], Literal["MVS"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["TC"]) -> Optional[NonSpare_1824]:
        ...
    @overload
    def get_item(self, key : Literal["TCA"]) -> Optional[NonSpare_1828]:
        ...
    @overload
    def get_item(self, key : Literal["CHS"]) -> Optional[NonSpare_731]:
        ...
    @overload
    def get_item(self, key : Literal["MHS"]) -> Optional[NonSpare_1273]:
        ...
    @overload
    def get_item(self, key : Literal["CVS"]) -> Optional[NonSpare_845]:
        ...
    @overload
    def get_item(self, key : Literal["MVS"]) -> Optional[NonSpare_1331]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["TC"], val : NonSpare_1824.cv_arg) -> "Variation_1506":
        ...
    @overload
    def set_item(self, key : Literal["TCA"], val : NonSpare_1828.cv_arg) -> "Variation_1506":
        ...
    @overload
    def set_item(self, key : Literal["CHS"], val : NonSpare_731.cv_arg) -> "Variation_1506":
        ...
    @overload
    def set_item(self, key : Literal["MHS"], val : NonSpare_1273.cv_arg) -> "Variation_1506":
        ...
    @overload
    def set_item(self, key : Literal["CVS"], val : NonSpare_845.cv_arg) -> "Variation_1506":
        ...
    @overload
    def set_item(self, key : Literal["MVS"], val : NonSpare_1331.cv_arg) -> "Variation_1506":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["TC"]) -> "Variation_1506":
        ...
    @overload
    def del_item(self, key : Literal["TCA"]) -> "Variation_1506":
        ...
    @overload
    def del_item(self, key : Literal["CHS"]) -> "Variation_1506":
        ...
    @overload
    def del_item(self, key : Literal["MHS"]) -> "Variation_1506":
        ...
    @overload
    def del_item(self, key : Literal["CVS"]) -> "Variation_1506":
        ...
    @overload
    def del_item(self, key : Literal["MVS"]) -> "Variation_1506":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1506.cv_arg") -> 'Variation_1506':
        return cls._create(arg) # type: ignore

class RuleVariation_1428(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1506.cv_arg
    cv_variation: TypeAlias = Variation_1506

    @classmethod
    def create(cls, arg : "RuleVariation_1428.cv_arg") -> "RuleVariation_1428":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1506:
        return self.arg # type: ignore

class NonSpare_200(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1428.cv_arg
    cv_name = "070"
    cv_title = "Conflict Timing and Separation"
    cv_rule: TypeAlias = RuleVariation_1428

    @classmethod
    def create(cls, arg : "NonSpare_200.cv_arg") -> "NonSpare_200":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1428:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1506:
        return self.rule.variation

class UapItem_200(UapItem):
    cv_non_spare: TypeAlias = NonSpare_200

class Content_630(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["ft"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 25.0
    cv_unit = "ft"

    def as_quantity(self, cv_unit : Optional[Literal["ft"]] = None) -> float:
        return self._as_quantity()

class RuleContent_630(RuleContentContextFree):
    cv_arg: TypeAlias = Content_630.cv_arg
    cv_content: TypeAlias = Content_630

    @property
    def content(self) -> Content_630:
        return self._get_content() # type: ignore

class Variation_260(Element):
    cv_arg: TypeAlias = RuleContent_630.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_630

    @classmethod
    def create(cls, arg: "Variation_260.cv_arg") -> "Variation_260":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_630:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_630:
        return self.rule.content

class RuleVariation_253(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_260.cv_arg
    cv_variation: TypeAlias = Variation_260

    @classmethod
    def create(cls, arg : "RuleVariation_253.cv_arg") -> "RuleVariation_253":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_260:
        return self.arg # type: ignore

class NonSpare_226(NonSpare):
    cv_arg: TypeAlias = RuleVariation_253.cv_arg
    cv_name = "076"
    cv_title = "Vertical Deviation"
    cv_rule: TypeAlias = RuleVariation_253

    @classmethod
    def create(cls, arg : "NonSpare_226.cv_arg") -> "NonSpare_226":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_253:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_260:
        return self.rule.variation

class UapItem_226(UapItem):
    cv_non_spare: TypeAlias = NonSpare_226

class Content_635(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 32.0
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_635(RuleContentContextFree):
    cv_arg: TypeAlias = Content_635.cv_arg
    cv_content: TypeAlias = Content_635

    @property
    def content(self) -> Content_635:
        return self._get_content() # type: ignore

class Variation_262(Element):
    cv_arg: TypeAlias = RuleContent_635.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_635

    @classmethod
    def create(cls, arg: "Variation_262.cv_arg") -> "Variation_262":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_635:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_635:
        return self.rule.content

class RuleVariation_255(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_262.cv_arg
    cv_variation: TypeAlias = Variation_262

    @classmethod
    def create(cls, arg : "RuleVariation_255.cv_arg") -> "RuleVariation_255":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_262:
        return self.arg # type: ignore

class NonSpare_221(NonSpare):
    cv_arg: TypeAlias = RuleVariation_255.cv_arg
    cv_name = "074"
    cv_title = "Longitudinal Deviation"
    cv_rule: TypeAlias = RuleVariation_255

    @classmethod
    def create(cls, arg : "NonSpare_221.cv_arg") -> "NonSpare_221":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_255:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_262:
        return self.rule.variation

class UapItem_221(UapItem):
    cv_non_spare: TypeAlias = NonSpare_221

class NonSpare_224(NonSpare):
    cv_arg: TypeAlias = RuleVariation_343.cv_arg
    cv_name = "075"
    cv_title = "Transversal Distance Deviation"
    cv_rule: TypeAlias = RuleVariation_343

    @classmethod
    def create(cls, arg : "NonSpare_224.cv_arg") -> "NonSpare_224":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_343:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_350:
        return self.rule.variation

class UapItem_224(UapItem):
    cv_non_spare: TypeAlias = NonSpare_224

class Content_607(ContentString):
    cv_arg: TypeAlias = Union[int, str]
    cv_string_type: TypeAlias = StringICAO

class RuleContent_607(RuleContentContextFree):
    cv_arg: TypeAlias = Content_607.cv_arg
    cv_content: TypeAlias = Content_607

    @property
    def content(self) -> Content_607:
        return self._get_content() # type: ignore

class Variation_389(Element):
    cv_arg: TypeAlias = RuleContent_607.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 48
    cv_rule = RuleContent_607

    @classmethod
    def create(cls, arg: "Variation_389.cv_arg") -> "Variation_389":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_607:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_607:
        return self.rule.content

class RuleVariation_381(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_389.cv_arg
    cv_variation: TypeAlias = Variation_389

    @classmethod
    def create(cls, arg : "RuleVariation_381.cv_arg") -> "RuleVariation_381":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_389:
        return self.arg # type: ignore

class NonSpare_605(NonSpare):
    cv_arg: TypeAlias = RuleVariation_381.cv_arg
    cv_name = "AN"
    cv_title = "Area Name"
    cv_rule: TypeAlias = RuleVariation_381

    @classmethod
    def create(cls, arg : "NonSpare_605.cv_arg") -> "NonSpare_605":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_381:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_389:
        return self.rule.variation

class NonSpare_698(NonSpare):
    cv_arg: TypeAlias = RuleVariation_383.cv_arg
    cv_name = "CAN"
    cv_title = "Crossing Area Name"
    cv_rule: TypeAlias = RuleVariation_383

    @classmethod
    def create(cls, arg : "NonSpare_698.cv_arg") -> "NonSpare_698":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_391:
        return self.rule.variation

class NonSpare_1618(NonSpare):
    cv_arg: TypeAlias = RuleVariation_383.cv_arg
    cv_name = "RT1"
    cv_title = "Runway/Taxiway Designator 1"
    cv_rule: TypeAlias = RuleVariation_383

    @classmethod
    def create(cls, arg : "NonSpare_1618.cv_arg") -> "NonSpare_1618":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_391:
        return self.rule.variation

class NonSpare_1619(NonSpare):
    cv_arg: TypeAlias = RuleVariation_383.cv_arg
    cv_name = "RT2"
    cv_title = "Runway/Taxiway Designator 2"
    cv_rule: TypeAlias = RuleVariation_383

    @classmethod
    def create(cls, arg : "NonSpare_1619.cv_arg") -> "NonSpare_1619":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_391:
        return self.rule.variation

class NonSpare_1654(NonSpare):
    cv_arg: TypeAlias = RuleVariation_383.cv_arg
    cv_name = "SB"
    cv_title = "Stop Bar Designator"
    cv_rule: TypeAlias = RuleVariation_383

    @classmethod
    def create(cls, arg : "NonSpare_1654.cv_arg") -> "NonSpare_1654":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_391:
        return self.rule.variation

class NonSpare_1004(NonSpare):
    cv_arg: TypeAlias = RuleVariation_383.cv_arg
    cv_name = "G"
    cv_title = "Gate Designator"
    cv_rule: TypeAlias = RuleVariation_383

    @classmethod
    def create(cls, arg : "NonSpare_1004.cv_arg") -> "NonSpare_1004":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_391:
        return self.rule.variation

class Variation_1464(Compound):
    cv_arg = TypedDict('cv_arg', {
        "AN": NonSpare_605.cv_arg,
        "CAN": NonSpare_698.cv_arg,
        "RT1": NonSpare_1618.cv_arg,
        "RT2": NonSpare_1619.cv_arg,
        "SB": NonSpare_1654.cv_arg,
        "G": NonSpare_1004.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 1
    cv_items_list = [NonSpare_605, NonSpare_698, NonSpare_1618, NonSpare_1619, NonSpare_1654, NonSpare_1004]
    cv_items_dict = {"AN": NonSpare_605, "CAN": NonSpare_698, "RT1": NonSpare_1618, "RT2": NonSpare_1619, "SB": NonSpare_1654, "G": NonSpare_1004}

    @overload
    @classmethod
    def spec(cls, key : Literal["AN"]) -> NonSpare_605:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CAN"]) -> NonSpare_698:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["RT1"]) -> NonSpare_1618:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["RT2"]) -> NonSpare_1619:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SB"]) -> NonSpare_1654:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> NonSpare_1004:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["AN"], Literal["CAN"], Literal["RT1"], Literal["RT2"], Literal["SB"], Literal["G"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["AN"]) -> Optional[NonSpare_605]:
        ...
    @overload
    def get_item(self, key : Literal["CAN"]) -> Optional[NonSpare_698]:
        ...
    @overload
    def get_item(self, key : Literal["RT1"]) -> Optional[NonSpare_1618]:
        ...
    @overload
    def get_item(self, key : Literal["RT2"]) -> Optional[NonSpare_1619]:
        ...
    @overload
    def get_item(self, key : Literal["SB"]) -> Optional[NonSpare_1654]:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> Optional[NonSpare_1004]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["AN"], val : NonSpare_605.cv_arg) -> "Variation_1464":
        ...
    @overload
    def set_item(self, key : Literal["CAN"], val : NonSpare_698.cv_arg) -> "Variation_1464":
        ...
    @overload
    def set_item(self, key : Literal["RT1"], val : NonSpare_1618.cv_arg) -> "Variation_1464":
        ...
    @overload
    def set_item(self, key : Literal["RT2"], val : NonSpare_1619.cv_arg) -> "Variation_1464":
        ...
    @overload
    def set_item(self, key : Literal["SB"], val : NonSpare_1654.cv_arg) -> "Variation_1464":
        ...
    @overload
    def set_item(self, key : Literal["G"], val : NonSpare_1004.cv_arg) -> "Variation_1464":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["AN"]) -> "Variation_1464":
        ...
    @overload
    def del_item(self, key : Literal["CAN"]) -> "Variation_1464":
        ...
    @overload
    def del_item(self, key : Literal["RT1"]) -> "Variation_1464":
        ...
    @overload
    def del_item(self, key : Literal["RT2"]) -> "Variation_1464":
        ...
    @overload
    def del_item(self, key : Literal["SB"]) -> "Variation_1464":
        ...
    @overload
    def del_item(self, key : Literal["G"]) -> "Variation_1464":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1464.cv_arg") -> 'Variation_1464':
        return cls._create(arg) # type: ignore

class RuleVariation_1386(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1464.cv_arg
    cv_variation: TypeAlias = Variation_1464

    @classmethod
    def create(cls, arg : "RuleVariation_1386.cv_arg") -> "RuleVariation_1386":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1464:
        return self.arg # type: ignore

class NonSpare_263(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1386.cv_arg
    cv_name = "100"
    cv_title = "Area Definition"
    cv_rule: TypeAlias = RuleVariation_1386

    @classmethod
    def create(cls, arg : "NonSpare_263.cv_arg") -> "NonSpare_263":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1386:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1464:
        return self.rule.variation

class UapItem_263(UapItem):
    cv_non_spare: TypeAlias = NonSpare_263

class NonSpare_128(NonSpare):
    cv_arg: TypeAlias = RuleVariation_244.cv_arg
    cv_name = "035"
    cv_title = "Track Number 2"
    cv_rule: TypeAlias = RuleVariation_244

    @classmethod
    def create(cls, arg : "NonSpare_128.cv_arg") -> "NonSpare_128":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_244:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_251:
        return self.rule.variation

class UapItem_128(UapItem):
    cv_non_spare: TypeAlias = NonSpare_128

class NonSpare_582(NonSpare):
    cv_arg: TypeAlias = RuleVariation_383.cv_arg
    cv_name = "AI2"
    cv_title = "Aircraft Identifier (in 7 Characters) of Aircraft 2 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_383

    @classmethod
    def create(cls, arg : "NonSpare_582.cv_arg") -> "NonSpare_582":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_391:
        return self.rule.variation

class NonSpare_1299(NonSpare):
    cv_arg: TypeAlias = RuleVariation_776.cv_arg
    cv_name = "MODE3A"
    cv_title = "Mode-3/A Code (Converted Into Octal Representation) of Aircraft 2 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_776

    @classmethod
    def create(cls, arg : "NonSpare_1299.cv_arg") -> "NonSpare_1299":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_776:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_806:
        return self.rule.variation

class Item_571(Item):
    cv_arg: TypeAlias = NonSpare_1299.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1299

    @classmethod
    def create(cls, arg : "Item_571.cv_arg") -> "Item_571":
        return cls._create(arg) # type: ignore

class Variation_1025(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_776.cv_arg, Tuple[Literal["MODE3A"], RuleVariation_776.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1025.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_3, 4), (Item_571, 12)]
    cv_items_dict = {"MODE3A": RuleVariation_776}

    @classmethod
    def spec(cls, key : Literal["MODE3A"]) -> RuleVariation_776:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["MODE3A"]) -> RuleVariation_776:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1025.cv_arg") -> 'Variation_1025':
        return cls._create(arg) # type: ignore

class RuleVariation_994(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1025.cv_arg
    cv_variation: TypeAlias = Variation_1025

    @classmethod
    def create(cls, arg : "RuleVariation_994.cv_arg") -> "RuleVariation_994":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1025:
        return self.arg # type: ignore

class NonSpare_1206(NonSpare):
    cv_arg: TypeAlias = RuleVariation_994.cv_arg
    cv_name = "M32"
    cv_title = "Mode 3/A Code Aircraft 2"
    cv_rule: TypeAlias = RuleVariation_994

    @classmethod
    def create(cls, arg : "NonSpare_1206.cv_arg") -> "NonSpare_1206":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_994:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1025:
        return self.rule.variation

class NonSpare_817(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1077.cv_arg
    cv_name = "CPW"
    cv_title = "Predicted Conflict Position Target 2 in WGS-84 Coordinates"
    cv_rule: TypeAlias = RuleVariation_1077

    @classmethod
    def create(cls, arg : "NonSpare_817.cv_arg") -> "NonSpare_817":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1077:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1121:
        return self.rule.variation

class NonSpare_814(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1230.cv_arg
    cv_name = "CPL"
    cv_title = "Predicted Conflict Position for the Aircraft 2 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_1230

    @classmethod
    def create(cls, arg : "NonSpare_814.cv_arg") -> "NonSpare_814":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1230:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1301:
        return self.rule.variation

class NonSpare_1934(NonSpare):
    cv_arg: TypeAlias = RuleVariation_361.cv_arg
    cv_name = "TT2"
    cv_title = "Time to Runway Threshold for Second Approaching Aircraft in a RIMCA"
    cv_rule: TypeAlias = RuleVariation_361

    @classmethod
    def create(cls, arg : "NonSpare_1934.cv_arg") -> "NonSpare_1934":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_361:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_368:
        return self.rule.variation

class NonSpare_898(NonSpare):
    cv_arg: TypeAlias = RuleVariation_302.cv_arg
    cv_name = "DT2"
    cv_title = "Distance to Runway Threshold for Aircraft 2 Involved in a RIMCA"
    cv_rule: TypeAlias = RuleVariation_302

    @classmethod
    def create(cls, arg : "NonSpare_898.cv_arg") -> "NonSpare_898":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_302:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_309:
        return self.rule.variation

class NonSpare_554(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1277.cv_arg
    cv_name = "AC2"
    cv_title = "Characteristics of Aircraft 2 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_1277

    @classmethod
    def create(cls, arg : "NonSpare_554.cv_arg") -> "NonSpare_554":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1277:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1355:
        return self.rule.variation

class NonSpare_1313(NonSpare):
    cv_arg: TypeAlias = RuleVariation_380.cv_arg
    cv_name = "MS2"
    cv_title = "Aircraft Identification Downloaded From Aircraft 2 Involved in the Conflict If Eequipped With a Mode-S Transponder"
    cv_rule: TypeAlias = RuleVariation_380

    @classmethod
    def create(cls, arg : "NonSpare_1313.cv_arg") -> "NonSpare_1313":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_380:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_388:
        return self.rule.variation

class NonSpare_979(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1003.cv_arg
    cv_name = "FP2"
    cv_title = "Number of the Flight Plan Correlated to Aircraft 2 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_1003

    @classmethod
    def create(cls, arg : "NonSpare_979.cv_arg") -> "NonSpare_979":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1003:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1035:
        return self.rule.variation

class NonSpare_719(NonSpare):
    cv_arg: TypeAlias = RuleVariation_312.cv_arg
    cv_name = "CF2"
    cv_title = "Cleared Flight Level for Aircraft 2 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_312

    @classmethod
    def create(cls, arg : "NonSpare_719.cv_arg") -> "NonSpare_719":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_312:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_319:
        return self.rule.variation

class Variation_1462(Compound):
    cv_arg = TypedDict('cv_arg', {
        "AI2": NonSpare_582.cv_arg,
        "M32": NonSpare_1206.cv_arg,
        "CPW": NonSpare_817.cv_arg,
        "CPL": NonSpare_814.cv_arg,
        "TT2": NonSpare_1934.cv_arg,
        "DT2": NonSpare_898.cv_arg,
        "AC2": NonSpare_554.cv_arg,
        "MS2": NonSpare_1313.cv_arg,
        "FP2": NonSpare_979.cv_arg,
        "CF2": NonSpare_719.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 2
    cv_items_list = [NonSpare_582, NonSpare_1206, NonSpare_817, NonSpare_814, NonSpare_1934, NonSpare_898, NonSpare_554, NonSpare_1313, NonSpare_979, NonSpare_719]
    cv_items_dict = {"AI2": NonSpare_582, "M32": NonSpare_1206, "CPW": NonSpare_817, "CPL": NonSpare_814, "TT2": NonSpare_1934, "DT2": NonSpare_898, "AC2": NonSpare_554, "MS2": NonSpare_1313, "FP2": NonSpare_979, "CF2": NonSpare_719}

    @overload
    @classmethod
    def spec(cls, key : Literal["AI2"]) -> NonSpare_582:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["M32"]) -> NonSpare_1206:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPW"]) -> NonSpare_817:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPL"]) -> NonSpare_814:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TT2"]) -> NonSpare_1934:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["DT2"]) -> NonSpare_898:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AC2"]) -> NonSpare_554:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MS2"]) -> NonSpare_1313:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["FP2"]) -> NonSpare_979:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CF2"]) -> NonSpare_719:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["AI2"], Literal["M32"], Literal["CPW"], Literal["CPL"], Literal["TT2"], Literal["DT2"], Literal["AC2"], Literal["MS2"], Literal["FP2"], Literal["CF2"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["AI2"]) -> Optional[NonSpare_582]:
        ...
    @overload
    def get_item(self, key : Literal["M32"]) -> Optional[NonSpare_1206]:
        ...
    @overload
    def get_item(self, key : Literal["CPW"]) -> Optional[NonSpare_817]:
        ...
    @overload
    def get_item(self, key : Literal["CPL"]) -> Optional[NonSpare_814]:
        ...
    @overload
    def get_item(self, key : Literal["TT2"]) -> Optional[NonSpare_1934]:
        ...
    @overload
    def get_item(self, key : Literal["DT2"]) -> Optional[NonSpare_898]:
        ...
    @overload
    def get_item(self, key : Literal["AC2"]) -> Optional[NonSpare_554]:
        ...
    @overload
    def get_item(self, key : Literal["MS2"]) -> Optional[NonSpare_1313]:
        ...
    @overload
    def get_item(self, key : Literal["FP2"]) -> Optional[NonSpare_979]:
        ...
    @overload
    def get_item(self, key : Literal["CF2"]) -> Optional[NonSpare_719]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["AI2"], val : NonSpare_582.cv_arg) -> "Variation_1462":
        ...
    @overload
    def set_item(self, key : Literal["M32"], val : NonSpare_1206.cv_arg) -> "Variation_1462":
        ...
    @overload
    def set_item(self, key : Literal["CPW"], val : NonSpare_817.cv_arg) -> "Variation_1462":
        ...
    @overload
    def set_item(self, key : Literal["CPL"], val : NonSpare_814.cv_arg) -> "Variation_1462":
        ...
    @overload
    def set_item(self, key : Literal["TT2"], val : NonSpare_1934.cv_arg) -> "Variation_1462":
        ...
    @overload
    def set_item(self, key : Literal["DT2"], val : NonSpare_898.cv_arg) -> "Variation_1462":
        ...
    @overload
    def set_item(self, key : Literal["AC2"], val : NonSpare_554.cv_arg) -> "Variation_1462":
        ...
    @overload
    def set_item(self, key : Literal["MS2"], val : NonSpare_1313.cv_arg) -> "Variation_1462":
        ...
    @overload
    def set_item(self, key : Literal["FP2"], val : NonSpare_979.cv_arg) -> "Variation_1462":
        ...
    @overload
    def set_item(self, key : Literal["CF2"], val : NonSpare_719.cv_arg) -> "Variation_1462":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["AI2"]) -> "Variation_1462":
        ...
    @overload
    def del_item(self, key : Literal["M32"]) -> "Variation_1462":
        ...
    @overload
    def del_item(self, key : Literal["CPW"]) -> "Variation_1462":
        ...
    @overload
    def del_item(self, key : Literal["CPL"]) -> "Variation_1462":
        ...
    @overload
    def del_item(self, key : Literal["TT2"]) -> "Variation_1462":
        ...
    @overload
    def del_item(self, key : Literal["DT2"]) -> "Variation_1462":
        ...
    @overload
    def del_item(self, key : Literal["AC2"]) -> "Variation_1462":
        ...
    @overload
    def del_item(self, key : Literal["MS2"]) -> "Variation_1462":
        ...
    @overload
    def del_item(self, key : Literal["FP2"]) -> "Variation_1462":
        ...
    @overload
    def del_item(self, key : Literal["CF2"]) -> "Variation_1462":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1462.cv_arg") -> 'Variation_1462':
        return cls._create(arg) # type: ignore

class RuleVariation_1384(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1462.cv_arg
    cv_variation: TypeAlias = Variation_1462

    @classmethod
    def create(cls, arg : "RuleVariation_1384.cv_arg") -> "RuleVariation_1384":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1462:
        return self.arg # type: ignore

class NonSpare_377(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1384.cv_arg
    cv_name = "171"
    cv_title = "Aircraft Identification and Characteristics 2"
    cv_rule: TypeAlias = RuleVariation_1384

    @classmethod
    def create(cls, arg : "NonSpare_377.cv_arg") -> "NonSpare_377":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1384:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1462:
        return self.rule.variation

class UapItem_377(UapItem):
    cv_non_spare: TypeAlias = NonSpare_377

class NonSpare_714(NonSpare):
    cv_arg: TypeAlias = RuleVariation_158.cv_arg
    cv_name = "CEN"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_158

    @classmethod
    def create(cls, arg : "NonSpare_714.cv_arg") -> "NonSpare_714":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_158:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_164:
        return self.rule.variation

class Item_146(Item):
    cv_arg: TypeAlias = NonSpare_714.cv_arg
    cv_non_spare: TypeAlias = NonSpare_714

    @classmethod
    def create(cls, arg : "Item_146.cv_arg") -> "Item_146":
        return cls._create(arg) # type: ignore

class NonSpare_1432(NonSpare):
    cv_arg: TypeAlias = RuleVariation_158.cv_arg
    cv_name = "POS"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_158

    @classmethod
    def create(cls, arg : "NonSpare_1432.cv_arg") -> "NonSpare_1432":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_158:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_164:
        return self.rule.variation

class Item_687(Item):
    cv_arg: TypeAlias = NonSpare_1432.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1432

    @classmethod
    def create(cls, arg : "Item_687.cv_arg") -> "Item_687":
        return cls._create(arg) # type: ignore

class Variation_1062(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_158.cv_arg, Tuple[Literal["CEN"], RuleVariation_158.cv_arg]], Union[RuleVariation_158.cv_arg, Tuple[Literal["POS"], RuleVariation_158.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1062.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_146, 8), (Item_687, 8)]
    cv_items_dict = {"CEN": RuleVariation_158, "POS": RuleVariation_158}

    @overload
    @classmethod
    def spec(cls, key : Literal["CEN"]) -> RuleVariation_158:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["POS"]) -> RuleVariation_158:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["CEN"], Literal["POS"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["CEN"]) -> RuleVariation_158:
        ...
    @overload
    def get_item(self, key : Literal["POS"]) -> RuleVariation_158:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1062.cv_arg") -> 'Variation_1062':
        return cls._create(arg) # type: ignore

class Variation_1406(Repetitive):
    cv_arg: TypeAlias = List[Variation_1062.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1062

    @classmethod
    def create(cls, arg: "Variation_1406.cv_arg") -> 'Variation_1406':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1062]:
        return self._get_list() # type: ignore

class RuleVariation_1328(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1406.cv_arg
    cv_variation: TypeAlias = Variation_1406

    @classmethod
    def create(cls, arg : "RuleVariation_1328.cv_arg") -> "RuleVariation_1328":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1406:
        return self.arg # type: ignore

class NonSpare_282(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1328.cv_arg
    cv_name = "110"
    cv_title = "FDPS Sector Control Identification"
    cv_rule: TypeAlias = RuleVariation_1328

    @classmethod
    def create(cls, arg : "NonSpare_282.cv_arg") -> "NonSpare_282":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1328:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1406:
        return self.rule.variation

class UapItem_282(UapItem):
    cv_non_spare: TypeAlias = NonSpare_282

class Variation_1455(Explicit):
    cv_arg: TypeAlias = bytes
    cv_explicit_type: TypeAlias = ReservedExpansion

    @classmethod
    def create(cls, arg: "Variation_1455.cv_arg") -> 'Variation_1455':
        return cls._create(arg) # type: ignore

class RuleVariation_1377(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1455.cv_arg
    cv_variation: TypeAlias = Variation_1455

    @classmethod
    def create(cls, arg : "RuleVariation_1377.cv_arg") -> "RuleVariation_1377":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1455:
        return self.arg # type: ignore

class NonSpare_1557(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1377.cv_arg
    cv_name = "RE"
    cv_title = "Reserved Expansion Field"
    cv_rule: TypeAlias = RuleVariation_1377

    @classmethod
    def create(cls, arg : "NonSpare_1557.cv_arg") -> "NonSpare_1557":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1377:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1455:
        return self.rule.variation

class UapItem_542(UapItem):
    cv_non_spare: TypeAlias = NonSpare_1557

class Record_13(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_33.cv_arg,
        "000": NonSpare_2.cv_arg,
        "015": NonSpare_57.cv_arg,
        "020": NonSpare_92.cv_arg,
        "040": NonSpare_134.cv_arg,
        "045": NonSpare_161.cv_arg,
        "060": NonSpare_192.cv_arg,
        "030": NonSpare_112.cv_arg,
        "170": NonSpare_365.cv_arg,
        "120": NonSpare_293.cv_arg,
        "070": NonSpare_200.cv_arg,
        "076": NonSpare_226.cv_arg,
        "074": NonSpare_221.cv_arg,
        "075": NonSpare_224.cv_arg,
        "100": NonSpare_263.cv_arg,
        "035": NonSpare_128.cv_arg,
        "171": NonSpare_377.cv_arg,
        "110": NonSpare_282.cv_arg,
        "RE": NonSpare_1557.cv_arg,
        "SP": NonSpare_1721.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 3
    cv_items_list = [UapItem_33, UapItem_2, UapItem_57, UapItem_92, UapItem_134, UapItem_161, UapItem_192, UapItem_112, UapItem_365, UapItem_293, UapItem_200, UapItem_226, UapItem_221, UapItem_224, UapItem_263, UapItem_128, UapItem_377, UapItem_282, UapItem_544, UapItem_542, UapItem_543]
    cv_items_dict = {"010": NonSpare_33, "000": NonSpare_2, "015": NonSpare_57, "020": NonSpare_92, "040": NonSpare_134, "045": NonSpare_161, "060": NonSpare_192, "030": NonSpare_112, "170": NonSpare_365, "120": NonSpare_293, "070": NonSpare_200, "076": NonSpare_226, "074": NonSpare_221, "075": NonSpare_224, "100": NonSpare_263, "035": NonSpare_128, "171": NonSpare_377, "110": NonSpare_282, "RE": NonSpare_1557, "SP": NonSpare_1721}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_33:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> NonSpare_2:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["015"]) -> NonSpare_57:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_92:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> NonSpare_134:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["045"]) -> NonSpare_161:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_192:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> NonSpare_112:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["170"]) -> NonSpare_365:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> NonSpare_293:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> NonSpare_200:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["076"]) -> NonSpare_226:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["074"]) -> NonSpare_221:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["075"]) -> NonSpare_224:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_263:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["035"]) -> NonSpare_128:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["171"]) -> NonSpare_377:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["110"]) -> NonSpare_282:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["RE"]) -> NonSpare_1557:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1721:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["015"], Literal["020"], Literal["040"], Literal["045"], Literal["060"], Literal["030"], Literal["170"], Literal["120"], Literal["070"], Literal["076"], Literal["074"], Literal["075"], Literal["100"], Literal["035"], Literal["171"], Literal["110"], Literal["RE"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_33]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_2]:
        ...
    @overload
    def get_item(self, key : Literal["015"]) -> Optional[NonSpare_57]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_92]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_134]:
        ...
    @overload
    def get_item(self, key : Literal["045"]) -> Optional[NonSpare_161]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_192]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_112]:
        ...
    @overload
    def get_item(self, key : Literal["170"]) -> Optional[NonSpare_365]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_293]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_200]:
        ...
    @overload
    def get_item(self, key : Literal["076"]) -> Optional[NonSpare_226]:
        ...
    @overload
    def get_item(self, key : Literal["074"]) -> Optional[NonSpare_221]:
        ...
    @overload
    def get_item(self, key : Literal["075"]) -> Optional[NonSpare_224]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_263]:
        ...
    @overload
    def get_item(self, key : Literal["035"]) -> Optional[NonSpare_128]:
        ...
    @overload
    def get_item(self, key : Literal["171"]) -> Optional[NonSpare_377]:
        ...
    @overload
    def get_item(self, key : Literal["110"]) -> Optional[NonSpare_282]:
        ...
    @overload
    def get_item(self, key : Literal["RE"]) -> Optional[NonSpare_1557]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1721]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_33.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_2.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["015"], val : NonSpare_57.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_92.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_134.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["045"], val : NonSpare_161.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_192.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_112.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["170"], val : NonSpare_365.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_293.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_200.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["076"], val : NonSpare_226.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["074"], val : NonSpare_221.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["075"], val : NonSpare_224.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_263.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["035"], val : NonSpare_128.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["171"], val : NonSpare_377.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["110"], val : NonSpare_282.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["RE"], val : NonSpare_1557.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1721.cv_arg) -> 'Record_13':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["015"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["045"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["170"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["076"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["074"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["075"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["035"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["171"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["110"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["RE"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_13':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Record_13.cv_arg") -> 'Record_13':
        return cls._create(arg) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_13", Bits]]:
        return cls._parse(bs) # type: ignore

class Uap_13(UapSingle):
    cv_arg: TypeAlias = Record_13
    cv_record: TypeAlias = Record_13

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_13]]:
        return cls._parse(bs)

class Asterix_6(AstCat):
    cv_category = 4
    cv_edition = (1, 12)
    cv_uap: TypeAlias = Uap_13
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_13.cv_arg]) -> "Asterix_6":
        return cls._create(records) # type: ignore

class Content_589(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Polar vector", 2: "Cartesian vector of start point/length", 3: "Contour record", 4: "Cartesian start point and end point vector", 254: "SOP message", 255: "EOP message"}

class RuleContent_589(RuleContentContextFree):
    cv_arg: TypeAlias = Content_589.cv_arg
    cv_content: TypeAlias = Content_589

    @property
    def content(self) -> Content_589:
        return self._get_content() # type: ignore

class Variation_190(Element):
    cv_arg: TypeAlias = RuleContent_589.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_589

    @classmethod
    def create(cls, arg: "Variation_190.cv_arg") -> "Variation_190":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_589:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_589:
        return self.rule.content

class RuleVariation_183(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_190.cv_arg
    cv_variation: TypeAlias = Variation_190

    @classmethod
    def create(cls, arg : "RuleVariation_183.cv_arg") -> "RuleVariation_183":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_190:
        return self.arg # type: ignore

class NonSpare_7(NonSpare):
    cv_arg: TypeAlias = RuleVariation_183.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_183

    @classmethod
    def create(cls, arg : "NonSpare_7.cv_arg") -> "NonSpare_7":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_183:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_190:
        return self.rule.variation

class UapItem_7(UapItem):
    cv_non_spare: TypeAlias = NonSpare_7

class Content_257(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Local Coordinates", 1: "System Coordinates"}

class RuleContent_257(RuleContentContextFree):
    cv_arg: TypeAlias = Content_257.cv_arg
    cv_content: TypeAlias = Content_257

    @property
    def content(self) -> Content_257:
        return self._get_content() # type: ignore

class Variation_51(Element):
    cv_arg: TypeAlias = RuleContent_257.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_257

    @classmethod
    def create(cls, arg: "Variation_51.cv_arg") -> "Variation_51":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_257:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_257:
        return self.rule.content

class RuleVariation_51(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_51.cv_arg
    cv_variation: TypeAlias = Variation_51

    @classmethod
    def create(cls, arg : "RuleVariation_51.cv_arg") -> "RuleVariation_51":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_51:
        return self.arg # type: ignore

class Variation_485(Element):
    cv_arg: TypeAlias = RuleContent_610.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 3
    cv_rule = RuleContent_610

    @classmethod
    def create(cls, arg: "Variation_485.cv_arg") -> "Variation_485":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_610:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_610:
        return self.rule.content

class RuleVariation_474(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_485.cv_arg
    cv_variation: TypeAlias = Variation_485

    @classmethod
    def create(cls, arg : "RuleVariation_474.cv_arg") -> "RuleVariation_474":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_485:
        return self.arg # type: ignore

class Content_2(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "0°", 1: "22.5°", 2: "45°", 3: "67.5°", 4: "90°", 5: "112.5°", 6: "135°", 7: "157.5°"}

class RuleContent_2(RuleContentContextFree):
    cv_arg: TypeAlias = Content_2.cv_arg
    cv_content: TypeAlias = Content_2

    @property
    def content(self) -> Content_2:
        return self._get_content() # type: ignore

class Variation_772(Element):
    cv_arg: TypeAlias = RuleContent_2.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_2

    @classmethod
    def create(cls, arg: "Variation_772.cv_arg") -> "Variation_772":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_2:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_2:
        return self.rule.content

class RuleVariation_761(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_772.cv_arg
    cv_variation: TypeAlias = Variation_772

    @classmethod
    def create(cls, arg : "RuleVariation_761.cv_arg") -> "RuleVariation_761":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_772:
        return self.arg # type: ignore

class Content_156(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Test vector"}

class RuleContent_156(RuleContentContextFree):
    cv_arg: TypeAlias = Content_156.cv_arg
    cv_content: TypeAlias = Content_156

    @property
    def content(self) -> Content_156:
        return self._get_content() # type: ignore

class Variation_837(Element):
    cv_arg: TypeAlias = RuleContent_156.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_156

    @classmethod
    def create(cls, arg: "Variation_837.cv_arg") -> "Variation_837":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_156:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_156:
        return self.rule.content

class RuleVariation_807(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_837.cv_arg
    cv_variation: TypeAlias = Variation_837

    @classmethod
    def create(cls, arg : "RuleVariation_807.cv_arg") -> "RuleVariation_807":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_837:
        return self.arg # type: ignore

class Content_95(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Error condition encountered"}

class RuleContent_95(RuleContentContextFree):
    cv_arg: TypeAlias = Content_95.cv_arg
    cv_content: TypeAlias = Content_95

    @property
    def content(self) -> Content_95:
        return self._get_content() # type: ignore

class Variation_908(Element):
    cv_arg: TypeAlias = RuleContent_95.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_95

    @classmethod
    def create(cls, arg: "Variation_908.cv_arg") -> "Variation_908":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_95:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_95:
        return self.rule.content

class RuleVariation_878(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_908.cv_arg
    cv_variation: TypeAlias = Variation_908

    @classmethod
    def create(cls, arg : "RuleVariation_878.cv_arg") -> "RuleVariation_878":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_908:
        return self.arg # type: ignore

class NonSpare_1391(NonSpare):
    cv_arg: TypeAlias = RuleVariation_51.cv_arg
    cv_name = "ORG"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_51

    @classmethod
    def create(cls, arg : "NonSpare_1391.cv_arg") -> "NonSpare_1391":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_51:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_51:
        return self.rule.variation

class Item_656(Item):
    cv_arg: TypeAlias = NonSpare_1391.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1391

    @classmethod
    def create(cls, arg : "Item_656.cv_arg") -> "Item_656":
        return cls._create(arg) # type: ignore

class NonSpare_1079(NonSpare):
    cv_arg: TypeAlias = RuleVariation_474.cv_arg
    cv_name = "I"
    cv_title = "Intensity Level"
    cv_rule: TypeAlias = RuleVariation_474

    @classmethod
    def create(cls, arg : "NonSpare_1079.cv_arg") -> "NonSpare_1079":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_474:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_485:
        return self.rule.variation

class Item_407(Item):
    cv_arg: TypeAlias = NonSpare_1079.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1079

    @classmethod
    def create(cls, arg : "Item_407.cv_arg") -> "Item_407":
        return cls._create(arg) # type: ignore

class NonSpare_1636(NonSpare):
    cv_arg: TypeAlias = RuleVariation_761.cv_arg
    cv_name = "S"
    cv_title = "Shading Orientation with Respect to North"
    cv_rule: TypeAlias = RuleVariation_761

    @classmethod
    def create(cls, arg : "NonSpare_1636.cv_arg") -> "NonSpare_1636":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_761:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_772:
        return self.rule.variation

class Item_845(Item):
    cv_arg: TypeAlias = NonSpare_1636.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1636

    @classmethod
    def create(cls, arg : "Item_845.cv_arg") -> "Item_845":
        return cls._create(arg) # type: ignore

class NonSpare_1925(NonSpare):
    cv_arg: TypeAlias = RuleVariation_807.cv_arg
    cv_name = "TST"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_807

    @classmethod
    def create(cls, arg : "NonSpare_1925.cv_arg") -> "NonSpare_1925":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_807:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_837:
        return self.rule.variation

class Item_1048(Item):
    cv_arg: TypeAlias = NonSpare_1925.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1925

    @classmethod
    def create(cls, arg : "Item_1048.cv_arg") -> "Item_1048":
        return cls._create(arg) # type: ignore

class NonSpare_948(NonSpare):
    cv_arg: TypeAlias = RuleVariation_878.cv_arg
    cv_name = "ER"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_878

    @classmethod
    def create(cls, arg : "NonSpare_948.cv_arg") -> "NonSpare_948":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_878:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_908:
        return self.rule.variation

class Item_315(Item):
    cv_arg: TypeAlias = NonSpare_948.cv_arg
    cv_non_spare: TypeAlias = NonSpare_948

    @classmethod
    def create(cls, arg : "Item_315.cv_arg") -> "Item_315":
        return cls._create(arg) # type: ignore

class Variation_1371(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_51.cv_arg, Tuple[Literal["ORG"], RuleVariation_51.cv_arg]], Union[RuleVariation_474.cv_arg, Tuple[Literal["I"], RuleVariation_474.cv_arg]], Union[RuleVariation_761.cv_arg, Tuple[Literal["S"], RuleVariation_761.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[int, Union[RuleVariation_807.cv_arg, Tuple[Literal["TST"], RuleVariation_807.cv_arg]], Union[RuleVariation_878.cv_arg, Tuple[Literal["ER"], RuleVariation_878.cv_arg]], None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1371.cv_arg_group_1"],
        Tuple["Variation_1371.cv_arg_group_1", "Variation_1371.cv_arg_group_2"],
    ]
    cv_items_list = [[(Item_656, 1), (Item_407, 3), (Item_845, 3), None], [(Item_4, 5), (Item_1048, 1), (Item_315, 1), None]]

    @classmethod
    def create(cls, arg: "Variation_1371.cv_arg") -> 'Variation_1371':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["ORG"]) -> RuleVariation_51:
        ...
    @overload
    def get_item(self, key : Literal["I"]) -> RuleVariation_474:
        ...
    @overload
    def get_item(self, key : Literal["S"]) -> RuleVariation_761:
        ...
    @overload
    def get_item(self, key : Literal["TST"]) -> Optional[RuleVariation_807]:
        ...
    @overload
    def get_item(self, key : Literal["ER"]) -> Optional[RuleVariation_878]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1293(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1371.cv_arg
    cv_variation: TypeAlias = Variation_1371

    @classmethod
    def create(cls, arg : "RuleVariation_1293.cv_arg") -> "RuleVariation_1293":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1371:
        return self.arg # type: ignore

class NonSpare_94(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1293.cv_arg
    cv_name = "020"
    cv_title = "Vector Qualifier"
    cv_rule: TypeAlias = RuleVariation_1293

    @classmethod
    def create(cls, arg : "NonSpare_94.cv_arg") -> "NonSpare_94":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1293:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1371:
        return self.rule.variation

class UapItem_94(UapItem):
    cv_non_spare: TypeAlias = NonSpare_94

class Content_609(ContentInteger):
    cv_arg: TypeAlias = int
    cv_signedness: TypeAlias = Signed

class RuleContent_609(RuleContentContextFree):
    cv_arg: TypeAlias = Content_609.cv_arg
    cv_content: TypeAlias = Content_609

    @property
    def content(self) -> Content_609:
        return self._get_content() # type: ignore

class Variation_202(Element):
    cv_arg: TypeAlias = RuleContent_609.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_609

    @classmethod
    def create(cls, arg: "Variation_202.cv_arg") -> "Variation_202":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_609:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_609:
        return self.rule.content

class RuleVariation_195(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_202.cv_arg
    cv_variation: TypeAlias = Variation_202

    @classmethod
    def create(cls, arg : "RuleVariation_195.cv_arg") -> "RuleVariation_195":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_202:
        return self.arg # type: ignore

class NonSpare_2085(NonSpare):
    cv_arg: TypeAlias = RuleVariation_195.cv_arg
    cv_name = "X"
    cv_title = "X-Component"
    cv_rule: TypeAlias = RuleVariation_195

    @classmethod
    def create(cls, arg : "NonSpare_2085.cv_arg") -> "NonSpare_2085":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_195:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_202:
        return self.rule.variation

class Item_1192(Item):
    cv_arg: TypeAlias = NonSpare_2085.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2085

    @classmethod
    def create(cls, arg : "Item_1192.cv_arg") -> "Item_1192":
        return cls._create(arg) # type: ignore

class NonSpare_2139(NonSpare):
    cv_arg: TypeAlias = RuleVariation_195.cv_arg
    cv_name = "Y"
    cv_title = "Y-Component"
    cv_rule: TypeAlias = RuleVariation_195

    @classmethod
    def create(cls, arg : "NonSpare_2139.cv_arg") -> "NonSpare_2139":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_195:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_202:
        return self.rule.variation

class Item_1243(Item):
    cv_arg: TypeAlias = NonSpare_2139.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2139

    @classmethod
    def create(cls, arg : "Item_1243.cv_arg") -> "Item_1243":
        return cls._create(arg) # type: ignore

class Variation_203(Element):
    cv_arg: TypeAlias = RuleContent_610.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_610

    @classmethod
    def create(cls, arg: "Variation_203.cv_arg") -> "Variation_203":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_610:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_610:
        return self.rule.content

class RuleVariation_196(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_203.cv_arg
    cv_variation: TypeAlias = Variation_203

    @classmethod
    def create(cls, arg : "RuleVariation_196.cv_arg") -> "RuleVariation_196":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_203:
        return self.arg # type: ignore

class NonSpare_1161(NonSpare):
    cv_arg: TypeAlias = RuleVariation_196.cv_arg
    cv_name = "LENGTH"
    cv_title = "Length"
    cv_rule: TypeAlias = RuleVariation_196

    @classmethod
    def create(cls, arg : "NonSpare_1161.cv_arg") -> "NonSpare_1161":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_196:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_203:
        return self.rule.variation

class Item_477(Item):
    cv_arg: TypeAlias = NonSpare_1161.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1161

    @classmethod
    def create(cls, arg : "Item_477.cv_arg") -> "Item_477":
        return cls._create(arg) # type: ignore

class Variation_1305(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_195.cv_arg, Tuple[Literal["X"], RuleVariation_195.cv_arg]], Union[RuleVariation_195.cv_arg, Tuple[Literal["Y"], RuleVariation_195.cv_arg]], Union[RuleVariation_196.cv_arg, Tuple[Literal["LENGTH"], RuleVariation_196.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1305.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_items_list = [(Item_1192, 8), (Item_1243, 8), (Item_477, 8)]
    cv_items_dict = {"X": RuleVariation_195, "Y": RuleVariation_195, "LENGTH": RuleVariation_196}

    @overload
    @classmethod
    def spec(cls, key : Literal["X"]) -> RuleVariation_195:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y"]) -> RuleVariation_195:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["LENGTH"]) -> RuleVariation_196:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X"], Literal["Y"], Literal["LENGTH"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X"]) -> RuleVariation_195:
        ...
    @overload
    def get_item(self, key : Literal["Y"]) -> RuleVariation_195:
        ...
    @overload
    def get_item(self, key : Literal["LENGTH"]) -> RuleVariation_196:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1305.cv_arg") -> 'Variation_1305':
        return cls._create(arg) # type: ignore

class Variation_1442(Repetitive):
    cv_arg: TypeAlias = List[Variation_1305.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1305

    @classmethod
    def create(cls, arg: "Variation_1442.cv_arg") -> 'Variation_1442':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1305]:
        return self._get_list() # type: ignore

class RuleVariation_1364(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1442.cv_arg
    cv_variation: TypeAlias = Variation_1442

    @classmethod
    def create(cls, arg : "RuleVariation_1364.cv_arg") -> "RuleVariation_1364":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1442:
        return self.arg # type: ignore

class NonSpare_131(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1364.cv_arg
    cv_name = "036"
    cv_title = "Sequence of Cartesian Vectors in SPF Notation"
    cv_rule: TypeAlias = RuleVariation_1364

    @classmethod
    def create(cls, arg : "NonSpare_131.cv_arg") -> "NonSpare_131":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1364:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1442:
        return self.rule.variation

class UapItem_131(UapItem):
    cv_non_spare: TypeAlias = NonSpare_131

class NonSpare_1786(NonSpare):
    cv_arg: TypeAlias = RuleVariation_196.cv_arg
    cv_name = "STR"
    cv_title = "Start Range"
    cv_rule: TypeAlias = RuleVariation_196

    @classmethod
    def create(cls, arg : "NonSpare_1786.cv_arg") -> "NonSpare_1786":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_196:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_203:
        return self.rule.variation

class Item_952(Item):
    cv_arg: TypeAlias = NonSpare_1786.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1786

    @classmethod
    def create(cls, arg : "Item_952.cv_arg") -> "Item_952":
        return cls._create(arg) # type: ignore

class NonSpare_927(NonSpare):
    cv_arg: TypeAlias = RuleVariation_196.cv_arg
    cv_name = "ENDR"
    cv_title = "End Range"
    cv_rule: TypeAlias = RuleVariation_196

    @classmethod
    def create(cls, arg : "NonSpare_927.cv_arg") -> "NonSpare_927":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_196:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_203:
        return self.rule.variation

class Item_294(Item):
    cv_arg: TypeAlias = NonSpare_927.cv_arg
    cv_non_spare: TypeAlias = NonSpare_927

    @classmethod
    def create(cls, arg : "Item_294.cv_arg") -> "Item_294":
        return cls._create(arg) # type: ignore

class NonSpare_657(NonSpare):
    cv_arg: TypeAlias = RuleVariation_334.cv_arg
    cv_name = "AZ"
    cv_title = "Azimuth"
    cv_rule: TypeAlias = RuleVariation_334

    @classmethod
    def create(cls, arg : "NonSpare_657.cv_arg") -> "NonSpare_657":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_334:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_341:
        return self.rule.variation

class Item_105(Item):
    cv_arg: TypeAlias = NonSpare_657.cv_arg
    cv_non_spare: TypeAlias = NonSpare_657

    @classmethod
    def create(cls, arg : "Item_105.cv_arg") -> "Item_105":
        return cls._create(arg) # type: ignore

class Variation_1214(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_196.cv_arg, Tuple[Literal["STR"], RuleVariation_196.cv_arg]], Union[RuleVariation_196.cv_arg, Tuple[Literal["ENDR"], RuleVariation_196.cv_arg]], Union[RuleVariation_334.cv_arg, Tuple[Literal["AZ"], RuleVariation_334.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1214.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_952, 8), (Item_294, 8), (Item_105, 16)]
    cv_items_dict = {"STR": RuleVariation_196, "ENDR": RuleVariation_196, "AZ": RuleVariation_334}

    @overload
    @classmethod
    def spec(cls, key : Literal["STR"]) -> RuleVariation_196:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ENDR"]) -> RuleVariation_196:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AZ"]) -> RuleVariation_334:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["STR"], Literal["ENDR"], Literal["AZ"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["STR"]) -> RuleVariation_196:
        ...
    @overload
    def get_item(self, key : Literal["ENDR"]) -> RuleVariation_196:
        ...
    @overload
    def get_item(self, key : Literal["AZ"]) -> RuleVariation_334:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1214.cv_arg") -> 'Variation_1214':
        return cls._create(arg) # type: ignore

class Variation_1426(Repetitive):
    cv_arg: TypeAlias = List[Variation_1214.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1214

    @classmethod
    def create(cls, arg: "Variation_1426.cv_arg") -> 'Variation_1426':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1214]:
        return self._get_list() # type: ignore

class RuleVariation_1348(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1426.cv_arg
    cv_variation: TypeAlias = Variation_1426

    @classmethod
    def create(cls, arg : "RuleVariation_1348.cv_arg") -> "RuleVariation_1348":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1426:
        return self.arg # type: ignore

class NonSpare_126(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1348.cv_arg
    cv_name = "034"
    cv_title = "Sequence of Polar Vectors in SPF Notation"
    cv_rule: TypeAlias = RuleVariation_1348

    @classmethod
    def create(cls, arg : "NonSpare_126.cv_arg") -> "NonSpare_126":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1348:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1426:
        return self.rule.variation

class UapItem_126(UapItem):
    cv_non_spare: TypeAlias = NonSpare_126

class Variation_480(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 3
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_480.cv_arg") -> "Variation_480":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_469(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_480.cv_arg
    cv_variation: TypeAlias = Variation_480

    @classmethod
    def create(cls, arg : "RuleVariation_469.cv_arg") -> "RuleVariation_469":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_480:
        return self.arg # type: ignore

class NonSpare_1078(NonSpare):
    cv_arg: TypeAlias = RuleVariation_469.cv_arg
    cv_name = "I"
    cv_title = "Intensity Level"
    cv_rule: TypeAlias = RuleVariation_469

    @classmethod
    def create(cls, arg : "NonSpare_1078.cv_arg") -> "NonSpare_1078":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_469:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_480:
        return self.rule.variation

class Item_406(Item):
    cv_arg: TypeAlias = NonSpare_1078.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1078

    @classmethod
    def create(cls, arg : "Item_406.cv_arg") -> "Item_406":
        return cls._create(arg) # type: ignore

class Item_20(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 4
    cv_bit_size = 2

class Content_245(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Intermediate record of a contour", 1: "Last record of a contour of at least two records", 2: "First record of a contour of at least two records", 3: "First and only record, fully defining a contour"}

class RuleContent_245(RuleContentContextFree):
    cv_arg: TypeAlias = Content_245.cv_arg
    cv_content: TypeAlias = Content_245

    @property
    def content(self) -> Content_245:
        return self._get_content() # type: ignore

class Variation_958(Element):
    cv_arg: TypeAlias = RuleContent_245.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 2
    cv_rule = RuleContent_245

    @classmethod
    def create(cls, arg: "Variation_958.cv_arg") -> "Variation_958":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_245:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_245:
        return self.rule.content

class RuleVariation_928(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_958.cv_arg
    cv_variation: TypeAlias = Variation_958

    @classmethod
    def create(cls, arg : "RuleVariation_928.cv_arg") -> "RuleVariation_928":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_958:
        return self.arg # type: ignore

class NonSpare_996(NonSpare):
    cv_arg: TypeAlias = RuleVariation_928.cv_arg
    cv_name = "FSTLST"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_928

    @classmethod
    def create(cls, arg : "NonSpare_996.cv_arg") -> "NonSpare_996":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_928:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_958:
        return self.rule.variation

class Item_348(Item):
    cv_arg: TypeAlias = NonSpare_996.cv_arg
    cv_non_spare: TypeAlias = NonSpare_996

    @classmethod
    def create(cls, arg : "Item_348.cv_arg") -> "Item_348":
        return cls._create(arg) # type: ignore

class NonSpare_828(NonSpare):
    cv_arg: TypeAlias = RuleVariation_158.cv_arg
    cv_name = "CSN"
    cv_title = "Contour Serial Number"
    cv_rule: TypeAlias = RuleVariation_158

    @classmethod
    def create(cls, arg : "NonSpare_828.cv_arg") -> "NonSpare_828":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_158:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_164:
        return self.rule.variation

class Item_218(Item):
    cv_arg: TypeAlias = NonSpare_828.cv_arg
    cv_non_spare: TypeAlias = NonSpare_828

    @classmethod
    def create(cls, arg : "Item_218.cv_arg") -> "Item_218":
        return cls._create(arg) # type: ignore

class Variation_1151(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_51.cv_arg, Tuple[Literal["ORG"], RuleVariation_51.cv_arg]], Union[RuleVariation_469.cv_arg, Tuple[Literal["I"], RuleVariation_469.cv_arg]], int, Union[RuleVariation_928.cv_arg, Tuple[Literal["FSTLST"], RuleVariation_928.cv_arg]], Union[RuleVariation_158.cv_arg, Tuple[Literal["CSN"], RuleVariation_158.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1151.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_656, 1), (Item_406, 3), (Item_20, 2), (Item_348, 2), (Item_218, 8)]
    cv_items_dict = {"ORG": RuleVariation_51, "I": RuleVariation_469, "FSTLST": RuleVariation_928, "CSN": RuleVariation_158}

    @overload
    @classmethod
    def spec(cls, key : Literal["ORG"]) -> RuleVariation_51:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["I"]) -> RuleVariation_469:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["FSTLST"]) -> RuleVariation_928:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CSN"]) -> RuleVariation_158:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["ORG"], Literal["I"], Literal["FSTLST"], Literal["CSN"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["ORG"]) -> RuleVariation_51:
        ...
    @overload
    def get_item(self, key : Literal["I"]) -> RuleVariation_469:
        ...
    @overload
    def get_item(self, key : Literal["FSTLST"]) -> RuleVariation_928:
        ...
    @overload
    def get_item(self, key : Literal["CSN"]) -> RuleVariation_158:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1151.cv_arg") -> 'Variation_1151':
        return cls._create(arg) # type: ignore

class RuleVariation_1104(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1151.cv_arg
    cv_variation: TypeAlias = Variation_1151

    @classmethod
    def create(cls, arg : "RuleVariation_1104.cv_arg") -> "RuleVariation_1104":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1151:
        return self.arg # type: ignore

class NonSpare_135(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1104.cv_arg
    cv_name = "040"
    cv_title = "Contour Identifier"
    cv_rule: TypeAlias = RuleVariation_1104

    @classmethod
    def create(cls, arg : "NonSpare_135.cv_arg") -> "NonSpare_135":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1104:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1151:
        return self.rule.variation

class UapItem_135(UapItem):
    cv_non_spare: TypeAlias = NonSpare_135

class NonSpare_2092(NonSpare):
    cv_arg: TypeAlias = RuleVariation_195.cv_arg
    cv_name = "X1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_195

    @classmethod
    def create(cls, arg : "NonSpare_2092.cv_arg") -> "NonSpare_2092":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_195:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_202:
        return self.rule.variation

class Item_1199(Item):
    cv_arg: TypeAlias = NonSpare_2092.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2092

    @classmethod
    def create(cls, arg : "Item_1199.cv_arg") -> "Item_1199":
        return cls._create(arg) # type: ignore

class NonSpare_2146(NonSpare):
    cv_arg: TypeAlias = RuleVariation_195.cv_arg
    cv_name = "Y1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_195

    @classmethod
    def create(cls, arg : "NonSpare_2146.cv_arg") -> "NonSpare_2146":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_195:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_202:
        return self.rule.variation

class Item_1250(Item):
    cv_arg: TypeAlias = NonSpare_2146.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2146

    @classmethod
    def create(cls, arg : "Item_1250.cv_arg") -> "Item_1250":
        return cls._create(arg) # type: ignore

class Variation_1312(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_195.cv_arg, Tuple[Literal["X1"], RuleVariation_195.cv_arg]], Union[RuleVariation_195.cv_arg, Tuple[Literal["Y1"], RuleVariation_195.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1312.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_1199, 8), (Item_1250, 8)]
    cv_items_dict = {"X1": RuleVariation_195, "Y1": RuleVariation_195}

    @overload
    @classmethod
    def spec(cls, key : Literal["X1"]) -> RuleVariation_195:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y1"]) -> RuleVariation_195:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X1"], Literal["Y1"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X1"]) -> RuleVariation_195:
        ...
    @overload
    def get_item(self, key : Literal["Y1"]) -> RuleVariation_195:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1312.cv_arg") -> 'Variation_1312':
        return cls._create(arg) # type: ignore

class Variation_1444(Repetitive):
    cv_arg: TypeAlias = List[Variation_1312.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1312

    @classmethod
    def create(cls, arg: "Variation_1444.cv_arg") -> 'Variation_1444':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1312]:
        return self._get_list() # type: ignore

class RuleVariation_1366(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1444.cv_arg
    cv_variation: TypeAlias = Variation_1444

    @classmethod
    def create(cls, arg : "RuleVariation_1366.cv_arg") -> "RuleVariation_1366":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1444:
        return self.arg # type: ignore

class NonSpare_175(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1366.cv_arg
    cv_name = "050"
    cv_title = "Sequence of Contour Points in SPF Notation"
    cv_rule: TypeAlias = RuleVariation_1366

    @classmethod
    def create(cls, arg : "NonSpare_175.cv_arg") -> "NonSpare_175":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1366:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1444:
        return self.rule.variation

class UapItem_175(UapItem):
    cv_non_spare: TypeAlias = NonSpare_175

class NonSpare_255(NonSpare):
    cv_arg: TypeAlias = RuleVariation_361.cv_arg
    cv_name = "090"
    cv_title = "Time of Day"
    cv_rule: TypeAlias = RuleVariation_361

    @classmethod
    def create(cls, arg : "NonSpare_255.cv_arg") -> "NonSpare_255":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_361:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_368:
        return self.rule.variation

class UapItem_255(UapItem):
    cv_non_spare: TypeAlias = NonSpare_255

class Variation_145(Element):
    cv_arg: TypeAlias = RuleContent_609.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 5
    cv_rule = RuleContent_609

    @classmethod
    def create(cls, arg: "Variation_145.cv_arg") -> "Variation_145":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_609:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_609:
        return self.rule.content

class RuleVariation_145(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_145.cv_arg
    cv_variation: TypeAlias = Variation_145

    @classmethod
    def create(cls, arg : "RuleVariation_145.cv_arg") -> "RuleVariation_145":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_145:
        return self.arg # type: ignore

class Variation_886(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 3
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_886.cv_arg") -> "Variation_886":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_856(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_886.cv_arg
    cv_variation: TypeAlias = Variation_886

    @classmethod
    def create(cls, arg : "RuleVariation_856.cv_arg") -> "RuleVariation_856":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_886:
        return self.arg # type: ignore

class Variation_249(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 15
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_249.cv_arg") -> "Variation_249":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_242(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_249.cv_arg
    cv_variation: TypeAlias = Variation_249

    @classmethod
    def create(cls, arg : "RuleVariation_242.cv_arg") -> "RuleVariation_242":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_249:
        return self.arg # type: ignore

class NonSpare_960(NonSpare):
    cv_arg: TypeAlias = RuleVariation_145.cv_arg
    cv_name = "F"
    cv_title = "Scaling Factor"
    cv_rule: TypeAlias = RuleVariation_145

    @classmethod
    def create(cls, arg : "NonSpare_960.cv_arg") -> "NonSpare_960":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_145:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_145:
        return self.rule.variation

class Item_324(Item):
    cv_arg: TypeAlias = NonSpare_960.cv_arg
    cv_non_spare: TypeAlias = NonSpare_960

    @classmethod
    def create(cls, arg : "Item_324.cv_arg") -> "Item_324":
        return cls._create(arg) # type: ignore

class NonSpare_1520(NonSpare):
    cv_arg: TypeAlias = RuleVariation_856.cv_arg
    cv_name = "R"
    cv_title = "Current Reduction Stage in Use"
    cv_rule: TypeAlias = RuleVariation_856

    @classmethod
    def create(cls, arg : "NonSpare_1520.cv_arg") -> "NonSpare_1520":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_856:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_886:
        return self.rule.variation

class Item_758(Item):
    cv_arg: TypeAlias = NonSpare_1520.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1520

    @classmethod
    def create(cls, arg : "Item_758.cv_arg") -> "Item_758":
        return cls._create(arg) # type: ignore

class NonSpare_1476(NonSpare):
    cv_arg: TypeAlias = RuleVariation_242.cv_arg
    cv_name = "Q"
    cv_title = "Processing Parameters"
    cv_rule: TypeAlias = RuleVariation_242

    @classmethod
    def create(cls, arg : "NonSpare_1476.cv_arg") -> "NonSpare_1476":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_242:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_249:
        return self.rule.variation

class Item_715(Item):
    cv_arg: TypeAlias = NonSpare_1476.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1476

    @classmethod
    def create(cls, arg : "Item_715.cv_arg") -> "Item_715":
        return cls._create(arg) # type: ignore

class Variation_1352(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_145.cv_arg, Tuple[Literal["F"], RuleVariation_145.cv_arg]], Union[RuleVariation_856.cv_arg, Tuple[Literal["R"], RuleVariation_856.cv_arg]], Union[RuleVariation_242.cv_arg, Tuple[Literal["Q"], RuleVariation_242.cv_arg]], None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1352.cv_arg_group_1"],
    ]
    cv_items_list = [[(Item_324, 5), (Item_758, 3), (Item_715, 15), None]]

    @classmethod
    def create(cls, arg: "Variation_1352.cv_arg") -> 'Variation_1352':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["F"]) -> RuleVariation_145:
        ...
    @overload
    def get_item(self, key : Literal["R"]) -> RuleVariation_856:
        ...
    @overload
    def get_item(self, key : Literal["Q"]) -> RuleVariation_242:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1274(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1352.cv_arg
    cv_variation: TypeAlias = Variation_1352

    @classmethod
    def create(cls, arg : "RuleVariation_1274.cv_arg") -> "RuleVariation_1274":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1352:
        return self.arg # type: ignore

class NonSpare_271(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1274.cv_arg
    cv_name = "100"
    cv_title = "Processing Status"
    cv_rule: TypeAlias = RuleVariation_1274

    @classmethod
    def create(cls, arg : "NonSpare_271.cv_arg") -> "NonSpare_271":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1274:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1352:
        return self.rule.variation

class UapItem_271(UapItem):
    cv_non_spare: TypeAlias = NonSpare_271

class NonSpare_287(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1368.cv_arg
    cv_name = "110"
    cv_title = "Station Configuration Status"
    cv_rule: TypeAlias = RuleVariation_1368

    @classmethod
    def create(cls, arg : "NonSpare_287.cv_arg") -> "NonSpare_287":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1368:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1446:
        return self.rule.variation

class UapItem_287(UapItem):
    cv_non_spare: TypeAlias = NonSpare_287

class Variation_254(Element):
    cv_arg: TypeAlias = RuleContent_610.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_610

    @classmethod
    def create(cls, arg: "Variation_254.cv_arg") -> "Variation_254":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_610:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_610:
        return self.rule.content

class RuleVariation_247(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_254.cv_arg
    cv_variation: TypeAlias = Variation_254

    @classmethod
    def create(cls, arg : "RuleVariation_247.cv_arg") -> "RuleVariation_247":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_254:
        return self.arg # type: ignore

class NonSpare_299(NonSpare):
    cv_arg: TypeAlias = RuleVariation_247.cv_arg
    cv_name = "120"
    cv_title = "Total Number of Items Constituting One Weather Picture"
    cv_rule: TypeAlias = RuleVariation_247

    @classmethod
    def create(cls, arg : "NonSpare_299.cv_arg") -> "NonSpare_299":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_247:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_254:
        return self.rule.variation

class UapItem_299(UapItem):
    cv_non_spare: TypeAlias = NonSpare_299

class NonSpare_2094(NonSpare):
    cv_arg: TypeAlias = RuleVariation_195.cv_arg
    cv_name = "X1"
    cv_title = "X1-Component"
    cv_rule: TypeAlias = RuleVariation_195

    @classmethod
    def create(cls, arg : "NonSpare_2094.cv_arg") -> "NonSpare_2094":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_195:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_202:
        return self.rule.variation

class Item_1201(Item):
    cv_arg: TypeAlias = NonSpare_2094.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2094

    @classmethod
    def create(cls, arg : "Item_1201.cv_arg") -> "Item_1201":
        return cls._create(arg) # type: ignore

class NonSpare_2147(NonSpare):
    cv_arg: TypeAlias = RuleVariation_195.cv_arg
    cv_name = "Y1"
    cv_title = "Y1-Component"
    cv_rule: TypeAlias = RuleVariation_195

    @classmethod
    def create(cls, arg : "NonSpare_2147.cv_arg") -> "NonSpare_2147":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_195:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_202:
        return self.rule.variation

class Item_1251(Item):
    cv_arg: TypeAlias = NonSpare_2147.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2147

    @classmethod
    def create(cls, arg : "Item_1251.cv_arg") -> "Item_1251":
        return cls._create(arg) # type: ignore

class NonSpare_2098(NonSpare):
    cv_arg: TypeAlias = RuleVariation_195.cv_arg
    cv_name = "X2"
    cv_title = "X2-Component"
    cv_rule: TypeAlias = RuleVariation_195

    @classmethod
    def create(cls, arg : "NonSpare_2098.cv_arg") -> "NonSpare_2098":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_195:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_202:
        return self.rule.variation

class Item_1205(Item):
    cv_arg: TypeAlias = NonSpare_2098.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2098

    @classmethod
    def create(cls, arg : "Item_1205.cv_arg") -> "Item_1205":
        return cls._create(arg) # type: ignore

class NonSpare_2149(NonSpare):
    cv_arg: TypeAlias = RuleVariation_195.cv_arg
    cv_name = "Y2"
    cv_title = "Y2-Component"
    cv_rule: TypeAlias = RuleVariation_195

    @classmethod
    def create(cls, arg : "NonSpare_2149.cv_arg") -> "NonSpare_2149":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_195:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_202:
        return self.rule.variation

class Item_1253(Item):
    cv_arg: TypeAlias = NonSpare_2149.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2149

    @classmethod
    def create(cls, arg : "Item_1253.cv_arg") -> "Item_1253":
        return cls._create(arg) # type: ignore

class Variation_1313(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_195.cv_arg, Tuple[Literal["X1"], RuleVariation_195.cv_arg]], Union[RuleVariation_195.cv_arg, Tuple[Literal["Y1"], RuleVariation_195.cv_arg]], Union[RuleVariation_195.cv_arg, Tuple[Literal["X2"], RuleVariation_195.cv_arg]], Union[RuleVariation_195.cv_arg, Tuple[Literal["Y2"], RuleVariation_195.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1313.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1201, 8), (Item_1251, 8), (Item_1205, 8), (Item_1253, 8)]
    cv_items_dict = {"X1": RuleVariation_195, "Y1": RuleVariation_195, "X2": RuleVariation_195, "Y2": RuleVariation_195}

    @overload
    @classmethod
    def spec(cls, key : Literal["X1"]) -> RuleVariation_195:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y1"]) -> RuleVariation_195:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["X2"]) -> RuleVariation_195:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y2"]) -> RuleVariation_195:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X1"], Literal["Y1"], Literal["X2"], Literal["Y2"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X1"]) -> RuleVariation_195:
        ...
    @overload
    def get_item(self, key : Literal["Y1"]) -> RuleVariation_195:
        ...
    @overload
    def get_item(self, key : Literal["X2"]) -> RuleVariation_195:
        ...
    @overload
    def get_item(self, key : Literal["Y2"]) -> RuleVariation_195:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1313.cv_arg") -> 'Variation_1313':
        return cls._create(arg) # type: ignore

class Variation_1445(Repetitive):
    cv_arg: TypeAlias = List[Variation_1313.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1313

    @classmethod
    def create(cls, arg: "Variation_1445.cv_arg") -> 'Variation_1445':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1313]:
        return self._get_list() # type: ignore

class RuleVariation_1367(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1445.cv_arg
    cv_variation: TypeAlias = Variation_1445

    @classmethod
    def create(cls, arg : "RuleVariation_1367.cv_arg") -> "RuleVariation_1367":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1445:
        return self.arg # type: ignore

class NonSpare_133(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1367.cv_arg
    cv_name = "038"
    cv_title = "Sequence of Weather Vectors in SPF Notation"
    cv_rule: TypeAlias = RuleVariation_1367

    @classmethod
    def create(cls, arg : "NonSpare_133.cv_arg") -> "NonSpare_133":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1367:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1445:
        return self.rule.variation

class UapItem_133(UapItem):
    cv_non_spare: TypeAlias = NonSpare_133

class Record_19(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_36.cv_arg,
        "000": NonSpare_7.cv_arg,
        "020": NonSpare_94.cv_arg,
        "036": NonSpare_131.cv_arg,
        "034": NonSpare_126.cv_arg,
        "040": NonSpare_135.cv_arg,
        "050": NonSpare_175.cv_arg,
        "090": NonSpare_255.cv_arg,
        "100": NonSpare_271.cv_arg,
        "110": NonSpare_287.cv_arg,
        "120": NonSpare_299.cv_arg,
        "038": NonSpare_133.cv_arg,
        "SP": NonSpare_1721.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_36.cv_arg],
        Tuple[Literal["000"], NonSpare_7.cv_arg],
        Tuple[Literal["020"], NonSpare_94.cv_arg],
        Tuple[Literal["036"], NonSpare_131.cv_arg],
        Tuple[Literal["034"], NonSpare_126.cv_arg],
        Tuple[Literal["040"], NonSpare_135.cv_arg],
        Tuple[Literal["050"], NonSpare_175.cv_arg],
        Tuple[Literal["090"], NonSpare_255.cv_arg],
        Tuple[Literal["100"], NonSpare_271.cv_arg],
        Tuple[Literal["110"], NonSpare_287.cv_arg],
        Tuple[Literal["120"], NonSpare_299.cv_arg],
        Tuple[Literal["038"], NonSpare_133.cv_arg],
        Tuple[Literal["SP"], NonSpare_1721.cv_arg],
    ]
    cv_fspec_max_bytes = 2
    cv_items_list = [UapItem_36, UapItem_7, UapItem_94, UapItem_131, UapItem_126, UapItem_135, UapItem_175, UapItem_255, UapItem_271, UapItem_287, UapItem_299, UapItem_133, UapItem_543, UapItem_545]
    cv_items_dict = {"010": NonSpare_36, "000": NonSpare_7, "020": NonSpare_94, "036": NonSpare_131, "034": NonSpare_126, "040": NonSpare_135, "050": NonSpare_175, "090": NonSpare_255, "100": NonSpare_271, "110": NonSpare_287, "120": NonSpare_299, "038": NonSpare_133, "SP": NonSpare_1721}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_36:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> NonSpare_7:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_94:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["036"]) -> NonSpare_131:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["034"]) -> NonSpare_126:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> NonSpare_135:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> NonSpare_175:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> NonSpare_255:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_271:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["110"]) -> NonSpare_287:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> NonSpare_299:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["038"]) -> NonSpare_133:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1721:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["020"], Literal["036"], Literal["034"], Literal["040"], Literal["050"], Literal["090"], Literal["100"], Literal["110"], Literal["120"], Literal["038"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_36]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_7]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_94]:
        ...
    @overload
    def get_item(self, key : Literal["036"]) -> Optional[NonSpare_131]:
        ...
    @overload
    def get_item(self, key : Literal["034"]) -> Optional[NonSpare_126]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_135]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_175]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_255]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_271]:
        ...
    @overload
    def get_item(self, key : Literal["110"]) -> Optional[NonSpare_287]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_299]:
        ...
    @overload
    def get_item(self, key : Literal["038"]) -> Optional[NonSpare_133]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1721]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_36.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_7.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_94.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["036"], val : NonSpare_131.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["034"], val : NonSpare_126.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_135.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_175.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_255.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_271.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["110"], val : NonSpare_287.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_299.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["038"], val : NonSpare_133.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1721.cv_arg) -> 'Record_19':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["036"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["034"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["110"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["038"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_19':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_36]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["000"]) -> List[NonSpare_7]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_94]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["036"]) -> List[NonSpare_131]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["034"]) -> List[NonSpare_126]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["040"]) -> List[NonSpare_135]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_175]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_255]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_271]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["110"]) -> List[NonSpare_287]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["120"]) -> List[NonSpare_299]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["038"]) -> List[NonSpare_133]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1721]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_19.cv_arg", rfs : Optional[List["Record_19.cv_union"]] = None) -> 'Record_19':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_19", Bits]]:
        return cls._parse(bs) # type: ignore

class Uap_17(UapSingle):
    cv_arg: TypeAlias = Record_19
    cv_record: TypeAlias = Record_19

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_19]]:
        return cls._parse(bs)

class Asterix_7(AstCat):
    cv_category = 8
    cv_edition = (1, 2)
    cv_uap: TypeAlias = Uap_17
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_17.cv_arg]) -> "Asterix_7":
        return cls._create(records) # type: ignore

class Asterix_8(AstCat):
    cv_category = 8
    cv_edition = (1, 3)
    cv_uap: TypeAlias = Uap_17
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_17.cv_arg]) -> "Asterix_8":
        return cls._create(records) # type: ignore

class Content_602(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {2: "Cartesian vector", 253: "Intermediate-update-step message", 254: "Start-of-picture message", 255: "End-of-picture message"}

class RuleContent_602(RuleContentContextFree):
    cv_arg: TypeAlias = Content_602.cv_arg
    cv_content: TypeAlias = Content_602

    @property
    def content(self) -> Content_602:
        return self._get_content() # type: ignore

class Variation_199(Element):
    cv_arg: TypeAlias = RuleContent_602.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_602

    @classmethod
    def create(cls, arg: "Variation_199.cv_arg") -> "Variation_199":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_602:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_602:
        return self.rule.content

class RuleVariation_192(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_199.cv_arg
    cv_variation: TypeAlias = Variation_199

    @classmethod
    def create(cls, arg : "RuleVariation_192.cv_arg") -> "RuleVariation_192":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_199:
        return self.arg # type: ignore

class NonSpare_15(NonSpare):
    cv_arg: TypeAlias = RuleVariation_192.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_192

    @classmethod
    def create(cls, arg : "NonSpare_15.cv_arg") -> "NonSpare_15":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_192:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_199:
        return self.rule.variation

class UapItem_15(UapItem):
    cv_non_spare: TypeAlias = NonSpare_15

class Variation_1370(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_51.cv_arg, Tuple[Literal["ORG"], RuleVariation_51.cv_arg]], Union[RuleVariation_474.cv_arg, Tuple[Literal["I"], RuleVariation_474.cv_arg]], Union[RuleVariation_761.cv_arg, Tuple[Literal["S"], RuleVariation_761.cv_arg]], None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1370.cv_arg_group_1"],
    ]
    cv_items_list = [[(Item_656, 1), (Item_407, 3), (Item_845, 3), None]]

    @classmethod
    def create(cls, arg: "Variation_1370.cv_arg") -> 'Variation_1370':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["ORG"]) -> RuleVariation_51:
        ...
    @overload
    def get_item(self, key : Literal["I"]) -> RuleVariation_474:
        ...
    @overload
    def get_item(self, key : Literal["S"]) -> RuleVariation_761:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1292(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1370.cv_arg
    cv_variation: TypeAlias = Variation_1370

    @classmethod
    def create(cls, arg : "RuleVariation_1292.cv_arg") -> "RuleVariation_1292":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1370:
        return self.arg # type: ignore

class NonSpare_93(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1292.cv_arg
    cv_name = "020"
    cv_title = "Vector Qualifier"
    cv_rule: TypeAlias = RuleVariation_1292

    @classmethod
    def create(cls, arg : "NonSpare_93.cv_arg") -> "NonSpare_93":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1292:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1370:
        return self.rule.variation

class UapItem_93(UapItem):
    cv_non_spare: TypeAlias = NonSpare_93

class Variation_253(Element):
    cv_arg: TypeAlias = RuleContent_609.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_609

    @classmethod
    def create(cls, arg: "Variation_253.cv_arg") -> "Variation_253":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_609:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_609:
        return self.rule.content

class RuleVariation_246(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_253.cv_arg
    cv_variation: TypeAlias = Variation_253

    @classmethod
    def create(cls, arg : "RuleVariation_246.cv_arg") -> "RuleVariation_246":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_253:
        return self.arg # type: ignore

class NonSpare_2089(NonSpare):
    cv_arg: TypeAlias = RuleVariation_246.cv_arg
    cv_name = "X"
    cv_title = "X-coordinate"
    cv_rule: TypeAlias = RuleVariation_246

    @classmethod
    def create(cls, arg : "NonSpare_2089.cv_arg") -> "NonSpare_2089":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_246:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_253:
        return self.rule.variation

class Item_1196(Item):
    cv_arg: TypeAlias = NonSpare_2089.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2089

    @classmethod
    def create(cls, arg : "Item_1196.cv_arg") -> "Item_1196":
        return cls._create(arg) # type: ignore

class NonSpare_2143(NonSpare):
    cv_arg: TypeAlias = RuleVariation_246.cv_arg
    cv_name = "Y"
    cv_title = "Y-coordinate"
    cv_rule: TypeAlias = RuleVariation_246

    @classmethod
    def create(cls, arg : "NonSpare_2143.cv_arg") -> "NonSpare_2143":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_246:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_253:
        return self.rule.variation

class Item_1247(Item):
    cv_arg: TypeAlias = NonSpare_2143.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2143

    @classmethod
    def create(cls, arg : "Item_1247.cv_arg") -> "Item_1247":
        return cls._create(arg) # type: ignore

class NonSpare_1137(NonSpare):
    cv_arg: TypeAlias = RuleVariation_247.cv_arg
    cv_name = "L"
    cv_title = "Vector Length"
    cv_rule: TypeAlias = RuleVariation_247

    @classmethod
    def create(cls, arg : "NonSpare_1137.cv_arg") -> "NonSpare_1137":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_247:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_254:
        return self.rule.variation

class Item_455(Item):
    cv_arg: TypeAlias = NonSpare_1137.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1137

    @classmethod
    def create(cls, arg : "Item_455.cv_arg") -> "Item_455":
        return cls._create(arg) # type: ignore

class Variation_1310(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_246.cv_arg, Tuple[Literal["X"], RuleVariation_246.cv_arg]], Union[RuleVariation_246.cv_arg, Tuple[Literal["Y"], RuleVariation_246.cv_arg]], Union[RuleVariation_247.cv_arg, Tuple[Literal["L"], RuleVariation_247.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1310.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 48
    cv_items_list = [(Item_1196, 16), (Item_1247, 16), (Item_455, 16)]
    cv_items_dict = {"X": RuleVariation_246, "Y": RuleVariation_246, "L": RuleVariation_247}

    @overload
    @classmethod
    def spec(cls, key : Literal["X"]) -> RuleVariation_246:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y"]) -> RuleVariation_246:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["L"]) -> RuleVariation_247:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X"], Literal["Y"], Literal["L"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X"]) -> RuleVariation_246:
        ...
    @overload
    def get_item(self, key : Literal["Y"]) -> RuleVariation_246:
        ...
    @overload
    def get_item(self, key : Literal["L"]) -> RuleVariation_247:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1310.cv_arg") -> 'Variation_1310':
        return cls._create(arg) # type: ignore

class Variation_1443(Repetitive):
    cv_arg: TypeAlias = List[Variation_1310.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1310

    @classmethod
    def create(cls, arg: "Variation_1443.cv_arg") -> 'Variation_1443':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1310]:
        return self._get_list() # type: ignore

class RuleVariation_1365(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1443.cv_arg
    cv_variation: TypeAlias = Variation_1443

    @classmethod
    def create(cls, arg : "RuleVariation_1365.cv_arg") -> "RuleVariation_1365":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1443:
        return self.arg # type: ignore

class NonSpare_105(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1365.cv_arg
    cv_name = "030"
    cv_title = "Sequence of Cartesian Vectors"
    cv_rule: TypeAlias = RuleVariation_1365

    @classmethod
    def create(cls, arg : "NonSpare_105.cv_arg") -> "NonSpare_105":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1365:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1443:
        return self.rule.variation

class UapItem_105(UapItem):
    cv_non_spare: TypeAlias = NonSpare_105

class Variation_148(Element):
    cv_arg: TypeAlias = RuleContent_610.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 6
    cv_rule = RuleContent_610

    @classmethod
    def create(cls, arg: "Variation_148.cv_arg") -> "Variation_148":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_610:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_610:
        return self.rule.content

class RuleVariation_148(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_148.cv_arg
    cv_variation: TypeAlias = Variation_148

    @classmethod
    def create(cls, arg : "RuleVariation_148.cv_arg") -> "RuleVariation_148":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_148:
        return self.arg # type: ignore

class NonSpare_1718(NonSpare):
    cv_arg: TypeAlias = RuleVariation_148.cv_arg
    cv_name = "SN"
    cv_title = "Step Number"
    cv_rule: TypeAlias = RuleVariation_148

    @classmethod
    def create(cls, arg : "NonSpare_1718.cv_arg") -> "NonSpare_1718":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_148:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_148:
        return self.rule.variation

class Item_899(Item):
    cv_arg: TypeAlias = NonSpare_1718.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1718

    @classmethod
    def create(cls, arg : "Item_899.cv_arg") -> "Item_899":
        return cls._create(arg) # type: ignore

class Variation_1374(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_148.cv_arg, Tuple[Literal["SN"], RuleVariation_148.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1374.cv_arg_group_1"],
    ]
    cv_items_list = [[(Item_899, 6), (Item_26, 1), None]]

    @classmethod
    def create(cls, arg: "Variation_1374.cv_arg") -> 'Variation_1374':
        return cls._create(arg) # type: ignore

    @overload # type: ignore
    def get_item(self, key : Literal["SN"]) -> RuleVariation_148:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1296(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1374.cv_arg
    cv_variation: TypeAlias = Variation_1374

    @classmethod
    def create(cls, arg : "RuleVariation_1296.cv_arg") -> "RuleVariation_1296":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1374:
        return self.arg # type: ignore

class NonSpare_195(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1296.cv_arg
    cv_name = "060"
    cv_title = "Synchronisation/Control Signal"
    cv_rule: TypeAlias = RuleVariation_1296

    @classmethod
    def create(cls, arg : "NonSpare_195.cv_arg") -> "NonSpare_195":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1296:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1374:
        return self.rule.variation

class UapItem_195(UapItem):
    cv_non_spare: TypeAlias = NonSpare_195

class NonSpare_217(NonSpare):
    cv_arg: TypeAlias = RuleVariation_361.cv_arg
    cv_name = "070"
    cv_title = "Time of Day"
    cv_rule: TypeAlias = RuleVariation_361

    @classmethod
    def create(cls, arg : "NonSpare_217.cv_arg") -> "NonSpare_217":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_361:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_368:
        return self.rule.variation

class UapItem_217(UapItem):
    cv_non_spare: TypeAlias = NonSpare_217

class NonSpare_230(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1274.cv_arg
    cv_name = "080"
    cv_title = "Processing Status"
    cv_rule: TypeAlias = RuleVariation_1274

    @classmethod
    def create(cls, arg : "NonSpare_230.cv_arg") -> "NonSpare_230":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1274:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1352:
        return self.rule.variation

class UapItem_230(UapItem):
    cv_non_spare: TypeAlias = NonSpare_230

class NonSpare_1643(NonSpare):
    cv_arg: TypeAlias = RuleVariation_158.cv_arg
    cv_name = "SAC"
    cv_title = "SAC of Radar Concerned"
    cv_rule: TypeAlias = RuleVariation_158

    @classmethod
    def create(cls, arg : "NonSpare_1643.cv_arg") -> "NonSpare_1643":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_158:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_164:
        return self.rule.variation

class Item_850(Item):
    cv_arg: TypeAlias = NonSpare_1643.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1643

    @classmethod
    def create(cls, arg : "Item_850.cv_arg") -> "Item_850":
        return cls._create(arg) # type: ignore

class NonSpare_1698(NonSpare):
    cv_arg: TypeAlias = RuleVariation_158.cv_arg
    cv_name = "SIC"
    cv_title = "SIC of Radar Concerned"
    cv_rule: TypeAlias = RuleVariation_158

    @classmethod
    def create(cls, arg : "NonSpare_1698.cv_arg") -> "NonSpare_1698":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_158:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_164:
        return self.rule.variation

class Item_881(Item):
    cv_arg: TypeAlias = NonSpare_1698.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1698

    @classmethod
    def create(cls, arg : "Item_881.cv_arg") -> "Item_881":
        return cls._create(arg) # type: ignore

class Item_2(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 0
    cv_bit_size = 3

class Variation_611(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_611.cv_arg") -> "Variation_611":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_600(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_611.cv_arg
    cv_variation: TypeAlias = Variation_611

    @classmethod
    def create(cls, arg : "RuleVariation_600.cv_arg") -> "RuleVariation_600":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_611:
        return self.arg # type: ignore

class NonSpare_807(NonSpare):
    cv_arg: TypeAlias = RuleVariation_600.cv_arg
    cv_name = "CP"
    cv_title = "Circular Polarisation"
    cv_rule: TypeAlias = RuleVariation_600

    @classmethod
    def create(cls, arg : "NonSpare_807.cv_arg") -> "NonSpare_807":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_600:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_611:
        return self.rule.variation

class Item_205(Item):
    cv_arg: TypeAlias = NonSpare_807.cv_arg
    cv_non_spare: TypeAlias = NonSpare_807

    @classmethod
    def create(cls, arg : "Item_205.cv_arg") -> "Item_205":
        return cls._create(arg) # type: ignore

class Variation_696(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_696.cv_arg") -> "Variation_696":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_685(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_696.cv_arg
    cv_variation: TypeAlias = Variation_696

    @classmethod
    def create(cls, arg : "RuleVariation_685.cv_arg") -> "RuleVariation_685":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_696:
        return self.arg # type: ignore

class NonSpare_2051(NonSpare):
    cv_arg: TypeAlias = RuleVariation_685.cv_arg
    cv_name = "WO"
    cv_title = "Weather Channel Overload"
    cv_rule: TypeAlias = RuleVariation_685

    @classmethod
    def create(cls, arg : "NonSpare_2051.cv_arg") -> "NonSpare_2051":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_685:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_696:
        return self.rule.variation

class Item_1161(Item):
    cv_arg: TypeAlias = NonSpare_2051.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2051

    @classmethod
    def create(cls, arg : "Item_1161.cv_arg") -> "Item_1161":
        return cls._create(arg) # type: ignore

class NonSpare_1522(NonSpare):
    cv_arg: TypeAlias = RuleVariation_856.cv_arg
    cv_name = "R"
    cv_title = "Reduction Step in Use By Radar  Concerned"
    cv_rule: TypeAlias = RuleVariation_856

    @classmethod
    def create(cls, arg : "NonSpare_1522.cv_arg") -> "NonSpare_1522":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_856:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_886:
        return self.rule.variation

class Item_759(Item):
    cv_arg: TypeAlias = NonSpare_1522.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1522

    @classmethod
    def create(cls, arg : "Item_759.cv_arg") -> "Item_759":
        return cls._create(arg) # type: ignore

class Variation_1186(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_158.cv_arg, Tuple[Literal["SAC"], RuleVariation_158.cv_arg]], Union[RuleVariation_158.cv_arg, Tuple[Literal["SIC"], RuleVariation_158.cv_arg]], int, Union[RuleVariation_600.cv_arg, Tuple[Literal["CP"], RuleVariation_600.cv_arg]], Union[RuleVariation_685.cv_arg, Tuple[Literal["WO"], RuleVariation_685.cv_arg]], Union[RuleVariation_856.cv_arg, Tuple[Literal["R"], RuleVariation_856.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1186.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_items_list = [(Item_850, 8), (Item_881, 8), (Item_2, 3), (Item_205, 1), (Item_1161, 1), (Item_759, 3)]
    cv_items_dict = {"SAC": RuleVariation_158, "SIC": RuleVariation_158, "CP": RuleVariation_600, "WO": RuleVariation_685, "R": RuleVariation_856}

    @overload
    @classmethod
    def spec(cls, key : Literal["SAC"]) -> RuleVariation_158:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SIC"]) -> RuleVariation_158:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CP"]) -> RuleVariation_600:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["WO"]) -> RuleVariation_685:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["R"]) -> RuleVariation_856:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["SAC"], Literal["SIC"], Literal["CP"], Literal["WO"], Literal["R"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["SAC"]) -> RuleVariation_158:
        ...
    @overload
    def get_item(self, key : Literal["SIC"]) -> RuleVariation_158:
        ...
    @overload
    def get_item(self, key : Literal["CP"]) -> RuleVariation_600:
        ...
    @overload
    def get_item(self, key : Literal["WO"]) -> RuleVariation_685:
        ...
    @overload
    def get_item(self, key : Literal["R"]) -> RuleVariation_856:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1186.cv_arg") -> 'Variation_1186':
        return cls._create(arg) # type: ignore

class Variation_1420(Repetitive):
    cv_arg: TypeAlias = List[Variation_1186.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1186

    @classmethod
    def create(cls, arg: "Variation_1420.cv_arg") -> 'Variation_1420':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1186]:
        return self._get_list() # type: ignore

class RuleVariation_1342(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1420.cv_arg
    cv_variation: TypeAlias = Variation_1420

    @classmethod
    def create(cls, arg : "RuleVariation_1342.cv_arg") -> "RuleVariation_1342":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1420:
        return self.arg # type: ignore

class NonSpare_253(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1342.cv_arg
    cv_name = "090"
    cv_title = "Radar Configuration and Status"
    cv_rule: TypeAlias = RuleVariation_1342

    @classmethod
    def create(cls, arg : "NonSpare_253.cv_arg") -> "NonSpare_253":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1342:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1420:
        return self.rule.variation

class UapItem_253(UapItem):
    cv_non_spare: TypeAlias = NonSpare_253

class NonSpare_275(NonSpare):
    cv_arg: TypeAlias = RuleVariation_247.cv_arg
    cv_name = "100"
    cv_title = "Vector Count"
    cv_rule: TypeAlias = RuleVariation_247

    @classmethod
    def create(cls, arg : "NonSpare_275.cv_arg") -> "NonSpare_275":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_247:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_254:
        return self.rule.variation

class UapItem_275(UapItem):
    cv_non_spare: TypeAlias = NonSpare_275

class Record_20(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_36.cv_arg,
        "000": NonSpare_15.cv_arg,
        "020": NonSpare_93.cv_arg,
        "030": NonSpare_105.cv_arg,
        "060": NonSpare_195.cv_arg,
        "070": NonSpare_217.cv_arg,
        "080": NonSpare_230.cv_arg,
        "090": NonSpare_253.cv_arg,
        "100": NonSpare_275.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 2
    cv_items_list = [UapItem_36, UapItem_15, UapItem_93, UapItem_105, UapItem_195, UapItem_217, UapItem_230, UapItem_253, UapItem_275]
    cv_items_dict = {"010": NonSpare_36, "000": NonSpare_15, "020": NonSpare_93, "030": NonSpare_105, "060": NonSpare_195, "070": NonSpare_217, "080": NonSpare_230, "090": NonSpare_253, "100": NonSpare_275}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_36:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> NonSpare_15:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_93:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> NonSpare_105:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_195:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> NonSpare_217:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> NonSpare_230:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> NonSpare_253:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_275:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["020"], Literal["030"], Literal["060"], Literal["070"], Literal["080"], Literal["090"], Literal["100"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_36]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_15]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_93]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_105]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_195]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_217]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_230]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_253]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_275]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_36.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_15.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_93.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_105.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_195.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_217.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_230.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_253.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_275.cv_arg) -> 'Record_20':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_20':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Record_20.cv_arg") -> 'Record_20':
        return cls._create(arg) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_20", Bits]]:
        return cls._parse(bs) # type: ignore

class Uap_18(UapSingle):
    cv_arg: TypeAlias = Record_20
    cv_record: TypeAlias = Record_20

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_20]]:
        return cls._parse(bs)

class Asterix_9(AstCat):
    cv_category = 9
    cv_edition = (2, 1)
    cv_uap: TypeAlias = Uap_18
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_18.cv_arg]) -> "Asterix_9":
        return cls._create(records) # type: ignore

class NonSpare_42(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1135.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1135

    @classmethod
    def create(cls, arg : "NonSpare_42.cv_arg") -> "NonSpare_42":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1135:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1187:
        return self.rule.variation

class UapItem_42(UapItem):
    cv_non_spare: TypeAlias = NonSpare_42

class Content_596(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Target Report", 2: "Start of Update Cycle", 3: "Periodic Status Message", 4: "Event-triggered Status Message"}

class RuleContent_596(RuleContentContextFree):
    cv_arg: TypeAlias = Content_596.cv_arg
    cv_content: TypeAlias = Content_596

    @property
    def content(self) -> Content_596:
        return self._get_content() # type: ignore

class Variation_196(Element):
    cv_arg: TypeAlias = RuleContent_596.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_596

    @classmethod
    def create(cls, arg: "Variation_196.cv_arg") -> "Variation_196":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_596:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_596:
        return self.rule.content

class RuleVariation_189(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_196.cv_arg
    cv_variation: TypeAlias = Variation_196

    @classmethod
    def create(cls, arg : "RuleVariation_189.cv_arg") -> "RuleVariation_189":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_196:
        return self.arg # type: ignore

class NonSpare_12(NonSpare):
    cv_arg: TypeAlias = RuleVariation_189.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_189

    @classmethod
    def create(cls, arg : "NonSpare_12.cv_arg") -> "NonSpare_12":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_189:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_196:
        return self.rule.variation

class UapItem_12(UapItem):
    cv_non_spare: TypeAlias = NonSpare_12

class Content_449(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "SSR multilateration", 1: "Mode S multilateration", 2: "ADS-B", 3: "PSR", 4: "Magnetic Loop System", 5: "HF multilateration", 6: "Not defined", 7: "Other types"}

class RuleContent_449(RuleContentContextFree):
    cv_arg: TypeAlias = Content_449.cv_arg
    cv_content: TypeAlias = Content_449

    @property
    def content(self) -> Content_449:
        return self._get_content() # type: ignore

class Variation_130(Element):
    cv_arg: TypeAlias = RuleContent_449.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 3
    cv_rule = RuleContent_449

    @classmethod
    def create(cls, arg: "Variation_130.cv_arg") -> "Variation_130":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_449:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_449:
        return self.rule.content

class RuleVariation_130(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_130.cv_arg
    cv_variation: TypeAlias = Variation_130

    @classmethod
    def create(cls, arg : "RuleVariation_130.cv_arg") -> "RuleVariation_130":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_130:
        return self.arg # type: ignore

class Content_350(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No differential correction (ADS-B)", 1: "Differential correction (ADS-B)"}

class RuleContent_350(RuleContentContextFree):
    cv_arg: TypeAlias = Content_350.cv_arg
    cv_content: TypeAlias = Content_350

    @property
    def content(self) -> Content_350:
        return self._get_content() # type: ignore

class Variation_649(Element):
    cv_arg: TypeAlias = RuleContent_350.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_350

    @classmethod
    def create(cls, arg: "Variation_649.cv_arg") -> "Variation_649":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_350:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_350:
        return self.rule.content

class RuleVariation_638(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_649.cv_arg
    cv_variation: TypeAlias = Variation_649

    @classmethod
    def create(cls, arg : "RuleVariation_638.cv_arg") -> "RuleVariation_638":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_649:
        return self.arg # type: ignore

class Content_53(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Chain 1", 1: "Chain 2"}

class RuleContent_53(RuleContentContextFree):
    cv_arg: TypeAlias = Content_53.cv_arg
    cv_content: TypeAlias = Content_53

    @property
    def content(self) -> Content_53:
        return self._get_content() # type: ignore

class Variation_700(Element):
    cv_arg: TypeAlias = RuleContent_53.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_53

    @classmethod
    def create(cls, arg: "Variation_700.cv_arg") -> "Variation_700":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_53:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_53:
        return self.rule.content

class RuleVariation_689(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_700.cv_arg
    cv_variation: TypeAlias = Variation_700

    @classmethod
    def create(cls, arg : "RuleVariation_689.cv_arg") -> "RuleVariation_689":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_700:
        return self.arg # type: ignore

class Content_519(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Transponder Ground bit not set", 1: "Transponder Ground bit set"}

class RuleContent_519(RuleContentContextFree):
    cv_arg: TypeAlias = Content_519.cv_arg
    cv_content: TypeAlias = Content_519

    @property
    def content(self) -> Content_519:
        return self._get_content() # type: ignore

class Variation_872(Element):
    cv_arg: TypeAlias = RuleContent_519.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_519

    @classmethod
    def create(cls, arg: "Variation_872.cv_arg") -> "Variation_872":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_519:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_519:
        return self.rule.content

class RuleVariation_842(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_872.cv_arg
    cv_variation: TypeAlias = Variation_872

    @classmethod
    def create(cls, arg : "RuleVariation_842.cv_arg") -> "RuleVariation_842":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_872:
        return self.arg # type: ignore

class Content_304(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No Corrupted reply in multilateration", 1: "Corrupted replies in multilateration"}

class RuleContent_304(RuleContentContextFree):
    cv_arg: TypeAlias = Content_304.cv_arg
    cv_content: TypeAlias = Content_304

    @property
    def content(self) -> Content_304:
        return self._get_content() # type: ignore

class Variation_937(Element):
    cv_arg: TypeAlias = RuleContent_304.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_304

    @classmethod
    def create(cls, arg: "Variation_937.cv_arg") -> "Variation_937":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_304:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_304:
        return self.rule.content

class RuleVariation_907(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_937.cv_arg
    cv_variation: TypeAlias = Variation_937

    @classmethod
    def create(cls, arg : "RuleVariation_907.cv_arg") -> "RuleVariation_907":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_937:
        return self.arg # type: ignore

class Content_19(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Actual target report", 1: "Simulated target report"}

class RuleContent_19(RuleContentContextFree):
    cv_arg: TypeAlias = Content_19.cv_arg
    cv_content: TypeAlias = Content_19

    @property
    def content(self) -> Content_19:
        return self._get_content() # type: ignore

class Variation_5(Element):
    cv_arg: TypeAlias = RuleContent_19.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_19

    @classmethod
    def create(cls, arg: "Variation_5.cv_arg") -> "Variation_5":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_19:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_19:
        return self.rule.content

class RuleVariation_5(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_5.cv_arg
    cv_variation: TypeAlias = Variation_5

    @classmethod
    def create(cls, arg : "RuleVariation_5.cv_arg") -> "RuleVariation_5":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_5:
        return self.arg # type: ignore

class Content_154(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Test Target"}

class RuleContent_154(RuleContentContextFree):
    cv_arg: TypeAlias = Content_154.cv_arg
    cv_content: TypeAlias = Content_154

    @property
    def content(self) -> Content_154:
        return self._get_content() # type: ignore

class Variation_417(Element):
    cv_arg: TypeAlias = RuleContent_154.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_154

    @classmethod
    def create(cls, arg: "Variation_417.cv_arg") -> "Variation_417":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_154:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_154:
        return self.rule.content

class RuleVariation_406(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_417.cv_arg
    cv_variation: TypeAlias = Variation_417

    @classmethod
    def create(cls, arg : "RuleVariation_406.cv_arg") -> "RuleVariation_406":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_417:
        return self.arg # type: ignore

class Content_440(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Report from target transponder", 1: "Report from field monitor (fixed transponder)"}

class RuleContent_440(RuleContentContextFree):
    cv_arg: TypeAlias = Content_440.cv_arg
    cv_content: TypeAlias = Content_440

    @property
    def content(self) -> Content_440:
        return self._get_content() # type: ignore

class Variation_571(Element):
    cv_arg: TypeAlias = RuleContent_440.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_440

    @classmethod
    def create(cls, arg: "Variation_571.cv_arg") -> "Variation_571":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_440:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_440:
        return self.rule.content

class RuleVariation_560(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_571.cv_arg
    cv_variation: TypeAlias = Variation_571

    @classmethod
    def create(cls, arg : "RuleVariation_560.cv_arg") -> "RuleVariation_560":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_571:
        return self.arg # type: ignore

class Content_531(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Undetermined", 1: "Loop start", 2: "Loop finish"}

class RuleContent_531(RuleContentContextFree):
    cv_arg: TypeAlias = Content_531.cv_arg
    cv_content: TypeAlias = Content_531

    @property
    def content(self) -> Content_531:
        return self._get_content() # type: ignore

class Variation_679(Element):
    cv_arg: TypeAlias = RuleContent_531.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 2
    cv_rule = RuleContent_531

    @classmethod
    def create(cls, arg: "Variation_679.cv_arg") -> "Variation_679":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_531:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_531:
        return self.rule.content

class RuleVariation_668(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_679.cv_arg
    cv_variation: TypeAlias = Variation_679

    @classmethod
    def create(cls, arg : "RuleVariation_668.cv_arg") -> "RuleVariation_668":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_679:
        return self.arg # type: ignore

class Content_530(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Undetermined", 1: "Aircraft", 2: "Ground vehicle", 3: "Helicopter"}

class RuleContent_530(RuleContentContextFree):
    cv_arg: TypeAlias = Content_530.cv_arg
    cv_content: TypeAlias = Content_530

    @property
    def content(self) -> Content_530:
        return self._get_content() # type: ignore

class Variation_884(Element):
    cv_arg: TypeAlias = RuleContent_530.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 2
    cv_rule = RuleContent_530

    @classmethod
    def create(cls, arg: "Variation_884.cv_arg") -> "Variation_884":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_530:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_530:
        return self.rule.content

class RuleVariation_854(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_884.cv_arg
    cv_variation: TypeAlias = Variation_884

    @classmethod
    def create(cls, arg : "RuleVariation_854.cv_arg") -> "RuleVariation_854":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_884:
        return self.arg # type: ignore

class Content_13(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Absence of SPI", 1: "Special Position Identification"}

class RuleContent_13(RuleContentContextFree):
    cv_arg: TypeAlias = Content_13.cv_arg
    cv_content: TypeAlias = Content_13

    @property
    def content(self) -> Content_13:
        return self._get_content() # type: ignore

class Variation_3(Element):
    cv_arg: TypeAlias = RuleContent_13.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_13

    @classmethod
    def create(cls, arg: "Variation_3.cv_arg") -> "Variation_3":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_13:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_13:
        return self.rule.content

class RuleVariation_3(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_3.cv_arg
    cv_variation: TypeAlias = Variation_3

    @classmethod
    def create(cls, arg : "RuleVariation_3.cv_arg") -> "RuleVariation_3":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_3:
        return self.arg # type: ignore

class NonSpare_1949(NonSpare):
    cv_arg: TypeAlias = RuleVariation_130.cv_arg
    cv_name = "TYP"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_130

    @classmethod
    def create(cls, arg : "NonSpare_1949.cv_arg") -> "NonSpare_1949":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_130:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_130:
        return self.rule.variation

class Item_1069(Item):
    cv_arg: TypeAlias = NonSpare_1949.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1949

    @classmethod
    def create(cls, arg : "Item_1069.cv_arg") -> "Item_1069":
        return cls._create(arg) # type: ignore

class NonSpare_867(NonSpare):
    cv_arg: TypeAlias = RuleVariation_638.cv_arg
    cv_name = "DCR"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_638

    @classmethod
    def create(cls, arg : "NonSpare_867.cv_arg") -> "NonSpare_867":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_638:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_649:
        return self.rule.variation

class Item_251(Item):
    cv_arg: TypeAlias = NonSpare_867.cv_arg
    cv_non_spare: TypeAlias = NonSpare_867

    @classmethod
    def create(cls, arg : "Item_251.cv_arg") -> "Item_251":
        return cls._create(arg) # type: ignore

class NonSpare_728(NonSpare):
    cv_arg: TypeAlias = RuleVariation_689.cv_arg
    cv_name = "CHN"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_689

    @classmethod
    def create(cls, arg : "NonSpare_728.cv_arg") -> "NonSpare_728":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_689:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_700:
        return self.rule.variation

class Item_156(Item):
    cv_arg: TypeAlias = NonSpare_728.cv_arg
    cv_non_spare: TypeAlias = NonSpare_728

    @classmethod
    def create(cls, arg : "Item_156.cv_arg") -> "Item_156":
        return cls._create(arg) # type: ignore

class NonSpare_1021(NonSpare):
    cv_arg: TypeAlias = RuleVariation_842.cv_arg
    cv_name = "GBS"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_842

    @classmethod
    def create(cls, arg : "NonSpare_1021.cv_arg") -> "NonSpare_1021":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_842:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_872:
        return self.rule.variation

class Item_365(Item):
    cv_arg: TypeAlias = NonSpare_1021.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1021

    @classmethod
    def create(cls, arg : "Item_365.cv_arg") -> "Item_365":
        return cls._create(arg) # type: ignore

class NonSpare_823(NonSpare):
    cv_arg: TypeAlias = RuleVariation_907.cv_arg
    cv_name = "CRT"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_907

    @classmethod
    def create(cls, arg : "NonSpare_823.cv_arg") -> "NonSpare_823":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_907:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_937:
        return self.rule.variation

class Item_215(Item):
    cv_arg: TypeAlias = NonSpare_823.cv_arg
    cv_non_spare: TypeAlias = NonSpare_823

    @classmethod
    def create(cls, arg : "Item_215.cv_arg") -> "Item_215":
        return cls._create(arg) # type: ignore

class NonSpare_1712(NonSpare):
    cv_arg: TypeAlias = RuleVariation_5.cv_arg
    cv_name = "SIM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_5

    @classmethod
    def create(cls, arg : "NonSpare_1712.cv_arg") -> "NonSpare_1712":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_5:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_5:
        return self.rule.variation

class Item_893(Item):
    cv_arg: TypeAlias = NonSpare_1712.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1712

    @classmethod
    def create(cls, arg : "Item_893.cv_arg") -> "Item_893":
        return cls._create(arg) # type: ignore

class NonSpare_1924(NonSpare):
    cv_arg: TypeAlias = RuleVariation_406.cv_arg
    cv_name = "TST"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_406

    @classmethod
    def create(cls, arg : "NonSpare_1924.cv_arg") -> "NonSpare_1924":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_406:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_417:
        return self.rule.variation

class Item_1047(Item):
    cv_arg: TypeAlias = NonSpare_1924.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1924

    @classmethod
    def create(cls, arg : "Item_1047.cv_arg") -> "Item_1047":
        return cls._create(arg) # type: ignore

class NonSpare_1526(NonSpare):
    cv_arg: TypeAlias = RuleVariation_560.cv_arg
    cv_name = "RAB"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_560

    @classmethod
    def create(cls, arg : "NonSpare_1526.cv_arg") -> "NonSpare_1526":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_560:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_571:
        return self.rule.variation

class Item_762(Item):
    cv_arg: TypeAlias = NonSpare_1526.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1526

    @classmethod
    def create(cls, arg : "Item_762.cv_arg") -> "Item_762":
        return cls._create(arg) # type: ignore

class NonSpare_1185(NonSpare):
    cv_arg: TypeAlias = RuleVariation_668.cv_arg
    cv_name = "LOP"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_668

    @classmethod
    def create(cls, arg : "NonSpare_1185.cv_arg") -> "NonSpare_1185":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_668:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_679:
        return self.rule.variation

class Item_501(Item):
    cv_arg: TypeAlias = NonSpare_1185.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1185

    @classmethod
    def create(cls, arg : "Item_501.cv_arg") -> "Item_501":
        return cls._create(arg) # type: ignore

class NonSpare_1877(NonSpare):
    cv_arg: TypeAlias = RuleVariation_854.cv_arg
    cv_name = "TOT"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_854

    @classmethod
    def create(cls, arg : "NonSpare_1877.cv_arg") -> "NonSpare_1877":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_854:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_884:
        return self.rule.variation

class Item_1006(Item):
    cv_arg: TypeAlias = NonSpare_1877.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1877

    @classmethod
    def create(cls, arg : "Item_1006.cv_arg") -> "Item_1006":
        return cls._create(arg) # type: ignore

class NonSpare_1725(NonSpare):
    cv_arg: TypeAlias = RuleVariation_3.cv_arg
    cv_name = "SPI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_3

    @classmethod
    def create(cls, arg : "NonSpare_1725.cv_arg") -> "NonSpare_1725":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_3:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_3:
        return self.rule.variation

class Item_904(Item):
    cv_arg: TypeAlias = NonSpare_1725.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1725

    @classmethod
    def create(cls, arg : "Item_904.cv_arg") -> "Item_904":
        return cls._create(arg) # type: ignore

class Variation_1384(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_130.cv_arg, Tuple[Literal["TYP"], RuleVariation_130.cv_arg]], Union[RuleVariation_638.cv_arg, Tuple[Literal["DCR"], RuleVariation_638.cv_arg]], Union[RuleVariation_689.cv_arg, Tuple[Literal["CHN"], RuleVariation_689.cv_arg]], Union[RuleVariation_842.cv_arg, Tuple[Literal["GBS"], RuleVariation_842.cv_arg]], Union[RuleVariation_907.cv_arg, Tuple[Literal["CRT"], RuleVariation_907.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_5.cv_arg, Tuple[Literal["SIM"], RuleVariation_5.cv_arg]], Union[RuleVariation_406.cv_arg, Tuple[Literal["TST"], RuleVariation_406.cv_arg]], Union[RuleVariation_560.cv_arg, Tuple[Literal["RAB"], RuleVariation_560.cv_arg]], Union[RuleVariation_668.cv_arg, Tuple[Literal["LOP"], RuleVariation_668.cv_arg]], Union[RuleVariation_854.cv_arg, Tuple[Literal["TOT"], RuleVariation_854.cv_arg]], None]]
    cv_arg_group_3: TypeAlias = Union[int, Tuple[Union[RuleVariation_3.cv_arg, Tuple[Literal["SPI"], RuleVariation_3.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1384.cv_arg_group_1"],
        Tuple["Variation_1384.cv_arg_group_1", "Variation_1384.cv_arg_group_2"],
        Tuple["Variation_1384.cv_arg_group_1", "Variation_1384.cv_arg_group_2", "Variation_1384.cv_arg_group_3"],
    ]
    cv_items_list = [[(Item_1069, 3), (Item_251, 1), (Item_156, 1), (Item_365, 1), (Item_215, 1), None], [(Item_893, 1), (Item_1047, 1), (Item_762, 1), (Item_501, 2), (Item_1006, 2), None], [(Item_904, 1), (Item_9, 6), None]]

    @classmethod
    def create(cls, arg: "Variation_1384.cv_arg") -> 'Variation_1384':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["TYP"]) -> RuleVariation_130:
        ...
    @overload
    def get_item(self, key : Literal["DCR"]) -> RuleVariation_638:
        ...
    @overload
    def get_item(self, key : Literal["CHN"]) -> RuleVariation_689:
        ...
    @overload
    def get_item(self, key : Literal["GBS"]) -> RuleVariation_842:
        ...
    @overload
    def get_item(self, key : Literal["CRT"]) -> RuleVariation_907:
        ...
    @overload
    def get_item(self, key : Literal["SIM"]) -> Optional[RuleVariation_5]:
        ...
    @overload
    def get_item(self, key : Literal["TST"]) -> Optional[RuleVariation_406]:
        ...
    @overload
    def get_item(self, key : Literal["RAB"]) -> Optional[RuleVariation_560]:
        ...
    @overload
    def get_item(self, key : Literal["LOP"]) -> Optional[RuleVariation_668]:
        ...
    @overload
    def get_item(self, key : Literal["TOT"]) -> Optional[RuleVariation_854]:
        ...
    @overload
    def get_item(self, key : Literal["SPI"]) -> Optional[RuleVariation_3]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1306(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1384.cv_arg
    cv_variation: TypeAlias = Variation_1384

    @classmethod
    def create(cls, arg : "RuleVariation_1306.cv_arg") -> "RuleVariation_1306":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1384:
        return self.arg # type: ignore

class NonSpare_90(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1306.cv_arg
    cv_name = "020"
    cv_title = "Target Report Descriptor"
    cv_rule: TypeAlias = RuleVariation_1306

    @classmethod
    def create(cls, arg : "NonSpare_90.cv_arg") -> "NonSpare_90":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1306:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1384:
        return self.rule.variation

class UapItem_90(UapItem):
    cv_non_spare: TypeAlias = NonSpare_90

class NonSpare_326(NonSpare):
    cv_arg: TypeAlias = RuleVariation_361.cv_arg
    cv_name = "140"
    cv_title = "Time of Day"
    cv_rule: TypeAlias = RuleVariation_361

    @classmethod
    def create(cls, arg : "NonSpare_326.cv_arg") -> "NonSpare_326":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_361:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_368:
        return self.rule.variation

class UapItem_326(UapItem):
    cv_non_spare: TypeAlias = NonSpare_326

class Content_702(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 8.381903171539307e-8
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_702(RuleContentContextFree):
    cv_arg: TypeAlias = Content_702.cv_arg
    cv_content: TypeAlias = Content_702

    @property
    def content(self) -> Content_702:
        return self._get_content() # type: ignore

class Variation_381(Element):
    cv_arg: TypeAlias = RuleContent_702.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_rule = RuleContent_702

    @classmethod
    def create(cls, arg: "Variation_381.cv_arg") -> "Variation_381":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_702:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_702:
        return self.rule.content

class RuleVariation_374(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_381.cv_arg
    cv_variation: TypeAlias = Variation_381

    @classmethod
    def create(cls, arg : "RuleVariation_374.cv_arg") -> "RuleVariation_374":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_381:
        return self.arg # type: ignore

class NonSpare_1147(NonSpare):
    cv_arg: TypeAlias = RuleVariation_374.cv_arg
    cv_name = "LAT"
    cv_title = "Latitude"
    cv_rule: TypeAlias = RuleVariation_374

    @classmethod
    def create(cls, arg : "NonSpare_1147.cv_arg") -> "NonSpare_1147":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_374:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_381:
        return self.rule.variation

class Item_465(Item):
    cv_arg: TypeAlias = NonSpare_1147.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1147

    @classmethod
    def create(cls, arg : "Item_465.cv_arg") -> "Item_465":
        return cls._create(arg) # type: ignore

class Content_700(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 8.381903171539307e-8
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_700(RuleContentContextFree):
    cv_arg: TypeAlias = Content_700.cv_arg
    cv_content: TypeAlias = Content_700

    @property
    def content(self) -> Content_700:
        return self._get_content() # type: ignore

class Variation_379(Element):
    cv_arg: TypeAlias = RuleContent_700.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_rule = RuleContent_700

    @classmethod
    def create(cls, arg: "Variation_379.cv_arg") -> "Variation_379":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_700:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_700:
        return self.rule.content

class RuleVariation_372(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_379.cv_arg
    cv_variation: TypeAlias = Variation_379

    @classmethod
    def create(cls, arg : "RuleVariation_372.cv_arg") -> "RuleVariation_372":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_379:
        return self.arg # type: ignore

class NonSpare_1176(NonSpare):
    cv_arg: TypeAlias = RuleVariation_372.cv_arg
    cv_name = "LON"
    cv_title = "Longitude"
    cv_rule: TypeAlias = RuleVariation_372

    @classmethod
    def create(cls, arg : "NonSpare_1176.cv_arg") -> "NonSpare_1176":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_372:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_379:
        return self.rule.variation

class Item_492(Item):
    cv_arg: TypeAlias = NonSpare_1176.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1176

    @classmethod
    def create(cls, arg : "Item_492.cv_arg") -> "Item_492":
        return cls._create(arg) # type: ignore

class Variation_1126(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_374.cv_arg, Tuple[Literal["LAT"], RuleVariation_374.cv_arg]], Union[RuleVariation_372.cv_arg, Tuple[Literal["LON"], RuleVariation_372.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1126.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 64
    cv_items_list = [(Item_465, 32), (Item_492, 32)]
    cv_items_dict = {"LAT": RuleVariation_374, "LON": RuleVariation_372}

    @overload
    @classmethod
    def spec(cls, key : Literal["LAT"]) -> RuleVariation_374:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["LON"]) -> RuleVariation_372:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["LAT"], Literal["LON"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["LAT"]) -> RuleVariation_374:
        ...
    @overload
    def get_item(self, key : Literal["LON"]) -> RuleVariation_372:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1126.cv_arg") -> 'Variation_1126':
        return cls._create(arg) # type: ignore

class RuleVariation_1082(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1126.cv_arg
    cv_variation: TypeAlias = Variation_1126

    @classmethod
    def create(cls, arg : "RuleVariation_1082.cv_arg") -> "RuleVariation_1082":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1126:
        return self.arg # type: ignore

class NonSpare_153(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1082.cv_arg
    cv_name = "041"
    cv_title = "Position in WGS-84 Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1082

    @classmethod
    def create(cls, arg : "NonSpare_153.cv_arg") -> "NonSpare_153":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1082:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1126:
        return self.rule.variation

class UapItem_153(UapItem):
    cv_non_spare: TypeAlias = NonSpare_153

class Content_717(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 1.0
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_717(RuleContentContextFree):
    cv_arg: TypeAlias = Content_717.cv_arg
    cv_content: TypeAlias = Content_717

    @property
    def content(self) -> Content_717:
        return self._get_content() # type: ignore

class Variation_303(Element):
    cv_arg: TypeAlias = RuleContent_717.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_717

    @classmethod
    def create(cls, arg: "Variation_303.cv_arg") -> "Variation_303":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_717:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_717:
        return self.rule.content

class RuleVariation_296(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_303.cv_arg
    cv_variation: TypeAlias = Variation_303

    @classmethod
    def create(cls, arg : "RuleVariation_296.cv_arg") -> "RuleVariation_296":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_303:
        return self.arg # type: ignore

class NonSpare_1581(NonSpare):
    cv_arg: TypeAlias = RuleVariation_296.cv_arg
    cv_name = "RHO"
    cv_title = "RHO"
    cv_rule: TypeAlias = RuleVariation_296

    @classmethod
    def create(cls, arg : "NonSpare_1581.cv_arg") -> "NonSpare_1581":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_296:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_303:
        return self.rule.variation

class Item_812(Item):
    cv_arg: TypeAlias = NonSpare_1581.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1581

    @classmethod
    def create(cls, arg : "Item_812.cv_arg") -> "Item_812":
        return cls._create(arg) # type: ignore

class NonSpare_1843(NonSpare):
    cv_arg: TypeAlias = RuleVariation_334.cv_arg
    cv_name = "TH"
    cv_title = "Theta"
    cv_rule: TypeAlias = RuleVariation_334

    @classmethod
    def create(cls, arg : "NonSpare_1843.cv_arg") -> "NonSpare_1843":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_334:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_341:
        return self.rule.variation

class Item_987(Item):
    cv_arg: TypeAlias = NonSpare_1843.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1843

    @classmethod
    def create(cls, arg : "Item_987.cv_arg") -> "Item_987":
        return cls._create(arg) # type: ignore

class Variation_1176(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_296.cv_arg, Tuple[Literal["RHO"], RuleVariation_296.cv_arg]], Union[RuleVariation_334.cv_arg, Tuple[Literal["TH"], RuleVariation_334.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1176.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_812, 16), (Item_987, 16)]
    cv_items_dict = {"RHO": RuleVariation_296, "TH": RuleVariation_334}

    @overload
    @classmethod
    def spec(cls, key : Literal["RHO"]) -> RuleVariation_296:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TH"]) -> RuleVariation_334:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["RHO"], Literal["TH"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["RHO"]) -> RuleVariation_296:
        ...
    @overload
    def get_item(self, key : Literal["TH"]) -> RuleVariation_334:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1176.cv_arg") -> 'Variation_1176':
        return cls._create(arg) # type: ignore

class RuleVariation_1127(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1176.cv_arg
    cv_variation: TypeAlias = Variation_1176

    @classmethod
    def create(cls, arg : "RuleVariation_1127.cv_arg") -> "RuleVariation_1127":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1176:
        return self.arg # type: ignore

class NonSpare_138(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1127.cv_arg
    cv_name = "040"
    cv_title = "Measured Position in Polar Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1127

    @classmethod
    def create(cls, arg : "NonSpare_138.cv_arg") -> "NonSpare_138":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1127:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1176:
        return self.rule.variation

class UapItem_138(UapItem):
    cv_non_spare: TypeAlias = NonSpare_138

class Content_624(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 1.0
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_624(RuleContentContextFree):
    cv_arg: TypeAlias = Content_624.cv_arg
    cv_content: TypeAlias = Content_624

    @property
    def content(self) -> Content_624:
        return self._get_content() # type: ignore

class Variation_257(Element):
    cv_arg: TypeAlias = RuleContent_624.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_624

    @classmethod
    def create(cls, arg: "Variation_257.cv_arg") -> "Variation_257":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_624:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_624:
        return self.rule.content

class RuleVariation_250(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_257.cv_arg
    cv_variation: TypeAlias = Variation_257

    @classmethod
    def create(cls, arg : "RuleVariation_250.cv_arg") -> "RuleVariation_250":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_257:
        return self.arg # type: ignore

class NonSpare_2083(NonSpare):
    cv_arg: TypeAlias = RuleVariation_250.cv_arg
    cv_name = "X"
    cv_title = "X Coordinate"
    cv_rule: TypeAlias = RuleVariation_250

    @classmethod
    def create(cls, arg : "NonSpare_2083.cv_arg") -> "NonSpare_2083":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_250:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_257:
        return self.rule.variation

class Item_1190(Item):
    cv_arg: TypeAlias = NonSpare_2083.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2083

    @classmethod
    def create(cls, arg : "Item_1190.cv_arg") -> "Item_1190":
        return cls._create(arg) # type: ignore

class NonSpare_2137(NonSpare):
    cv_arg: TypeAlias = RuleVariation_250.cv_arg
    cv_name = "Y"
    cv_title = "Y Coordinate"
    cv_rule: TypeAlias = RuleVariation_250

    @classmethod
    def create(cls, arg : "NonSpare_2137.cv_arg") -> "NonSpare_2137":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_250:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_257:
        return self.rule.variation

class Item_1241(Item):
    cv_arg: TypeAlias = NonSpare_2137.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2137

    @classmethod
    def create(cls, arg : "Item_1241.cv_arg") -> "Item_1241":
        return cls._create(arg) # type: ignore

class Variation_1303(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_250.cv_arg, Tuple[Literal["X"], RuleVariation_250.cv_arg]], Union[RuleVariation_250.cv_arg, Tuple[Literal["Y"], RuleVariation_250.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1303.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1190, 16), (Item_1241, 16)]
    cv_items_dict = {"X": RuleVariation_250, "Y": RuleVariation_250}

    @overload
    @classmethod
    def spec(cls, key : Literal["X"]) -> RuleVariation_250:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y"]) -> RuleVariation_250:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X"], Literal["Y"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X"]) -> RuleVariation_250:
        ...
    @overload
    def get_item(self, key : Literal["Y"]) -> RuleVariation_250:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1303.cv_arg") -> 'Variation_1303':
        return cls._create(arg) # type: ignore

class RuleVariation_1231(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1303.cv_arg
    cv_variation: TypeAlias = Variation_1303

    @classmethod
    def create(cls, arg : "RuleVariation_1231.cv_arg") -> "RuleVariation_1231":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1303:
        return self.arg # type: ignore

class NonSpare_159(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1231.cv_arg
    cv_name = "042"
    cv_title = "Position in Cartesian Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1231

    @classmethod
    def create(cls, arg : "NonSpare_159.cv_arg") -> "NonSpare_159":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1231:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1303:
        return self.rule.variation

class UapItem_159(UapItem):
    cv_non_spare: TypeAlias = NonSpare_159

class Content_777(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM/s"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 6.103515625e-5
    cv_unit = "NM/s"

    def as_quantity(self, cv_unit : Optional[Literal["NM/s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_776(RuleContentContextFree):
    cv_arg: TypeAlias = Content_777.cv_arg
    cv_content: TypeAlias = Content_777

    @property
    def content(self) -> Content_777:
        return self._get_content() # type: ignore

class Variation_337(Element):
    cv_arg: TypeAlias = RuleContent_776.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_776

    @classmethod
    def create(cls, arg: "Variation_337.cv_arg") -> "Variation_337":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_776:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_777:
        return self.rule.content

class RuleVariation_330(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_337.cv_arg
    cv_variation: TypeAlias = Variation_337

    @classmethod
    def create(cls, arg : "RuleVariation_330.cv_arg") -> "RuleVariation_330":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_337:
        return self.arg # type: ignore

class NonSpare_1034(NonSpare):
    cv_arg: TypeAlias = RuleVariation_330.cv_arg
    cv_name = "GSP"
    cv_title = "Ground Speed"
    cv_rule: TypeAlias = RuleVariation_330

    @classmethod
    def create(cls, arg : "NonSpare_1034.cv_arg") -> "NonSpare_1034":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_330:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_337:
        return self.rule.variation

class Item_374(Item):
    cv_arg: TypeAlias = NonSpare_1034.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1034

    @classmethod
    def create(cls, arg : "Item_374.cv_arg") -> "Item_374":
        return cls._create(arg) # type: ignore

class NonSpare_1890(NonSpare):
    cv_arg: TypeAlias = RuleVariation_334.cv_arg
    cv_name = "TRA"
    cv_title = "Track Angle"
    cv_rule: TypeAlias = RuleVariation_334

    @classmethod
    def create(cls, arg : "NonSpare_1890.cv_arg") -> "NonSpare_1890":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_334:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_341:
        return self.rule.variation

class Item_1019(Item):
    cv_arg: TypeAlias = NonSpare_1890.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1890

    @classmethod
    def create(cls, arg : "Item_1019.cv_arg") -> "Item_1019":
        return cls._create(arg) # type: ignore

class Variation_1110(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_330.cv_arg, Tuple[Literal["GSP"], RuleVariation_330.cv_arg]], Union[RuleVariation_334.cv_arg, Tuple[Literal["TRA"], RuleVariation_334.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1110.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_374, 16), (Item_1019, 16)]
    cv_items_dict = {"GSP": RuleVariation_330, "TRA": RuleVariation_334}

    @overload
    @classmethod
    def spec(cls, key : Literal["GSP"]) -> RuleVariation_330:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TRA"]) -> RuleVariation_334:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["GSP"], Literal["TRA"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["GSP"]) -> RuleVariation_330:
        ...
    @overload
    def get_item(self, key : Literal["TRA"]) -> RuleVariation_334:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1110.cv_arg") -> 'Variation_1110':
        return cls._create(arg) # type: ignore

class RuleVariation_1068(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1110.cv_arg
    cv_variation: TypeAlias = Variation_1110

    @classmethod
    def create(cls, arg : "RuleVariation_1068.cv_arg") -> "RuleVariation_1068":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1110:
        return self.arg # type: ignore

class NonSpare_386(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1068.cv_arg
    cv_name = "200"
    cv_title = "Calculated Track Velocity in Polar Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1068

    @classmethod
    def create(cls, arg : "NonSpare_386.cv_arg") -> "NonSpare_386":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1068:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1110:
        return self.rule.variation

class UapItem_386(UapItem):
    cv_non_spare: TypeAlias = NonSpare_386

class Content_666(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m/s"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 6.25e-2
    cv_unit = "m/s"

    def as_quantity(self, cv_unit : Optional[Literal["m/s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_666(RuleContentContextFree):
    cv_arg: TypeAlias = Content_666.cv_arg
    cv_content: TypeAlias = Content_666

    @property
    def content(self) -> Content_666:
        return self._get_content() # type: ignore

class Variation_280(Element):
    cv_arg: TypeAlias = RuleContent_666.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_666

    @classmethod
    def create(cls, arg: "Variation_280.cv_arg") -> "Variation_280":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_666:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_666:
        return self.rule.content

class RuleVariation_273(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_280.cv_arg
    cv_variation: TypeAlias = Variation_280

    @classmethod
    def create(cls, arg : "RuleVariation_273.cv_arg") -> "RuleVariation_273":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_280:
        return self.arg # type: ignore

class NonSpare_2040(NonSpare):
    cv_arg: TypeAlias = RuleVariation_273.cv_arg
    cv_name = "VX"
    cv_title = "X Velocity"
    cv_rule: TypeAlias = RuleVariation_273

    @classmethod
    def create(cls, arg : "NonSpare_2040.cv_arg") -> "NonSpare_2040":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_273:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_280:
        return self.rule.variation

class Item_1152(Item):
    cv_arg: TypeAlias = NonSpare_2040.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2040

    @classmethod
    def create(cls, arg : "Item_1152.cv_arg") -> "Item_1152":
        return cls._create(arg) # type: ignore

class NonSpare_2045(NonSpare):
    cv_arg: TypeAlias = RuleVariation_273.cv_arg
    cv_name = "VY"
    cv_title = "Y Velocity"
    cv_rule: TypeAlias = RuleVariation_273

    @classmethod
    def create(cls, arg : "NonSpare_2045.cv_arg") -> "NonSpare_2045":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_273:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_280:
        return self.rule.variation

class Item_1157(Item):
    cv_arg: TypeAlias = NonSpare_2045.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2045

    @classmethod
    def create(cls, arg : "Item_1157.cv_arg") -> "Item_1157":
        return cls._create(arg) # type: ignore

class Variation_1277(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_273.cv_arg, Tuple[Literal["VX"], RuleVariation_273.cv_arg]], Union[RuleVariation_273.cv_arg, Tuple[Literal["VY"], RuleVariation_273.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1277.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1152, 16), (Item_1157, 16)]
    cv_items_dict = {"VX": RuleVariation_273, "VY": RuleVariation_273}

    @overload
    @classmethod
    def spec(cls, key : Literal["VX"]) -> RuleVariation_273:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["VY"]) -> RuleVariation_273:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["VX"], Literal["VY"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["VX"]) -> RuleVariation_273:
        ...
    @overload
    def get_item(self, key : Literal["VY"]) -> RuleVariation_273:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1277.cv_arg") -> 'Variation_1277':
        return cls._create(arg) # type: ignore

class RuleVariation_1206(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1277.cv_arg
    cv_variation: TypeAlias = Variation_1277

    @classmethod
    def create(cls, arg : "RuleVariation_1206.cv_arg") -> "RuleVariation_1206":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1277:
        return self.arg # type: ignore

class NonSpare_399(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1206.cv_arg
    cv_name = "202"
    cv_title = "Calculated Track Velocity in Cartesian Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1206

    @classmethod
    def create(cls, arg : "NonSpare_399.cv_arg") -> "NonSpare_399":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1206:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1277:
        return self.rule.variation

class UapItem_399(UapItem):
    cv_non_spare: TypeAlias = NonSpare_399

class NonSpare_1908(NonSpare):
    cv_arg: TypeAlias = RuleVariation_775.cv_arg
    cv_name = "TRK"
    cv_title = "Track Number"
    cv_rule: TypeAlias = RuleVariation_775

    @classmethod
    def create(cls, arg : "NonSpare_1908.cv_arg") -> "NonSpare_1908":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_775:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_805:
        return self.rule.variation

class Item_1033(Item):
    cv_arg: TypeAlias = NonSpare_1908.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1908

    @classmethod
    def create(cls, arg : "Item_1033.cv_arg") -> "Item_1033":
        return cls._create(arg) # type: ignore

class Variation_1031(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_775.cv_arg, Tuple[Literal["TRK"], RuleVariation_775.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1031.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_3, 4), (Item_1033, 12)]
    cv_items_dict = {"TRK": RuleVariation_775}

    @classmethod
    def spec(cls, key : Literal["TRK"]) -> RuleVariation_775:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["TRK"]) -> RuleVariation_775:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1031.cv_arg") -> 'Variation_1031':
        return cls._create(arg) # type: ignore

class RuleVariation_999(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1031.cv_arg
    cv_variation: TypeAlias = Variation_1031

    @classmethod
    def create(cls, arg : "RuleVariation_999.cv_arg") -> "RuleVariation_999":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1031:
        return self.arg # type: ignore

class NonSpare_357(NonSpare):
    cv_arg: TypeAlias = RuleVariation_999.cv_arg
    cv_name = "161"
    cv_title = "Track Number"
    cv_rule: TypeAlias = RuleVariation_999

    @classmethod
    def create(cls, arg : "NonSpare_357.cv_arg") -> "NonSpare_357":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_999:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1031:
        return self.rule.variation

class UapItem_357(UapItem):
    cv_non_spare: TypeAlias = NonSpare_357

class Content_63(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Confirmed track", 1: "Track in initialisation phase"}

class RuleContent_63(RuleContentContextFree):
    cv_arg: TypeAlias = Content_63.cv_arg
    cv_content: TypeAlias = Content_63

    @property
    def content(self) -> Content_63:
        return self._get_content() # type: ignore

class Variation_18(Element):
    cv_arg: TypeAlias = RuleContent_63.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_63

    @classmethod
    def create(cls, arg: "Variation_18.cv_arg") -> "Variation_18":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_63:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_63:
        return self.rule.content

class RuleVariation_18(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_18.cv_arg
    cv_variation: TypeAlias = Variation_18

    @classmethod
    def create(cls, arg : "RuleVariation_18.cv_arg") -> "RuleVariation_18":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_18:
        return self.arg # type: ignore

class Variation_409(Element):
    cv_arg: TypeAlias = RuleContent_112.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_112

    @classmethod
    def create(cls, arg: "Variation_409.cv_arg") -> "Variation_409":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_112:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_112:
        return self.rule.content

class RuleVariation_398(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_409.cv_arg
    cv_variation: TypeAlias = Variation_409

    @classmethod
    def create(cls, arg : "RuleVariation_398.cv_arg") -> "RuleVariation_398":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_409:
        return self.arg # type: ignore

class Content_359(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No extrapolation", 1: "Predictable extrapolation due to sensor refresh period (see NOTE)", 2: "Predictable extrapolation in masked area", 3: "Extrapolation due to unpredictable absence of detection"}

class RuleContent_359(RuleContentContextFree):
    cv_arg: TypeAlias = Content_359.cv_arg
    cv_content: TypeAlias = Content_359

    @property
    def content(self) -> Content_359:
        return self._get_content() # type: ignore

class Variation_591(Element):
    cv_arg: TypeAlias = RuleContent_359.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 2
    cv_rule = RuleContent_359

    @classmethod
    def create(cls, arg: "Variation_591.cv_arg") -> "Variation_591":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_359:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_359:
        return self.rule.content

class RuleVariation_580(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_591.cv_arg
    cv_variation: TypeAlias = Variation_591

    @classmethod
    def create(cls, arg : "RuleVariation_580.cv_arg") -> "RuleVariation_580":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_591:
        return self.arg # type: ignore

class Content_105(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Horizontal manoeuvre"}

class RuleContent_105(RuleContentContextFree):
    cv_arg: TypeAlias = Content_105.cv_arg
    cv_content: TypeAlias = Content_105

    @property
    def content(self) -> Content_105:
        return self._get_content() # type: ignore

class Variation_703(Element):
    cv_arg: TypeAlias = RuleContent_105.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_105

    @classmethod
    def create(cls, arg: "Variation_703.cv_arg") -> "Variation_703":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_105:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_105:
        return self.rule.content

class RuleVariation_692(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_703.cv_arg
    cv_variation: TypeAlias = Variation_703

    @classmethod
    def create(cls, arg : "RuleVariation_692.cv_arg") -> "RuleVariation_692":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_703:
        return self.arg # type: ignore

class Content_513(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Tracking performed in 'Sensor Plane', i.e. neither slant range correction nor projection was applied", 1: "Slant range correction and a suitable projection technique are used to track in a 2D.reference plane, tangential to the earth model at the Sensor Site co-ordinates"}

class RuleContent_513(RuleContentContextFree):
    cv_arg: TypeAlias = Content_513.cv_arg
    cv_content: TypeAlias = Content_513

    @property
    def content(self) -> Content_513:
        return self._get_content() # type: ignore

class Variation_871(Element):
    cv_arg: TypeAlias = RuleContent_513.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_513

    @classmethod
    def create(cls, arg: "Variation_871.cv_arg") -> "Variation_871":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_513:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_513:
        return self.rule.content

class RuleVariation_841(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_871.cv_arg
    cv_variation: TypeAlias = Variation_871

    @classmethod
    def create(cls, arg : "RuleVariation_841.cv_arg") -> "RuleVariation_841":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_871:
        return self.arg # type: ignore

class Content_266(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Measured position", 1: "Smoothed position"}

class RuleContent_266(RuleContentContextFree):
    cv_arg: TypeAlias = Content_266.cv_arg
    cv_content: TypeAlias = Content_266

    @property
    def content(self) -> Content_266:
        return self._get_content() # type: ignore

class Variation_934(Element):
    cv_arg: TypeAlias = RuleContent_266.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_266

    @classmethod
    def create(cls, arg: "Variation_934.cv_arg") -> "Variation_934":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_266:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_266:
        return self.rule.content

class RuleVariation_904(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_934.cv_arg
    cv_variation: TypeAlias = Variation_934

    @classmethod
    def create(cls, arg : "RuleVariation_904.cv_arg") -> "RuleVariation_904":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_934:
        return self.arg # type: ignore

class Content_552(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Unknown type of movement", 1: "Taking-off", 2: "Landing", 3: "Other types of movement"}

class RuleContent_552(RuleContentContextFree):
    cv_arg: TypeAlias = Content_552.cv_arg
    cv_content: TypeAlias = Content_552

    @property
    def content(self) -> Content_552:
        return self._get_content() # type: ignore

class Variation_116(Element):
    cv_arg: TypeAlias = RuleContent_552.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 2
    cv_rule = RuleContent_552

    @classmethod
    def create(cls, arg: "Variation_116.cv_arg") -> "Variation_116":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_552:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_552:
        return self.rule.content

class RuleVariation_116(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_116.cv_arg
    cv_variation: TypeAlias = Variation_116

    @classmethod
    def create(cls, arg : "RuleVariation_116.cv_arg") -> "RuleVariation_116":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_116:
        return self.arg # type: ignore

class Content_351(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No doubt", 1: "Doubtful correlation (undetermined reason)", 2: "Doubtful correlation in clutter", 3: "Loss of accuracy", 4: "Loss of accuracy in clutter", 5: "Unstable track", 6: "Previously coasted"}

class RuleContent_351(RuleContentContextFree):
    cv_arg: TypeAlias = Content_351.cv_arg
    cv_content: TypeAlias = Content_351

    @property
    def content(self) -> Content_351:
        return self._get_content() # type: ignore

class Variation_597(Element):
    cv_arg: TypeAlias = RuleContent_351.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 3
    cv_rule = RuleContent_351

    @classmethod
    def create(cls, arg: "Variation_597.cv_arg") -> "Variation_597":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_351:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_351:
        return self.rule.content

class RuleVariation_586(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_597.cv_arg
    cv_variation: TypeAlias = Variation_597

    @classmethod
    def create(cls, arg : "RuleVariation_586.cv_arg") -> "RuleVariation_586":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_597:
        return self.arg # type: ignore

class Content_267(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Merge or split indication undetermined", 1: "Track merged by association to plot", 2: "Track merged by non-association to plot", 3: "Split track"}

class RuleContent_267(RuleContentContextFree):
    cv_arg: TypeAlias = Content_267.cv_arg
    cv_content: TypeAlias = Content_267

    @property
    def content(self) -> Content_267:
        return self._get_content() # type: ignore

class Variation_876(Element):
    cv_arg: TypeAlias = RuleContent_267.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 2
    cv_rule = RuleContent_267

    @classmethod
    def create(cls, arg: "Variation_876.cv_arg") -> "Variation_876":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_267:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_267:
        return self.rule.content

class RuleVariation_846(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_876.cv_arg
    cv_variation: TypeAlias = Variation_876

    @classmethod
    def create(cls, arg : "RuleVariation_846.cv_arg") -> "RuleVariation_846":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_876:
        return self.arg # type: ignore

class Variation_28(Element):
    cv_arg: TypeAlias = RuleContent_99.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_99

    @classmethod
    def create(cls, arg: "Variation_28.cv_arg") -> "Variation_28":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_99:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_99:
        return self.rule.content

class RuleVariation_28(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_28.cv_arg
    cv_variation: TypeAlias = Variation_28

    @classmethod
    def create(cls, arg : "RuleVariation_28.cv_arg") -> "RuleVariation_28":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_28:
        return self.arg # type: ignore

class NonSpare_740(NonSpare):
    cv_arg: TypeAlias = RuleVariation_18.cv_arg
    cv_name = "CNF"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_18

    @classmethod
    def create(cls, arg : "NonSpare_740.cv_arg") -> "NonSpare_740":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_18:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_18:
        return self.rule.variation

class Item_164(Item):
    cv_arg: TypeAlias = NonSpare_740.cv_arg
    cv_non_spare: TypeAlias = NonSpare_740

    @classmethod
    def create(cls, arg : "Item_164.cv_arg") -> "Item_164":
        return cls._create(arg) # type: ignore

class NonSpare_1904(NonSpare):
    cv_arg: TypeAlias = RuleVariation_398.cv_arg
    cv_name = "TRE"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_398

    @classmethod
    def create(cls, arg : "NonSpare_1904.cv_arg") -> "NonSpare_1904":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_398:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_409:
        return self.rule.variation

class Item_1031(Item):
    cv_arg: TypeAlias = NonSpare_1904.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1904

    @classmethod
    def create(cls, arg : "Item_1031.cv_arg") -> "Item_1031":
        return cls._create(arg) # type: ignore

class NonSpare_834(NonSpare):
    cv_arg: TypeAlias = RuleVariation_580.cv_arg
    cv_name = "CST"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_580

    @classmethod
    def create(cls, arg : "NonSpare_834.cv_arg") -> "NonSpare_834":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_580:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_591:
        return self.rule.variation

class Item_223(Item):
    cv_arg: TypeAlias = NonSpare_834.cv_arg
    cv_non_spare: TypeAlias = NonSpare_834

    @classmethod
    def create(cls, arg : "Item_223.cv_arg") -> "Item_223":
        return cls._create(arg) # type: ignore

class NonSpare_1215(NonSpare):
    cv_arg: TypeAlias = RuleVariation_692.cv_arg
    cv_name = "MAH"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_692

    @classmethod
    def create(cls, arg : "NonSpare_1215.cv_arg") -> "NonSpare_1215":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_692:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_703:
        return self.rule.variation

class Item_521(Item):
    cv_arg: TypeAlias = NonSpare_1215.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1215

    @classmethod
    def create(cls, arg : "Item_521.cv_arg") -> "Item_521":
        return cls._create(arg) # type: ignore

class NonSpare_1829(NonSpare):
    cv_arg: TypeAlias = RuleVariation_841.cv_arg
    cv_name = "TCC"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_841

    @classmethod
    def create(cls, arg : "NonSpare_1829.cv_arg") -> "NonSpare_1829":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_841:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_871:
        return self.rule.variation

class Item_974(Item):
    cv_arg: TypeAlias = NonSpare_1829.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1829

    @classmethod
    def create(cls, arg : "Item_974.cv_arg") -> "Item_974":
        return cls._create(arg) # type: ignore

class NonSpare_1778(NonSpare):
    cv_arg: TypeAlias = RuleVariation_904.cv_arg
    cv_name = "STH"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_904

    @classmethod
    def create(cls, arg : "NonSpare_1778.cv_arg") -> "NonSpare_1778":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_904:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_934:
        return self.rule.variation

class Item_944(Item):
    cv_arg: TypeAlias = NonSpare_1778.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1778

    @classmethod
    def create(cls, arg : "Item_944.cv_arg") -> "Item_944":
        return cls._create(arg) # type: ignore

class NonSpare_1873(NonSpare):
    cv_arg: TypeAlias = RuleVariation_116.cv_arg
    cv_name = "TOM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_116

    @classmethod
    def create(cls, arg : "NonSpare_1873.cv_arg") -> "NonSpare_1873":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_116:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_116:
        return self.rule.variation

class Item_1004(Item):
    cv_arg: TypeAlias = NonSpare_1873.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1873

    @classmethod
    def create(cls, arg : "Item_1004.cv_arg") -> "Item_1004":
        return cls._create(arg) # type: ignore

class NonSpare_885(NonSpare):
    cv_arg: TypeAlias = RuleVariation_586.cv_arg
    cv_name = "DOU"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_586

    @classmethod
    def create(cls, arg : "NonSpare_885.cv_arg") -> "NonSpare_885":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_586:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_597:
        return self.rule.variation

class Item_266(Item):
    cv_arg: TypeAlias = NonSpare_885.cv_arg
    cv_non_spare: TypeAlias = NonSpare_885

    @classmethod
    def create(cls, arg : "Item_266.cv_arg") -> "Item_266":
        return cls._create(arg) # type: ignore

class NonSpare_1308(NonSpare):
    cv_arg: TypeAlias = RuleVariation_846.cv_arg
    cv_name = "MRS"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_846

    @classmethod
    def create(cls, arg : "NonSpare_1308.cv_arg") -> "NonSpare_1308":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_846:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_876:
        return self.rule.variation

class Item_580(Item):
    cv_arg: TypeAlias = NonSpare_1308.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1308

    @classmethod
    def create(cls, arg : "Item_580.cv_arg") -> "Item_580":
        return cls._create(arg) # type: ignore

class NonSpare_1027(NonSpare):
    cv_arg: TypeAlias = RuleVariation_28.cv_arg
    cv_name = "GHO"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_28

    @classmethod
    def create(cls, arg : "NonSpare_1027.cv_arg") -> "NonSpare_1027":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_28:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_28:
        return self.rule.variation

class Item_368(Item):
    cv_arg: TypeAlias = NonSpare_1027.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1027

    @classmethod
    def create(cls, arg : "Item_368.cv_arg") -> "Item_368":
        return cls._create(arg) # type: ignore

class Variation_1344(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_18.cv_arg, Tuple[Literal["CNF"], RuleVariation_18.cv_arg]], Union[RuleVariation_398.cv_arg, Tuple[Literal["TRE"], RuleVariation_398.cv_arg]], Union[RuleVariation_580.cv_arg, Tuple[Literal["CST"], RuleVariation_580.cv_arg]], Union[RuleVariation_692.cv_arg, Tuple[Literal["MAH"], RuleVariation_692.cv_arg]], Union[RuleVariation_841.cv_arg, Tuple[Literal["TCC"], RuleVariation_841.cv_arg]], Union[RuleVariation_904.cv_arg, Tuple[Literal["STH"], RuleVariation_904.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_116.cv_arg, Tuple[Literal["TOM"], RuleVariation_116.cv_arg]], Union[RuleVariation_586.cv_arg, Tuple[Literal["DOU"], RuleVariation_586.cv_arg]], Union[RuleVariation_846.cv_arg, Tuple[Literal["MRS"], RuleVariation_846.cv_arg]], None]]
    cv_arg_group_3: TypeAlias = Union[int, Tuple[Union[RuleVariation_28.cv_arg, Tuple[Literal["GHO"], RuleVariation_28.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1344.cv_arg_group_1"],
        Tuple["Variation_1344.cv_arg_group_1", "Variation_1344.cv_arg_group_2"],
        Tuple["Variation_1344.cv_arg_group_1", "Variation_1344.cv_arg_group_2", "Variation_1344.cv_arg_group_3"],
    ]
    cv_items_list = [[(Item_164, 1), (Item_1031, 1), (Item_223, 2), (Item_521, 1), (Item_974, 1), (Item_944, 1), None], [(Item_1004, 2), (Item_266, 3), (Item_580, 2), None], [(Item_368, 1), (Item_9, 6), None]]

    @classmethod
    def create(cls, arg: "Variation_1344.cv_arg") -> 'Variation_1344':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["CNF"]) -> RuleVariation_18:
        ...
    @overload
    def get_item(self, key : Literal["TRE"]) -> RuleVariation_398:
        ...
    @overload
    def get_item(self, key : Literal["CST"]) -> RuleVariation_580:
        ...
    @overload
    def get_item(self, key : Literal["MAH"]) -> RuleVariation_692:
        ...
    @overload
    def get_item(self, key : Literal["TCC"]) -> RuleVariation_841:
        ...
    @overload
    def get_item(self, key : Literal["STH"]) -> RuleVariation_904:
        ...
    @overload
    def get_item(self, key : Literal["TOM"]) -> Optional[RuleVariation_116]:
        ...
    @overload
    def get_item(self, key : Literal["DOU"]) -> Optional[RuleVariation_586]:
        ...
    @overload
    def get_item(self, key : Literal["MRS"]) -> Optional[RuleVariation_846]:
        ...
    @overload
    def get_item(self, key : Literal["GHO"]) -> Optional[RuleVariation_28]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1266(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1344.cv_arg
    cv_variation: TypeAlias = Variation_1344

    @classmethod
    def create(cls, arg : "RuleVariation_1266.cv_arg") -> "RuleVariation_1266":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1344:
        return self.arg # type: ignore

class NonSpare_369(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1266.cv_arg
    cv_name = "170"
    cv_title = "Track Status"
    cv_rule: TypeAlias = RuleVariation_1266

    @classmethod
    def create(cls, arg : "NonSpare_369.cv_arg") -> "NonSpare_369":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1266:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1344:
        return self.rule.variation

class UapItem_369(UapItem):
    cv_non_spare: TypeAlias = NonSpare_369

class NonSpare_1980(NonSpare):
    cv_arg: TypeAlias = RuleVariation_15.cv_arg
    cv_name = "V"
    cv_title = "Validated"
    cv_rule: TypeAlias = RuleVariation_15

    @classmethod
    def create(cls, arg : "NonSpare_1980.cv_arg") -> "NonSpare_1980":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_15:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_15:
        return self.rule.variation

class Item_1098(Item):
    cv_arg: TypeAlias = NonSpare_1980.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1980

    @classmethod
    def create(cls, arg : "Item_1098.cv_arg") -> "Item_1098":
        return cls._create(arg) # type: ignore

class NonSpare_1003(NonSpare):
    cv_arg: TypeAlias = RuleVariation_394.cv_arg
    cv_name = "G"
    cv_title = "Garbled"
    cv_rule: TypeAlias = RuleVariation_394

    @classmethod
    def create(cls, arg : "NonSpare_1003.cv_arg") -> "NonSpare_1003":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_394:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_405:
        return self.rule.variation

class Item_355(Item):
    cv_arg: TypeAlias = NonSpare_1003.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1003

    @classmethod
    def create(cls, arg : "Item_355.cv_arg") -> "Item_355":
        return cls._create(arg) # type: ignore

class Content_288(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Mode-3/A code derived from the reply of the transponder", 1: "Mode-3/A code not extracted during the last scan"}

class RuleContent_288(RuleContentContextFree):
    cv_arg: TypeAlias = Content_288.cv_arg
    cv_content: TypeAlias = Content_288

    @property
    def content(self) -> Content_288:
        return self._get_content() # type: ignore

class Variation_550(Element):
    cv_arg: TypeAlias = RuleContent_288.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_288

    @classmethod
    def create(cls, arg: "Variation_550.cv_arg") -> "Variation_550":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_288:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_288:
        return self.rule.content

class RuleVariation_539(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_550.cv_arg
    cv_variation: TypeAlias = Variation_550

    @classmethod
    def create(cls, arg : "RuleVariation_539.cv_arg") -> "RuleVariation_539":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_550:
        return self.arg # type: ignore

class NonSpare_1133(NonSpare):
    cv_arg: TypeAlias = RuleVariation_539.cv_arg
    cv_name = "L"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_539

    @classmethod
    def create(cls, arg : "NonSpare_1133.cv_arg") -> "NonSpare_1133":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_539:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_550:
        return self.rule.variation

class Item_451(Item):
    cv_arg: TypeAlias = NonSpare_1133.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1133

    @classmethod
    def create(cls, arg : "Item_451.cv_arg") -> "Item_451":
        return cls._create(arg) # type: ignore

class Variation_1269(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_15.cv_arg, Tuple[Literal["V"], RuleVariation_15.cv_arg]], Union[RuleVariation_394.cv_arg, Tuple[Literal["G"], RuleVariation_394.cv_arg]], Union[RuleVariation_539.cv_arg, Tuple[Literal["L"], RuleVariation_539.cv_arg]], int, Union[RuleVariation_776.cv_arg, Tuple[Literal["MODE3A"], RuleVariation_776.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1269.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_1098, 1), (Item_355, 1), (Item_451, 1), (Item_16, 1), (Item_572, 12)]
    cv_items_dict = {"V": RuleVariation_15, "G": RuleVariation_394, "L": RuleVariation_539, "MODE3A": RuleVariation_776}

    @overload
    @classmethod
    def spec(cls, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> RuleVariation_394:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["L"]) -> RuleVariation_539:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MODE3A"]) -> RuleVariation_776:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["V"], Literal["G"], Literal["L"], Literal["MODE3A"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> RuleVariation_394:
        ...
    @overload
    def get_item(self, key : Literal["L"]) -> RuleVariation_539:
        ...
    @overload
    def get_item(self, key : Literal["MODE3A"]) -> RuleVariation_776:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1269.cv_arg") -> 'Variation_1269':
        return cls._create(arg) # type: ignore

class RuleVariation_1198(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1269.cv_arg
    cv_variation: TypeAlias = Variation_1269

    @classmethod
    def create(cls, arg : "RuleVariation_1198.cv_arg") -> "RuleVariation_1198":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1269:
        return self.arg # type: ignore

class NonSpare_189(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1198.cv_arg
    cv_name = "060"
    cv_title = "Mode-3/A Code in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_1198

    @classmethod
    def create(cls, arg : "NonSpare_189.cv_arg") -> "NonSpare_189":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1198:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1269:
        return self.rule.variation

class UapItem_189(UapItem):
    cv_non_spare: TypeAlias = NonSpare_189

class Variation_347(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_347.cv_arg") -> "Variation_347":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_340(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_347.cv_arg
    cv_variation: TypeAlias = Variation_347

    @classmethod
    def create(cls, arg : "RuleVariation_340.cv_arg") -> "RuleVariation_340":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_347:
        return self.arg # type: ignore

class NonSpare_421(NonSpare):
    cv_arg: TypeAlias = RuleVariation_340.cv_arg
    cv_name = "220"
    cv_title = "Target Address"
    cv_rule: TypeAlias = RuleVariation_340

    @classmethod
    def create(cls, arg : "NonSpare_421.cv_arg") -> "NonSpare_421":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_340:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_347:
        return self.rule.variation

class UapItem_421(UapItem):
    cv_non_spare: TypeAlias = NonSpare_421

class Content_51(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Callsign or registration downlinked from transponder", 1: "Callsign not downlinked from transponder", 2: "Registration not downlinked from transponder"}

class RuleContent_51(RuleContentContextFree):
    cv_arg: TypeAlias = Content_51.cv_arg
    cv_content: TypeAlias = Content_51

    @property
    def content(self) -> Content_51:
        return self._get_content() # type: ignore

class Variation_97(Element):
    cv_arg: TypeAlias = RuleContent_51.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 2
    cv_rule = RuleContent_51

    @classmethod
    def create(cls, arg: "Variation_97.cv_arg") -> "Variation_97":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_51:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_51:
        return self.rule.content

class RuleVariation_97(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_97.cv_arg
    cv_variation: TypeAlias = Variation_97

    @classmethod
    def create(cls, arg : "RuleVariation_97.cv_arg") -> "RuleVariation_97":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_97:
        return self.arg # type: ignore

class NonSpare_1780(NonSpare):
    cv_arg: TypeAlias = RuleVariation_97.cv_arg
    cv_name = "STI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_97

    @classmethod
    def create(cls, arg : "NonSpare_1780.cv_arg") -> "NonSpare_1780":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_97:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_97:
        return self.rule.variation

class Item_946(Item):
    cv_arg: TypeAlias = NonSpare_1780.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1780

    @classmethod
    def create(cls, arg : "Item_946.cv_arg") -> "Item_946":
        return cls._create(arg) # type: ignore

class Item_15(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 2
    cv_bit_size = 6

class NonSpare_729(NonSpare):
    cv_arg: TypeAlias = RuleVariation_381.cv_arg
    cv_name = "CHR"
    cv_title = "Characters 1-8 (Coded on 6 Bits Each) Defining Target Identification"
    cv_rule: TypeAlias = RuleVariation_381

    @classmethod
    def create(cls, arg : "NonSpare_729.cv_arg") -> "NonSpare_729":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_381:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_389:
        return self.rule.variation

class Item_157(Item):
    cv_arg: TypeAlias = NonSpare_729.cv_arg
    cv_non_spare: TypeAlias = NonSpare_729

    @classmethod
    def create(cls, arg : "Item_157.cv_arg") -> "Item_157":
        return cls._create(arg) # type: ignore

class Variation_1211(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_97.cv_arg, Tuple[Literal["STI"], RuleVariation_97.cv_arg]], int, Union[RuleVariation_381.cv_arg, Tuple[Literal["CHR"], RuleVariation_381.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1211.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 56
    cv_items_list = [(Item_946, 2), (Item_15, 6), (Item_157, 48)]
    cv_items_dict = {"STI": RuleVariation_97, "CHR": RuleVariation_381}

    @overload
    @classmethod
    def spec(cls, key : Literal["STI"]) -> RuleVariation_97:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CHR"]) -> RuleVariation_381:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["STI"], Literal["CHR"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["STI"]) -> RuleVariation_97:
        ...
    @overload
    def get_item(self, key : Literal["CHR"]) -> RuleVariation_381:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1211.cv_arg") -> 'Variation_1211':
        return cls._create(arg) # type: ignore

class RuleVariation_1155(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1211.cv_arg
    cv_variation: TypeAlias = Variation_1211

    @classmethod
    def create(cls, arg : "RuleVariation_1155.cv_arg") -> "RuleVariation_1155":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1211:
        return self.arg # type: ignore

class NonSpare_436(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1155.cv_arg
    cv_name = "245"
    cv_title = "Target Identification"
    cv_rule: TypeAlias = RuleVariation_1155

    @classmethod
    def create(cls, arg : "NonSpare_436.cv_arg") -> "NonSpare_436":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1155:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1211:
        return self.rule.variation

class UapItem_436(UapItem):
    cv_non_spare: TypeAlias = NonSpare_436

class Variation_390(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 56
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_390.cv_arg") -> "Variation_390":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_382(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_390.cv_arg
    cv_variation: TypeAlias = Variation_390

    @classmethod
    def create(cls, arg : "RuleVariation_382.cv_arg") -> "RuleVariation_382":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_390:
        return self.arg # type: ignore

class NonSpare_1226(NonSpare):
    cv_arg: TypeAlias = RuleVariation_382.cv_arg
    cv_name = "MBDATA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_382

    @classmethod
    def create(cls, arg : "NonSpare_1226.cv_arg") -> "NonSpare_1226":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_382:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_390:
        return self.rule.variation

class Item_528(Item):
    cv_arg: TypeAlias = NonSpare_1226.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1226

    @classmethod
    def create(cls, arg : "Item_528.cv_arg") -> "Item_528":
        return cls._create(arg) # type: ignore

class NonSpare_669(NonSpare):
    cv_arg: TypeAlias = RuleVariation_131.cv_arg
    cv_name = "BDS1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_131

    @classmethod
    def create(cls, arg : "NonSpare_669.cv_arg") -> "NonSpare_669":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_131:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_131:
        return self.rule.variation

class Item_114(Item):
    cv_arg: TypeAlias = NonSpare_669.cv_arg
    cv_non_spare: TypeAlias = NonSpare_669

    @classmethod
    def create(cls, arg : "Item_114.cv_arg") -> "Item_114":
        return cls._create(arg) # type: ignore

class Variation_796(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 4
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_796.cv_arg") -> "Variation_796":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_766(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_796.cv_arg
    cv_variation: TypeAlias = Variation_796

    @classmethod
    def create(cls, arg : "RuleVariation_766.cv_arg") -> "RuleVariation_766":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_796:
        return self.arg # type: ignore

class NonSpare_671(NonSpare):
    cv_arg: TypeAlias = RuleVariation_766.cv_arg
    cv_name = "BDS2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_766

    @classmethod
    def create(cls, arg : "NonSpare_671.cv_arg") -> "NonSpare_671":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_766:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_796:
        return self.rule.variation

class Item_116(Item):
    cv_arg: TypeAlias = NonSpare_671.cv_arg
    cv_non_spare: TypeAlias = NonSpare_671

    @classmethod
    def create(cls, arg : "Item_116.cv_arg") -> "Item_116":
        return cls._create(arg) # type: ignore

class Variation_1137(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_382.cv_arg, Tuple[Literal["MBDATA"], RuleVariation_382.cv_arg]], Union[RuleVariation_131.cv_arg, Tuple[Literal["BDS1"], RuleVariation_131.cv_arg]], Union[RuleVariation_766.cv_arg, Tuple[Literal["BDS2"], RuleVariation_766.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1137.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 64
    cv_items_list = [(Item_528, 56), (Item_114, 4), (Item_116, 4)]
    cv_items_dict = {"MBDATA": RuleVariation_382, "BDS1": RuleVariation_131, "BDS2": RuleVariation_766}

    @overload
    @classmethod
    def spec(cls, key : Literal["MBDATA"]) -> RuleVariation_382:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["BDS1"]) -> RuleVariation_131:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["BDS2"]) -> RuleVariation_766:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["MBDATA"], Literal["BDS1"], Literal["BDS2"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["MBDATA"]) -> RuleVariation_382:
        ...
    @overload
    def get_item(self, key : Literal["BDS1"]) -> RuleVariation_131:
        ...
    @overload
    def get_item(self, key : Literal["BDS2"]) -> RuleVariation_766:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1137.cv_arg") -> 'Variation_1137':
        return cls._create(arg) # type: ignore

class Variation_1413(Repetitive):
    cv_arg: TypeAlias = List[Variation_1137.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1137

    @classmethod
    def create(cls, arg: "Variation_1413.cv_arg") -> 'Variation_1413':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1137]:
        return self._get_list() # type: ignore

class RuleVariation_1335(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1413.cv_arg
    cv_variation: TypeAlias = Variation_1413

    @classmethod
    def create(cls, arg : "RuleVariation_1335.cv_arg") -> "RuleVariation_1335":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1413:
        return self.arg # type: ignore

class NonSpare_443(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1335.cv_arg
    cv_name = "250"
    cv_title = "Mode S MB Data"
    cv_rule: TypeAlias = RuleVariation_1335

    @classmethod
    def create(cls, arg : "NonSpare_443.cv_arg") -> "NonSpare_443":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1335:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1413:
        return self.rule.variation

class UapItem_443(UapItem):
    cv_non_spare: TypeAlias = NonSpare_443

class Content_535(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Unknown", 1: "ATC equipment maintenance", 2: "Airport maintenance", 3: "Fire", 4: "Bird scarer", 5: "Snow plough", 6: "Runway sweeper", 7: "Emergency", 8: "Police", 9: "Bus", 10: "Tug (push/tow)", 11: "Grass cutter", 12: "Fuel", 13: "Baggage", 14: "Catering", 15: "Aircraft maintenance", 16: "Flyco (follow me)"}

class RuleContent_535(RuleContentContextFree):
    cv_arg: TypeAlias = Content_535.cv_arg
    cv_content: TypeAlias = Content_535

    @property
    def content(self) -> Content_535:
        return self._get_content() # type: ignore

class Variation_176(Element):
    cv_arg: TypeAlias = RuleContent_535.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_535

    @classmethod
    def create(cls, arg: "Variation_176.cv_arg") -> "Variation_176":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_535:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_535:
        return self.rule.content

class RuleVariation_169(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_176.cv_arg
    cv_variation: TypeAlias = Variation_176

    @classmethod
    def create(cls, arg : "RuleVariation_169.cv_arg") -> "RuleVariation_169":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_176:
        return self.arg # type: ignore

class NonSpare_472(NonSpare):
    cv_arg: TypeAlias = RuleVariation_169.cv_arg
    cv_name = "300"
    cv_title = "Vehicle Fleet Identification"
    cv_rule: TypeAlias = RuleVariation_169

    @classmethod
    def create(cls, arg : "NonSpare_472.cv_arg") -> "NonSpare_472":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_169:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_176:
        return self.rule.variation

class UapItem_472(UapItem):
    cv_non_spare: TypeAlias = NonSpare_472

class NonSpare_966(NonSpare):
    cv_arg: TypeAlias = RuleVariation_595.cv_arg
    cv_name = "FL"
    cv_title = "Flight Level"
    cv_rule: TypeAlias = RuleVariation_595

    @classmethod
    def create(cls, arg : "NonSpare_966.cv_arg") -> "NonSpare_966":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_595:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_606:
        return self.rule.variation

class Item_329(Item):
    cv_arg: TypeAlias = NonSpare_966.cv_arg
    cv_non_spare: TypeAlias = NonSpare_966

    @classmethod
    def create(cls, arg : "Item_329.cv_arg") -> "Item_329":
        return cls._create(arg) # type: ignore

class Variation_1265(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_15.cv_arg, Tuple[Literal["V"], RuleVariation_15.cv_arg]], Union[RuleVariation_394.cv_arg, Tuple[Literal["G"], RuleVariation_394.cv_arg]], Union[RuleVariation_595.cv_arg, Tuple[Literal["FL"], RuleVariation_595.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1265.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_1098, 1), (Item_355, 1), (Item_329, 14)]
    cv_items_dict = {"V": RuleVariation_15, "G": RuleVariation_394, "FL": RuleVariation_595}

    @overload
    @classmethod
    def spec(cls, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> RuleVariation_394:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["FL"]) -> RuleVariation_595:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["V"], Literal["G"], Literal["FL"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> RuleVariation_394:
        ...
    @overload
    def get_item(self, key : Literal["FL"]) -> RuleVariation_595:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1265.cv_arg") -> 'Variation_1265':
        return cls._create(arg) # type: ignore

class RuleVariation_1194(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1265.cv_arg
    cv_variation: TypeAlias = Variation_1265

    @classmethod
    def create(cls, arg : "RuleVariation_1194.cv_arg") -> "RuleVariation_1194":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1265:
        return self.arg # type: ignore

class NonSpare_246(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1194.cv_arg
    cv_name = "090"
    cv_title = "Flight Level in Binary Representation"
    cv_rule: TypeAlias = RuleVariation_1194

    @classmethod
    def create(cls, arg : "NonSpare_246.cv_arg") -> "NonSpare_246":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1194:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1265:
        return self.rule.variation

class UapItem_246(UapItem):
    cv_non_spare: TypeAlias = NonSpare_246

class Content_682(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["ft"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 6.25
    cv_unit = "ft"

    def as_quantity(self, cv_unit : Optional[Literal["ft"]] = None) -> float:
        return self._as_quantity()

class RuleContent_682(RuleContentContextFree):
    cv_arg: TypeAlias = Content_682.cv_arg
    cv_content: TypeAlias = Content_682

    @property
    def content(self) -> Content_682:
        return self._get_content() # type: ignore

class Variation_288(Element):
    cv_arg: TypeAlias = RuleContent_682.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_682

    @classmethod
    def create(cls, arg: "Variation_288.cv_arg") -> "Variation_288":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_682:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_682:
        return self.rule.content

class RuleVariation_281(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_288.cv_arg
    cv_variation: TypeAlias = Variation_288

    @classmethod
    def create(cls, arg : "RuleVariation_281.cv_arg") -> "RuleVariation_281":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_288:
        return self.arg # type: ignore

class NonSpare_256(NonSpare):
    cv_arg: TypeAlias = RuleVariation_281.cv_arg
    cv_name = "091"
    cv_title = "Measured Height"
    cv_rule: TypeAlias = RuleVariation_281

    @classmethod
    def create(cls, arg : "NonSpare_256.cv_arg") -> "NonSpare_256":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_281:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_288:
        return self.rule.variation

class UapItem_256(UapItem):
    cv_non_spare: TypeAlias = NonSpare_256

class Content_716(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 1.0
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_716(RuleContentContextFree):
    cv_arg: TypeAlias = Content_716.cv_arg
    cv_content: TypeAlias = Content_716

    @property
    def content(self) -> Content_716:
        return self._get_content() # type: ignore

class Variation_160(Element):
    cv_arg: TypeAlias = RuleContent_716.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 7
    cv_rule = RuleContent_716

    @classmethod
    def create(cls, arg: "Variation_160.cv_arg") -> "Variation_160":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_716:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_716:
        return self.rule.content

class RuleVariation_154(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_160.cv_arg
    cv_variation: TypeAlias = Variation_160

    @classmethod
    def create(cls, arg : "RuleVariation_154.cv_arg") -> "RuleVariation_154":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_160:
        return self.arg # type: ignore

class Content_786(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 2.8125
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_785(RuleContentContextFree):
    cv_arg: TypeAlias = Content_786.cv_arg
    cv_content: TypeAlias = Content_786

    @property
    def content(self) -> Content_786:
        return self._get_content() # type: ignore

class Variation_163(Element):
    cv_arg: TypeAlias = RuleContent_785.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 7
    cv_rule = RuleContent_785

    @classmethod
    def create(cls, arg: "Variation_163.cv_arg") -> "Variation_163":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_785:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_786:
        return self.rule.content

class RuleVariation_157(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_163.cv_arg
    cv_variation: TypeAlias = Variation_163

    @classmethod
    def create(cls, arg : "RuleVariation_157.cv_arg") -> "RuleVariation_157":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_163:
        return self.arg # type: ignore

class NonSpare_1160(NonSpare):
    cv_arg: TypeAlias = RuleVariation_154.cv_arg
    cv_name = "LENGTH"
    cv_title = "Length"
    cv_rule: TypeAlias = RuleVariation_154

    @classmethod
    def create(cls, arg : "NonSpare_1160.cv_arg") -> "NonSpare_1160":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_154:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_160:
        return self.rule.variation

class Item_476(Item):
    cv_arg: TypeAlias = NonSpare_1160.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1160

    @classmethod
    def create(cls, arg : "Item_476.cv_arg") -> "Item_476":
        return cls._create(arg) # type: ignore

class NonSpare_1392(NonSpare):
    cv_arg: TypeAlias = RuleVariation_157.cv_arg
    cv_name = "ORIENTATION"
    cv_title = "Orientation"
    cv_rule: TypeAlias = RuleVariation_157

    @classmethod
    def create(cls, arg : "NonSpare_1392.cv_arg") -> "NonSpare_1392":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_157:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_163:
        return self.rule.variation

class Item_657(Item):
    cv_arg: TypeAlias = NonSpare_1392.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1392

    @classmethod
    def create(cls, arg : "Item_657.cv_arg") -> "Item_657":
        return cls._create(arg) # type: ignore

class NonSpare_2050(NonSpare):
    cv_arg: TypeAlias = RuleVariation_154.cv_arg
    cv_name = "WIDTH"
    cv_title = "Width"
    cv_rule: TypeAlias = RuleVariation_154

    @classmethod
    def create(cls, arg : "NonSpare_2050.cv_arg") -> "NonSpare_2050":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_154:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_160:
        return self.rule.variation

class Item_1160(Item):
    cv_arg: TypeAlias = NonSpare_2050.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2050

    @classmethod
    def create(cls, arg : "Item_1160.cv_arg") -> "Item_1160":
        return cls._create(arg) # type: ignore

class Variation_1356(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_154.cv_arg, Tuple[Literal["LENGTH"], RuleVariation_154.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_157.cv_arg, Tuple[Literal["ORIENTATION"], RuleVariation_157.cv_arg]], None]]
    cv_arg_group_3: TypeAlias = Union[int, Tuple[Union[RuleVariation_154.cv_arg, Tuple[Literal["WIDTH"], RuleVariation_154.cv_arg]], None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1356.cv_arg_group_1"],
        Tuple["Variation_1356.cv_arg_group_1", "Variation_1356.cv_arg_group_2"],
        Tuple["Variation_1356.cv_arg_group_1", "Variation_1356.cv_arg_group_2", "Variation_1356.cv_arg_group_3"],
    ]
    cv_items_list = [[(Item_476, 7), None], [(Item_657, 7), None], [(Item_1160, 7), None]]

    @classmethod
    def create(cls, arg: "Variation_1356.cv_arg") -> 'Variation_1356':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["LENGTH"]) -> RuleVariation_154:
        ...
    @overload
    def get_item(self, key : Literal["ORIENTATION"]) -> Optional[RuleVariation_157]:
        ...
    @overload
    def get_item(self, key : Literal["WIDTH"]) -> Optional[RuleVariation_154]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1278(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1356.cv_arg
    cv_variation: TypeAlias = Variation_1356

    @classmethod
    def create(cls, arg : "RuleVariation_1278.cv_arg") -> "RuleVariation_1278":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1356:
        return self.arg # type: ignore

class NonSpare_456(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1278.cv_arg
    cv_name = "270"
    cv_title = "Target Size and Orientation"
    cv_rule: TypeAlias = RuleVariation_1278

    @classmethod
    def create(cls, arg : "NonSpare_456.cv_arg") -> "NonSpare_456":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1278:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1356:
        return self.rule.variation

class UapItem_456(UapItem):
    cv_non_spare: TypeAlias = NonSpare_456

class Content_409(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Operational", 1: "Degraded", 2: "NOGO"}

class RuleContent_409(RuleContentContextFree):
    cv_arg: TypeAlias = Content_409.cv_arg
    cv_content: TypeAlias = Content_409

    @property
    def content(self) -> Content_409:
        return self._get_content() # type: ignore

class Variation_107(Element):
    cv_arg: TypeAlias = RuleContent_409.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 2
    cv_rule = RuleContent_409

    @classmethod
    def create(cls, arg: "Variation_107.cv_arg") -> "Variation_107":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_409:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_409:
        return self.rule.content

class RuleVariation_107(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_107.cv_arg
    cv_variation: TypeAlias = Variation_107

    @classmethod
    def create(cls, arg : "RuleVariation_107.cv_arg") -> "RuleVariation_107":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_107:
        return self.arg # type: ignore

class NonSpare_1359(NonSpare):
    cv_arg: TypeAlias = RuleVariation_107.cv_arg
    cv_name = "NOGO"
    cv_title = "Operational Release Status of the System"
    cv_rule: TypeAlias = RuleVariation_107

    @classmethod
    def create(cls, arg : "NonSpare_1359.cv_arg") -> "NonSpare_1359":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_107:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_107:
        return self.rule.variation

class Item_625(Item):
    cv_arg: TypeAlias = NonSpare_1359.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1359

    @classmethod
    def create(cls, arg : "Item_625.cv_arg") -> "Item_625":
        return cls._create(arg) # type: ignore

class Content_367(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No overload", 1: "Overload"}

class RuleContent_367(RuleContentContextFree):
    cv_arg: TypeAlias = Content_367.cv_arg
    cv_content: TypeAlias = Content_367

    @property
    def content(self) -> Content_367:
        return self._get_content() # type: ignore

class Variation_561(Element):
    cv_arg: TypeAlias = RuleContent_367.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_367

    @classmethod
    def create(cls, arg: "Variation_561.cv_arg") -> "Variation_561":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_367:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_367:
        return self.rule.content

class RuleVariation_550(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_561.cv_arg
    cv_variation: TypeAlias = Variation_561

    @classmethod
    def create(cls, arg : "RuleVariation_550.cv_arg") -> "RuleVariation_550":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_561:
        return self.arg # type: ignore

class NonSpare_1399(NonSpare):
    cv_arg: TypeAlias = RuleVariation_550.cv_arg
    cv_name = "OVL"
    cv_title = "Overload Indicator"
    cv_rule: TypeAlias = RuleVariation_550

    @classmethod
    def create(cls, arg : "NonSpare_1399.cv_arg") -> "NonSpare_1399":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_550:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_561:
        return self.rule.variation

class Item_663(Item):
    cv_arg: TypeAlias = NonSpare_1399.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1399

    @classmethod
    def create(cls, arg : "Item_663.cv_arg") -> "Item_663":
        return cls._create(arg) # type: ignore

class Content_557(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Valid", 1: "Invalid"}

class RuleContent_557(RuleContentContextFree):
    cv_arg: TypeAlias = Content_557.cv_arg
    cv_content: TypeAlias = Content_557

    @property
    def content(self) -> Content_557:
        return self._get_content() # type: ignore

class Variation_670(Element):
    cv_arg: TypeAlias = RuleContent_557.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_557

    @classmethod
    def create(cls, arg: "Variation_670.cv_arg") -> "Variation_670":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_557:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_557:
        return self.rule.content

class RuleVariation_659(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_670.cv_arg
    cv_variation: TypeAlias = Variation_670

    @classmethod
    def create(cls, arg : "RuleVariation_659.cv_arg") -> "RuleVariation_659":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_670:
        return self.arg # type: ignore

class NonSpare_1930(NonSpare):
    cv_arg: TypeAlias = RuleVariation_659.cv_arg
    cv_name = "TSV"
    cv_title = "Time Source Validity"
    cv_rule: TypeAlias = RuleVariation_659

    @classmethod
    def create(cls, arg : "NonSpare_1930.cv_arg") -> "NonSpare_1930":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_659:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_670:
        return self.rule.variation

class Item_1053(Item):
    cv_arg: TypeAlias = NonSpare_1930.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1930

    @classmethod
    def create(cls, arg : "Item_1053.cv_arg") -> "Item_1053":
        return cls._create(arg) # type: ignore

class Content_380(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Normal Operation", 1: "Diversity degraded"}

class RuleContent_380(RuleContentContextFree):
    cv_arg: TypeAlias = Content_380.cv_arg
    cv_content: TypeAlias = Content_380

    @property
    def content(self) -> Content_380:
        return self._get_content() # type: ignore

class Variation_739(Element):
    cv_arg: TypeAlias = RuleContent_380.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_380

    @classmethod
    def create(cls, arg: "Variation_739.cv_arg") -> "Variation_739":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_380:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_380:
        return self.rule.content

class RuleVariation_728(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_739.cv_arg
    cv_variation: TypeAlias = Variation_739

    @classmethod
    def create(cls, arg : "RuleVariation_728.cv_arg") -> "RuleVariation_728":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_739:
        return self.arg # type: ignore

class NonSpare_877(NonSpare):
    cv_arg: TypeAlias = RuleVariation_728.cv_arg
    cv_name = "DIV"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_728

    @classmethod
    def create(cls, arg : "NonSpare_877.cv_arg") -> "NonSpare_877":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_728:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_739:
        return self.rule.variation

class Item_260(Item):
    cv_arg: TypeAlias = NonSpare_877.cv_arg
    cv_non_spare: TypeAlias = NonSpare_877

    @classmethod
    def create(cls, arg : "Item_260.cv_arg") -> "Item_260":
        return cls._create(arg) # type: ignore

class Content_485(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Test Target Operative", 1: "Test Target Failure"}

class RuleContent_485(RuleContentContextFree):
    cv_arg: TypeAlias = Content_485.cv_arg
    cv_content: TypeAlias = Content_485

    @property
    def content(self) -> Content_485:
        return self._get_content() # type: ignore

class Variation_869(Element):
    cv_arg: TypeAlias = RuleContent_485.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_485

    @classmethod
    def create(cls, arg: "Variation_869.cv_arg") -> "Variation_869":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_485:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_485:
        return self.rule.content

class RuleVariation_839(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_869.cv_arg
    cv_variation: TypeAlias = Variation_869

    @classmethod
    def create(cls, arg : "RuleVariation_839.cv_arg") -> "RuleVariation_839":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_869:
        return self.arg # type: ignore

class NonSpare_1937(NonSpare):
    cv_arg: TypeAlias = RuleVariation_839.cv_arg
    cv_name = "TTF"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_839

    @classmethod
    def create(cls, arg : "NonSpare_1937.cv_arg") -> "NonSpare_1937":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_839:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_869:
        return self.rule.variation

class Item_1058(Item):
    cv_arg: TypeAlias = NonSpare_1937.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1937

    @classmethod
    def create(cls, arg : "Item_1058.cv_arg") -> "Item_1058":
        return cls._create(arg) # type: ignore

class Variation_1148(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_107.cv_arg, Tuple[Literal["NOGO"], RuleVariation_107.cv_arg]], Union[RuleVariation_550.cv_arg, Tuple[Literal["OVL"], RuleVariation_550.cv_arg]], Union[RuleVariation_659.cv_arg, Tuple[Literal["TSV"], RuleVariation_659.cv_arg]], Union[RuleVariation_728.cv_arg, Tuple[Literal["DIV"], RuleVariation_728.cv_arg]], Union[RuleVariation_839.cv_arg, Tuple[Literal["TTF"], RuleVariation_839.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1148.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_625, 2), (Item_663, 1), (Item_1053, 1), (Item_260, 1), (Item_1058, 1), (Item_27, 2)]
    cv_items_dict = {"NOGO": RuleVariation_107, "OVL": RuleVariation_550, "TSV": RuleVariation_659, "DIV": RuleVariation_728, "TTF": RuleVariation_839}

    @overload
    @classmethod
    def spec(cls, key : Literal["NOGO"]) -> RuleVariation_107:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["OVL"]) -> RuleVariation_550:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TSV"]) -> RuleVariation_659:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["DIV"]) -> RuleVariation_728:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TTF"]) -> RuleVariation_839:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["NOGO"], Literal["OVL"], Literal["TSV"], Literal["DIV"], Literal["TTF"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["NOGO"]) -> RuleVariation_107:
        ...
    @overload
    def get_item(self, key : Literal["OVL"]) -> RuleVariation_550:
        ...
    @overload
    def get_item(self, key : Literal["TSV"]) -> RuleVariation_659:
        ...
    @overload
    def get_item(self, key : Literal["DIV"]) -> RuleVariation_728:
        ...
    @overload
    def get_item(self, key : Literal["TTF"]) -> RuleVariation_839:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1148.cv_arg") -> 'Variation_1148':
        return cls._create(arg) # type: ignore

class RuleVariation_1101(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1148.cv_arg
    cv_variation: TypeAlias = Variation_1148

    @classmethod
    def create(cls, arg : "RuleVariation_1101.cv_arg") -> "RuleVariation_1101":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1148:
        return self.arg # type: ignore

class NonSpare_518(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1101.cv_arg
    cv_name = "550"
    cv_title = "System Status"
    cv_rule: TypeAlias = RuleVariation_1101

    @classmethod
    def create(cls, arg : "NonSpare_518.cv_arg") -> "NonSpare_518":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1101:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1148:
        return self.rule.variation

class UapItem_517(UapItem):
    cv_non_spare: TypeAlias = NonSpare_518

class Content_109(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "In Trouble"}

class RuleContent_109(RuleContentContextFree):
    cv_arg: TypeAlias = Content_109.cv_arg
    cv_content: TypeAlias = Content_109

    @property
    def content(self) -> Content_109:
        return self._get_content() # type: ignore

class Variation_30(Element):
    cv_arg: TypeAlias = RuleContent_109.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_109

    @classmethod
    def create(cls, arg: "Variation_30.cv_arg") -> "Variation_30":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_109:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_109:
        return self.rule.content

class RuleVariation_30(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_30.cv_arg
    cv_variation: TypeAlias = Variation_30

    @classmethod
    def create(cls, arg : "RuleVariation_30.cv_arg") -> "RuleVariation_30":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_30:
        return self.arg # type: ignore

class NonSpare_1897(NonSpare):
    cv_arg: TypeAlias = RuleVariation_30.cv_arg
    cv_name = "TRB"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_30

    @classmethod
    def create(cls, arg : "NonSpare_1897.cv_arg") -> "NonSpare_1897":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_30:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_30:
        return self.rule.variation

class Item_1026(Item):
    cv_arg: TypeAlias = NonSpare_1897.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1897

    @classmethod
    def create(cls, arg : "Item_1026.cv_arg") -> "Item_1026":
        return cls._create(arg) # type: ignore

class Content_599(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Towing aircraft", 2: "“Follow me” operation", 3: "Runway check", 4: "Emergency operation (fire, medical...)", 5: "Work in progress (maintenance, birds scarer, sweepers...)"}

class RuleContent_599(RuleContentContextFree):
    cv_arg: TypeAlias = Content_599.cv_arg
    cv_content: TypeAlias = Content_599

    @property
    def content(self) -> Content_599:
        return self._get_content() # type: ignore

class Variation_493(Element):
    cv_arg: TypeAlias = RuleContent_599.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 7
    cv_rule = RuleContent_599

    @classmethod
    def create(cls, arg: "Variation_493.cv_arg") -> "Variation_493":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_599:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_599:
        return self.rule.content

class RuleVariation_482(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_493.cv_arg
    cv_variation: TypeAlias = Variation_493

    @classmethod
    def create(cls, arg : "RuleVariation_482.cv_arg") -> "RuleVariation_482":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_493:
        return self.arg # type: ignore

class NonSpare_1321(NonSpare):
    cv_arg: TypeAlias = RuleVariation_482.cv_arg
    cv_name = "MSG"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_482

    @classmethod
    def create(cls, arg : "NonSpare_1321.cv_arg") -> "NonSpare_1321":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_482:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_493:
        return self.rule.variation

class Item_591(Item):
    cv_arg: TypeAlias = NonSpare_1321.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1321

    @classmethod
    def create(cls, arg : "Item_591.cv_arg") -> "Item_591":
        return cls._create(arg) # type: ignore

class Variation_1225(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_30.cv_arg, Tuple[Literal["TRB"], RuleVariation_30.cv_arg]], Union[RuleVariation_482.cv_arg, Tuple[Literal["MSG"], RuleVariation_482.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1225.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_1026, 1), (Item_591, 7)]
    cv_items_dict = {"TRB": RuleVariation_30, "MSG": RuleVariation_482}

    @overload
    @classmethod
    def spec(cls, key : Literal["TRB"]) -> RuleVariation_30:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MSG"]) -> RuleVariation_482:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["TRB"], Literal["MSG"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["TRB"]) -> RuleVariation_30:
        ...
    @overload
    def get_item(self, key : Literal["MSG"]) -> RuleVariation_482:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1225.cv_arg") -> 'Variation_1225':
        return cls._create(arg) # type: ignore

class RuleVariation_1163(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1225.cv_arg
    cv_variation: TypeAlias = Variation_1225

    @classmethod
    def create(cls, arg : "RuleVariation_1163.cv_arg") -> "RuleVariation_1163":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1225:
        return self.arg # type: ignore

class NonSpare_474(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1163.cv_arg
    cv_name = "310"
    cv_title = "Pre-programmed Message"
    cv_rule: TypeAlias = RuleVariation_1163

    @classmethod
    def create(cls, arg : "NonSpare_474.cv_arg") -> "NonSpare_474":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1163:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1225:
        return self.rule.variation

class UapItem_474(UapItem):
    cv_non_spare: TypeAlias = NonSpare_474

class Content_752(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 0.25
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_751(RuleContentContextFree):
    cv_arg: TypeAlias = Content_752.cv_arg
    cv_content: TypeAlias = Content_752

    @property
    def content(self) -> Content_752:
        return self._get_content() # type: ignore

class Variation_230(Element):
    cv_arg: TypeAlias = RuleContent_751.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_751

    @classmethod
    def create(cls, arg: "Variation_230.cv_arg") -> "Variation_230":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_751:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_752:
        return self.rule.content

class RuleVariation_223(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_230.cv_arg
    cv_variation: TypeAlias = Variation_230

    @classmethod
    def create(cls, arg : "RuleVariation_223.cv_arg") -> "RuleVariation_223":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_230:
        return self.arg # type: ignore

class NonSpare_872(NonSpare):
    cv_arg: TypeAlias = RuleVariation_223.cv_arg
    cv_name = "DEVX"
    cv_title = "Standard Deviation of X Component"
    cv_rule: TypeAlias = RuleVariation_223

    @classmethod
    def create(cls, arg : "NonSpare_872.cv_arg") -> "NonSpare_872":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_223:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_230:
        return self.rule.variation

class Item_255(Item):
    cv_arg: TypeAlias = NonSpare_872.cv_arg
    cv_non_spare: TypeAlias = NonSpare_872

    @classmethod
    def create(cls, arg : "Item_255.cv_arg") -> "Item_255":
        return cls._create(arg) # type: ignore

class NonSpare_873(NonSpare):
    cv_arg: TypeAlias = RuleVariation_223.cv_arg
    cv_name = "DEVY"
    cv_title = "Standard Deviation of Y Component"
    cv_rule: TypeAlias = RuleVariation_223

    @classmethod
    def create(cls, arg : "NonSpare_873.cv_arg") -> "NonSpare_873":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_223:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_230:
        return self.rule.variation

class Item_256(Item):
    cv_arg: TypeAlias = NonSpare_873.cv_arg
    cv_non_spare: TypeAlias = NonSpare_873

    @classmethod
    def create(cls, arg : "Item_256.cv_arg") -> "Item_256":
        return cls._create(arg) # type: ignore

class Content_655(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.25
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_655(RuleContentContextFree):
    cv_arg: TypeAlias = Content_655.cv_arg
    cv_content: TypeAlias = Content_655

    @property
    def content(self) -> Content_655:
        return self._get_content() # type: ignore

class Variation_273(Element):
    cv_arg: TypeAlias = RuleContent_655.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_655

    @classmethod
    def create(cls, arg: "Variation_273.cv_arg") -> "Variation_273":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_655:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_655:
        return self.rule.content

class RuleVariation_266(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_273.cv_arg
    cv_variation: TypeAlias = Variation_273

    @classmethod
    def create(cls, arg : "RuleVariation_266.cv_arg") -> "RuleVariation_266":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_273:
        return self.arg # type: ignore

class NonSpare_806(NonSpare):
    cv_arg: TypeAlias = RuleVariation_266.cv_arg
    cv_name = "COVXY"
    cv_title = "Covariance in Two’s Complement Form"
    cv_rule: TypeAlias = RuleVariation_266

    @classmethod
    def create(cls, arg : "NonSpare_806.cv_arg") -> "NonSpare_806":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_266:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_273:
        return self.rule.variation

class Item_204(Item):
    cv_arg: TypeAlias = NonSpare_806.cv_arg
    cv_non_spare: TypeAlias = NonSpare_806

    @classmethod
    def create(cls, arg : "Item_204.cv_arg") -> "Item_204":
        return cls._create(arg) # type: ignore

class Variation_1080(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_223.cv_arg, Tuple[Literal["DEVX"], RuleVariation_223.cv_arg]], Union[RuleVariation_223.cv_arg, Tuple[Literal["DEVY"], RuleVariation_223.cv_arg]], Union[RuleVariation_266.cv_arg, Tuple[Literal["COVXY"], RuleVariation_266.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1080.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_255, 8), (Item_256, 8), (Item_204, 16)]
    cv_items_dict = {"DEVX": RuleVariation_223, "DEVY": RuleVariation_223, "COVXY": RuleVariation_266}

    @overload
    @classmethod
    def spec(cls, key : Literal["DEVX"]) -> RuleVariation_223:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["DEVY"]) -> RuleVariation_223:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["COVXY"]) -> RuleVariation_266:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["DEVX"], Literal["DEVY"], Literal["COVXY"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["DEVX"]) -> RuleVariation_223:
        ...
    @overload
    def get_item(self, key : Literal["DEVY"]) -> RuleVariation_223:
        ...
    @overload
    def get_item(self, key : Literal["COVXY"]) -> RuleVariation_266:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1080.cv_arg") -> 'Variation_1080':
        return cls._create(arg) # type: ignore

class RuleVariation_1040(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1080.cv_arg
    cv_variation: TypeAlias = Variation_1080

    @classmethod
    def create(cls, arg : "RuleVariation_1040.cv_arg") -> "RuleVariation_1040":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1080:
        return self.arg # type: ignore

class NonSpare_513(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1040.cv_arg
    cv_name = "500"
    cv_title = "Standard Deviation of Position"
    cv_rule: TypeAlias = RuleVariation_1040

    @classmethod
    def create(cls, arg : "NonSpare_513.cv_arg") -> "NonSpare_513":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1040:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1080:
        return self.rule.variation

class UapItem_512(UapItem):
    cv_non_spare: TypeAlias = NonSpare_513

class Content_625(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 1.0
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_625(RuleContentContextFree):
    cv_arg: TypeAlias = Content_625.cv_arg
    cv_content: TypeAlias = Content_625

    @property
    def content(self) -> Content_625:
        return self._get_content() # type: ignore

class Variation_208(Element):
    cv_arg: TypeAlias = RuleContent_625.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_625

    @classmethod
    def create(cls, arg: "Variation_208.cv_arg") -> "Variation_208":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_625:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_625:
        return self.rule.content

class RuleVariation_201(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_208.cv_arg
    cv_variation: TypeAlias = Variation_208

    @classmethod
    def create(cls, arg : "RuleVariation_201.cv_arg") -> "RuleVariation_201":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_208:
        return self.arg # type: ignore

class NonSpare_890(NonSpare):
    cv_arg: TypeAlias = RuleVariation_201.cv_arg
    cv_name = "DRHO"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_201

    @classmethod
    def create(cls, arg : "NonSpare_890.cv_arg") -> "NonSpare_890":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_201:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_208:
        return self.rule.variation

class Item_269(Item):
    cv_arg: TypeAlias = NonSpare_890.cv_arg
    cv_non_spare: TypeAlias = NonSpare_890

    @classmethod
    def create(cls, arg : "Item_269.cv_arg") -> "Item_269":
        return cls._create(arg) # type: ignore

class Content_681(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.15
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_681(RuleContentContextFree):
    cv_arg: TypeAlias = Content_681.cv_arg
    cv_content: TypeAlias = Content_681

    @property
    def content(self) -> Content_681:
        return self._get_content() # type: ignore

class Variation_217(Element):
    cv_arg: TypeAlias = RuleContent_681.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_681

    @classmethod
    def create(cls, arg: "Variation_217.cv_arg") -> "Variation_217":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_681:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_681:
        return self.rule.content

class RuleVariation_210(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_217.cv_arg
    cv_variation: TypeAlias = Variation_217

    @classmethod
    def create(cls, arg : "RuleVariation_210.cv_arg") -> "RuleVariation_210":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_217:
        return self.arg # type: ignore

class NonSpare_901(NonSpare):
    cv_arg: TypeAlias = RuleVariation_210.cv_arg
    cv_name = "DTHETA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_210

    @classmethod
    def create(cls, arg : "NonSpare_901.cv_arg") -> "NonSpare_901":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_210:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_217:
        return self.rule.variation

class Item_277(Item):
    cv_arg: TypeAlias = NonSpare_901.cv_arg
    cv_non_spare: TypeAlias = NonSpare_901

    @classmethod
    def create(cls, arg : "Item_277.cv_arg") -> "Item_277":
        return cls._create(arg) # type: ignore

class Variation_1082(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_201.cv_arg, Tuple[Literal["DRHO"], RuleVariation_201.cv_arg]], Union[RuleVariation_210.cv_arg, Tuple[Literal["DTHETA"], RuleVariation_210.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1082.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_269, 8), (Item_277, 8)]
    cv_items_dict = {"DRHO": RuleVariation_201, "DTHETA": RuleVariation_210}

    @overload
    @classmethod
    def spec(cls, key : Literal["DRHO"]) -> RuleVariation_201:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["DTHETA"]) -> RuleVariation_210:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["DRHO"], Literal["DTHETA"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["DRHO"]) -> RuleVariation_201:
        ...
    @overload
    def get_item(self, key : Literal["DTHETA"]) -> RuleVariation_210:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1082.cv_arg") -> 'Variation_1082':
        return cls._create(arg) # type: ignore

class Variation_1410(Repetitive):
    cv_arg: TypeAlias = List[Variation_1082.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1082

    @classmethod
    def create(cls, arg: "Variation_1410.cv_arg") -> 'Variation_1410':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1082]:
        return self._get_list() # type: ignore

class RuleVariation_1332(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1410.cv_arg
    cv_variation: TypeAlias = Variation_1410

    @classmethod
    def create(cls, arg : "RuleVariation_1332.cv_arg") -> "RuleVariation_1332":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1410:
        return self.arg # type: ignore

class NonSpare_462(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1332.cv_arg
    cv_name = "280"
    cv_title = "Presence"
    cv_rule: TypeAlias = RuleVariation_1332

    @classmethod
    def create(cls, arg : "NonSpare_462.cv_arg") -> "NonSpare_462":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1332:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1410:
        return self.rule.variation

class UapItem_462(UapItem):
    cv_non_spare: TypeAlias = NonSpare_462

class NonSpare_309(NonSpare):
    cv_arg: TypeAlias = RuleVariation_158.cv_arg
    cv_name = "131"
    cv_title = "Amplitude of Primary Plot"
    cv_rule: TypeAlias = RuleVariation_158

    @classmethod
    def create(cls, arg : "NonSpare_309.cv_arg") -> "NonSpare_309":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_158:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_164:
        return self.rule.variation

class UapItem_309(UapItem):
    cv_non_spare: TypeAlias = NonSpare_309

class Content_668(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m/s²"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 6.25e-2
    cv_unit = "m/s²"

    def as_quantity(self, cv_unit : Optional[Literal["m/s²"]] = None) -> float:
        return self._as_quantity()

class RuleContent_668(RuleContentContextFree):
    cv_arg: TypeAlias = Content_668.cv_arg
    cv_content: TypeAlias = Content_668

    @property
    def content(self) -> Content_668:
        return self._get_content() # type: ignore

class Variation_211(Element):
    cv_arg: TypeAlias = RuleContent_668.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_668

    @classmethod
    def create(cls, arg: "Variation_211.cv_arg") -> "Variation_211":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_668:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_668:
        return self.rule.content

class RuleVariation_204(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_211.cv_arg
    cv_variation: TypeAlias = Variation_211

    @classmethod
    def create(cls, arg : "RuleVariation_204.cv_arg") -> "RuleVariation_204":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_211:
        return self.arg # type: ignore

class NonSpare_652(NonSpare):
    cv_arg: TypeAlias = RuleVariation_204.cv_arg
    cv_name = "AX"
    cv_title = "X Acceleration"
    cv_rule: TypeAlias = RuleVariation_204

    @classmethod
    def create(cls, arg : "NonSpare_652.cv_arg") -> "NonSpare_652":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_204:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_211:
        return self.rule.variation

class Item_100(Item):
    cv_arg: TypeAlias = NonSpare_652.cv_arg
    cv_non_spare: TypeAlias = NonSpare_652

    @classmethod
    def create(cls, arg : "Item_100.cv_arg") -> "Item_100":
        return cls._create(arg) # type: ignore

class NonSpare_656(NonSpare):
    cv_arg: TypeAlias = RuleVariation_204.cv_arg
    cv_name = "AY"
    cv_title = "Y Acceleration"
    cv_rule: TypeAlias = RuleVariation_204

    @classmethod
    def create(cls, arg : "NonSpare_656.cv_arg") -> "NonSpare_656":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_204:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_211:
        return self.rule.variation

class Item_104(Item):
    cv_arg: TypeAlias = NonSpare_656.cv_arg
    cv_non_spare: TypeAlias = NonSpare_656

    @classmethod
    def create(cls, arg : "Item_104.cv_arg") -> "Item_104":
        return cls._create(arg) # type: ignore

class Variation_1054(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_204.cv_arg, Tuple[Literal["AX"], RuleVariation_204.cv_arg]], Union[RuleVariation_204.cv_arg, Tuple[Literal["AY"], RuleVariation_204.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1054.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_100, 8), (Item_104, 8)]
    cv_items_dict = {"AX": RuleVariation_204, "AY": RuleVariation_204}

    @overload
    @classmethod
    def spec(cls, key : Literal["AX"]) -> RuleVariation_204:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AY"]) -> RuleVariation_204:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["AX"], Literal["AY"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["AX"]) -> RuleVariation_204:
        ...
    @overload
    def get_item(self, key : Literal["AY"]) -> RuleVariation_204:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1054.cv_arg") -> 'Variation_1054':
        return cls._create(arg) # type: ignore

class RuleVariation_1021(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1054.cv_arg
    cv_variation: TypeAlias = Variation_1054

    @classmethod
    def create(cls, arg : "RuleVariation_1021.cv_arg") -> "RuleVariation_1021":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1054:
        return self.arg # type: ignore

class NonSpare_404(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1021.cv_arg
    cv_name = "210"
    cv_title = "Calculated Acceleration"
    cv_rule: TypeAlias = RuleVariation_1021

    @classmethod
    def create(cls, arg : "NonSpare_404.cv_arg") -> "NonSpare_404":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1021:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1054:
        return self.rule.variation

class UapItem_404(UapItem):
    cv_non_spare: TypeAlias = NonSpare_404

class Record_37(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_42.cv_arg,
        "000": NonSpare_12.cv_arg,
        "020": NonSpare_90.cv_arg,
        "140": NonSpare_326.cv_arg,
        "041": NonSpare_153.cv_arg,
        "040": NonSpare_138.cv_arg,
        "042": NonSpare_159.cv_arg,
        "200": NonSpare_386.cv_arg,
        "202": NonSpare_399.cv_arg,
        "161": NonSpare_357.cv_arg,
        "170": NonSpare_369.cv_arg,
        "060": NonSpare_189.cv_arg,
        "220": NonSpare_421.cv_arg,
        "245": NonSpare_436.cv_arg,
        "250": NonSpare_443.cv_arg,
        "300": NonSpare_472.cv_arg,
        "090": NonSpare_246.cv_arg,
        "091": NonSpare_256.cv_arg,
        "270": NonSpare_456.cv_arg,
        "550": NonSpare_518.cv_arg,
        "310": NonSpare_474.cv_arg,
        "500": NonSpare_513.cv_arg,
        "280": NonSpare_462.cv_arg,
        "131": NonSpare_309.cv_arg,
        "210": NonSpare_404.cv_arg,
        "SP": NonSpare_1721.cv_arg,
        "RE": NonSpare_1557.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 4
    cv_items_list = [UapItem_42, UapItem_12, UapItem_90, UapItem_326, UapItem_153, UapItem_138, UapItem_159, UapItem_386, UapItem_399, UapItem_357, UapItem_369, UapItem_189, UapItem_421, UapItem_436, UapItem_443, UapItem_472, UapItem_246, UapItem_256, UapItem_456, UapItem_517, UapItem_474, UapItem_512, UapItem_462, UapItem_309, UapItem_404, UapItem_544, UapItem_543, UapItem_542]
    cv_items_dict = {"010": NonSpare_42, "000": NonSpare_12, "020": NonSpare_90, "140": NonSpare_326, "041": NonSpare_153, "040": NonSpare_138, "042": NonSpare_159, "200": NonSpare_386, "202": NonSpare_399, "161": NonSpare_357, "170": NonSpare_369, "060": NonSpare_189, "220": NonSpare_421, "245": NonSpare_436, "250": NonSpare_443, "300": NonSpare_472, "090": NonSpare_246, "091": NonSpare_256, "270": NonSpare_456, "550": NonSpare_518, "310": NonSpare_474, "500": NonSpare_513, "280": NonSpare_462, "131": NonSpare_309, "210": NonSpare_404, "SP": NonSpare_1721, "RE": NonSpare_1557}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_42:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> NonSpare_12:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_90:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["140"]) -> NonSpare_326:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["041"]) -> NonSpare_153:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> NonSpare_138:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["042"]) -> NonSpare_159:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["200"]) -> NonSpare_386:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["202"]) -> NonSpare_399:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["161"]) -> NonSpare_357:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["170"]) -> NonSpare_369:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_189:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["220"]) -> NonSpare_421:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["245"]) -> NonSpare_436:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["250"]) -> NonSpare_443:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["300"]) -> NonSpare_472:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> NonSpare_246:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["091"]) -> NonSpare_256:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["270"]) -> NonSpare_456:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["550"]) -> NonSpare_518:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["310"]) -> NonSpare_474:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["500"]) -> NonSpare_513:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["280"]) -> NonSpare_462:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["131"]) -> NonSpare_309:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["210"]) -> NonSpare_404:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1721:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["RE"]) -> NonSpare_1557:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["020"], Literal["140"], Literal["041"], Literal["040"], Literal["042"], Literal["200"], Literal["202"], Literal["161"], Literal["170"], Literal["060"], Literal["220"], Literal["245"], Literal["250"], Literal["300"], Literal["090"], Literal["091"], Literal["270"], Literal["550"], Literal["310"], Literal["500"], Literal["280"], Literal["131"], Literal["210"], Literal["SP"], Literal["RE"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_42]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_12]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_90]:
        ...
    @overload
    def get_item(self, key : Literal["140"]) -> Optional[NonSpare_326]:
        ...
    @overload
    def get_item(self, key : Literal["041"]) -> Optional[NonSpare_153]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_138]:
        ...
    @overload
    def get_item(self, key : Literal["042"]) -> Optional[NonSpare_159]:
        ...
    @overload
    def get_item(self, key : Literal["200"]) -> Optional[NonSpare_386]:
        ...
    @overload
    def get_item(self, key : Literal["202"]) -> Optional[NonSpare_399]:
        ...
    @overload
    def get_item(self, key : Literal["161"]) -> Optional[NonSpare_357]:
        ...
    @overload
    def get_item(self, key : Literal["170"]) -> Optional[NonSpare_369]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_189]:
        ...
    @overload
    def get_item(self, key : Literal["220"]) -> Optional[NonSpare_421]:
        ...
    @overload
    def get_item(self, key : Literal["245"]) -> Optional[NonSpare_436]:
        ...
    @overload
    def get_item(self, key : Literal["250"]) -> Optional[NonSpare_443]:
        ...
    @overload
    def get_item(self, key : Literal["300"]) -> Optional[NonSpare_472]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_246]:
        ...
    @overload
    def get_item(self, key : Literal["091"]) -> Optional[NonSpare_256]:
        ...
    @overload
    def get_item(self, key : Literal["270"]) -> Optional[NonSpare_456]:
        ...
    @overload
    def get_item(self, key : Literal["550"]) -> Optional[NonSpare_518]:
        ...
    @overload
    def get_item(self, key : Literal["310"]) -> Optional[NonSpare_474]:
        ...
    @overload
    def get_item(self, key : Literal["500"]) -> Optional[NonSpare_513]:
        ...
    @overload
    def get_item(self, key : Literal["280"]) -> Optional[NonSpare_462]:
        ...
    @overload
    def get_item(self, key : Literal["131"]) -> Optional[NonSpare_309]:
        ...
    @overload
    def get_item(self, key : Literal["210"]) -> Optional[NonSpare_404]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1721]:
        ...
    @overload
    def get_item(self, key : Literal["RE"]) -> Optional[NonSpare_1557]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_42.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_12.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_90.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["140"], val : NonSpare_326.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["041"], val : NonSpare_153.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_138.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["042"], val : NonSpare_159.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["200"], val : NonSpare_386.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["202"], val : NonSpare_399.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["161"], val : NonSpare_357.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["170"], val : NonSpare_369.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_189.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["220"], val : NonSpare_421.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["245"], val : NonSpare_436.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["250"], val : NonSpare_443.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["300"], val : NonSpare_472.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_246.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["091"], val : NonSpare_256.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["270"], val : NonSpare_456.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["550"], val : NonSpare_518.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["310"], val : NonSpare_474.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["500"], val : NonSpare_513.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["280"], val : NonSpare_462.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["131"], val : NonSpare_309.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["210"], val : NonSpare_404.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1721.cv_arg) -> 'Record_37':
        ...
    @overload
    def set_item(self, key : Literal["RE"], val : NonSpare_1557.cv_arg) -> 'Record_37':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["140"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["041"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["042"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["200"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["202"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["161"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["170"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["220"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["245"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["250"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["300"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["091"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["270"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["550"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["310"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["500"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["280"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["131"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["210"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_37':
        ...
    @overload
    def del_item(self, key : Literal["RE"]) -> 'Record_37':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Record_37.cv_arg") -> 'Record_37':
        return cls._create(arg) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_37", Bits]]:
        return cls._parse(bs) # type: ignore

class Uap_33(UapSingle):
    cv_arg: TypeAlias = Record_37
    cv_record: TypeAlias = Record_37

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_37]]:
        return cls._parse(bs)

class Asterix_10(AstCat):
    cv_category = 10
    cv_edition = (1, 1)
    cv_uap: TypeAlias = Uap_33
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_33.cv_arg]) -> "Asterix_10":
        return cls._create(records) # type: ignore

class NonSpare_1645(NonSpare):
    cv_arg: TypeAlias = RuleVariation_158.cv_arg
    cv_name = "SAC"
    cv_title = "System Area Code Fixed to Zero"
    cv_rule: TypeAlias = RuleVariation_158

    @classmethod
    def create(cls, arg : "NonSpare_1645.cv_arg") -> "NonSpare_1645":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_158:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_164:
        return self.rule.variation

class Item_852(Item):
    cv_arg: TypeAlias = NonSpare_1645.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1645

    @classmethod
    def create(cls, arg : "Item_852.cv_arg") -> "Item_852":
        return cls._create(arg) # type: ignore

class Variation_1191(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_158.cv_arg, Tuple[Literal["SAC"], RuleVariation_158.cv_arg]], Union[RuleVariation_158.cv_arg, Tuple[Literal["SIC"], RuleVariation_158.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1191.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_852, 8), (Item_882, 8)]
    cv_items_dict = {"SAC": RuleVariation_158, "SIC": RuleVariation_158}

    @overload
    @classmethod
    def spec(cls, key : Literal["SAC"]) -> RuleVariation_158:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SIC"]) -> RuleVariation_158:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["SAC"], Literal["SIC"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["SAC"]) -> RuleVariation_158:
        ...
    @overload
    def get_item(self, key : Literal["SIC"]) -> RuleVariation_158:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1191.cv_arg") -> 'Variation_1191':
        return cls._create(arg) # type: ignore

class RuleVariation_1137(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1191.cv_arg
    cv_variation: TypeAlias = Variation_1191

    @classmethod
    def create(cls, arg : "RuleVariation_1137.cv_arg") -> "RuleVariation_1137":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1191:
        return self.arg # type: ignore

class NonSpare_47(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1137.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1137

    @classmethod
    def create(cls, arg : "NonSpare_47.cv_arg") -> "NonSpare_47":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1137:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1191:
        return self.rule.variation

class UapItem_47(UapItem):
    cv_non_spare: TypeAlias = NonSpare_47

class Content_597(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Target reports, flight plan data and basic alerts", 2: "Manual attachment of flight plan to track", 3: "Manual detachment of flight plan to track", 4: "Insertion of flight plan data", 5: "Suppression of flight plan data", 6: "Modification of flight plan data", 7: "Holdbar status"}

class RuleContent_597(RuleContentContextFree):
    cv_arg: TypeAlias = Content_597.cv_arg
    cv_content: TypeAlias = Content_597

    @property
    def content(self) -> Content_597:
        return self._get_content() # type: ignore

class Variation_197(Element):
    cv_arg: TypeAlias = RuleContent_597.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_597

    @classmethod
    def create(cls, arg: "Variation_197.cv_arg") -> "Variation_197":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_597:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_597:
        return self.rule.content

class RuleVariation_190(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_197.cv_arg
    cv_variation: TypeAlias = Variation_197

    @classmethod
    def create(cls, arg : "RuleVariation_190.cv_arg") -> "RuleVariation_190":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_197:
        return self.arg # type: ignore

class NonSpare_13(NonSpare):
    cv_arg: TypeAlias = RuleVariation_190.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_190

    @classmethod
    def create(cls, arg : "NonSpare_13.cv_arg") -> "NonSpare_13":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_190:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_197:
        return self.rule.variation

class UapItem_13(UapItem):
    cv_non_spare: TypeAlias = NonSpare_13

class NonSpare_61(NonSpare):
    cv_arg: TypeAlias = RuleVariation_158.cv_arg
    cv_name = "015"
    cv_title = "Service Identification"
    cv_rule: TypeAlias = RuleVariation_158

    @classmethod
    def create(cls, arg : "NonSpare_61.cv_arg") -> "NonSpare_61":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_158:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_164:
        return self.rule.variation

class UapItem_61(UapItem):
    cv_non_spare: TypeAlias = NonSpare_61

class NonSpare_331(NonSpare):
    cv_arg: TypeAlias = RuleVariation_361.cv_arg
    cv_name = "140"
    cv_title = "Time of Track Information"
    cv_rule: TypeAlias = RuleVariation_361

    @classmethod
    def create(cls, arg : "NonSpare_331.cv_arg") -> "NonSpare_331":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_361:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_368:
        return self.rule.variation

class UapItem_331(UapItem):
    cv_non_spare: TypeAlias = NonSpare_331

class NonSpare_1151(NonSpare):
    cv_arg: TypeAlias = RuleVariation_374.cv_arg
    cv_name = "LAT"
    cv_title = "Latitude in WGS-84 in Two's Complement"
    cv_rule: TypeAlias = RuleVariation_374

    @classmethod
    def create(cls, arg : "NonSpare_1151.cv_arg") -> "NonSpare_1151":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_374:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_381:
        return self.rule.variation

class Item_469(Item):
    cv_arg: TypeAlias = NonSpare_1151.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1151

    @classmethod
    def create(cls, arg : "Item_469.cv_arg") -> "Item_469":
        return cls._create(arg) # type: ignore

class NonSpare_1180(NonSpare):
    cv_arg: TypeAlias = RuleVariation_372.cv_arg
    cv_name = "LON"
    cv_title = "Longitude in WGS-84 in Two's Complement"
    cv_rule: TypeAlias = RuleVariation_372

    @classmethod
    def create(cls, arg : "NonSpare_1180.cv_arg") -> "NonSpare_1180":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_372:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_379:
        return self.rule.variation

class Item_496(Item):
    cv_arg: TypeAlias = NonSpare_1180.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1180

    @classmethod
    def create(cls, arg : "Item_496.cv_arg") -> "Item_496":
        return cls._create(arg) # type: ignore

class Variation_1130(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_374.cv_arg, Tuple[Literal["LAT"], RuleVariation_374.cv_arg]], Union[RuleVariation_372.cv_arg, Tuple[Literal["LON"], RuleVariation_372.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1130.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 64
    cv_items_list = [(Item_469, 32), (Item_496, 32)]
    cv_items_dict = {"LAT": RuleVariation_374, "LON": RuleVariation_372}

    @overload
    @classmethod
    def spec(cls, key : Literal["LAT"]) -> RuleVariation_374:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["LON"]) -> RuleVariation_372:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["LAT"], Literal["LON"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["LAT"]) -> RuleVariation_374:
        ...
    @overload
    def get_item(self, key : Literal["LON"]) -> RuleVariation_372:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1130.cv_arg") -> 'Variation_1130':
        return cls._create(arg) # type: ignore

class RuleVariation_1086(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1130.cv_arg
    cv_variation: TypeAlias = Variation_1130

    @classmethod
    def create(cls, arg : "RuleVariation_1086.cv_arg") -> "RuleVariation_1086":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1130:
        return self.arg # type: ignore

class NonSpare_154(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1086.cv_arg
    cv_name = "041"
    cv_title = "Position in WGS-84 Coordinates"
    cv_rule: TypeAlias = RuleVariation_1086

    @classmethod
    def create(cls, arg : "NonSpare_154.cv_arg") -> "NonSpare_154":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1086:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1130:
        return self.rule.variation

class UapItem_154(UapItem):
    cv_non_spare: TypeAlias = NonSpare_154

class NonSpare_2086(NonSpare):
    cv_arg: TypeAlias = RuleVariation_250.cv_arg
    cv_name = "X"
    cv_title = "X-Component"
    cv_rule: TypeAlias = RuleVariation_250

    @classmethod
    def create(cls, arg : "NonSpare_2086.cv_arg") -> "NonSpare_2086":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_250:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_257:
        return self.rule.variation

class Item_1193(Item):
    cv_arg: TypeAlias = NonSpare_2086.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2086

    @classmethod
    def create(cls, arg : "Item_1193.cv_arg") -> "Item_1193":
        return cls._create(arg) # type: ignore

class NonSpare_2140(NonSpare):
    cv_arg: TypeAlias = RuleVariation_250.cv_arg
    cv_name = "Y"
    cv_title = "Y-Component"
    cv_rule: TypeAlias = RuleVariation_250

    @classmethod
    def create(cls, arg : "NonSpare_2140.cv_arg") -> "NonSpare_2140":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_250:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_257:
        return self.rule.variation

class Item_1244(Item):
    cv_arg: TypeAlias = NonSpare_2140.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2140

    @classmethod
    def create(cls, arg : "Item_1244.cv_arg") -> "Item_1244":
        return cls._create(arg) # type: ignore

class Variation_1306(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_250.cv_arg, Tuple[Literal["X"], RuleVariation_250.cv_arg]], Union[RuleVariation_250.cv_arg, Tuple[Literal["Y"], RuleVariation_250.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1306.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1193, 16), (Item_1244, 16)]
    cv_items_dict = {"X": RuleVariation_250, "Y": RuleVariation_250}

    @overload
    @classmethod
    def spec(cls, key : Literal["X"]) -> RuleVariation_250:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y"]) -> RuleVariation_250:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X"], Literal["Y"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X"]) -> RuleVariation_250:
        ...
    @overload
    def get_item(self, key : Literal["Y"]) -> RuleVariation_250:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1306.cv_arg") -> 'Variation_1306':
        return cls._create(arg) # type: ignore

class RuleVariation_1233(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1306.cv_arg
    cv_variation: TypeAlias = Variation_1306

    @classmethod
    def create(cls, arg : "RuleVariation_1233.cv_arg") -> "RuleVariation_1233":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1306:
        return self.arg # type: ignore

class NonSpare_156(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1233.cv_arg
    cv_name = "042"
    cv_title = "Calculated Position in Cartesian Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1233

    @classmethod
    def create(cls, arg : "NonSpare_156.cv_arg") -> "NonSpare_156":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1233:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1306:
        return self.rule.variation

class UapItem_156(UapItem):
    cv_non_spare: TypeAlias = NonSpare_156

class Content_659(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m/s"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.25
    cv_unit = "m/s"

    def as_quantity(self, cv_unit : Optional[Literal["m/s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_659(RuleContentContextFree):
    cv_arg: TypeAlias = Content_659.cv_arg
    cv_content: TypeAlias = Content_659

    @property
    def content(self) -> Content_659:
        return self._get_content() # type: ignore

class Variation_277(Element):
    cv_arg: TypeAlias = RuleContent_659.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_659

    @classmethod
    def create(cls, arg: "Variation_277.cv_arg") -> "Variation_277":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_659:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_659:
        return self.rule.content

class RuleVariation_270(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_277.cv_arg
    cv_variation: TypeAlias = Variation_277

    @classmethod
    def create(cls, arg : "RuleVariation_270.cv_arg") -> "RuleVariation_270":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_277:
        return self.arg # type: ignore

class NonSpare_2039(NonSpare):
    cv_arg: TypeAlias = RuleVariation_270.cv_arg
    cv_name = "VX"
    cv_title = "Vx"
    cv_rule: TypeAlias = RuleVariation_270

    @classmethod
    def create(cls, arg : "NonSpare_2039.cv_arg") -> "NonSpare_2039":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_270:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_277:
        return self.rule.variation

class Item_1151(Item):
    cv_arg: TypeAlias = NonSpare_2039.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2039

    @classmethod
    def create(cls, arg : "Item_1151.cv_arg") -> "Item_1151":
        return cls._create(arg) # type: ignore

class NonSpare_2044(NonSpare):
    cv_arg: TypeAlias = RuleVariation_270.cv_arg
    cv_name = "VY"
    cv_title = "Vy"
    cv_rule: TypeAlias = RuleVariation_270

    @classmethod
    def create(cls, arg : "NonSpare_2044.cv_arg") -> "NonSpare_2044":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_270:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_277:
        return self.rule.variation

class Item_1156(Item):
    cv_arg: TypeAlias = NonSpare_2044.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2044

    @classmethod
    def create(cls, arg : "Item_1156.cv_arg") -> "Item_1156":
        return cls._create(arg) # type: ignore

class Variation_1276(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_270.cv_arg, Tuple[Literal["VX"], RuleVariation_270.cv_arg]], Union[RuleVariation_270.cv_arg, Tuple[Literal["VY"], RuleVariation_270.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1276.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1151, 16), (Item_1156, 16)]
    cv_items_dict = {"VX": RuleVariation_270, "VY": RuleVariation_270}

    @overload
    @classmethod
    def spec(cls, key : Literal["VX"]) -> RuleVariation_270:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["VY"]) -> RuleVariation_270:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["VX"], Literal["VY"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["VX"]) -> RuleVariation_270:
        ...
    @overload
    def get_item(self, key : Literal["VY"]) -> RuleVariation_270:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1276.cv_arg") -> 'Variation_1276':
        return cls._create(arg) # type: ignore

class RuleVariation_1205(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1276.cv_arg
    cv_variation: TypeAlias = Variation_1276

    @classmethod
    def create(cls, arg : "RuleVariation_1205.cv_arg") -> "RuleVariation_1205":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1276:
        return self.arg # type: ignore

class NonSpare_401(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1205.cv_arg
    cv_name = "202"
    cv_title = "Calculated Track Velocity in Cartesian Coordinates"
    cv_rule: TypeAlias = RuleVariation_1205

    @classmethod
    def create(cls, arg : "NonSpare_401.cv_arg") -> "NonSpare_401":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1205:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1276:
        return self.rule.variation

class UapItem_401(UapItem):
    cv_non_spare: TypeAlias = NonSpare_401

class Content_662(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m/s²"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.25
    cv_unit = "m/s²"

    def as_quantity(self, cv_unit : Optional[Literal["m/s²"]] = None) -> float:
        return self._as_quantity()

class RuleContent_662(RuleContentContextFree):
    cv_arg: TypeAlias = Content_662.cv_arg
    cv_content: TypeAlias = Content_662

    @property
    def content(self) -> Content_662:
        return self._get_content() # type: ignore

class Variation_210(Element):
    cv_arg: TypeAlias = RuleContent_662.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_662

    @classmethod
    def create(cls, arg: "Variation_210.cv_arg") -> "Variation_210":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_662:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_662:
        return self.rule.content

class RuleVariation_203(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_210.cv_arg
    cv_variation: TypeAlias = Variation_210

    @classmethod
    def create(cls, arg : "RuleVariation_203.cv_arg") -> "RuleVariation_203":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_210:
        return self.arg # type: ignore

class NonSpare_651(NonSpare):
    cv_arg: TypeAlias = RuleVariation_203.cv_arg
    cv_name = "AX"
    cv_title = "Ax"
    cv_rule: TypeAlias = RuleVariation_203

    @classmethod
    def create(cls, arg : "NonSpare_651.cv_arg") -> "NonSpare_651":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_203:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_210:
        return self.rule.variation

class Item_99(Item):
    cv_arg: TypeAlias = NonSpare_651.cv_arg
    cv_non_spare: TypeAlias = NonSpare_651

    @classmethod
    def create(cls, arg : "Item_99.cv_arg") -> "Item_99":
        return cls._create(arg) # type: ignore

class NonSpare_655(NonSpare):
    cv_arg: TypeAlias = RuleVariation_203.cv_arg
    cv_name = "AY"
    cv_title = "Ay"
    cv_rule: TypeAlias = RuleVariation_203

    @classmethod
    def create(cls, arg : "NonSpare_655.cv_arg") -> "NonSpare_655":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_203:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_210:
        return self.rule.variation

class Item_103(Item):
    cv_arg: TypeAlias = NonSpare_655.cv_arg
    cv_non_spare: TypeAlias = NonSpare_655

    @classmethod
    def create(cls, arg : "Item_103.cv_arg") -> "Item_103":
        return cls._create(arg) # type: ignore

class Variation_1053(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_203.cv_arg, Tuple[Literal["AX"], RuleVariation_203.cv_arg]], Union[RuleVariation_203.cv_arg, Tuple[Literal["AY"], RuleVariation_203.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1053.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_99, 8), (Item_103, 8)]
    cv_items_dict = {"AX": RuleVariation_203, "AY": RuleVariation_203}

    @overload
    @classmethod
    def spec(cls, key : Literal["AX"]) -> RuleVariation_203:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AY"]) -> RuleVariation_203:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["AX"], Literal["AY"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["AX"]) -> RuleVariation_203:
        ...
    @overload
    def get_item(self, key : Literal["AY"]) -> RuleVariation_203:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1053.cv_arg") -> 'Variation_1053':
        return cls._create(arg) # type: ignore

class RuleVariation_1020(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1053.cv_arg
    cv_variation: TypeAlias = Variation_1053

    @classmethod
    def create(cls, arg : "RuleVariation_1020.cv_arg") -> "RuleVariation_1020":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1053:
        return self.arg # type: ignore

class NonSpare_403(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1020.cv_arg
    cv_name = "210"
    cv_title = "Calculated Acceleration"
    cv_rule: TypeAlias = RuleVariation_1020

    @classmethod
    def create(cls, arg : "NonSpare_403.cv_arg") -> "NonSpare_403":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1020:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1053:
        return self.rule.variation

class UapItem_403(UapItem):
    cv_non_spare: TypeAlias = NonSpare_403

class NonSpare_1290(NonSpare):
    cv_arg: TypeAlias = RuleVariation_776.cv_arg
    cv_name = "MOD3A"
    cv_title = "Mode-3/A Reply in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_776

    @classmethod
    def create(cls, arg : "NonSpare_1290.cv_arg") -> "NonSpare_1290":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_776:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_806:
        return self.rule.variation

class Item_562(Item):
    cv_arg: TypeAlias = NonSpare_1290.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1290

    @classmethod
    def create(cls, arg : "Item_562.cv_arg") -> "Item_562":
        return cls._create(arg) # type: ignore

class Variation_1021(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_776.cv_arg, Tuple[Literal["MOD3A"], RuleVariation_776.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1021.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_3, 4), (Item_562, 12)]
    cv_items_dict = {"MOD3A": RuleVariation_776}

    @classmethod
    def spec(cls, key : Literal["MOD3A"]) -> RuleVariation_776:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["MOD3A"]) -> RuleVariation_776:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1021.cv_arg") -> 'Variation_1021':
        return cls._create(arg) # type: ignore

class RuleVariation_990(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1021.cv_arg
    cv_variation: TypeAlias = Variation_1021

    @classmethod
    def create(cls, arg : "RuleVariation_990.cv_arg") -> "RuleVariation_990":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1021:
        return self.arg # type: ignore

class NonSpare_188(NonSpare):
    cv_arg: TypeAlias = RuleVariation_990.cv_arg
    cv_name = "060"
    cv_title = "Mode-3/A Code in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_990

    @classmethod
    def create(cls, arg : "NonSpare_188.cv_arg") -> "NonSpare_188":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_990:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1021:
        return self.rule.variation

class UapItem_188(UapItem):
    cv_non_spare: TypeAlias = NonSpare_188

class NonSpare_1852(NonSpare):
    cv_arg: TypeAlias = RuleVariation_381.cv_arg
    cv_name = "TID"
    cv_title = "Target Identification"
    cv_rule: TypeAlias = RuleVariation_381

    @classmethod
    def create(cls, arg : "NonSpare_1852.cv_arg") -> "NonSpare_1852":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_381:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_389:
        return self.rule.variation

class Item_994(Item):
    cv_arg: TypeAlias = NonSpare_1852.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1852

    @classmethod
    def create(cls, arg : "Item_994.cv_arg") -> "Item_994":
        return cls._create(arg) # type: ignore

class Variation_1212(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_97.cv_arg, Tuple[Literal["STI"], RuleVariation_97.cv_arg]], int, Union[RuleVariation_381.cv_arg, Tuple[Literal["TID"], RuleVariation_381.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1212.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 56
    cv_items_list = [(Item_946, 2), (Item_15, 6), (Item_994, 48)]
    cv_items_dict = {"STI": RuleVariation_97, "TID": RuleVariation_381}

    @overload
    @classmethod
    def spec(cls, key : Literal["STI"]) -> RuleVariation_97:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TID"]) -> RuleVariation_381:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["STI"], Literal["TID"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["STI"]) -> RuleVariation_97:
        ...
    @overload
    def get_item(self, key : Literal["TID"]) -> RuleVariation_381:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1212.cv_arg") -> 'Variation_1212':
        return cls._create(arg) # type: ignore

class RuleVariation_1156(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1212.cv_arg
    cv_variation: TypeAlias = Variation_1212

    @classmethod
    def create(cls, arg : "RuleVariation_1156.cv_arg") -> "RuleVariation_1156":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1212:
        return self.arg # type: ignore

class NonSpare_437(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1156.cv_arg
    cv_name = "245"
    cv_title = "Target Identification"
    cv_rule: TypeAlias = RuleVariation_1156

    @classmethod
    def create(cls, arg : "NonSpare_437.cv_arg") -> "NonSpare_437":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1156:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1212:
        return self.rule.variation

class UapItem_437(UapItem):
    cv_non_spare: TypeAlias = NonSpare_437

class Content_795(ContentBds):
    cv_arg: TypeAlias = int
    cv_bds_type = BdsWithAddress

class RuleContent_794(RuleContentContextFree):
    cv_arg: TypeAlias = Content_795.cv_arg
    cv_content: TypeAlias = Content_795

    @property
    def content(self) -> Content_795:
        return self._get_content() # type: ignore

class Variation_394(Element):
    cv_arg: TypeAlias = RuleContent_794.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 64
    cv_rule = RuleContent_794

    @classmethod
    def create(cls, arg: "Variation_394.cv_arg") -> "Variation_394":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_794:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_795:
        return self.rule.content

class Variation_1396(Repetitive):
    cv_arg: TypeAlias = List[Variation_394.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_394

    @classmethod
    def create(cls, arg: "Variation_1396.cv_arg") -> 'Variation_1396':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_394]:
        return self._get_list() # type: ignore

class RuleVariation_1318(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1396.cv_arg
    cv_variation: TypeAlias = Variation_1396

    @classmethod
    def create(cls, arg : "RuleVariation_1318.cv_arg") -> "RuleVariation_1318":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1396:
        return self.arg # type: ignore

class NonSpare_1222(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1318.cv_arg
    cv_name = "MB"
    cv_title = "BDS"
    cv_rule: TypeAlias = RuleVariation_1318

    @classmethod
    def create(cls, arg : "NonSpare_1222.cv_arg") -> "NonSpare_1222":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1318:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1396:
        return self.rule.variation

class NonSpare_566(NonSpare):
    cv_arg: TypeAlias = RuleVariation_340.cv_arg
    cv_name = "ADR"
    cv_title = "24 Bits Aircraft Address"
    cv_rule: TypeAlias = RuleVariation_340

    @classmethod
    def create(cls, arg : "NonSpare_566.cv_arg") -> "NonSpare_566":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_340:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_347:
        return self.rule.variation

class Content_337(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No communications capability (surveillance only)", 1: "Comm. A and Comm. B capability", 2: "Comm. A, Comm. B and Uplink ELM", 3: "Comm. A, Comm. B, Uplink ELM and Downlink ELM", 4: "Level 5 Transponder capability", 5: "Not assigned", 6: "Not assigned", 7: "Not assigned"}

class RuleContent_337(RuleContentContextFree):
    cv_arg: TypeAlias = Content_337.cv_arg
    cv_content: TypeAlias = Content_337

    @property
    def content(self) -> Content_337:
        return self._get_content() # type: ignore

class Variation_123(Element):
    cv_arg: TypeAlias = RuleContent_337.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 3
    cv_rule = RuleContent_337

    @classmethod
    def create(cls, arg: "Variation_123.cv_arg") -> "Variation_123":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_337:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_337:
        return self.rule.content

class RuleVariation_123(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_123.cv_arg
    cv_variation: TypeAlias = Variation_123

    @classmethod
    def create(cls, arg : "RuleVariation_123.cv_arg") -> "RuleVariation_123":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_123:
        return self.arg # type: ignore

class NonSpare_778(NonSpare):
    cv_arg: TypeAlias = RuleVariation_123.cv_arg
    cv_name = "COM"
    cv_title = "Communications Capability of the Transponder"
    cv_rule: TypeAlias = RuleVariation_123

    @classmethod
    def create(cls, arg : "NonSpare_778.cv_arg") -> "NonSpare_778":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_123:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_123:
        return self.rule.variation

class Item_187(Item):
    cv_arg: TypeAlias = NonSpare_778.cv_arg
    cv_non_spare: TypeAlias = NonSpare_778

    @classmethod
    def create(cls, arg : "Item_187.cv_arg") -> "Item_187":
        return cls._create(arg) # type: ignore

class Content_318(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No alert, no SPI, aircraft airborne", 1: "No alert, no SPI, aircraft on ground", 2: "Alert, no SPI, aircraft airborne", 3: "Alert, no SPI, aircraft on ground", 4: "Alert, SPI, aircraft airborne or on ground", 5: "No alert, SPI, aircraft airborne or on ground", 6: "General Emergency", 7: "Lifeguard / medical", 8: "Minimum fuel", 9: "No communications", 10: "Unlawful"}

class RuleContent_318(RuleContentContextFree):
    cv_arg: TypeAlias = Content_318.cv_arg
    cv_content: TypeAlias = Content_318

    @property
    def content(self) -> Content_318:
        return self._get_content() # type: ignore

class Variation_689(Element):
    cv_arg: TypeAlias = RuleContent_318.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 4
    cv_rule = RuleContent_318

    @classmethod
    def create(cls, arg: "Variation_689.cv_arg") -> "Variation_689":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_318:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_318:
        return self.rule.content

class RuleVariation_678(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_689.cv_arg
    cv_variation: TypeAlias = Variation_689

    @classmethod
    def create(cls, arg : "RuleVariation_678.cv_arg") -> "RuleVariation_678":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_689:
        return self.arg # type: ignore

class NonSpare_1768(NonSpare):
    cv_arg: TypeAlias = RuleVariation_678.cv_arg
    cv_name = "STAT"
    cv_title = "Flight Status"
    cv_rule: TypeAlias = RuleVariation_678

    @classmethod
    def create(cls, arg : "NonSpare_1768.cv_arg") -> "NonSpare_1768":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_678:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_689:
        return self.rule.variation

class Item_935(Item):
    cv_arg: TypeAlias = NonSpare_1768.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1768

    @classmethod
    def create(cls, arg : "Item_935.cv_arg") -> "Item_935":
        return cls._create(arg) # type: ignore

class Content_302(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No", 1: "Yes"}

class RuleContent_302(RuleContentContextFree):
    cv_arg: TypeAlias = Content_302.cv_arg
    cv_content: TypeAlias = Content_302

    @property
    def content(self) -> Content_302:
        return self._get_content() # type: ignore

class Variation_55(Element):
    cv_arg: TypeAlias = RuleContent_302.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_302

    @classmethod
    def create(cls, arg: "Variation_55.cv_arg") -> "Variation_55":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_302:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_302:
        return self.rule.content

class RuleVariation_55(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_55.cv_arg
    cv_variation: TypeAlias = Variation_55

    @classmethod
    def create(cls, arg : "RuleVariation_55.cv_arg") -> "RuleVariation_55":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_55:
        return self.arg # type: ignore

class NonSpare_1745(NonSpare):
    cv_arg: TypeAlias = RuleVariation_55.cv_arg
    cv_name = "SSC"
    cv_title = "Specific Service Capability"
    cv_rule: TypeAlias = RuleVariation_55

    @classmethod
    def create(cls, arg : "NonSpare_1745.cv_arg") -> "NonSpare_1745":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_55:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_55:
        return self.rule.variation

class Item_921(Item):
    cv_arg: TypeAlias = NonSpare_1745.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1745

    @classmethod
    def create(cls, arg : "Item_921.cv_arg") -> "Item_921":
        return cls._create(arg) # type: ignore

class Content_3(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "100 ft resolution", 1: "25 ft resolution"}

class RuleContent_3(RuleContentContextFree):
    cv_arg: TypeAlias = Content_3.cv_arg
    cv_content: TypeAlias = Content_3

    @property
    def content(self) -> Content_3:
        return self._get_content() # type: ignore

class Variation_399(Element):
    cv_arg: TypeAlias = RuleContent_3.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_3

    @classmethod
    def create(cls, arg: "Variation_399.cv_arg") -> "Variation_399":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_3:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_3:
        return self.rule.content

class RuleVariation_388(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_399.cv_arg
    cv_variation: TypeAlias = Variation_399

    @classmethod
    def create(cls, arg : "RuleVariation_388.cv_arg") -> "RuleVariation_388":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_399:
        return self.arg # type: ignore

class NonSpare_621(NonSpare):
    cv_arg: TypeAlias = RuleVariation_388.cv_arg
    cv_name = "ARC"
    cv_title = "Altitude Reporting Capability"
    cv_rule: TypeAlias = RuleVariation_388

    @classmethod
    def create(cls, arg : "NonSpare_621.cv_arg") -> "NonSpare_621":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_388:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_399:
        return self.rule.variation

class Item_81(Item):
    cv_arg: TypeAlias = NonSpare_621.cv_arg
    cv_non_spare: TypeAlias = NonSpare_621

    @classmethod
    def create(cls, arg : "Item_81.cv_arg") -> "Item_81":
        return cls._create(arg) # type: ignore

class Variation_555(Element):
    cv_arg: TypeAlias = RuleContent_302.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_302

    @classmethod
    def create(cls, arg: "Variation_555.cv_arg") -> "Variation_555":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_302:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_302:
        return self.rule.content

class RuleVariation_544(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_555.cv_arg
    cv_variation: TypeAlias = Variation_555

    @classmethod
    def create(cls, arg : "RuleVariation_544.cv_arg") -> "RuleVariation_544":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_555:
        return self.arg # type: ignore

class NonSpare_583(NonSpare):
    cv_arg: TypeAlias = RuleVariation_544.cv_arg
    cv_name = "AIC"
    cv_title = "Aircraft Identification Capability"
    cv_rule: TypeAlias = RuleVariation_544

    @classmethod
    def create(cls, arg : "NonSpare_583.cv_arg") -> "NonSpare_583":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_544:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_555:
        return self.rule.variation

class Item_55(Item):
    cv_arg: TypeAlias = NonSpare_583.cv_arg
    cv_non_spare: TypeAlias = NonSpare_583

    @classmethod
    def create(cls, arg : "Item_55.cv_arg") -> "Item_55":
        return cls._create(arg) # type: ignore

class NonSpare_663(NonSpare):
    cv_arg: TypeAlias = RuleVariation_600.cv_arg
    cv_name = "B1A"
    cv_title = "BDS 1,0 Bit 16"
    cv_rule: TypeAlias = RuleVariation_600

    @classmethod
    def create(cls, arg : "NonSpare_663.cv_arg") -> "NonSpare_663":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_600:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_611:
        return self.rule.variation

class Item_108(Item):
    cv_arg: TypeAlias = NonSpare_663.cv_arg
    cv_non_spare: TypeAlias = NonSpare_663

    @classmethod
    def create(cls, arg : "Item_108.cv_arg") -> "Item_108":
        return cls._create(arg) # type: ignore

class NonSpare_664(NonSpare):
    cv_arg: TypeAlias = RuleVariation_766.cv_arg
    cv_name = "B1B"
    cv_title = "BDS 1,0 Bit 37/40"
    cv_rule: TypeAlias = RuleVariation_766

    @classmethod
    def create(cls, arg : "NonSpare_664.cv_arg") -> "NonSpare_664":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_766:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_796:
        return self.rule.variation

class Item_109(Item):
    cv_arg: TypeAlias = NonSpare_664.cv_arg
    cv_non_spare: TypeAlias = NonSpare_664

    @classmethod
    def create(cls, arg : "Item_109.cv_arg") -> "Item_109":
        return cls._create(arg) # type: ignore

class NonSpare_550(NonSpare):
    cv_arg: TypeAlias = RuleVariation_55.cv_arg
    cv_name = "AC"
    cv_title = "ACAS Operational"
    cv_rule: TypeAlias = RuleVariation_55

    @classmethod
    def create(cls, arg : "NonSpare_550.cv_arg") -> "NonSpare_550":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_55:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_55:
        return self.rule.variation

class Item_37(Item):
    cv_arg: TypeAlias = NonSpare_550.cv_arg
    cv_non_spare: TypeAlias = NonSpare_550

    @classmethod
    def create(cls, arg : "Item_37.cv_arg") -> "Item_37":
        return cls._create(arg) # type: ignore

class Variation_437(Element):
    cv_arg: TypeAlias = RuleContent_302.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_302

    @classmethod
    def create(cls, arg: "Variation_437.cv_arg") -> "Variation_437":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_302:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_302:
        return self.rule.content

class RuleVariation_426(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_437.cv_arg
    cv_variation: TypeAlias = Variation_437

    @classmethod
    def create(cls, arg : "RuleVariation_426.cv_arg") -> "RuleVariation_426":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_437:
        return self.arg # type: ignore

class NonSpare_1287(NonSpare):
    cv_arg: TypeAlias = RuleVariation_426.cv_arg
    cv_name = "MN"
    cv_title = "Multiple Navigational Aids Operating"
    cv_rule: TypeAlias = RuleVariation_426

    @classmethod
    def create(cls, arg : "NonSpare_1287.cv_arg") -> "NonSpare_1287":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_426:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_437:
        return self.rule.variation

class Item_559(Item):
    cv_arg: TypeAlias = NonSpare_1287.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1287

    @classmethod
    def create(cls, arg : "Item_559.cv_arg") -> "Item_559":
        return cls._create(arg) # type: ignore

class Content_569(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Yes", 1: "No"}

class RuleContent_569(RuleContentContextFree):
    cv_arg: TypeAlias = Content_569.cv_arg
    cv_content: TypeAlias = Content_569

    @property
    def content(self) -> Content_569:
        return self._get_content() # type: ignore

class Variation_582(Element):
    cv_arg: TypeAlias = RuleContent_569.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_569

    @classmethod
    def create(cls, arg: "Variation_582.cv_arg") -> "Variation_582":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_569:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_569:
        return self.rule.content

class RuleVariation_571(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_582.cv_arg
    cv_variation: TypeAlias = Variation_582

    @classmethod
    def create(cls, arg : "RuleVariation_571.cv_arg") -> "RuleVariation_571":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_582:
        return self.arg # type: ignore

class NonSpare_864(NonSpare):
    cv_arg: TypeAlias = RuleVariation_571.cv_arg
    cv_name = "DC"
    cv_title = "Differential Correction"
    cv_rule: TypeAlias = RuleVariation_571

    @classmethod
    def create(cls, arg : "NonSpare_864.cv_arg") -> "NonSpare_864":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_571:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_582:
        return self.rule.variation

class Item_248(Item):
    cv_arg: TypeAlias = NonSpare_864.cv_arg
    cv_non_spare: TypeAlias = NonSpare_864

    @classmethod
    def create(cls, arg : "Item_248.cv_arg") -> "Item_248":
        return cls._create(arg) # type: ignore

class Item_19(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 3
    cv_bit_size = 5

class Variation_1075(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_123.cv_arg, Tuple[Literal["COM"], RuleVariation_123.cv_arg]], Union[RuleVariation_678.cv_arg, Tuple[Literal["STAT"], RuleVariation_678.cv_arg]], int, Union[RuleVariation_55.cv_arg, Tuple[Literal["SSC"], RuleVariation_55.cv_arg]], Union[RuleVariation_388.cv_arg, Tuple[Literal["ARC"], RuleVariation_388.cv_arg]], Union[RuleVariation_544.cv_arg, Tuple[Literal["AIC"], RuleVariation_544.cv_arg]], Union[RuleVariation_600.cv_arg, Tuple[Literal["B1A"], RuleVariation_600.cv_arg]], Union[RuleVariation_766.cv_arg, Tuple[Literal["B1B"], RuleVariation_766.cv_arg]], Union[RuleVariation_55.cv_arg, Tuple[Literal["AC"], RuleVariation_55.cv_arg]], Union[RuleVariation_426.cv_arg, Tuple[Literal["MN"], RuleVariation_426.cv_arg]], Union[RuleVariation_571.cv_arg, Tuple[Literal["DC"], RuleVariation_571.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1075.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_items_list = [(Item_187, 3), (Item_935, 4), (Item_29, 1), (Item_921, 1), (Item_81, 1), (Item_55, 1), (Item_108, 1), (Item_109, 4), (Item_37, 1), (Item_559, 1), (Item_248, 1), (Item_19, 5)]
    cv_items_dict = {"COM": RuleVariation_123, "STAT": RuleVariation_678, "SSC": RuleVariation_55, "ARC": RuleVariation_388, "AIC": RuleVariation_544, "B1A": RuleVariation_600, "B1B": RuleVariation_766, "AC": RuleVariation_55, "MN": RuleVariation_426, "DC": RuleVariation_571}

    @overload
    @classmethod
    def spec(cls, key : Literal["COM"]) -> RuleVariation_123:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["STAT"]) -> RuleVariation_678:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SSC"]) -> RuleVariation_55:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ARC"]) -> RuleVariation_388:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AIC"]) -> RuleVariation_544:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["B1A"]) -> RuleVariation_600:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["B1B"]) -> RuleVariation_766:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AC"]) -> RuleVariation_55:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MN"]) -> RuleVariation_426:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["DC"]) -> RuleVariation_571:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["COM"], Literal["STAT"], Literal["SSC"], Literal["ARC"], Literal["AIC"], Literal["B1A"], Literal["B1B"], Literal["AC"], Literal["MN"], Literal["DC"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["COM"]) -> RuleVariation_123:
        ...
    @overload
    def get_item(self, key : Literal["STAT"]) -> RuleVariation_678:
        ...
    @overload
    def get_item(self, key : Literal["SSC"]) -> RuleVariation_55:
        ...
    @overload
    def get_item(self, key : Literal["ARC"]) -> RuleVariation_388:
        ...
    @overload
    def get_item(self, key : Literal["AIC"]) -> RuleVariation_544:
        ...
    @overload
    def get_item(self, key : Literal["B1A"]) -> RuleVariation_600:
        ...
    @overload
    def get_item(self, key : Literal["B1B"]) -> RuleVariation_766:
        ...
    @overload
    def get_item(self, key : Literal["AC"]) -> RuleVariation_55:
        ...
    @overload
    def get_item(self, key : Literal["MN"]) -> RuleVariation_426:
        ...
    @overload
    def get_item(self, key : Literal["DC"]) -> RuleVariation_571:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1075.cv_arg") -> 'Variation_1075':
        return cls._create(arg) # type: ignore

class RuleVariation_1035(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1075.cv_arg
    cv_variation: TypeAlias = Variation_1075

    @classmethod
    def create(cls, arg : "RuleVariation_1035.cv_arg") -> "RuleVariation_1035":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1075:
        return self.arg # type: ignore

class NonSpare_782(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1035.cv_arg
    cv_name = "COMACAS"
    cv_title = "Communications/ACAS Capability and Flight Status"
    cv_rule: TypeAlias = RuleVariation_1035

    @classmethod
    def create(cls, arg : "NonSpare_782.cv_arg") -> "NonSpare_782":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1035:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1075:
        return self.rule.variation

class Variation_372(Element):
    cv_arg: TypeAlias = RuleContent_606.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_rule = RuleContent_606

    @classmethod
    def create(cls, arg: "Variation_372.cv_arg") -> "Variation_372":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_606:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_606:
        return self.rule.content

class RuleVariation_365(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_372.cv_arg
    cv_variation: TypeAlias = Variation_372

    @classmethod
    def create(cls, arg : "RuleVariation_365.cv_arg") -> "RuleVariation_365":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_372:
        return self.arg # type: ignore

class NonSpare_561(NonSpare):
    cv_arg: TypeAlias = RuleVariation_365.cv_arg
    cv_name = "ACT"
    cv_title = "Aircraft Derived Aircraft Type"
    cv_rule: TypeAlias = RuleVariation_365

    @classmethod
    def create(cls, arg : "NonSpare_561.cv_arg") -> "NonSpare_561":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_365:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_372:
        return self.rule.variation

class Content_578(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Light aircraft <= 7000 kg", 2: "Reserved", 3: "7000 kg &lt; medium aircraft &lt; 136000 kg", 4: "Reserved", 5: "136000 kg <= heavy aircraft", 6: "Highly manoeuvrable (5g acceleration capability) and high speed (&gt;400 knots cruise)", 7: "Reserved", 8: "Reserved", 9: "Reserved", 10: "Rotocraft", 11: "Glider / sailplane", 12: "Lighter-than-air", 13: "Unmanned aerial vehicle", 14: "Space / transatmospheric vehicle", 15: "Ultralight / handglider / paraglider", 16: "Parachutist / skydiver", 17: "Reserved", 18: "Reserved", 19: "Reserved", 20: "Surface emergency vehicle", 21: "Surface service vehicle", 22: "Fixed ground or tethered obstruction", 23: "Reserved", 24: "Reserved"}

class RuleContent_578(RuleContentContextFree):
    cv_arg: TypeAlias = Content_578.cv_arg
    cv_content: TypeAlias = Content_578

    @property
    def content(self) -> Content_578:
        return self._get_content() # type: ignore

class Variation_181(Element):
    cv_arg: TypeAlias = RuleContent_578.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_578

    @classmethod
    def create(cls, arg: "Variation_181.cv_arg") -> "Variation_181":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_578:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_578:
        return self.rule.content

class RuleVariation_174(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_181.cv_arg
    cv_variation: TypeAlias = Variation_181

    @classmethod
    def create(cls, arg : "RuleVariation_174.cv_arg") -> "RuleVariation_174":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_181:
        return self.arg # type: ignore

class NonSpare_911(NonSpare):
    cv_arg: TypeAlias = RuleVariation_174.cv_arg
    cv_name = "ECAT"
    cv_title = "Emitter Category"
    cv_rule: TypeAlias = RuleVariation_174

    @classmethod
    def create(cls, arg : "NonSpare_911.cv_arg") -> "NonSpare_911":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_174:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_181:
        return self.rule.variation

class Content_553(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "VDL Mode 4 available", 1: "VDL Mode 4 not available"}

class RuleContent_553(RuleContentContextFree):
    cv_arg: TypeAlias = Content_553.cv_arg
    cv_content: TypeAlias = Content_553

    @property
    def content(self) -> Content_553:
        return self._get_content() # type: ignore

class Variation_94(Element):
    cv_arg: TypeAlias = RuleContent_553.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_553

    @classmethod
    def create(cls, arg: "Variation_94.cv_arg") -> "Variation_94":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_553:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_553:
        return self.rule.content

class RuleVariation_94(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_94.cv_arg
    cv_variation: TypeAlias = Variation_94

    @classmethod
    def create(cls, arg : "RuleVariation_94.cv_arg") -> "RuleVariation_94":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_94:
        return self.arg # type: ignore

class NonSpare_2018(NonSpare):
    cv_arg: TypeAlias = RuleVariation_94.cv_arg
    cv_name = "VDL"
    cv_title = "VDL Mode 4"
    cv_rule: TypeAlias = RuleVariation_94

    @classmethod
    def create(cls, arg : "NonSpare_2018.cv_arg") -> "NonSpare_2018":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_94:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_94:
        return self.rule.variation

class Item_1133(Item):
    cv_arg: TypeAlias = NonSpare_2018.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2018

    @classmethod
    def create(cls, arg : "Item_1133.cv_arg") -> "Item_1133":
        return cls._create(arg) # type: ignore

class Content_280(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Mode S available", 1: "Mode S not available"}

class RuleContent_280(RuleContentContextFree):
    cv_arg: TypeAlias = Content_280.cv_arg
    cv_content: TypeAlias = Content_280

    @property
    def content(self) -> Content_280:
        return self._get_content() # type: ignore

class Variation_435(Element):
    cv_arg: TypeAlias = RuleContent_280.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_280

    @classmethod
    def create(cls, arg: "Variation_435.cv_arg") -> "Variation_435":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_280:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_280:
        return self.rule.content

class RuleVariation_424(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_435.cv_arg
    cv_variation: TypeAlias = Variation_435

    @classmethod
    def create(cls, arg : "RuleVariation_424.cv_arg") -> "RuleVariation_424":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_435:
        return self.arg # type: ignore

class NonSpare_1251(NonSpare):
    cv_arg: TypeAlias = RuleVariation_424.cv_arg
    cv_name = "MDS"
    cv_title = "Mode S"
    cv_rule: TypeAlias = RuleVariation_424

    @classmethod
    def create(cls, arg : "NonSpare_1251.cv_arg") -> "NonSpare_1251":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_424:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_435:
        return self.rule.variation

class Item_538(Item):
    cv_arg: TypeAlias = NonSpare_1251.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1251

    @classmethod
    def create(cls, arg : "Item_538.cv_arg") -> "Item_538":
        return cls._create(arg) # type: ignore

class Content_526(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "UAT available", 1: "UAT not available"}

class RuleContent_526(RuleContentContextFree):
    cv_arg: TypeAlias = Content_526.cv_arg
    cv_content: TypeAlias = Content_526

    @property
    def content(self) -> Content_526:
        return self._get_content() # type: ignore

class Variation_580(Element):
    cv_arg: TypeAlias = RuleContent_526.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_526

    @classmethod
    def create(cls, arg: "Variation_580.cv_arg") -> "Variation_580":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_526:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_526:
        return self.rule.content

class RuleVariation_569(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_580.cv_arg
    cv_variation: TypeAlias = Variation_580

    @classmethod
    def create(cls, arg : "RuleVariation_569.cv_arg") -> "RuleVariation_569":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_580:
        return self.arg # type: ignore

class NonSpare_1968(NonSpare):
    cv_arg: TypeAlias = RuleVariation_569.cv_arg
    cv_name = "UAT"
    cv_title = "UAT"
    cv_rule: TypeAlias = RuleVariation_569

    @classmethod
    def create(cls, arg : "NonSpare_1968.cv_arg") -> "NonSpare_1968":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_569:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_580:
        return self.rule.variation

class Item_1086(Item):
    cv_arg: TypeAlias = NonSpare_1968.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1968

    @classmethod
    def create(cls, arg : "Item_1086.cv_arg") -> "Item_1086":
        return cls._create(arg) # type: ignore

class Variation_1272(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_94.cv_arg, Tuple[Literal["VDL"], RuleVariation_94.cv_arg]], Union[RuleVariation_424.cv_arg, Tuple[Literal["MDS"], RuleVariation_424.cv_arg]], Union[RuleVariation_569.cv_arg, Tuple[Literal["UAT"], RuleVariation_569.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1272.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_1133, 1), (Item_538, 1), (Item_1086, 1), (Item_19, 5)]
    cv_items_dict = {"VDL": RuleVariation_94, "MDS": RuleVariation_424, "UAT": RuleVariation_569}

    @overload
    @classmethod
    def spec(cls, key : Literal["VDL"]) -> RuleVariation_94:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MDS"]) -> RuleVariation_424:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["UAT"]) -> RuleVariation_569:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["VDL"], Literal["MDS"], Literal["UAT"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["VDL"]) -> RuleVariation_94:
        ...
    @overload
    def get_item(self, key : Literal["MDS"]) -> RuleVariation_424:
        ...
    @overload
    def get_item(self, key : Literal["UAT"]) -> RuleVariation_569:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1272.cv_arg") -> 'Variation_1272':
        return cls._create(arg) # type: ignore

class RuleVariation_1201(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1272.cv_arg
    cv_variation: TypeAlias = Variation_1272

    @classmethod
    def create(cls, arg : "RuleVariation_1201.cv_arg") -> "RuleVariation_1201":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1272:
        return self.arg # type: ignore

class NonSpare_648(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1201.cv_arg
    cv_name = "AVTECH"
    cv_title = "Available Technologies"
    cv_rule: TypeAlias = RuleVariation_1201

    @classmethod
    def create(cls, arg : "NonSpare_648.cv_arg") -> "NonSpare_648":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1201:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1272:
        return self.rule.variation

class Variation_1485(Compound):
    cv_arg = TypedDict('cv_arg', {
        "MB": NonSpare_1222.cv_arg,
        "ADR": NonSpare_566.cv_arg,
        "COMACAS": NonSpare_782.cv_arg,
        "ACT": NonSpare_561.cv_arg,
        "ECAT": NonSpare_911.cv_arg,
        "AVTECH": NonSpare_648.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 2
    cv_items_list = [NonSpare_1222, NonSpare_566, None, NonSpare_782, None, None, None, NonSpare_561, NonSpare_911, None, NonSpare_648]
    cv_items_dict = {"MB": NonSpare_1222, "ADR": NonSpare_566, "COMACAS": NonSpare_782, "ACT": NonSpare_561, "ECAT": NonSpare_911, "AVTECH": NonSpare_648}

    @overload
    @classmethod
    def spec(cls, key : Literal["MB"]) -> NonSpare_1222:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ADR"]) -> NonSpare_566:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["COMACAS"]) -> NonSpare_782:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ACT"]) -> NonSpare_561:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ECAT"]) -> NonSpare_911:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AVTECH"]) -> NonSpare_648:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["MB"], Literal["ADR"], Literal["COMACAS"], Literal["ACT"], Literal["ECAT"], Literal["AVTECH"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["MB"]) -> Optional[NonSpare_1222]:
        ...
    @overload
    def get_item(self, key : Literal["ADR"]) -> Optional[NonSpare_566]:
        ...
    @overload
    def get_item(self, key : Literal["COMACAS"]) -> Optional[NonSpare_782]:
        ...
    @overload
    def get_item(self, key : Literal["ACT"]) -> Optional[NonSpare_561]:
        ...
    @overload
    def get_item(self, key : Literal["ECAT"]) -> Optional[NonSpare_911]:
        ...
    @overload
    def get_item(self, key : Literal["AVTECH"]) -> Optional[NonSpare_648]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["MB"], val : NonSpare_1222.cv_arg) -> "Variation_1485":
        ...
    @overload
    def set_item(self, key : Literal["ADR"], val : NonSpare_566.cv_arg) -> "Variation_1485":
        ...
    @overload
    def set_item(self, key : Literal["COMACAS"], val : NonSpare_782.cv_arg) -> "Variation_1485":
        ...
    @overload
    def set_item(self, key : Literal["ACT"], val : NonSpare_561.cv_arg) -> "Variation_1485":
        ...
    @overload
    def set_item(self, key : Literal["ECAT"], val : NonSpare_911.cv_arg) -> "Variation_1485":
        ...
    @overload
    def set_item(self, key : Literal["AVTECH"], val : NonSpare_648.cv_arg) -> "Variation_1485":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["MB"]) -> "Variation_1485":
        ...
    @overload
    def del_item(self, key : Literal["ADR"]) -> "Variation_1485":
        ...
    @overload
    def del_item(self, key : Literal["COMACAS"]) -> "Variation_1485":
        ...
    @overload
    def del_item(self, key : Literal["ACT"]) -> "Variation_1485":
        ...
    @overload
    def del_item(self, key : Literal["ECAT"]) -> "Variation_1485":
        ...
    @overload
    def del_item(self, key : Literal["AVTECH"]) -> "Variation_1485":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1485.cv_arg") -> 'Variation_1485':
        return cls._create(arg) # type: ignore

class RuleVariation_1407(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1485.cv_arg
    cv_variation: TypeAlias = Variation_1485

    @classmethod
    def create(cls, arg : "RuleVariation_1407.cv_arg") -> "RuleVariation_1407":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1485:
        return self.arg # type: ignore

class NonSpare_484(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1407.cv_arg
    cv_name = "380"
    cv_title = "Mode-S / ADS-B Related Data"
    cv_rule: TypeAlias = RuleVariation_1407

    @classmethod
    def create(cls, arg : "NonSpare_484.cv_arg") -> "NonSpare_484":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1407:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1485:
        return self.rule.variation

class UapItem_484(UapItem):
    cv_non_spare: TypeAlias = NonSpare_484

class Item_0(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 0
    cv_bit_size = 1

class Variation_496(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 15
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_496.cv_arg") -> "Variation_496":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_485(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_496.cv_arg
    cv_variation: TypeAlias = Variation_496

    @classmethod
    def create(cls, arg : "RuleVariation_485.cv_arg") -> "RuleVariation_485":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_496:
        return self.arg # type: ignore

class NonSpare_998(NonSpare):
    cv_arg: TypeAlias = RuleVariation_485.cv_arg
    cv_name = "FTN"
    cv_title = "Fusion Track Number"
    cv_rule: TypeAlias = RuleVariation_485

    @classmethod
    def create(cls, arg : "NonSpare_998.cv_arg") -> "NonSpare_998":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_485:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_496:
        return self.rule.variation

class Item_350(Item):
    cv_arg: TypeAlias = NonSpare_998.cv_arg
    cv_non_spare: TypeAlias = NonSpare_998

    @classmethod
    def create(cls, arg : "Item_350.cv_arg") -> "Item_350":
        return cls._create(arg) # type: ignore

class Variation_992(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_485.cv_arg, Tuple[Literal["FTN"], RuleVariation_485.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_992.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_0, 1), (Item_350, 15)]
    cv_items_dict = {"FTN": RuleVariation_485}

    @classmethod
    def spec(cls, key : Literal["FTN"]) -> RuleVariation_485:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["FTN"]) -> RuleVariation_485:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_992.cv_arg") -> 'Variation_992':
        return cls._create(arg) # type: ignore

class RuleVariation_962(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_992.cv_arg
    cv_variation: TypeAlias = Variation_992

    @classmethod
    def create(cls, arg : "RuleVariation_962.cv_arg") -> "RuleVariation_962":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_992:
        return self.arg # type: ignore

class NonSpare_356(NonSpare):
    cv_arg: TypeAlias = RuleVariation_962.cv_arg
    cv_name = "161"
    cv_title = "Track Number"
    cv_rule: TypeAlias = RuleVariation_962

    @classmethod
    def create(cls, arg : "NonSpare_356.cv_arg") -> "NonSpare_356":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_962:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_992:
        return self.rule.variation

class UapItem_356(UapItem):
    cv_non_spare: TypeAlias = NonSpare_356

class Content_296(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Multisensor Track", 1: "Monosensor Track"}

class RuleContent_296(RuleContentContextFree):
    cv_arg: TypeAlias = Content_296.cv_arg
    cv_content: TypeAlias = Content_296

    @property
    def content(self) -> Content_296:
        return self._get_content() # type: ignore

class Variation_53(Element):
    cv_arg: TypeAlias = RuleContent_296.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_296

    @classmethod
    def create(cls, arg: "Variation_53.cv_arg") -> "Variation_53":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_296:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_296:
        return self.rule.content

class RuleVariation_53(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_53.cv_arg
    cv_variation: TypeAlias = Variation_53

    @classmethod
    def create(cls, arg : "RuleVariation_53.cv_arg") -> "RuleVariation_53":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_53:
        return self.arg # type: ignore

class Content_520(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Transponder Ground bit not set or unknown", 1: "Transponder Ground bit set"}

class RuleContent_520(RuleContentContextFree):
    cv_arg: TypeAlias = Content_520.cv_arg
    cv_content: TypeAlias = Content_520

    @property
    def content(self) -> Content_520:
        return self._get_content() # type: ignore

class Variation_459(Element):
    cv_arg: TypeAlias = RuleContent_520.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_520

    @classmethod
    def create(cls, arg: "Variation_459.cv_arg") -> "Variation_459":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_520:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_520:
        return self.rule.content

class RuleVariation_448(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_459.cv_arg
    cv_variation: TypeAlias = Variation_459

    @classmethod
    def create(cls, arg : "RuleVariation_448.cv_arg") -> "RuleVariation_448":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_459:
        return self.arg # type: ignore

class Content_45(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Barometric altitude (Mode C) more reliable", 1: "Geometric altitude more reliable"}

class RuleContent_45(RuleContentContextFree):
    cv_arg: TypeAlias = Content_45.cv_arg
    cv_content: TypeAlias = Content_45

    @property
    def content(self) -> Content_45:
        return self._get_content() # type: ignore

class Variation_508(Element):
    cv_arg: TypeAlias = RuleContent_45.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_45

    @classmethod
    def create(cls, arg: "Variation_508.cv_arg") -> "Variation_508":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_45:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_45:
        return self.rule.content

class RuleVariation_497(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_508.cv_arg
    cv_variation: TypeAlias = Variation_508

    @classmethod
    def create(cls, arg : "RuleVariation_497.cv_arg") -> "RuleVariation_497":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_508:
        return self.arg # type: ignore

class Content_370(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No source", 1: "GPS", 2: "3d radar", 3: "Triangulation", 4: "Height from coverage", 5: "Speed look-up table", 6: "Default height", 7: "Multilateration"}

class RuleContent_370(RuleContentContextFree):
    cv_arg: TypeAlias = Content_370.cv_arg
    cv_content: TypeAlias = Content_370

    @property
    def content(self) -> Content_370:
        return self._get_content() # type: ignore

class Variation_687(Element):
    cv_arg: TypeAlias = RuleContent_370.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 3
    cv_rule = RuleContent_370

    @classmethod
    def create(cls, arg: "Variation_687.cv_arg") -> "Variation_687":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_370:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_370:
        return self.rule.content

class RuleVariation_676(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_687.cv_arg
    cv_variation: TypeAlias = Variation_687

    @classmethod
    def create(cls, arg : "RuleVariation_676.cv_arg") -> "RuleVariation_676":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_687:
        return self.arg # type: ignore

class Content_62(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Confirmed track", 1: "Tentative track"}

class RuleContent_62(RuleContentContextFree):
    cv_arg: TypeAlias = Content_62.cv_arg
    cv_content: TypeAlias = Content_62

    @property
    def content(self) -> Content_62:
        return self._get_content() # type: ignore

class Variation_904(Element):
    cv_arg: TypeAlias = RuleContent_62.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_62

    @classmethod
    def create(cls, arg: "Variation_904.cv_arg") -> "Variation_904":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_62:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_62:
        return self.rule.content

class RuleVariation_874(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_904.cv_arg
    cv_variation: TypeAlias = Variation_904

    @classmethod
    def create(cls, arg : "RuleVariation_874.cv_arg") -> "RuleVariation_874":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_904:
        return self.arg # type: ignore

class Content_17(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Actual Track", 1: "Simulated track"}

class RuleContent_17(RuleContentContextFree):
    cv_arg: TypeAlias = Content_17.cv_arg
    cv_content: TypeAlias = Content_17

    @property
    def content(self) -> Content_17:
        return self._get_content() # type: ignore

class Variation_4(Element):
    cv_arg: TypeAlias = RuleContent_17.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_17

    @classmethod
    def create(cls, arg: "Variation_4.cv_arg") -> "Variation_4":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_17:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_17:
        return self.rule.content

class RuleVariation_4(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_4.cv_arg
    cv_variation: TypeAlias = Variation_4

    @classmethod
    def create(cls, arg : "RuleVariation_4.cv_arg") -> "RuleVariation_4":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_4:
        return self.arg # type: ignore

class Content_195(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default value", 1: "Track service end (i.e. last message transmitted to the user for the track)"}

class RuleContent_195(RuleContentContextFree):
    cv_arg: TypeAlias = Content_195.cv_arg
    cv_content: TypeAlias = Content_195

    @property
    def content(self) -> Content_195:
        return self._get_content() # type: ignore

class Variation_422(Element):
    cv_arg: TypeAlias = RuleContent_195.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_195

    @classmethod
    def create(cls, arg: "Variation_422.cv_arg") -> "Variation_422":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_195:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_195:
        return self.rule.content

class RuleVariation_411(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_422.cv_arg
    cv_variation: TypeAlias = Variation_422

    @classmethod
    def create(cls, arg : "RuleVariation_411.cv_arg") -> "RuleVariation_411":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_422:
        return self.arg # type: ignore

class Content_194(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default value", 1: "Track service begin (i.e. first message transmitted to the user for the track)"}

class RuleContent_194(RuleContentContextFree):
    cv_arg: TypeAlias = Content_194.cv_arg
    cv_content: TypeAlias = Content_194

    @property
    def content(self) -> Content_194:
        return self._get_content() # type: ignore

class Variation_529(Element):
    cv_arg: TypeAlias = RuleContent_194.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_194

    @classmethod
    def create(cls, arg: "Variation_529.cv_arg") -> "Variation_529":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_194:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_194:
        return self.rule.content

class RuleVariation_518(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_529.cv_arg
    cv_variation: TypeAlias = Variation_529

    @classmethod
    def create(cls, arg : "RuleVariation_518.cv_arg") -> "RuleVariation_518":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_529:
        return self.arg # type: ignore

class Content_309(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No Mode 4 interrogationt", 1: "Friendly target", 2: "Unknown target", 3: "No reply"}

class RuleContent_309(RuleContentContextFree):
    cv_arg: TypeAlias = Content_309.cv_arg
    cv_content: TypeAlias = Content_309

    @property
    def content(self) -> Content_309:
        return self._get_content() # type: ignore

class Variation_676(Element):
    cv_arg: TypeAlias = RuleContent_309.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 2
    cv_rule = RuleContent_309

    @classmethod
    def create(cls, arg: "Variation_676.cv_arg") -> "Variation_676":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_309:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_309:
        return self.rule.content

class RuleVariation_665(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_676.cv_arg
    cv_variation: TypeAlias = Variation_676

    @classmethod
    def create(cls, arg : "RuleVariation_665.cv_arg") -> "RuleVariation_665":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_676:
        return self.arg # type: ignore

class Content_187(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default value", 1: "Military Emergency present in the last report received from a sensor capable of decoding this data"}

class RuleContent_187(RuleContentContextFree):
    cv_arg: TypeAlias = Content_187.cv_arg
    cv_content: TypeAlias = Content_187

    @property
    def content(self) -> Content_187:
        return self._get_content() # type: ignore

class Variation_842(Element):
    cv_arg: TypeAlias = RuleContent_187.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_187

    @classmethod
    def create(cls, arg: "Variation_842.cv_arg") -> "Variation_842":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_187:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_187:
        return self.rule.content

class RuleVariation_812(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_842.cv_arg
    cv_variation: TypeAlias = Variation_842

    @classmethod
    def create(cls, arg : "RuleVariation_812.cv_arg") -> "RuleVariation_812":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_842:
        return self.arg # type: ignore

class Content_208(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "End of Data Item", 1: "Military Identification present in the last report received from a sensor capable of decoding this data"}

class RuleContent_208(RuleContentContextFree):
    cv_arg: TypeAlias = Content_208.cv_arg
    cv_content: TypeAlias = Content_208

    @property
    def content(self) -> Content_208:
        return self._get_content() # type: ignore

class Variation_923(Element):
    cv_arg: TypeAlias = RuleContent_208.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_208

    @classmethod
    def create(cls, arg: "Variation_923.cv_arg") -> "Variation_923":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_208:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_208:
        return self.rule.content

class RuleVariation_893(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_923.cv_arg
    cv_variation: TypeAlias = Variation_923

    @classmethod
    def create(cls, arg : "RuleVariation_893.cv_arg") -> "RuleVariation_893":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_923:
        return self.arg # type: ignore

class Content_511(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Track not resulting from amalgamation process", 1: "Track resulting from amalgamation process"}

class RuleContent_511(RuleContentContextFree):
    cv_arg: TypeAlias = Content_511.cv_arg
    cv_content: TypeAlias = Content_511

    @property
    def content(self) -> Content_511:
        return self._get_content() # type: ignore

class Variation_89(Element):
    cv_arg: TypeAlias = RuleContent_511.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_511

    @classmethod
    def create(cls, arg: "Variation_89.cv_arg") -> "Variation_89":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_511:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_511:
        return self.rule.content

class RuleVariation_89(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_89.cv_arg
    cv_variation: TypeAlias = Variation_89

    @classmethod
    def create(cls, arg : "RuleVariation_89.cv_arg") -> "RuleVariation_89":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_89:
        return self.arg # type: ignore

class Content_189(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default value", 1: "SPI present in the last report received from a sensor capable of decoding this data"}

class RuleContent_189(RuleContentContextFree):
    cv_arg: TypeAlias = Content_189.cv_arg
    cv_content: TypeAlias = Content_189

    @property
    def content(self) -> Content_189:
        return self._get_content() # type: ignore

class Variation_421(Element):
    cv_arg: TypeAlias = RuleContent_189.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_189

    @classmethod
    def create(cls, arg: "Variation_421.cv_arg") -> "Variation_421":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_189:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_189:
        return self.rule.content

class RuleVariation_410(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_421.cv_arg
    cv_variation: TypeAlias = Variation_421

    @classmethod
    def create(cls, arg : "RuleVariation_410.cv_arg") -> "RuleVariation_410":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_421:
        return self.arg # type: ignore

class Content_178(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default value", 1: "Age of the last received track update is higher than system dependent threshold (coasting)"}

class RuleContent_178(RuleContentContextFree):
    cv_arg: TypeAlias = Content_178.cv_arg
    cv_content: TypeAlias = Content_178

    @property
    def content(self) -> Content_178:
        return self._get_content() # type: ignore

class Variation_526(Element):
    cv_arg: TypeAlias = RuleContent_178.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_178

    @classmethod
    def create(cls, arg: "Variation_526.cv_arg") -> "Variation_526":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_178:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_178:
        return self.rule.content

class RuleVariation_515(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_526.cv_arg
    cv_variation: TypeAlias = Variation_526

    @classmethod
    def create(cls, arg : "RuleVariation_515.cv_arg") -> "RuleVariation_515":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_526:
        return self.arg # type: ignore

class Content_397(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Not flight-plan correlated", 1: "Flight plan correlated"}

class RuleContent_397(RuleContentContextFree):
    cv_arg: TypeAlias = Content_397.cv_arg
    cv_content: TypeAlias = Content_397

    @property
    def content(self) -> Content_397:
        return self._get_content() # type: ignore

class Variation_655(Element):
    cv_arg: TypeAlias = RuleContent_397.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_397

    @classmethod
    def create(cls, arg: "Variation_655.cv_arg") -> "Variation_655":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_397:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_397:
        return self.rule.content

class RuleVariation_644(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_655.cv_arg
    cv_variation: TypeAlias = Variation_655

    @classmethod
    def create(cls, arg : "RuleVariation_644.cv_arg") -> "RuleVariation_644":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_655:
        return self.arg # type: ignore

class Content_171(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default value", 1: "ADS-B data inconsistent with other surveillance information"}

class RuleContent_171(RuleContentContextFree):
    cv_arg: TypeAlias = Content_171.cv_arg
    cv_content: TypeAlias = Content_171

    @property
    def content(self) -> Content_171:
        return self._get_content() # type: ignore

class Variation_713(Element):
    cv_arg: TypeAlias = RuleContent_171.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_171

    @classmethod
    def create(cls, arg: "Variation_713.cv_arg") -> "Variation_713":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_171:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_171:
        return self.rule.content

class RuleVariation_702(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_713.cv_arg
    cv_variation: TypeAlias = Variation_713

    @classmethod
    def create(cls, arg : "RuleVariation_702.cv_arg") -> "RuleVariation_702":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_713:
        return self.arg # type: ignore

class NonSpare_1303(NonSpare):
    cv_arg: TypeAlias = RuleVariation_53.cv_arg
    cv_name = "MON"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_53

    @classmethod
    def create(cls, arg : "NonSpare_1303.cv_arg") -> "NonSpare_1303":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_53:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_53:
        return self.rule.variation

class Item_575(Item):
    cv_arg: TypeAlias = NonSpare_1303.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1303

    @classmethod
    def create(cls, arg : "Item_575.cv_arg") -> "Item_575":
        return cls._create(arg) # type: ignore

class NonSpare_1019(NonSpare):
    cv_arg: TypeAlias = RuleVariation_448.cv_arg
    cv_name = "GBS"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_448

    @classmethod
    def create(cls, arg : "NonSpare_1019.cv_arg") -> "NonSpare_1019":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_448:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_459:
        return self.rule.variation

class Item_363(Item):
    cv_arg: TypeAlias = NonSpare_1019.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1019

    @classmethod
    def create(cls, arg : "Item_363.cv_arg") -> "Item_363":
        return cls._create(arg) # type: ignore

class NonSpare_1306(NonSpare):
    cv_arg: TypeAlias = RuleVariation_497.cv_arg
    cv_name = "MRH"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_497

    @classmethod
    def create(cls, arg : "NonSpare_1306.cv_arg") -> "NonSpare_1306":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_497:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_508:
        return self.rule.variation

class Item_578(Item):
    cv_arg: TypeAlias = NonSpare_1306.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1306

    @classmethod
    def create(cls, arg : "Item_578.cv_arg") -> "Item_578":
        return cls._create(arg) # type: ignore

class NonSpare_1737(NonSpare):
    cv_arg: TypeAlias = RuleVariation_676.cv_arg
    cv_name = "SRC"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_676

    @classmethod
    def create(cls, arg : "NonSpare_1737.cv_arg") -> "NonSpare_1737":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_676:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_687:
        return self.rule.variation

class Item_916(Item):
    cv_arg: TypeAlias = NonSpare_1737.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1737

    @classmethod
    def create(cls, arg : "Item_916.cv_arg") -> "Item_916":
        return cls._create(arg) # type: ignore

class NonSpare_742(NonSpare):
    cv_arg: TypeAlias = RuleVariation_874.cv_arg
    cv_name = "CNF"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_874

    @classmethod
    def create(cls, arg : "NonSpare_742.cv_arg") -> "NonSpare_742":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_874:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_904:
        return self.rule.variation

class Item_166(Item):
    cv_arg: TypeAlias = NonSpare_742.cv_arg
    cv_non_spare: TypeAlias = NonSpare_742

    @classmethod
    def create(cls, arg : "Item_166.cv_arg") -> "Item_166":
        return cls._create(arg) # type: ignore

class NonSpare_1711(NonSpare):
    cv_arg: TypeAlias = RuleVariation_4.cv_arg
    cv_name = "SIM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_4

    @classmethod
    def create(cls, arg : "NonSpare_1711.cv_arg") -> "NonSpare_1711":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_4:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_4:
        return self.rule.variation

class Item_892(Item):
    cv_arg: TypeAlias = NonSpare_1711.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1711

    @classmethod
    def create(cls, arg : "Item_892.cv_arg") -> "Item_892":
        return cls._create(arg) # type: ignore

class NonSpare_1919(NonSpare):
    cv_arg: TypeAlias = RuleVariation_411.cv_arg
    cv_name = "TSE"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_411

    @classmethod
    def create(cls, arg : "NonSpare_1919.cv_arg") -> "NonSpare_1919":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_411:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_422:
        return self.rule.variation

class Item_1042(Item):
    cv_arg: TypeAlias = NonSpare_1919.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1919

    @classmethod
    def create(cls, arg : "Item_1042.cv_arg") -> "Item_1042":
        return cls._create(arg) # type: ignore

class NonSpare_1917(NonSpare):
    cv_arg: TypeAlias = RuleVariation_518.cv_arg
    cv_name = "TSB"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_518

    @classmethod
    def create(cls, arg : "NonSpare_1917.cv_arg") -> "NonSpare_1917":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_518:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_529:
        return self.rule.variation

class Item_1040(Item):
    cv_arg: TypeAlias = NonSpare_1917.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1917

    @classmethod
    def create(cls, arg : "Item_1040.cv_arg") -> "Item_1040":
        return cls._create(arg) # type: ignore

class NonSpare_988(NonSpare):
    cv_arg: TypeAlias = RuleVariation_665.cv_arg
    cv_name = "FRIFOE"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_665

    @classmethod
    def create(cls, arg : "NonSpare_988.cv_arg") -> "NonSpare_988":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_665:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_676:
        return self.rule.variation

class Item_343(Item):
    cv_arg: TypeAlias = NonSpare_988.cv_arg
    cv_non_spare: TypeAlias = NonSpare_988

    @classmethod
    def create(cls, arg : "Item_343.cv_arg") -> "Item_343":
        return cls._create(arg) # type: ignore

class NonSpare_1259(NonSpare):
    cv_arg: TypeAlias = RuleVariation_812.cv_arg
    cv_name = "ME"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_812

    @classmethod
    def create(cls, arg : "NonSpare_1259.cv_arg") -> "NonSpare_1259":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_812:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_842:
        return self.rule.variation

class Item_543(Item):
    cv_arg: TypeAlias = NonSpare_1259.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1259

    @classmethod
    def create(cls, arg : "Item_543.cv_arg") -> "Item_543":
        return cls._create(arg) # type: ignore

class NonSpare_1277(NonSpare):
    cv_arg: TypeAlias = RuleVariation_893.cv_arg
    cv_name = "MI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_893

    @classmethod
    def create(cls, arg : "NonSpare_1277.cv_arg") -> "NonSpare_1277":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_893:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_923:
        return self.rule.variation

class Item_550(Item):
    cv_arg: TypeAlias = NonSpare_1277.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1277

    @classmethod
    def create(cls, arg : "Item_550.cv_arg") -> "Item_550":
        return cls._create(arg) # type: ignore

class NonSpare_602(NonSpare):
    cv_arg: TypeAlias = RuleVariation_89.cv_arg
    cv_name = "AMA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_89

    @classmethod
    def create(cls, arg : "NonSpare_602.cv_arg") -> "NonSpare_602":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_89:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_89:
        return self.rule.variation

class Item_71(Item):
    cv_arg: TypeAlias = NonSpare_602.cv_arg
    cv_non_spare: TypeAlias = NonSpare_602

    @classmethod
    def create(cls, arg : "Item_71.cv_arg") -> "Item_71":
        return cls._create(arg) # type: ignore

class NonSpare_1727(NonSpare):
    cv_arg: TypeAlias = RuleVariation_410.cv_arg
    cv_name = "SPI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_410

    @classmethod
    def create(cls, arg : "NonSpare_1727.cv_arg") -> "NonSpare_1727":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_410:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_421:
        return self.rule.variation

class Item_906(Item):
    cv_arg: TypeAlias = NonSpare_1727.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1727

    @classmethod
    def create(cls, arg : "Item_906.cv_arg") -> "Item_906":
        return cls._create(arg) # type: ignore

class NonSpare_831(NonSpare):
    cv_arg: TypeAlias = RuleVariation_515.cv_arg
    cv_name = "CST"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_515

    @classmethod
    def create(cls, arg : "NonSpare_831.cv_arg") -> "NonSpare_831":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_515:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_526:
        return self.rule.variation

class Item_220(Item):
    cv_arg: TypeAlias = NonSpare_831.cv_arg
    cv_non_spare: TypeAlias = NonSpare_831

    @classmethod
    def create(cls, arg : "Item_220.cv_arg") -> "Item_220":
        return cls._create(arg) # type: ignore

class NonSpare_980(NonSpare):
    cv_arg: TypeAlias = RuleVariation_644.cv_arg
    cv_name = "FPC"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_644

    @classmethod
    def create(cls, arg : "NonSpare_980.cv_arg") -> "NonSpare_980":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_644:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_655:
        return self.rule.variation

class Item_336(Item):
    cv_arg: TypeAlias = NonSpare_980.cv_arg
    cv_non_spare: TypeAlias = NonSpare_980

    @classmethod
    def create(cls, arg : "Item_336.cv_arg") -> "Item_336":
        return cls._create(arg) # type: ignore

class NonSpare_575(NonSpare):
    cv_arg: TypeAlias = RuleVariation_702.cv_arg
    cv_name = "AFF"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_702

    @classmethod
    def create(cls, arg : "NonSpare_575.cv_arg") -> "NonSpare_575":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_702:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_713:
        return self.rule.variation

class Item_50(Item):
    cv_arg: TypeAlias = NonSpare_575.cv_arg
    cv_non_spare: TypeAlias = NonSpare_575

    @classmethod
    def create(cls, arg : "Item_50.cv_arg") -> "Item_50":
        return cls._create(arg) # type: ignore

class Variation_1359(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_53.cv_arg, Tuple[Literal["MON"], RuleVariation_53.cv_arg]], Union[RuleVariation_448.cv_arg, Tuple[Literal["GBS"], RuleVariation_448.cv_arg]], Union[RuleVariation_497.cv_arg, Tuple[Literal["MRH"], RuleVariation_497.cv_arg]], Union[RuleVariation_676.cv_arg, Tuple[Literal["SRC"], RuleVariation_676.cv_arg]], Union[RuleVariation_874.cv_arg, Tuple[Literal["CNF"], RuleVariation_874.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_4.cv_arg, Tuple[Literal["SIM"], RuleVariation_4.cv_arg]], Union[RuleVariation_411.cv_arg, Tuple[Literal["TSE"], RuleVariation_411.cv_arg]], Union[RuleVariation_518.cv_arg, Tuple[Literal["TSB"], RuleVariation_518.cv_arg]], Union[RuleVariation_665.cv_arg, Tuple[Literal["FRIFOE"], RuleVariation_665.cv_arg]], Union[RuleVariation_812.cv_arg, Tuple[Literal["ME"], RuleVariation_812.cv_arg]], Union[RuleVariation_893.cv_arg, Tuple[Literal["MI"], RuleVariation_893.cv_arg]], None]]
    cv_arg_group_3: TypeAlias = Union[int, Tuple[Union[RuleVariation_89.cv_arg, Tuple[Literal["AMA"], RuleVariation_89.cv_arg]], Union[RuleVariation_410.cv_arg, Tuple[Literal["SPI"], RuleVariation_410.cv_arg]], Union[RuleVariation_515.cv_arg, Tuple[Literal["CST"], RuleVariation_515.cv_arg]], Union[RuleVariation_644.cv_arg, Tuple[Literal["FPC"], RuleVariation_644.cv_arg]], Union[RuleVariation_702.cv_arg, Tuple[Literal["AFF"], RuleVariation_702.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1359.cv_arg_group_1"],
        Tuple["Variation_1359.cv_arg_group_1", "Variation_1359.cv_arg_group_2"],
        Tuple["Variation_1359.cv_arg_group_1", "Variation_1359.cv_arg_group_2", "Variation_1359.cv_arg_group_3"],
    ]
    cv_items_list = [[(Item_575, 1), (Item_363, 1), (Item_578, 1), (Item_916, 3), (Item_166, 1), None], [(Item_892, 1), (Item_1042, 1), (Item_1040, 1), (Item_343, 2), (Item_543, 1), (Item_550, 1), None], [(Item_71, 1), (Item_906, 1), (Item_220, 1), (Item_336, 1), (Item_50, 1), (Item_24, 2), None]]

    @classmethod
    def create(cls, arg: "Variation_1359.cv_arg") -> 'Variation_1359':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["MON"]) -> RuleVariation_53:
        ...
    @overload
    def get_item(self, key : Literal["GBS"]) -> RuleVariation_448:
        ...
    @overload
    def get_item(self, key : Literal["MRH"]) -> RuleVariation_497:
        ...
    @overload
    def get_item(self, key : Literal["SRC"]) -> RuleVariation_676:
        ...
    @overload
    def get_item(self, key : Literal["CNF"]) -> RuleVariation_874:
        ...
    @overload
    def get_item(self, key : Literal["SIM"]) -> Optional[RuleVariation_4]:
        ...
    @overload
    def get_item(self, key : Literal["TSE"]) -> Optional[RuleVariation_411]:
        ...
    @overload
    def get_item(self, key : Literal["TSB"]) -> Optional[RuleVariation_518]:
        ...
    @overload
    def get_item(self, key : Literal["FRIFOE"]) -> Optional[RuleVariation_665]:
        ...
    @overload
    def get_item(self, key : Literal["ME"]) -> Optional[RuleVariation_812]:
        ...
    @overload
    def get_item(self, key : Literal["MI"]) -> Optional[RuleVariation_893]:
        ...
    @overload
    def get_item(self, key : Literal["AMA"]) -> Optional[RuleVariation_89]:
        ...
    @overload
    def get_item(self, key : Literal["SPI"]) -> Optional[RuleVariation_410]:
        ...
    @overload
    def get_item(self, key : Literal["CST"]) -> Optional[RuleVariation_515]:
        ...
    @overload
    def get_item(self, key : Literal["FPC"]) -> Optional[RuleVariation_644]:
        ...
    @overload
    def get_item(self, key : Literal["AFF"]) -> Optional[RuleVariation_702]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1281(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1359.cv_arg
    cv_variation: TypeAlias = Variation_1359

    @classmethod
    def create(cls, arg : "RuleVariation_1281.cv_arg") -> "RuleVariation_1281":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1359:
        return self.arg # type: ignore

class NonSpare_374(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1281.cv_arg
    cv_name = "170"
    cv_title = "Track Status"
    cv_rule: TypeAlias = RuleVariation_1281

    @classmethod
    def create(cls, arg : "NonSpare_374.cv_arg") -> "NonSpare_374":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1281:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1359:
        return self.rule.variation

class UapItem_374(UapItem):
    cv_non_spare: TypeAlias = NonSpare_374

class Content_756(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["s"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 0.25
    cv_unit = "s"

    def as_quantity(self, cv_unit : Optional[Literal["s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_755(RuleContentContextFree):
    cv_arg: TypeAlias = Content_756.cv_arg
    cv_content: TypeAlias = Content_756

    @property
    def content(self) -> Content_756:
        return self._get_content() # type: ignore

class Variation_233(Element):
    cv_arg: TypeAlias = RuleContent_755.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_755

    @classmethod
    def create(cls, arg: "Variation_233.cv_arg") -> "Variation_233":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_755:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_756:
        return self.rule.content

class RuleVariation_226(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_233.cv_arg
    cv_variation: TypeAlias = Variation_233

    @classmethod
    def create(cls, arg : "RuleVariation_226.cv_arg") -> "RuleVariation_226":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_233:
        return self.arg # type: ignore

class NonSpare_1463(NonSpare):
    cv_arg: TypeAlias = RuleVariation_226.cv_arg
    cv_name = "PSR"
    cv_title = "Age of The Last Primary Detection Used to Update the Track"
    cv_rule: TypeAlias = RuleVariation_226

    @classmethod
    def create(cls, arg : "NonSpare_1463.cv_arg") -> "NonSpare_1463":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_226:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_233:
        return self.rule.variation

class NonSpare_1749(NonSpare):
    cv_arg: TypeAlias = RuleVariation_226.cv_arg
    cv_name = "SSR"
    cv_title = "Age of the Last Secondary Detection Used to Update the Track"
    cv_rule: TypeAlias = RuleVariation_226

    @classmethod
    def create(cls, arg : "NonSpare_1749.cv_arg") -> "NonSpare_1749":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_226:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_233:
        return self.rule.variation

class NonSpare_1243(NonSpare):
    cv_arg: TypeAlias = RuleVariation_226.cv_arg
    cv_name = "MDA"
    cv_title = "Age of the Last Mode A Detection Used to Update the Track"
    cv_rule: TypeAlias = RuleVariation_226

    @classmethod
    def create(cls, arg : "NonSpare_1243.cv_arg") -> "NonSpare_1243":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_226:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_233:
        return self.rule.variation

class NonSpare_1265(NonSpare):
    cv_arg: TypeAlias = RuleVariation_226.cv_arg
    cv_name = "MFL"
    cv_title = "Age of the Last Mode C Detection Used to Update the Track"
    cv_rule: TypeAlias = RuleVariation_226

    @classmethod
    def create(cls, arg : "NonSpare_1265.cv_arg") -> "NonSpare_1265":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_226:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_233:
        return self.rule.variation

class NonSpare_1249(NonSpare):
    cv_arg: TypeAlias = RuleVariation_226.cv_arg
    cv_name = "MDS"
    cv_title = "Age of the Last Mode S Detection Used to Update the Track"
    cv_rule: TypeAlias = RuleVariation_226

    @classmethod
    def create(cls, arg : "NonSpare_1249.cv_arg") -> "NonSpare_1249":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_226:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_233:
        return self.rule.variation

class Variation_324(Element):
    cv_arg: TypeAlias = RuleContent_755.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_755

    @classmethod
    def create(cls, arg: "Variation_324.cv_arg") -> "Variation_324":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_755:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_756:
        return self.rule.content

class RuleVariation_317(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_324.cv_arg
    cv_variation: TypeAlias = Variation_324

    @classmethod
    def create(cls, arg : "RuleVariation_317.cv_arg") -> "RuleVariation_317":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_324:
        return self.arg # type: ignore

class NonSpare_572(NonSpare):
    cv_arg: TypeAlias = RuleVariation_317.cv_arg
    cv_name = "ADS"
    cv_title = "Age of the Last ADS Report Used to Update the Track"
    cv_rule: TypeAlias = RuleVariation_317

    @classmethod
    def create(cls, arg : "NonSpare_572.cv_arg") -> "NonSpare_572":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_317:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_324:
        return self.rule.variation

class NonSpare_562(NonSpare):
    cv_arg: TypeAlias = RuleVariation_226.cv_arg
    cv_name = "ADB"
    cv_title = "Age of the Last ADS-B Report Used to Update the Track"
    cv_rule: TypeAlias = RuleVariation_226

    @classmethod
    def create(cls, arg : "NonSpare_562.cv_arg") -> "NonSpare_562":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_226:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_233:
        return self.rule.variation

class NonSpare_1232(NonSpare):
    cv_arg: TypeAlias = RuleVariation_226.cv_arg
    cv_name = "MD1"
    cv_title = "Age of the Last Valid Mode 1 Used to Update the Track"
    cv_rule: TypeAlias = RuleVariation_226

    @classmethod
    def create(cls, arg : "NonSpare_1232.cv_arg") -> "NonSpare_1232":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_226:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_233:
        return self.rule.variation

class NonSpare_1234(NonSpare):
    cv_arg: TypeAlias = RuleVariation_226.cv_arg
    cv_name = "MD2"
    cv_title = "Age of the Last Mode 2 Used to Update the Track"
    cv_rule: TypeAlias = RuleVariation_226

    @classmethod
    def create(cls, arg : "NonSpare_1234.cv_arg") -> "NonSpare_1234":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_226:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_233:
        return self.rule.variation

class NonSpare_1186(NonSpare):
    cv_arg: TypeAlias = RuleVariation_226.cv_arg
    cv_name = "LOP"
    cv_title = "Age of the Last Magentic Loop Detection"
    cv_rule: TypeAlias = RuleVariation_226

    @classmethod
    def create(cls, arg : "NonSpare_1186.cv_arg") -> "NonSpare_1186":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_226:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_233:
        return self.rule.variation

class NonSpare_1906(NonSpare):
    cv_arg: TypeAlias = RuleVariation_226.cv_arg
    cv_name = "TRK"
    cv_title = "Actual Track Age Since First Occurrence"
    cv_rule: TypeAlias = RuleVariation_226

    @classmethod
    def create(cls, arg : "NonSpare_1906.cv_arg") -> "NonSpare_1906":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_226:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_233:
        return self.rule.variation

class NonSpare_1326(NonSpare):
    cv_arg: TypeAlias = RuleVariation_226.cv_arg
    cv_name = "MUL"
    cv_title = "Age of the Last Multilateration Detection"
    cv_rule: TypeAlias = RuleVariation_226

    @classmethod
    def create(cls, arg : "NonSpare_1326.cv_arg") -> "NonSpare_1326":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_226:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_233:
        return self.rule.variation

class Variation_1491(Compound):
    cv_arg = TypedDict('cv_arg', {
        "PSR": NonSpare_1463.cv_arg,
        "SSR": NonSpare_1749.cv_arg,
        "MDA": NonSpare_1243.cv_arg,
        "MFL": NonSpare_1265.cv_arg,
        "MDS": NonSpare_1249.cv_arg,
        "ADS": NonSpare_572.cv_arg,
        "ADB": NonSpare_562.cv_arg,
        "MD1": NonSpare_1232.cv_arg,
        "MD2": NonSpare_1234.cv_arg,
        "LOP": NonSpare_1186.cv_arg,
        "TRK": NonSpare_1906.cv_arg,
        "MUL": NonSpare_1326.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 2
    cv_items_list = [NonSpare_1463, NonSpare_1749, NonSpare_1243, NonSpare_1265, NonSpare_1249, NonSpare_572, NonSpare_562, NonSpare_1232, NonSpare_1234, NonSpare_1186, NonSpare_1906, NonSpare_1326]
    cv_items_dict = {"PSR": NonSpare_1463, "SSR": NonSpare_1749, "MDA": NonSpare_1243, "MFL": NonSpare_1265, "MDS": NonSpare_1249, "ADS": NonSpare_572, "ADB": NonSpare_562, "MD1": NonSpare_1232, "MD2": NonSpare_1234, "LOP": NonSpare_1186, "TRK": NonSpare_1906, "MUL": NonSpare_1326}

    @overload
    @classmethod
    def spec(cls, key : Literal["PSR"]) -> NonSpare_1463:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SSR"]) -> NonSpare_1749:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MDA"]) -> NonSpare_1243:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MFL"]) -> NonSpare_1265:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MDS"]) -> NonSpare_1249:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ADS"]) -> NonSpare_572:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ADB"]) -> NonSpare_562:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MD1"]) -> NonSpare_1232:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MD2"]) -> NonSpare_1234:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["LOP"]) -> NonSpare_1186:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TRK"]) -> NonSpare_1906:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MUL"]) -> NonSpare_1326:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["PSR"], Literal["SSR"], Literal["MDA"], Literal["MFL"], Literal["MDS"], Literal["ADS"], Literal["ADB"], Literal["MD1"], Literal["MD2"], Literal["LOP"], Literal["TRK"], Literal["MUL"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["PSR"]) -> Optional[NonSpare_1463]:
        ...
    @overload
    def get_item(self, key : Literal["SSR"]) -> Optional[NonSpare_1749]:
        ...
    @overload
    def get_item(self, key : Literal["MDA"]) -> Optional[NonSpare_1243]:
        ...
    @overload
    def get_item(self, key : Literal["MFL"]) -> Optional[NonSpare_1265]:
        ...
    @overload
    def get_item(self, key : Literal["MDS"]) -> Optional[NonSpare_1249]:
        ...
    @overload
    def get_item(self, key : Literal["ADS"]) -> Optional[NonSpare_572]:
        ...
    @overload
    def get_item(self, key : Literal["ADB"]) -> Optional[NonSpare_562]:
        ...
    @overload
    def get_item(self, key : Literal["MD1"]) -> Optional[NonSpare_1232]:
        ...
    @overload
    def get_item(self, key : Literal["MD2"]) -> Optional[NonSpare_1234]:
        ...
    @overload
    def get_item(self, key : Literal["LOP"]) -> Optional[NonSpare_1186]:
        ...
    @overload
    def get_item(self, key : Literal["TRK"]) -> Optional[NonSpare_1906]:
        ...
    @overload
    def get_item(self, key : Literal["MUL"]) -> Optional[NonSpare_1326]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["PSR"], val : NonSpare_1463.cv_arg) -> "Variation_1491":
        ...
    @overload
    def set_item(self, key : Literal["SSR"], val : NonSpare_1749.cv_arg) -> "Variation_1491":
        ...
    @overload
    def set_item(self, key : Literal["MDA"], val : NonSpare_1243.cv_arg) -> "Variation_1491":
        ...
    @overload
    def set_item(self, key : Literal["MFL"], val : NonSpare_1265.cv_arg) -> "Variation_1491":
        ...
    @overload
    def set_item(self, key : Literal["MDS"], val : NonSpare_1249.cv_arg) -> "Variation_1491":
        ...
    @overload
    def set_item(self, key : Literal["ADS"], val : NonSpare_572.cv_arg) -> "Variation_1491":
        ...
    @overload
    def set_item(self, key : Literal["ADB"], val : NonSpare_562.cv_arg) -> "Variation_1491":
        ...
    @overload
    def set_item(self, key : Literal["MD1"], val : NonSpare_1232.cv_arg) -> "Variation_1491":
        ...
    @overload
    def set_item(self, key : Literal["MD2"], val : NonSpare_1234.cv_arg) -> "Variation_1491":
        ...
    @overload
    def set_item(self, key : Literal["LOP"], val : NonSpare_1186.cv_arg) -> "Variation_1491":
        ...
    @overload
    def set_item(self, key : Literal["TRK"], val : NonSpare_1906.cv_arg) -> "Variation_1491":
        ...
    @overload
    def set_item(self, key : Literal["MUL"], val : NonSpare_1326.cv_arg) -> "Variation_1491":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["PSR"]) -> "Variation_1491":
        ...
    @overload
    def del_item(self, key : Literal["SSR"]) -> "Variation_1491":
        ...
    @overload
    def del_item(self, key : Literal["MDA"]) -> "Variation_1491":
        ...
    @overload
    def del_item(self, key : Literal["MFL"]) -> "Variation_1491":
        ...
    @overload
    def del_item(self, key : Literal["MDS"]) -> "Variation_1491":
        ...
    @overload
    def del_item(self, key : Literal["ADS"]) -> "Variation_1491":
        ...
    @overload
    def del_item(self, key : Literal["ADB"]) -> "Variation_1491":
        ...
    @overload
    def del_item(self, key : Literal["MD1"]) -> "Variation_1491":
        ...
    @overload
    def del_item(self, key : Literal["MD2"]) -> "Variation_1491":
        ...
    @overload
    def del_item(self, key : Literal["LOP"]) -> "Variation_1491":
        ...
    @overload
    def del_item(self, key : Literal["TRK"]) -> "Variation_1491":
        ...
    @overload
    def del_item(self, key : Literal["MUL"]) -> "Variation_1491":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1491.cv_arg") -> 'Variation_1491':
        return cls._create(arg) # type: ignore

class RuleVariation_1413(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1491.cv_arg
    cv_variation: TypeAlias = Variation_1491

    @classmethod
    def create(cls, arg : "RuleVariation_1413.cv_arg") -> "RuleVariation_1413":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1491:
        return self.arg # type: ignore

class NonSpare_463(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1413.cv_arg
    cv_name = "290"
    cv_title = "System Track Update Ages"
    cv_rule: TypeAlias = RuleVariation_1413

    @classmethod
    def create(cls, arg : "NonSpare_463.cv_arg") -> "NonSpare_463":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1413:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1491:
        return self.rule.variation

class UapItem_463(UapItem):
    cv_non_spare: TypeAlias = NonSpare_463

class Content_549(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Unknown", 1: "On stand", 2: "Taxiing for departure", 3: "Taxiing for arrival", 4: "Runway for departure", 5: "Runway for arrival", 6: "Hold for departure", 7: "Hold for arrival", 8: "Push back", 9: "On finals"}

class RuleContent_549(RuleContentContextFree):
    cv_arg: TypeAlias = Content_549.cv_arg
    cv_content: TypeAlias = Content_549

    @property
    def content(self) -> Content_549:
        return self._get_content() # type: ignore

class Variation_177(Element):
    cv_arg: TypeAlias = RuleContent_549.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_549

    @classmethod
    def create(cls, arg: "Variation_177.cv_arg") -> "Variation_177":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_549:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_549:
        return self.rule.content

class RuleVariation_170(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_177.cv_arg
    cv_variation: TypeAlias = Variation_177

    @classmethod
    def create(cls, arg : "RuleVariation_170.cv_arg") -> "RuleVariation_170":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_177:
        return self.arg # type: ignore

class NonSpare_501(NonSpare):
    cv_arg: TypeAlias = RuleVariation_170.cv_arg
    cv_name = "430"
    cv_title = "Phase of Flight"
    cv_rule: TypeAlias = RuleVariation_170

    @classmethod
    def create(cls, arg : "NonSpare_501.cv_arg") -> "NonSpare_501":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_170:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_177:
        return self.rule.variation

class UapItem_500(UapItem):
    cv_non_spare: TypeAlias = NonSpare_501

class Content_654(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["FL"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.25
    cv_unit = "FL"

    def as_quantity(self, cv_unit : Optional[Literal["FL"]] = None) -> float:
        return self._as_quantity()

class RuleContent_654(RuleContentContextFree):
    cv_arg: TypeAlias = Content_654.cv_arg
    cv_content: TypeAlias = Content_654

    @property
    def content(self) -> Content_654:
        return self._get_content() # type: ignore

class Variation_272(Element):
    cv_arg: TypeAlias = RuleContent_654.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_654

    @classmethod
    def create(cls, arg: "Variation_272.cv_arg") -> "Variation_272":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_654:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_654:
        return self.rule.content

class RuleVariation_265(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_272.cv_arg
    cv_variation: TypeAlias = Variation_272

    @classmethod
    def create(cls, arg : "RuleVariation_265.cv_arg") -> "RuleVariation_265":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_272:
        return self.arg # type: ignore

class NonSpare_248(NonSpare):
    cv_arg: TypeAlias = RuleVariation_265.cv_arg
    cv_name = "090"
    cv_title = "Measured Flight Level"
    cv_rule: TypeAlias = RuleVariation_265

    @classmethod
    def create(cls, arg : "NonSpare_248.cv_arg") -> "NonSpare_248":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_265:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_272:
        return self.rule.variation

class UapItem_248(UapItem):
    cv_non_spare: TypeAlias = NonSpare_248

class Content_314(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No QNH correction applied", 1: "QNH correction applied"}

class RuleContent_314(RuleContentContextFree):
    cv_arg: TypeAlias = Content_314.cv_arg
    cv_content: TypeAlias = Content_314

    @property
    def content(self) -> Content_314:
        return self._get_content() # type: ignore

class Variation_58(Element):
    cv_arg: TypeAlias = RuleContent_314.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_314

    @classmethod
    def create(cls, arg: "Variation_58.cv_arg") -> "Variation_58":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_314:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_314:
        return self.rule.content

class RuleVariation_58(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_58.cv_arg
    cv_variation: TypeAlias = Variation_58

    @classmethod
    def create(cls, arg : "RuleVariation_58.cv_arg") -> "RuleVariation_58":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_58:
        return self.arg # type: ignore

class NonSpare_1519(NonSpare):
    cv_arg: TypeAlias = RuleVariation_58.cv_arg
    cv_name = "QNH"
    cv_title = "QNH Correction Applied"
    cv_rule: TypeAlias = RuleVariation_58

    @classmethod
    def create(cls, arg : "NonSpare_1519.cv_arg") -> "NonSpare_1519":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_58:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_58:
        return self.rule.variation

class Item_757(Item):
    cv_arg: TypeAlias = NonSpare_1519.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1519

    @classmethod
    def create(cls, arg : "Item_757.cv_arg") -> "Item_757":
        return cls._create(arg) # type: ignore

class Content_652(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["FL"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.25
    cv_unit = "FL"

    def as_quantity(self, cv_unit : Optional[Literal["FL"]] = None) -> float:
        return self._as_quantity()

class RuleContent_652(RuleContentContextFree):
    cv_arg: TypeAlias = Content_652.cv_arg
    cv_content: TypeAlias = Content_652

    @property
    def content(self) -> Content_652:
        return self._get_content() # type: ignore

class Variation_497(Element):
    cv_arg: TypeAlias = RuleContent_652.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 15
    cv_rule = RuleContent_652

    @classmethod
    def create(cls, arg: "Variation_497.cv_arg") -> "Variation_497":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_652:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_652:
        return self.rule.content

class RuleVariation_486(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_497.cv_arg
    cv_variation: TypeAlias = Variation_497

    @classmethod
    def create(cls, arg : "RuleVariation_486.cv_arg") -> "RuleVariation_486":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_497:
        return self.arg # type: ignore

class NonSpare_840(NonSpare):
    cv_arg: TypeAlias = RuleVariation_486.cv_arg
    cv_name = "CTBA"
    cv_title = "Calculated Track Barometric Altitude"
    cv_rule: TypeAlias = RuleVariation_486

    @classmethod
    def create(cls, arg : "NonSpare_840.cv_arg") -> "NonSpare_840":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_486:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_497:
        return self.rule.variation

class Item_228(Item):
    cv_arg: TypeAlias = NonSpare_840.cv_arg
    cv_non_spare: TypeAlias = NonSpare_840

    @classmethod
    def create(cls, arg : "Item_228.cv_arg") -> "Item_228":
        return cls._create(arg) # type: ignore

class Variation_1163(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_58.cv_arg, Tuple[Literal["QNH"], RuleVariation_58.cv_arg]], Union[RuleVariation_486.cv_arg, Tuple[Literal["CTBA"], RuleVariation_486.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1163.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_757, 1), (Item_228, 15)]
    cv_items_dict = {"QNH": RuleVariation_58, "CTBA": RuleVariation_486}

    @overload
    @classmethod
    def spec(cls, key : Literal["QNH"]) -> RuleVariation_58:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CTBA"]) -> RuleVariation_486:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["QNH"], Literal["CTBA"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["QNH"]) -> RuleVariation_58:
        ...
    @overload
    def get_item(self, key : Literal["CTBA"]) -> RuleVariation_486:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1163.cv_arg") -> 'Variation_1163':
        return cls._create(arg) # type: ignore

class RuleVariation_1114(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1163.cv_arg
    cv_variation: TypeAlias = Variation_1163

    @classmethod
    def create(cls, arg : "RuleVariation_1114.cv_arg") -> "RuleVariation_1114":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1163:
        return self.arg # type: ignore

class NonSpare_261(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1114.cv_arg
    cv_name = "093"
    cv_title = "Calculated Track Barometric Altitude"
    cv_rule: TypeAlias = RuleVariation_1114

    @classmethod
    def create(cls, arg : "NonSpare_261.cv_arg") -> "NonSpare_261":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1114:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1163:
        return self.rule.variation

class UapItem_261(UapItem):
    cv_non_spare: TypeAlias = NonSpare_261

class Content_684(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["ft"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 6.25
    cv_unit = "ft"

    def as_quantity(self, cv_unit : Optional[Literal["ft"]] = None) -> float:
        return self._as_quantity()

class RuleContent_684(RuleContentContextFree):
    cv_arg: TypeAlias = Content_684.cv_arg
    cv_content: TypeAlias = Content_684

    @property
    def content(self) -> Content_684:
        return self._get_content() # type: ignore

class Variation_290(Element):
    cv_arg: TypeAlias = RuleContent_684.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_684

    @classmethod
    def create(cls, arg: "Variation_290.cv_arg") -> "Variation_290":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_684:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_684:
        return self.rule.content

class RuleVariation_283(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_290.cv_arg
    cv_variation: TypeAlias = Variation_290

    @classmethod
    def create(cls, arg : "RuleVariation_283.cv_arg") -> "RuleVariation_283":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_290:
        return self.arg # type: ignore

class NonSpare_258(NonSpare):
    cv_arg: TypeAlias = RuleVariation_283.cv_arg
    cv_name = "092"
    cv_title = "Calculated Track Geometric Altitude"
    cv_rule: TypeAlias = RuleVariation_283

    @classmethod
    def create(cls, arg : "NonSpare_258.cv_arg") -> "NonSpare_258":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_283:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_290:
        return self.rule.variation

class UapItem_258(UapItem):
    cv_non_spare: TypeAlias = NonSpare_258

class Content_686(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["ft/min"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 6.25
    cv_unit = "ft/min"

    def as_quantity(self, cv_unit : Optional[Literal["ft/min"]] = None) -> float:
        return self._as_quantity()

class RuleContent_686(RuleContentContextFree):
    cv_arg: TypeAlias = Content_686.cv_arg
    cv_content: TypeAlias = Content_686

    @property
    def content(self) -> Content_686:
        return self._get_content() # type: ignore

class Variation_292(Element):
    cv_arg: TypeAlias = RuleContent_686.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_686

    @classmethod
    def create(cls, arg: "Variation_292.cv_arg") -> "Variation_292":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_686:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_686:
        return self.rule.content

class RuleVariation_285(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_292.cv_arg
    cv_variation: TypeAlias = Variation_292

    @classmethod
    def create(cls, arg : "RuleVariation_285.cv_arg") -> "RuleVariation_285":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_292:
        return self.arg # type: ignore

class NonSpare_413(NonSpare):
    cv_arg: TypeAlias = RuleVariation_285.cv_arg
    cv_name = "215"
    cv_title = "Calculated Rate Of Climb/Descent"
    cv_rule: TypeAlias = RuleVariation_285

    @classmethod
    def create(cls, arg : "NonSpare_413.cv_arg") -> "NonSpare_413":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_285:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_292:
        return self.rule.variation

class UapItem_413(UapItem):
    cv_non_spare: TypeAlias = NonSpare_413

class NonSpare_459(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1278.cv_arg
    cv_name = "270"
    cv_title = "Target Size and Orientation"
    cv_rule: TypeAlias = RuleVariation_1278

    @classmethod
    def create(cls, arg : "NonSpare_459.cv_arg") -> "NonSpare_459":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1278:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1356:
        return self.rule.variation

class UapItem_459(UapItem):
    cv_non_spare: TypeAlias = NonSpare_459

class NonSpare_1700(NonSpare):
    cv_arg: TypeAlias = RuleVariation_158.cv_arg
    cv_name = "SIC"
    cv_title = "System Identity Code"
    cv_rule: TypeAlias = RuleVariation_158

    @classmethod
    def create(cls, arg : "NonSpare_1700.cv_arg") -> "NonSpare_1700":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_158:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_164:
        return self.rule.variation

class Item_883(Item):
    cv_arg: TypeAlias = NonSpare_1700.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1700

    @classmethod
    def create(cls, arg : "Item_883.cv_arg") -> "Item_883":
        return cls._create(arg) # type: ignore

class Variation_1190(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_158.cv_arg, Tuple[Literal["SAC"], RuleVariation_158.cv_arg]], Union[RuleVariation_158.cv_arg, Tuple[Literal["SIC"], RuleVariation_158.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1190.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_851, 8), (Item_883, 8)]
    cv_items_dict = {"SAC": RuleVariation_158, "SIC": RuleVariation_158}

    @overload
    @classmethod
    def spec(cls, key : Literal["SAC"]) -> RuleVariation_158:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SIC"]) -> RuleVariation_158:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["SAC"], Literal["SIC"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["SAC"]) -> RuleVariation_158:
        ...
    @overload
    def get_item(self, key : Literal["SIC"]) -> RuleVariation_158:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1190.cv_arg") -> 'Variation_1190':
        return cls._create(arg) # type: ignore

class RuleVariation_1136(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1190.cv_arg
    cv_variation: TypeAlias = Variation_1190

    @classmethod
    def create(cls, arg : "RuleVariation_1136.cv_arg") -> "RuleVariation_1136":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1190:
        return self.arg # type: ignore

class NonSpare_982(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1136.cv_arg
    cv_name = "FPPSID"
    cv_title = "FPPS Identification Tag"
    cv_rule: TypeAlias = RuleVariation_1136

    @classmethod
    def create(cls, arg : "NonSpare_982.cv_arg") -> "NonSpare_982":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1136:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1190:
        return self.rule.variation

class NonSpare_827(NonSpare):
    cv_arg: TypeAlias = RuleVariation_383.cv_arg
    cv_name = "CSN"
    cv_title = "Callsign"
    cv_rule: TypeAlias = RuleVariation_383

    @classmethod
    def create(cls, arg : "NonSpare_827.cv_arg") -> "NonSpare_827":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_391:
        return self.rule.variation

class Content_425(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Plan number", 1: "Unit 1 internal flight number", 2: "Unit 2 internal flight number", 3: "Unit 3 internal flight number"}

class RuleContent_425(RuleContentContextFree):
    cv_arg: TypeAlias = Content_425.cv_arg
    cv_content: TypeAlias = Content_425

    @property
    def content(self) -> Content_425:
        return self._get_content() # type: ignore

class Variation_111(Element):
    cv_arg: TypeAlias = RuleContent_425.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 2
    cv_rule = RuleContent_425

    @classmethod
    def create(cls, arg: "Variation_111.cv_arg") -> "Variation_111":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_425:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_425:
        return self.rule.content

class RuleVariation_111(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_111.cv_arg
    cv_variation: TypeAlias = Variation_111

    @classmethod
    def create(cls, arg : "RuleVariation_111.cv_arg") -> "RuleVariation_111":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_111:
        return self.arg # type: ignore

class NonSpare_1954(NonSpare):
    cv_arg: TypeAlias = RuleVariation_111.cv_arg
    cv_name = "TYP"
    cv_title = "IFPS Flight ID Type"
    cv_rule: TypeAlias = RuleVariation_111

    @classmethod
    def create(cls, arg : "NonSpare_1954.cv_arg") -> "NonSpare_1954":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_111:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_111:
        return self.rule.variation

class Item_1073(Item):
    cv_arg: TypeAlias = NonSpare_1954.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1954

    @classmethod
    def create(cls, arg : "Item_1073.cv_arg") -> "Item_1073":
        return cls._create(arg) # type: ignore

class Item_13(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 2
    cv_bit_size = 3

class Variation_893(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 27
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_893.cv_arg") -> "Variation_893":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_863(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_893.cv_arg
    cv_variation: TypeAlias = Variation_893

    @classmethod
    def create(cls, arg : "RuleVariation_863.cv_arg") -> "RuleVariation_863":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_893:
        return self.arg # type: ignore

class NonSpare_1343(NonSpare):
    cv_arg: TypeAlias = RuleVariation_863.cv_arg
    cv_name = "NBR"
    cv_title = "IFPS Flight ID Number"
    cv_rule: TypeAlias = RuleVariation_863

    @classmethod
    def create(cls, arg : "NonSpare_1343.cv_arg") -> "NonSpare_1343":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_863:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_893:
        return self.rule.variation

class Item_609(Item):
    cv_arg: TypeAlias = NonSpare_1343.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1343

    @classmethod
    def create(cls, arg : "Item_609.cv_arg") -> "Item_609":
        return cls._create(arg) # type: ignore

class Variation_1231(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_111.cv_arg, Tuple[Literal["TYP"], RuleVariation_111.cv_arg]], int, Union[RuleVariation_863.cv_arg, Tuple[Literal["NB