"""
SFCTOOLS - An SFC-ABM Toolbox
=============================

Author: Thomas Baldauf  
Contact: thomas.baldauf@dlr.de  
Date: November 2021  
Organization: German Aerospace Center  
License: MIT  

Package Contents:  

- `sfctools.core` - Core Features  
- `sfctools.datastructs` & `sfctools.sfc_structs` - Data Structures  
- `sfctools.automation` - Automation & Parameter I/O  
- `sfctoools.bottomup` - Bottom-Up Features  
- `sfctools.misc` - Miscellaneous Utilities  
- `sfctools.gui` - Graphical User Interface  
"""

"""
CORE FEATURES
"""

from .core.agent import block_on_bankrupt
from .datastructs.income_statement import IncomeStatement, ICSEntry
from .core.agent import Agent, SingletonAgent
from .core.singleton import Singleton
from .core.clock import Clock
from .core.settings import Settings
from .core.world import World

from .core.flow_matrix import FlowMatrix 
from .core.flow_matrix import Accounts
from .core.balance_matrix import BalanceMatrix
from .core.flow_matrix import FlowMatrix as TFM
from .core.balance_matrix import BalanceMatrix as BSM


from sfctools.sfc_structs.sfc_structs import SfcArrayBalanceMatrix
from .datastructs.balance import BalanceSheet, BalanceEntry
from .datastructs.cash_flow_statement import CashFlowStatement, CashFlowEntry
from .datastructs.bank_order_book import BankOrderBook
from .datastructs.inventory import Inventory
from .datastructs.market_registry import MarketRegistry
from .datastructs.worker_registry import WorkerRegistry
from .automation.runner import ModelRunner
from .bottomup.priceman import PriceManager
from .bottomup.matching import MarketMatching
from .misc.reporting_sheet import ReportingSheet, DistributionReport, IndicatorReport
from .datastructs.signalslot import Signal, Slot, SignalSlot
from sfctools.api.bimets import Equations


"""
DATA STRUCTURES
"""


AST = BalanceEntry.ASSETS  # < abbreviations of BalanceEntry
LIA = BalanceEntry.LIABILITIES
EQT = BalanceEntry.EQUITY


"""
AUTOMATION AND PARAMETER-IO
"""
# from .automation.calibration import CalibrationRoutine, DistanceMeasure # <- experimental thus commented out

"""
BOTTOM-UP FEATURES
"""

# from .bottomup.productiontree import ProductionTree # <- experimental thus commented out


"""
ANALYTICAL FUNCTIONS
"""
# ...

"""
MISCELLANEOUS
"""

# from .misc.timeseries import stretch_pandas, stretch_datetime, convert_quarterly_to_datetime, stretch_to_length, convert_numeric
# from .misc.mpl_plotting import matplotlib_barplot,matplotlib_lineplot, plot_sankey

from .misc.utils import gen_class

"""
GUI
"""
# from . import gui

"""
MACHINE LEARNING AND DATA MODELS
"""
# from .ml_models import *
