

def gen_dummies(name, n: int):
    """
    generate some dummy class and n dummy agents from this class

    name (str): name of the dummy class
    n (int): number of dummies to crease

    Returns:
        class, list_of_agents
    """
    def init(self, *args, **kwargs):
        super(cls, self).__init__(*args, **kwargs)

    from sfctools.core.agent import Agent
    cls = type(name, (Agent,), {'__init__': init, '__new__': Agent.__new__})

    return cls, [cls() for i in range(n)]
