import os 
import json 
import warnings 
from pathlib import Path


"""
sfctools Configurations 

this can store fixed configurations and settings of the module
"""

def write_config(key, val):

    script_dir = os.path.dirname(os.path.abspath(__file__))
    CONFIG_PATH = os.path.join(script_dir, "config.json")
    # CONFIG_PATH = os.path.join(Path.home(), ".config", "sfctools", "config.json")

    print(f"[sfctools] writing [{key}] -> [{val}] to config path:", CONFIG_PATH)

    config = {} 
    if os.path.exists(CONFIG_PATH):
        try:
            with open(CONFIG_PATH, 'r') as f:
                config = json.load(f)
        except:
            warnings.warn("No config or corrupted config found.")
    config[key] = val
    with open(CONFIG_PATH, 'w') as f:
        json.dump(config, f)

def read_config(key, verbose=False):

    script_dir = os.path.dirname(os.path.abspath(__file__))
    CONFIG_PATH = os.path.join(script_dir, "config.json")
    
    if verbose: 
        print(f"[sfctools] reading [{key}] from {CONFIG_PATH}")
    try:
        if os.path.exists(CONFIG_PATH):
            with open(CONFIG_PATH, 'r') as f:
                config = json.load(f)
                return config[key]
    except:
        return None 

