

write_coeffs <- function(model){

  df_all_coeffs = data.frame(eq = character(
      0), coeff = numeric(0), pval = numeric(0))
  df_all_stats = data.frame('Durbin-Watson' = numeric(0), 'Adj. R-Squared' = numeric(0), 'Est. Technique' = character(0))

  for (name in model$vendogBehaviorals){

    var <- get(name, model$behaviorals)
    df0 <- data.frame(rep(name, length(var$coefficients)))
    df1 <- data.frame(var$coefficients)
    df2 <- data.frame(var$statistics$CoeffPvalues)
    # model$behaviorals$log_omega$coefficients
    # print(df1)
    # print(df2)

    df_coeffs <- cbind(df0, df1, df2)
    # print(df_coeffs)
    colnames(df_coeffs) <- c("eq", "coeff", "pval")
    df_all_coeffs <- rbind(df_all_coeffs, df_coeffs)

    stats <- c(var$statistics$DurbinWatson,
                   var$statistics$AdjustedRSquared,
                   var$statistics$estimationTechnique)
    df_stats <- t(data.frame(stats))
    rownames(df_stats) <- c(name)
    colnames(df_stats) <- c("Durbin-Watson",
             "Adj. R-Squared", "Est. Technique")
    # print(df_stats)

    df_all_stats <- rbind(df_all_stats, df_stats)

    # write.xlsx(df_stats, "df_behavioral_log_omega.xlsx")

    eq <- var$eq
    # print(eq)
  }

  write.xlsx(df_all_coeffs, "df_coeffs.xlsx", rowNames=TRUE)
  write.xlsx(df_all_stats, "df_stats.xlsx", rowNames=TRUE)
}
