
library(mFilter)
library(bimets)
library(knitr)
library("readxl")
library(patchwork)
library(tidyr)
library("readr")
library(ggplot2)
library(ggthemes)
library(scales)
library(zoo)
require(gridExtra)

tser <- function(xx){
return(TIMESERIES(xx, START=c(1920,1),FREQ=1))
}

lag <- function(xx){
    return(c(NA, head(xx, -1)))
}

prepare_data <- function(){
    fname <- 'C:/Users/bald_to/Documents/framework_dev/framework_dev/sfctools/examples/bimets/klein/data/klein_data.xlsx'
    myCols <- as.character(read_excel(fname, n_max = 1, col_names = FALSE))
    df <- read_excel(fname,skip=1,col_names=myCols)
    

    My_modelData = list(
		Year = tser(df$Year),
		cn = tser(df$cn),
		g = tser(df$g),
		i = tser(df$i),
		k = tser(df$k),
		p = tser(df$p),
		w1 = tser(df$w1),
		y = tser(df$y),
		t = tser(df$t),
		time = tser(df$time),
		w2 = tser(df$w2))

    return(My_modelData);
}
    