"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const construct_1 = require("../lib/construct");
const util_1 = require("./util");
class MyConstruct extends construct_1.Construct {
    constructor() {
        super(...arguments);
        this.visitCounter = 0;
    }
    static IsMyConstruct(x) {
        return x.visitCounter !== undefined;
    }
}
class VisitOnce {
    visit(node) {
        if (MyConstruct.IsMyConstruct(node)) {
            node.visitCounter += 1;
        }
    }
}
test('Aspects are invoked only once', () => {
    const app = new util_1.App();
    const root = new MyConstruct(app, 'MyConstruct');
    const node = construct_1.Node.of(root);
    node.applyAspect(new VisitOnce());
    node.prepare();
    expect(root.visitCounter).toBe(1);
    node.prepare();
    expect(root.visitCounter).toBe(1);
});
//# sourceMappingURL=data:application/json;base64,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