"use strict";
/**
 * Simple function to evaluate CloudFormation intrinsics.
 *
 * Note that this function is not production quality, it exists to support tests.
 */
Object.defineProperty(exports, "__esModule", { value: true });
function evaluateCFN(object, context = {}) {
    const intrinsics = {
        'Fn::Join'(separator, args) {
            return args.map(evaluate).join(separator);
        },
        'Ref'(logicalId) {
            if (!(logicalId in context)) {
                throw new Error(`Trying to evaluate Ref of '${logicalId}' but not in context!`);
            }
            return context[logicalId];
        },
        'Fn::GetAtt'(logicalId, attributeName) {
            const key = `${logicalId}.${attributeName}`;
            if (!(key in context)) {
                throw new Error(`Trying to evaluate Fn::GetAtt of '${logicalId}.${attributeName}' but not in context!`);
            }
            return context[key];
        }
    };
    return evaluate(object);
    function evaluate(obj) {
        if (Array.isArray(obj)) {
            return obj.map(evaluate);
        }
        if (typeof obj === 'object') {
            const keys = Object.keys(obj);
            if (keys.length === 1 && (isNameOfCloudFormationIntrinsic(keys[0]) || keys[0] === 'Ref')) {
                return evaluateIntrinsic(keys[0], obj[keys[0]]);
            }
            const ret = {};
            for (const key of keys) {
                ret[key] = evaluateCFN(obj[key]);
            }
            return ret;
        }
        return obj;
    }
    function evaluateIntrinsic(name, args) {
        if (!(name in intrinsics)) {
            throw new Error(`Intrinsic ${name} not supported here`);
        }
        if (!Array.isArray(args)) {
            args = [args];
        }
        return intrinsics[name].apply(intrinsics, args);
    }
}
exports.evaluateCFN = evaluateCFN;
function isNameOfCloudFormationIntrinsic(name) {
    if (!name.startsWith('Fn::')) {
        return false;
    }
    // these are 'fake' intrinsics, only usable inside the parameter overrides of a CFN CodePipeline Action
    return name !== 'Fn::GetArtifactAtt' && name !== 'Fn::GetParam';
}
//# sourceMappingURL=data:application/json;base64,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