from setuptools import setup, find_packages

setup(
    name="pyrestcountries",
    version="2024.05.03",
    description="Pythonic wrapper around data served by restcountries API",
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    author="Gopala Krishna Koduri",
    author_email="gopal@riyazapp.com",
    url="https://github.com/musicmuni/pyrestcountries",
    packages=find_packages(),
    include_package_data=True,
    install_requires=["requests", "appdirs", "diskcache", "thefuzz"],
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Build Tools",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
    ],
    python_requires=">=3.7",
    project_urls={
        "Documentation": "https://github.com/musicmuni/pyrestcountries",
        "Source": "https://github.com/musicmuni/pyrestcountries",
        "Tracker": "https://github.com/musicmuni/pyrestcountries/issues",
        "Connect w/ Author": "https://linkedin.com/in/gopalkoduri",
        "Riyaz - Learn to sing": "https://riyazapp.com",
    },
)
