"""Exports all data types from the .base module for easy access."""

from __future__ import annotations

from tidy3d.components.types.base import (
    TYPE_TAG_STR,
    ArrayComplex1D,
    ArrayComplex2D,
    ArrayComplex3D,
    ArrayComplex4D,
    ArrayFloat1D,
    ArrayFloat2D,
    ArrayFloat3D,
    ArrayFloat4D,
    ArrayInt1D,
    ArrayLike,
    AuxField,
    Ax,
    Axis,
    Axis2D,
    Bound,
    BoxSurface,
    ClipOperationType,
    ColormapType,
    Complex,
    ComplexNumber,
    Coordinate,
    Coordinate2D,
    CoordinateOptional,
    Direction,
    EMField,
    EpsSpecType,
    FieldType,
    FieldVal,
    FreqArray,
    FreqBound,
    FreqBoundMax,
    FreqBoundMin,
    GridSize,
    InterpMethod,
    LengthUnit,
    LumpDistType,
    MatrixReal4x4,
    ModeSolverType,
    Numpy,
    ObsGridArray,
    PermittivityComponent,
    PlanePosition,
    PlotScale,
    PlotVal,
    Polarization,
    PolarizationBasis,
    PoleAndResidue,
    PriorityMode,
    RealFieldVal,
    ScalarSymmetry,
    Shapely,
    Size,
    Size1D,
    Symmetry,
    TensorReal,
    TrackFreq,
    Undefined,
    UnitsZBF,
    annotate_type,
    constrained_array,
    tidycomplex,
    xyz,
)
from tidy3d.components.types.third_party import TrimeshType
from tidy3d.components.types.utils import _add_schema

__all__ = [
    "TYPE_TAG_STR",
    "ArrayComplex1D",
    "ArrayComplex2D",
    "ArrayComplex3D",
    "ArrayComplex4D",
    "ArrayFloat1D",
    "ArrayFloat2D",
    "ArrayFloat3D",
    "ArrayFloat4D",
    "ArrayInt1D",
    "ArrayLike",
    "AuxField",
    "Ax",
    "Axis",
    "Axis2D",
    "Bound",
    "BoxSurface",
    "ClipOperationType",
    "ColormapType",
    "Complex",
    "ComplexNumber",
    "Coordinate",
    "Coordinate2D",
    "CoordinateOptional",
    "Direction",
    "EMField",
    "EpsSpecType",
    "FieldType",
    "FieldVal",
    "FreqArray",
    "FreqBound",
    "FreqBoundMax",
    "FreqBoundMin",
    "GridSize",
    "InterpMethod",
    "LengthUnit",
    "LumpDistType",
    "MatrixReal4x4",
    "ModeSolverType",
    "Numpy",
    "ObsGridArray",
    "PermittivityComponent",
    "PlanePosition",
    "PlotScale",
    "PlotVal",
    "Polarization",
    "PolarizationBasis",
    "PoleAndResidue",
    "PriorityMode",
    "RealFieldVal",
    "ScalarSymmetry",
    "Shapely",
    "Size",
    "Size1D",
    "Symmetry",
    "TensorReal",
    "TrackFreq",
    "TrimeshType",
    "Undefined",
    "UnitsZBF",
    "_add_schema",
    "annotate_type",
    "constrained_array",
    "tidycomplex",
    "xyz",
]
