# Generated by Django 4.2.7 on 2023-11-28 19:39

import _socket
from django.db import migrations, models
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("sites", "0002_alter_domain_unique"),
    ]

    operations = [
        migrations.CreateModel(
            name="Issue",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device created"
                    ),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("session_id", models.UUIDField(null=True)),
                ("session_datetime", models.DateTimeField(null=True)),
                ("label_lower", models.CharField(max_length=150)),
                ("verbose_name", models.CharField(max_length=150)),
                ("subject_identifier", models.CharField(max_length=150)),
                ("visit_code", models.CharField(max_length=150)),
                ("visit_code_sequence", models.CharField(max_length=150)),
                ("field_name", models.CharField(max_length=150)),
                ("raw_message", models.TextField(null=True)),
                ("message", models.TextField(null=True)),
                ("short_message", models.CharField(max_length=250, null=True)),
                ("response", models.CharField(max_length=250, null=True)),
                ("src_id", models.UUIDField(null=True)),
                ("src_revision", models.CharField(max_length=150, null=True)),
                ("src_report_datetime", models.DateTimeField(null=True)),
                ("src_modified_datetime", models.DateTimeField(null=True)),
                ("src_user_modified", models.CharField(max_length=150, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("New", "New"),
                            ("in_progress", "In progress"),
                            ("done", "Done"),
                        ],
                        default="New",
                        max_length=15,
                    ),
                ),
                ("extra_formfields", models.TextField(null=True)),
                ("ignore_formfields", models.TextField(null=True)),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="sites.site"
                    ),
                ),
            ],
            options={
                "verbose_name": "Issue",
                "verbose_name_plural": "Issues",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
                "indexes": [
                    models.Index(
                        fields=["label_lower", "field_name", "short_message"],
                        name="edc_form_ru_label_l_ce3dda_idx",
                    ),
                    models.Index(
                        fields=[
                            "subject_identifier",
                            "visit_code",
                            "visit_code_sequence",
                            "short_message",
                        ],
                        name="edc_form_ru_subject_10bb16_idx",
                    ),
                ],
            },
        ),
        migrations.AddConstraint(
            model_name="issue",
            constraint=models.UniqueConstraint(
                fields=(
                    "label_lower",
                    "subject_identifier",
                    "field_name",
                    "visit_code",
                    "visit_code_sequence",
                ),
                name="unique_label_lower_subject_identifier_etc",
            ),
        ),
    ]
