# Generated by Django 6.0 on 2025-03-12 11:33

from django.db import migrations
from tqdm import tqdm

from ..models import (
    Allocation,
    Dispense,
    DispenseItem,
    StockTransferItem,
    StorageBin,
    StorageBinItem,
)


def update_site_id(apps, schema_editor):

    stock_transfer_confirmation = apps.get_model(
        "edc_pharmacy", "StockTransferConfirmation"
    )
    stock_transfer_confirmation_item = apps.get_model(
        "edc_pharmacy", "StockTransferConfirmationItem"
    )
    for model_cls in [
        Allocation,
        stock_transfer_confirmation,
        stock_transfer_confirmation_item,
        StorageBin,
        StorageBinItem,
        Dispense,
        DispenseItem,
    ]:
        total = model_cls.objects.count()
        for obj in tqdm(model_cls.objects.all(), total=total):
            obj.save(update_fields=("site",))

    for obj in tqdm(Allocation.objects.all(), total=Allocation.objects.count()):
        stock = obj.stock
        stock.allocated = True
        stock.save(update_fields=("allocated",))

    for obj in tqdm(
        StockTransferItem.objects.all(), total=StockTransferItem.objects.count()
    ):
        stock = obj.stock
        stock.transferred = True
        stock.save(update_fields=("transferred",))


class Migration(migrations.Migration):

    dependencies = [
        (
            "edc_pharmacy",
            "0061_alter_historicalstocktransferconfirmation_options_and_more",
        ),
    ]

    operations = [migrations.RunPython(update_site_id)]
