---
title: Get started with Jupyter Book
subtitle: Learn how to navigate this documentation and build your first book.
---

Jupyter Book is [a distribution of the MyST Document Engine](https://mystmd.org).

:::{seealso} Looking for the Jupyter Book 1 docs?
This documentation is for Jupyter Book 2. If you're looking for the Jupyter Book 1 docs, go to [jupyterbook.org](https://jupyterbook.org).
:::

## See `mystmd.org` for more complete documentation

Because Jupyter Book is [a distribution of the MyST Document Engine](./about/ecosystem.md), we keep most documentation about configuring and using Jupyter Book in the [MyST User Guide](https://mystmd.org/guide). Anything you can do with MyST you can do with Jupyter Book - the only difference in using the two is the CLI verb (`jupyter book` vs. `myst`).

We know this can be confusing! Jupyter Book [pre-dates the MyST Document Engine](./about/history.md) and we're still working out the best way to maintain both of them as parallel efforts.

## Navigate the Jupyter Book documentation

This User Guide steps you through **high-level concepts**, **tutorials for step-by-step learning**, and **how-to guides to get things done**. It focuses on use-cases for multi-document projects, like **community knowledge bases** and **multi-page books**.[^diataxis]

[^diataxis]: The Jupyter Book and MyST documentation follow [the Diataxis documentation framework](https://diataxis.fr). Within that framework, we aim for jupyterbook.org to contain **tutorials** and **how-to guides**, and the [MyST guide](xref:guide) to focus on **reference documentation** and **deeper explanation**.


::::{grid} 1 2 2 2
:::{card} Get started 🆕
:link: /start/install
:footer: Get started with Jupyter Book »

The **Get Started** guide covers basic steps to learn the basics of using Jupyter Book.
:::
:::{card} Tutorials 🎓
:link: /tutorial/website
:footer: See the first tutorial »

The **Tutorials** cover key workflows and concepts in more depth.
:::
:::{card} How To Guides 💡
:link: /author/roles-and-directives
:footer: See the how-to page »

The **Tutorials** cover key workflows and concepts in more depth.
:::
:::{card} Reference ℹ️
:link: https://mystmd.org/guide
:footer: Go to the MyST Guide »

The MyST Guide is the **reference** for the full-suite of features provided by the MyST Document Engine that powers Jupyter Book.
:::
::::
